/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.lib.jnm.SwitchVersion;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.common.model.AbstractSwitchBase;
import com.cisco.dcbu.sm.common.model.Card;
import com.cisco.dcbu.sm.common.model.ClusterInterfBase;
import com.cisco.dcbu.sm.common.model.EndPortBase;
import com.cisco.dcbu.sm.common.model.FabricBase;
import com.cisco.dcbu.sm.common.model.FcPortBase;
import com.cisco.dcbu.sm.common.model.LicenseInfo;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.model.ZoneMemberBase;
import com.cisco.dcbu.sm.common.model.ioa.Cluster;
import com.cisco.dcbu.sm.common.model.ioa.EndDevice;
import com.cisco.dcbu.sm.common.model.ioa.Flow;
import com.cisco.dcbu.sm.common.model.ioa.FlowCandidateSet;
import com.cisco.dcbu.sm.common.model.ioa.IOAInterface;
import com.cisco.dcbu.sm.common.model.ioa.InterfaceStats;
import com.cisco.dcbu.sm.common.model.ioa.IvrEndPort;
import com.cisco.dcbu.sm.common.model.ioa.Site;
import com.cisco.dcbu.sm.common.model.ioa.Switch;
import com.cisco.dcbu.sm.common.rif.IOARif;
import com.cisco.dcbu.sm.common.rif.SessionRif;
import com.cisco.dcbu.sm.common.type.ClusterPK;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.discovery.SnmpAdapter;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.ioa.comm.IOAXmlHandler;
import com.cisco.dcbu.sm.server.ioa.common.IOAContext;
import com.cisco.dcbu.sm.server.ioa.common.IOAHelper;
import com.cisco.dcbu.sm.server.ioa.common.Limits;
import com.cisco.dcbu.sm.server.ioa.exception.IOAException;
import com.cisco.dcbu.sm.server.ioa.exception.IOAInvalidMessageException;
import com.cisco.dcbu.sm.server.ioa.exception.IOAProcessingException;
import com.cisco.dcbu.sm.server.ioa.exception.IOASwitchCommunicationException;
import com.cisco.dcbu.sm.server.ioa.message.ClusterMessage;
import com.cisco.dcbu.sm.server.ioa.message.FlowMessage;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterInterfaceObject;
import com.cisco.dcbu.sm.server.ioa.xml.ClusterNodeObject;
import com.cisco.dcbu.sm.server.ioa.xml.IOAFlowObject;
import com.cisco.dcbu.sm.server.ioa.xml.IOAInterfaceObject;
import com.cisco.dcbu.sm.server.ioa.xml.IOAMessage;
import com.cisco.dcbu.sm.server.ioa.xml.IOAOpcodeEnum;
import com.cisco.dcbu.sm.server.ioa.xml.ITNexusStatusEnum;
import com.cisco.dcbu.sm.server.ioa.xml.InterfaceStatistics;
import com.cisco.dcbu.sm.server.ioa.xml.InterfaceStatusEnum;
import com.cisco.dcbu.sm.server.ioa.xml.InterfaceStatusReasonEnum;
import com.cisco.dcbu.sm.server.ioa.xml.OperationEnum;
import com.cisco.dcbu.sm.server.ioa.xml.Path;
import com.cisco.dcbu.sm.server.model.ClusterImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import com.cisco.dcbu.sm.server.zone.ZoneService;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class IOAImpl
implements IOARif,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int IOA_TYPE = 33;
    private static final int IOA_IFINDEX = 0x21000000;
    private static final int MAX_TRAP_ENTRIES = 10;
    private SanManager _sanManager = SanManager.getInstance();
    transient Logger _Logger = null;
    private SessionRif _session;
    private FMUser _user;

    @Override
    public void init(SessionRif session) throws RemoteException {
        this._Logger = LogManager.getLogger((String)"IOA_SRV");
        if (this._session == null) {
            this._session = session;
        }
        if (this._user == null) {
            this._user = this._session.getUser();
        }
    }

    @Override
    public ArrayList<FabricPK> getFabrics() throws RemoteException {
        ArrayList<FabricPK> fabricList = new ArrayList<FabricPK>();
        FabricPK[] fabrics = null;
        try {
            fabrics = this._sanManager.getFabricPKs();
            if (fabrics == null) {
                return fabricList;
            }
        }
        catch (Exception ex) {
            String logMsg = "An unrecoverable error has occurred, please relaunch IOA Manager and try again";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg, ex);
        }
        for (int i = 0; i < fabrics.length; ++i) {
            fabricList.add(fabrics[i]);
        }
        return fabricList;
    }

    @Override
    public ArrayList<Site> getSiteList(FabricPK pk) throws RemoteException {
        ArrayList<Site> siteList = new ArrayList<Site>();
        FabricImpl fabricImpl = this._sanManager.findFabric(pk);
        if (fabricImpl == null) {
            return siteList;
        }
        SwitchImpl[] switchImplList = fabricImpl.getSwitches();
        if (switchImplList == null) {
            return siteList;
        }
        for (int i = 0; i < switchImplList.length; ++i) {
            SwitchImpl swImpl = switchImplList[i];
            if (!swImpl.isMDS()) continue;
            SwitchBase swBase = (SwitchBase)swImpl.getBaseObject();
            String sysLocation = swBase.getSysLocation();
            String ioaSiteName = null;
            try {
                if (swImpl.isFeatureEnabled(AbstractSwitchBase.Feature.IOA.flag())) {
                    ioaSiteName = this.getIOASite(pk, swImpl);
                }
                if (ioaSiteName != null && ioaSiteName.length() > 0 && !ioaSiteName.equals(sysLocation)) {
                    sysLocation = ioaSiteName;
                    try {
                        this.snmpChangeValue(swImpl, "sysLocation", ioaSiteName);
                        swImpl.setLocation(ioaSiteName);
                    }
                    catch (SnmpException e) {
                        this._Logger.error((Object)("Non-fatal error: Snmp-set failed for sysLocation on " + swImpl.getName()), (Throwable)e);
                    }
                }
            }
            catch (IOASwitchCommunicationException e) {
                this._Logger.error((Object)("Non-fatal error: Exception in getIOASite for " + swImpl.getName()), (Throwable)e);
            }
            if (sysLocation == null || sysLocation.length() <= 0) continue;
            Site site = null;
            for (Site x : siteList) {
                if (!x.getName().equals(sysLocation)) continue;
                site = x;
            }
            if (site == null) {
                site = new Site(sysLocation, null);
                siteList.add(site);
            }
            Switch s = new Switch(pk._fid, swBase.getSysName(), swBase.getWwn().toHexString(true));
            s.setIpAddress(swBase.getIpAddress());
            s.setVersion(swBase.getVersion());
            s.setSiteName(sysLocation);
            s.setLicenseList(this.getIOALicenses(swImpl));
            site.getMemberList().add(s);
        }
        return siteList;
    }

    private String getIOASite(FabricPK fabric, SwitchImpl swImpl) throws IOASwitchCommunicationException {
        SnmpUser snmpUser = this._user.getSnmpUser(fabric);
        if (snmpUser == null) {
            throw new IOASwitchCommunicationException("getIOASite: No login credential for fabic " + fabric);
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler("", swImpl.getIpAddress(), username, password);
        String msgOut = clusterMessage.prepareSiteGetReq("");
        String msgIn = null;
        try {
            msgIn = xmlHandler.sendReceive(msgOut);
        }
        catch (IOAException se) {
            throw new IOASwitchCommunicationException("Message send failed: " + se.getMessage());
        }
        if (msgIn == null) {
            throw new IOASwitchCommunicationException("Message send failed Unable to communicate with switch.");
        }
        IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
        try {
            if (!clusterMessage.analyzeResponse(message)) {
                throw new IOASwitchCommunicationException("Request failed: " + message.getMsg_Header().getResponse_Status_Desc());
            }
            if (message.getTable_Data() != null && message.getTable_Data().getSite_Get_Resp() != null && message.getTable_Data().getSite_Get_Resp().getSite() != null && message.getTable_Data().getSite_Get_Resp().getSite().getIndex() != null) {
                return message.getTable_Data().getSite_Get_Resp().getSite().getIndex().getSite_Name();
            }
        }
        catch (IOAInvalidMessageException se) {
            throw new IOASwitchCommunicationException("Failed to request the Site label on switch " + swImpl.getIpAddress() + ". Error: " + se.getMessage());
        }
        catch (IOAException se) {
            throw new IOASwitchCommunicationException("Failed to request the Site label on switch " + swImpl.getIpAddress() + ". Error: " + se.getMessage());
        }
        throw new IOASwitchCommunicationException("Failed to request the Site label on switch " + swImpl.getIpAddress() + " Unknown error");
    }

    private void deleteIOASite(FabricPK fabric, SwitchImpl swImpl) throws IOASwitchCommunicationException {
        SnmpUser snmpUser = this._user.getSnmpUser(fabric);
        if (snmpUser == null) {
            this._Logger.error((Object)("Remove ioa site-local failed: No login credential for fabic " + fabric));
            throw new IOASwitchCommunicationException("Remove ioa site-local failed: No login credential for fabic " + fabric);
        }
        if (!swImpl.isFeatureEnabled(AbstractSwitchBase.Feature.IOA.flag())) {
            return;
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler("", swImpl.getIpAddress(), username, password);
        SwitchBase base = (SwitchBase)swImpl.getBaseObject();
        String siteName = base.getSysLocation();
        String msgOut = clusterMessage.prepareSiteDeleteReq(siteName);
        String msgIn = null;
        try {
            msgIn = xmlHandler.sendReceive(msgOut);
        }
        catch (IOAException se) {
            this._Logger.error((Object)"Remove ioa site-local failed: Failed to send message to switch", (Throwable)se);
            throw new IOASwitchCommunicationException("Remove ioa site-local failed: " + se.getMessage());
        }
        if (msgIn == null) {
            this._Logger.error((Object)("Remove ioa site-local failed: Unable to communicate with switch " + swImpl.getIpAddress()));
            throw new IOASwitchCommunicationException("Remove ioa site-local failed: Unable to communicate with switch " + swImpl.getIpAddress());
        }
        IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
        try {
            if (!clusterMessage.analyzeResponse(message)) {
                this._Logger.error((Object)("Remove ioa site-local failed: Failed to send message to switch.  Error: " + message.getMsg_Header().getResponse_Status_Desc()));
                throw new IOASwitchCommunicationException("Remove ioa site-local failed: On " + swImpl.getIpAddress() + ". Error: " + message.getMsg_Header().getResponse_Status_Desc());
            }
            return;
        }
        catch (IOAInvalidMessageException se) {
            this._Logger.error((Object)"Remove ioa site-local failed", (Throwable)se);
            throw new IOASwitchCommunicationException("Remove ioa site-local failed: On " + swImpl.getIpAddress() + " " + se.getMessage());
        }
        catch (IOAException se) {
            this._Logger.error((Object)"Remove ioa site-local failed: Failed to send message to switch", (Throwable)se);
            throw new IOASwitchCommunicationException("Remove ioa site-local failed:  " + swImpl.getIpAddress() + ". Error: " + se.getMessage());
        }
    }

    @Override
    public ArrayList<Switch> getUnassignedSwitchList(FabricPK pk) throws RemoteException {
        ArrayList<Switch> switchList = new ArrayList<Switch>();
        FabricImpl fabricImpl = this._sanManager.findFabric(pk);
        if (fabricImpl == null) {
            return switchList;
        }
        SwitchImpl[] switchImplList = fabricImpl.getSwitches();
        if (switchImplList == null) {
            return switchList;
        }
        for (int i = 0; i < switchImplList.length; ++i) {
            SwitchBase swBase;
            String sysLocation;
            SwitchImpl swImpl = switchImplList[i];
            if (!swImpl.isMDS() || (sysLocation = (swBase = (SwitchBase)swImpl.getBaseObject()).getSysLocation()) != null && sysLocation.length() != 0) continue;
            Switch s = new Switch(pk._fid, swBase.getSysName(), swBase.getWwn().toHexString(true));
            s.setIpAddress(swBase.getIpAddress());
            s.setVersion(swBase.getVersion());
            switchList.add(s);
        }
        return switchList;
    }

    private Switch getSwitchByName(FabricPK pk, String name) throws IOAProcessingException {
        FabricImpl fabric = this._sanManager.findFabric(pk);
        if (fabric == null) {
            throw new IOAProcessingException("getSwitchByName: " + name + " failed, cannot find fabric by " + pk);
        }
        SwitchImpl[] switches = fabric.getSwitches();
        for (int i = 0; i < switches.length; ++i) {
            SwitchBase base;
            String swName;
            SwitchImpl sw = switches[i];
            if (!sw.isMDS() || (swName = (base = (SwitchBase)sw.getBaseObject()).getSysName()) == null || !swName.equals(name)) continue;
            Switch s = new Switch(pk._fid, swName, base.getWwn().toHexString(true));
            s.setIpAddress(base.getIpAddress());
            if (base.getSysLocation() != null) {
                s.setSiteName(base.getSysLocation());
            }
            s.setVersion(base.getVersion());
            return s;
        }
        throw new IOAProcessingException("getSwitchByName: " + name + " failed, not found");
    }

    private Switch getSwitchByIp(FabricPK pk, String ip) throws IOAProcessingException {
        FabricImpl fabric = this._sanManager.findFabric(pk);
        if (fabric == null) {
            throw new IOAProcessingException("getSwitchByIp: " + ip + " failed, fabric not found by " + pk);
        }
        SwitchImpl[] switches = fabric.getSwitches();
        for (int i = 0; i < switches.length; ++i) {
            SwitchImpl sw = switches[i];
            if (!sw.isMDS()) continue;
            SwitchBase base = (SwitchBase)sw.getBaseObject();
            String ipaddr = base.getIpAddress();
            if (ipaddr != null && ipaddr.charAt(0) == '/') {
                ipaddr = ipaddr.substring(1);
            }
            if (ipaddr == null || !ipaddr.equals(ip)) continue;
            Switch s = new Switch(pk._fid, base.getSysName(), base.getWwn().toHexString(true));
            s.setIpAddress(base.getIpAddress());
            if (base.getSysLocation() != null) {
                s.setSiteName(base.getSysLocation());
            }
            s.setVersion(base.getVersion());
            return s;
        }
        throw new IOAProcessingException("getSwitchByIp: " + ip + " failed, not found");
    }

    private SwitchImpl getSwitchImplByIp(FabricPK pk, String ip) throws IOAProcessingException {
        FabricImpl fabric = this._sanManager.findFabric(pk);
        if (fabric == null) {
            throw new IOAProcessingException("getSwitchImplByIp: " + ip + " failed, invalid fabric");
        }
        if (ip == null) {
            throw new IOAProcessingException("getSwitchImplByIp failed, null ip");
        }
        SwitchImpl[] switches = fabric.getSwitches();
        SwitchImpl swi = null;
        block0: for (int i = 0; i < switches.length; ++i) {
            SwitchImpl sw = switches[i];
            if (!sw.isMDS()) continue;
            String name = sw.getName();
            if (name != null && name.equals(ip)) {
                swi = sw;
                break;
            }
            InetAddress[] ips = sw.getManagementAddresses();
            if (ips == null || ips.length <= 0) continue;
            for (int j = 0; j < ips.length; ++j) {
                if (ips[j] == null || !ips[j].toString().equals("/" + ip)) continue;
                swi = sw;
                continue block0;
            }
        }
        if (swi == null) {
            throw new IOAProcessingException("getSwitchImplByIp failed, no switch found in model for IP address " + ip);
        }
        return swi;
    }

    @Override
    public void addSwitchToSite(FabricPK pk, Switch sw, String siteName) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pk);
        if (fabric == null) {
            throw new RemoteException("addSwitchToSite: " + sw + " failed, fabric not found by " + pk);
        }
        SwitchImpl[] switches = fabric.getSwitches();
        if ((long)pk._fid != sw.getFabricId()) {
            throw new RemoteException("Given FabricId does not match switch FabricId");
        }
        for (int i = 0; i < switches.length; ++i) {
            SwitchBase base;
            SwitchImpl si = switches[i];
            if (!si.isMDS() || !(base = (SwitchBase)si.getBaseObject()).getSysName().equals(sw.getName()) || !si.getWwn().toHexString(true).equals(sw.getWwn())) continue;
            try {
                this.snmpChangeValue(si, "sysLocation", siteName);
            }
            catch (SnmpException e) {
                String logMsg = "Unable to set site name on switch";
                this._Logger.error((Object)logMsg, (Throwable)e);
                throw new RemoteException(logMsg);
            }
            si.setLocation(siteName);
        }
    }

    @Override
    public void removeSwitchFromSite(FabricPK pk, Switch sw) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(pk);
        if (fabric == null) {
            return;
        }
        SwitchImpl[] switches = fabric.getSwitches();
        if ((long)pk._fid != sw.getFabricId()) {
            throw new RemoteException("Given FabricId does not match Switches FabricId");
        }
        for (int i = 0; i < switches.length; ++i) {
            SwitchImpl si = switches[i];
            SwitchBase base = (SwitchBase)si.getBaseObject();
            if (!base.getSysName().equals(sw.getName()) || !si.getWwn().toHexString(true).equals(sw.getWwn())) continue;
            try {
                this.deleteIOASite(pk, si);
            }
            catch (IOASwitchCommunicationException e) {
                this._Logger.error((Object)"Remove site label failed", (Throwable)e);
                throw new RemoteException(e.getMessage());
            }
            try {
                this.snmpChangeValue(si, "sysLocation", "");
            }
            catch (SnmpException e) {
                String logMsg = "Unable to clear sysLocation on switch";
                this._Logger.error((Object)logMsg, (Throwable)e);
                throw new RemoteException(logMsg);
            }
            si.setLocation("");
            return;
        }
    }

    @Override
    public void addClusterSite(IOAContext context, String siteName, Switch sw) throws RemoteException {
        SwitchImpl swi;
        SnmpUser snmpUser;
        String operation = "configure ioa site-local";
        if (context == null) {
            throw new RemoteException("Invalid context");
        }
        if (context.fabric == null) {
            throw new RemoteException("Invalid context.fabric");
        }
        if (sw == null) {
            throw new RemoteException("Invalid switch");
        }
        String ipAddress = sw.getIpAddress();
        if (ipAddress == null) {
            throw new RemoteException("Invalid switch ip address");
        }
        if (siteName == null) {
            siteName = "";
        }
        if ((snmpUser = this._user.getSnmpUser(context.fabric)) == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() != 3) {
            throw new RemoteException("Unsupported login to switch " + ipAddress + " for security model on this fabric");
        }
        username = ((UsmUser)snmpUser).getUserName();
        password = ((UsmUser)snmpUser).getAuthPassword();
        try {
            swi = this.getSwitchImplByIp(context.fabric, ipAddress);
        }
        catch (IOAProcessingException e) {
            this._Logger.error((Object)"Unable to set site, invalid switch ip address", (Throwable)e);
            throw new RemoteException("Unable to set site, invalid switch ip address", e);
        }
        this.enableFeatures(swi);
        String clusterName = context.clusterName;
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, ipAddress, username, password);
        String msgOut = clusterMessage.prepareSiteSetReq(siteName);
        String msgIn = null;
        try {
            msgIn = xmlHandler.sendReceive(msgOut);
        }
        catch (IOAException se) {
            this._Logger.error((Object)("Failed to send message to switch " + ipAddress), (Throwable)se);
            throw new RemoteException("Failed to send message to switch " + ipAddress, se);
        }
        if (msgIn == null) {
            String logMsg = "Failed to update ioa site-local on switch: " + sw.getIpAddress() + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
        IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
        try {
            if (!clusterMessage.analyzeResponse(message)) {
                String logMsg = "Failed to " + operation + " Error: " + message.getMsg_Header().getResponse_Status_Desc();
                this._Logger.warn((Object)logMsg);
                throw new RemoteException(logMsg);
            }
        }
        catch (IOAInvalidMessageException se) {
            String logMsg = "Failed to " + operation + " Error: " + se.getMessage();
            this._Logger.error((Object)("Failed to " + operation), (Throwable)se);
            throw new RemoteException(logMsg, se);
        }
        catch (IOAException se) {
            String logMsg = "Failed to " + operation + " Error: " + se.getMessage();
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg, se);
        }
    }

    private Cluster implToModel(ClusterImpl c) throws IOAProcessingException {
        this._Logger.debug((Object)("Convering FM Model to IOA Model for Cluster " + c.getName()));
        Cluster cluster = new Cluster(c.getName(), c.getClusterId());
        cluster.setStatus(c.getState());
        SwitchImpl masterSwitch = this.getSwitchImplByIp(c.getFabricPK(), c.getMasterInetAddr());
        SwitchBase base = (SwitchBase)masterSwitch.getBaseObject();
        Switch s = new Switch(c.getFabricPK()._fid, base.getSysName(), base.getWwn().toHexString(true));
        s.setIpAddress(base.getIpAddress());
        if (base.getSysLocation() != null) {
            s.setSiteName(base.getSysLocation());
        }
        s.setVersion(base.getVersion());
        cluster.setMasterSwitch(s);
        ClusterInterfBase[] interfaces = c.getClusterInterfs();
        if (interfaces != null) {
            for (ClusterInterfBase interf : interfaces) {
                try {
                    IOAInterface i = new IOAInterface();
                    i.setIfIndex(interf.getIfindex());
                    i.setClusterName(c.getName());
                    i.setInterfaceId(this.getIfNameIOA(interf.getIfindex()));
                    i.setStatus(interf.getStatus());
                    Switch sw = null;
                    try {
                        sw = this.getSwitchByIp(c.getFabricPK(), interf.getSwInetAddrStr());
                    }
                    catch (IOAProcessingException e) {
                        // empty catch block
                    }
                    if (sw == null) {
                        sw = this.getSwitchByName(c.getFabricPK(), interf.getSwInetAddrStr());
                        sw.setSwitchCommUseIp(false);
                    }
                    if (sw == null) {
                        throw new IOAProcessingException("Unable to find switch " + interf.getSwInetAddrStr());
                    }
                    i.setSwitchInfo(sw);
                    cluster.getInterfaceList().add(i);
                    this._Logger.debug((Object)("Associating interface " + interf.getSwInetAddrStr() + " " + i.getInterfaceId()));
                }
                catch (IOAProcessingException e) {
                    this._Logger.error((Object)("Problem associating cluster " + c.getName() + " and interface " + interf.getSwInetAddrStr() + " " + interf.getIfindex()), (Throwable)e);
                }
            }
        }
        return cluster;
    }

    @Override
    public ArrayList<Cluster> getClusterList(IOAContext context) throws RemoteException {
        SwitchImpl masterSwitch;
        ArrayList<Cluster> clusterList = new ArrayList<Cluster>();
        this._Logger.info((Object)("getClusterList entry fabric ID: " + context.fabric.id));
        ArrayList<SwitchImpl> discoveredList = new ArrayList<SwitchImpl>();
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        ArrayList<ClusterImpl> clusters = fabric.getClusterList();
        this._Logger.info((Object)("getClusterList fabric.getClusterList() returned " + clusters.size() + " clusters."));
        for (ClusterImpl c : clusters) {
            if (c.getType() != 2) continue;
            masterSwitch = null;
            if (masterSwitch == null) {
                if (c.getMasterInetAddr() == null || c.getMasterInetAddr().length() == 0) {
                    this._Logger.error((Object)("Cluster " + c.getName() + " from FM data model doesn't seem to have a valid masterIpAddr, skipping"));
                    continue;
                }
                try {
                    masterSwitch = this.getSwitchImplByIp(context.fabric, c.getMasterInetAddr());
                }
                catch (IOAProcessingException e1) {
                    this._Logger.error((Object)("Cluster " + c.getName() + " from FM data model doesn't seem to have a valid masterIpAddr, skipping"), (Throwable)e1);
                    continue;
                }
            }
            String masterIp = masterSwitch.getIpAddress();
            this._Logger.info((Object)("getClusterList found an IOA Cluster " + c.getName() + " masterIP: " + masterIp + " initiating IAS related discovery."));
            if (masterSwitch == null) continue;
            try {
                if (discoveredList.contains(masterSwitch)) continue;
                SnmpAdapter.discoverIAS(masterSwitch);
                discoveredList.add(masterSwitch);
            }
            catch (SnmpException e) {
                this._Logger.error((Object)("Cluster " + c.getName() + " SNMP discovery error"), (Throwable)e);
            }
        }
        clusters = fabric.getClusterList();
        for (ClusterImpl c : clusters) {
            if (c.getType() != 2) continue;
            masterSwitch = null;
            if (masterSwitch == null) {
                if (c.getMasterInetAddr() == null || c.getMasterInetAddr().length() == 0) {
                    this._Logger.error((Object)("Cluster " + c.getName() + " from FM data model doesn't seem to have a valid masterIpAddr, skipping"));
                    continue;
                }
                try {
                    masterSwitch = this.getSwitchImplByIp(context.fabric, c.getMasterInetAddr());
                }
                catch (IOAProcessingException e1) {
                    this._Logger.error((Object)("Cluster " + c.getName() + " from FM data model doesn't seem to have a valid masterIpAddr, skipping"), (Throwable)e1);
                    continue;
                }
            }
            Cluster cluster = null;
            try {
                cluster = this.implToModel(c);
            }
            catch (IOAProcessingException e) {
                this._Logger.error((Object)("Cluster " + c.getName() + " conversion error, skipping"), (Throwable)e);
                continue;
            }
            context.clusterName = cluster.getName();
            context.masterSwitch = cluster.getMasterSwitch();
            ArrayList<Switch> members = this.getClusterNodeList(context);
            for (Switch s : members) {
                if (!s.getIpAddress().equals(context.masterSwitch.getIpAddress())) continue;
                s.setMaster(true);
            }
            cluster.getMembers().addAll(members);
            ArrayList<IOAInterface> clusterIntfList = this.getClusterInterfaceList(context);
            ArrayList<IOAInterface> mergedList = new ArrayList<IOAInterface>();
            for (IOAInterface intf : cluster.getInterfaceList()) {
                boolean found = false;
                for (IOAInterface cif : clusterIntfList) {
                    if (!intf.equals(cif)) continue;
                    found = true;
                    intf.setStatus(cif.getStatus());
                    intf.setStatusReason(cif.getStatusReason());
                }
                if (!found) continue;
                mergedList.add(intf);
            }
            cluster.setInterfaceList(mergedList);
            for (IOAInterface intf : cluster.getInterfaceList()) {
                Switch intfS = intf.getSwitchInfo();
                for (Switch m : members) {
                    if (m.equals(cluster.getMasterSwitch())) {
                        m.setMaster(true);
                    }
                    if (m.equals(intfS)) {
                        if (!intf.getSwitchInfo().getSiteName().equals(m.getSiteName())) {
                            m.setSiteName(intfS.getSiteName());
                            this.addClusterSite(context, intfS.getSiteName(), m);
                        }
                        intf.setSwitchInfo(m);
                    }
                    SwitchImpl swi = null;
                    try {
                        swi = this.getSwitchImplByIp(context.fabric, m.getIpAddress());
                    }
                    catch (IOAProcessingException e) {
                        this._Logger.error((Object)("Error processing interface " + intf.getInterfaceId()), (Throwable)e);
                    }
                    m.setLicenseList(this.getIOALicenses(swi));
                }
            }
            clusterList.add(cluster);
        }
        return clusterList;
    }

    @Override
    public Cluster getCluster(IOAContext context) throws RemoteException {
        SwitchImpl masterSwitch = null;
        try {
            masterSwitch = this.getSwitchImplByIp(context.fabric, context.masterSwitch.getIpAddress());
        }
        catch (IOAProcessingException e1) {
            this._Logger.error((Object)("Cluster " + context.clusterName + " conversion error, skipping"), (Throwable)e1);
            throw new RemoteException("Unable to retrieve information for cluster " + context.clusterName, e1);
        }
        if (masterSwitch != null) {
            try {
                SnmpAdapter.discoverIAS(masterSwitch);
                Thread.sleep(500L);
            }
            catch (SnmpException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        ArrayList<ClusterImpl> clusters = fabric.getClusterList();
        for (ClusterImpl c : clusters) {
            Cluster cluster;
            if (c.getType() != 2 || !c.getName().equals(context.clusterName)) continue;
            try {
                cluster = this.implToModel(c);
            }
            catch (IOAProcessingException e) {
                this._Logger.error((Object)("Cluster " + context.clusterName + " conversion error"), (Throwable)e);
                throw new RemoteException("Unable to retrieve information for cluster " + context.clusterName, e);
            }
            ArrayList<Switch> members = this.getClusterNodeList(context);
            cluster.getMembers().addAll(members);
            for (IOAInterface intf : cluster.getInterfaceList()) {
                Switch intfS = intf.getSwitchInfo();
                for (Switch m : members) {
                    if (m.equals(cluster.getMasterSwitch())) {
                        m.setMaster(true);
                    }
                    if (!m.equals(intfS)) continue;
                    if (!intf.getSwitchInfo().getSiteName().equals(m.getSiteName())) {
                        m.setSiteName(intfS.getSiteName());
                        this.addClusterSite(context, intfS.getSiteName(), m);
                    }
                    intf.setSwitchInfo(m);
                }
            }
            return cluster;
        }
        return null;
    }

    @Override
    public ArrayList<IOAInterface> getInterfacesForSite(FabricPK pk, String siteName) throws RemoteException {
        ArrayList<IOAInterface> interfaceList = new ArrayList<IOAInterface>();
        FabricImpl fabric = this._sanManager.findFabric(pk);
        if (fabric == null) {
            return interfaceList;
        }
        SwitchImpl[] switches = fabric.getSwitches();
        for (int i = 0; i < switches.length; ++i) {
            SwitchBase base;
            String location;
            SwitchImpl sw = switches[i];
            if (!sw.isMDS() || (location = (base = (SwitchBase)sw.getBaseObject()).getSysLocation()) == null || !location.equals(siteName)) continue;
            List<FcPortBase> ports = sw.findIOAPorts();
            for (FcPortBase p : ports) {
                IOAInterface intf = new IOAInterface();
                intf.setIfIndex(p.getIfIndex());
                intf.setInterfaceId(p.getIfname());
                intf.setKey(p.getSwitchPK());
                intf.setStatus(p.getIOAState());
                Switch swInfo = new Switch(pk._fid, sw.getName(), sw.getWwn().toHexString(true));
                swInfo.setIpAddress(sw.getIpAddress());
                swInfo.setSiteName(location);
                intf.setSwitchInfo(swInfo);
                interfaceList.add(intf);
            }
        }
        return interfaceList;
    }

    @Override
    public ArrayList<IOAInterface> getCandidateInterfacesForCluster(IOAContext context) throws RemoteException {
        ArrayList<IOAInterface> interfaceList = new ArrayList<IOAInterface>();
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            return interfaceList;
        }
        SwitchImpl[] switches = fabric.getSwitches();
        for (int i = 0; i < switches.length; ++i) {
            SwitchImpl swi = switches[i];
            if (!swi.isMDS()) continue;
            ArrayList<IOAInterface> ifl = this.getSupportingInterfaces(swi);
            interfaceList.addAll(ifl);
        }
        ArrayList<ClusterInterfBase> baseList = new ArrayList<ClusterInterfBase>();
        ArrayList<ClusterImpl> clusterList = fabric.getClusterList();
        for (ClusterImpl cImpl : clusterList) {
            ClusterInterfBase[] intfList = cImpl.getClusterInterfs();
            if (intfList == null) continue;
            baseList.addAll(Arrays.asList(intfList));
        }
        Iterator<IOAInterface> iter = interfaceList.iterator();
        block2: while (iter.hasNext()) {
            IOAInterface intf = iter.next();
            int ifIndex = intf.getIfIndex();
            for (ClusterInterfBase ifBase : baseList) {
                Switch isw;
                String addr;
                if (ifBase.getIfindex() != ifIndex || !(addr = ifBase.getSwInetAddrStr()).equals((isw = intf.getSwitchInfo()).getIpAddress()) && !addr.equals(isw.getName())) continue;
                iter.remove();
                continue block2;
            }
        }
        for (int i = 0; i < switches.length; ++i) {
            SwitchImpl swi = switches[i];
            String ipaddr = swi.getIpAddress();
            if (ipaddr == null || ipaddr.length() == 0) continue;
            if (ipaddr.charAt(0) == '/') {
                ipaddr = ipaddr.substring(1);
            }
            ArrayList<LicenseInfo> licenseList = this.getIOALicenses(swi);
            List<FcPortBase> ports = swi.findIOAPorts();
            block5: for (IOAInterface intf : interfaceList) {
                if (!intf.getSwitchInfo().getIpAddress().equals(ipaddr)) continue;
                intf.getSwitchInfo().setLicenseList(licenseList);
                if (ports == null || ports.size() <= 0) continue;
                for (FcPortBase port : ports) {
                    if (intf.getIfIndex() != port.getIfIndex()) continue;
                    intf.setStatus(port.getIOAState());
                    intf.setKey(port.getSwitchPK());
                    continue block5;
                }
            }
        }
        return interfaceList;
    }

    @Override
    public InterfaceStats getStatsForInterface(IOAContext context, String ipAddress, int ifIndex) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get Interface Statistics, invalid fabric");
        }
        if (ipAddress == null || ifIndex < 0x21000000) {
            throw new RemoteException("Incomplete interface information");
        }
        String ifName = this.getIfNameIOA(ifIndex);
        this._Logger.warn((Object)("getStatsForInterface switch: " + ipAddress + " intf:" + ifName));
        InterfaceStats stats = new InterfaceStats();
        stats.setIpAddress(ipAddress);
        stats.setIfName(ifName);
        stats.setIfIndex(ifIndex);
        SwitchImpl swi = null;
        try {
            swi = this.getSwitchImplByIp(context.fabric, ipAddress);
        }
        catch (IOAProcessingException e) {
            this._Logger.error((Object)("Unable to get Interface Statistics, invalid switch ip address: " + ipAddress + " for interface " + ifIndex), (Throwable)e);
            return stats;
        }
        stats.setHostname(swi.getName());
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            this._Logger.warn((Object)("No login credential for fabic " + context.fabric));
            return stats;
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, ipAddress, username, password);
        String msgOut = clusterMessage.prepareGetInterfaceStatsGetReq(ifName, OperationEnum.BASE___SVC___OP___GET, Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
        String msgIn = null;
        try {
            msgIn = xmlHandler.sendReceive(msgOut);
        }
        catch (IOAException se) {
            this._Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            return stats;
        }
        if (msgIn == null) {
            this._Logger.warn((Object)"Error sending message to switch: null response");
            return stats;
        }
        IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
        try {
            if (clusterMessage.analyzeResponse(message)) {
                List interfaceObjects = message.getTable_Data().getGlobal_Get_Resp().getInterface();
                Iterator it = interfaceObjects.iterator();
                if (!it.hasNext()) {
                    this._Logger.warn((Object)"Interface statistics not available");
                    return stats;
                }
                IOAInterfaceObject io = (IOAInterfaceObject)it.next();
                InterfaceStatistics statistics = io.getStats();
                IOAHelper.setStatistics(stats, statistics);
            }
        }
        catch (IOAException se) {
            this._Logger.warn((Object)("Exception in getClusterInterfaceInfoList " + se.getMessage()));
        }
        return stats;
    }

    public ArrayList<InterfaceStats> getStatsForInterfacesSwitch(IOAContext context, Switch sw) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get Interface Statistics, invalid fabric");
        }
        ArrayList<InterfaceStats> statsList = new ArrayList<InterfaceStats>();
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        String inetAddr = sw.getIpAddress();
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, inetAddr, username, password);
        int receivedCount = 0;
        do {
            receivedCount = 0;
            String msgOut = clusterMessage.prepareGetInterfaceStatsGetReq(null, OperationEnum.BASE___SVC___OP___GET___NEXT, Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                this._Logger.error((Object)("Failed to send message to switch " + se.getMessage()), (Throwable)se);
                throw new RemoteException("Error sending message to switch: null response", se);
            }
            if (msgIn == null) {
                throw new RemoteException("Error sending message to switch: null response");
            }
            IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(message)) continue;
                List interfaceObjects = message.getTable_Data().getGlobal_Get_Resp().getInterface();
                Iterator it = interfaceObjects.iterator();
                while (it.hasNext()) {
                    InterfaceStats stats = new InterfaceStats();
                    IOAInterfaceObject io = (IOAInterfaceObject)it.next();
                    InterfaceStatistics statistics = io.getStats();
                    stats.setIpAddress(inetAddr);
                    stats.setHostname(sw.getName());
                    stats.setIfName(io.getInterface().getIndex().getIf_Index());
                    IOAHelper.setStatistics(stats, statistics);
                    statsList.add(stats);
                }
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Exception in getClusterInterfaceInfoList " + se.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
        return statsList;
    }

    @Override
    public void createCluster(IOAContext context) throws RemoteException {
        SwitchImpl swi;
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to create cluster, invalid fabric");
        }
        if (context.masterSwitch == null) {
            throw new RemoteException("Unable to create cluster, invalid switch");
        }
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        short type = 2;
        short state = 4;
        short masterInetAddrType = 16;
        String masterInetAddr = context.masterSwitch.getIpAddress();
        try {
            swi = this.getSwitchImplByIp(context.fabric, masterInetAddr);
        }
        catch (IOAProcessingException e) {
            this._Logger.error((Object)"Unable to create cluster, invalid switch ip address", (Throwable)e);
            throw new RemoteException("Unable to create cluster, invalid switch ip address", e);
        }
        SwitchBase base = (SwitchBase)swi.getBaseObject();
        String location = base.getSysLocation();
        if (location == null || location.length() == 0) {
            throw new RemoteException("Must set site name first");
        }
        this.enableFeatures(swi);
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
        String msgOut = clusterMessage.prepareCreateClusterSetReq(clusterName);
        String msgIn = null;
        try {
            msgIn = xmlHandler.sendReceive(msgOut);
        }
        catch (IOAException se) {
            String logMsg = "Failed to create cluster " + clusterName;
            this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
            throw new RemoteException(logMsg);
        }
        if (msgIn != null) {
            ClusterPK cKey;
            ClusterImpl cluster;
            IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(message)) {
                    String logMsg = "Failed to create cluster " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
                cluster = null;
                cKey = new ClusterPK(clusterName, clusterName, 2);
                cluster = fabric.findCluster(cKey);
                if (cluster == null && (cluster = fabric.createCluster(cKey, type, state, masterInetAddrType, masterInetAddr, swi)) != null) {
                    cluster.setFabric(fabric);
                }
            }
            catch (IOAInvalidMessageException se) {
                String logMsg = "Failed to Create Cluster: " + clusterName + ". Error: " + se.getMessage();
                this._Logger.warn((Object)logMsg);
                throw new RemoteException(logMsg);
            }
            catch (IOAException se) {
                String logMsg = "Failed to Create Cluster : " + clusterName + ". Error: " + se.getMessage();
                this._Logger.warn((Object)logMsg);
                throw new RemoteException(logMsg);
            }
            cluster = null;
            cKey = new ClusterPK(clusterName, clusterName, 2);
            cluster = fabric.findCluster(cKey);
            if (cluster == null && (cluster = fabric.createCluster(cKey, type, state, masterInetAddrType, masterInetAddr, swi)) != null) {
                cluster.setFabric(fabric);
            }
        } else {
            String logMsg = "Failed to update the Cluster " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteCluster(IOAContext context) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to delete cluster, invalid fabric");
        }
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        String masterInetAddr = context.masterSwitch.getIpAddress();
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
        String msgOut = clusterMessage.prepareDeleteClusterSetReq(clusterName);
        String msgIn = null;
        try {
            msgIn = xmlHandler.sendReceive(msgOut);
        }
        catch (IOAException se) {
            String logMsg = "Failed to delete cluster " + clusterName;
            this._Logger.error((Object)(logMsg + ". Error: " + se.getMessage()), (Throwable)se);
            throw new RemoteException(logMsg, se);
        }
        if (msgIn != null) {
            IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(message)) {
                    String logMsg = "Failed to delete cluster " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
                ClusterImpl cluster = null;
                ClusterPK cKey = new ClusterPK(clusterName, clusterName, 2);
                cluster = fabric.findCluster(cKey);
                if (cluster == null) return;
                fabric.removeCluster(cluster);
                return;
            }
            catch (IOAInvalidMessageException se) {
                String logMsg = "Failed to Delete Cluster: " + clusterName + ". Error: " + se.getMessage();
                this._Logger.error((Object)logMsg, (Throwable)se);
                throw new RemoteException(logMsg, se);
            }
            catch (IOAException se) {
                String logMsg = "Failed to Delete Cluster : " + clusterName + ". Error: " + se.getMessage();
                this._Logger.warn((Object)logMsg, (Throwable)se);
                throw new RemoteException(logMsg, se);
            }
        } else {
            String logMsg = "Failed to Delete the Cluster " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public void addClusterNode(IOAContext context, Switch node, String siteName) throws RemoteException {
        block13: {
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                throw new RemoteException("Unable to add cluster node, invalid fabric");
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            SwitchImpl nodeSwi = null;
            try {
                nodeSwi = this.getSwitchImplByIp(context.fabric, node.getIpAddress());
            }
            catch (IOAProcessingException e) {
                this._Logger.error((Object)"Unable to add cluster node, invalid switch ip address", (Throwable)e);
                throw new RemoteException("Unable to add cluster node, invalid switch ip address", e);
            }
            this.enableFeatures(nodeSwi);
            ClusterMessage clusterMessage = new ClusterMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = clusterMessage.prepareUpdateClusterNodeSetReq(clusterName, siteName, node);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to add cluster node " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg, se);
            }
            if (msgIn != null) {
                IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!clusterMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to add cluster node " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block13;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to add cluster node: " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg, se);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to add cluster node : " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg, se);
                }
            }
            String logMsg = "Failed to add cluster node " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public void deleteClusterNode(IOAContext context, Switch node) throws RemoteException {
        block14: {
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                throw new RemoteException("Unable to remove cluster node, invalid fabric");
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            SwitchImpl[] switches = fabric.getSwitches();
            SwitchImpl swi = null;
            for (int i = 0; i < switches.length; ++i) {
                SwitchImpl sw = switches[i];
                if (!sw.isMDS()) continue;
                InetAddress[] ips = sw.getManagementAddresses();
                for (int j = 0; j < ips.length; ++j) {
                    if (!ips[j].toString().equals("/" + masterInetAddr)) continue;
                    swi = sw;
                }
            }
            if (swi == null) {
                throw new RemoteException("Unable to remove cluster node, invalid switch ip address");
            }
            ClusterMessage clusterMessage = new ClusterMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = clusterMessage.prepareDeleteClusterNodeSetReq(clusterName, node);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to remove cluster node " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg);
            }
            if (msgIn != null) {
                IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!clusterMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to remove cluster node " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(message.getMsg_Header().getResponse_Status_Desc());
                    }
                    break block14;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to remove cluster node: " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(se.getMessage());
                }
                catch (IOAException se) {
                    String logMsg = "Failed to remove cluster node : " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(se.getMessage());
                }
            }
            String logMsg = "Failed to remove cluster node " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    public ArrayList<Switch> getClusterNodeList(IOAContext context) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get cluster nodes, invalid fabric");
        }
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        String masterInetAddr = context.masterSwitch.getIpAddress();
        ArrayList<Switch> nodeList = new ArrayList<Switch>();
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
        int receivedCount = 0;
        do {
            receivedCount = 0;
            String msgOut = clusterMessage.prepareClusterNodeGetReq(clusterName, null, OperationEnum.BASE___SVC___OP___GET___NEXT, Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
                throw new RemoteException("Failed to send message to switch", se);
            }
            if (msgIn == null) break;
            IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(message)) break;
                List nodes = message.getTable_Data().getCluster_Get_Resp().getNode();
                for (ClusterNodeObject cno : nodes) {
                    String cname = cno.getIndex().getCluster_Name();
                    if (cname == null || !cname.equals(clusterName)) continue;
                    String identifier = cno.getIndex().getNode_Name();
                    Switch sw = null;
                    try {
                        sw = this.getSwitchByIp(context.fabric, identifier);
                    }
                    catch (IOAProcessingException e) {
                        // empty catch block
                    }
                    if (sw == null) {
                        try {
                            sw = this.getSwitchByName(context.fabric, identifier);
                            sw.setSwitchCommUseIp(false);
                        }
                        catch (IOAProcessingException e) {
                            // empty catch block
                        }
                    }
                    if (sw != null) {
                        sw.setSiteName(cno.getData().getSite());
                        nodeList.add(sw);
                    }
                    ++receivedCount;
                }
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Exception in getClusterNodeList " + se.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
        return nodeList;
    }

    @Override
    public void addClusterInterface(IOAContext context, IOAInterface intf) throws RemoteException {
        block19: {
            this._Logger.info((Object)("addClusterInterface - cluster: " + context.clusterName + " interface: " + intf.getInterfaceId()));
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                String logMsg = "Unable to add cluster interface, invalid fabric";
                this._Logger.warn((Object)logMsg);
                throw new RemoteException(logMsg);
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            SwitchImpl swi = null;
            try {
                swi = this.getSwitchImplByIp(context.fabric, intf.getSwitchInfo().getIpAddress());
            }
            catch (IOAProcessingException e1) {
                this._Logger.error((Object)"Unable to add cluster interface, invalid switch ip address", (Throwable)e1);
                throw new RemoteException("Unable to add cluster interface, invalid switch ip address", e1);
            }
            if (intf.getStatus() == 0) {
                try {
                    this.createInterfaceIOA(swi, intf.getSlot(), intf.getPort());
                }
                catch (SnmpException e) {
                    String logMsg = "Error adding interface : " + e.getMessage();
                    this._Logger.error((Object)logMsg, (Throwable)e);
                    throw new RemoteException(logMsg, e);
                }
            }
            if (intf.getStatus() != 4) {
                this._Logger.info((Object)("interface status is: " + intf.getStatusString() + " attempting to no shut."));
                try {
                    this.setInterfaceIOAStatus(swi, intf.getIfIndex(), false);
                }
                catch (SnmpException e) {
                    this._Logger.warn((Object)"Non-fatal error: interface no shut failed - user can no shut manually");
                }
            }
            String masterInetAddr = context.masterSwitch.getIpAddress();
            ClusterMessage clusterMessage = new ClusterMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = clusterMessage.prepareUpdateClusterInterfaceSetReq(clusterName, intf.getSwitchInfo(), "ioa " + intf.getSlot() + "/" + intf.getPort(), false, false);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to add cluster interface " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg, se);
            }
            if (msgIn != null) {
                IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!clusterMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to add cluster interface " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block19;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to add cluster interface: " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg, se);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to add cluster interface : " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg, se);
                }
            }
            String logMsg = "Failed to add cluster interface " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public void deleteClusterInterface(IOAContext context, IOAInterface intf) throws RemoteException {
        block12: {
            if (context.masterSwitch == null) {
                throw new RemoteException("Request failed, invalid switch parameter");
            }
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                throw new RemoteException("Unable to remove cluster interface, invalid fabric");
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            ClusterMessage clusterMessage = new ClusterMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = clusterMessage.prepareDeleteClusterInterfaceSetReq(clusterName, intf.getSwitchInfo(), intf.getInterfaceId());
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to remove cluster interface " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg, se);
            }
            if (msgIn != null) {
                IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!clusterMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to remove cluster interface " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block12;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to remove cluster interface: " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg, se);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to remove cluster interface : " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg, se);
                }
            }
            String logMsg = "Failed to remove cluster interface " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public void ioaInterfaceAdminShut(IOAContext context, IOAInterface intf) throws RemoteException {
        SwitchImpl swi;
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to shut interface, invalid fabric");
        }
        try {
            swi = this.getSwitchImplByIp(context.fabric, intf.getSwitchInfo().getIpAddress());
        }
        catch (IOAProcessingException e1) {
            this._Logger.error((Object)"Unable to shut interface, invalid switch ip address", (Throwable)e1);
            throw new RemoteException("Unable to shut interface, invalid switch ip address", e1);
        }
        try {
            this.setInterfaceIOAStatus(swi, intf.getIfIndex(), true);
        }
        catch (SnmpException e) {
            this._Logger.error((Object)"Error shutting interface", (Throwable)e);
            throw new RemoteException("Error shutting interface : " + e.getMessage());
        }
    }

    @Override
    public void ioaInterfaceAdminNoShut(IOAContext context, IOAInterface intf) throws RemoteException {
        SwitchImpl swi;
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to no shut interface, invalid fabric");
        }
        try {
            swi = this.getSwitchImplByIp(context.fabric, intf.getSwitchInfo().getIpAddress());
        }
        catch (IOAProcessingException e1) {
            this._Logger.error((Object)"Unable to no shut interface, invalid switch ip address", (Throwable)e1);
            throw new RemoteException("Unable to no shut interface, invalid switch ip address", e1);
        }
        try {
            this.setInterfaceIOAStatus(swi, intf.getIfIndex(), false);
        }
        catch (SnmpException e) {
            this._Logger.error((Object)("Error no-shutting interface : " + e.getMessage()), (Throwable)e);
            throw new RemoteException("Error no-shutting interface : " + e.getMessage(), e);
        }
    }

    @Override
    public ArrayList<IOAInterface> getClusterInterfaceList(IOAContext context) throws RemoteException {
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get cluster interfaces, invalid fabric");
        }
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        String masterInetAddr = context.masterSwitch.getIpAddress();
        ArrayList<IOAInterface> clusterInterfaceList = new ArrayList<IOAInterface>();
        ClusterMessage clusterMessage = new ClusterMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
        int receivedCount = 0;
        String nodeName = null;
        String interfaceId = null;
        do {
            receivedCount = 0;
            String msgOut = clusterMessage.prepareClusterInterfaceGetReq(clusterName, nodeName, interfaceId, OperationEnum.BASE___SVC___OP___GET___NEXT, Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            IOAMessage message = clusterMessage.parseClusterResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!clusterMessage.analyzeResponse(message)) break;
                List cifl = message.getTable_Data().getCluster_Get_Resp().getInterface();
                for (ClusterInterfaceObject cio : cifl) {
                    interfaceId = cio.getIndex().getIf_Index();
                    clusterName = cio.getIndex().getCluster_Name();
                    nodeName = cio.getIndex().getNode_Name();
                    if (context.clusterName.equals(clusterName)) {
                        IOAInterface intf = new IOAInterface();
                        intf.setClusterName(clusterName);
                        String ifValue = cio.getIndex().getIf_Index();
                        if (ifValue != null) {
                            intf.setInterfaceId(ifValue);
                            int ifIndex = this.getIfIndexIOA(this.getIfSlotFromName(ifValue), this.getIfPortFromName(ifValue));
                            intf.setIfIndex(ifIndex);
                        }
                        InterfaceStatusEnum stat = cio.getData().getStatus();
                        InterfaceStatusReasonEnum statReason = cio.getData().getStatus_Reason();
                        intf.setStatus(IOAHelper.InterfaceStatusEnum2int(stat));
                        intf.setStatusReason(IOAHelper.InterfaceStatusReasonEnum2String(stat, statReason));
                        String identifier = cio.getIndex().getNode_Name();
                        Switch sw = null;
                        try {
                            sw = this.getSwitchByIp(context.fabric, identifier);
                        }
                        catch (IOAProcessingException e) {
                            // empty catch block
                        }
                        if (sw == null) {
                            sw = this.getSwitchByName(context.fabric, identifier);
                            sw.setSwitchCommUseIp(false);
                        }
                        if (sw == null) {
                            ++receivedCount;
                            continue;
                        }
                        intf.setSwitchInfo(sw);
                        clusterInterfaceList.add(intf);
                    }
                    ++receivedCount;
                }
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Exception in getClusterInterfaceList " + se.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_INTERFACES_IN_REQUEST);
        return clusterInterfaceList;
    }

    @Override
    public ArrayList<Flow> getFlowsForCluster(IOAContext context) throws RemoteException {
        SwitchImpl swi;
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get flows for cluster, invalid fabric");
        }
        SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
        if (snmpUser == null) {
            throw new RemoteException("No login credential for fabic");
        }
        String username = null;
        String password = null;
        if (snmpUser.getSecurityModel() == 3) {
            username = ((UsmUser)snmpUser).getUserName();
            password = ((UsmUser)snmpUser).getAuthPassword();
        } else {
            username = ((CommunityUser)snmpUser).getCommunity();
        }
        String clusterName = context.clusterName;
        String masterInetAddr = context.masterSwitch.getIpAddress();
        try {
            swi = this.getSwitchImplByIp(context.fabric, masterInetAddr);
        }
        catch (IOAProcessingException e) {
            this._Logger.error((Object)"Unable to get flows for cluster, invalid switch ip address", (Throwable)e);
            throw new RemoteException("Unable to get flows for cluster, invalid switch ip address", e);
        }
        FlowMessage flowMessage = new FlowMessage();
        IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
        int receivedCount = 0;
        Path path = null;
        String flowGroupName = null;
        int exceptionCnt = 0;
        do {
            receivedCount = 0;
            String msgOut = flowMessage.prepareClusterFlowGetReq(clusterName, path, flowGroupName, OperationEnum.BASE___SVC___OP___GET___NEXT, Limits.MAX_CLUSTER_FLOWS_IN_REQUEST);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Failed to send message to switch " + se.getMessage()));
            }
            if (msgIn == null) break;
            IOAMessage message = flowMessage.parseFlowResponse(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (!flowMessage.analyzeResponse(message)) break;
                List flows = message.getTable_Data().getFlow_Get_Resp().getFlows();
                for (IOAFlowObject flow : flows) {
                    ++receivedCount;
                    try {
                        EndDevice i = new EndDevice();
                        i.setClusterName(clusterName);
                        i.setWwn(flow.getIndex().getI_T_Nexus_Path().getInitiator());
                        EndDevice t = new EndDevice();
                        t.setClusterName(clusterName);
                        t.setWwn(flow.getIndex().getI_T_Nexus_Path().getTarget());
                        path = new Path();
                        path.setFabric("");
                        path.setInitiator(i.getWwnBrief());
                        path.setTarget(t.getWwnBrief());
                        flowGroupName = flow.getData().getFlowGroup();
                        int initiatorVsan = flow.getData().getHost_VSAN();
                        int targetVsan = flow.getData().getTarget_VSAN();
                        Flow f = new Flow();
                        f.setInitiator(i);
                        EndPortImpl iep = this._sanManager.findEndPortByWwn(new Wwn(i.getWwnBrief()));
                        if (iep != null) {
                            VsanPK initiatorVsanPK;
                            SwitchImpl iswi;
                            i.setAlias(iep.getAlias());
                            Wwn iwwn = null;
                            if (iep.isPresent() && (iswi = iep.getSwitch()) != null) {
                                SwitchBase isb = (SwitchBase)iswi.getBaseObject();
                                if (isb != null) {
                                    i.setSiteName(isb.getSysLocation());
                                }
                                iwwn = iswi.getVsanWwn((short)initiatorVsan);
                            }
                            if (iwwn != null) {
                                initiatorVsanPK = new VsanPK(initiatorVsan, iwwn);
                                i.setVsan(initiatorVsanPK);
                            } else {
                                initiatorVsanPK = new VsanPK(initiatorVsan, swi.getWwn());
                                i.setVsan(initiatorVsanPK);
                                i.setOffline(true);
                            }
                        } else {
                            VsanPK initiatorVsanPK = new VsanPK(initiatorVsan, swi.getWwn());
                            i.setVsan(initiatorVsanPK);
                            i.setOffline(true);
                        }
                        f.setTarget(t);
                        EndPortImpl tep = this._sanManager.findEndPortByWwn(new Wwn(t.getWwnBrief()));
                        if (tep != null) {
                            VsanPK targetVsanPK;
                            SwitchImpl tswi;
                            t.setAlias(tep.getAlias());
                            Wwn twwn = null;
                            if (tep.isPresent() && (tswi = tep.getSwitch()) != null) {
                                SwitchBase tsb = (SwitchBase)tswi.getBaseObject();
                                if (tsb != null) {
                                    t.setSiteName(tsb.getSysLocation());
                                }
                                twwn = tswi.getVsanWwn((short)targetVsan);
                            }
                            if (twwn != null) {
                                targetVsanPK = new VsanPK(targetVsan, twwn);
                                t.setVsan(targetVsanPK);
                            } else {
                                targetVsanPK = new VsanPK(targetVsan, swi.getWwn());
                                t.setVsan(targetVsanPK);
                                t.setOffline(true);
                            }
                        } else {
                            VsanPK targetVsanPK = new VsanPK(targetVsan, swi.getWwn());
                            t.setVsan(targetVsanPK);
                            t.setOffline(true);
                        }
                        if (initiatorVsan == targetVsan) {
                            f.setVsanId(targetVsan);
                        } else {
                            f.setVsanId(-1);
                        }
                        f.setUseCompression(flow.getData().isCompression());
                        f.setUseTA(flow.getData().isTA());
                        f.setUseWA(flow.getData().isWA());
                        f.setFlowGroupName(flow.getData().getFlowGroup());
                        if (flow.getData().getI_T_Nexus_Data().getStatus().equals((Object)ITNexusStatusEnum.BASE___SVC___I___T___NEXUS___ONLINE)) {
                            f.setStatus("ONLINE");
                        } else if (flow.getData().getI_T_Nexus_Data().getStatus().equals((Object)ITNexusStatusEnum.BASE___SVC___I___T___NEXUS___FAILURE)) {
                            f.setStatus("FAILURE");
                        } else {
                            f.setStatus("OFFLINE");
                        }
                        f.setStatusReason(flow.getData().getI_T_Nexus_Data().getStatus_Desc());
                        flowList.add(f);
                    }
                    catch (Exception e) {
                        if (++exceptionCnt <= 3) continue;
                        this._Logger.error((Object)"Multiple errors parsing flows", (Throwable)e);
                        return flowList;
                    }
                }
            }
            catch (IOAException se) {
                this._Logger.warn((Object)("Exception in getFlowsForCluster " + se.getMessage()));
            }
        } while (receivedCount == Limits.MAX_CLUSTER_FLOWS_IN_REQUEST);
        return flowList;
    }

    @Override
    public void manageFlow(IOAContext context, Flow flowCandidate) throws RemoteException {
        block13: {
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                throw new RemoteException("Unable to manage flow, invalid fabric");
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            SwitchImpl swi = null;
            try {
                swi = this.getSwitchImplByIp(context.fabric, masterInetAddr);
            }
            catch (IOAProcessingException e) {
                this._Logger.error((Object)"Unable to manage flows, invalid switch ip address", (Throwable)e);
                throw new RemoteException("Unable to manage flows, invalid switch ip address", e);
            }
            FlowMessage flowMessage = new FlowMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            this.setEndPortSite(context, flowCandidate.getInitiator());
            this.setEndPortSite(context, flowCandidate.getTarget());
            String msgOut = flowMessage.prepareClusterFlowSetReq(clusterName, flowCandidate, IOAOpcodeEnum.CREATE___FLOW);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to manage flow " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg);
            }
            if (msgIn != null) {
                IOAMessage message = flowMessage.parseFlowResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!flowMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to manage flow from " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block13;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to manage flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to manage flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
            }
            String logMsg = "Failed to modify flow from " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    private void setEndPortSite(IOAContext context, EndDevice dev) throws RemoteException {
        block10: {
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            FlowMessage flowMessage = new FlowMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = flowMessage.prepareNportSetReq(clusterName, dev);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to manage flow " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg);
            }
            if (msgIn != null) {
                IOAMessage message = flowMessage.parseFlowResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!flowMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to manage flow from " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block10;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to manage flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to manage flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
            }
            String logMsg = "Failed to modify flow from " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public void modifyFlow(IOAContext context, Flow flow) throws RemoteException {
        block11: {
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                throw new RemoteException("Unable to modify flow, invalid fabric");
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            FlowMessage flowMessage = new FlowMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = flowMessage.prepareClusterFlowSetReq(clusterName, flow, IOAOpcodeEnum.UPDATE___FLOW);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to modify flow " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg);
            }
            if (msgIn != null) {
                IOAMessage message = flowMessage.parseFlowResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!flowMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to modify flow from " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block11;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to modify flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to modify flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
            }
            String logMsg = "Failed to modify flow from " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public void removeFlow(IOAContext context, Flow flow) throws RemoteException {
        block11: {
            FabricImpl fabric = this._sanManager.findFabric(context.fabric);
            if (fabric == null) {
                throw new RemoteException("Unable to remove flow, invalid fabric");
            }
            SnmpUser snmpUser = this._user.getSnmpUser(context.fabric);
            if (snmpUser == null) {
                throw new RemoteException("No login credential for fabic");
            }
            String username = null;
            String password = null;
            if (snmpUser.getSecurityModel() == 3) {
                username = ((UsmUser)snmpUser).getUserName();
                password = ((UsmUser)snmpUser).getAuthPassword();
            } else {
                username = ((CommunityUser)snmpUser).getCommunity();
            }
            String clusterName = context.clusterName;
            String masterInetAddr = context.masterSwitch.getIpAddress();
            FlowMessage flowMessage = new FlowMessage();
            IOAXmlHandler xmlHandler = new IOAXmlHandler(clusterName, masterInetAddr, username, password);
            String msgOut = flowMessage.prepareDeleteFlowSetReq(clusterName, flow);
            String msgIn = null;
            try {
                msgIn = xmlHandler.sendReceive(msgOut);
            }
            catch (IOAException se) {
                String logMsg = "Failed to remove flow " + clusterName;
                this._Logger.warn((Object)(logMsg + ". Error: " + se.getMessage()));
                throw new RemoteException(logMsg);
            }
            if (msgIn != null) {
                IOAMessage message = flowMessage.parseFlowResponse(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!flowMessage.analyzeResponse(message)) {
                        String logMsg = "Failed to remove flow from " + clusterName + ". Error: " + message.getMsg_Header().getResponse_Status_Desc();
                        this._Logger.warn((Object)logMsg);
                        throw new RemoteException(logMsg);
                    }
                    break block11;
                }
                catch (IOAInvalidMessageException se) {
                    String logMsg = "Failed to remove flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
                catch (IOAException se) {
                    String logMsg = "Failed to remove flow from " + clusterName + ". Error: " + se.getMessage();
                    this._Logger.warn((Object)logMsg);
                    throw new RemoteException(logMsg);
                }
            }
            String logMsg = "Failed to remove flow from " + clusterName + ". Unable to communicate with switch.";
            this._Logger.warn((Object)logMsg);
            throw new RemoteException(logMsg);
        }
    }

    @Override
    public FlowCandidateSet getFlowCandidateEndDeviceSet(IOAContext context, String siteA, String siteB) throws RemoteException {
        ArrayList<EndDevice> s1deviceList = new ArrayList<EndDevice>();
        ArrayList<EndDevice> s2deviceList = new ArrayList<EndDevice>();
        FlowCandidateSet fcs = new FlowCandidateSet(siteA, s1deviceList, siteB, s2deviceList);
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get flow candidates, invalid fabric");
        }
        EndPortImpl[] allEpArray = fabric.getEndPorts();
        if (allEpArray == null || allEpArray.length == 0) {
            return fcs;
        }
        for (EndPortImpl ep : allEpArray) {
            EndDevice i;
            WwnKey iKey;
            EndPortBase ib;
            String location;
            SwitchBase base;
            SwitchImpl swi;
            if (ep == null || !ep.isPresent() || (swi = ep.getSwitch()) == null || (base = (SwitchBase)swi.getBaseObject()) == null || (location = base.getSysLocation()) == null || location.length() <= 0) continue;
            if (location.equals(siteA)) {
                ib = (EndPortBase)ep.getBaseObject();
                iKey = ib.getEndPortPK();
                i = new EndDevice();
                i.setClusterName(context.clusterName);
                i.setFabric(context.fabric);
                i.setSiteName(siteA);
                i.setVsan(ib.getVsanPK(ib.getVsan()));
                i.setWwn(iKey._wwn.toHexString(true));
                i.setAlias(ep.getDeviceAlias());
                i.setInitiator(ib.isIntiator());
                i.setTarget(ib.isTarget());
                s1deviceList.add(i);
                continue;
            }
            if (!location.equals(siteB)) continue;
            ib = (EndPortBase)ep.getBaseObject();
            iKey = ib.getEndPortPK();
            i = new EndDevice();
            i.setClusterName(context.clusterName);
            i.setFabric(context.fabric);
            i.setSiteName(siteB);
            i.setVsan(ib.getVsanPK(ib.getVsan()));
            i.setWwn(iKey._wwn.toHexString(true));
            i.setAlias(ep.getDeviceAlias());
            i.setInitiator(ib.isIntiator());
            i.setTarget(ib.isTarget());
            s2deviceList.add(i);
        }
        return fcs;
    }

    private Wwn getZoneMemberWwn(ZoneMemberBase mem, VsanBase vsan, FabricBase fa) {
        switch (mem.getType()) {
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                EndPortBase epb = ZoneService.getEndPort(mem.getType(), mem.getId(), vsan, fa);
                if (epb == null) break;
                Wwn epbWwn = epb.getPortWwn();
                return epbWwn;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                ArrayList endportList = ZoneService.getAttachedEndPorts(fa, mem.getType(), mem.getId(), vsan);
                if (endportList == null) break;
                for (int i = 0; i < endportList.size(); ++i) {
                    EndPortBase epb = (EndPortBase)endportList.get(i);
                    if (epb == null) continue;
                    Wwn epbWwn = epb.getPortWwn();
                    return epbWwn;
                }
                break;
            }
        }
        return null;
    }

    @Override
    public ArrayList<Flow> getCandidateFlows(IOAContext context, String siteA, String siteB, boolean getAllPairs) throws RemoteException {
        if (getAllPairs) {
            return this.getAllCandidateFlows(context, siteA, siteB);
        }
        return this.getCandidateFlows(context, siteA, siteB);
    }

    public ArrayList<Flow> getAllCandidateFlows(IOAContext context, String siteA, String siteB) throws RemoteException {
        SwitchImpl swi;
        VsanImpl[] vsans;
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get candidate flows, invalid fabric");
        }
        FabricBase fabricBase = fabric.getFabricBase(new short[0]);
        flowList.addAll(this.getCandidateFlows(context, siteA, siteB));
        for (VsanImpl vsan : vsans = fabric.getVsans()) {
            VsanBase vsanBase = (VsanBase)vsan.getBaseObject();
            ZoneBase[] zoneBases = vsan.getEnforcedZones();
            List<EndPortImpl> allEndPorts = vsan.getEndPorts();
            this._Logger.debug((Object)("getCandidateFlows:  vsan " + vsan.getId() + " with " + allEndPorts.size() + " endPorts"));
            Hashtable<Wwn, EndPortImpl> hashSiteA = new Hashtable<Wwn, EndPortImpl>();
            Hashtable<Wwn, EndPortImpl> hashSiteB = new Hashtable<Wwn, EndPortImpl>();
            for (EndPortImpl ep : allEndPorts) {
                WwnKey key;
                EndPortBase epb;
                String location;
                SwitchBase base;
                if (ep == null || !ep.isPresent() || (swi = ep.getSwitch()) == null || (base = (SwitchBase)swi.getBaseObject()) == null || (location = base.getSysLocation()) == null || location.length() <= 0) continue;
                if (location.equals(siteA)) {
                    epb = (EndPortBase)ep.getBaseObject();
                    if (epb == null || (key = epb.getEndPortPK()) == null) continue;
                    hashSiteA.put(key._wwn, ep);
                    continue;
                }
                if (!location.equals(siteB) || (epb = (EndPortBase)ep.getBaseObject()) == null || (key = epb.getEndPortPK()) == null) continue;
                hashSiteB.put(key._wwn, ep);
            }
            this._Logger.debug((Object)("getCandidateFlows: site " + siteA + " with " + hashSiteA.size()));
            this._Logger.debug((Object)("getCandidateFlows: site " + siteB + " with " + hashSiteB.size()));
            if (zoneBases == null) continue;
            for (int j = 0; j < zoneBases.length; ++j) {
                ZoneBase zone = zoneBases[j];
                Array members = zone.getMembers();
                this._Logger.debug((Object)("getCandidateFlows: zone " + zone.getName() + " with " + members.size() + " members"));
                if (members == null || members.getData() == null || members.size() <= 1) continue;
                ArrayList<EndPortImpl> listSiteA = new ArrayList<EndPortImpl>();
                ArrayList<EndPortImpl> listSiteB = new ArrayList<EndPortImpl>();
                E[] allMembers = members.getData();
                for (int k = 0; k < members.size(); ++k) {
                    ZoneMemberBase mem = (ZoneMemberBase)allMembers[k];
                    Wwn memWwn = this.getZoneMemberWwn(mem, vsanBase, fabricBase);
                    if (memWwn == null) continue;
                    EndPortImpl epi = (EndPortImpl)hashSiteA.get(memWwn);
                    if (epi != null) {
                        listSiteA.add(epi);
                        continue;
                    }
                    epi = (EndPortImpl)hashSiteB.get(memWwn);
                    if (epi == null) continue;
                    listSiteB.add(epi);
                }
                if (listSiteA.size() <= 0 || listSiteB.size() <= 0) continue;
                this._Logger.debug((Object)("getCandidateFlows: in " + siteA + " = " + listSiteA.size() + ", in " + siteB + " = " + listSiteB.size()));
                for (EndPortImpl iPort : listSiteA) {
                    EndPortBase ib = (EndPortBase)iPort.getBaseObject();
                    WwnKey iKey = ib.getEndPortPK();
                    for (EndPortImpl tPort : listSiteB) {
                        EndPortBase tb = (EndPortBase)tPort.getBaseObject();
                        WwnKey tKey = tb.getEndPortPK();
                        Flow f = new Flow();
                        EndDevice i = new EndDevice();
                        i.setClusterName(context.clusterName);
                        i.setFabric(context.fabric);
                        i.setSiteName(siteA);
                        i.setVsan(vsan.getVsanPK());
                        i.setWwn(iKey._wwn.toHexString(true));
                        i.setAlias(iPort.getDeviceAlias());
                        i.setInitiator(ib.isIntiator());
                        i.setTarget(ib.isTarget());
                        EndDevice t = new EndDevice();
                        t.setClusterName(context.clusterName);
                        t.setFabric(context.fabric);
                        t.setSiteName(siteB);
                        t.setVsan(vsan.getVsanPK());
                        t.setWwn(tKey._wwn.toHexString(true));
                        t.setAlias(tPort.getDeviceAlias());
                        t.setInitiator(tb.isIntiator());
                        t.setTarget(tb.isTarget());
                        if (!i.isInitiator() && !t.isTarget()) {
                            f.setInitiator(t);
                            f.setTarget(i);
                        } else {
                            f.setInitiator(i);
                            f.setTarget(t);
                        }
                        f.setVsanId(vsan.getId());
                        boolean found = false;
                        for (Flow fl : flowList) {
                            if (i.equals(fl.getInitiator()) && t.equals(fl.getTarget())) {
                                found = true;
                                continue;
                            }
                            if (!t.equals(fl.getInitiator()) || !i.equals(fl.getTarget())) continue;
                            found = true;
                        }
                        if (found) continue;
                        flowList.add(f);
                    }
                }
            }
        }
        ZoneBase[] ivrZoneBases = fabric.getIvrEnforcedZones();
        if (ivrZoneBases != null) {
            for (ZoneBase zone : ivrZoneBases) {
                ArrayList<IvrEndPort> memberList = new ArrayList<IvrEndPort>();
                Array members = zone.getMembers();
                if (members != null && members.getData() != null && members.size() > 0) {
                    E[] allMembers = members.getData();
                    for (int k = 0; k < members.size(); ++k) {
                        WwnKey key;
                        EndPortBase epb;
                        EndPortImpl ep;
                        Wwn memWwn;
                        ZoneMemberBase mem = (ZoneMemberBase)allMembers[k];
                        VsanBase vsanBase = null;
                        for (VsanImpl vsan : vsans) {
                            VsanBase vBase = (VsanBase)vsan.getBaseObject();
                            if (vBase.getId() != mem.getIvrVsanId()) continue;
                            vsanBase = vBase;
                        }
                        if (vsanBase == null || (memWwn = this.getZoneMemberWwn(mem, vsanBase, fabricBase)) == null || (ep = this._sanManager.findEndPortByWwn(memWwn)) == null || !ep.isPresent() || ep.getSwitch() == null || (epb = (EndPortBase)ep.getBaseObject()) == null || (key = epb.getEndPortPK()) == null) continue;
                        IvrEndPort iep = new IvrEndPort(vsanBase, ep);
                        memberList.add(iep);
                    }
                }
                ArrayList<IvrEndPort> listSiteA = new ArrayList<IvrEndPort>();
                ArrayList<IvrEndPort> listSiteB = new ArrayList<IvrEndPort>();
                for (IvrEndPort iep : memberList) {
                    SwitchBase base;
                    String location;
                    swi = iep.getEp().getSwitch();
                    if (swi == null || swi.getBaseObject() == null || (location = (base = (SwitchBase)swi.getBaseObject()).getSysLocation()) == null || location.length() <= 0) continue;
                    if (location.equals(siteA)) {
                        listSiteA.add(iep);
                        continue;
                    }
                    if (!location.equals(siteB)) continue;
                    listSiteB.add(iep);
                }
                for (IvrEndPort iPort : listSiteA) {
                    EndPortBase ib = (EndPortBase)iPort.getEp().getBaseObject();
                    WwnKey iKey = ib.getEndPortPK();
                    for (IvrEndPort tPort : listSiteB) {
                        EndPortBase tb = (EndPortBase)tPort.getEp().getBaseObject();
                        WwnKey tKey = tb.getEndPortPK();
                        Flow f = new Flow();
                        EndDevice i = new EndDevice();
                        i.setClusterName(context.clusterName);
                        i.setFabric(context.fabric);
                        i.setSiteName(siteA);
                        i.setVsan(iPort.getVsan().getVsanPK());
                        i.setWwn(iKey._wwn.toHexString(true));
                        i.setAlias(iPort.getEp().getDeviceAlias());
                        EndDevice t = new EndDevice();
                        t.setClusterName(context.clusterName);
                        t.setFabric(context.fabric);
                        t.setSiteName(siteB);
                        t.setVsan(tPort.getVsan().getVsanPK());
                        t.setWwn(tKey._wwn.toHexString(true));
                        t.setAlias(tPort.getEp().getDeviceAlias());
                        if (!i.isInitiator() && !t.isTarget()) {
                            f.setInitiator(t);
                            f.setTarget(i);
                        } else {
                            f.setInitiator(i);
                            f.setTarget(t);
                        }
                        f.setVsanId(-1);
                        boolean found = false;
                        for (Flow fl : flowList) {
                            if (i.equals(fl.getInitiator()) && t.equals(fl.getTarget())) {
                                found = true;
                                continue;
                            }
                            if (!t.equals(fl.getInitiator()) || !i.equals(fl.getTarget())) continue;
                            found = true;
                        }
                        if (found) continue;
                        flowList.add(f);
                    }
                }
            }
        }
        return flowList;
    }

    @Override
    public ArrayList<Flow> getCandidateFlows(IOAContext context, String siteA, String siteB) throws RemoteException {
        VsanImpl[] vsans;
        ArrayList<Flow> flowList = new ArrayList<Flow>();
        FabricImpl fabric = this._sanManager.findFabric(context.fabric);
        if (fabric == null) {
            throw new RemoteException("Unable to get candidate flows, invalid fabric");
        }
        FabricBase fabricBase = fabric.getFabricBase(new short[0]);
        for (VsanImpl vsan : vsans = fabric.getVsans()) {
            VsanBase vsanBase = (VsanBase)vsan.getBaseObject();
            ZoneBase[] zoneBases = vsan.getEnforcedZones();
            List<EndPortImpl> allEndPorts = vsan.getEndPorts();
            this._Logger.debug((Object)("getCandidateFlows:  vsan " + vsan.getId() + " with " + allEndPorts.size() + " endPorts"));
            Hashtable<Wwn, EndPortImpl> iHashSiteA = new Hashtable<Wwn, EndPortImpl>();
            Hashtable<Wwn, EndPortImpl> tHashSiteA = new Hashtable<Wwn, EndPortImpl>();
            Hashtable<Wwn, EndPortImpl> iHashSiteB = new Hashtable<Wwn, EndPortImpl>();
            Hashtable<Wwn, EndPortImpl> tHashSiteB = new Hashtable<Wwn, EndPortImpl>();
            for (EndPortImpl ep : allEndPorts) {
                SwitchImpl epSwi;
                EndPortBase epbase;
                WwnKey basekey;
                if (ep == null || !ep.isPresent() || ep.getBaseObject() == null || (basekey = (epbase = (EndPortBase)ep.getBaseObject()).getEndPortPK()) == null || (epSwi = ep.getSwitch()) == null || epSwi.getBaseObject() == null) continue;
                SwitchBase base = (SwitchBase)epSwi.getBaseObject();
                String location = base.getSysLocation();
                if (ep.isIntiator() && location != null && location.length() > 0) {
                    if (location.equals(siteA)) {
                        iHashSiteA.put(basekey._wwn, ep);
                    } else if (location.equals(siteB)) {
                        iHashSiteB.put(basekey._wwn, ep);
                    }
                }
                if (!ep.isTarget() || location == null || location.length() <= 0) continue;
                if (location.equals(siteA)) {
                    tHashSiteA.put(basekey._wwn, ep);
                    continue;
                }
                if (!location.equals(siteB)) continue;
                tHashSiteB.put(basekey._wwn, ep);
            }
            this._Logger.debug((Object)("getCandidateFlows: site " + siteA + " with I=" + iHashSiteA.size() + ", T=" + iHashSiteA.size()));
            this._Logger.debug((Object)("getCandidateFlows: site " + siteB + " with I=" + iHashSiteB.size() + ", T=" + iHashSiteB.size()));
            if (zoneBases == null) continue;
            for (int j = 0; j < zoneBases.length; ++j) {
                EndDevice t;
                EndDevice i;
                Flow f;
                WwnKey tKey;
                EndPortBase tb;
                WwnKey iKey;
                EndPortBase ib;
                ZoneBase zone = zoneBases[j];
                Array members = zone.getMembers();
                this._Logger.debug((Object)("getCandidateFlows: zone " + zone.getName() + " with " + members.size() + " members"));
                if (members == null || members.getData() == null || members.size() <= 1) continue;
                ArrayList<EndPortImpl> iListSiteA = new ArrayList<EndPortImpl>();
                ArrayList<EndPortImpl> tListSiteA = new ArrayList<EndPortImpl>();
                ArrayList<EndPortImpl> iListSiteB = new ArrayList<EndPortImpl>();
                ArrayList<EndPortImpl> tListSiteB = new ArrayList<EndPortImpl>();
                E[] allMembers = members.getData();
                for (int k = 0; k < members.size(); ++k) {
                    ZoneMemberBase mem = (ZoneMemberBase)allMembers[k];
                    Wwn memWwn = this.getZoneMemberWwn(mem, vsanBase, fabricBase);
                    if (memWwn == null) continue;
                    EndPortImpl epi = (EndPortImpl)iHashSiteA.get(memWwn);
                    if (epi != null) {
                        iListSiteA.add(epi);
                        this._Logger.trace((Object)("Added " + siteA + " i=" + memWwn.toHexString(true)));
                    }
                    if ((epi = (EndPortImpl)iHashSiteB.get(memWwn)) != null) {
                        iListSiteB.add(epi);
                        this._Logger.trace((Object)("Added " + siteB + " i=" + memWwn.toHexString(true)));
                    }
                    if ((epi = (EndPortImpl)tHashSiteA.get(memWwn)) != null) {
                        tListSiteA.add(epi);
                        this._Logger.trace((Object)("Added " + siteA + " t=" + memWwn.toHexString(true)));
                    }
                    if ((epi = (EndPortImpl)tHashSiteB.get(memWwn)) == null) continue;
                    tListSiteB.add(epi);
                    this._Logger.trace((Object)("Added " + siteB + " t=" + memWwn.toHexString(true)));
                }
                if (iListSiteA.size() > 0 && tListSiteB.size() > 0) {
                    this._Logger.trace((Object)("getCandidateFlows: I in " + siteA + " = " + iListSiteA.size() + ", T in " + siteB + " = " + tListSiteB.size()));
                    for (EndPortImpl iPort : iListSiteA) {
                        ib = (EndPortBase)iPort.getBaseObject();
                        iKey = ib.getEndPortPK();
                        for (EndPortImpl tPort : tListSiteB) {
                            tb = (EndPortBase)tPort.getBaseObject();
                            tKey = tb.getEndPortPK();
                            f = new Flow();
                            i = new EndDevice();
                            i.setClusterName(context.clusterName);
                            i.setFabric(context.fabric);
                            i.setSiteName(siteA);
                            i.setVsan(vsan.getVsanPK());
                            i.setWwn(iKey._wwn.toHexString(true));
                            i.setAlias(iPort.getDeviceAlias());
                            i.setInitiator(ib.isIntiator());
                            i.setTarget(ib.isTarget());
                            t = new EndDevice();
                            t.setClusterName(context.clusterName);
                            t.setFabric(context.fabric);
                            t.setSiteName(siteB);
                            t.setVsan(vsan.getVsanPK());
                            t.setWwn(tKey._wwn.toHexString(true));
                            t.setAlias(tPort.getDeviceAlias());
                            t.setInitiator(tb.isIntiator());
                            t.setTarget(tb.isTarget());
                            f.setInitiator(i);
                            f.setTarget(t);
                            f.setVsanId(vsan.getId());
                            if (flowList.contains(f)) continue;
                            this._Logger.trace((Object)("Added candidate i=" + i.getWwn() + " t=" + t.getWwn()));
                            flowList.add(f);
                        }
                    }
                }
                if (iListSiteB.size() <= 0 || tListSiteA.size() <= 0) continue;
                this._Logger.trace((Object)("getCandidateFlows: I in " + siteB + " = " + iListSiteB.size() + ", T in " + siteA + " = " + tListSiteA.size()));
                for (EndPortImpl iPort : iListSiteB) {
                    ib = (EndPortBase)iPort.getBaseObject();
                    iKey = ib.getEndPortPK();
                    for (EndPortImpl tPort : tListSiteA) {
                        tb = (EndPortBase)tPort.getBaseObject();
                        tKey = tb.getEndPortPK();
                        if (ib.isInitiatorAndTarget() && tb.isInitiatorAndTarget()) continue;
                        f = new Flow();
                        i = new EndDevice();
                        i.setClusterName(context.clusterName);
                        i.setFabric(context.fabric);
                        i.setSiteName(siteB);
                        i.setVsan(vsan.getVsanPK());
                        i.setWwn(iKey._wwn.toHexString(true));
                        i.setAlias(iPort.getDeviceAlias());
                        i.setInitiator(ib.isIntiator());
                        i.setTarget(ib.isTarget());
                        t = new EndDevice();
                        t.setClusterName(context.clusterName);
                        t.setFabric(context.fabric);
                        t.setSiteName(siteA);
                        t.setVsan(vsan.getVsanPK());
                        t.setWwn(tKey._wwn.toHexString(true));
                        t.setAlias(tPort.getDeviceAlias());
                        t.setInitiator(tb.isIntiator());
                        t.setTarget(tb.isTarget());
                        f.setInitiator(i);
                        f.setTarget(t);
                        f.setVsanId(vsan.getId());
                        if (flowList.contains(f)) continue;
                        flowList.add(f);
                        this._Logger.trace((Object)("Added candidate i=" + i.getWwn() + " t=" + t.getWwn()));
                    }
                }
            }
        }
        ZoneBase[] ivrZoneBases = fabric.getIvrEnforcedZones();
        if (ivrZoneBases != null) {
            for (ZoneBase zone : ivrZoneBases) {
                EndDevice t;
                EndDevice i;
                Flow f;
                WwnKey tKey;
                EndPortBase tb;
                WwnKey iKey;
                ArrayList<IvrEndPort> memberList = new ArrayList<IvrEndPort>();
                Array members = zone.getMembers();
                if (members != null && members.getData() != null && members.size() > 0) {
                    E[] allMembers = members.getData();
                    for (int k = 0; k < members.size(); ++k) {
                        WwnKey key;
                        EndPortBase epb;
                        EndPortImpl ep;
                        Wwn memWwn;
                        ZoneMemberBase mem = (ZoneMemberBase)allMembers[k];
                        VsanBase vsanBase = null;
                        for (VsanImpl vsan : vsans) {
                            VsanBase vBase = (VsanBase)vsan.getBaseObject();
                            if (vBase.getId() != mem.getIvrVsanId()) continue;
                            vsanBase = vBase;
                        }
                        if (vsanBase == null || (memWwn = this.getZoneMemberWwn(mem, vsanBase, fabricBase)) == null || (ep = this._sanManager.findEndPortByWwn(memWwn)) == null || !ep.isPresent() || ep.getSwitch() == null || (epb = (EndPortBase)ep.getBaseObject()) == null || (key = epb.getEndPortPK()) == null) continue;
                        IvrEndPort iep = new IvrEndPort(vsanBase, ep);
                        memberList.add(iep);
                    }
                }
                ArrayList<IvrEndPort> iListSiteA = new ArrayList<IvrEndPort>();
                ArrayList<IvrEndPort> tListSiteA = new ArrayList<IvrEndPort>();
                ArrayList<IvrEndPort> iListSiteB = new ArrayList<IvrEndPort>();
                ArrayList<IvrEndPort> tListSiteB = new ArrayList<IvrEndPort>();
                for (IvrEndPort iep : memberList) {
                    SwitchImpl swi = iep.getEp().getSwitch();
                    if (swi == null || swi.getBaseObject() == null) continue;
                    SwitchBase base = (SwitchBase)swi.getBaseObject();
                    String location = base.getSysLocation();
                    if (iep.getEp().getEnclosure().isHost()) {
                        if (location == null || location.length() <= 0) continue;
                        if (location.equals(siteA)) {
                            iListSiteA.add(iep);
                            continue;
                        }
                        if (!location.equals(siteB)) continue;
                        iListSiteB.add(iep);
                        continue;
                    }
                    if (!iep.getEp().getEnclosure().isStorage() || location == null || location.length() <= 0) continue;
                    if (location.equals(siteA)) {
                        tListSiteA.add(iep);
                        continue;
                    }
                    if (!location.equals(siteB)) continue;
                    tListSiteB.add(iep);
                }
                for (IvrEndPort iPort : iListSiteA) {
                    EndPortBase ib = (EndPortBase)iPort.getEp().getBaseObject();
                    iKey = ib.getEndPortPK();
                    for (IvrEndPort tPort : tListSiteB) {
                        tb = (EndPortBase)tPort.getEp().getBaseObject();
                        tKey = tb.getEndPortPK();
                        f = new Flow();
                        i = new EndDevice();
                        i.setClusterName(context.clusterName);
                        i.setFabric(context.fabric);
                        i.setSiteName(siteA);
                        i.setVsan(iPort.getVsan().getVsanPK());
                        i.setWwn(iKey._wwn.toHexString(true));
                        i.setAlias(iPort.getEp().getDeviceAlias());
                        t = new EndDevice();
                        t.setClusterName(context.clusterName);
                        t.setFabric(context.fabric);
                        t.setSiteName(siteB);
                        t.setVsan(tPort.getVsan().getVsanPK());
                        t.setWwn(tKey._wwn.toHexString(true));
                        t.setAlias(tPort.getEp().getDeviceAlias());
                        f.setInitiator(i);
                        f.setTarget(t);
                        f.setVsanId(-1);
                        flowList.add(f);
                    }
                }
                for (IvrEndPort iPort : iListSiteB) {
                    EndPortBase ib = (EndPortBase)iPort.getEp().getBaseObject();
                    iKey = ib.getEndPortPK();
                    for (IvrEndPort tPort : tListSiteA) {
                        tb = (EndPortBase)tPort.getEp().getBaseObject();
                        tKey = tb.getEndPortPK();
                        if (ib.isInitiatorAndTarget() && tb.isInitiatorAndTarget()) continue;
                        f = new Flow();
                        i = new EndDevice();
                        i.setClusterName(context.clusterName);
                        i.setFabric(context.fabric);
                        i.setSiteName(siteB);
                        i.setVsan(iPort.getVsan().getVsanPK());
                        i.setWwn(iKey._wwn.toHexString(true));
                        i.setAlias(iPort.getEp().getDeviceAlias());
                        t = new EndDevice();
                        t.setClusterName(context.clusterName);
                        t.setFabric(context.fabric);
                        t.setSiteName(siteA);
                        t.setVsan(tPort.getVsan().getVsanPK());
                        t.setWwn(tKey._wwn.toHexString(true));
                        t.setAlias(tPort.getEp().getDeviceAlias());
                        f.setInitiator(i);
                        f.setTarget(t);
                        f.setVsanId(-1);
                        flowList.add(f);
                    }
                }
            }
        }
        this._Logger.debug((Object)("getCandidateFlows: returning " + flowList.size() + " candidates"));
        return flowList;
    }

    private ArrayList<LicenseInfo> getIOALicenses(SwitchImpl swi) {
        this._Logger.info((Object)("getIOALicenses sw: " + swi.getIpAddress()));
        ArrayList<LicenseInfo> licenseList = new ArrayList<LicenseInfo>();
        String[] licenses = new String[]{"IOA_184", "IOA_9222i", "IOA_SSN16", "IOA_9250"};
        WwnKey key = swi.getSwitchPK();
        if (key == null) {
            this._Logger.info((Object)"getIOALicenses no WwwKey for switch, returning");
            return licenseList;
        }
        InventoryManager im = InventoryManager.getInstance();
        List<LicenseInfo> licInfo = this.findLicense(im, key, licenses);
        if (licInfo == null || licInfo.size() == 0) {
            this._Logger.info((Object)"getIOALicenses no license found, returning");
            return licenseList;
        }
        for (LicenseInfo l : licInfo) {
            licenseList.add(l);
        }
        return licenseList;
    }

    private List<LicenseInfo> findLicense(InventoryManager imInst, WwnKey key, String[] licenses) {
        ArrayList<LicenseInfo> licInfo = new ArrayList<LicenseInfo>();
        if (imInst == null) {
            imInst = InventoryManager.getInstance();
        }
        for (String licStr : licenses) {
            LicenseInfo nextlicInfo = imInst.findLicense(key, licStr);
            if (nextlicInfo == null) continue;
            licInfo.add(nextlicInfo);
        }
        return licInfo;
    }

    private int getIfIndexIOA(int card, int port) {
        return 0x21000000 + (card - 1 << 19) + (port - 1 << 12);
    }

    private String getIfNameIOA(int ifIndex) {
        int slot = 1 + (ifIndex >> 19) & 0x1F;
        int port = 1 + (ifIndex >> 12) & 0x7F;
        return "ioa " + slot + "/" + port;
    }

    private int getIfSlotFromName(String name) {
        String[] pair;
        if (name.startsWith("ioa") && (pair = (name = name.substring(3)).split("/")).length == 2) {
            return Integer.valueOf(pair[0]);
        }
        return 0;
    }

    private int getIfPortFromName(String name) {
        String[] pair;
        if (name.startsWith("ioa") && (pair = (name = name.substring(3)).split("/")).length == 2) {
            return Integer.valueOf(pair[1]);
        }
        return 0;
    }

    private void enableFeatures(SwitchImpl swi) throws RemoteException {
        if (!swi.isFeatureEnabled(AbstractSwitchBase.Feature.CLUSTER.flag())) {
            try {
                this.snmpEnableFeature(swi, AbstractSwitchBase.Feature.CLUSTER.flag());
                swi.setFeatureEnabled(AbstractSwitchBase.Feature.CLUSTER.flag(), true);
            }
            catch (SnmpException e) {
                throw new RemoteException("Failed to enable feature cluster on switch");
            }
        }
        try {
            if (!this.snmpCheckEnabled(swi, AbstractSwitchBase.Feature.CLUSTER.flag())) {
                throw new RemoteException("Timeout waiting for feature cluster to enable, please try again");
            }
        }
        catch (SnmpException e) {
            throw new RemoteException("Failure waiting for feature cluster to enable on switch");
        }
        if (!swi.isFeatureEnabled(AbstractSwitchBase.Feature.IOA.flag())) {
            try {
                this.snmpEnableFeature(swi, AbstractSwitchBase.Feature.IOA.flag());
                swi.setFeatureEnabled(AbstractSwitchBase.Feature.IOA.flag(), true);
            }
            catch (SnmpException e) {
                throw new RemoteException("Failed to enable feature ioa on switch");
            }
        }
        try {
            if (!this.snmpCheckEnabled(swi, AbstractSwitchBase.Feature.IOA.flag())) {
                throw new RemoteException("Timeout waiting for feature ioa to enable, please try again");
            }
        }
        catch (SnmpException e) {
            throw new RemoteException("Failure waiting for feature ioa to enable on switch");
        }
    }

    private SnmpPeer getPeer(SwitchImpl swImpl) throws SnmpException {
        FabricPK fabricPK = swImpl.getFabricPK();
        SnmpUser snmpUser = this._user.getSnmpUser(fabricPK);
        this._Logger.debug((Object)("getPeer: for switch " + swImpl.getIpAddress()));
        if (snmpUser == null) {
            this._Logger.warn((Object)"getPeer(): No SNMP credential, throwing SnmpException");
            throw new SnmpException("No SNMP credential");
        }
        try {
            if (snmpUser.getSecurityModel() == 3) {
                this._Logger.debug((Object)"calling getSnmpPeer: SecurityModel is SECURITY_MODEL_USM");
            } else {
                this._Logger.debug((Object)"calling getSnmpPeer: SecurityModel not SECURITY_MODEL_USM");
            }
            SnmpPeer peer = IOAImpl.getSnmpPeer(swImpl.getInetAddress(), snmpUser, SnmpSession.getInstance());
            this._Logger.debug((Object)("getPeer: retrieved auth for " + peer.getUserName()));
            return peer;
        }
        catch (UnknownHostException e) {
            this._Logger.warn((Object)("getPeer(): UnknownHostException: " + e.getMessage()));
            throw new SnmpException(e.getMessage());
        }
    }

    static SnmpPeer getSnmpPeer(InetAddress mgmtIp, SnmpUser user, SnmpSession snmpSession) throws SnmpException, UnknownHostException {
        SnmpPeer peer = null;
        if (user.getSecurityModel() == 3) {
            UsmUser usmUser = (UsmUser)user;
            peer = new SnmpPeer(mgmtIp, snmpSession, usmUser.getUserName(), usmUser.getAuthPassword(), usmUser.getAuthProtocol(), usmUser.getPrivacyPassword(), usmUser.getPrivacyProtocol());
        } else {
            peer = new SnmpPeer(mgmtIp, snmpSession, ((CommunityUser)user).getCommunity(), null);
        }
        return peer;
    }

    private int[] getMibOid(String mibName) throws SnmpException {
        int[] oid = MibNode.get(mibName).getOid();
        if (oid == null) {
            this._Logger.warn((Object)("SnmpException: getMibOid unknown mib " + mibName));
            throw new SnmpException("unknown mib: " + mibName);
        }
        return oid;
    }

    public void snmpChangeValue(SwitchImpl sw, String mibName, String value) throws SnmpException {
        this._Logger.info((Object)("snmpChangeValue sw: " + sw.getIpAddress() + " mib: " + mibName + " value: " + value));
        int[] oid = this.getMibOid(mibName);
        SnmpPeer node = this.getPeer(sw);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setAddress(node.getAddress());
        pdu.addVar(new SnmpOID(oid, 0), new SnmpString(value));
        node.set(pdu);
    }

    public void snmpEnableFeature(SwitchImpl sw, int featureIndex) throws SnmpException {
        this._Logger.info((Object)("snmpEnableFeature sw: " + sw.getIpAddress() + " feature: " + featureIndex));
        int[] oid = this.getMibOid("cfcFeatureCtrlAction");
        SnmpPeer node = this.getPeer(sw);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setAddress(node.getAddress());
        pdu.addVar(new SnmpOID(oid, featureIndex + 1), new SnmpInt(2));
        node.set(pdu);
    }

    private boolean snmpCheckEnabled(SwitchImpl sw, int featureIndex) throws SnmpException {
        this._Logger.info((Object)("snmpCheckEnabled sw: " + sw.getIpAddress() + " feature: " + featureIndex));
        int[] _FeatureOid = this.getMibOid("cfcFeatureCtrlOpStatus");
        SnmpPeer node = this.getPeer(sw);
        VarBindList vbl = new VarBindList(1);
        vbl.add(_FeatureOid, featureIndex + 1);
        SnmpPDU pdu = new SnmpPDU(-96, vbl);
        pdu.setAddress(node.getAddress());
        for (int i = 0; i < 6; ++i) {
            try {
                Thread.sleep(1000 + 500 * i);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SnmpPDU pduRes = sw.createPeer().send(pdu);
            VarBindList vblRes = pduRes.getVariables();
            SnmpVarBind vb = vblRes.get(0);
            SnmpVar var = vb.getVar();
            if (var.getType() != 2 || ((SnmpInt)var).getValue() != 2) continue;
            this._Logger.info((Object)("snmpCheckEnabled sw: " + sw.getIpAddress() + " feature: " + featureIndex + " returning true on try: " + i));
            return true;
        }
        this._Logger.info((Object)("snmpCheckEnabled sw: " + sw.getIpAddress() + " feature: " + featureIndex + " returning false after 5 failed reads."));
        return false;
    }

    private ArrayList<IOAInterface> getSupportingInterfaces(SwitchImpl sw) {
        Card card;
        int slot;
        int[] oid;
        int oidOffset;
        this._Logger.info((Object)("getSupportingInterfaces sw: " + sw.getIpAddress()));
        ArrayList<IOAInterface> interfaceList = new ArrayList<IOAInterface>();
        InventoryManager im = InventoryManager.getInstance();
        SwitchVersion requiredVersion = new SwitchVersion("4.2(1)");
        SwitchVersion thisVersion = new SwitchVersion(sw.getVersion());
        if (thisVersion.lessThan(requiredVersion)) {
            this._Logger.info((Object)("getSupportingInterfaces running " + sw.getVersion() + " need 4.2(1), skipping"));
            return interfaceList;
        }
        List<Card> ioaCapableCards = im.findIOACapableCards(sw.getSwitchPK());
        if (ioaCapableCards.size() == 0) {
            this._Logger.info((Object)"getSupportingInterfaces: Looking for IOA capable cards, found none, returning");
            return interfaceList;
        }
        this._Logger.info((Object)("getSupportingInterfaces: Looking for IOA capable cards, found " + ioaCapableCards.size()));
        ArrayList<IOACardPort> ioaIfList = new ArrayList<IOACardPort>();
        for (Card c : ioaCapableCards) {
            if (c.getType() == 44) {
                for (int i = 1; i <= 4; ++i) {
                    IOACardPort icp = new IOACardPort();
                    icp.card = c;
                    icp.port = i;
                    ioaIfList.add(icp);
                }
                continue;
            }
            IOACardPort icp = new IOACardPort();
            icp.card = c;
            icp.port = 1;
            ioaIfList.add(icp);
        }
        SwitchBase base = (SwitchBase)sw.getBaseObject();
        String location = base.getSysLocation();
        Switch s = new Switch(sw.getFabricPK()._fid, base.getSysName(), base.getWwn().toHexString(true));
        s.setIpAddress(base.getIpAddress());
        s.setSiteName(location);
        VarBindList vbl = new VarBindList(1);
        SnmpPDU rspPdu = null;
        this._Logger.info((Object)"getSupportingInterfaces: checking cards in use by fcip");
        SnmpOID _FcipVar = new SnmpOID(MibNode.get("cfmFcipLinkExtEthIfIndex").getOid());
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_FcipVar));
        try {
            rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, 24);
            VarBindList respVbl = rspPdu.getVariables();
            for (int i = 0; i < respVbl.size(); ++i) {
                int ifIndex;
                SnmpVarBind vb = respVbl.get(i);
                SnmpVar var = vb.getVar();
                if (var.getType() != 2 || (ifIndex = ((SnmpInt)var).getValue()) == 0) continue;
                int slot2 = (ifIndex >> 19 & 0x1F) + 1;
                int port = (ifIndex >> 12 & 0x7F) + 1;
                this._Logger.info((Object)("snmpCheckEnabled sw: " + sw.getIpAddress() + " found fcip on: " + slot2 + " / " + port));
                Card card2 = im.findCard(sw.getSwitchPK(), slot2);
                if (card2 == null) continue;
                IOACardPort icp = new IOACardPort();
                icp.card = card2;
                if (card2.getType() == 44) {
                    icp.port = 1 + (port - 1) / 4;
                } else {
                    icp.port = port;
                }
                ioaIfList.remove(icp);
            }
        }
        catch (SnmpException e) {
            this._Logger.error((Object)"getSupportingInterfaces fcip check exception", (Throwable)e);
        }
        this._Logger.info((Object)"getSupportingInterfaces: checking cards in use by iscsi");
        SnmpOID _IscsiVar = new SnmpOID(MibNode.get("iscsiModuleEnableAdmin").getOid());
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_IscsiVar));
        try {
            rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, 24);
            VarBindList respVbl = rspPdu.getVariables();
            for (int i = 0; i < respVbl.size(); ++i) {
                int value;
                SnmpVarBind vb = respVbl.get(i);
                SnmpVar var = vb.getVar();
                if (var.getType() != 2 || (value = ((SnmpInt)var).getValue()) != 1) continue;
                oidOffset = _IscsiVar.getValue().length;
                int[] lastOid = null;
                oid = vb.getOid().getValue();
                if (!Arrays.equals(oid, lastOid)) {
                    int maskslot = oid[oidOffset];
                    slot = maskslot - 21;
                    this._Logger.info((Object)("snmpCheckEnabled sw: " + sw.getIpAddress() + " found iscsi on: " + slot));
                    Card card3 = im.findCard(sw.getSwitchPK(), slot);
                    if (card3 == null) continue;
                    ArrayList<IOACardPort> remList = new ArrayList<IOACardPort>();
                    for (IOACardPort cp : ioaIfList) {
                        if (!cp.card.equals(card3)) continue;
                        remList.add(cp);
                    }
                    ioaIfList.removeAll(remList);
                    continue;
                }
                break;
            }
        }
        catch (SnmpException e) {
            this._Logger.error((Object)"getSupportingInterfaces iscsi check exception", (Throwable)e);
        }
        this._Logger.info((Object)"getSupportingInterfaces: checking cards in use by sme");
        SnmpOID _SmeVar = new SnmpOID(MibNode.get("cSmeInterfaceState").getOid());
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_SmeVar));
        try {
            rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, 24);
            VarBindList respVbl = rspPdu.getVariables();
            for (int i = 0; i < respVbl.size(); ++i) {
                SnmpVarBind vb = respVbl.get(i);
                SnmpVar var = vb.getVar();
                if (var.getType() != 2) continue;
                oidOffset = _IscsiVar.getValue().length;
                int[] lastOid = null;
                oid = vb.getOid().getValue();
                if (!Arrays.equals(oid, lastOid)) {
                    int ifIndex = oid[oidOffset];
                    slot = (ifIndex >> 19 & 0x1F) + 1;
                    int port = (ifIndex >> 12 & 0x7F) + 1;
                    this._Logger.info((Object)("snmpCheckEnabled sw: " + sw.getIpAddress() + " found sme on: " + slot + " / " + port));
                    card = im.findCard(sw.getSwitchPK(), slot);
                    IOACardPort icp = new IOACardPort();
                    icp.card = card;
                    icp.port = port;
                    ioaIfList.remove(icp);
                    continue;
                }
                break;
            }
        }
        catch (SnmpException e) {
            this._Logger.error((Object)"getSupportingInterfaces sme check exception", (Throwable)e);
        }
        this._Logger.info((Object)"getSupportingInterfaces: checking cards under ssmSsnProvFeatureRowStatus");
        SnmpOID _SsmSsnFeatureVar = new SnmpOID(MibNode.get("ssmSsnProvFeatureRowStatus").getOid());
        vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(_SsmSsnFeatureVar));
        try {
            int[] oid2;
            rspPdu = SnmpFetch.getBulk(sw.createPeer(), vbl, 24);
            vbl = rspPdu.getVariables();
            oidOffset = _SsmSsnFeatureVar.getValue().length;
            int[] lastOid = null;
            for (int i = 0; i < vbl.size() && !Arrays.equals(oid2 = vbl.getVb(i).getOid().getValue(), lastOid) && oidOffset + 4 < oid2.length; ++i) {
                int j;
                int physicalIndex = oid2[oidOffset];
                int startPort = oid2[oidOffset + 1];
                int endPort = oid2[oidOffset + 2];
                String featureName = SnmpString.toString(oid2, oidOffset + 4, oid2.length);
                int slot3 = physicalIndex - 21;
                if (featureName != null) {
                    this._Logger.info((Object)("getSupportingInterfaces: found card for feature " + featureName + " at " + slot3 + " / " + startPort + "-" + endPort));
                } else {
                    this._Logger.info((Object)("getSupportingInterfaces: found card with no assigned feature at " + slot3 + " / " + startPort + "-" + endPort));
                }
                card = im.findCard(sw.getSwitchPK(), slot3);
                if (card != null) {
                    for (j = startPort; j <= endPort; ++j) {
                        IOACardPort ipc = new IOACardPort();
                        ipc.card = card;
                        ipc.port = j;
                        ioaIfList.remove(ipc);
                    }
                }
                if (featureName == null || !featureName.equals("ioa")) continue;
                for (j = startPort; j <= endPort; ++j) {
                    IOAInterface ioaIf = new IOAInterface();
                    ioaIf.setIfIndex(this.getIfIndexIOA(slot3, j));
                    ioaIf.setSwitchInfo(s);
                    ioaIf.setInterfaceId("ioa " + ioaIf.getSlot() + "/" + ioaIf.getPort());
                    ioaIf.setStatus(1);
                    interfaceList.add(ioaIf);
                    this._Logger.info((Object)("getSupportingInterfaces: added card to candiates list: " + ioaIf.getInterfaceId() + " ifIndex: " + ioaIf.getIfIndex()));
                }
            }
        }
        catch (SnmpException e) {
            this._Logger.error((Object)"getSupportingInterfaces exception", (Throwable)e);
        }
        for (IOACardPort icp : ioaIfList) {
            int slot4 = icp.card.getSlotId();
            int port = icp.port;
            IOAInterface ioaIf = new IOAInterface();
            ioaIf.setIfIndex(this.getIfIndexIOA(slot4, port));
            ioaIf.setSwitchInfo(s);
            ioaIf.setInterfaceId("unconfigured " + slot4 + "/" + port);
            ioaIf.setStatus(0);
            interfaceList.add(ioaIf);
            this._Logger.info((Object)("getSupportingInterfaces: added card to candiates list: " + ioaIf.getInterfaceId() + " ifIndex: " + ioaIf.getIfIndex()));
        }
        return interfaceList;
    }

    private void createInterfaceIOA(SwitchImpl swi, int slot, int port) throws SnmpException {
        int ifindex = this.getIfIndexIOA(slot, port);
        this._Logger.info((Object)("createInterfaceIOA sw: " + swi.getIpAddress() + " ifIndex: " + ifindex + " slot: " + slot + " port: " + port));
        int[] oid = this.getMibOid("cSanBaseSvcInterfaceRowStatus");
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(oid, ifindex), new SnmpInt(4));
        oid = this.getMibOid("ifAdminStatus");
        pdu.addVar(new SnmpOID(oid, ifindex), new SnmpInt(1));
        SnmpPeer node = this.getPeer(swi);
        node.set(pdu);
    }

    private void setInterfaceIOAStatus(SwitchImpl swi, int ifIndex, boolean doShut) throws SnmpException {
        this._Logger.info((Object)("setInterfaceIOAStatus sw: " + swi.getIpAddress() + " interface : " + this.getIfNameIOA(ifIndex) + " doShut: " + doShut));
        int[] oid = this.getMibOid("ifAdminStatus");
        SnmpOID sOid = new SnmpOID(oid, ifIndex);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        if (doShut) {
            pdu.addVar(sOid, new SnmpInt(2));
        } else {
            pdu.addVar(sOid, new SnmpInt(1));
        }
        SnmpPeer node = this.getPeer(swi);
        try {
            node.set(pdu);
        }
        catch (SnmpException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("noSuchName") > 0) {
                throw new SnmpException("Switch state mismatch.  Verify the status of the interface on the switch and refresh.", e);
            }
            throw new SnmpException("An error occured, verify the interface status on the switch and refresh", e);
        }
        VarBindList vbl = new VarBindList(1);
        vbl.add(new SnmpVarBind(sOid));
        SnmpPDU pduReq = new SnmpPDU(-96, vbl);
        boolean success = false;
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(1000L);
                SnmpPDU pduRes = node.send(pduReq);
                VarBindList vblRes = pduRes.getVariables();
                SnmpVarBind vb = vblRes.get(0);
                SnmpVar var = vb.getVar();
                if (var == null || var.getType() != 2) continue;
                int received = ((SnmpInt)var).getValue();
                if (doShut) {
                    if (received == 2) {
                        success = true;
                        break;
                    }
                    this._Logger.warn((Object)("try #" + i + " interface " + this.getIfNameIOA(ifIndex) + " set request verification failed.  expected=2 received=" + received));
                    continue;
                }
                if (received == 1) {
                    success = true;
                    break;
                }
                this._Logger.warn((Object)("try #" + i + " interface " + this.getIfNameIOA(ifIndex) + " set request verification failed.  expected=1 received=" + received));
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!success) {
            throw new SnmpException("Interface " + this.getIfNameIOA(ifIndex) + " set request validation timeout.  Refresh view and validate status.");
        }
        if (doShut) {
            this._Logger.info((Object)("Interface " + this.getIfNameIOA(ifIndex) + " shut set request verified."));
        } else {
            this._Logger.info((Object)("Interface " + this.getIfNameIOA(ifIndex) + " no shut set request verified."));
        }
    }

    class SnmpCb
    implements SnmpCallbackIf {
        Object _lock;
        ArrayList _results;
        int _requests;

        SnmpCb(Object lock, int requests) {
            this._lock = lock;
            this._results = new ArrayList();
            this._requests = requests;
        }

        boolean done() {
            return this._requests <= 0;
        }

        ArrayList getResults() {
            return this._results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
            int state = -1;
            boolean b = false;
            if (timedOut) {
                InetAddress addr = pdu.getAddress();
                state = 0;
                IOAImpl.this._Logger.info((Object)("SNMP Timeout " + addr));
            } else if (pdu.getError() != 0) {
                state = 0;
                IOAImpl.this._Logger.info((Object)("Error checking syslog srcs " + SnmpException.toError(pdu.getError()) + " from " + pdu.getAddress()));
            } else {
                this._results.add(pdu);
            }
            --this._requests;
            if (this._requests == 0) {
                Object object = this._lock;
                synchronized (object) {
                    this._lock.notifyAll();
                }
            }
        }
    }

    public class IOACardPort {
        private Card card;
        private int port;

        public Card getCard() {
            return this.card;
        }

        public int getPort() {
            return this.port;
        }

        public void setCard(Card c) {
            this.card = c;
        }

        public void setPort(int p) {
            this.port = p;
        }

        public boolean equals(Object o) {
            if (o instanceof IOACardPort) {
                IOACardPort ipc = (IOACardPort)o;
                if (ipc.card.equals(this.card) && ipc.port == this.port) {
                    return true;
                }
            }
            return false;
        }
    }
}

