/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.facade;

import com.cisco.dcbu.install.PortConfigurator;
import com.cisco.dcbu.jaxws.ep.IdentityManager;
import com.cisco.dcbu.jaxws.handler.SecurityHandler;
import com.cisco.dcbu.lib.pm.N3KBufferIfCountData;
import com.cisco.dcbu.lib.pm.PmChartInfo;
import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SessionCallback;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.event.SyslogEntry;
import com.cisco.dcbu.sm.common.model.PmAdvancePolicyBase;
import com.cisco.dcbu.sm.common.model.PmExtraOidBase;
import com.cisco.dcbu.sm.common.model.PmPolicyBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.pm.Constant;
import com.cisco.dcbu.sm.common.pm.ConvertionStatus;
import com.cisco.dcbu.sm.common.pm.PmEntityBase;
import com.cisco.dcbu.sm.common.pm.PmEventDef;
import com.cisco.dcbu.sm.common.pm.PmLinearRegression;
import com.cisco.dcbu.sm.common.rif.PMEventConsumerRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.IslPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.InventoryPersistentManager;
import com.cisco.dcbu.sm.server.event.EventControllerService;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.PmAdvancePolicyImpl;
import com.cisco.dcbu.sm.server.model.PmExtraOidImpl;
import com.cisco.dcbu.sm.server.model.PmPolicyImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.pm.N3kCollector;
import com.cisco.dcbu.sm.server.pm.PM;
import com.cisco.dcbu.sm.server.pm.PMStatistics;
import com.cisco.dcbu.sm.server.pm.PMStatisticsManager;
import com.cisco.dcbu.sm.server.pm.PmChart;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmDisplay;
import com.cisco.dcbu.sm.server.pm.PmMetaDataUtil;
import com.cisco.dcbu.sm.server.pm.pmutil.NtopIntegrator;
import com.cisco.dcbu.sm.server.pm.pmutil.PMConvertion;
import com.cisco.dcbu.sm.server.pm.pmutil.PmEventDispatcher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jrobin.core.RrdException;

public class PMImpl
implements PMRif,
Serializable {
    public static final String PM_NOT_RUNNING = "Stopped";
    public static final String PM_STOPPING = "Stopping";
    public static final String PM_STARTING = "Starting";
    public static final String PM_RUNNING = "Running";
    static final String pmEntityQuery = "select rrd_file,avg_rx,avg_tx,total_rxtx,max_rx,max_tx,total_err,total_discard,type from statistics where src_id=? and dest_id=?";
    private static final long serialVersionUID = 1L;
    static final String SEPARATOR = System.getProperty("file.separator");
    static final int POLL_INTERVAL = 300;
    static final long[] ARCH_STEPS = new long[]{300L, 1800L, 7200L, 86400L};
    private static PMImpl _Instance;
    private static String _status;
    private static Lock locker;
    private static String warningStr;
    private static String runningStr;
    public static int resetCounter;
    private static PMSessionCallbackListener pmSessionCallbackListener;
    private String webPortStr = null;

    public String getWarning() {
        return warningStr;
    }

    public String getRunning() {
        return runningStr;
    }

    public void setWarning(String warningStr) {
        PMImpl.warningStr = warningStr;
    }

    public void setRunning(String runningStr) {
        PMImpl.runningStr = runningStr;
    }

    public static PMImpl getInstance() {
        if (_Instance == null) {
            try {
                _Instance = new PMImpl();
                pmSessionCallbackListener = new PMSessionCallbackListener();
                SnmpSession.getInstance().addListener(pmSessionCallbackListener);
            }
            catch (RemoteException re) {
                System.err.println("PMImpl.getInstance() error: " + re);
            }
        }
        return _Instance;
    }

    protected PMImpl(boolean sessionB) throws RemoteException {
    }

    private PMImpl() throws RemoteException {
    }

    @Override
    public int invokeSpanWorker(int fabricId) throws RemoteException {
        try {
            NtopIntegrator.scanSD(fabricId);
            return 0;
        }
        catch (Exception ex) {
            throw new RemoteException("Span Port discover error : " + ex.getMessage());
        }
    }

    @Override
    public int invokeNtopWorker(String search) throws RemoteException {
        try {
            NtopIntegrator.scanNtop(search);
            return 0;
        }
        catch (Exception ex) {
            throw new RemoteException("Traffic Analyzer discover error : " + ex.getMessage());
        }
    }

    @Override
    public void updatePmPolicy(PmPolicyBase ppb) throws RemoteException {
        PmPolicyImpl ppi = new PmPolicyImpl(ppb);
        this.checkLicense(ppb.getFabricId());
        try {
            InventoryPersistentManager.getInstance().persistDBObject(ppi);
            PmExtraOidImpl.addCpuMemoryCollection(ppi.getBase().getFabricId());
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    private void checkLicense(long dbid) throws RemoteException {
        LicenseManager licManager = LicenseManager.getInstance();
        FabricPK fPk = null;
        try {
            int fid = PmMetaDataUtil.findFabricIdByDbId(dbid);
            fPk = new FabricPK(fid);
        }
        catch (Exception ex) {
            throw new RemoteException("fabric: " + fPk + " is not continously managed .");
        }
        boolean licensed = licManager.isFmLicensed(fPk);
        if (!licensed) {
            throw new RemoteException("fabric: " + fPk.getName() + " is not licensed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] updatePmPeriodInterval(PmAdvancePolicyBase papb, boolean preview) throws RemoteException {
        if (preview) {
            if (locker.tryLock()) {
                try {
                    String[] stringArray = this.getAffectedFiles(papb);
                    return stringArray;
                }
                finally {
                    locker.unlock();
                }
            }
            throw new RemoteException("Can not reformat database during PM initialization. Please try it later");
        }
        this.stop();
        String[] fileNames = this.getAffectedFiles(papb);
        String curDb = PmCollect.getMetaData().getDbPath();
        String backDbDir = curDb + File.separator + ".." + SEPARATOR + "backupdb";
        File backDb = new File(backDbDir);
        if (!backDb.exists()) {
            backDb.mkdir();
        }
        for (int i = 0; i < fileNames.length; ++i) {
            File file = new File(curDb + SEPARATOR + fileNames[i]);
            File toFile = new File(backDbDir + SEPARATOR + fileNames[i]);
            try {
                if (toFile.exists()) {
                    toFile.delete();
                }
                file.renameTo(toFile);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.updatePmAdvancePolicy(papb);
        this.start();
        return new String[0];
    }

    private String[] getAffectedFiles(PmAdvancePolicyBase papb) {
        File file = new File(PmCollect.getMetaData().getDbPath());
        ArrayList<String> list = new ArrayList<String>();
        if (papb.get2hourSampleDays() != PmCollect.getMetaData().get2hourSamples() || papb.get5minSampleDays() != PmCollect.getMetaData().get5minSamples() || papb.get30minSampleDays() != PmCollect.getMetaData().get30minSamples() || papb.getdailySampleDays() != PmCollect.getMetaData().getDailySamples()) {
            return file.list();
        }
        if (papb.getIslInterval() != PmCollect.getMetaData().getIslInterval()) {
            for (int i = 0; i < file.list().length; ++i) {
                if (!file.list()[i].endsWith("isl.rrd") && !file.list()[i].endsWith("isl_err.rrd")) continue;
                list.add(file.list()[i]);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public void updatePmAdvancePolicy(PmAdvancePolicyBase papb) throws RemoteException {
        try {
            PmAdvancePolicyImpl ppi = new PmAdvancePolicyImpl(papb);
            if (ppi.getBase().getUpdateType() == 1 || ppi.getBase().getUpdateType() == 4 || ppi.getBase().getUpdateType() == 5 || ppi.getBase().getUpdateType() == 6) {
                // empty if block
            }
            InventoryPersistentManager.getInstance().persistDBObject(ppi);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void deleteCollection(PmPolicyBase base) throws RemoteException {
        if (base == null) {
            return;
        }
        try {
            InventoryPersistentManager.getInstance().deleteDBObject(new PmPolicyImpl(base));
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex);
        }
    }

    @Override
    public void registerPmEvent(PmEventDef def, PMEventConsumerRif consumer) throws RemoteException {
        PmEventDispatcher pd = PmEventDispatcher.getInstance();
        pd.setEventDef(def);
        pd.setEventConsumer(consumer);
        pd.start();
    }

    @Override
    public ConvertionStatus getConvertionStatus() throws RemoteException {
        return PMConvertion.getInstance().getStatus();
    }

    @Override
    public void stopConvertion() throws RemoteException {
        try {
            PMConvertion.getInstance().stopConversion();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void updatePmExtraOid(PmExtraOidBase baseObj) throws RemoteException {
        try {
            PmExtraOidImpl ppi = new PmExtraOidImpl(baseObj);
            InventoryPersistentManager.getInstance().persistDBObject(ppi);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void deletePmExtraOid(PmExtraOidBase baseObj) throws RemoteException {
        try {
            PmExtraOidImpl ppi = new PmExtraOidImpl(baseObj);
            InventoryPersistentManager.getInstance().deleteDBObject(ppi);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    @Override
    public void restart() throws RemoteException {
        this.start();
    }

    @Override
    public void start() throws RemoteException {
        final PMImpl impl = this;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    locker.lock();
                    if (PM.isRunning()) {
                        impl.stop(false);
                    }
                    _status = PMImpl.PM_STARTING;
                    1.sleep(10000L);
                    String collectStr = PM.collect();
                    if (collectStr == null) {
                        _status = PMImpl.PM_RUNNING;
                    } else {
                        _status = "Stopped, check log for error." + collectStr;
                    }
                }
                catch (Throwable ex) {
                    PM._Logger.warn((Object)ex.toString(), ex);
                    _status = "Stopped, check log for error." + ex.getMessage();
                }
                finally {
                    locker.unlock();
                }
            }
        }.start();
        this.sendEvent("PM has been started.");
    }

    @Override
    public void stop() throws RemoteException {
        this.stop(true);
        this.sendEvent("PM has been stopped.");
    }

    public void stop(boolean needLock) throws RemoteException {
        try {
            if (needLock) {
                locker.lock();
            }
            _status = PM_STOPPING;
            PM.stop();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
        finally {
            _status = PM_NOT_RUNNING;
            if (needLock) {
                locker.unlock();
            }
        }
    }

    @Override
    public boolean isRunning() throws RemoteException {
        try {
            return PM.isRunning();
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage());
        }
    }

    private String getCurrentUsername() {
        String token = SecurityHandler.getToken();
        if (token != null) {
            return IdentityManager.getInstance().extractToken(token).getUsername();
        }
        PM._Logger.warn((Object)"Unable to get logged in Username, returning default username Admin!!!!");
        return "admin";
    }

    private void sendEvent(String msg) {
        SyslogEntry se = new SyslogEntry(FMServerImpl.getInstance().getCurrentServerInetAddr(), -1L, "DCNM-SAN", LogEventType.OTHER.toString(), this.getCurrentUsername(), msg, Severity.INFO.getValue(), 0);
        ((EventControllerService)ServiceConfig.findService("Event Controller Service")).publishAccounting(se);
    }

    @Override
    public List<PmPolicyBase> getFabricPolicy() throws RemoteException {
        List<PmPolicyImpl> implList = PmCollect.getMetaData().getFabricPolicyList();
        ArrayList<PmPolicyBase> ret = new ArrayList<PmPolicyBase>();
        if (implList == null) {
            return ret;
        }
        for (PmPolicyImpl impl : implList) {
            ret.add(impl.getBase());
        }
        return ret;
    }

    @Override
    public boolean isFabricInCollection(long fid) throws RemoteException {
        List<PmPolicyImpl> implList = PmCollect.getMetaData().getFabricPolicyList();
        if (implList == null || implList.size() == 0) {
            return false;
        }
        if (fid == -1L) {
            return true;
        }
        for (PmPolicyImpl impl : implList) {
            if (impl.getBase().getFabricId() != fid) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getStatus() throws RemoteException {
        if (this.isRunning()) {
            return "Running. " + this.getWarning() + " " + this.getRunning();
        }
        return _status;
    }

    @Override
    public double[][] getPmStats(String rrdFile, int pmType, int chartType) throws IOException, RrdException {
        return this.getPmStats(rrdFile, pmType, chartType, -1L, -1L);
    }

    public String getWebServerPort() throws RemoteException {
        if (this.webPortStr != null) {
            return this.webPortStr;
        }
        PortConfigurator pc = new PortConfigurator(ClientCache.getDcmDir(), "fm");
        String propFile = ClientCache.getDcmDir() + pc.WEB;
        try {
            pc.load(propFile);
            pc.getWebPortsFromTomcat();
        }
        catch (Exception e) {
            PM._Logger.error((Object)("getWebServerPort failed:" + propFile + " "), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        PM._Logger.info((Object)("Server.xml is loaded: scheme -- " + pc.isHTTPS() + " ::" + "port -- " + pc.getWebPort()));
        String ret = String.valueOf(pc.getWebPort());
        if (ret != null) {
            this.webPortStr = ret;
        }
        return this.webPortStr;
    }

    @Override
    public String getIslStatsUrl(PKIf pk) throws RemoteException {
        StringBuffer ret = new StringBuffer("");
        IslPK islpk = (IslPK)pk;
        try {
            List<PMStatistics> stats = PMStatistics.findPMStatistics(islpk.getSwitchIntKey1()._swPK._wwn.getValue(), islpk.getSwitchIntKey1()._index, islpk.getSwitchIntKey2()._swPK._wwn.getValue(), islpk.getSwitchIntKey2()._index);
            if (stats != null && stats.size() > 0) {
                String webPort = this.getWebServerPort();
                ret = !webPort.equals("80") ? new StringBuffer(":" + webPort + "/") : new StringBuffer("/");
                ret.append("pmreport?xml=0&rrd=" + stats.get(0).getRrdFile() + "&type=" + 1 + "&chartType=1&interval=" + "24 Hours".replaceAll(" ", "%20"));
            }
        }
        catch (SQLException ex) {
            throw new RemoteException("Can not get stats", ex);
        }
        return ret.toString();
    }

    @Override
    public String getDeviceStatsUrl(PKIf pk) throws RemoteException {
        StringBuffer ret = new StringBuffer("");
        WwnKey devicepk = (WwnKey)pk;
        try {
            List<PMStatistics> stats = PMStatistics.findPMStatistics(devicepk._wwn.getValue());
            if (stats != null && stats.size() > 0) {
                String webPort = this.getWebServerPort();
                ret = !webPort.equals("80") ? new StringBuffer(":" + webPort + "/") : new StringBuffer("/");
                ret.append("pmreport?xml=0&rrd=" + stats.get(0).getRrdFile() + "&type=" + 4 + "&chartType=1&interval=" + "24 Hours".replaceAll(" ", "%20"));
            }
        }
        catch (SQLException ex) {
            throw new RemoteException("Can not get stats", ex);
        }
        return ret.toString();
    }

    @Override
    public double[][] getPmStats(String rrdFile, int pmType, int chartType, long start, long end) throws IOException, RrdException {
        return PmChart.getPmStats(rrdFile, pmType, chartType, start, end);
    }

    @Override
    public Map<String, byte[]> getPmCharts(String rrdFile, int pmType, int chartType, long start, long end, double criticalThresholdValue, double warningThresholdValue, double yLowRng, double yUpRng) throws Exception {
        return new PmDisplay().getPmCharts(rrdFile, pmType, start, end, chartType, criticalThresholdValue, warningThresholdValue, yLowRng, yUpRng);
    }

    @Override
    public String getPmChart(String rrdFile, int pmType, int chartType) throws Exception {
        Map<String, byte[]> map = new PmDisplay().getPmCharts(rrdFile, pmType, 0L, 0L, chartType, -1.0, -1.0, -1.0, -1.0);
        Iterator<String> it = map.keySet().iterator();
        String fileName = it.next();
        return fileName.substring(fileName.lastIndexOf("www") + 1);
    }

    @Override
    public PmChartInfo getPmChartInfo(String rrdFile, int pmType, int chartType, long start, long end) throws Exception {
        return PmChart.getPmChartInfo(rrdFile, pmType, chartType, start, end);
    }

    @Override
    public PmChartInfo getPmChartInfo(String rrdFile, int pmType, int chartType) throws Exception {
        return this.getPmChartInfo(rrdFile, pmType, chartType, -1L, -1L);
    }

    @Override
    public ArrayList<N3KBufferIfCountData> getN3KBufferIfCount(long switchId, long ifIndex, long timestamp) throws Exception {
        return N3kCollector.getInstance().getCountsBySwIdAndInf(switchId, ifIndex, timestamp);
    }

    @Override
    public long[] getRealTimeStats(Map<String, String[]> map, int type) throws Exception {
        return PmChart.getRealTimeStats(map, type);
    }

    @Override
    public PmLinearRegression getLinearRegression(int dataIdx, long past, long now, String rrd, String colFun) throws Exception {
        return PMStatisticsManager.getLinearRegression(dataIdx, past, now, PMStatisticsManager.getRrdData(Constant.RRDPATH + rrd, colFun, past, now, dataIdx));
    }

    @Override
    public PmLinearRegression getLinearRegression(int dataIdx, long past, long now, String rrd, String colFun, int peakSampleSize) throws Exception {
        return PMStatisticsManager.getLinearRegression(dataIdx, past, now, PMStatisticsManager.getRrdData(Constant.RRDPATH + rrd, colFun, past, now, dataIdx), peakSampleSize);
    }

    @Override
    public Map<WwnKey, SwitchBase> getUnlicensedSwitches() throws Exception {
        HashMap<WwnKey, SwitchBase> switchLicMap = new HashMap<WwnKey, SwitchBase>();
        HashMap<String, String> licFreeMap = new HashMap<String, String>();
        String chkFreeModels = System.getProperty("check_free_models");
        if (chkFreeModels != null) {
            StringEncrypter strEncrypter = new StringEncrypter("DES", "MODELSFREEOFLICENSECHECK");
            String[] models = chkFreeModels.split(",");
            for (String model : models) {
                licFreeMap.put(strEncrypter.decrypt(model), "");
            }
        }
        FabricPK[] fpks = SanManager.getInstance().getFabricPKs();
        LicenseManager licMgr = LicenseManager.getInstance();
        for (FabricPK fpk : fpks) {
            List<SwitchBase> sbList = licMgr.getAllUnLicensedSwitches(fpk);
            for (SwitchBase sb : sbList) {
                if (licFreeMap.containsKey(sb.getModelName())) continue;
                switchLicMap.put((WwnKey)sb.getSwitchPK(), sb);
            }
        }
        return switchLicMap;
    }

    public PmEntityBase getPmEntity(String id, String dstId, int type, String name) throws Exception {
        PmEntityBase base = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt = conn.prepareStatement(pmEntityQuery);
            pstmt.setLong(1, Long.parseLong(id));
            pstmt.setLong(2, Long.parseLong(dstId));
            rs = pstmt.executeQuery();
            if (rs.next()) {
                double avgRx = rs.getDouble(2);
                double avgTx = rs.getDouble(3);
                double rxTx = rs.getDouble(4);
                double maxRx = rs.getDouble(5);
                double maxTx = rs.getDouble(6);
                double err = rs.getDouble(7);
                double discard = rs.getDouble(8);
                int pmType = rs.getInt(9);
                base = new PmEntityBase(name, type, rs.getString(1), PmMetaDataUtil.formatData(avgRx), PmMetaDataUtil.formatData(avgTx), PmMetaDataUtil.formatData(rxTx), PmMetaDataUtil.formatData(maxRx), PmMetaDataUtil.formatData(maxTx), err < 0.0 ? "n/a" : String.valueOf(err), discard < 0.0 ? "n/a" : String.valueOf(discard), pmType);
            }
        }
        catch (Exception ex) {
            try {
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                DbUtil.close(conn);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        DbUtil.close(conn);
        return base;
    }

    @Override
    public double[][] getPmChartData(String rrdFile, int pmType) throws Exception {
        return PmChart.getPmStats(rrdFile, pmType, 1);
    }

    @Override
    public double[][] getPmChartData(String rrdFile, int pmType, int interval) throws Exception {
        return PmChart.getPmStats(rrdFile, pmType, interval);
    }

    @Override
    public double[][] getPmChartData(String rrdFile, int pmType, long start, long end) throws Exception {
        return PmChart.getPmStats(rrdFile, pmType, 1, start, end);
    }

    @Override
    public double[][] getPmChartData(String rrdFile, int pmType, int chartType, long start, long end) throws Exception {
        return PmChart.getPmStats(rrdFile, pmType, chartType, start, end);
    }

    static {
        _status = PM_NOT_RUNNING;
        locker = new ReentrantLock();
        warningStr = "";
        runningStr = "";
        resetCounter = 0;
    }

    static class PMSessionCallbackListener
    extends SessionCallback {
        PMSessionCallbackListener() {
        }

        @Override
        protected void callback(int status) {
            try {
                if (status == 4099) {
                    if (resetCounter >= 3) {
                        PM._Logger.info((Object)("Restart PM..... resetSession Counter is: " + resetCounter));
                        PMImpl.getInstance().restart();
                    } else {
                        ++resetCounter;
                    }
                }
            }
            catch (Exception e) {
                PM._Logger.warn((Object)("Caught PMSessionCallbackListener exception from callback. " + e));
            }
        }
    }
}

