/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.analysis.BaseAnalysisReport;
import com.cisco.dcbu.sm.server.analysis.ReportAnalysis;
import com.cisco.dcbu.sm.server.analysis.ReportProgressTracker;
import com.cisco.dcbu.sm.server.fc.CheckThread;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FabricCheckAnalysis
extends ReportAnalysis {
    public static Logger _Logger = LogManager.getLogger((String)"FM.WebReport");
    protected static ReportAnalysis repInstance;
    public static final int MISMATCH = 0;
    public static final int MISSING = 1;
    public static final int EXTRA = 2;
    static String FILE_LOCATION;
    static final Object[][] DEFAULT_OPTIONS;
    private CheckThread checkThread;

    public static Array buildOptionsData() {
        Array<Object[]> optionsData = new Array<Object[]>();
        for (int i = 0; i < DEFAULT_OPTIONS.length; ++i) {
            optionsData.addElement(DEFAULT_OPTIONS[i]);
        }
        return optionsData;
    }

    @Override
    protected Logger getLogger() {
        return _Logger;
    }

    protected FabricCheckAnalysis() {
    }

    public static FabricCheckAnalysis getInstance() {
        if (repInstance == null) {
            repInstance = new FabricCheckAnalysis();
        }
        _Logger.debug((Object)"Instance of Fabric Analysis used");
        return (FabricCheckAnalysis)repInstance;
    }

    public static FabricCheckAnalysis newInstance() {
        return new FabricCheckAnalysis();
    }

    private boolean compareAction(WwnKey swRefPK, String strPolicy, Array optionsData, SwitchImpl[] swImpls, Array data, ReportProgressTracker prTracker, FabricPK fpk) throws Exception {
        SnmpPeer refPeer = null;
        SnmpPeer[] peers = null;
        SwitchImpl swRefImpl = SanManager.getInstance().findSwitch(swRefPK, fpk);
        SnmpPeer snmpPeer = refPeer = swRefImpl != null ? swRefImpl.getPeer() : null;
        if (swImpls != null && swImpls.length > 0) {
            ArrayList<SnmpPeer> peerLst = new ArrayList<SnmpPeer>();
            for (int k = 0; k < swImpls.length; ++k) {
                if (swImpls[k] == null || swImpls[k].getPeer() == null) continue;
                peerLst.add(swImpls[k].getPeer());
            }
            if (peerLst.size() > 0) {
                peers = peerLst.toArray(new SnmpPeer[peerLst.size()]);
            }
        }
        if (peers == null || peers.length == 0) {
            throw new Exception("No Switches avalable for comparison.");
        }
        this.checkThread = null;
        if (null != strPolicy && strPolicy.length() > 0) {
            try {
                FileInputStream pout = new FileInputStream(FILE_LOCATION + File.separator + strPolicy);
                this.checkThread = new CheckThread(refPeer, data, optionsData, pout, peers, prTracker, fpk);
            }
            catch (IOException exx) {
                throw new Exception("Failed to open file " + strPolicy + ".");
            }
        } else {
            throw new Exception("Please enter a policy file name.");
        }
        if (this.checkThread != null) {
            this.checkThread.run();
            Exception ex = this.checkThread.getExError();
            if (ex != null) {
                this.warnings.add(ex.getMessage());
            }
        }
        return true;
    }

    public void creatPolicyFile(String strPolicy, SnmpPeer refPeer, Array optionsData, ReportProgressTracker prTracker) throws Exception {
        if (null != strPolicy && strPolicy.length() > 0) {
            try {
                PrintStream pout = new PrintStream(new FileOutputStream(FILE_LOCATION + File.separator + strPolicy));
                prTracker.setCurTaskWeight(95);
                CheckThread checkThread = new CheckThread(refPeer, null, optionsData, pout, null, prTracker);
                checkThread.run();
            }
            catch (IOException exx) {
                throw new Exception("Failed to open file " + strPolicy + ".");
            }
        } else {
            throw new Exception("Please enter a policy file name.");
        }
    }

    @Override
    public void generateReportAsynchronously(int fid, String vsanPKString, Object[] param, int reportType, int rptId, long fabricDbID, long vsanDbID) {
        this.reptId = rptId;
        String strPolicy = (String)param[0];
        WwnKey refPeer = (WwnKey)param[1];
        SnmpPeer[] peers = (SnmpPeer[])param[2];
        Array optionsData = FabricCheckAnalysis.buildOptionsData();
        if (this.isReportRunning()) {
            return;
        }
        FabricCheckAnalysisGenerator repGenerator = new FabricCheckAnalysisGenerator(fid, true, strPolicy, refPeer, peers, optionsData);
        this.initNewReport();
        this.setStatus("Starting Fabric Analysis Analysis Report");
        new Thread(repGenerator).start();
    }

    @Override
    public ArrayList generateReportSynchronously(int fid, String vsanPKString, Object[] param, int reportType, long fabricDbID, long vsanDbID) {
        String strPolicy = (String)param[0];
        WwnKey refPeer = (WwnKey)param[1];
        SnmpPeer[] peers = (SnmpPeer[])param[2];
        Array optionsData = FabricCheckAnalysis.buildOptionsData();
        FabricCheckAnalysisGenerator repGenerator = new FabricCheckAnalysisGenerator(fid, false, strPolicy, refPeer, peers, optionsData);
        this.initNewReport();
        repGenerator.run();
        if (repGenerator.getThReport() == null) {
            return new ArrayList();
        }
        return repGenerator.getThReport().getReportData();
    }

    public void buildReportSynchronously(FabricPK fPk, String strPolicy, WwnKey refKey, Array optionsData, ArrayList reportList, ReportProgressTracker prTracker) throws Exception {
        FabricImpl fImpl = SanManager.getInstance().findFabric(fPk);
        if (fImpl == null) {
            throw new Exception("Invalid Data Fabric PK:" + fPk);
        }
        if (this.logUnlicensedFabric(fImpl) && this.logUnopenedFabric(fImpl)) {
            return;
        }
        try {
            Array data = new Array();
            this.compareAction(refKey, strPolicy, optionsData, this.getManagebleSwitches(fImpl), data, prTracker, fPk);
            this.buildTextReport(data, reportList, fPk);
        }
        catch (Exception ex) {
            this.warnings.add("Error:" + ex.getMessage());
            _Logger.info((Object)("Error:" + ex.getMessage()));
        }
    }

    private SwitchImpl[] getManagebleSwitches(FabricImpl fImpl) {
        ArrayList<SwitchImpl> swLst = new ArrayList<SwitchImpl>();
        SwitchImpl[] allSw = fImpl.getSwitches();
        if (allSw != null) {
            for (int i = 0; i < allSw.length; ++i) {
                if (!((SwitchBase)allSw[i].getBaseObject()).isCisco() || !allSw[i].isManageable()) continue;
                swLst.add(allSw[i]);
            }
        }
        return swLst.toArray(new SwitchImpl[swLst.size()]);
    }

    private void buildTextReport(Array data, ArrayList reportList, FabricPK fpk) {
        if (data != null) {
            for (int i = 0; i < data.size(); ++i) {
                Object[] obs = (Object[])data.elementAt(i);
                if (obs == null || obs.length <= 0) continue;
                String[] details = new String[obs.length];
                for (int j = 0; j < obs.length; ++j) {
                    SwitchImpl swImpl;
                    details[j] = "";
                    if (obs[j] == null) continue;
                    details[j] = obs[j] instanceof SnmpPeer && (swImpl = SanManager.getInstance().findSwitch(((SnmpPeer)obs[j]).getAddress(), fpk)) != null ? swImpl.toString() : obs[j].toString();
                }
                reportList.add(details);
            }
        }
    }

    public ArrayList buildReportSynchronously(int fid, String strPolicy, WwnKey refPeer, Array optionsData) throws Exception {
        ArrayList reportList = new ArrayList();
        ReportProgressTracker prTracker = new ReportProgressTracker(this);
        if (fid == -1) {
            FabricPK[] fPK = SanManager.getInstance().getFabricPKs();
            if (fPK != null) {
                for (int k = 0; k < fPK.length; ++k) {
                    prTracker.setCurTaskWeight(100 * (k + 1) / fPK.length);
                    this.buildReportSynchronously(fPK[k], strPolicy, refPeer, optionsData, reportList, prTracker);
                }
            }
        } else {
            prTracker.setCurTaskWeight(95);
            this.buildReportSynchronously(new FabricPK(fid), strPolicy, refPeer, optionsData, reportList, prTracker);
        }
        return this.buildTextReport(reportList);
    }

    public static String[] getConfigFiles() {
        String[] fileList;
        File fAnaDir = new File(FILE_LOCATION);
        if (fAnaDir.exists() && (fileList = fAnaDir.list()) != null && fileList.length > 0) {
            ArrayList<String> fileNames = new ArrayList<String>();
            for (int k = 0; k < fileList.length; ++k) {
                File tempF = new File(FILE_LOCATION + File.separator + fileList[k]);
                if (!tempF.isFile()) continue;
                fileNames.add(tempF.getName());
            }
            if (fileNames.size() > 0) {
                return fileNames.toArray(new String[fileNames.size()]);
            }
        }
        return new String[0];
    }

    public static String getConfigFilesLocation() {
        return FILE_LOCATION;
    }

    @Override
    public void stopReport() {
        super.stopReport();
        this.checkThread.isStopped = true;
    }

    static {
        FILE_LOCATION = ClientCache.getInstallLocation() + "reports" + File.separator + "fcpolicy";
        DEFAULT_OPTIONS = new Object[][]{{"Version", Boolean.TRUE, null, null, null}, {"VSAN", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"IPFC", Boolean.TRUE, null, null, null}, {"ISL", Boolean.TRUE, null, null, null}, {"FCIP", Boolean.TRUE, null, null, null}, {"FSPF", Boolean.TRUE, null, null, null}, {"Port_Channels", Boolean.TRUE, null, null, null}, {"Domain_Manager", Boolean.TRUE, null, null, null}, {"Zone_Policies", Boolean.TRUE, null, null, null}, {"NameServer_Proxy", Boolean.TRUE, null, null, null}, {"Timers_Policies", Boolean.TRUE, null, null, null}, {"VRRP", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"CallHome", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Syslog", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"AAA", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Snmp_User", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Snmp_Events", Boolean.TRUE, null, null, null}, {"Port_Security", Boolean.TRUE, null, null, null}, {"NTP_Server", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"IP_Filter", Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, null}, {"Feature", Boolean.TRUE, null, null, null}};
    }

    class FabricCheckAnalysisGenerator
    extends ReportAnalysis.RunReportThread {
        int faId;
        String strPolicy;
        WwnKey refPeer;
        SnmpPeer[] peers;
        Array optionsData;

        public FabricCheckAnalysisGenerator(int fid, boolean asynchronous, String strPolicy, WwnKey refPeer, SnmpPeer[] peers, Array optionsData) {
            super(asynchronous);
            this.faId = fid;
            this.strPolicy = strPolicy;
            this.refPeer = refPeer;
            this.peers = peers;
        }

        @Override
        protected BaseAnalysisReport doAction() throws Exception {
            FabricCheckAnalysis.this.setStopped(false);
            ArrayList data = FabricCheckAnalysis.this.buildReportSynchronously(this.faId, this.strPolicy, this.refPeer, this.optionsData == null ? FabricCheckAnalysis.buildOptionsData() : this.optionsData);
            BaseAnalysisReport znRpt = new BaseAnalysisReport(this.faId, null, -1);
            FabricCheckAnalysis.this.setReportData(znRpt);
            znRpt.setReportData(data);
            return znRpt;
        }
    }
}

