/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.server.fc.FabricCheckTable;
import com.cisco.dcbu.sm.server.fc.ResolveData;
import java.util.HashMap;
import java.util.Map;

class FabricCheckIPFCTable
extends FabricCheckTable {
    FabricCheckIPFCTable() {
    }

    @Override
    protected void compare(SnmpPeer peer, String name, Array source, Array target) {
        try {
            Integer vsanSrc;
            HashMap hmSrc = this.createMap(source);
            HashMap hmTr = this.createMap(target);
            for (Map.Entry obEntry : hmSrc.entrySet()) {
                vsanSrc = (Integer)obEntry.getKey();
                maskInfo info = (maskInfo)obEntry.getValue();
                byte[] mask = info._mask;
                Object obTr = hmTr.get(vsanSrc);
                if (null == obTr) {
                    StringBuffer miss = new StringBuffer("Missing in VSAN ");
                    miss.append(vsanSrc + ", mask " + info._varbind.getVar());
                    this.addData(peer, false, name, miss.toString(), null);
                    continue;
                }
                maskInfo infoMiss = (maskInfo)obTr;
                StringBuffer miss = new StringBuffer("Mismatch in VSAN ");
                miss.append(vsanSrc + ", mask " + info._varbind.getVar());
                if (!SnmpString.equals(mask, infoMiss._mask)) {
                    infoMiss._varbind.setVar(info._varbind.getVar());
                    Array<SnmpVarBind> varbinds = new Array<SnmpVarBind>();
                    varbinds.addElement(infoMiss._varbind);
                    StringBuffer strMsg = new StringBuffer(peer + "\t" + name + "\t" + "set ");
                    strMsg.append(MibNode.oidToName(infoMiss._varbind.getOid().getValue()));
                    strMsg.setCharAt(strMsg.length() - 1, 'x');
                    strMsg.append("  to  " + infoMiss._varbind.getVar());
                    Array<String> msgsArr = new Array<String>();
                    msgsArr.addElement(strMsg.toString());
                    this.addData(peer, true, name, miss.toString(), new ResolveData(varbinds, this._rndr, msgsArr));
                }
                hmTr.remove(vsanSrc);
            }
            for (Map.Entry obEntry : hmTr.entrySet()) {
                vsanSrc = (Integer)obEntry.getKey();
                maskInfo infoTr = (maskInfo)obEntry.getValue();
                StringBuffer extr = new StringBuffer("Extra in VSAN ");
                extr.append(vsanSrc + ", mask " + infoTr._varbind.getVar());
                if (null != this._rowAddRm) {
                    Array<SnmpVarBind> varbinds = new Array<SnmpVarBind>();
                    varbinds.addElement(new SnmpVarBind(new SnmpOID(this._rowAddRm.getValue(), infoTr._index), new SnmpInt(4)));
                }
                this.addData(peer, false, name, extr.toString(), null);
            }
        }
        catch (SnmpException ex) {
            this.addData(peer, false, name, "Invalid ip address", null);
        }
    }

    protected HashMap createMap(Array source) throws SnmpException {
        HashMap<Integer, maskInfo> hm = new HashMap<Integer, maskInfo>();
        for (int i = 0; i < source.size(); ++i) {
            int len;
            FabricCheckTable.SnmpRow sRow = (FabricCheckTable.SnmpRow)source.elementAt(i);
            int[] index = sRow._index;
            SnmpVarBind[] vars = sRow._vars;
            int type = index[1];
            if (1 == type) {
                len = 4;
            } else if (2 == type) {
                len = 16;
            } else {
                throw new SnmpException("Invalid address type in " + SnmpString.toString(index, 0, index.length));
            }
            byte[] add = new byte[len];
            for (int j = 0; j < len; ++j) {
                add[len - 1 - j] = (byte)(index[2 + j] & 0xFF);
            }
            int maskRange = (int)((SnmpUnsignedInt)vars[0].getVar()).getValue();
            byte[] msk = new byte[len];
            int unMskByte = maskRange / 8;
            for (int b = 0; b < unMskByte; ++b) {
                msk[unMskByte - 1 - b] = -1;
            }
            int MskBits = maskRange - unMskByte * 8;
            if (MskBits > 0) {
                msk[unMskByte] = (byte)(255 << 8 - MskBits);
            }
            for (int a = 0; a < len; ++a) {
                add[a] = (byte)(add[a] & msk[a]);
            }
            if (this.ifIndexToVsan(index[0]) == -1) continue;
            hm.put(new Integer(this.ifIndexToVsan(index[0])), new maskInfo(add, vars[0], index));
        }
        return hm;
    }

    public int ifIndexToVsan(int ifIndex) {
        if (ifIndex >> 24 != 8) {
            return -1;
        }
        return ifIndex & 0xFFF;
    }

    class maskInfo {
        byte[] _mask;
        SnmpVarBind _varbind;
        int[] _index;

        public maskInfo(byte[] mask, SnmpVarBind varbind, int[] index) {
            this._mask = mask;
            this._varbind = varbind;
            this._index = index;
        }
    }
}

