/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.server.fc.CheckData;
import com.cisco.dcbu.sm.server.fc.FabricCheckTable;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

abstract class FabricCheckIslBase
extends FabricCheckTable {
    HashMap _peerToSnmpInfo = new HashMap();
    HashMap _peerToIfIndexLst = new HashMap();
    Array _islLnks = new Array();
    boolean _ignoreIsls;

    FabricCheckIslBase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doIt(SnmpPeer peer, Array peers, String category, CheckData chkAttrs, Array data, String rowAddRm, Node rtNd) throws SnmpException {
        String[] attrs = chkAttrs._attrs;
        this._data = data;
        this._attrName = category;
        this._rndr = chkAttrs._rndr;
        Array localPeers = new Array();
        int maxPeers = peers.size();
        for (int i = 0; i < maxPeers; ++i) {
            localPeers.addElement(peers.elementAt(0));
        }
        this._peers = localPeers;
        if (peer != null) {
            this._peers.addElement(peer);
        }
        this._enums = new MibEnum[attrs.length][];
        for (FabricImpl f : SanManager.getInstance().getFabrics()) {
            IslImpl[] fisl = f.getIsls();
            int maxj = fisl.length;
            for (int j = 0; j < maxj; ++j) {
                this._islLnks.addElement(fisl[j]);
            }
        }
        this.filterSelIsllist();
        this._peerToSnmpInfo.clear();
        this._peerToIfIndexLst.clear();
        if (!(this._ignoreIsls || null != this._islLnks && this._islLnks.size() != 0)) {
            return;
        }
        this.populatePeerIfIndex();
        this._numReqs = this._peerToIfIndexLst.size();
        if (this._ignoreIsls || this._numReqs > 0) {
            this.getData(attrs);
            if (this.waitAllowed()) {
                try {
                    Array i = this._data;
                    synchronized (i) {
                        this._data.wait(24000L);
                    }
                }
                catch (Exception ex) {
                    _Logger.debug((Object)"Wait broken");
                }
            }
            this.populateDiscrepancyTable(this._islLnks);
        }
    }

    protected void filterSelIsllist() throws SnmpException {
    }

    protected boolean waitAllowed() {
        return true;
    }

    protected void populatePeerIfIndex() throws SnmpException {
        int MAXL = this._islLnks.size();
        for (int il = 0; il < MAXL; ++il) {
            IslImpl lk = (IslImpl)this._islLnks.elementAt(il);
            if (!this.validateLink(lk)) continue;
            SwitchImpl swA = lk.getSwitch1();
            SwitchImpl swB = lk.getSwitch2();
            if (!swA.isMDS() || !swA.isManageable() || !swB.isMDS() || !swB.isManageable()) continue;
            int[] toIndex = new int[1];
            int[] fromIndex = new int[]{lk.getIfIndex1()};
            toIndex[0] = lk.getIfIndex2();
            SnmpPeer toPeer = swB.getPeer();
            SnmpPeer fromPeer = swA.getPeer();
            if (this._peers.findEquals(toPeer) == -1 || this._peers.findEquals(fromPeer) == -1) continue;
            Object toOb = this._peerToIfIndexLst.get(toPeer);
            if (null != toOb) {
                Array toLst = (Array)toOb;
                if (toLst.find(toIndex) == -1) {
                    toLst.addElement(toIndex);
                }
            } else {
                Array<int[]> arLst = new Array<int[]>();
                arLst.addElement(toIndex);
                this._peerToIfIndexLst.put(toPeer, arLst);
            }
            Object fromOb = this._peerToIfIndexLst.get(fromPeer);
            if (null != fromOb) {
                Array fromLst = (Array)fromOb;
                if (fromLst.find(fromIndex) != -1) continue;
                fromLst.addElement(fromIndex);
                continue;
            }
            Array<int[]> arLst = new Array<int[]>();
            arLst.addElement(fromIndex);
            this._peerToIfIndexLst.put(fromPeer, arLst);
        }
    }

    protected void getData(String[] attrs) throws SnmpException {
        Array<int[]> arOid = new Array<int[]>();
        for (int i = 0; i < attrs.length; ++i) {
            MibNode node = MibNode.get(attrs[i]);
            this._enums[i] = node.getEnums();
            int[] oid = node.getOid();
            arOid.addElement(oid);
        }
        for (Map.Entry obEntry : this._peerToIfIndexLst.entrySet()) {
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            Array indices = (Array)obEntry.getValue();
            VarBindList request = new VarBindList();
            int MAXIND = indices.size();
            for (int ind = 0; ind < MAXIND; ++ind) {
                int[] indice = (int[])indices.elementAt(ind);
                int MAXOID = arOid.size();
                for (int oids = 0; oids < MAXOID; ++oids) {
                    int[] oid = (int[])arOid.elementAt(oids);
                    request.add(new SnmpVarBind(new SnmpOID(oid, this.getModIndex(indice[0]))));
                }
            }
            new SnmpFetch().get(obHmKey, request, this);
        }
    }

    public int getModIndex(int index) {
        return index;
    }

    @Override
    void handleCallBack(SnmpPeer peer, SnmpPDU pdu) {
        VarBindList vbLst = pdu.getVariables();
        if (vbLst.size() > 0) {
            Array<SnmpVarBind> arVlst = new Array<SnmpVarBind>(vbLst.size());
            int maxik = vbLst.size();
            for (int ik = 0; ik < maxik; ++ik) {
                arVlst.addElement(vbLst.get(ik));
            }
            this._peerToSnmpInfo.put(peer, arVlst);
        }
    }

    protected void populateDiscrepancyTable(Array islLnks) {
        int MAXL = islLnks.size();
        for (int il = 0; il < MAXL; ++il) {
            long ifIndex;
            int[] oid;
            SnmpVarBind theData;
            int ivl;
            IslImpl lk = (IslImpl)islLnks.elementAt(il);
            if (!this.validateLink(lk)) continue;
            SwitchImpl swFrom = lk.getSwitch1();
            SwitchImpl swTo = lk.getSwitch2();
            if (!swFrom.isMDS() || !swFrom.isManageable() || !swTo.isMDS() || !swTo.isManageable()) continue;
            int prtFrom = lk.getIfIndex1();
            int prtTo = lk.getIfIndex2();
            int fromIfIndex = prtFrom;
            int toIfIndex = prtTo;
            SnmpPeer toPeer = swTo.getPeer();
            SnmpPeer fromPeer = swFrom.getPeer();
            if (null == toPeer || null == fromPeer) continue;
            Array toVsanData = (Array)this._peerToSnmpInfo.get(toPeer);
            Array fromVsanData = (Array)this._peerToSnmpInfo.get(fromPeer);
            if (null == toVsanData || null == fromVsanData) continue;
            int matchToId = -1;
            int matchFromId = -1;
            int MAXVL = toVsanData.size();
            for (ivl = 0; ivl < MAXVL; ivl += this._enums.length) {
                theData = (SnmpVarBind)toVsanData.elementAt(ivl);
                oid = theData.getOid().getValue();
                ifIndex = oid[oid.length - 1];
                if (ifIndex != (long)this.getModIndex(toIfIndex)) continue;
                matchToId = ivl;
                break;
            }
            MAXVL = fromVsanData.size();
            for (ivl = 0; ivl < MAXVL; ivl += this._enums.length) {
                theData = (SnmpVarBind)fromVsanData.elementAt(ivl);
                oid = theData.getOid().getValue();
                ifIndex = oid[oid.length - 1];
                if (ifIndex != (long)this.getModIndex(fromIfIndex)) continue;
                matchFromId = ivl;
                break;
            }
            if (-1 == matchToId || -1 == matchFromId) continue;
            this.checkDiscrepancy(toVsanData, matchToId, fromVsanData, matchFromId, toPeer, fromPeer);
        }
    }

    public boolean validateLink(IslImpl lk) {
        return lk != null && lk.isPresent();
    }

    protected abstract void checkDiscrepancy(Array var1, int var2, Array var3, int var4, SnmpPeer var5, SnmpPeer var6);
}

