/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.fc;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.mds.PortInterfaceUtil;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.server.fc.FabricCheckIslBase;
import com.cisco.dcbu.sm.server.fc.ResolveData;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.util.HashMap;
import java.util.Map;

class FabricCheckIslTable
extends FabricCheckIslBase {
    Array _newSelList = new Array();
    HashMap _peerToIsl = new HashMap();
    boolean _filterInProgress;

    FabricCheckIslTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void filterSelIsllist() throws SnmpException {
        this._newSelList.clear();
        this.buildPeerIsl();
        this._numReqs = this._peerToIsl.size();
        int[] oid = MibNode.get("fcIfOperMode").getOid();
        this._filterInProgress = true;
        for (Map.Entry obEntry : this._peerToIsl.entrySet()) {
            SnmpPeer obHmKey = (SnmpPeer)obEntry.getKey();
            Array indices = (Array)obEntry.getValue();
            VarBindList request = new VarBindList();
            int MAXIND = indices.size();
            for (int ind = 0; ind < MAXIND; ++ind) {
                IslImpl indice = (IslImpl)indices.elementAt(ind);
                request.add(new SnmpVarBind(new SnmpOID(oid, this.getModIndex(indice.getIfIndex1()))));
            }
            new SnmpFetch().get(obHmKey, request, this);
        }
        try {
            Array itr = this._newSelList;
            synchronized (itr) {
                this._newSelList.wait(24000L);
            }
        }
        catch (Exception ex) {
            _Logger.debug((Object)"Wait broken");
        }
        this._filterInProgress = false;
        this._islLnks = this._newSelList;
    }

    protected HashMap buildPeerIsl() throws SnmpException {
        this._peerToIsl.clear();
        int MAXL = this._islLnks.size();
        for (int il = 0; il < MAXL; ++il) {
            IslImpl lk = (IslImpl)this._islLnks.elementAt(il);
            if (!this.validateLink(lk)) continue;
            SwitchImpl swA = lk.getSwitch1();
            SwitchImpl swB = lk.getSwitch2();
            if (!swA.isMDS() || !swA.isManageable() || !swB.isMDS() || !swB.isManageable()) continue;
            int[] toIndex = new int[1];
            int[] fromIndex = new int[]{lk.getIfIndex1()};
            toIndex[0] = lk.getIfIndex2();
            SnmpPeer toPeer = swB.getPeer();
            SnmpPeer fromPeer = swA.getPeer();
            if (this._peers.findEquals(toPeer) == -1 || this._peers.findEquals(fromPeer) == -1) continue;
            Object fromOb = this._peerToIsl.get(fromPeer);
            if (null != fromOb) {
                Array fromLst = (Array)fromOb;
                if (fromLst.find(fromIndex) != -1) continue;
                fromLst.addElement(lk);
                continue;
            }
            Array<IslImpl> arLst = new Array<IslImpl>();
            arLst.addElement(lk);
            this._peerToIsl.put(fromPeer, arLst);
        }
        return this._peerToIsl;
    }

    @Override
    protected void checkDiscrepancy(Array toData, int toIndex, Array fromData, int fromIndex, SnmpPeer toPeer, SnmpPeer fromPeer) {
        Array<String> msg;
        String info;
        SnmpString vsan4K;
        SnmpString vsan2K;
        SnmpVarBind toVarBndDat = (SnmpVarBind)toData.elementAt(toIndex);
        int[] oid = toVarBndDat.getOid().getValue();
        long toIfIndex = oid[oid.length - 1];
        SnmpVarBind fromVarBndDat = (SnmpVarBind)fromData.elementAt(fromIndex);
        oid = fromVarBndDat.getOid().getValue();
        long fromIfIndex = oid[oid.length - 1];
        String toIfIndexName = "";
        String fromIfIndexName = "";
        int[] from2KOid = null;
        int[] from4KOid = null;
        int[] to2KOid = null;
        int[] to4KOid = null;
        toIfIndexName = SanManager.getInstance().findSwitchByIP(toPeer.getAddress()).ifIndexToName((int)toIfIndex);
        fromIfIndexName = SanManager.getInstance().findSwitchByIP(fromPeer.getAddress()).ifIndexToName((int)fromIfIndex);
        SnmpString toVsn = null;
        SnmpString fromVsn = null;
        SnmpVarBind the2KData = (SnmpVarBind)toData.elementAt(toIndex);
        SnmpVarBind the4KData = (SnmpVarBind)toData.elementAt(toIndex + 1);
        to2KOid = the2KData.getOid().getValue();
        to4KOid = the4KData.getOid().getValue();
        SnmpString vsn2K = (SnmpString)the2KData.getVar();
        SnmpString vsn4K = (SnmpString)the4KData.getVar();
        try {
            toVsn = PortInterfaceUtil.getInstance(1).getVsan(vsn2K, vsn4K, true);
        }
        catch (Exception ex) {
            return;
        }
        the2KData = (SnmpVarBind)fromData.elementAt(fromIndex);
        the4KData = (SnmpVarBind)fromData.elementAt(fromIndex + 1);
        from2KOid = the2KData.getOid().getValue();
        from4KOid = the4KData.getOid().getValue();
        vsn2K = (SnmpString)the2KData.getVar();
        vsn4K = (SnmpString)the4KData.getVar();
        try {
            fromVsn = PortInterfaceUtil.getInstance(1).getVsan(vsn2K, vsn4K, true);
        }
        catch (Exception ex) {
            return;
        }
        if (null == toVsn || null == fromVsn) {
            return;
        }
        MissingAllowedVsan theMissingByte = this.getMissingVsan(toVsn.getValue(), fromVsn.getValue());
        if (null != theMissingByte._toVsan) {
            Array<SnmpVarBind> toVarBnd = new Array<SnmpVarBind>();
            vsan2K = PortInterfaceUtil.getInstance(1).get2KString(theMissingByte._combinedVsanList);
            vsan4K = PortInterfaceUtil.getInstance(1).get4KString(theMissingByte._combinedVsanList);
            toVarBnd.addElement(new SnmpVarBind(new SnmpOID(to2KOid), vsan2K));
            toVarBnd.addElement(new SnmpVarBind(new SnmpOID(to4KOid), vsan4K));
            info = "ISL " + toIfIndexName + "-" + fromPeer + ":" + fromIfIndexName + " missing VSAN " + theMissingByte._toVsanList;
            msg = new Array<String>();
            msg.addElement(toPeer + ": adding VSANs " + theMissingByte._toVsanList);
            msg.addElement("  to ISL port " + toIfIndexName);
            this.addData(toPeer, true, this._attrName, info, new ResolveData(toVarBnd, this._rndr, msg));
        }
        if (null != theMissingByte._fromVsan) {
            Array<SnmpVarBind> fromVarBnd = new Array<SnmpVarBind>();
            vsan2K = PortInterfaceUtil.getInstance(1).get2KString(theMissingByte._combinedVsanList);
            vsan4K = PortInterfaceUtil.getInstance(1).get4KString(theMissingByte._combinedVsanList);
            fromVarBnd.addElement(new SnmpVarBind(new SnmpOID(from2KOid), vsan2K));
            fromVarBnd.addElement(new SnmpVarBind(new SnmpOID(from4KOid), vsan4K));
            info = "ISL " + fromIfIndexName + "-" + toPeer + ":" + toIfIndexName + " missing VSAN " + theMissingByte._fromVsanList;
            msg = new Array();
            msg.addElement(fromPeer + ": adding VSANs " + theMissingByte._fromVsanList);
            msg.addElement("  to ISL port " + fromIfIndexName);
            this.addData(fromPeer, true, this._attrName, info, new ResolveData(fromVarBnd, this._rndr, msg));
        }
    }

    protected MissingAllowedVsan getMissingVsan(byte[] toVsan, byte[] fromVsan) {
        if (toVsan.length != fromVsan.length) {
            return null;
        }
        MissingAllowedVsan missVsan = new MissingAllowedVsan();
        int vsanbase = 1;
        byte[] commonMissingVsan = new byte[toVsan.length];
        byte[] toMissingVsan = null;
        byte[] fromMissingVsan = null;
        int ns = 0;
        int NSMAX = toVsan.length;
        while (ns < NSMAX) {
            byte fmbt;
            commonMissingVsan[ns] = (byte)(toVsan[ns] & fromVsan[ns]);
            byte tobt = (byte)(toVsan[ns] ^ commonMissingVsan[ns]);
            if (tobt != 0) {
                if (null == fromMissingVsan) {
                    fromMissingVsan = new byte[toVsan.length];
                }
                fromMissingVsan[ns] = tobt;
            }
            if ((fmbt = (byte)(fromVsan[ns] ^ commonMissingVsan[ns])) != 0) {
                if (null == toMissingVsan) {
                    toMissingVsan = new byte[toVsan.length];
                }
                toMissingVsan[ns] = fmbt;
            }
            ++ns;
            vsanbase += 8;
        }
        missVsan._fromVsan = fromMissingVsan;
        missVsan._toVsan = toMissingVsan;
        if (null != fromMissingVsan) {
            missVsan._fromVsanList = SnmpBitmap.toString(fromMissingVsan);
        }
        if (null != toMissingVsan) {
            missVsan._toVsanList = SnmpBitmap.toString(toMissingVsan);
        }
        missVsan._combinedVsanList = new byte[toVsan.length];
        NSMAX = toVsan.length;
        for (ns = 0; ns < NSMAX; ++ns) {
            missVsan._combinedVsanList[ns] = (byte)(toVsan[ns] | fromVsan[ns]);
        }
        return missVsan;
    }

    @Override
    public boolean validateLink(IslImpl lk) {
        return super.validateLink(lk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleCallBack(SnmpPeer peer, SnmpPDU pdu) {
        if (!this._filterInProgress) {
            super.handleCallBack(peer, pdu);
        } else {
            Array islAr = (Array)this._peerToIsl.get(peer);
            VarBindList varAr = pdu.getVariables();
            int maxi = islAr.size();
            for (int i = 0; i < maxi; ++i) {
                SnmpInt ifOperMode = (SnmpInt)varAr.getVb(i).getVar();
                if (ifOperMode.getValue() != 12) continue;
                Array array = this._newSelList;
                synchronized (array) {
                    this._newSelList.addElement(islAr.elementAt(i));
                    continue;
                }
            }
        }
    }

    class MissingAllowedVsan {
        String _toVsanList;
        String _fromVsanList;
        byte[] _toVsan;
        byte[] _fromVsan;
        byte[] _combinedVsanList;

        MissingAllowedVsan() {
        }
    }
}

