/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.flexattach;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class BasicRunnable
implements Runnable {
    static final int[] _ifAdminStatusOid = MibNode.get("ifAdminStatus").getOid();
    static final int[] _cfsPendingConfOwnerIDTypeOid = MibNode.get("cfsPendingConfOwnerIDType").getOid();
    static final int[] _cfsPendingConfOwnerAddrTypeOid = MibNode.get("cfsPendingConfOwnerAddrType").getOid();
    static final int[] _cfsPendingConfOwnerAddrOid = MibNode.get("cfsPendingConfOwnerAddr").getOid();
    static final int[] _cfsPendingConfOwnerIDOid = MibNode.get("cfsPendingConfOwnerID").getOid();
    static final int[] _FlexAttachCFSOwnerIndex = new int[]{11, 102, 108, 101, 120, 45, 97, 116, 116, 97, 99, 104, 1};
    static final int[] _cfsFeatureOpActionOid = MibNode.get("cfsFeatureOpAction").getOid();
    static final int[] _cfsFeatureOpScopeTypeOid = MibNode.get("cfsFeatureOpScopeType").getOid();
    static final int[] _cfsFeatureOpScopeValOid = MibNode.get("cfsFeatureOpScopeVal").getOid();
    static final int[] _cfsFeatureOpLastActionResultOid = MibNode.get("cfsFeatureOpLastActionResult").getOid();
    static final int[] _cfsFeatureOpLastFailureReasonOid = MibNode.get("cfsFeatureOpLastFailureReason").getOid();
    static final int[] _cfsFeatureOpLastActionOid = MibNode.get("cfsFeatureOpLastAction").getOid();
    static final int[] _FlexAttachCFSIndex = new int[]{11, 102, 108, 101, 120, 45, 97, 116, 116, 97, 99, 104};
    static final int INPROGRESS = 4;
    static final int FAILURE = 3;
    static VarBindList _PollVbl = null;
    static VarBindList _LockOwnerVbl = null;
    public static final int PORT_ADMIN_STATUS_UP = 1;
    public static final int PORT_ADMIN_STATUS_DOWN = 2;
    public static final int NP_PORT_MODE = 16;
    public static final int AUTO_PORT_MODE = 1;
    public static final int F_PORT_MODE = 2;
    public static final String SUCCESSFUL = "Successful";
    public static final int COMMIT = 4;
    public static final int ABORT = 5;
    public static final int CLEAR = 6;
    public static final int NOOP = 0;
    public static final int LOCK_CLEAR = 0;
    public static final int LOCK_OWNER_MATCH = 1;
    public static final int LOCK_PENDING = 2;
    public boolean _isOK = true;
    public boolean _isExceptionClear = false;
    static Integer _timeout;
    static Integer _retries;
    static Logger _logger;
    static final int DISABLE_FEATURE = 3;
    static final int ENABLE_FEATURE = 2;
    static final int FEATURE_ENABLED = 2;
    static final int ACTION_RESULT_INPROGRESS = 4;

    public BasicRunnable() {
        _timeout = Integer.getInteger("snmp.timeout");
        _retries = Integer.getInteger("snmp.retries");
        this.buildPollVbl();
        this.buildLockOwnerVbl();
        this._isOK = true;
        this._isExceptionClear = false;
    }

    protected SnmpPeer generatePeer(SwitchBase sw, SnmpUserOpt snmpUserOpt) throws SnmpException {
        if (sw == null) {
            throw new IllegalArgumentException("Switch can not be null");
        }
        SnmpPeer peer = SnmpPeer.getSnmpPeer(sw.getInetAddress(), SnmpSession.getInstance(), snmpUserOpt);
        if (_timeout != null) {
            SnmpPeer._Timeout = _timeout;
        }
        if (_retries != null) {
            SnmpPeer._Retries = (short)_retries.intValue();
        }
        peer.setLogger(_logger);
        return peer;
    }

    public static boolean isCFSPending(SnmpPeer peer, SnmpPeer remotePeer) {
        SnmpPDU resp;
        VarBindList varList = new VarBindList();
        varList.add(_cfsPendingConfOwnerIDTypeOid, _FlexAttachCFSOwnerIndex);
        boolean isPending = true;
        try {
            resp = SnmpFetch.get(peer, varList);
            isPending = resp.getVariables().get(0).getVar().getType() == 5 ? false : SnmpOID.startsWith(resp.getVariables().get(0).getOid().getValue(), _cfsPendingConfOwnerIDTypeOid);
        }
        catch (SnmpException ex) {
            return isPending;
        }
        if (!isPending && remotePeer != null && !peer.equals(remotePeer)) {
            varList.clear();
            varList.add(_cfsPendingConfOwnerIDTypeOid);
            try {
                resp = SnmpFetch.get(remotePeer, varList);
                isPending = resp.getVariables().get(0).getVar().getType() == 5 ? false : SnmpOID.startsWith(resp.getVariables().get(0).getOid().getValue(), _cfsPendingConfOwnerIDTypeOid);
            }
            catch (SnmpException ex) {
                return isPending;
            }
        }
        return isPending;
    }

    void buildPollVbl() {
        _PollVbl = new VarBindList();
        _PollVbl.add(_cfsFeatureOpLastActionResultOid, _FlexAttachCFSIndex);
        _PollVbl.add(_cfsFeatureOpLastFailureReasonOid, _FlexAttachCFSIndex);
        _PollVbl.add(_cfsFeatureOpLastActionOid, _FlexAttachCFSIndex);
    }

    void buildLockOwnerVbl() {
        _LockOwnerVbl = new VarBindList();
        _LockOwnerVbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerAddrTypeOid, _FlexAttachCFSIndex)));
        _LockOwnerVbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerAddrOid, _FlexAttachCFSIndex)));
        _LockOwnerVbl.add(new SnmpVarBind(new SnmpOID(_cfsPendingConfOwnerIDOid, _FlexAttachCFSIndex)));
    }

    void doPoll(SnmpPeer peer, int commandToCheck, String errMsg) throws Exception {
        int timeout;
        if (_PollVbl == null) {
            this.buildPollVbl();
        }
        boolean isTimeout = true;
        int timer = timeout = 60;
        int state = commandToCheck;
        for (int i = 0; i < timer; ++i) {
            SnmpPDU resp = null;
            try {
                resp = SnmpFetch.get(peer, _PollVbl);
            }
            catch (SnmpException ex) {
                throw new Exception(errMsg + "; " + ex.getMessage());
            }
            if (resp == null) {
                throw new Exception(errMsg + "; failed to verify cfs commit status.");
            }
            VarBindList respList = resp.getVariables();
            int result = respList.intValue(0);
            _logger.debug((Object)("BassicRunnable/doPoll result/state = " + result + "/" + state));
            if (result == 4) {
                Thread.sleep(3000L);
                continue;
            }
            if (result == 3) {
                if (state == 4) {
                    _logger.debug((Object)"BassicRunnable/doPoll cfs commit failed, will do abort");
                    state = 5;
                    VarBindList varList = new VarBindList();
                    varList.add(_cfsFeatureOpActionOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(5));
                    varList.add(_cfsFeatureOpScopeTypeOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(1));
                    varList.add(_cfsFeatureOpScopeValOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpString(new byte[0]));
                    SnmpFetch.set(peer, varList);
                    timer = i + timeout;
                    continue;
                }
                _logger.debug((Object)"BassicRunnable/doPoll cfs abort failed");
                throw new Exception(errMsg + "; cfs abort failed.");
            }
            isTimeout = false;
            break;
        }
        if (isTimeout) {
            String stateString = state == 4 ? "commit" : "abort";
            _logger.debug((Object)("BassicRunnable/doPoll cfs " + stateString + " failed"));
            throw new Exception(errMsg + "; cfs " + stateString + " status polling timedout.");
        }
    }

    int isCFSLockHeld(SnmpPeer peer) throws SnmpException {
        SnmpPDU lockPDU;
        VarBindList lockVl;
        if (_LockOwnerVbl == null) {
            this.buildLockOwnerVbl();
        }
        if ((lockVl = (lockPDU = SnmpFetch.getBulk(peer, 5 * _LockOwnerVbl.size(), _LockOwnerVbl)).getVariables()).size() == 0) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"BasicRunnable::isCFSLockHeld table empty LOCK_CLEAR");
            }
            return 0;
        }
        for (int m = 0; m < lockPDU.getVariables().size(); m += 3) {
            int type = lockVl.intValue(m);
            if (type == 1) {
                String ipAddress = SnmpIpAddress.toString(lockVl.byteValue(m + 1));
                String user = ((SnmpString)lockPDU.getVariables().get(m + 2).getVar()).toString();
                try {
                    if (peer.getAddress().equals(InetAddress.getByAddress(lockVl.byteValue(m + 1)))) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)"BasicRunnable::isCFSLockHeld ipv4 ownerType LOCAK_OWNER_MATCH");
                        }
                        return 1;
                    }
                }
                catch (UnknownHostException ex) {}
                continue;
            }
            SnmpString lockDns = new SnmpString(lockVl.byteValue(m + 1));
            String ipAddress = lockDns.toString();
            String user = ((SnmpString)lockPDU.getVariables().get(m + 2).getVar()).toString();
            try {
                InetAddress addr = InetAddress.getByName(ipAddress);
                if (!addr.equals(peer.getAddress())) continue;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"BasicRunnable::isCFSLockHeld dns ownerType LOCAK_OWNER_MATCH");
                }
                return 1;
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"BasicRunnable::isCFSLockHeld LOCK_PENDING");
        }
        return 2;
    }

    StringBuffer handleSetConfigException(SwitchBase sw, SnmpPeer peer, VarBindList varList, SnmpException ex) throws Exception {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)"BasicRunnable::handleSetConfigException SET/commit failed");
        }
        StringBuffer errString = new StringBuffer(peer.toString());
        errString.append(": ");
        int errIndex = ex.getErrorIndex();
        if (errIndex != -1) {
            int dashOffset = ex.getMessage().lastIndexOf(45);
            if (dashOffset != -1) {
                errString.append(ex.getMessage().substring(0, dashOffset));
            } else {
                errString.append(ex.getMessage());
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("BasicRunnable::handleSetConfigException ex=" + ex + " , err object=" + peer + " " + errString.toString()));
            }
        } else {
            errString.append(ex.getMessage());
        }
        int cfsAction = 0;
        try {
            int cfsLockStatus = this.isCFSLockHeld(peer);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("BasicRunnable::handleSetConfigException isCFSLockHeld = " + cfsLockStatus + "(0:clear;1:match;2:pending)"));
            }
            if (cfsLockStatus == 1) {
                cfsAction = 5;
            } else if (cfsLockStatus == 2) {
                errString.append(";cfs lock by other switch.");
                throw new Exception(errString.toString());
            }
        }
        catch (Exception ex1) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("BasicRunnable::handleSetConfigException isCFSLockHeld, ex1=" + ex1 + " , will do cfs clear"));
            }
            cfsAction = 6;
        }
        if (cfsAction != 0) {
            String actionString = MibEnum.getLabel(MibNode.get("cfsFeatureOpAction").getEnums(), cfsAction);
            try {
                VarBindList varList1 = new VarBindList();
                varList1.add(_cfsFeatureOpActionOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(cfsAction));
                varList1.add(_cfsFeatureOpScopeTypeOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpInt(1));
                varList1.add(_cfsFeatureOpScopeValOid, _FlexAttachCFSIndex, (SnmpVar)new SnmpString(new byte[0]));
                SnmpFetch.set(peer, varList1);
            }
            catch (SnmpException ex1) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("BasicRunnable::handleSetConfigException cfs " + actionString + " failed, ex=" + ex1));
                }
                errString.append(";cfs action " + actionString + " SET failed.");
                throw new Exception(errString.toString());
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("BasicRunnable::handleSetConfigException SET cfs " + actionString));
            }
            errString.append(";cfs " + actionString + ".");
            this.doPoll(peer, cfsAction, errString.toString());
        }
        return errString;
    }

    static {
        _logger = LogManager.getLogger((String)"fms.flexAttach");
    }
}

