/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.flexattach;

import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.flexattach.Job;

public class SwitchPairJob
extends Job {
    private SwitchBase _jobSwitchObjectTo;
    private SwitchBase _jobSwitchObjectFrom;
    private SnmpUserOpt _snmpCredTo;
    private SnmpUserOpt _snmpCredFrom;
    private CommunicationObjectSender _commObjSender;
    private Object _extraData = null;

    public SwitchPairJob(int jobType, long requestId, SwitchBase jobSwitchFrom, SnmpUserOpt snmpCredFrom, SwitchBase jobSwitchTo, SnmpUserOpt snmpCredTo) throws IllegalArgumentException {
        super(jobType, requestId);
        if (jobSwitchFrom == null && jobSwitchTo == null) {
            throw new IllegalArgumentException("Must provide at least one switch to perform the action upon.");
        }
        if (jobSwitchTo != null && snmpCredTo == null || jobSwitchTo != null && snmpCredTo == null) {
            throw new IllegalArgumentException("Snmp Credentials must be provided for switches.");
        }
        this._jobSwitchObjectTo = jobSwitchTo;
        this._jobSwitchObjectFrom = jobSwitchFrom;
        this._snmpCredFrom = snmpCredFrom;
        this._snmpCredTo = snmpCredTo;
    }

    public SwitchBase getSwitchObjectFrom() {
        return this._jobSwitchObjectFrom;
    }

    public SwitchBase getSwitchObjectTo() {
        return this._jobSwitchObjectTo;
    }

    public SnmpUserOpt getSnnpCredFrom() {
        return this._snmpCredFrom;
    }

    public SnmpUserOpt getSnnpCredTo() {
        return this._snmpCredTo;
    }

    public CommunicationObjectSender getSender() {
        return this._commObjSender;
    }

    public void setSender(CommunicationObjectSender commObj) {
        this._commObjSender = commObj;
    }

    @Override
    public String toString() {
        String strSuper = super.toString();
        StringBuilder str = new StringBuilder(strSuper);
        str.append(" sender - ").append(this._commObjSender);
        str.append(" jobSwitchObjectFrom - ").append(this._jobSwitchObjectFrom);
        str.append(" snmpCredFrom - ").append(this._snmpCredFrom);
        str.append(" jobSwitchObjectTo - ").append(this._jobSwitchObjectTo);
        str.append(" snmpCredTo - ").append(this._snmpCredTo);
        return str.toString();
    }

    public Object getExtraData() {
        return this._extraData;
    }

    public void setExtraData(Object extraData) {
        this._extraData = extraData;
    }
}

