/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.hostredundancy;

import java.io.Serializable;
import java.util.Calendar;

public class HostRedundancySummary
implements Serializable {
    public static final String GOOD = "Good";
    public static final String SKIPPED = "Skipped";
    public static final String ERRORED = "Errored";
    public static final int SUMMARY_TYPE_ERRORS = 0;
    public static final int SUMMARY_TYPE_SUM = 1;
    public static final int FILTER_TYPE_NOT_FILTER = 0;
    public static final int FILTER_TYPE_FILTER = 1;
    String title;
    int summaryType;
    int count;
    int filterType;
    Calendar lastUpdateTime;

    public HostRedundancySummary(String title, int summaryType, int count, int filterType, Calendar lastUpdate) {
        this.title = title;
        this.summaryType = summaryType;
        this.count = count;
        this.filterType = filterType;
        this.lastUpdateTime = lastUpdate;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSummaryType() {
        return this.summaryType;
    }

    public int getCount() {
        return this.count;
    }

    public int getFilter_type() {
        return this.filterType;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getLastUpdateTimeStr() {
        if (this.lastUpdateTime == null) {
            return "N/A";
        }
        return this.lastUpdateTime.getTime().toString();
    }

    public static String getFilterErrorIdsList(int[] filterErrorIds) {
        StringBuilder errorIdStr = new StringBuilder();
        if (filterErrorIds != null) {
            for (int errorId : filterErrorIds) {
                if (errorIdStr.length() > 0) {
                    errorIdStr.append(",");
                }
                errorIdStr.append(errorId);
            }
        }
        return errorIdStr.toString();
    }
}

