/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.inventory;

import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class CapacityMgrUtil {
    private static CapacityMgrUtil _Instance = null;
    private static Logger _Log = Logger.getLogger((String)"capacity");
    static final String _InsertTimeSQL = "INSERT INTO CAPACITY_TIME (ID, UPDATE_DATE, UPDATE_YEAR, DAY_OF_YEAR, DAY_OF_MONTH, WEEK_OF_YEAR,MONTH_OF_YEAR, QUARTER) VALUES(?,?,?,?,?,?,?,?)";
    static final String _GetSanSwitchSQL = "select fabric_id, id from switch order by fabric_id,  id asc";
    static final String _GetLanSwitchSQL = "select lan_id, id from lanswitch_map order by lan_id, id asc";
    static final String _InsertDataSQL = "insert into capacity_data (time_id, fabric_id, switch_id, avail_1g, total_1g, avail_2g, total_2g,  avail_4g, total_4g, avail_8g, total_8g,avail_10g, total_10g, avail_na, total_na,  health, events) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static final String _RemoveCapacityTimeSQL = "DELETE FROM CAPACITY_TIME";
    static final String _RemoveCapacityDataSQL = "DELETE FROM CAPACITY_DATA";
    static final String _RemoveCapacitySmisDataSQL = "DELETE FROM CAPACITY_DATA_SMIS";
    static final String _RemoveCapacitySmisLunDataSQL = "DELETE FROM CAPACITY_DATA_SMIS_LUN";
    static final String _GetSmisPoolSQL = "select id, system_db_id from smis_pool";
    static final String _InsertSmisDataSQL = "insert into capacity_data_smis (time_id, system_id, pool_id, raw_capacity, remaining_raw_capacity, total_managed, remaining_managed)  values (?, ?, ?, ?, ?, ?, ?)";
    static final String _GetSmisLunSQL = "select id, system_db_id from smis_storage_lun";
    static final String _InsertSmisLunDataSQL = "insert into capacity_data_smis_lun (time_id, system_id, lun_id, total_managed, remaining_managed)  values (?, ?, ?, ?, ?)";

    protected CapacityMgrUtil() {
    }

    public static CapacityMgrUtil getInstance() {
        if (_Instance == null) {
            _Instance = new CapacityMgrUtil();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeCapacityDB() {
        Connection con = null;
        PreparedStatement stat = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_RemoveCapacityDataSQL);
            stat.executeQuery();
        }
        catch (Exception ex) {
            DbUtil.close(stat);
            catch (Throwable throwable) {
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(stat);
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_RemoveCapacitySmisDataSQL);
            stat.executeQuery();
        }
        catch (Exception ex) {
        }
        finally {
            DbUtil.close(stat);
        }
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_RemoveCapacitySmisLunDataSQL);
            stat.executeQuery();
        }
        catch (Exception ex) {
        }
        finally {
            DbUtil.close(stat);
        }
        try {
            if (con != null) {
                stat = con.prepareStatement(_RemoveCapacityTimeSQL);
                stat.executeQuery();
            }
        }
        catch (Exception exception) {
        }
        finally {
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    public void pumping3monthData() throws Exception {
        _Log.info((Object)"CapacityMgrTest Start to clean up data...");
        this.removeCapacityDB();
        _Log.info((Object)"CapacityMgrTest Start to pump 3 month data...");
        Connection con = null;
        try {
            int index = 1;
            con = ConnectionManager.getConnection();
            for (int i = 90; i > 0; --i) {
                int status;
                Calendar cal = Calendar.getInstance();
                cal.add(5, -i);
                long timeId = this.populateCapacityTime(con, cal, index++);
                if (timeId < 0L) {
                    _Log.error((Object)"CapacityMgrTest Error in pumping 3 month data...");
                }
                if ((status = this.populateCapacityData(timeId, con)) < 0) {
                    _Log.error((Object)"Error happens during the capacity data persistence process.");
                }
                if ((status = this.populateSmisCapacityData(timeId, con)) < 0) {
                    throw new Exception("Error happens during the capacity Smis data persistence process.");
                }
                status = this.populateSmisLunCapacityData(timeId, con);
                if (status >= 0) continue;
                throw new Exception("Error happens during the capacity Smis LUN data persistence process.");
            }
        }
        catch (Exception ex) {
            _Log.warn((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            DbUtil.close(con);
        }
        _Log.info((Object)"CapacityMgrTest finish pumping 3 month data...");
    }

    private int populateCapacityData(long timeId, Connection con) {
        int statusCode = 1;
        HashMap<Long, CaDataBase> swMap = new HashMap<Long, CaDataBase>();
        this.getSanSwitchData(con, swMap);
        this.getLanSwitchData(con, swMap);
        statusCode = this.persistData(swMap, con, timeId);
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int persistData(Map<Long, CaDataBase> swMap, Connection con, long timeId) {
        int statusCode = 1;
        PreparedStatement pstmt = null;
        for (CaDataBase item : swMap.values()) {
            try {
                pstmt = con.prepareStatement(_InsertDataSQL);
                int index = 1;
                pstmt.setLong(index++, timeId);
                pstmt.setLong(index++, item.parentId);
                pstmt.setLong(index++, item.switchId);
                pstmt.setInt(index++, item.avail_1G);
                pstmt.setInt(index++, item.total_1G);
                pstmt.setInt(index++, item.avail_2G);
                pstmt.setInt(index++, item.total_2G);
                pstmt.setInt(index++, item.avail_4G);
                pstmt.setInt(index++, item.total_4G);
                pstmt.setInt(index++, item.avail_8G);
                pstmt.setInt(index++, item.total_8G);
                pstmt.setInt(index++, item.avail_10G);
                pstmt.setInt(index++, item.total_10G);
                pstmt.setInt(index++, item.avail_na);
                pstmt.setInt(index++, item.total_na);
                pstmt.setFloat(index++, item.health);
                pstmt.setLong(index++, item.events);
                pstmt.execute();
            }
            catch (Exception ex) {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
                statusCode = -2;
            }
            finally {
                DbUtil.close(pstmt);
            }
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSwitchData(Connection con, Map<Long, CaDataBase> swMap, String sql) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            Random randomGenerator = new Random();
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            CaDataBase base = null;
            while (rs.next()) {
                long parent_id = rs.getLong(1);
                long switch_id = rs.getLong(2);
                base = swMap.get(switch_id);
                if (base == null) {
                    base = new CaDataBase(parent_id, switch_id);
                    swMap.put(switch_id, base);
                }
                base.avail_na = randomGenerator.nextInt(200);
                base.total_na = base.avail_na + randomGenerator.nextInt(200);
                base.avail_1G = randomGenerator.nextInt(200);
                base.total_1G = base.avail_1G + randomGenerator.nextInt(200);
                base.avail_2G = randomGenerator.nextInt(200);
                base.total_2G = base.avail_2G + randomGenerator.nextInt(200);
                base.avail_4G = randomGenerator.nextInt(200);
                base.total_4G = base.avail_4G + randomGenerator.nextInt(200);
                base.avail_8G = randomGenerator.nextInt(200);
                base.total_8G = base.avail_8G + randomGenerator.nextInt(200);
                base.avail_10G = randomGenerator.nextInt(200);
                base.total_10G = base.avail_10G + randomGenerator.nextInt(200);
                base.health = (float)((double)randomGenerator.nextInt(100) / 100.0);
                base.events = randomGenerator.nextInt(200);
            }
        }
        catch (Exception ex) {
            try {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
    }

    private void getLanSwitchData(Connection con, Map<Long, CaDataBase> swMap) {
        this.getSwitchData(con, swMap, _GetLanSwitchSQL);
    }

    private void getSanSwitchData(Connection con, Map<Long, CaDataBase> swMap) {
        this.getSwitchData(con, swMap, _GetSanSwitchSQL);
    }

    private int populateSmisCapacityData(long timeId, Connection con) {
        int statusCode = 0;
        HashMap<Long, CaSmisDataBase> dataMap = new HashMap<Long, CaSmisDataBase>();
        this.getSmisPoolData(con, dataMap);
        statusCode = this.persistSmisData(dataMap, con, timeId);
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSmisPoolData(Connection con, Map<Long, CaSmisDataBase> swMap) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(_GetSmisPoolSQL);
            rs = pstmt.executeQuery();
            CaSmisDataBase base = null;
            Random randomGenerator = new Random();
            while (rs.next()) {
                long pool_id = rs.getLong(1);
                long sys_id = rs.getLong(2);
                long remainRaw = randomGenerator.nextInt(2000000000);
                long rawCap = remainRaw + (long)randomGenerator.nextInt(2000000000);
                long remainMag = randomGenerator.nextInt(2000000000);
                long total = remainMag + (long)randomGenerator.nextInt(2000000000);
                base = new CaSmisDataBase(sys_id, pool_id, rawCap, remainRaw, total, remainMag);
                swMap.put(pool_id, base);
            }
        }
        catch (Exception ex) {
            try {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int persistSmisData(Map<Long, CaSmisDataBase> dataMap, Connection con, long timeId) {
        int statusCode = 0;
        PreparedStatement pstmt = null;
        for (CaSmisDataBase item : dataMap.values()) {
            try {
                pstmt = con.prepareStatement(_InsertSmisDataSQL);
                int index = 1;
                pstmt.setLong(index++, timeId);
                pstmt.setLong(index++, item.systemId);
                pstmt.setLong(index++, item.poolId);
                pstmt.setLong(index++, item.rawCapacity);
                pstmt.setLong(index++, item.remainingRawCapacity);
                pstmt.setLong(index++, item.totalManaged);
                pstmt.setLong(index++, item.remainingManaged);
                pstmt.execute();
            }
            catch (Exception ex) {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
                statusCode = -2;
            }
            finally {
                DbUtil.close(pstmt);
            }
        }
        return statusCode;
    }

    private int populateSmisLunCapacityData(long timeId, Connection con) {
        int statusCode = 0;
        HashMap<Long, CaSmisLunDataBase> dataMap = new HashMap<Long, CaSmisLunDataBase>();
        this.getSmisLunData(con, dataMap);
        statusCode = this.persistSmisLunData(dataMap, con, timeId);
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSmisLunData(Connection con, Map<Long, CaSmisLunDataBase> swMap) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(_GetSmisLunSQL);
            rs = pstmt.executeQuery();
            CaSmisLunDataBase base = null;
            Random randomGenerator = new Random();
            while (rs.next()) {
                long lun_id = rs.getLong(1);
                long sys_id = rs.getLong(2);
                long remained = randomGenerator.nextInt(2000000000);
                long total = remained + (long)randomGenerator.nextInt(2000000000);
                base = new CaSmisLunDataBase(sys_id, lun_id, total, remained);
                swMap.put(lun_id, base);
            }
        }
        catch (Exception ex) {
            try {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt);
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int persistSmisLunData(Map<Long, CaSmisLunDataBase> dataMap, Connection con, long timeId) {
        int statusCode = 0;
        PreparedStatement pstmt = null;
        for (CaSmisLunDataBase item : dataMap.values()) {
            try {
                pstmt = con.prepareStatement(_InsertSmisLunDataSQL);
                int index = 1;
                pstmt.setLong(index++, timeId);
                pstmt.setLong(index++, item.systemId);
                pstmt.setLong(index++, item.lunId);
                pstmt.setLong(index++, item.totalManaged);
                pstmt.setLong(index++, item.remainingManaged);
                pstmt.execute();
            }
            catch (Exception ex) {
                _Log.warn((Object)ex.getMessage(), (Throwable)ex);
                statusCode = -2;
            }
            finally {
                DbUtil.close(pstmt);
            }
        }
        return statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long populateCapacityTime(Connection con, Calendar cal, int timeId) {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(_InsertTimeSQL);
            int index = 1;
            pstmt.setLong(index++, timeId);
            pstmt.setTimestamp(index++, new Timestamp(cal.getTimeInMillis()));
            pstmt.setInt(index++, cal.get(1));
            pstmt.setInt(index++, cal.get(6));
            pstmt.setInt(index++, cal.get(5));
            pstmt.setInt(index++, cal.get(3));
            pstmt.setInt(index++, cal.get(2) + 1);
            pstmt.setInt(index++, cal.get(2) / 3 + 1);
            pstmt.execute();
        }
        catch (Exception ex) {
            _Log.warn((Object)ex.getMessage(), (Throwable)ex);
            long l = -1L;
            return l;
        }
        finally {
            DbUtil.close(pstmt);
        }
        return timeId;
    }

    public static void main(String[] args) {
        try {
            GenUtil.loadServerProperties(_Log);
            CapacityMgrUtil.getInstance().pumping3monthData();
        }
        catch (Exception ex) {
            System.err.print(ex.getMessage());
        }
        System.exit(0);
    }

    private class CaSmisLunDataBase {
        long systemId;
        long lunId;
        long totalManaged;
        long remainingManaged;

        public CaSmisLunDataBase(long sysId, long lId) {
            this.systemId = sysId;
            this.lunId = lId;
        }

        public CaSmisLunDataBase(long sysId, long lId, long total, long rem) {
            this.systemId = sysId;
            this.lunId = lId;
            this.totalManaged = total;
            this.remainingManaged = rem;
        }
    }

    private class CaSmisDataBase {
        long systemId;
        long poolId;
        long rawCapacity;
        long remainingRawCapacity;
        long totalManaged;
        long remainingManaged;

        public CaSmisDataBase(long sysId, long pId) {
            this.systemId = sysId;
            this.poolId = pId;
        }

        public CaSmisDataBase(long sysId, long pId, long raw, long remainRaw, long total, long remainMag) {
            this.systemId = sysId;
            this.poolId = pId;
            this.rawCapacity = raw;
            this.remainingRawCapacity = remainRaw;
            this.totalManaged = total;
            this.remainingManaged = remainMag;
        }
    }

    private class CaDataBase {
        long parentId;
        long switchId;
        int avail_1G;
        int total_1G;
        int avail_2G;
        int total_2G;
        int avail_4G;
        int total_4G;
        int avail_8G;
        int total_8G;
        int avail_10G;
        int total_10G;
        int avail_na;
        int total_na;
        float health;
        long events;

        public CaDataBase(long f, long s) {
            this.parentId = f;
            this.switchId = s;
        }
    }
}

