/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.inventory;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.util.SyncedBoolean;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.InventoryPersistent;
import com.cisco.dcbu.sm.server.discovery.CdpDiscvHelper;
import com.cisco.dcbu.sm.server.inventory.SwitchInventoryWorker;
import com.cisco.dcbu.sm.server.inventory.SwitchInventoryWorkerIf;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;

public class EthSwitchInventoryWorker
implements SwitchInventoryWorkerIf {
    static TraceLogger _Tracer = new TraceLogger(LogManager.getLogger((String)"fms.inventory"), false, false, false, false);
    private int _discFlags = 63;
    private EthSwitchImpl _sw;
    private SyncedBoolean _isDiscovering = new SyncedBoolean(false);

    EthSwitchInventoryWorker(EthSwitchImpl sw) {
        this._sw = sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: {
            if (this._isDiscovering.get()) {
                return;
            }
            this._isDiscovering.set(true);
            try {
                if (!this.discover()) break block7;
                try {
                    EthSwitchImpl sw = DCManager.getInstance().findEthSwitchBySwPK(this._sw.getSwitchPK());
                    if (sw != null && (sw == this._sw || sw.getDBID() == this._sw.getDBID())) {
                        InventoryPersistent.getInstance().persist(this._sw);
                    }
                }
                catch (Exception ex) {
                    _Tracer.log(Level.WARN, this + ": persisting inventory failed", ex);
                }
            }
            finally {
                this._isDiscovering.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        SyncedBoolean syncedBoolean = this._isDiscovering;
        synchronized (syncedBoolean) {
            if (this._isDiscovering.get()) {
                this._isDiscovering.set(false);
                this._isDiscovering.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDiscovering() {
        SyncedBoolean syncedBoolean = this._isDiscovering;
        synchronized (syncedBoolean) {
            return this._isDiscovering.get();
        }
    }

    public String toString() {
        return this._sw.getIpAddress() + "-EthSwitchInventoryWorker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean discover() {
        block34: {
            block32: {
                block31: {
                    try {
                        if (CdpDiscvHelper.checkHwChanged(this._sw)) {
                            this.setDiscFlag(31);
                            if ((this._sw.getBase().isN5KVerLT521() || this._sw.isFexEnabled()) && this._sw.isFexCapableVersion() && this._sw.getNumFex() > 0) {
                                this.setDiscFlag(1024);
                            }
                        } else if ((this._sw.getBase().isN5KVerLT521() || this._sw.isFexEnabled()) && this._sw.isFexCapableVersion() && this._sw.getNumFex() > 0 && CdpDiscvHelper.checkFexChange(this._sw)) {
                            this.setDiscFlag(1024);
                        }
                        if (EthSwitchInventoryWorker._Tracer.isDebuggable()) {
                            EthSwitchInventoryWorker._Tracer.debug(this + ": entity change checked, discFlag=" + this._discFlags);
                        }
                    }
                    catch (Exception ex) {
                        if (ex instanceof SnmpException) {
                            EthSwitchInventoryWorker._Tracer.log(Level.WARN, this + ": checking entity change failed: " + ex.getMessage());
                        } else {
                            EthSwitchInventoryWorker._Tracer.log(Level.WARN, this + ": checking entity change failed: " + ex.getMessage(), ex);
                        }
                        if (this._sw.isManageable()) break block31;
                        return false;
                    }
                }
                if (this.isDiscFlagSet(31)) {
                    try {
                        CdpDiscvHelper.discoverHwEntities(this._sw);
                        this.resetDiscFlag(31);
                        if (!EthSwitchInventoryWorker._Tracer.isDebuggable()) ** GOTO lbl48
                        EthSwitchInventoryWorker._Tracer.debug(this + ": hardware inventory rediscovered");
                    }
                    catch (Exception ex) {
                        EthSwitchInventoryWorker._Tracer.warn(this + ": rediscovering hardware inventory failed: " + ex.getMessage(), ex);
                        if (this._sw.isManageable()) ** GOTO lbl48
                        return false;
                    }
                } else {
                    try {
                        CdpDiscvHelper.updateHwEntityStatus(this._sw);
                        if (EthSwitchInventoryWorker._Tracer.isDebuggable()) {
                            EthSwitchInventoryWorker._Tracer.debug(this + ": hardware inventory status refreshed");
                        }
                    }
                    catch (Exception ex) {
                        if (ex instanceof SnmpException) {
                            if (EthSwitchInventoryWorker._Tracer.isDebuggable()) {
                                EthSwitchInventoryWorker._Tracer.warn(this + ": refreshing hardware inventory status failed", ex);
                            } else {
                                EthSwitchInventoryWorker._Tracer.warn(this + ": refreshing hardware inventory status failed: " + ex.getMessage());
                            }
                        } else {
                            EthSwitchInventoryWorker._Tracer.warn(this + ": refreshing hardware inventory status failed: " + ex.getMessage(), ex);
                        }
                        if (this._sw.isManageable()) break block32;
                        return false;
                    }
                }
            }
            if (this.isDiscFlagSet(1024)) {
                try {
                    CdpDiscvHelper.discoverFexHwEntities(this._sw);
                    if (EthSwitchInventoryWorker._Tracer.isDebuggable()) {
                        EthSwitchInventoryWorker._Tracer.debug(this + ": fex inventory rediscovered");
                    }
                }
                catch (Exception ex) {
                    EthSwitchInventoryWorker._Tracer.log(Level.WARN, this + ": rediscovering fex inventory failed: " + ex.getMessage(), ex);
                    if (!this._sw.isManageable()) {
                        var2_8 = false;
                        return var2_8;
                    }
                }
                finally {
                    this.resetDiscFlag(1024);
                }
            }
            try {
                numLic = CdpDiscvHelper.discoverNumLicense(this._sw);
                if (numLic != this._sw.getNumLicensedFeatures()) {
                    this._sw.setNumLicensedFeatures(numLic);
                }
                SwitchInventoryWorker._Logger.debug((Object)(this + ": number of license checked"));
                CdpDiscvHelper.discoverLicenses(this._sw);
                this.resetDiscFlag(64);
                SwitchInventoryWorker._Logger.debug((Object)(this + ": license inventory rediscovered"));
            }
            catch (Exception ex) {
                SwitchInventoryWorker._Logger.log((Priority)Level.WARN, (Object)(this + ": rediscovering license inventory failed: " + ex.getMessage()), (Throwable)ex);
                if (this._sw.isManageable()) break block34;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setDiscFlag(int flag) {
        this._discFlags |= flag;
    }

    @Override
    public void resetDiscFlag(int flag) {
        this._discFlags &= ~flag;
    }

    @Override
    public boolean isDiscFlagSet(int flag) {
        return (this._discFlags & flag) != 0;
    }
}

