/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.ioa.xmltool;

import com.cisco.dcbu.sm.server.ioa.xmltool.IO;
import com.cisco.dcbu.sm.server.ioa.xmltool.XSDParse;
import com.cisco.dcbu.sm.server.ioa.xmltool.XSDParserHelper;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDParser {
    private String prefix;
    private String[] dependencyPrefix = new String[10];
    private int dependencyIndex = 0;

    public String getPrefix(String filename) {
        int beginIndex = filename.lastIndexOf("/");
        int endIndex = filename.indexOf(".xsd");
        String pfx = filename.substring(beginIndex + 1, endIndex);
        System.out.println("Prefix is " + pfx);
        return pfx;
    }

    public void printDependencyHeaders(IO io) {
        for (int i = 0; i < this.dependencyIndex; ++i) {
            io.writetofile("#include <isan/" + this.dependencyPrefix[i] + "_fm_enums.h>");
            io.writetofile("#include <isan/" + this.dependencyPrefix[i] + "_common_defs.h>");
            io.writetofile("#include <isan/" + this.dependencyPrefix[i] + "_fm_extern.h>");
            io.writetofile("#include <isan/" + this.dependencyPrefix[i] + "_message.h>");
        }
    }

    public void parseXSD(String fileName, String path) {
        this.prefix = this.getPrefix(fileName);
        XSDParserHelper helper = new XSDParserHelper();
        Document doc = helper.parseXmlFile(fileName);
        if (doc == null) {
            System.out.println("failed to parse file " + fileName);
            return;
        }
        Element docEle = doc.getDocumentElement();
        XSDParse xsdParse = new XSDParse();
        xsdParse.parse(docEle, Boolean.FALSE);
        this.process(path, xsdParse);
    }

    public void parseXSD(String path, String thisSchema, String[] fileName) {
        XSDParserHelper helper = new XSDParserHelper();
        XSDParse xsdParse = new XSDParse();
        this.prefix = this.getPrefix(thisSchema);
        for (String file : fileName) {
            this.dependencyPrefix[this.dependencyIndex++] = this.getPrefix(file);
            Document doc = helper.parseXmlFile(file);
            if (doc == null) {
                System.out.println("failed to parse file " + fileName);
                continue;
            }
            Element docEle = doc.getDocumentElement();
            xsdParse.parse(docEle, Boolean.TRUE);
        }
        Document doc = helper.parseXmlFile(thisSchema);
        if (doc == null) {
            System.out.println("failed to parse file " + thisSchema);
            return;
        }
        Element docEle = doc.getDocumentElement();
        xsdParse.parse(docEle, Boolean.FALSE);
        this.process(path, xsdParse);
    }

    private void process(String path, XSDParse xsdParse) {
        IO io;
        xsdParse.print();
        try {
            io = new IO(path + "/" + this.prefix + "_common_defs.h");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_common_defs.h");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This header file contains the necessary data structures used as");
        io.writetofile("*        C objects that are populated by parsing XML messages sent by FM");
        io.writetofile("*        and vice-versa.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#ifndef _" + this.prefix.toUpperCase() + "_COMMON_DEFS_H_");
        io.writetofile("#define _" + this.prefix.toUpperCase() + "_COMMON_DEFS_H_");
        xsdParse.generateCDefines(io);
        io.writetofile("#endif");
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_fm_enums.h");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_fm_enums.h");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This header file contains the necessary data structures used as");
        io.writetofile("*        C objects that are populated by parsing XML messages sent by FM");
        io.writetofile("*        and vice-versa.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#ifndef _" + this.prefix.toUpperCase() + "_FM_ENUMS_H_");
        io.writetofile("#define _" + this.prefix.toUpperCase() + "_FM_ENUMS_H_");
        io.writetofile("#include <isan/types.h>");
        io.writetofile("#include <isan/enum_table.h>");
        xsdParse.generateCEnums(io);
        io.writetofile("#endif");
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_fm_enums.c");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_fm_enums.c");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This header file contains the necessary data structures used as");
        io.writetofile("*        C objects that are populated by parsing XML messages sent by FM");
        io.writetofile("*        and vice-versa.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#define BUILD_ENUM_TABLE");
        io.writetofile("#include <isan/" + this.prefix + "_fm_enums.h>");
        io.writetofile("#undef BUILD_ENUM_TABLE");
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_message.h");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_message.h");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This header file contains the necessary data structures used as");
        io.writetofile("*        C objects that are populated by parsing XML messages sent by FM");
        io.writetofile("*        and vice-versa.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#ifndef _" + this.prefix.toUpperCase() + "_MESSAGE_H_");
        io.writetofile("#define _" + this.prefix.toUpperCase() + "_MESSAGE_H_");
        io.writetofile("#include <stdio.h>");
        io.writetofile("#include <libxml/parser.h>");
        io.writetofile("#include <libxml/tree.h>");
        io.writetofile("#include <isan/types.h>");
        this.printDependencyHeaders(io);
        io.writetofile("#include <isan/" + this.prefix + "_defs.h>");
        io.writetofile("#include <isan/" + this.prefix + "_common_defs.h>");
        io.writetofile("#include <isan/" + this.prefix + "_fm_enums.h>");
        xsdParse.generateCStructures(io);
        io.writetofile("#endif");
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_fm_xmlparse.c");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_fm_xmlparse.c");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This file contains the necessary infrastructural functions to");
        io.writetofile("*        convert the XML messages sent by FM to C objects that can easily");
        io.writetofile("*        be passed to the SME process.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#include <isan/" + this.prefix + "_message.h>");
        io.writetofile("#include \"" + this.prefix + "_fm_support.h\"");
        xsdParse.generateCParseFunctions(io);
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_fm_xmlbuild.c");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_fm_xmlbuild.c");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This file contains the necessary infrastructural functions to");
        io.writetofile("*        convert the C objects to XML messages that is understood by FM.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#include <isan/" + this.prefix + "_message.h>");
        io.writetofile("#include \"" + this.prefix + "_fm_support.h\"");
        io.writetofile("/* Global variables used for building XML */");
        io.writetofile("#define MAX_TEMP_STR_SIZE 256");
        io.writetofile("static char temp[MAX_TEMP_STR_SIZE];");
        xsdParse.generateCBuildFunctions(io);
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_fm_endian_utils.c");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_fm_endian_utils.c");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This file contains the necessary infrastructural functions to");
        io.writetofile("*        convert the C objects to XML messages that is understood by FM.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#include <isan/" + this.prefix + "_message.h>");
        io.writetofile("#include <isan/" + this.prefix + "_fm_extern.h>");
        io.writetofile("#include \"" + this.prefix + "_fm_support.h\"");
        xsdParse.generateEndianFunctions(io);
        io.finalize();
        try {
            io = new IO(path + "/" + this.prefix + "_fm_extern.h");
        }
        catch (IOException e) {
            return;
        }
        io.writetofile("/********************************************************************");
        io.writetofile("*");
        io.writetofile("*      File:   " + this.prefix + "_fm_extern.h");
        io.writetofile("*      Name:   ");
        io.writetofile("*");
        io.writetofile("*       Description:");
        io.writetofile("*        This file contains the necessary infrastructural functions to");
        io.writetofile("*        convert the C objects to XML messages that is understood by FM.");
        io.writetofile("*");
        io.writetofile("*       NOTE!!!! THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT");
        io.writetofile("*       MODIFY THIS FILE DIRECTLY. INSTEAD, PLEASE UPDATE THE SCHEMA");
        io.writetofile("*       AND GENERATE THIS FILE AGAIN.");
        io.writetofile("*");
        io.writetofile("*      Copyright (c) 1985-2005,2006 by Cisco Systems, Inc.");
        io.writetofile("*");
        io.writetofile("*       ALL RIGHTS RESERVED.");
        io.writetofile("*");
        io.writetofile("*");
        io.writetofile("* $Id: $");
        io.writetofile("* $Source: $");
        io.writetofile("* $Author: $");
        io.writetofile("* ---------------------------------------------------------------");
        io.writetofile("*********************************************************************");
        io.writetofile("*/");
        io.writetofile("#ifndef _" + this.prefix.toUpperCase() + "_FM_EXTERN_H_");
        io.writetofile("#define _" + this.prefix.toUpperCase() + "_FM_EXTERN_H_");
        io.writetofile("#include <isan/" + this.prefix + "_message.h>");
        xsdParse.generateEndianFunctionsDefines(io);
        xsdParse.generateCBuildFunctionsDefines(io);
        xsdParse.generateCParseFunctionsDefines(io);
        io.writetofile("#endif");
        io.finalize();
    }
}

