/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import com.cisco.dcbu.sm.server.licmgr.HostIdGenerator;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class FmHostId
extends HostId
implements FlexlmConstants {
    private static final String HOST_ID_PREFIX = "VDH";
    private String hostId;
    static Logger _Logger = LogManager.getLogger((String)"fms.license");

    public FmHostId() {
    }

    private FmHostId(String hostId) throws FlexlmException {
        if (!hostId.startsWith(HOST_ID_PREFIX)) {
            throw new FlexlmException(-504, 1);
        }
        this.hostId = hostId.substring(hostId.indexOf("=") + 1).toUpperCase();
        if (this.hostId == null || this.hostId.length() < 1) {
            throw new FlexlmException(-503, 2);
        }
    }

    public HostId createNew(String newId) throws FlexlmException {
        return new FmHostId(newId);
    }

    public HostId[] getCurrentHostIds() {
        HostId[] ids = new HostId[1];
        try {
            List<String> hostMacs = null;
            hostMacs = HostIdGenerator.getInstance().getHostMacs();
            ids = new HostId[hostMacs.size()];
            int index = 0;
            for (String nextMac : hostMacs) {
                ids[index++] = new FmHostId("VDH=" + nextMac);
            }
        }
        catch (FlexlmException e) {
            e.printStackTrace();
            return null;
        }
        return ids;
    }

    public String getKeyword() {
        return HOST_ID_PREFIX;
    }

    public int getType() {
        return 1000;
    }

    public Object getValue() {
        return this.hostId;
    }

    public boolean isCurrentHost() {
        List<String> hostMacs = null;
        try {
            hostMacs = HostIdGenerator.getInstance().getHostMacs();
            if (hostMacs != null && hostMacs.size() > 0 && hostMacs.contains(this.hostId)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (hostMacs == null) {
            if (_Logger.isInfoEnabled()) {
                _Logger.info((Object)(" Host Id from License File " + this.hostId + " could not be verified on this host "));
            }
            return false;
        }
        Iterator<String> iter = hostMacs.iterator();
        String hostm = "";
        while (iter.hasNext()) {
            hostm = hostm + iter.next() + " , ";
        }
        if (_Logger.isInfoEnabled()) {
            _Logger.info((Object)("HOST IDs do not match!\nHostId from License : <" + this.hostId + "> HostId(s) from the Host : <" + hostm + ">"));
        }
        return false;
    }
}

