/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.licmgr;

import java.text.MessageFormat;

public class LicensingException
extends Exception {
    private static final long serialVersionUID = 1L;
    public static final String ERR_LICENSE_SOURCE_NOT_EXIST_MSG = "License file {0} does not exist.";
    public static final String ERR_LICENSE_SOURCE_DIR_EMPTY_MSG = "License folder {0} is empty.";
    public static final String ERR_LICENSE_FEATURES_READ_FAILED_MSG = "Could not read feature information from {0}.";
    public static final String ERR_LICENSE_DCNM_FEATURES_NOT_EXIST_MSG = "Could not find DCNM specific feature information in {0}.";
    public static final String ERR_LICENSE_DCNM_FEATURES_READ_FAILED_MSG = "Could not read DCNM specific feature information in {0}.";
    public static final String ERR_LICENSE_FEATURE_API_INVOKED_IN_STARTER = "License for {0} feature is not installed on server.";
    public static final String ERR_LICENSE_SOURCE_NOT_DIR_MSG = "Given license source {0} is not a directory.";
    public static final String ERR_LICENSE_HOST_ID_READ_FAILED_MSG = "Could not read host identifier of the server.";
    public static final String ERR_LICENSE_SOURCE_DIR_HAS_NO_LIC_FILES_MSG = "No license files(s) found in {0}.";
    public static final String ERR_NO_VALID_LICENSE_FOUND_MSG = "No valid license found in {0}.";
    public static final String ERR_LICENSE_SOURCE_EXPIRATION_READ_FAILED_MSG = "Could not read DCNM feature expiration information in {0}.";

    LicensingException(String message) {
        super(message);
    }

    public static LicensingException errorLicSourceExpirationDateReadError(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_SOURCE_EXPIRATION_READ_FAILED_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicSourceNotExists(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_SOURCE_NOT_EXIST_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicSourceNotDir(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_SOURCE_NOT_DIR_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicSourceEmpty(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_SOURCE_DIR_EMPTY_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicSourceHasNoLicFiles(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_SOURCE_DIR_HAS_NO_LIC_FILES_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorNoValidLicenseFound(String licSource) {
        String msg = MessageFormat.format(ERR_NO_VALID_LICENSE_FOUND_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicFeaturesRead(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_FEATURES_READ_FAILED_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicDcnmFeaturesNotExists(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_DCNM_FEATURES_NOT_EXIST_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLicDcnmFeaturesRead(String licSource) {
        String msg = MessageFormat.format(ERR_LICENSE_DCNM_FEATURES_READ_FAILED_MSG, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorLic(String errorText, String licSource) {
        String msg = MessageFormat.format(errorText, licSource);
        return new LicensingException(msg);
    }

    public static LicensingException errorFlexlm(int errorCode, String msg, String licSource) {
        msg = "No valid license files found in " + licSource + ".";
        return new LicensingException(msg);
    }
}

