/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.IpUtil;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.CdpSeedBase;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.DiscStateType;
import com.cisco.dcbu.sm.common.type.DiscStatusType;
import com.cisco.dcbu.sm.common.type.DiscTaskType;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.TaskKey;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.EthDBObjectIf;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FexImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class CdpSeedImpl
extends AbstractModelObjectImpl
implements EthDBObjectIf,
DumpIf {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String TableName = "cdp_seed";
    public static final String InsertSQL = "insert into cdp_seed(id, lan_id, inet_addr, ip_range, subnet, mask, cred_id, max_hops, last_update_time, serial_number, platform, seed_type, disc_state, ip_list, group_id, create_time, enable_pwd, dcnm_user, deep_taskid, deep_updatetime, manageable, fwsm) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?)";
    static final String DeleteSQL = "delete from cdp_seed where id=?";
    public static final String UpdateSQL = "update cdp_seed set lan_id=?, inet_addr=?, ip_range=?, subnet=?, mask=?, cred_id=?, max_hops=?, last_update_time=?, serial_number=?, platform=?, seed_type=?, disc_state=?, ip_list=?, group_id=?, create_time=?, enable_pwd=?, dcnm_user=?, deep_taskid=?, deep_updatetime=?, manageable=?,  fwsm=? where id=?";
    public static final String QuerySQL = "select id, lan_id, inet_addr, ip_range, subnet, mask, cred_id, max_hops, last_update_time, serial_number,platform, seed_type, disc_state, ip_list, group_id, create_time, enable_pwd, dcnm_user, deep_taskid, deep_updatetime, manageable, fwsm from cdp_seed";
    public static final String QuerySQL_SeedsByLanDBID = "select id, lan_id, inet_addr, ip_range, subnet, mask, cred_id, max_hops, last_update_time, serial_number,platform, seed_type, disc_state, ip_list, group_id, create_time, enable_pwd, dcnm_user, deep_taskid, deep_updatetime, manageable, fwsm from cdp_seed where lan_id=?";
    public static final String QuerySQL_SeedByTaskKey = "select id, lan_id, inet_addr, ip_range, subnet, mask, cred_id, max_hops, last_update_time, serial_number,platform, seed_type, disc_state, ip_list, group_id, create_time, enable_pwd, dcnm_user, deep_taskid, deep_updatetime, manageable, fwsm from cdp_seed where id=?";
    public static final String QuerySQL_SwDBIDBySeedDBID = "select switch_id from ethswitch_seed where seed_id=?";
    public static final String QuerySQL_NavGroupDBIDBySwDBID = "select cs.group_id from cdp_seed cs, ethswitch_seed es where cs.id = es.seed_id AND es.switch_id=?";
    public static final String QuerySQL_NavGroupDBIDByFexSwDBID = "select cs.group_id from cdp_seed cs, ethswitch_seed es, ethswitch_fex ef where cs.id = es.seed_id AND  es.switch_id=ef.switch_id AND ef.fex_id=?";
    private final CdpSeedBase _base;
    private long _lastDBUpdateTime;
    protected transient boolean _needDisc = false;
    private Map<PKIf, EthSwitchImpl> _discEthSwsBySwPK = new ConcurrentHashMap<PKIf, EthSwitchImpl>();
    private long _groupDBID = 0L;
    private long _userDBID = 0L;

    public CdpSeedImpl(TaskKey taskKey, InetAddress seedIp, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, long createTime, String dcnmUser, boolean deepDisc) {
        this._base = new CdpSeedBase(taskKey, seedIp, maxHop, snmpUser, enablePwd, groupDBID, createTime, dcnmUser, deepDisc);
    }

    public CdpSeedImpl(TaskKey taskKey, List<InetAddress> seedIPs, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, long createTime, String dcnmUser, boolean deepDisc) {
        this._base = new CdpSeedBase(taskKey, seedIPs, snmpUser, enablePwd, groupDBID, createTime, dcnmUser, deepDisc);
    }

    public CdpSeedImpl(TaskKey taskKey, List<InetAddress> seedIPs, int maxHop, SnmpUserOpt snmpUser, String enablePwd, long groupDBID, long createTime, String dcnmUser, boolean deepDisc) {
        this._base = new CdpSeedBase(taskKey, seedIPs, maxHop, snmpUser, enablePwd, groupDBID, createTime, dcnmUser, deepDisc);
    }

    public CdpSeedImpl(CdpSeedBase base) {
        this._base = base;
    }

    @Override
    public PKIf getPK() {
        return this._base.getPK();
    }

    public TaskKey getTaskKey() {
        return this._base.getTaskKey();
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public CdpSeedBase getBase() {
        return this._base;
    }

    @Override
    public FabricImpl getFabric() {
        throw new UnsupportedOperationException("Invalid call for ethernet objects");
    }

    @Override
    public LanImpl getLan() {
        return DCManager.getInstance().getLan();
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        return false;
    }

    public void addEthSwitch(EthSwitchImpl sw) {
        if (sw == null || this._base.containsEthSwitch(sw.getSwitchPK())) {
            return;
        }
        List<PKIf> oldValue = this._base.getEthSwitches();
        this._base.addEthSwitch(sw.getSwitchPK());
        this._base.addSeedIp(sw.getInetAddress());
        this._discEthSwsBySwPK.put(sw.getSwitchPK(), sw);
        this.propertyChanged((short)3331, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getEthSwitches()));
    }

    public void removeEthSwitch(EthSwitchImpl sw) {
        if (sw == null || !this._base.containsEthSwitch(sw.getSwitchPK())) {
            return;
        }
        List<PKIf> oldValue = this._base.getEthSwitches();
        this._base.removeEthSwitch(sw.getSwitchPK());
        boolean keepSeedIp = false;
        List<EthSwitchImpl> ethsws = this.getDiscoveredEthSwitches();
        for (EthSwitchImpl ethsw : ethsws) {
            if (ethsw == null || ethsw.getInetAddress() == null || !ethsw.getInetAddress().equals(sw.getInetAddress()) || GenUtil.equals(sw, ethsw)) continue;
            keepSeedIp = true;
        }
        if (!keepSeedIp) {
            this._base.removeSeedIp(sw.getInetAddress());
        }
        this._discEthSwsBySwPK.remove(sw.getSwitchPK());
        this.propertyChanged((short)3331, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getEthSwitches()));
    }

    public int getNumOfEthSwitches() {
        return this._base.getNumEthSwitches();
    }

    public EthSwitchImpl findDiscoveredNodeByNodeIp(InetAddress nodeIp) {
        if (nodeIp == null) {
            return null;
        }
        EthSwitchImpl ethSw = this.getLan().findEthSwitchByIp(nodeIp);
        if (ethSw != null) {
            return this.findDiscoveredNodeByNodePK(ethSw.getPK());
        }
        return null;
    }

    public EthSwitchImpl findDiscoveredNodeByNodePK(PKIf nodePK) {
        if (nodePK == null) {
            return null;
        }
        return this._discEthSwsBySwPK.get(nodePK);
    }

    public void cleanCache() {
        this._discEthSwsBySwPK.clear();
    }

    public List<InetAddress> getSeedIPs() {
        return this._base.getSeedIPs();
    }

    public List<EthSwitchImpl> getDiscoveredEthSwitches() {
        return new ArrayList<EthSwitchImpl>(this._discEthSwsBySwPK.values());
    }

    public DiscStateType getDiscState() {
        return this._base.getDiscState();
    }

    public void setDiscState(DiscStateType state) {
        this._base.setDiscState(state);
    }

    public DiscStatusType getDiscStatus() {
        return this._base.getDiscStatus();
    }

    public void setDiscStatus(DiscStatusType status) {
        this._base.setDiscStatus(status);
    }

    public void setLastUpdateTime(long time) {
        this._lastDBUpdateTime = time;
    }

    public long getLastUpdateTime() {
        return this._lastDBUpdateTime;
    }

    public void setInitTime(long time) {
        this._base.setInitTime(time);
    }

    public long getInitTime() {
        return this._base.getInitTime();
    }

    public long getDeepTaskId() {
        return this._base.getDeepTaskId();
    }

    public void setDeepTaskId(long deepTaskId) {
        this._base.setDeepTaskId(deepTaskId);
    }

    public long getDeepUpdateTime() {
        return this._base.getDeepUpdateTime();
    }

    public void setDeepUpdateTime(long deepUpdateTime) {
        this._base.setDeepUpdateTime(deepUpdateTime);
    }

    public List<EthSwitchImpl> getDeepDiscSwitches() {
        List<EthSwitchImpl> switches = this.getDiscoveredEthSwitches();
        ArrayList<EthSwitchImpl> result = new ArrayList<EthSwitchImpl>();
        for (EthSwitchImpl nextSw : switches) {
            _Tracer.log(Level.INFO, "Ip Address ==> " + nextSw.getIpAddress());
            _Tracer.log(Level.INFO, "IsDeepDisc() ==> " + nextSw.isDeepDisc());
            if (!nextSw.isDeepDisc()) continue;
            _Tracer.log(Level.INFO, "IsDeepDisc() ==> returning true!!!");
            result.add(nextSw);
        }
        return result;
    }

    public boolean isManageable() {
        return this._base.isManageable();
    }

    public void setManageable(boolean manageable) {
        this._base.setManageable(manageable);
    }

    public boolean needDisc() {
        return this._needDisc;
    }

    public void setNeedDisc(boolean needDisc) {
        this._needDisc = needDisc;
    }

    public boolean isFwsm() {
        return this._base.isFwsm();
    }

    public void setFwsm(boolean fwsm) {
        this._base.setFwsm(fwsm);
    }

    public boolean isDeepDisc() {
        return this._base.isDeepDisc();
    }

    public void setDeepDisc(boolean deepDisc) {
        this._base.setDeepDisc(deepDisc);
    }

    public String getEnablePwd() {
        return this._base.getEnablePwd();
    }

    public boolean setEnablePwd(String enablePwd) {
        String oldValue = this._base.getEnablePwd();
        if (!GenUtil.equals(oldValue, enablePwd)) {
            this._base.setEnablePwd(enablePwd);
            return true;
        }
        return false;
    }

    public String getDcnmUser() {
        return this._base.getDcnmUser();
    }

    public boolean setDcnmUser(String dcnmUser) {
        String oldValue = this._base.getDcnmUser();
        if (!GenUtil.equals(oldValue, dcnmUser)) {
            this._base.setDcnmUser(dcnmUser);
            return true;
        }
        return false;
    }

    public void checkSeedSwitch() {
        if (this._base.isMaxHopTask()) {
            EthSwitchImpl ethSw;
            if (this._base.getSeedSwPK() == null && (ethSw = this.findDiscoveredNodeByNodeIp(this._base.getSeedIp())) != null) {
                this._base.setSeedSwPK(ethSw.getSwitchPK());
            }
            if (!((ethSw = this.findDiscoveredNodeByNodePK(this._base.getSeedSwPK())) != null && ethSw.isManageable() || (ethSw = this.selectActiveSwitch()) == null)) {
                this._base.setSeedIp(ethSw.getInetAddress());
                this._base.setSeedSwPK(ethSw.getSwitchPK());
            }
        }
    }

    public EthSwitchImpl selectActiveSwitch() {
        EthSwitchImpl activeSw = null;
        for (EthSwitchImpl sw : this.getDiscoveredEthSwitches()) {
            if (!sw.isManageable()) continue;
            if (activeSw == null) {
                activeSw = sw;
                continue;
            }
            if (sw.getBase().getNumEthPorts() <= activeSw.getBase().getNumEthPorts()) continue;
            activeSw = sw;
        }
        return activeSw;
    }

    public SnmpUser getCredential() {
        return this._base.getCredential();
    }

    public boolean setCredential(SnmpUser newUser) throws Exception {
        if (newUser == null) {
            return false;
        }
        SnmpUser oldValue = this._base.getCredential();
        if (!GenUtil.equals(oldValue, newUser)) {
            ArrayList<EthSwitchImpl> ethSws = new ArrayList<EthSwitchImpl>(this._discEthSwsBySwPK.values());
            StringBuilder failedList = new StringBuilder();
            int failedCount = 0;
            for (EthSwitchImpl sw : ethSws) {
                try {
                    sw.setCredential(newUser);
                    if (sw.getPeerWithoutCreate() == null || !sw.getPeerWithoutCreate().hasCerdentialAs(newUser)) {
                        ++failedCount;
                        sw.setReachable(false);
                        failedList.append(sw.getIpAddress() + ", ");
                        continue;
                    }
                    sw.setReachable(true);
                }
                catch (Exception ex) {
                    ++failedCount;
                    sw.setReachable(false);
                    failedList.append(sw.getIpAddress() + ", ");
                }
            }
            if (failedList.length() > 0) {
                _Tracer.log(Level.WARN, "Failed to change credential to discovered switches:" + failedList.toString());
            }
            if (failedCount > 0 && failedCount == ethSws.size()) {
                _Tracer.log(Level.WARN, "Failed to authenticate all " + ethSws.size() + " discovered switches for " + this + " using " + newUser);
                StringBuilder failedList1 = new StringBuilder();
                for (EthSwitchImpl sw : ethSws) {
                    try {
                        sw.setCredential(oldValue);
                        if (sw.getPeerWithoutCreate() == null || !sw.getPeerWithoutCreate().hasCerdentialAs(oldValue)) {
                            sw.setReachable(false);
                            failedList1.append(sw.getIpAddress() + ", ");
                            continue;
                        }
                        sw.setReachable(true);
                    }
                    catch (Exception ex) {
                        sw.setReachable(false);
                        failedList1.append(sw.getIpAddress() + ", ");
                    }
                }
                if (failedList1.length() > 0) {
                    _Tracer.log(Level.WARN, "Failed to change credential back to discovered switches:" + failedList1.toString());
                }
                throw new Exception("Failed to authenticate switch " + failedList.toString());
            }
            this._base.setCredential(newUser);
            return true;
        }
        return false;
    }

    public boolean setCredentialTest(SnmpUser newUser) throws Exception {
        if (newUser == null) {
            return false;
        }
        SnmpUser oldValue = this._base.getCredential();
        if (!GenUtil.equals(oldValue, newUser)) {
            ArrayList<EthSwitchImpl> ethSws = new ArrayList<EthSwitchImpl>(this._discEthSwsBySwPK.values());
            StringBuilder failedList = new StringBuilder();
            int failedCount = 0;
            if (ethSws.size() == 0) {
                return false;
            }
            EthSwitchImpl sw = (EthSwitchImpl)ethSws.get(0);
            try {
                sw.setCredential(newUser);
                if (sw.getPeerWithoutCreate() == null || !sw.getPeerWithoutCreate().hasCerdentialAs(newUser)) {
                    ++failedCount;
                    sw.setReachable(false);
                    failedList.append(sw.getIpAddress() + ", ");
                } else {
                    sw.setReachable(true);
                }
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, "Failed to change credential to discovered switch:" + sw + " for " + this + ":" + ex);
                ++failedCount;
                sw.setReachable(false);
                failedList.append(sw.getIpAddress() + ", ");
            }
            if (failedList.length() > 0) {
                _Tracer.log(Level.WARN, "Failed to change credential to discovered switch:" + failedList.toString());
            }
            if (failedCount > 0) {
                _Tracer.log(Level.WARN, "Failed to authenticate switch " + sw + " for " + this + " using " + newUser);
                StringBuilder failedList1 = new StringBuilder();
                try {
                    sw.setCredential(oldValue);
                    if (sw.getPeerWithoutCreate() == null || !sw.getPeerWithoutCreate().hasCerdentialAs(oldValue)) {
                        sw.setReachable(false);
                        failedList1.append(sw.getIpAddress() + ", ");
                    } else {
                        sw.setReachable(true);
                    }
                }
                catch (Exception ex) {
                    sw.setReachable(false);
                    failedList1.append(sw.getIpAddress() + ", ");
                }
                if (failedList1.length() > 0) {
                    _Tracer.log(Level.WARN, "Failed to change credential back to discovered switch:" + failedList1.toString());
                }
                throw new Exception("Failed to authenticate switch " + failedList.toString());
            }
            this._base.setCredential(newUser);
            for (EthSwitchImpl discEthsw : ethSws) {
                discEthsw.setCredentialNoPeer(newUser);
                discEthsw.resetPeer();
            }
            return true;
        }
        return false;
    }

    public void setPeerTimeout(int timeout) {
        this._base.setPeerTimeout(timeout);
    }

    public void setPeerRetries(int retries) {
        this._base.setPeerRetries(retries);
    }

    @Override
    public String indent(int level) {
        if (level < 0) {
            return LIL[0];
        }
        if (level >= LIL.length) {
            return LIL[LIL.length - 1];
        }
        return LIL[level];
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._base.dump(inDetail, level));
        if (inDetail && this.getNumOfEthSwitches() > 0) {
            ArrayList<EthSwitchImpl> swList = new ArrayList<EthSwitchImpl>(this._discEthSwsBySwPK.values());
            for (EthSwitchImpl sw : swList) {
                sb.append(this.indent(level + 1)).append(sw.print(false, true)).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        return this._base.print(inDetail, withDecor);
    }

    @Override
    public String toString() {
        return this.print(false, true);
    }

    @Override
    public void setDBID(long dbid) {
        super.setDBID(dbid);
        this.getLan().addCdpSeedDBID(this);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public String getPurgeSqlStr() {
        return DeleteSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQL_SeedByTaskKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(CdpSeedImpl.getCheckExistenceSqlStr());
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    _Tracer.log(Level.WARN, "CdpSeedImpl cannot checkPreexistRecord for " + this, ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        PreparedStatement stat = null;
        if (this.getDBID() == 0L) {
            this.setDBID(this.getTaskKey().getId());
            stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
        } else {
            stat = con.prepareStatement(UpdateSQL);
            this.setupUpdateStatement(stat);
        }
        return stat;
    }

    @Override
    public PreparedStatement getCheckExistanceStatement(Connection con) throws SQLException {
        return con.prepareStatement(CdpSeedImpl.getCheckExistenceSqlStr());
    }

    @Override
    public PreparedStatement getInsertStatement(Connection con) throws SQLException {
        return con.prepareStatement(CdpSeedImpl.getInsertSqlStr());
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection con) throws SQLException {
        return con.prepareStatement(CdpSeedImpl.getUpdateSqlStr());
    }

    @Override
    public void flushed() {
        this.getBase().setFlushed(true);
    }

    @Override
    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getTaskKey().getId());
    }

    @Override
    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        List<InetAddress> seedIPs = this._base.getSeedIPs();
        stat.setLong(1, this.getDBID());
        stat.setLong(2, this.getLan().getDBID());
        stat.setNull(3, -2);
        stat.setNull(4, 12);
        stat.setNull(5, 12);
        stat.setNull(6, 12);
        stat.setLong(7, this._userDBID);
        stat.setLong(8, this._base.getMaxHop());
        this._lastDBUpdateTime = System.currentTimeMillis();
        stat.setTimestamp(9, new Timestamp(this._lastDBUpdateTime));
        stat.setNull(10, 12);
        stat.setNull(11, 12);
        stat.setInt(12, this._base.getTaskType().value());
        stat.setInt(13, this._base.getDiscState().value());
        stat.setString(14, IpUtil.getIPListInString(this._base.getSeedIPs(), ","));
        stat.setLong(15, this._base.getGroup());
        stat.setLong(16, this._base.getCreateTime());
        stat.setString(17, this._base.getEnablePwd());
        stat.setString(18, this._base.getDcnmUser());
        stat.setLong(19, this._base.getDeepTaskId());
        stat.setLong(20, this._base.getDeepUpdateTime());
        stat.setBoolean(21, this._base.isManageable());
        stat.setBoolean(22, this._base.isFwsm());
    }

    @Override
    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        List<InetAddress> seedIPs = this._base.getSeedIPs();
        stat.setLong(1, this.getLan().getDBID());
        stat.setNull(2, -2);
        stat.setNull(3, 12);
        stat.setNull(4, 12);
        stat.setNull(5, 12);
        stat.setLong(6, this._userDBID);
        stat.setLong(7, this._base.getMaxHop());
        this._lastDBUpdateTime = System.currentTimeMillis();
        stat.setTimestamp(8, new Timestamp(this._lastDBUpdateTime));
        stat.setNull(9, 12);
        stat.setNull(10, 12);
        stat.setInt(11, this._base.getTaskType().value());
        stat.setInt(12, this._base.getDiscState().value());
        stat.setString(13, IpUtil.getIPListInString(this._base.getSeedIPs(), ","));
        stat.setLong(14, this._base.getGroup());
        stat.setLong(15, this._base.getCreateTime());
        stat.setString(16, this._base.getEnablePwd());
        stat.setString(17, this._base.getDcnmUser());
        stat.setLong(18, this._base.getDeepTaskId());
        stat.setLong(19, this._base.getDeepUpdateTime());
        stat.setBoolean(20, this._base.isManageable());
        stat.setBoolean(21, this._base.isFwsm());
        stat.setLong(22, this.getDBID());
    }

    public void setUserDBID(long id) {
        this._userDBID = id;
    }

    public long getUserDBID() {
        return this._userDBID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(LanImpl lan) throws SQLException {
        ArrayList<CdpSeedImpl> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            queryStat = con.prepareStatement(QuerySQL_SeedsByLanDBID);
            queryStat.setLong(1, lan.getDBID());
            rs = queryStat.executeQuery();
            ArrayList<CdpSeedImpl> al = CdpSeedImpl.loadDBRecord(rs, lan);
            for (int i = 0; i < al.size(); ++i) {
                CdpSeedImpl seed = al.get(i);
                lan.addCdpSeed(seed);
                CdpSeedImpl.loadAssocSwitchesFromDB(seed);
            }
            arrayList = al;
        }
        catch (SQLException ex) {
            ArrayList arrayList2;
            try {
                _Tracer.log(Level.WARN, "Failed to load cdp seed", ex);
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        DbUtil.close(con);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(LanImpl lan, TaskKey cdpTask) throws SQLException {
        ArrayList<CdpSeedImpl> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement queryStat = null;
        ResultSet rs = null;
        try {
            queryStat = con.prepareStatement(QuerySQL_SeedByTaskKey);
            queryStat.setLong(1, cdpTask.getId());
            rs = queryStat.executeQuery();
            ArrayList<CdpSeedImpl> al = CdpSeedImpl.loadDBRecord(rs, lan);
            for (int i = 0; i < al.size(); ++i) {
                CdpSeedImpl seed = al.get(i);
                lan.addCdpSeed(seed);
                CdpSeedImpl.loadAssocSwitchesFromDB(seed);
            }
            arrayList = al;
        }
        catch (SQLException ex) {
            ArrayList arrayList2;
            try {
                _Tracer.log(Level.WARN, "Failed to load cdp seed", ex);
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(queryStat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(queryStat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(queryStat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList<CdpSeedImpl> loadDBRecord(ResultSet rs, LanImpl lan) throws SQLException {
        ArrayList<CdpSeedImpl> al = new ArrayList<CdpSeedImpl>();
        while (rs.next()) {
            try {
                List<InetAddress> list;
                long dbid = rs.getLong(1);
                TaskKey taskKey = new TaskKey(dbid);
                Long lanDBID = rs.getLong(2);
                HashSet<InetAddress> ipSet = new HashSet<InetAddress>();
                try {
                    byte[] b = rs.getBytes(3);
                    if (b != null) {
                        ipSet.add(InetAddress.getByAddress(b));
                    }
                }
                catch (Exception ex) {
                    _Tracer.log(Level.WARN, "CdpSeedImpl cannot get ip", ex);
                }
                Long userDBID = rs.getLong(7);
                SnmpUser credential = null;
                try {
                    credential = SnmpUserImpl.loadFromDB(userDBID);
                }
                catch (Exception ex) {
                    _Tracer.log(Level.WARN, "CdpSeedImpl cannot load credential from DB record", ex);
                }
                SnmpUserOpt snmpUser = null;
                if (credential != null) {
                    snmpUser = SnmpUserOpt.convertToSnmpUserOpt(credential);
                }
                int maxHop = rs.getInt(8);
                Timestamp dbUpdateTime = rs.getTimestamp(9);
                DiscTaskType taskType = DiscTaskType.getType(rs.getInt(12));
                DiscStateType discState = DiscStateType.getType(rs.getInt(13));
                String ipStr = rs.getString(14);
                if (ipStr != null && ipStr.length() > 0 && (list = IpUtil.getIPListFromString(ipStr, ",")) != null) {
                    ipSet.addAll(list);
                }
                ArrayList<InetAddress> ipList = new ArrayList<InetAddress>(ipSet);
                Long groupDBID = rs.getLong(15);
                if (groupDBID < 2L) {
                    groupDBID = new Long(2L);
                }
                Long createTime = rs.getLong(16);
                String enablePwd = rs.getString(17);
                String dcnmUser = rs.getString(18);
                Long deepTaskId = rs.getLong(19);
                Long deepUpdateTime = rs.getLong(20);
                boolean manageable = rs.getBoolean(21);
                boolean fwsm = rs.getBoolean(22);
                CdpSeedImpl task = null;
                task = taskType == DiscTaskType.LAN_MAXHOP ? new CdpSeedImpl(taskKey, (InetAddress)ipList.get(0), maxHop, snmpUser, enablePwd, (long)groupDBID, (long)createTime, dcnmUser, false) : new CdpSeedImpl(taskKey, ipList, maxHop, snmpUser, enablePwd, (long)groupDBID, (long)createTime, dcnmUser, false);
                task.setDiscState(discState);
                task.setDBID(dbid);
                if (dbUpdateTime != null) {
                    task.setLastUpdateTime(dbUpdateTime.getTime());
                }
                if (deepTaskId != null) {
                    task.setDeepTaskId(deepTaskId);
                }
                if (deepUpdateTime != null) {
                    task.setDeepUpdateTime(deepUpdateTime);
                }
                task.setManageable(manageable);
                task.setNeedDisc(manageable);
                task.setFwsm(fwsm);
                al.add(task);
            }
            catch (Exception ex) {
                _Tracer.log(Level.WARN, "CdpSeedImpl cannot load instance from DB record", ex);
            }
        }
        return al;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAssocSwitchesFromDB(CdpSeedImpl seed) throws SQLException {
        if (seed == null) {
            return;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        LanImpl lan = seed.getLan();
        try {
            stat = con.prepareStatement(QuerySQL_SwDBIDBySeedDBID);
            stat.setLong(1, seed.getDBID());
            rs = stat.executeQuery();
            while (rs.next()) {
                long swDBID = rs.getLong(1);
                EthSwitchImpl sw = lan.findEthSwitchByDBID(swDBID);
                if (sw == null) continue;
                seed.addEthSwitch(sw);
            }
        }
        catch (Exception ex) {
            try {
                _Tracer.log(Level.WARN, seed + " loadAssocSwitchesFromDB failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findNavGroupDBIdFromDB(EthSwitchImpl sw) throws SQLException {
        long grpDBID2;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block6: {
            long grpDBID2;
            if (sw == null) {
                return -1L;
            }
            con = ConnectionManager.getConnection();
            stat = null;
            rs = null;
            stat = sw instanceof FexImpl ? con.prepareStatement(QuerySQL_NavGroupDBIDByFexSwDBID) : con.prepareStatement(QuerySQL_NavGroupDBIDBySwDBID);
            stat.setLong(1, sw.getDBID());
            rs = stat.executeQuery();
            if (!rs.next()) break block6;
            long l = grpDBID2 = rs.getLong(1);
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return l;
        }
        try {
            grpDBID2 = -1L;
        }
        catch (Exception ex) {
            long l;
            try {
                _Tracer.log(Level.WARN, sw + " findNavGroupDBIdFromDB ", ex);
                l = -1L;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return l;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return grpDBID2;
    }

    @Override
    public List<Short> getVlanIds() {
        return Collections.EMPTY_LIST;
    }
}

