/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.util.IntPair;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.DumpIf;
import com.cisco.dcbu.sm.common.model.EthIslBase;
import com.cisco.dcbu.sm.common.model.IslIf;
import com.cisco.dcbu.sm.common.type.EthIslPK;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.SwitchIntKeyIf;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.EthDBObjectIf;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.FexIslImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.model.VlanImpl;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class EthIslImpl
extends AbstractModelObjectImpl
implements IslIf<EthIslPK>,
DumpIf,
EthDBObjectIf {
    static final TraceLogger _Tracer = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    static final String TableName = "ethisl";
    static final String InsertSQL = "insert into ethisl(id, port1_id, port2_id, oper_mode, is_present, last_update_time, last_scan_time, is_channel, is_trunk, native_vlanid, access_vlanid, channel_id, is_fexisl) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?)";
    static final String DeleteSQL = "delete from ethisl where id=?";
    static final String UpdateSQL = "update ethisl set port1_id=?, port2_id=?, oper_mode=?, is_present=?, last_update_time=?, last_scan_time=?, is_channel=?, is_trunk=?, native_vlanid=?, access_vlanid=?, channel_id=?, is_fexisl=? where id=?";
    static final String QuerySQL = "select id, port1_id, port2_id, oper_mode, is_present, last_update_time, last_scan_time, is_channel, is_trunk, native_vlanid, access_vlanid, channel_id, is_fexisl from ethisl";
    static final String QuerySQL_ByLanDBID = "select id, port1_id, port2_id, oper_mode, is_present, last_update_time, last_scan_time, is_channel, is_trunk, native_vlanid, access_vlanid, channel_id, is_fexisl from ethisl where ethisl.port1_id in (select eisl1.port1_id from ethisl eisl1, ethswitch_port esp  where eisl1.port1_id=esp.id and esp.id in (select esp1.id from ethswitch_port esp1, lanswitch_map lsm where esp1.switch_id=lsm.id and lsm.lan_id=?))";
    static final String QuerySQL_ByPortDBIDs = "select id from ethisl where (port1_id=? and port2_id=?) or (port1_id=? and port2_id=?)";
    static final String VlanDBTableName = "ethisl_vlan";
    static final String InsertVlanSQL = "insert into ethisl_vlan (isl_id, vlan_id, last_update_time) values(?,?,?)";
    static final String DeleteVlanSQL_ByIslDBID = "delete ethisl_vlan where isl_id=?";
    static final String UpdateVlanSQL = "update ethisl_vlan set last_update_time=? where isl_id=? and vlan_id=?";
    static final String QueryVlanSQL_ByIslDBIDs = "select isl_id, vlan_id, last_update_time from ethisl_vlan where isl_id=?";
    static final String QueryVlanSQL_DBIDByIslVlanDBIDs = "select id from ethisl_vlan where isl_id=? and vlan_id=?";
    protected EthIslBase _base = null;
    protected EthSwitchImpl _sw1;
    protected EthSwitchImpl _sw2;
    protected EthPortImpl _port1;
    protected EthPortImpl _port2;
    protected EthIslImpl _parent = null;
    protected long _lastUpdateTime;

    protected EthIslImpl() {
    }

    public EthIslImpl(EthSwitchImpl sw1, EthSwitchImpl sw2, int ifIndex1, int ifIndex2) {
        EthIslPK pkey = new EthIslPK(sw1.getSwitchPK(), sw2.getSwitchPK(), ifIndex1, ifIndex2);
        this._base = new EthIslBase(pkey);
        if (pkey.getSwitch1Key().equals(sw1.getSwitchPK())) {
            this._sw1 = sw1;
            this._sw2 = sw2;
        } else {
            this._sw1 = sw2;
            this._sw2 = sw1;
        }
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public EthIslBase getBase() {
        return this._base;
    }

    @Override
    public FabricImpl getFabric() {
        throw new UnsupportedOperationException("Invalid call lan object");
    }

    @Override
    public EthIslPK getIslPK() {
        return this._base.getIslPK();
    }

    public void setSwitchPortImpl(EthPortImpl port1, EthPortImpl port2) {
        if (port1 != null) {
            if (this._base.getIslPK()._p1.equals(port1.getPK())) {
                this._port1 = port1;
            } else {
                this._port2 = port1;
            }
        }
        if (port2 != null) {
            if (this._base.getIslPK()._p2.equals(port2.getPK())) {
                this._port2 = port2;
            } else {
                this._port1 = port2;
            }
        }
    }

    public EthPortImpl getPort1() {
        return this._port1;
    }

    public EthPortImpl getPort2() {
        return this._port2;
    }

    @Override
    public PKIf getSwitch1PK() {
        return this._sw1.getPK();
    }

    @Override
    public PKIf getSwitch2PK() {
        return this._sw2.getPK();
    }

    public EthSwitchImpl getSwitch1() {
        return this._sw1;
    }

    public EthSwitchImpl getSwitch2() {
        return this._sw2;
    }

    @Override
    public int getIfIndex1() {
        return this._base.getIfIndex1();
    }

    @Override
    public int getIfIndex2() {
        return this._base.getIfIndex2();
    }

    public String getIfIndex1Name() {
        return this._sw1.getBase().ifIndexToName(this.getIfIndex1());
    }

    public String getIfIndex2Name() {
        return this._sw2.getBase().ifIndexToName(this.getIfIndex2());
    }

    public SwitchIntKeyIf getSwitch1IntKey() {
        return this._base.getIslPK().getSwitchIntKey1();
    }

    public SwitchIntKeyIf getSwitch2IntKey() {
        return this._base.getIslPK().getSwitchIntKey2();
    }

    public EthSwitchImpl getNbrSwitch(PKIf swPK) {
        if (this._base.getSwitch1PK().equals(swPK)) {
            return this._sw2;
        }
        if (this._base.getSwitch2PK().equals(swPK)) {
            return this._sw1;
        }
        return null;
    }

    public int getNbrIfIndex(PKIf swPK) {
        if (this._base.getSwitch1PK().equals(swPK)) {
            return this._base.getIfIndex2();
        }
        if (this._base.getSwitch2PK().equals(swPK)) {
            return this._base.getIfIndex1();
        }
        return 0;
    }

    @Override
    public boolean isPresent() {
        return this._base.isPresent();
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent != isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)1281, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, "EthIslImpl trace setPresent:old=" + wasPresent + "-->new=" + isPresent + " for " + this.print(false, true), new Exception("TraceLogger"));
            }
        }
        return wasPresent;
    }

    public int getOperMode() {
        return this._base.getOperMode();
    }

    public void setOperMode(int operMode) {
        if (this._base.getOperMode() != operMode) {
            Integer oldMode = new Integer(this._base.getOperMode());
            this._base.setOperMode(operMode);
            this.propertyChanged((short)1282, oldMode, new Integer(operMode));
        }
    }

    public void setSpeed(long speed) {
        if (this._base.getSpeed() != speed) {
            Long oldSpeed = new Long(this._base.getSpeed());
            this._base.setSpeed(speed);
            this.propertyChanged((short)1288, oldSpeed, new Long(speed));
        }
    }

    @Override
    public long getSpeed() {
        return this._base.getSpeed();
    }

    @Override
    public boolean isPortChannel() {
        return this._base.isPortChannel();
    }

    public void setPortChannel(boolean isChannel) {
        boolean oldValue = this._base.isPortChannel();
        if (oldValue != isChannel) {
            this._base.setPortChannel(isChannel);
            this.propertyChanged((short)1298, Boolean.valueOf(oldValue), Boolean.valueOf(this._base.isPortChannel()));
        }
    }

    @Override
    public int getChildCount() {
        return this._base.getChildCount();
    }

    @Override
    public List<int[]> getChildren() {
        return this._base.getChildren();
    }

    public List<IntPair> getChildrenPairs() {
        return this._base.getChildrenPairs();
    }

    public boolean containChild(PKIf sw1PK, PKIf sw2PK, int childIfindex1, int childIfindex2) {
        return this._base.containChild(sw1PK, sw2PK, childIfindex1, childIfindex2);
    }

    public void setChildren(PKIf sw1PK, PKIf sw2PK, List<int[]> children) {
        List<int[]> oldValue = this._base.getChildren();
        if (this._base.setChildren(sw1PK, sw2PK, children)) {
            this.propertyChanged((short)1298, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getChildren()));
        }
    }

    public void addChild(PKIf sw1PK, PKIf sw2PK, int childIfindex1, int childIfindex2) {
        List<int[]> oldValue = this._base.getChildren();
        if (this._base.addChild(sw1PK, sw2PK, childIfindex1, childIfindex2)) {
            this.propertyChanged((short)1298, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getChildren()));
        }
    }

    public void removeChild(PKIf sw1PK, PKIf sw2PK, int childIfindex1, int childIfindex2) {
        List<int[]> oldValue = this._base.getChildren();
        if (this._base.removeChild(sw1PK, sw2PK, childIfindex1, childIfindex2)) {
            this.propertyChanged((short)1298, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getChildren()));
        }
    }

    public void clearChildren() {
        List<int[]> oldValue = this._base.getChildren();
        if (this._base.clearChildren()) {
            this.propertyChanged((short)1298, (Serializable)((Object)oldValue), (Serializable)((Object)this._base.getChildren()));
        }
    }

    public void setParent(EthIslImpl parent) {
        this._parent = parent;
    }

    public EthIslImpl getParent() {
        return this._parent;
    }

    @Override
    public boolean isTrunk() {
        return this._base.isTrunk();
    }

    public void setTrunk(boolean trunk) {
        boolean oldValue = this._base.isTrunk();
        if (oldValue != trunk) {
            this._base.setTrunk(trunk);
            this.propertyChanged((short)1300, Boolean.valueOf(oldValue), Boolean.valueOf(this._base.isTrunk()));
        }
    }

    public void setNativeVlan(short nativeVlan) {
        short oldValue = this._base.getNativeVlan();
        if (oldValue != nativeVlan) {
            this._base.setNativeVlan(nativeVlan);
            this.propertyChanged((short)1296, Short.valueOf(oldValue), Short.valueOf(this._base.getNativeVlan()));
        }
    }

    public void setAccessVlan(short accessVlan) {
        short oldValue = this._base.getAccessVlan();
        if (oldValue != accessVlan) {
            this._base.setAccessVlan(accessVlan);
            this.propertyChanged((short)1299, Short.valueOf(oldValue), Short.valueOf(this._base.getAccessVlan()));
        }
    }

    public void setVlans(List<Short> vlanIds) {
        List<Short> oldVlans = this._base.getVlans();
        if (this._base.setVlans(vlanIds)) {
            this.propertyChanged((short)1291, (Serializable)((Object)oldVlans), (Serializable)((Object)this._base.getVlans()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, "EthIslImpl trace setVlans: old=" + oldVlans + "-->new=" + this._base.getVlans() + " for " + this._base.print(false, true), new Exception("TraceLogger"));
            }
        }
    }

    public void addVlan(short vlanId) {
        if (!this._base.containVlan(vlanId)) {
            List<Short> oldVlans = this._base.getVlans();
            this._base.addVlan(vlanId);
            this.propertyChanged((short)1291, (Serializable)((Object)oldVlans), (Serializable)((Object)this._base.getVlans()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, this._base.print(false, true) + "--EthIslImpl trace addVlan:" + vlanId + "--old=" + oldVlans + "-->new=" + this._base.getVlans(), new Exception("TraceLogger"));
            }
        }
    }

    public void removeVlan(short vlanId) {
        if (this._base.containVlan(vlanId)) {
            List<Short> oldVlans = this._base.getVlans();
            this._base.removeVlan(vlanId);
            this.propertyChanged((short)1291, (Serializable)((Object)oldVlans), (Serializable)((Object)this._base.getVlans()));
            if (_Tracer.isDebuggable()) {
                _Tracer.log(Level.DEBUG, this._base.print(false, true) + "--EthIslImpl trace removeVlan:" + vlanId + "--old=" + oldVlans + "-->new=" + this._base.getVlans(), new Exception("TraceLogger"));
            }
        }
    }

    public void cleanVlans() {
        List<Short> oldVlans = this._base.getVlans();
        if (this._base.clearVlans()) {
            this.propertyChanged((short)1291, (Serializable)((Object)oldVlans), (Serializable)((Object)this._base.getVlans()));
        }
    }

    @Override
    public List<Short> getVlanIds() {
        return this._base.getVlans();
    }

    public void setMatchStatus(String match) {
        if (match != null && !match.equals(this._base.getMatchStatus())) {
            this._base.setMatchStatus(match);
        }
    }

    public void resetMatchStatus() {
        this._base.resetMatchStatus();
    }

    @Override
    public String indent(int level) {
        return this._base.indent(level);
    }

    public String dumpIfindexNum(int ifindex, boolean withBrace) {
        if (withBrace) {
            return "(" + ifindex + "-0x" + Integer.toHexString(ifindex) + ")";
        }
        return ifindex + "-0x" + Integer.toHexString(ifindex);
    }

    @Override
    public String dump(boolean inDetail, int level) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(this.indent(level)).append("Ethernet ISL: ").append(this._sw1.getName()).append(',').append(this._sw1.ifIndexToName(this.getIfIndex1())).append(this.dumpIfindexNum(this.getIfIndex1(), true)).append(" <-> ").append(this._sw2.getName()).append(',').append(this._sw2.ifIndexToName(this.getIfIndex2())).append(this.dumpIfindexNum(this.getIfIndex2(), true));
            sb.append(this.indent(level + 1)).append("Status: ").append(this.isPresent() ? "up" : "down").append(", LastScanTime: " + new Date(this.getLastScanTime())).append(this.indent(level + 1)).append("Active Vlans: ").append(this._base.getVlanIdsAsString());
            if (inDetail) {
                sb.append(this.indent(level + 1)).append("OperMode: ").append(this.getOperMode()).append(this.indent(level + 1)).append("Speed: ").append(this.getSpeed()).append(" bps").append(this.indent(level + 1)).append("Access Vlan: ").append(this._base.getAccessVlan() == -1 ? "None" : String.valueOf(this._base.getAccessVlan())).append(this.indent(level + 1)).append("Native Vlan: ").append(this._base.getNativeVlan() == -1 ? "None" : String.valueOf(this._base.getNativeVlan())).append(this.indent(level + 1)).append("IsTrunk: ").append(this.isTrunk()).append(this.indent(level + 1)).append("IsChannel: ").append(this.isPortChannel());
                if (this.isPortChannel() && this.getChildCount() > 0) {
                    int i;
                    sb.append(this.indent(level + 1)).append("Children: ");
                    List<int[]> chList = this.getChildren();
                    ArrayList<Integer> ch1List = new ArrayList<Integer>(chList.size());
                    ArrayList<Integer> ch2List = new ArrayList<Integer>(chList.size());
                    for (int[] pair : chList) {
                        ch1List.add(pair[0]);
                        ch2List.add(pair[1]);
                    }
                    for (i = 0; i < ch1List.size(); ++i) {
                        sb.append(this._sw1.ifIndexToName((Integer)ch1List.get(i))).append(",");
                    }
                    if (sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append("<->");
                    for (i = 0; i < ch2List.size(); ++i) {
                        sb.append(this._sw2.ifIndexToName((Integer)ch2List.get(i))).append(",");
                    }
                    if (sb.charAt(sb.length() - 1) == ',') {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
                if (this._base.getMatchStatus() != null && this._base.getMatchStatus().length() > 0) {
                    sb.append(this.indent(level + 1)).append("Warning:").append(this._base.getMatchStatus());
                }
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.DEBUG, "EthIsl cannot get dump string", e);
        }
        return sb.toString();
    }

    @Override
    public String print(boolean inDetail, boolean withDecor) {
        StringBuilder sb = new StringBuilder();
        try {
            if (withDecor) {
                sb.append("EthIsl-").append(this._sw1.getName()).append(",").append(this._sw1.ifIndexToName(this.getIfIndex1())).append('(').append(this.getIfIndex1()).append(')').append("<->").append(this._sw2.getName()).append(",").append(this._sw2.ifIndexToName(this.getIfIndex2())).append('(').append(this.getIfIndex2()).append(')').append("[");
            } else {
                sb.append(this._sw1.getName()).append(",").append(this._sw1.ifIndexToName(this.getIfIndex1())).append('(').append(this.getIfIndex1()).append(')').append("<->").append(this._sw2.getName()).append(",").append(this._sw2.ifIndexToName(this.getIfIndex2())).append('(').append(this.getIfIndex2()).append(')').append(':');
            }
            sb.append(" ActiveVlans:").append(this._base.getVlanIdsAsString()).append(" ");
            if (this.isPortChannel() && this.getChildCount() > 0) {
                int i;
                List<int[]> chList = this.getChildren();
                ArrayList<Integer> ch1List = new ArrayList<Integer>(chList.size());
                ArrayList<Integer> ch2List = new ArrayList<Integer>(chList.size());
                for (int[] pair : chList) {
                    ch1List.add(pair[0]);
                    ch2List.add(pair[1]);
                }
                sb.append(this.getIfIndex1()).append("Children: ");
                for (i = 0; i < ch1List.size(); ++i) {
                    sb.append(this._sw1.ifIndexToName((Integer)ch1List.get(i))).append(",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append("<->");
                for (i = 0; i < ch2List.size(); ++i) {
                    sb.append(this._sw2.ifIndexToName((Integer)ch2List.get(i))).append(",");
                }
                if (sb.charAt(sb.length() - 1) == ',') {
                    sb.deleteCharAt(sb.length() - 1);
                }
            }
            if (inDetail) {
                sb.append(", Status=").append(this.isPresent() ? "up" : "down").append(", LastScanTime=" + new Date(this.getLastScanTime())).append(", OperMode=").append(this.getOperMode()).append(", Speed=").append(this.getSpeed()).append(" bps").append(", AccessVlan=").append(this._base.getAccessVlan() == -1 ? "None" : String.valueOf(this._base.getAccessVlan())).append(", NativeVlan=").append(this._base.getNativeVlan() == -1 ? "None" : String.valueOf(this._base.getNativeVlan())).append(", IsTrunked=").append(this._base.isTrunk()).append(", IsChannel=").append(this.isPortChannel());
            }
            if (withDecor) {
                sb.append("]");
            }
        }
        catch (Exception e) {
            _Tracer.log(Level.DEBUG, "EthIsl cannot get print string", e);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.print(false, false);
    }

    @Override
    public void setDBID(long dbid) {
        super.setDBID(dbid);
        this.getLan().addEthIslDBID(this);
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQL_ByPortDBIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = con.prepareStatement(QuerySQL_ByPortDBIDs);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public PreparedStatement getCheckExistanceStatement(Connection con) throws SQLException {
        return con.prepareStatement(EthIslImpl.getCheckExistenceSqlStr());
    }

    @Override
    public PreparedStatement getInsertStatement(Connection con) throws SQLException {
        return con.prepareStatement(EthIslImpl.getInsertSqlStr());
    }

    @Override
    public PreparedStatement getUpdateStatement(Connection con) throws SQLException {
        return con.prepareStatement(EthIslImpl.getUpdateSqlStr());
    }

    @Override
    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._port1.getDBID());
        stat.setLong(2, this._port2.getDBID());
        stat.setLong(3, this._port2.getDBID());
        stat.setLong(4, this._port1.getDBID());
    }

    @Override
    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setLong(i++, this._port1.getDBID());
        stat.setLong(i++, this._port2.getDBID());
        stat.setInt(i++, this.getOperMode());
        stat.setBoolean(i++, this.isPresent());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getLastScanTime());
        stat.setBoolean(i++, this._base.isPortChannel());
        stat.setBoolean(i++, this._base.isTrunk());
        stat.setInt(i++, this._base.getNativeVlan());
        stat.setInt(i++, this._base.getAccessVlan());
        if (this.getParent() != null) {
            stat.setLong(i++, this.getParent().getDBID());
        } else {
            stat.setLong(i++, -1L);
        }
        stat.setBoolean(i++, this._base.isFexIsl());
    }

    @Override
    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this._port1.getDBID());
        stat.setLong(i++, this._port2.getDBID());
        stat.setInt(i++, this.getOperMode());
        stat.setBoolean(i++, this.isPresent());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getLastScanTime());
        stat.setBoolean(i++, this._base.isPortChannel());
        stat.setBoolean(i++, this._base.isTrunk());
        stat.setInt(i++, this._base.getNativeVlan());
        stat.setInt(i++, this._base.getAccessVlan());
        if (this.getParent() != null) {
            stat.setLong(i++, this.getParent().getDBID());
        } else {
            stat.setLong(i++, -1L);
        }
        stat.setBoolean(i++, this._base.isFexIsl());
        stat.setLong(i++, this.getDBID());
    }

    @Override
    public void flushed() {
        this.getBase().setFlushed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList loadFromDB(LanImpl lan) throws SQLException {
        ArrayList<EthIslImpl> arrayList;
        if (lan == null) {
            return null;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQL_ByLanDBID);
            stat.setLong(1, lan.getDBID());
            rs = stat.executeQuery();
            ArrayList<EthIslImpl> list = EthIslImpl.loadDBRecord(rs, lan);
            for (EthIslImpl ethIsl : list) {
                EthIslImpl.loadAssocVlansFromDB(ethIsl);
            }
            arrayList = list;
        }
        catch (Exception ex) {
            try {
                _Tracer.log(Level.WARN, lan + " load ethisl from DB failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return null;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList<EthIslImpl> loadDBRecord(ResultSet rs, LanImpl lan) throws SQLException {
        if (rs == null || lan == null) {
            return new ArrayList<EthIslImpl>(0);
        }
        ArrayList<EthIslImpl> list = new ArrayList<EthIslImpl>();
        HashMap<Long, EthIslImpl> channels = new HashMap<Long, EthIslImpl>();
        HashMap<IntPair, Long> children = new HashMap<IntPair, Long>();
        while (rs.next()) {
            EthPortImpl ethPort1 = EthPortImpl.queryEthPortByDbId(lan, rs.getLong(2));
            EthPortImpl ethPort2 = EthPortImpl.queryEthPortByDbId(lan, rs.getLong(3));
            if (ethPort1 == null || ethPort2 == null || ethPort1.getSwitch() == null || ethPort2.getSwitch() == null) continue;
            long channelDBID = rs.getLong(12);
            if (channelDBID > 0L) {
                children.put(new IntPair(ethPort1.getIfIndex(), ethPort2.getIfIndex()), channelDBID);
                continue;
            }
            EthIslImpl ethIsl = null;
            boolean isFexIsl = rs.getBoolean(13);
            ethIsl = isFexIsl ? new FexIslImpl(ethPort1.getSwitch(), ethPort2.getSwitch(), ethPort1.getIfIndex(), ethPort2.getIfIndex()) : new EthIslImpl(ethPort1.getSwitch(), ethPort2.getSwitch(), ethPort1.getIfIndex(), ethPort2.getIfIndex());
            ethIsl.setDBID(rs.getLong(1));
            ethIsl._base.setOperMode((short)rs.getInt(4));
            ethIsl._base.setPresent(rs.getBoolean(5));
            ethIsl._base.setLastScanTime(rs.getLong(7));
            boolean isChannel = rs.getBoolean(8);
            ethIsl._base.setPortChannel(isChannel);
            if (isChannel) {
                channels.put(ethIsl.getDBID(), ethIsl);
            }
            ethIsl._port1 = ethPort1;
            ethIsl._port2 = ethPort2;
            lan.addEthIsl(ethIsl);
            list.add(ethIsl);
        }
        for (Map.Entry mem : children.entrySet()) {
            EthIslImpl channel = (EthIslImpl)channels.get(mem.getValue());
            if (channel == null) continue;
            channel.getBase().addChild((IntPair)mem.getKey());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadAssocVlansFromDB(EthIslImpl ethIsl) throws SQLException {
        ArrayList<Short> arrayList;
        if (ethIsl == null) {
            return null;
        }
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QueryVlanSQL_ByIslDBIDs);
            stat.setLong(1, ethIsl.getDBID());
            rs = stat.executeQuery();
            arrayList = EthIslImpl.loadVlanDBRecord(rs, ethIsl);
        }
        catch (SQLException ex) {
            ArrayList arrayList2;
            try {
                _Tracer.log(Level.WARN, ethIsl + " load eth isl vlans from DB failed", ex);
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    static ArrayList<Short> loadVlanDBRecord(ResultSet rs, EthIslImpl ethIsl) throws SQLException {
        if (ethIsl == null) {
            return null;
        }
        ArrayList<Short> vlanIds = new ArrayList<Short>();
        LanImpl lan = ethIsl.getLan();
        while (rs.next()) {
            long vlanDBID = rs.getLong(1);
            VlanImpl vlan = lan.findVlanByDBID(vlanDBID);
            if (vlan == null) continue;
            vlanIds.add(vlan.getVlanPK()._id);
        }
        ethIsl.setVlans(vlanIds);
        return vlanIds;
    }
}

