/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public final class FabricSwitchImpl
extends AbstractDBObjectImpl {
    static final String QuerySQLByFabricId = "select fabric_switch_info.fabric_id, fabric_switch_info.switch_id from fabric_switch_info, fabric where fabric.fabric_id = ? and fabric_switch_info.fabric_id = fabric.id";
    static final String QuerySQLByFabricIdSwitchId = "select fabric_id, switch_id from fabric_switch_info where fabric_id=? and switch_id=?";
    static final String InsertSQL = "insert into fabric_switch_info(fabric_id, switch_id, last_update_time) values(?,?,?)";
    static final String UpdateSQL = "update fabric_switch_info set last_update_time=? where fabric_id=? and switch_id=?";
    static final String TableName = "fabric_switch_info";
    final FabricImpl _fabric;
    final SwitchImpl _sw;

    public FabricSwitchImpl(FabricImpl fabric, SwitchImpl sw) throws IllegalArgumentException {
        if (fabric == null || sw == null) {
            throw new IllegalArgumentException("Null fabric or switch is not allowed");
        }
        this._fabric = fabric;
        this._sw = sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = con.prepareStatement(QuerySQLByFabricIdSwitchId);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(1L);
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromDB(FabricImpl fImpl) throws SQLException {
        block5: {
            Connection con = ConnectionManager.getConnection();
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByFabricId);
                stat.setLong(1, fImpl.getDBID());
                rs = stat.executeQuery();
                FabricSwitchImpl.loadDBRecord(rs, fImpl);
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block5;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
    }

    public static void loadDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        if (fImpl == null) {
            return;
        }
        while (rs.next()) {
            SwitchImpl swImpl = fImpl.findSwitchByDbId(rs.getLong(2));
            if (swImpl == null) continue;
            fImpl.addSwitch(swImpl);
        }
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByFabricIdSwitchId;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._fabric.getDBID());
        stat.setLong(2, this._sw.getDBID());
        stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
        stat.setLong(2, this._fabric.getDBID());
        stat.setLong(3, this._sw.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this._fabric.getDBID());
        stat.setLong(2, this._sw.getDBID());
    }
}

