/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.HostMapBase;
import com.cisco.dcbu.sm.common.util.TraceLogger;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class HostMapImpl
extends AbstractModelObjectImpl {
    static final TraceLogger _logger = new TraceLogger(Logger.getLogger((String)"fms.model"), false, false, false, false);
    public static final String QuerySQL = "select id, host_id, enclosure_id, vhost_id, lanhost_id, created_time, last_updated_time from host_map";
    public static final String QueryLanHostSQL = "select id, host_id, enclosure_id, vhost_id, lanhost_id, created_time, last_updated_time from host_map where lanhost_id>0";
    public static final String QuerySanHostSQL = "select id, host_id, enclosure_id, vhost_id, lanhost_id, created_time, last_updated_time from host_map where enclosure_id>0";
    public static final String QuerySQLExistingRecord = "select id, host_id, enclosure_id, vhost_id, lanhost_id from host_map where host_id=? AND enclosure_id=? AND vhost_id=? AND lanhost_id=?";
    public static final String QuerySQLByHostId = "select id, host_id, enclosure_id, vhost_id, lanhost_id, created_time, last_updated_time from host_map where host_id=?";
    public static final String QueryHostIdsSQL = "select distinct host_id from host_map";
    public static final String DeleteAllSQL = "delete from host_map";
    public static final String DeleteAllLanHostSQL = "delete from host_map where lanhost_id > 0";
    public static final String DeleteByIdSQL = "delete from host_map where id=?";
    public static final String DeleteByLanHostIdSQL = "delete from host_map where lanhost_id=?";
    public static final String InsertSQL = "insert into host_map(id, host_id, enclosure_id, vhost_id, lanhost_id, created_time, last_updated_time) values(?,?,?,?,?, ?,?)";
    public static final String UpdateSQL = "update host_map set host_id=?, enclosure_id=?, vhost_id=?, lanhost_id=?, last_updated_time=? where id=?";
    static final String TableName = "HOST_MAP";
    private final HostMapBase base;

    public HostMapImpl(long hostId, long enclosureId, long vhostId, long lanhostId) {
        this.base = new HostMapBase(hostId, enclosureId, vhostId, lanhostId);
    }

    public HostMapImpl(HostMapBase hostMap) {
        this.base = hostMap;
    }

    @Override
    public void setDBID(long id) {
        this.base.setId(id);
        super.setDBID(id);
    }

    public long getHostId() {
        return this.base.getHostId();
    }

    public void setHostId(long id) {
        this.base.setHostId(id);
    }

    public long getEnclosureId() {
        return this.base.getEnclosureId();
    }

    public long getVhostId() {
        return this.base.getVhostId();
    }

    public long getLanHostId() {
        return this.base.getLanhostId();
    }

    public Timestamp getCreateTime() {
        return this.base.getCreateTime();
    }

    public void setCreateTime(Timestamp time) {
        this.base.setCreateTime(time);
    }

    public Timestamp getLastUpdateTime() {
        return this.base.getLastUpdateTime();
    }

    public void setLastUpdateTime(Timestamp time) {
        this.base.setLastUpdateTime(time);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this.base;
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this.base.isPresent();
        if (wasPresent ^ isPresent) {
            this.base.setPresent(isPresent);
            this.propertyChanged((short)1793, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLExistingRecord);
                stat.setLong(1, this.base.getHostId());
                stat.setLong(2, this.base.getEnclosureId());
                stat.setLong(3, this.base.getVhostId());
                stat.setLong(4, this.base.getLanhostId());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _logger.log(Level.ERROR, "checkPreexistRecord caught exception", ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.getDBID());
        stat.setLong(i++, this.base.getHostId());
        stat.setLong(i++, this.base.getEnclosureId());
        stat.setLong(i++, this.base.getVhostId());
        stat.setLong(i++, this.base.getLanhostId());
        Timestamp time = new Timestamp(System.currentTimeMillis());
        stat.setTimestamp(i++, time);
        stat.setTimestamp(i++, time);
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        int i = 1;
        stat.setLong(i++, this.base.getHostId());
        stat.setLong(i++, this.base.getEnclosureId());
        stat.setLong(i++, this.base.getVhostId());
        stat.setLong(i++, this.base.getLanhostId());
        stat.setTimestamp(i++, new Timestamp(System.currentTimeMillis()));
        stat.setLong(i++, this.getDBID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHostMap(Connection con, HostMapImpl hostMap) {
        if (hostMap == null) {
            return;
        }
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteByIdSQL);
            deleteStat.setLong(1, hostMap.getDBID());
            deleteStat.execute();
            _logger.log(Level.DEBUG, "done deleteHostMap: " + hostMap.getDBID());
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.log(Level.WARN, "deleteHostMaps failed and rollback", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "deleteHostMaps failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "deleteHostMaps failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteHostMaps caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllHostMaps(Connection con) {
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteAllSQL);
            deleteStat.execute();
            _logger.log(Level.INFO, "deleteAllHostMaps finished in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (SQLException sqlex) {
            _logger.log(Level.WARN, "deleteAllHostMaps failed", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "deleteAllHostMaps failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "deleteAllHostMaps failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteAllHostMaps caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllLanHostMaps(Connection con) {
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteAllLanHostSQL);
            deleteStat.execute();
        }
        catch (SQLException sqlex) {
            _logger.log(Level.WARN, "deleteAllLanHostMaps failed", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "deleteAllLanHostMaps failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "deleteAllLanHostMaps failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteAllLanHostMaps caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.log(Level.INFO, "deleteAllLanHostMaps finished in " + (System.currentTimeMillis() - startTime) + "ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHostMaps(Connection con, List<HostMapImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        try {
            deleteStat = con.prepareStatement(DeleteByIdSQL);
            for (HostMapImpl h : hosts) {
                if (h == null) continue;
                try {
                    deleteStat.setLong(1, h.getDBID());
                    deleteStat.addBatch();
                }
                catch (NullPointerException e) {
                    _logger.log(Level.ERROR, "deleteHostMap '" + h + "' failed", e);
                }
            }
            deleteStat.executeBatch();
            _logger.log(Level.DEBUG, "deleteHostMaps finished in " + (System.currentTimeMillis() - startTime) + "ms, deleted: " + hosts.size());
        }
        catch (SQLException sqlex) {
            try {
                if (con != null) {
                    con.rollback();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            _logger.log(Level.WARN, "deleteHostMaps failed and rollback", sqlex);
            if (sqlex != null && sqlex.getNextException() != null) {
                _logger.log(Level.WARN, "deleteHostMaps failed and got SQLException", sqlex.getNextException());
            } else {
                _logger.log(Level.WARN, "deleteHostMaps failed and got SQLException", sqlex);
            }
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteHostMaps caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteHostMapsByLanHostIds(Connection con, List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement deleteStat = null;
        int[] total = new int[]{};
        try {
            deleteStat = con.prepareStatement(DeleteByLanHostIdSQL);
            for (Long id : ids) {
                deleteStat.setLong(1, id);
                deleteStat.addBatch();
            }
            total = deleteStat.executeBatch();
        }
        catch (Exception ex) {
            _logger.log(Level.ERROR, "deleteHostMapsByLanHostId caught exception", ex);
        }
        finally {
            DbUtil.close(deleteStat);
        }
        _logger.log(Level.INFO, "deleteHostMapsByLanHostId finished in " + (System.currentTimeMillis() - startTime) + "ms, deleted: " + total.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getHostIds(Connection con) {
        ResultSet rs;
        PreparedStatement stat;
        ArrayList<Long> list;
        block5: {
            list = new ArrayList<Long>();
            stat = null;
            rs = null;
            try {
                stat = con.prepareStatement(QueryHostIdsSQL);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    list.add(rs.getLong(1));
                }
            }
            catch (SQLException ex) {
                try {
                    _logger.log(Level.ERROR, "getLanHostMaps failed", ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return list;
    }

    public static List<HostMapImpl> loadHostMapsByHostId(Connection con, long id) throws SQLException {
        List<HostMapImpl> hosts = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByHostId);
            stat.setLong(1, id);
            rs = stat.executeQuery();
            hosts = HostMapImpl.loadHostMapRecords(rs);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                throw throwable;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostMapImpl> getLanHostMaps(Connection con) {
        List<HostMapImpl> list = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QueryLanHostSQL);
            rs = stat.executeQuery();
            list = HostMapImpl.loadHostMapRecords(rs);
        }
        catch (SQLException ex) {
            try {
                _logger.log(Level.ERROR, "getLanHostMaps failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HostMapImpl> getSanHostMaps(Connection con) {
        List<HostMapImpl> list = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySanHostSQL);
            rs = stat.executeQuery();
            list = HostMapImpl.loadHostMapRecords(rs);
        }
        catch (SQLException ex) {
            try {
                _logger.log(Level.ERROR, "getSanHostMaps failed", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        return list;
    }

    public static List<HostMapImpl> loadHostMapRecords(ResultSet rs) throws SQLException {
        ArrayList<HostMapImpl> list = new ArrayList<HostMapImpl>();
        if (rs == null) {
            return list;
        }
        while (rs.next()) {
            int i = 1;
            long id = rs.getLong(i++);
            long hostId = rs.getLong(i++);
            long encId = rs.getLong(i++);
            long vhostId = rs.getLong(i++);
            long lanhostId = rs.getLong(i++);
            Timestamp createdTime = rs.getTimestamp(i++);
            Timestamp lastUpdatedTime = rs.getTimestamp(i++);
            HostMapImpl hostMap = new HostMapImpl(hostId, encId, vhostId, lanhostId);
            hostMap.setDBID(id);
            hostMap.setCreateTime(createdTime);
            hostMap.setLastUpdateTime(lastUpdatedTime);
            list.add(hostMap);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistHostMaps(Connection con, List<HostMapImpl> hosts) {
        if (hosts == null || hosts.size() == 0) {
            return;
        }
        int MAX_COUNT = 500;
        Statement insertStat = null;
        Statement updateStat = null;
        int total = 0;
        int insertCount = 0;
        int updateCount = 0;
        try {
            long startTime = System.currentTimeMillis();
            for (HostMapImpl h : hosts) {
                try {
                    if (insertStat == null) {
                        insertStat = con.prepareStatement(InsertSQL);
                    }
                    if (updateStat == null) {
                        updateStat = con.prepareStatement(UpdateSQL);
                    }
                    if (h.getDBID() == 0L) {
                        h.setDBID(Sequence.getSequence().getPK());
                        h.setupInsertStatement((PreparedStatement)insertStat);
                        insertStat.addBatch();
                        ++insertCount;
                    } else if (h.getBaseObject().isModified()) {
                        h.setupUpdateStatement((PreparedStatement)updateStat);
                        updateStat.addBatch();
                        ++updateCount;
                    }
                    ++total;
                    if (insertCount == MAX_COUNT) {
                        try {
                            insertStat.executeBatch();
                        }
                        catch (SQLException sqlex) {
                            if (sqlex != null && sqlex.getNextException() != null) {
                                _logger.log(Level.WARN, "persistHostMaps failed and got SQLException", sqlex.getNextException());
                            } else {
                                _logger.log(Level.WARN, "persistHostMaps failed and got SQLException", sqlex);
                            }
                        }
                        finally {
                            DbUtil.close(insertStat);
                            insertStat = null;
                            insertCount = 0;
                        }
                    }
                    if (updateCount != MAX_COUNT) continue;
                    try {
                        updateStat.executeBatch();
                    }
                    catch (SQLException sqlex) {
                        if (sqlex != null && sqlex.getNextException() != null) {
                            _logger.log(Level.WARN, "persistHostMaps failed and got SQLException", sqlex.getNextException());
                            continue;
                        }
                        _logger.log(Level.WARN, "persistHostMaps failed and got SQLException", sqlex);
                    }
                    finally {
                        DbUtil.close(updateStat);
                        updateStat = null;
                        updateCount = 0;
                    }
                }
                catch (SQLException sqlex) {
                    if (sqlex != null && sqlex.getNextException() != null) {
                        _logger.log(Level.WARN, "persistHostMaps failed and got SQLException", sqlex.getNextException());
                        continue;
                    }
                    _logger.log(Level.WARN, "persistHostMaps failed and got SQLException", sqlex);
                }
            }
            if (insertStat != null) {
                insertStat.executeBatch();
            }
            if (updateStat != null) {
                updateStat.executeBatch();
            }
            _logger.log(Level.DEBUG, "done persistHostMaps: " + total + " in " + (System.currentTimeMillis() - startTime) + "ms");
        }
        catch (Exception ex) {
            try {
                _logger.log(Level.WARN, "persistHostMaps failed and got exception", ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(updateStat);
                DbUtil.close(insertStat);
                throw throwable;
            }
            DbUtil.close(updateStat);
            DbUtil.close(insertStat);
        }
        DbUtil.close(updateStat);
        DbUtil.close(insertStat);
    }
}

