/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.NtopBase;
import com.cisco.dcbu.sm.common.model.SpanInfo;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class NtopImpl
extends AbstractDBObjectImpl {
    final NtopBase _base;
    ArrayList _spanInfos;
    static final String QuerySQLByIpPort = "select id, ip_addr, port_number, last_update_time from ntop where ip_addr=? and port_number=?";
    static final String InsertSQL = "insert into ntop(id, ip_addr, port_number, last_update_time) values(?,?,?,?)";
    static final String UpdateSQL = "update ntop set ip_addr=?, port_number=?, last_update_time=? where id=?";
    static final String TableName = "ntop";

    public NtopImpl(NtopBase base) {
        this._base = base;
        this._spanInfos = new ArrayList();
    }

    public NtopImpl(String ip, int port) {
        this._base = new NtopBase(ip, port);
        this._spanInfos = new ArrayList();
    }

    public void addSpanInfo(String swWwn, String swName, int spIndex, String ethN) {
        this._spanInfos.add(new SpanInfo(swWwn, swName, spIndex, ethN));
    }

    public ArrayList getSpanInfos() {
        return this._spanInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stat;
        block4: {
            stat = con.prepareStatement(QuerySQLByIpPort);
            rs = null;
            try {
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (!rs.next()) break block4;
                this.setDBID(rs.getLong(1));
            }
            catch (SQLException ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(String ip, int port) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            ArrayList al;
            stat = con.prepareStatement(QuerySQLByIpPort);
            stat.setString(1, ip);
            stat.setInt(2, port);
            rs = stat.executeQuery();
            arrayList = al = NtopImpl.loadDBRecord(rs);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<NtopImpl> al = new ArrayList<NtopImpl>();
        while (rs.next()) {
            NtopBase base = new NtopBase(rs.getString(2), rs.getInt(3));
            NtopImpl ntop = new NtopImpl(base);
            ntop.setDBID(rs.getLong(1));
            al.add(ntop);
        }
        return al;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByIpPort;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        stat.setString(2, this._base.getIp());
        stat.setInt(3, this._base.getPort());
        stat.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._base.getIp());
        stat.setInt(2, this._base.getPort());
        stat.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
        stat.setLong(4, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setString(1, this._base.getIp());
        stat.setInt(2, this._base.getPort());
    }
}

