/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.sm.common.model.SpanSessionBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.model.SpanPortImpl;
import com.cisco.dcbu.sm.server.model.SpanSourcePortImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public final class SpanSessionImpl
extends AbstractDBObjectImpl {
    final SpanSessionBase _base;
    SpanPortImpl _spanPort;
    ArrayList _spanSourcePorts;
    static final String QuerySQLByPortIdSessionId = "select id, span_port_id, session_id, oper_status, vsan_filter, vsan_source, last_update_time from span_session where span_port_id=? and session_id=?";
    static final String QuerySQLByPortId = "select id, span_port_id, session_id, oper_status, vsan_filter, vsan_source, last_update_time from span_session where span_port_id=?";
    static final String InsertSQL = "insert into span_session(id,span_port_id, session_id, oper_status, vsan_filter, vsan_source, last_update_time) values(?,?,?,?,?, ?,?)";
    static final String UpdateSQL = "update span_session set span_port_id=?, session_id=?, oper_status=?, vsan_filter=?, vsan_source=?, last_update_time=? where id=?";
    static final String TableName = "span_session";

    public SpanSessionImpl(SpanSessionBase base, SpanPortImpl ss) {
        this._base = base;
        this._spanPort = ss;
        this._spanSourcePorts = new ArrayList();
    }

    public SpanSessionImpl(SpanSessionBase base) {
        this._base = base;
        this._spanPort = null;
        this._spanSourcePorts = new ArrayList();
    }

    public SpanSessionImpl(int sid, int status, String vsanFilter, String vsanSource) {
        this._base = new SpanSessionBase(sid, status, vsanFilter, vsanSource);
        this._spanPort = null;
        this._spanSourcePorts = new ArrayList();
    }

    public void setSpanPort(SpanPortImpl ss) {
        this._spanPort = ss;
        ss.addSpanSession(this);
    }

    public void addSpanSourcePort(SpanSourcePortImpl sp) {
        this._spanSourcePorts.add(sp);
    }

    public SpanSourcePortImpl removeSpanSourcePort(SpanSourcePortImpl sp) {
        if (sp == null) {
            return null;
        }
        int index = this._spanSourcePorts.indexOf(sp);
        if (index == -1) {
            return null;
        }
        return (SpanSourcePortImpl)this._spanSourcePorts.remove(index);
    }

    public ArrayList getSpanSourcePorts() {
        return this._spanSourcePorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        PreparedStatement stat = con.prepareStatement(QuerySQLByPortIdSessionId);
        ResultSet rs = null;
        try {
            stat.setLong(1, this._spanPort.getDBID());
            stat.setInt(2, this._base.getSessionId());
            rs = stat.executeQuery();
            if (rs.next()) {
                this.setDBID(rs.getLong(1));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stat != null) {
                stat.close();
            }
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            stat.setLong(1, this.getDBID());
            stat.setLong(2, this._spanPort.getDBID());
            stat.setInt(3, this._base.getSessionId());
            stat.setInt(4, this._base.getStatus());
            stat.setString(5, this._base.getVsanFilter());
            stat.setString(6, this._base.getVsanSource());
            stat.setTimestamp(7, new Timestamp(System.currentTimeMillis()));
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        stat.setLong(1, this._spanPort.getDBID());
        stat.setInt(2, this._base.getSessionId());
        stat.setInt(3, this._base.getStatus());
        stat.setString(4, this._base.getVsanFilter());
        stat.setString(5, this._base.getVsanSource());
        stat.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
        stat.setLong(7, this.getDBID());
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(SpanPortImpl sp) throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByPortId);
            stat.setLong(1, sp.getDBID());
            rs = stat.executeQuery();
            ArrayList al = SpanSessionImpl.loadDBRecord(rs);
            Iterator it = al.iterator();
            while (it.hasNext()) {
                ((SpanSessionImpl)it.next())._spanPort = sp;
            }
            arrayList = al;
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<SpanSessionImpl> al = new ArrayList<SpanSessionImpl>();
        while (rs.next()) {
            SpanSessionBase base = new SpanSessionBase(rs.getInt(3), rs.getInt(4), rs.getString(5), rs.getString(6));
            SpanSessionImpl ss = new SpanSessionImpl(base);
            ss.setDBID(rs.getLong(1));
            al.add(ss);
        }
        return al;
    }
}

