/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.dcm.security.CryptoHelper;
import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.SchedulerSingleton;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.dto.DiscoveryType;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.type.NameKey;
import com.cisco.dcbu.sm.common.type.PKIf;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.DataStoreImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.HostClusterImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.model.VmImpl;
import com.cisco.dcbu.vi.discover.VCenterWorker;
import com.cisco.dcbu.vi.model.HostSystem;
import com.cisco.dcbu.vi.model.ViManager;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class VirtualCenterImpl
extends AbstractModelObjectImpl {
    public static int _DefRediscInterval;
    public static int _DefPollInterval;
    static final String QuerySQLByIpAddress = "select id, vc_id, ip_address, user_name, password, discovery, state, status_description, last_scan_time,last_update_time, server_id from vcenter where ip_address=?";
    static final String QuerySQLByPersistent = "select id, vc_id, ip_address, user_name, password, discovery, state, status_description, last_scan_time,last_update_time, server_id from vcenter";
    static final String QueryVHostByVCenterSQL = "select id, name, full_name, moRef, vendor, model, version, memory_size, cpucount, cpu_speed_avg from vhost where vcenter_id=?";
    static final String QueryDataStoreByVCenterSQL = "select canonical_name from data_store where vcenter_id=? ";
    static final String InsertSQL = "insert into vcenter(id, vc_id, ip_address, user_name, password, discovery, state, status_description, last_scan_time,last_update_time, server_id) values(?,?,?,?,?, ?,?,?,?,?, ?)";
    static final String UpdateSQL = "update vcenter set vc_id=?, ip_address=?, user_name=?, password=?, discovery=?, state=?, status_description=?, last_scan_time=?, last_update_time=?, server_id=? where id=?";
    static final String DeleteSQL = "delete from vcenter where id=?";
    static final String TableName = "vcenter";
    static Logger _Logger;
    private final VirtualCenterBase _base;
    private VCenterWorker _worker;
    private ConcurrentHashMap<NameKey, DataStoreImpl> _dataStoreByNameKey;
    private ConcurrentHashMap<NameKey, VHostImpl> _hostByNameKey;
    private ConcurrentHashMap<NameKey, HostClusterImpl> _hostClusterByNameKey;
    static final String[] LIL;
    public static final String VALUE_NONE = "none";
    public static final String VALUE_NA = "n/a";
    private transient int _maxWait = 3300;
    private int _pollInterval = _DefPollInterval;
    private int _rediscInterval = _DefRediscInterval;

    public VirtualCenterImpl(VcenterPK vcPK, InetAddress ipAddr, String username, String password, boolean discovery) {
        this._hostByNameKey = new ConcurrentHashMap();
        this._dataStoreByNameKey = new ConcurrentHashMap();
        this._hostClusterByNameKey = new ConcurrentHashMap();
        this._base = new VirtualCenterBase(vcPK, ipAddr, username, password, discovery);
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public NameKey getVcIpStr() {
        return (NameKey)this._base.getPK();
    }

    public PKIf getVcPK() {
        return this._base.getVcPK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VHostImpl createHost(long[] nwwns, long[] pwwns, String ostype, String vendor, String model, String version, long memorySize, short cpuCount, long cpuSpeedAvg, String hostName, String fullName, int powerState, int connState, ArrayList<String> macAddresses, ArrayList<String> ipAddresses, String moRef, VirtualCenterImpl vc) {
        ConcurrentHashMap<NameKey, VHostImpl> concurrentHashMap = this._hostByNameKey;
        synchronized (concurrentHashMap) {
            String name = vc.getDBID() + "-" + moRef;
            VHostImpl host = this.findHostByName(name);
            if (host == null) {
                host = new VHostImpl(nwwns, pwwns, ostype, vendor, model, version, memorySize, cpuCount, cpuSpeedAvg, hostName, fullName, powerState, connState, macAddresses, ipAddresses, moRef, vc);
                this._hostByNameKey.put(new NameKey(name), host);
            } else {
                host.setNwwns(nwwns);
                host.setPwwns(pwwns);
                host.setOsType(ostype);
                host.setVendor(vendor);
                host.setModel(model);
                host.setVersion(version);
                host.setMemorySize(memorySize);
                host.setCpuCount(cpuCount);
                host.setCpuSpeedAvg(cpuSpeedAvg);
                host.setHostName(hostName);
                host.setHostFullName(fullName);
                host.setPowerState(powerState);
                host.setMacAddresses(macAddresses);
                host.setIpAddresses(ipAddresses);
                host.setVirtualCenter(vc);
                this._hostByNameKey.put(new NameKey(name), host);
            }
            return host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateHost(long[] nwwns, long[] pwwns, String ostype, String vendor, String model, String version, long memorySize, short cpuCount, String moRef, long cpuSpeedAvg, String hostName, String fullName, int powerState, int connState, ArrayList<String> macAddresses, ArrayList<String> ipAddresses, VirtualCenterImpl vc) {
        ConcurrentHashMap<NameKey, VHostImpl> concurrentHashMap = this._hostByNameKey;
        synchronized (concurrentHashMap) {
            VHostImpl host = this.findHostByName(vc.getDBID() + "-" + moRef);
            if (host == null) {
                return false;
            }
            host.setNwwns(nwwns);
            host.setPwwns(pwwns);
            host.setOsType(ostype);
            host.setVendor(vendor);
            host.setModel(model);
            host.setVersion(version);
            host.setMemorySize(memorySize);
            host.setCpuCount(cpuCount);
            host.setCpuSpeedAvg(cpuSpeedAvg);
            host.setHostName(hostName);
            host.setHostFullName(fullName);
            host.setPowerState(powerState);
            host.setConnState(connState);
            host.setMacAddresses(macAddresses);
            host.setIpAddresses(ipAddresses);
            host.setVirtualCenter(vc);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VHostImpl> loadHostsFromDB() {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        ArrayList<VHostImpl> result;
        block5: {
            result = new ArrayList<VHostImpl>();
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryVHostByVCenterSQL));
                stat.setLong(1, this._dbID);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    long id = rs.getLong(1);
                    String name = rs.getString(2);
                    String fullName = rs.getString(3);
                    String moRef = rs.getString(4);
                    String vendor = rs.getString(5);
                    String model = rs.getString(6);
                    String version = rs.getString(7);
                    long memorySize = rs.getLong(8);
                    short cpuCount = rs.getShort(9);
                    long cpuSpeedAvg = rs.getLong(10);
                    VHostImpl vhost = new VHostImpl(null, null, null, vendor, model, version, memorySize, cpuCount, cpuSpeedAvg, name, fullName, 0, 0, null, null, moRef, this);
                    vhost.setDBID(id);
                    result.add(vhost);
                }
            }
            catch (Exception e) {
                try {
                    _Logger.warn((Object)("load vhost from db failed: " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataStoreImpl> loadDataStoresFromDB() {
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        ArrayList<DataStoreImpl> result;
        block5: {
            result = new ArrayList<DataStoreImpl>();
            con = null;
            stat = null;
            rs = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryDataStoreByVCenterSQL));
                stat.setLong(1, this._dbID);
                rs = stat.executeQuery();
                if (rs == null) break block5;
                while (rs.next()) {
                    String canonicalName = rs.getString(1);
                    DataStoreImpl dataStore = new DataStoreImpl(0L, 0L, null, 0, null, null, canonicalName);
                    result.add(dataStore);
                }
            }
            catch (Exception e) {
                try {
                    _Logger.warn((Object)("load data store from db failed: " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return result;
    }

    public VHostImpl[] getHosts() {
        return this._hostByNameKey.values().toArray(new VHostImpl[this._hostByNameKey.size()]);
    }

    public Collection<VHostImpl> getAllHosts() {
        return this._hostByNameKey.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NameKey> getAllHostPKs() {
        ConcurrentHashMap<NameKey, VHostImpl> concurrentHashMap = this._hostByNameKey;
        synchronized (concurrentHashMap) {
            return Collections.synchronizedSet(new HashSet(this._hostByNameKey.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NameKey> getAllDataStorePKs() {
        ConcurrentHashMap<NameKey, DataStoreImpl> concurrentHashMap = this._dataStoreByNameKey;
        synchronized (concurrentHashMap) {
            return Collections.synchronizedSet(new HashSet(this._dataStoreByNameKey.keySet()));
        }
    }

    public List<NameKey> getAllVmPKs() {
        ArrayList<NameKey> resultList = new ArrayList<NameKey>();
        Set<NameKey> vhostPKs = this.getAllHostPKs();
        for (NameKey vhostPK : vhostPKs) {
            NameKey nameKey = new NameKey(this.getDBID() + "-" + vhostPK._name);
            VHostImpl vhost = this.findHostByPK(nameKey);
            if (vhost == null) continue;
            Set<NameKey> vmPKs = vhost.getAllVmPKs();
            resultList.addAll(vmPKs);
        }
        return resultList;
    }

    public List<VmImpl> getAllVms() {
        ArrayList<VmImpl> resultList = new ArrayList<VmImpl>();
        Collection<VHostImpl> vhosts = this.getAllHosts();
        for (VHostImpl vhost : vhosts) {
            List<VmImpl> vms = vhost.getVms();
            resultList.addAll(vms);
        }
        return resultList;
    }

    public VHostImpl findHostByPK(NameKey pkey) {
        return pkey == null ? null : this._hostByNameKey.get(pkey);
    }

    public VmImpl findVmByPK(NameKey pkey) {
        List<VmImpl> vms = this.getAllVms();
        for (VmImpl vm : vms) {
            if (vm == null || vm.getNameKey() == null || !vm.getNameKey().equals(pkey)) continue;
            return vm;
        }
        return null;
    }

    public VHostImpl findHostByName(String name) {
        return this.findHostByPK(new NameKey(name));
    }

    public VHostImpl findAllHost(NameKey pkey) {
        return pkey == null ? null : this._hostByNameKey.get(pkey);
    }

    public void updateHost(String vendor, long memorySize, short cpuCount, long cpuSpeedAvg, String hostName) throws Exception {
        VHostImpl host = this.findHostByPK(new NameKey(hostName));
        if (host == null) {
            throw new Exception("host " + hostName + " not found");
        }
        host.setVendor(vendor);
        host.setMemorySize(memorySize);
        host.setCpuCount(cpuCount);
        host.setCpuSpeedAvg(cpuSpeedAvg);
    }

    public void removeEnclosure(NameKey encPK) throws Exception {
        NameKey nameKey = new NameKey(this.getDBID() + "-" + encPK._name);
        VHostImpl enc = this.findHostByPK(nameKey);
        if (enc == null) {
            throw new Exception("enclosure " + encPK._name + " not found");
        }
        this._hostByNameKey.remove(encPK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreImpl createDataStore(long nwwn, long pwwn, String lunUuid, int lun, String scsiLun, String uuid, String canonicalName) {
        ConcurrentHashMap<NameKey, DataStoreImpl> concurrentHashMap = this._dataStoreByNameKey;
        synchronized (concurrentHashMap) {
            DataStoreImpl dataStore = this.findDataStoreByName(canonicalName);
            if (dataStore == null) {
                dataStore = new DataStoreImpl(nwwn, pwwn, lunUuid, lun, scsiLun, uuid, canonicalName);
                dataStore.setVirtualCenter(this);
                this._dataStoreByNameKey.put(new NameKey(canonicalName), dataStore);
            }
            return dataStore;
        }
    }

    public DataStoreImpl[] getDataStores() {
        return this._dataStoreByNameKey.values().toArray(new DataStoreImpl[this._dataStoreByNameKey.size()]);
    }

    public DataStoreImpl findDataStoreByPK(NameKey pkey) {
        return pkey == null ? null : this._dataStoreByNameKey.get(pkey);
    }

    public DataStoreImpl findDataStoreByName(String name) {
        return this.findDataStoreByPK(new NameKey(name));
    }

    public ArrayList<DataStoreImpl> findDataStoresByHost(String name) {
        if (name == null) {
            return null;
        }
        DataStoreImpl[] dStores = this.getDataStores();
        if (dStores == null) {
            return null;
        }
        ArrayList<DataStoreImpl> resultList = new ArrayList<DataStoreImpl>();
        for (int i = 0; i < dStores.length; ++i) {
            ArrayList<HostSystem> hosts = dStores[i].getHosts();
            for (HostSystem host : hosts) {
                if (host == null || host.getHostName() == null || !host.getHostName().equals(name)) continue;
                resultList.add(dStores[i]);
            }
        }
        return resultList;
    }

    public DataStoreImpl findAllDataStores(NameKey pkey) {
        return pkey == null ? null : this._dataStoreByNameKey.get(pkey);
    }

    public void updateDataStore(long nwwn, long pwwn, String key, int lun, String scsiLun, String canonicalName) throws Exception {
        DataStoreImpl dataStore = this.findDataStoreByPK(new NameKey(canonicalName));
        if (dataStore == null) {
            throw new Exception("dataStore " + key + " not found");
        }
        dataStore.setNwwn(nwwn);
        dataStore.setPwwn(pwwn);
        dataStore.setLun(lun);
        dataStore.setScsiLun(scsiLun);
    }

    public void removeDataStore(NameKey dataStorePK) throws Exception {
        DataStoreImpl dStore = this.findDataStoreByPK(dataStorePK);
        if (dStore == null) {
            throw new Exception("dataStore " + dataStorePK + " not found");
        }
        this._dataStoreByNameKey.remove(dataStorePK);
    }

    public void removeHost(VHostImpl host) throws Exception {
        if (host == null || host.getPK() == null) {
            return;
        }
        this.removeHost((NameKey)host.getPK());
    }

    public void removeHost(NameKey vhostPK) throws Exception {
        String name = this.getDBID() + "-" + vhostPK._name;
        VHostImpl vhost = this.findHostByPK(new NameKey(name));
        if (vhost == null) {
            throw new Exception("vhostPK " + name + " not found");
        }
        this._hostByNameKey.remove(vhostPK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByIpAddress);
            if (this._base.getVcIP() != null) {
                stat.setBytes(1, this._base.getVcIP().getAddress());
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static VirtualCenterImpl getByIpAddress(InetAddress ipAddr) {
        VirtualCenterImpl ret;
        block16: {
            if (ipAddr == null) {
                return null;
            }
            Connection con = null;
            PreparedStatement stat = null;
            ResultSet rs = null;
            ret = null;
            try {
                con = ConnectionManager.getConnection();
                stat = con.prepareStatement(QuerySQLByIpAddress);
                stat.setBytes(1, ipAddr.getAddress());
                rs = stat.executeQuery();
                ArrayList<VirtualCenterImpl> results = new ArrayList<VirtualCenterImpl>();
                while (rs.next()) {
                    int vcId = rs.getInt(2);
                    InetAddress ip = null;
                    try {
                        byte[] b = rs.getBytes(3);
                        if (b != null) {
                            ip = InetAddress.getByAddress(b);
                        }
                    }
                    catch (UnknownHostException ex) {
                        ex.printStackTrace();
                    }
                    String username = rs.getString(4);
                    String encryptPasswd = rs.getString(5);
                    String passwd = StringEncrypter.DESedeDecrypt(encryptPasswd);
                    boolean discovery = rs.getBoolean(6);
                    boolean state = rs.getBoolean(7);
                    String statusDescription = rs.getString(8);
                    long lastScanTime = rs.getLong(9);
                    Timestamp lastUpdateTime = rs.getTimestamp(10);
                    int serverId = rs.getInt(11);
                    try {
                        VirtualCenterImpl vcImpl = new VirtualCenterImpl(new VcenterPK(vcId), ipAddr, username, passwd, discovery);
                        vcImpl.setManageState(state);
                        vcImpl.setStatusDescription(statusDescription);
                        vcImpl.setLastScanTime(lastScanTime);
                        if (lastUpdateTime != null) {
                            vcImpl.setLastUpdateTime(lastUpdateTime.getTime());
                        }
                        vcImpl.setServerId(serverId);
                        vcImpl.setDBID(rs.getLong(1));
                        results.add(vcImpl);
                    }
                    catch (SQLException ex) {
                        _Logger.warn((Object)"getByIpAddress failed", (Throwable)ex);
                    }
                }
                if (results != null && !results.isEmpty()) {
                    ret = (VirtualCenterImpl)results.get(0);
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                _Logger.warn((Object)"getByIpAddress failed", (Throwable)ex);
                break block16;
            }
            catch (Exception e) {
                _Logger.warn((Object)e.getMessage(), (Throwable)e);
                break block16;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
            }
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        return ret;
    }

    public static ArrayList loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<VirtualCenterImpl> al = new ArrayList<VirtualCenterImpl>();
        while (rs.next()) {
            InetAddress ip = null;
            try {
                String passwd;
                String username;
                int vcId;
                block9: {
                    vcId = rs.getInt(2);
                    try {
                        byte[] b = rs.getBytes(3);
                        if (b != null) {
                            ip = InetAddress.getByAddress(b);
                        }
                    }
                    catch (UnknownHostException ex) {
                        ex.printStackTrace();
                    }
                    username = rs.getString(4);
                    String encryptPasswd = rs.getString(5);
                    passwd = null;
                    try {
                        passwd = StringEncrypter.DESedeDecrypt(encryptPasswd);
                    }
                    catch (Exception e) {
                        passwd = CryptoHelper.INSTANCE.decrypt(encryptPasswd);
                        if (passwd != null) break block9;
                        _Logger.error((Object)("Failed to descrypt password. " + e.getMessage()));
                        throw e;
                    }
                }
                boolean discovery = rs.getBoolean(6);
                boolean state = rs.getBoolean(7);
                String statusDescription = rs.getString(8);
                long lastScanTime = rs.getLong(9);
                Timestamp lastUpdateTime = rs.getTimestamp(10);
                int serverId = rs.getInt(11);
                VirtualCenterImpl vcImpl = ViManager.getInstance().createVirtualCenter(vcId, ip, username, passwd, discovery, false);
                vcImpl.setServerId(serverId);
                vcImpl.setManageState(state);
                vcImpl.setStatusDescription(statusDescription);
                vcImpl.setLastScanTime(lastScanTime);
                if (lastUpdateTime != null) {
                    vcImpl.setLastUpdateTime(lastUpdateTime.getTime());
                }
                vcImpl.setDBID(rs.getLong(1));
                al.add(vcImpl);
            }
            catch (Exception ex) {
                _Logger.warn((Object)("create Virtual Center failed " + (ip == null ? null : ip.getHostAddress()) + ":" + ex.getMessage()));
            }
        }
        return al;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getDeleteSqlStr() {
        return DeleteSQL;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        String passwd;
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getDBID());
        if (this._base.getVcPK() != null) {
            stat.setInt(2, ((VcenterPK)this._base.getVcPK()).getId());
        } else {
            stat.setInt(2, 0);
        }
        if (this._base.getVcIP() != null) {
            stat.setBytes(3, this._base.getVcIP().getAddress());
        } else {
            stat.setNull(3, -2);
        }
        stat.setString(4, this._base.getUserName());
        try {
            passwd = StringEncrypter.DESedeEncrypt(this._base.getPassword());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        stat.setString(5, passwd);
        stat.setBoolean(6, this._base.getDiscovery());
        stat.setBoolean(7, this._base.getManageState());
        stat.setString(8, this._base.getStatusDescription());
        stat.setLong(9, this._base.getLastScanTime());
        stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
        stat.setInt(11, this._base.getServerId());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        String passwd;
        if (stat == null) {
            return;
        }
        if (this._base.getVcPK() != null) {
            stat.setInt(1, ((VcenterPK)this._base.getVcPK()).getId());
        } else {
            stat.setInt(1, 0);
        }
        if (this._base.getVcIP() != null) {
            stat.setBytes(2, this._base.getVcIP().getAddress());
        } else {
            stat.setNull(2, -2);
        }
        stat.setString(3, this._base.getUserName());
        try {
            passwd = StringEncrypter.DESedeEncrypt(this._base.getPassword());
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        stat.setString(4, passwd);
        stat.setBoolean(5, this._base.getDiscovery());
        stat.setBoolean(6, this._base.getManageState());
        stat.setString(7, this._base.getStatusDescription());
        stat.setLong(8, this._base.getLastScanTime());
        stat.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
        stat.setInt(10, this._base.getServerId());
        stat.setLong(11, this.getDBID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadPersistentVirtualCentersFromDB() throws SQLException {
        ArrayList arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        String queryStr = QuerySQLByPersistent;
        try {
            stat = con.prepareStatement(PersistentHelper.getHelper().getQueryString(queryStr));
            rs = stat.executeQuery();
            arrayList = VirtualCenterImpl.loadDBRecord(rs);
        }
        catch (SQLException ex) {
            ArrayList arrayList2;
            try {
                _Logger.error((Object)"loadPersistentFabricsFromDB failed", (Throwable)ex);
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null || this._base.getVcIP() == null) {
            return;
        }
        stat.setBytes(1, this._base.getVcIP().getAddress());
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        return wasPresent;
    }

    @Override
    public FabricImpl getFabric() {
        return null;
    }

    public InetAddress getIpAddress() {
        return this._base.getVcIP();
    }

    public void setIpAddress(InetAddress ipaddress) {
        this._base.setVcIP(ipaddress);
    }

    public int getServerId() {
        return this._base.getServerId();
    }

    public void setServerId(int id) {
        this._base.setServerId(id);
    }

    public String getUserName() {
        return this._base.getUserName();
    }

    public void setUserName(String newName) {
        this._base.setUserName(newName);
    }

    public String getPassword() {
        return this._base.getPassword();
    }

    public void setPassword(String passwd) {
        this._base.setPassword(passwd);
    }

    public boolean getDiscovery() {
        return this._base.getDiscovery();
    }

    public void setDiscovery(boolean discovery) {
        this._base.setDiscovery(discovery);
    }

    void scheduleRefresh(int delay) {
        if (this._worker == null) {
            return;
        }
        SchedulerSingleton schdl = SchedulerSingleton.getInstance();
        Schedule sch = new Schedule(delay, (long)this._pollInterval * 1000L, false);
        if (this._worker.getState() == 1 || this._worker.getState() == 2) {
            schdl.setTaskSchedule(this._worker, sch);
        } else {
            schdl.addTask(this._worker, sch);
        }
    }

    boolean isRefreshScheduled() {
        return this._worker != null && (this._worker.getState() == 1 || this._worker.getState() == 2);
    }

    public synchronized VCenterWorker getWorker() {
        if (this._worker == null) {
            this._worker = new VCenterWorker(this, this._pollInterval);
        }
        return this._worker;
    }

    public boolean isDiscovering() {
        return this._worker == null ? false : this._worker.isDiscovering();
    }

    public boolean isInitialDiscovery() {
        return this._worker == null || this._worker.getDiscoveryType() == DiscoveryType.FABRIC_INITIAL;
    }

    public boolean isInInitialDiscovery() {
        if (this._worker == null) {
            return false;
        }
        return this._worker.getDiscoveryType() == DiscoveryType.FABRIC_INITIAL && this._worker.isDiscovering();
    }

    public boolean isOnDemandDiscovery() {
        return this._worker != null && this._worker.getDiscoveryType() == DiscoveryType.FABRIC_ONDEMAND;
    }

    public void setDiscoveryType(DiscoveryType discType) {
        if (this._worker != null) {
            this._worker.setDiscoveryType(discType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostClusterImpl addCluster(HostClusterImpl cl) {
        ConcurrentHashMap<NameKey, HostClusterImpl> concurrentHashMap = this._hostClusterByNameKey;
        synchronized (concurrentHashMap) {
            String clusterName = cl.getClusterName();
            if (clusterName == null) {
                return null;
            }
            HostClusterImpl cluster = this.findClusterByName(clusterName);
            if (cluster == null) {
                this._hostClusterByNameKey.put(new NameKey(clusterName), cl);
                return cl;
            }
            return cluster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostClusterImpl createCluster(String clusterName) {
        ConcurrentHashMap<NameKey, HostClusterImpl> concurrentHashMap = this._hostClusterByNameKey;
        synchronized (concurrentHashMap) {
            HostClusterImpl cluster = this.findClusterByName(clusterName);
            if (cluster == null) {
                cluster = new HostClusterImpl(clusterName);
                this._hostClusterByNameKey.put(new NameKey(clusterName), cluster);
            }
            return cluster;
        }
    }

    public HostClusterImpl findCluster(NameKey pkey) {
        return pkey == null ? null : this._hostClusterByNameKey.get(pkey);
    }

    public HostClusterImpl[] getClusters() {
        return this._hostClusterByNameKey.values().toArray(new HostClusterImpl[this._hostClusterByNameKey.size()]);
    }

    public HostClusterImpl findClusterByPK(NameKey pkey) {
        return pkey == null ? null : this._hostClusterByNameKey.get(pkey);
    }

    public HostClusterImpl findClusterByName(String name) {
        return this.findClusterByPK(new NameKey(name));
    }

    public void setLastUpdateTime(long time) {
        this._base.setLastUpdateTime(time);
    }

    public long getLastUpdateTime() {
        return this._base.getLastUpdateTime();
    }

    public void setLastScanTime(long time) {
        this._base.setLastScanTime(time);
    }

    @Override
    public long getLastScanTime() {
        return this._base.getLastScanTime();
    }

    public void setVcLastScanTime(long time) {
        this._base.setVcLastScanTime(time);
    }

    public long getVcLastScanTime() {
        return this._base.getVcLastScanTime();
    }

    public boolean getManageState() {
        return this._base.getManageState();
    }

    public void setManageState(boolean state) {
        this._base.setManageState(state);
    }

    public void setStatusDescription(String description) {
        this._base.setStatusDescription(description);
    }

    public String getStatusDescription() {
        return this._base.getStatusDescription();
    }

    public String getIpAddressAsString() {
        return this.getIpAddress() == null ? null : this.getIpAddress().getHostAddress();
    }

    public int getNumHosts() {
        return this._hostByNameKey.size();
    }

    public int getNumDataStores() {
        return this._dataStoreByNameKey.size();
    }

    public int getNumClusters() {
        return this._hostClusterByNameKey.size();
    }

    public long getDiscoveryTimeout() {
        return this._maxWait * 1000;
    }

    public void preDiscovery(DiscoveryType discType) {
        this.setLastScanTime(System.currentTimeMillis());
    }

    public String dump(boolean inDetail) {
        StringBuilder sb = new StringBuilder(this.getVcIpStr().toString());
        sb.append(LIL[1]).append("Status: ").append(this.getManageState());
        if (this.getManageState()) {
            sb.append(LIL[1]).append("User: ").append(this.getUserName()).append(LIL[1]).append("Virtual Center IP: ").append(this.getIpAddressAsString()).append(LIL[1]).append("Manage continously: ").append(this.getDiscovery()).append("\n").append(this.dumpClusters(inDetail, 1)).append('\n').append(this.dumpVHosts(inDetail, 1)).append('\n').append(this.dumpDataStores(inDetail, 1));
        }
        return sb.toString();
    }

    public String dumpVHosts(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of vHosts: ").append(this.getNumHosts());
        VHostImpl[] hosts = this.getHosts();
        for (int i = 0; i < hosts.length; ++i) {
            if (inDetail) {
                sb.append(hosts[i].dump(level));
                continue;
            }
            sb.append(LIL[level]).append("vHost: ").append(hosts[i].getHostName()).append(LIL[level + 1]).append("IP Addresses: ").append(hosts[i].getIpAddressesAsString()).append(LIL[level + 1]).append("Mac Addresses: ").append(hosts[i].getMacAddressesAsString()).append(LIL[level + 1]).append("Node wwns: ").append(hosts[i].getNodeWwnsAsString()).append(LIL[level + 1]).append("HBAs: ").append(hosts[i].getHbasAsString()).append(LIL[level + 1]).append("MultiPath: ").append(hosts[i].getMultiPath()).append(LIL[level + 1]).append("Connection State: ").append(hosts[i].getConnState()).append(LIL[level + 1]).append("Power State: ").append(hosts[i].getPowerState()).append(LIL[level + 1]).append("OS Type: ");
            if (hosts[i].getOsType() == null) {
                sb.append(VALUE_NA);
                continue;
            }
            sb.append(hosts[i].getOsType());
        }
        return sb.toString();
    }

    public String dumpClusters(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of cluster: ").append(this.getNumClusters());
        HostClusterImpl[] hClusters = this.getClusters();
        for (int i = 0; i < hClusters.length; ++i) {
            sb.append(hClusters[i].dump(level));
        }
        return sb.toString();
    }

    public String dumpDataStores(boolean inDetail, int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(LIL[level]).append("Num of data stores: ").append(this.getNumDataStores());
        DataStoreImpl[] dStore = this.getDataStores();
        for (int i = 0; i < dStore.length; ++i) {
            sb.append(dStore[i].dump(level));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean cleanCache) throws Exception {
        if (_Logger.isDebugEnabled()) {
            _Logger.debug((Object)("vCenter--" + this.getPK() + " closing"), (Throwable)new NullPointerException("To track vCenter close"));
        }
        if (this._worker != null) {
            try {
                SchedulerSingleton.getInstance().removeTask(this._worker);
            }
            catch (Exception ex) {
                _Logger.warn((Object)"Failed to remove worker thread");
            }
            this._worker.stop();
            this._worker = null;
        }
        this.setManageState(false);
        if (!cleanCache) {
            return;
        }
        ConcurrentHashMap<NameKey, AbstractModelObjectImpl> concurrentHashMap = this._hostClusterByNameKey;
        synchronized (concurrentHashMap) {
            this._hostClusterByNameKey.clear();
        }
        concurrentHashMap = this._dataStoreByNameKey;
        synchronized (concurrentHashMap) {
            this._dataStoreByNameKey.clear();
        }
        concurrentHashMap = this._hostByNameKey;
        synchronized (concurrentHashMap) {
            for (VHostImpl vhost : this._hostByNameKey.values()) {
                try {
                    vhost.purgeVms();
                }
                catch (Exception ex) {}
            }
            this._hostByNameKey.clear();
        }
    }

    public int getRediscoverInterval() {
        return this._rediscInterval;
    }

    static {
        _Logger = LogManager.getLogger((String)"fms.model");
        LIL = new String[]{"\n", "\n\t", "\n\t\t", "\n\t\t\t", "\n\t\t\t\t"};
        Integer n = Integer.getInteger("fabric.rediscoverinterval");
        _DefRediscInterval = n == null || n <= 0 ? 12 : n;
        n = Integer.getInteger("vi.pollinterval");
        _DefPollInterval = n == null || n < 300 ? 300 : n;
    }
}

