/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.model;

import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.dto.FcPortAlias;
import com.cisco.dcbu.sm.common.dto.VsanDomain;
import com.cisco.dcbu.sm.common.model.BaseModelObject;
import com.cisco.dcbu.sm.common.model.Hba;
import com.cisco.dcbu.sm.common.model.VsanBase;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.VsanFcIdKey;
import com.cisco.dcbu.sm.common.type.VsanPK;
import com.cisco.dcbu.sm.common.type.WwnKey;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.inventory.InventoryManager;
import com.cisco.dcbu.sm.server.model.AbstractModelObjectImpl;
import com.cisco.dcbu.sm.server.model.EnclosureImpl;
import com.cisco.dcbu.sm.server.model.EndPortImpl;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.IslImpl;
import com.cisco.dcbu.sm.server.model.NpvLinkImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.SwitchImpl;
import com.cisco.dcbu.sm.server.model.ZoneImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public final class VsanImpl
extends AbstractModelObjectImpl {
    static final String QuerySQLByFabricID = "select id, name, is_up, seed_switch_id, enf_zoneset_name, enf_zoneset_activate_time, vsan_id, principal_swwn, is_disjoint, ficon_state, inter_oper_mode, principal_sw_id, admin_state, mtu, load_balancing_type, inorder_delivery, network_drop_latency from vsan where fabric_id=?";
    static final String QuerySQLByFabricIDVsanIndex = "select id, name, is_up, seed_switch_id, enf_zoneset_name, enf_zoneset_activate_time, vsan_id, principal_swwn, is_disjoint, ficon_state, inter_oper_mode,principal_sw_id , admin_state, mtu, load_balancing_type, inorder_delivery, network_drop_latency from vsan where fabric_id=? and vsan_id=? and principal_swwn=?";
    static final String InsertSQL = "insert into vsan(id, name, is_up,seed_switch_id,enf_zoneset_name,enf_zoneset_activate_time,fabric_id,vsan_id, principal_swwn, last_update_time, is_disjoint, ficon_state, inter_oper_mode,principal_sw_id, admin_state, mtu, load_balancing_type, inorder_delivery, network_drop_latency) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,?)";
    static final String UpdateSQL = "update vsan set name=?, is_up=?,seed_switch_id=?,enf_zoneset_name=?,enf_zoneset_activate_time=?,fabric_id=?,vsan_id=?, principal_swwn=?, last_update_time=?, is_disjoint=?, ficon_state=?, inter_oper_mode=?, principal_sw_id=?, admin_state=?, mtu=?, load_balancing_type=?, inorder_delivery=?, network_drop_latency =? where id=?";
    static final String TableName = "vsan";
    public static final int DISC_SWS = 1;
    public static final int DISC_NPS = 2;
    public static final int DISC_ISLS = 4;
    public static final int DISC_ZONESET = 8;
    public static final int DISC_ZONES = 16;
    public static final int DISC_FCALIAS = 32;
    public static final int DISC_VEINIT = 64;
    public static final int DISC_PCMBRS = 128;
    public static final int DISC_FICON = 256;
    static Logger _Logger = LogManager.getLogger((String)"fms.model");
    private final VsanBase _base;
    private final Map<Integer, SwitchImpl> _switchByDid = new ConcurrentHashMap<Integer, SwitchImpl>(new HashMap());
    private final Map<Integer, EndPortImpl> _endportByFcid = new ConcurrentHashMap<Integer, EndPortImpl>(10);
    private final Set<IslImpl> _isls = Collections.synchronizedSet(new HashSet(10));
    private final Set<NpvLinkImpl> _npvls = Collections.synchronizedSet(new HashSet(3));
    public SwitchImpl _seed;
    private SwitchImpl _fcAliasSeed;
    private long _fspfCheckSum;
    private int _discFlags = 383;
    private int _numEnfZones;
    private long _principalSwId = 0L;
    public static final String[] DISC_FLAGS = new String[]{"Switches", "EndPorts", "Isls", "EnfZoneset", "EnfZones", "FcAliases", "VeInit", "PortChannelMembers", "FiconState"};
    private static ArrayList<Pattern> _Patterns;

    public static String toDiscFlagString(int flags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DISC_FLAGS.length; ++i) {
            if ((flags >> i & 1) == 0) continue;
            sb.append(DISC_FLAGS[i]).append(" ");
        }
        return sb.toString();
    }

    VsanImpl(FabricPK fabricPK, VsanPK vPK) {
        this._base = new VsanBase(fabricPK, vPK);
    }

    VsanImpl(FabricPK fabricPK, VsanPK pkey, String name, byte adminState, byte operState, byte interOper, int mtu, byte lbType, boolean ioDelivery, int latency) {
        this._base = new VsanBase(fabricPK, pkey, name, adminState, operState, interOper, mtu, lbType, ioDelivery, latency);
    }

    @Override
    public BaseModelObject getBaseObject() {
        return this._base;
    }

    public VsanPK getVsanPK() {
        return this._base.getVsanPK();
    }

    public Wwn getPrincipalSwitchWwn() {
        short vid = this._base.getId();
        Wwn prinvwwn = this._base.getVsanPK()._prinSwwn;
        Wwn prinswwn = null;
        for (SwitchImpl sw : this._switchByDid.values()) {
            VsanDomain vd = sw.getVsanDomain(vid);
            if (vd == null || !vd.getVsanWwn().equals(prinvwwn)) continue;
            prinswwn = sw.getWwn();
            break;
        }
        return prinswwn;
    }

    public SwitchImpl getPrincipalSwitch() {
        short vid = this._base.getId();
        Wwn prinvwwn = this._base.getVsanPK()._prinSwwn;
        SwitchImpl prinsw = null;
        for (SwitchImpl sw : this._switchByDid.values()) {
            VsanDomain vd = sw.getVsanDomain(vid);
            if (vd == null || !prinvwwn.equals(vd.getVsanWwn())) continue;
            prinsw = sw;
            break;
        }
        return prinsw;
    }

    public void setFabricPK(FabricPK fabricPK) {
        if (!this._base.getFabricPK().equals(fabricPK)) {
            FabricPK old = this._base.getFabricPK();
            this._base.setFabricPK(fabricPK);
            this.propertyChanged((short)780, old, fabricPK);
        }
    }

    @Override
    public FabricImpl getFabric() {
        return this._seed != null ? this._seed.getFabric() : SanManager.getInstance().findFabric(this._base.getFabricPK());
    }

    public short getId() {
        return this._base.getId();
    }

    @Override
    public boolean setPresent(boolean isPresent) {
        boolean wasPresent = this._base.isPresent();
        if (wasPresent ^ isPresent) {
            this._base.setPresent(isPresent);
            this.propertyChanged((short)769, Boolean.valueOf(wasPresent), Boolean.valueOf(isPresent));
        }
        return wasPresent;
    }

    public String getName() {
        return this._base.getName();
    }

    public String getDetailedName() {
        boolean needIdAfterName;
        FabricImpl fImpl = this.getFabric();
        String name = this._base.getName();
        if (name == null || name.length() == 0) {
            name = "VSAN" + this.getId();
        }
        if (fImpl == null) {
            return name;
        }
        VsanImpl[] fVsans = fImpl.findVsan(this.getId());
        boolean isDisjoint = fVsans != null && fVsans.length > 1;
        boolean bl = needIdAfterName = !name.endsWith(Integer.toString(this.getId()));
        if (needIdAfterName || isDisjoint || !this.isUp()) {
            StringBuffer sb = new StringBuffer(128);
            sb.append(name);
            sb.append(" (");
            if (needIdAfterName) {
                sb.append(this.getId() + ",");
            }
            if (!this.isUp()) {
                sb.append("down,");
            }
            if (isDisjoint) {
                sb.append("segmented @ " + this.getPrincipalSwitch() + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append(')');
            return sb.toString();
        }
        return name;
    }

    public void setName(String newName) {
        String oldName = this._base.getName();
        if (!GenUtil.equals(oldName, newName)) {
            this._base.setName(newName);
            this.propertyChanged((short)770, (Serializable)((Object)oldName), (Serializable)((Object)newName));
        }
    }

    public byte getAdminState() {
        return this._base.getAdminState();
    }

    public void setAdminState(byte adminState) {
        if (adminState != this._base.getAdminState()) {
            Byte old = new Byte(this._base.getAdminState());
            this._base.setAdminState(adminState);
            this.propertyChanged((short)771, old, new Byte(adminState));
        }
    }

    public boolean isUp() {
        return this._base.isUp();
    }

    public void setOperState(byte state) {
        if (state != this._base.getOperState()) {
            Byte old = new Byte(this._base.getOperState());
            this._base.setOperState(state);
            this.propertyChanged((short)772, old, new Byte(state));
        }
    }

    public byte getInterOperMode() {
        return this._base.getInterOperMode();
    }

    public void setInterOperMode(byte mode) {
        if (this._base.getInterOperMode() != mode) {
            Byte old = new Byte(this._base.getInterOperMode());
            this._base.setInterOperMode(mode);
            this.propertyChanged((short)773, old, new Byte(mode));
        }
    }

    public void setMtu(int mtu) {
        if (mtu != this._base.getMtu()) {
            Integer old = new Integer(this._base.getMtu());
            this._base.setMtu(mtu);
            this.propertyChanged((short)774, old, new Integer(mtu));
        }
    }

    public void setLoadBalancingType(byte type) {
        if (type != this._base.getLoadBalancingType()) {
            Byte old = new Byte(this._base.getLoadBalancingType());
            this._base.setLoadBalancingType(type);
            this.propertyChanged((short)775, old, new Byte(type));
        }
    }

    public void setInorderDelievery(boolean ioDelivery) {
        if (ioDelivery ^ this._base.isInorderDelivery()) {
            this._base.setInorderDelivery(ioDelivery);
            this.propertyChanged((short)776, Boolean.valueOf(!ioDelivery), Boolean.valueOf(ioDelivery));
        }
    }

    public void setNetworkDropLatency(int latency) {
        if (latency != this._base.getNetworkDropLatency()) {
            Integer old = new Integer(this._base.getNetworkDropLatency());
            this._base.setNetworkDropLatency(latency);
            this.propertyChanged((short)777, old, new Integer(latency));
        }
    }

    public boolean isSegmented() {
        return this._base.isSegmented();
    }

    public void setSegmented(boolean b) {
        if (this._base.isSegmented() ^ b) {
            this._base.setSegmented(b);
            this.propertyChanged((short)779, Boolean.valueOf(!b), Boolean.valueOf(b));
        }
    }

    public void setFiconState(byte state) {
        byte oldState = this._base.getFiconState();
        if (oldState != state) {
            this._base.setFiconState(state);
            this.propertyChanged((short)778, new Byte(oldState), new Byte(state));
        }
    }

    public boolean isFicon() {
        return this._base.isFicon();
    }

    public String getEnforcedZoneSetName() {
        return this._base.getEnforcedZoneSetName();
    }

    public void setEnforcedZoneSetName(String newName) {
        String oldName = this._base.getEnforcedZoneSetName();
        if (!GenUtil.equals(newName, oldName)) {
            this._base.setEnforcedZoneSetName(newName);
            oldName = oldName == null && this._base.getEnforcedZoneSetActivateTime() == 0L ? "" : oldName;
            this.propertyChanged((short)783, (Serializable)((Object)oldName), (Serializable)((Object)newName));
            if (newName == null || newName.length() == 0) {
                this.setEnforcedZones(null);
            } else {
                _Logger.debug((Object)(this + " setEnforcedZoneSetName(): set discFlag DISC_ZONES, oldName is " + oldName + ", newName is " + newName));
                this.setDiscFlag(16);
            }
        }
    }

    public long getEnforcedZoneSetActivateTime() {
        return this._base.getEnforcedZoneSetActivateTime();
    }

    public void setEnforcedZoneSetActivateTime(SwitchImpl sw, long newTime) {
        long oldTime;
        Long oldActivateTime = this._base.findZoneSetActivateTime(sw.getWwn());
        long l = oldTime = oldActivateTime == null ? -1L : oldActivateTime;
        if (oldTime / 100L != newTime / 100L) {
            this._base.updateZoneSetActivateTime(sw.getWwn(), new Long(newTime));
            this._base.setEnforcedZoneSetActivateTime(newTime);
            this.propertyChanged((short)784, new Long(oldTime), new Long(newTime));
            if (newTime != 0L) {
                this.setDiscFlag(16);
            } else {
                this.setEnforcedZones(null);
            }
        }
    }

    public ZoneBase[] getEnforcedZones() {
        return this._base.getEnforcedZones();
    }

    public void setEnforcedZones(ZoneBase[] zones) {
        if (this._base.getEnforcedZoneSetName() == null && zones != null) {
            return;
        }
        Object[] oldZones = this._base.getEnforcedZones();
        if (zones != null) {
            Arrays.sort(zones);
        }
        if (!(zones != null ? Arrays.equals(oldZones, zones) : oldZones == null)) {
            this._base.setEnforcedZones(zones);
            this.propertyChanged((short)785, (Serializable)oldZones, (Serializable)zones);
        }
    }

    public int getNumEnforcedZones() {
        return this._numEnfZones;
    }

    public void setNumEnforcedZones(int num) {
        if (this._numEnfZones != num) {
            _Logger.debug((Object)(this + " setNumEnforcedZones(): set discFlag DISC_ZONES, old zoneZum " + this._numEnfZones + ", new zoneZum " + num));
            this._numEnfZones = num;
            this.setDiscFlag(16);
        }
    }

    public SwitchImpl getSeed() {
        return this._seed;
    }

    public void setSeed(SwitchImpl newSeed) {
        WwnKey newSwPK;
        WwnKey oldSwPK = this._base.getSeedSwitchPK();
        WwnKey wwnKey = newSwPK = newSeed != null ? newSeed.getSwitchPK() : null;
        if (!GenUtil.equals(oldSwPK, newSwPK)) {
            this._base.setSeedSwitchPK(newSwPK);
            this.propertyChanged((short)781, oldSwPK, newSwPK);
        }
        this._seed = newSeed;
    }

    public SwitchImpl getFcAliasSeed() {
        return this._fcAliasSeed;
    }

    public void setFcAliasSeed(SwitchImpl newSeed) {
        if (newSeed != this._fcAliasSeed) {
            WwnKey oldSwPK = this._base.getFcAliasSeedPK();
            WwnKey newSwPK = newSeed != null ? newSeed.getSwitchPK() : null;
            this._base.setFcAliasSeedPK(newSwPK);
            this._fcAliasSeed = newSeed;
            this.propertyChanged((short)782, oldSwPK, newSwPK);
        }
    }

    public long getPrincipalSwitchId() {
        SwitchImpl sw;
        if (this._principalSwId == 0L && (sw = this.getPrincipalSwitch()) != null) {
            this._principalSwId = sw.getDBID();
        }
        return this._principalSwId;
    }

    void reselectFcAliasSeed() {
        SwitchImpl seed = null;
        Wwn prinWwn = this.getPrincipalSwitchWwn();
        for (SwitchImpl sw : this._switchByDid.values()) {
            if (!sw.isManageableMDS() || sw.isNpvEnabled()) continue;
            if (seed == null) {
                seed = sw;
                continue;
            }
            if (seed.getWwn().equals(prinWwn) || !sw.getWwn().equals(prinWwn)) continue;
            seed = sw;
            break;
        }
        this.setFcAliasSeed(seed);
    }

    public SwitchImpl selectSeed() {
        SwitchImpl seed = null;
        SwitchImpl prinSw = this.getPrincipalSwitch();
        for (SwitchImpl sw : this._switchByDid.values()) {
            if (!sw.isManageable() || !(seed == null || !seed.isMDS() && sw.isMDS() || seed.isNpvEnabled() && !sw.isNpvEnabled() || sw.isVersionGreaterThan(seed.getVersion())) && (seed == prinSw || sw != prinSw)) continue;
            seed = sw;
        }
        return seed;
    }

    public List<SwitchImpl> getAllSwitches() {
        ArrayList<SwitchImpl> sws = new ArrayList<SwitchImpl>(this._switchByDid.values());
        sws.addAll(this.getNpvEdgeSwitches());
        return sws;
    }

    public List<SwitchImpl> getSwitches() {
        ArrayList<SwitchImpl> sws = new ArrayList<SwitchImpl>(this._switchByDid.values());
        return sws;
    }

    public List<SwitchImpl> getNpvEdgeSwitches() {
        List<SwitchImpl> sws;
        if (this._npvls.size() == 0) {
            sws = Collections.emptyList();
        } else {
            sws = new ArrayList();
            for (NpvLinkImpl npvl : this._npvls) {
                SwitchImpl sw = npvl.getEdgeSwitch();
                if (sw == null || sws.contains(sw)) continue;
                sws.add(sw);
            }
        }
        return sws;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSwitch(SwitchImpl sw, int domainId, Wwn vwwn) {
        if (sw == null) {
            return;
        }
        Map<Integer, SwitchImpl> map = this._switchByDid;
        synchronized (map) {
            this._switchByDid.values().remove(sw);
            if (sw.isNpvEnabled()) {
                domainId |= 0xF00;
            }
            if (domainId == 0) {
                SwitchImpl swt = this._switchByDid.get(domainId);
                while (swt != null && !swt.getSwitchPK().equals(sw.getSwitchPK())) {
                    swt = this._switchByDid.get(++domainId);
                }
            }
            this._switchByDid.put(domainId, sw);
        }
        sw.addVsan(this, (short)domainId, vwwn);
        sw.setPresent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSwitch(SwitchImpl sw) {
        boolean removed = this._switchByDid.values().remove(sw);
        if (removed) {
            Iterator<AbstractModelObjectImpl> it;
            sw.removeVsan(this);
            if (sw == this._seed) {
                this.setSeed(null);
            }
            if (sw == this._fcAliasSeed) {
                this.reselectFcAliasSeed();
            }
            ArrayList rmEpList = new ArrayList();
            Iterator<EndPortImpl> it2 = this._endportByFcid.values().iterator();
            while (it2.hasNext()) {
                EndPortImpl ep = it2.next();
                if (ep.getSwitch() != sw) continue;
                it2.remove();
                ep.removeVsan(this);
                if (ep.getNumVsans() != 0) continue;
                ep.setOperStatusCause((short)11);
            }
            Set<AbstractModelObjectImpl> set = this._isls;
            synchronized (set) {
                it = this._isls.iterator();
                while (it.hasNext()) {
                    IslImpl isl = it.next();
                    if (isl.getSwitch1() != sw && isl.getSwitch2() != sw) continue;
                    it.remove();
                    isl.removeVsan(this._base.getId());
                    if (isl.getNumVsans() != 0) continue;
                    isl.setPresent(false, 11);
                }
            }
            set = this._npvls;
            synchronized (set) {
                it = this._npvls.iterator();
                while (it.hasNext()) {
                    NpvLinkImpl npvl = (NpvLinkImpl)it.next();
                    if (npvl.getCoreSwitch() != sw && npvl.getEdgeSwitch() != sw) continue;
                    short[] vids = npvl.getVsanIds();
                    if (vids != null && vids.length == 1 && vids[0] == this._base.getId()) {
                        npvl.setPresent(false, 11);
                        continue;
                    }
                    npvl.removeVsan(this._base.getId());
                    it.remove();
                }
            }
        }
    }

    public SwitchImpl findSwitchByDomainId(int domainId) {
        return this._switchByDid.get(domainId);
    }

    public SwitchImpl findSwitchByVwwn(byte[] vwwn) {
        for (SwitchImpl sw : this._switchByDid.values()) {
            Wwn wwn = sw.getVsanWwn(this._base.getId());
            if (wwn == null || !Arrays.equals(wwn.getValue(), vwwn)) continue;
            return sw;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndPort(EndPortImpl ep, int fcId) {
        VsanFcIdKey[] fcids;
        if (_Logger.isDebugEnabled()) {
            _Logger.trace((Object)("Adding EndPort " + ep.getPortWwn() + " to Vsan " + this.getVsanPK() + ", fcId :" + "0x" + Integer.toHexString(fcId)));
            this.printEndPortFcids(ep);
        }
        if (!ep.isPresent() && (fcids = ep.getVsanFcIds()) != null) {
            SanManager sm = SanManager.getInstance();
            for (VsanFcIdKey fcid : fcids) {
                VsanImpl vsan = sm.findVsan(fcid._vsanPK);
                if (vsan == null || vsan == this) continue;
                vsan.removeEndPort(ep);
            }
        }
        ep.setPresent(true);
        Map<Integer, EndPortImpl> map = this._endportByFcid;
        synchronized (map) {
            EndPortImpl oldport = this._endportByFcid.put(fcId, ep);
            if (oldport != null) {
                if (oldport != ep) {
                    oldport.removeVsan(this);
                }
            } else {
                int[] oldFcids = ep.getFcIds(this._base.getVsanPK()._id);
                for (int i = 0; i < oldFcids.length; ++i) {
                    if (oldFcids[i] == fcId || this._endportByFcid.get(oldFcids[i]) != ep) continue;
                    if (_Logger.isDebugEnabled()) {
                        _Logger.trace((Object)("Remove fcId 0x" + Integer.toHexString(oldFcids[i]) + " from EndPort " + ep.getPortWwn() + ", in Vsan " + this.getVsanPK()));
                    }
                    this._endportByFcid.remove(oldFcids[i]);
                }
            }
        }
        ep.addVsanFcId(this, fcId);
        if (_Logger.isDebugEnabled()) {
            _Logger.trace((Object)("Done adding EndPort " + ep.getPortWwn() + " to Vsan " + this.getVsanPK() + ", fcId :" + "0x" + Integer.toHexString(fcId)));
            this.printEndPortFcids(ep);
        }
    }

    private void printEndPortFcids(EndPortImpl ep) {
        int[] fcids = ep.getFcIds(this._base.getVsanPK()._id);
        for (int i = 0; i < fcids.length; ++i) {
            _Logger.trace((Object)("Vsan " + this.getVsanPK() + ",EndPort " + ep.getPortWwn() + ", existing fcId :" + "0x" + Integer.toHexString(fcids[i])));
        }
    }

    public void removeEndPort(EndPortImpl ep, boolean needPurge) {
        VsanFcIdKey[] fcids = ep.getVsanFcIds();
        if (fcids != null && fcids.length != 0) {
            if (fcids.length == 1 && fcids[0]._vsanPK.equals(this._base.getVsanPK()) && !needPurge) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.trace((Object)("Set VSANINACTIVE for EndPort " + ep + ", VSAN: " + this + ",fcId: " + "0x" + Integer.toHexString(fcids[0]._fcId)));
                }
                ep.setOperStatusCause((short)11);
            } else {
                int fcid = ep.getFcId(this._base.getVsanPK()._id);
                if (_Logger.isDebugEnabled()) {
                    _Logger.trace((Object)("Remove EndPort " + ep + "from Vsan " + this + ", fcId :" + "0x" + Integer.toHexString(fcid)));
                }
                EndPortImpl rmEp = null;
                if (fcid != 0) {
                    rmEp = this._endportByFcid.remove(fcid);
                }
                if (rmEp == null) {
                    this._endportByFcid.values().remove(ep);
                }
                ep.removeVsan(this);
            }
        }
    }

    public void removeEndPort(EndPortImpl ep) {
        this.removeEndPort(ep, false);
    }

    public List<EndPortImpl> getEndPorts() {
        List<EndPortImpl> list = this._endportByFcid.size() == 0 ? Collections.emptyList() : new ArrayList<EndPortImpl>(this._endportByFcid.values());
        return list;
    }

    public int getNumEndPorts() {
        return this._endportByFcid.size();
    }

    public EndPortImpl findEndPort(int fcId) {
        return this._endportByFcid.get(fcId);
    }

    public EndPortImpl findEndPort(byte[] fcId) {
        int id = ((fcId[0] & 0xFF) << 16) + ((fcId[1] & 0xFF) << 8) + (fcId[2] & 0xFF);
        return this.findEndPort(id);
    }

    public List<EndPortImpl> getInitiators() {
        ArrayList<EndPortImpl> list = new ArrayList<EndPortImpl>();
        for (EndPortImpl ep : this._endportByFcid.values()) {
            if (ep.getEnclosure() != null) {
                List<EndPortImpl> l = ep.getEnclosure().getEndPorts();
                if (l == null || l.size() == 0 || !ep.getEnclosure().isHost()) continue;
                list.add(ep);
                continue;
            }
            if (!ep.isIntiator()) continue;
            list.add(ep);
        }
        return list;
    }

    public void addIsl(IslImpl isl) {
        if (!isl.isPresent()) {
            short[] vids;
            for (short vid : vids = isl.getVsanIds()) {
                VsanImpl vsan;
                if (vid == this._base.getId() || (vsan = isl.getSwitch1().getVsan(vid)) == null) continue;
                vsan.removeIsl(isl);
            }
        }
        if (!this._isls.contains(isl)) {
            this._isls.add(isl);
        } else {
            Iterator<IslImpl> it = this._isls.iterator();
            while (it.hasNext()) {
                IslImpl oldIsl = it.next();
                if (!oldIsl.getPK().equals(isl.getPK()) || oldIsl == isl) continue;
                it.remove();
                this._isls.add(isl);
                break;
            }
        }
        isl.addVsan(this._base.getId());
        isl.setPresent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIsl(IslImpl isl) {
        boolean removed = false;
        IslImpl islImpl = isl;
        synchronized (islImpl) {
            List<Short> vids = isl.getVsanMembership();
            if (vids.size() != 0) {
                removed = true;
                isl.removeVsan(this._base.getId());
                if (isl.getNumVsans() == 0) {
                    isl.setPresent(false);
                }
            }
        }
        if (removed) {
            this._isls.remove(isl);
        }
    }

    public List<IslImpl> getIsls() {
        return new ArrayList<IslImpl>(this._isls);
    }

    public void addNpvLink(NpvLinkImpl npvl) {
        this.addNpvLink(npvl, true);
    }

    public void addNpvLink(NpvLinkImpl npvl, boolean updatePresent) {
        if (!npvl.isPresent()) {
            short[] vids;
            for (short vid : vids = npvl.getVsanIds()) {
                VsanImpl vsan;
                if (vid == this._base.getId() || (vsan = npvl.getCoreSwitch().getVsan(vid)) == null) continue;
                vsan.removeNpvLink(npvl);
            }
        }
        this._npvls.add(npvl);
        npvl.addVsan(this._base.getId());
        if (updatePresent) {
            npvl.setPresent(true, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNpvLink(NpvLinkImpl npvl) {
        boolean removed = false;
        NpvLinkImpl npvLinkImpl = npvl;
        synchronized (npvLinkImpl) {
            List<Short> vids = npvl.getVsanMembership();
            if (vids.size() != 0) {
                removed = true;
                npvl.removeVsan(this._base.getId());
                if (npvl.getNumVsans() == 0) {
                    npvl.setPresent(false, 11);
                }
            }
        }
        if (removed) {
            this._npvls.remove(npvl);
        }
    }

    public List<NpvLinkImpl> getNpvLinks() {
        List<NpvLinkImpl> npvls = this._npvls.size() == 0 ? Collections.emptyList() : new ArrayList<NpvLinkImpl>(this._npvls);
        return npvls;
    }

    void createEnclosure() {
        EnclosureImpl enc = null;
        String encname = null;
        SanManager sm = SanManager.getInstance();
        InventoryManager im = InventoryManager.getInstance();
        for (EndPortImpl ep : this._endportByFcid.values()) {
            EnclosureImpl encl = ep.getEnclosure();
            if (ep.isSVC()) continue;
            if (encl != null && encl.getName() != null) {
                if (sm.findEnclosureByName(encl.getName()) == null) {
                    sm.addEnclosure(encl);
                } else if (encl.getName().startsWith("HOST_") ? ep.getDeviceAlias() == null : !encl.getName().startsWith("Shark_")) continue;
            }
            byte[] wwn = ep.getPortWwn().getValue();
            if (ep.isFiconCup()) {
                encname = "CUP-" + ep.getVsan();
            } else if (WwnDictionary.isEMCWwn(wwn)) {
                encname = WwnDictionary.getEmcSymEncName(wwn);
            } else if (WwnDictionary.isEMC2Wwn(wwn)) {
                encname = WwnDictionary.getEmcSymEncName(wwn);
            } else if (WwnDictionary.isHDSWwn(wwn)) {
                encname = WwnDictionary.getHDSName(wwn);
            } else if (WwnDictionary.isClariionWwn(wwn)) {
                encname = WwnDictionary.getClariionName(ep.getNodeWwn().getValue());
            } else if (WwnDictionary.isAdicWwn(wwn)) {
                encname = WwnDictionary.getAdicEncName(wwn);
            } else {
                encname = ep.getDeviceAlias();
                if (encname != null) {
                    if ((encname = GenUtil.regexMatch(_Patterns, encname)) == null || encname.length() == 0) {
                        encname = ep.getDeviceAlias();
                    }
                } else {
                    encname = this.findFcAliasByWwn(ep.getPortWwn());
                    if (encname != null) {
                        if ((encname = GenUtil.regexMatch(_Patterns, encname)) == null || encname.length() == 0) {
                            encname = this.findFcAliasByWwn(ep.getPortWwn());
                        }
                    } else if (ep.isISCSI()) {
                        if (ep.getNodeIpAddress() != null) {
                            try {
                                encname = InetAddress.getByName(ep.getNodeIpAddress()).getHostName();
                                if (encname.equals(ep.getNodeIpAddress())) {
                                    encname = ep.getSymNodeName();
                                }
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (encname == null && ep.getSymNodeName() != null) {
                            encname = ep.getSymNodeName();
                        }
                    }
                }
            }
            if (encname == null || encname.length() == 0) {
                encname = WwnDictionary.get(ep.getNodeWwn().getValue(), true, false);
                if (encname == null) {
                    encname = "";
                }
                if (ep.isVolume()) {
                    String vdn = WwnDictionary.getVendor(ep.getNodeWwn().getValue());
                    encname = vdn != null ? (encname.length() > 8 ? vdn + " volume " + encname.substring(encname.length() - 8) : vdn + " volume") : encname + " volume";
                } else {
                    encname = encname.replaceAll(":", "").replaceAll(" ", "");
                    if (!ep.isTarget()) {
                        encname = "HOST_" + encname;
                    }
                }
            }
            enc = sm.createEnclosure(encname, null, true);
            ep.setEnclosure(enc);
            Hba hba = im.findHbaByWwn(ep.getPortWwn());
            if (hba == null) continue;
            enc.addHba(hba);
        }
    }

    public int getNumOfIsls() {
        return this._isls.size();
    }

    public int getNumOfNpvls() {
        return this._npvls.size();
    }

    public int getNumOfEndPorts() {
        return this._endportByFcid.size();
    }

    public int getNumOfSwitches() {
        return this._switchByDid.size();
    }

    List<EndPortImpl> purgeEndPorts() {
        ArrayList<EndPortImpl> downEndPorts = new ArrayList<EndPortImpl>(5);
        SanManager sm = SanManager.getInstance();
        Iterator<EndPortImpl> it = this._endportByFcid.values().iterator();
        while (it.hasNext()) {
            EndPortImpl ep = it.next();
            if (ep.isPresent() && sm.findSwitch(ep.getSwitchPK(), this.getFabric().getPK()) != null) continue;
            sm.removeEndPort(ep);
            downEndPorts.add(ep);
            it.remove();
        }
        return downEndPorts.size() == 0 ? null : downEndPorts;
    }

    List<EndPortImpl> purgeDupEndPorts() {
        ArrayList<EndPortImpl> downEndPorts = new ArrayList<EndPortImpl>(5);
        SanManager sm = SanManager.getInstance();
        EndPortImpl[] eps = this._endportByFcid.values().toArray(new EndPortImpl[this._endportByFcid.size()]);
        EndPortImpl[] epsc = this._endportByFcid.values().toArray(new EndPortImpl[this._endportByFcid.size()]);
        block0: for (EndPortImpl ep : eps) {
            for (EndPortImpl epc : epsc) {
                if (ep.getFabricPK() == null || ep.isPresent() || !epc.isPresent() || !ep.getNodeWwn().equals(epc.getNodeWwn()) || ep.getIfIndex() != epc.getIfIndex() || ep.getPortWwn().equals(epc.getPortWwn())) continue;
                sm.removeEndPort(ep);
                downEndPorts.add(ep);
                this._endportByFcid.values().remove(ep);
                continue block0;
            }
        }
        return downEndPorts.size() == 0 ? null : downEndPorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IslImpl> purgeIsls() {
        ArrayList<IslImpl> pkeys = new ArrayList<IslImpl>(5);
        SanManager sm = SanManager.getInstance();
        Set<IslImpl> set = this._isls;
        synchronized (set) {
            Iterator<IslImpl> it = this._isls.iterator();
            while (it.hasNext()) {
                IslImpl isl = it.next();
                if (isl.isPresent() && sm.findSwitch(isl.getSwitch1IntKey()._swPK, this.getFabric().getPK()) != null && sm.findSwitch(isl.getSwitch2IntKey()._swPK, this.getFabric().getPK()) != null) continue;
                pkeys.add(isl);
                it.remove();
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Vsan(" + this.getId() + ") purged Isls: " + pkeys));
        }
        return pkeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<NpvLinkImpl> purgeNpvLinks() {
        ArrayList<NpvLinkImpl> purgedNpvLinks = new ArrayList<NpvLinkImpl>();
        SanManager sm = SanManager.getInstance();
        Set<NpvLinkImpl> set = this._npvls;
        synchronized (set) {
            Iterator<NpvLinkImpl> it = this._npvls.iterator();
            while (it.hasNext()) {
                NpvLinkImpl npvLink = it.next();
                if (!SanManager.getInstance().shouldPurgeNpvLink(npvLink)) continue;
                purgedNpvLinks.add(npvLink);
                it.remove();
            }
        }
        if (_Logger.isTraceEnabled()) {
            _Logger.trace((Object)("Vsan(" + this.getId() + ") purged NPV links: " + purgedNpvLinks));
        }
        return purgedNpvLinks;
    }

    public void setDiscFlag(int type) {
        this._discFlags |= type;
    }

    public void resetDiscFlag(int type) {
        this._discFlags &= ~type;
    }

    public boolean isDiscFlagSet(int type) {
        return (this._discFlags & type) != 0;
    }

    public boolean setFspfCheckSum(long checksum) {
        if (this._fspfCheckSum != checksum) {
            this._fspfCheckSum = checksum;
            this.setDiscFlag(4);
            return true;
        }
        return false;
    }

    void destroy() {
        for (EndPortImpl ep : this._endportByFcid.values()) {
            ep.removeVsan(this);
            if (ep.getNumVsans() != 0) continue;
            ep.setOperStatusCause((short)11);
        }
        for (SwitchImpl sw : this._switchByDid.values()) {
            sw.removeVsan(this);
            if (sw.getNumVsans() != 0 || !sw.isMDS()) continue;
            sw.setPresent(false);
        }
        short vid = this._base.getId();
        for (IslImpl isl : this._isls) {
            isl.removeVsan(vid);
            if (isl.getNumVsans() != 0) continue;
            isl.setPresent(false, 11);
        }
        this._seed = null;
        this._endportByFcid.clear();
        this._switchByDid.clear();
        this._isls.clear();
        this._npvls.clear();
    }

    public String dump(int level) {
        short vid = this._base.getId();
        StringBuffer sb = new StringBuffer();
        sb.append(FabricImpl.LIL[level]).append("VSAN: ").append(vid);
        sb.append(FabricImpl.LIL[level + 1]).append("Name: ").append(this._base.getName());
        sb.append(FabricImpl.LIL[level + 1]).append("AdminState: ").append(this._base.isActive() ? "active" : "suspended");
        sb.append(FabricImpl.LIL[level + 1]).append("OperStatus: ").append(this._base.isUp() ? "up" : "down");
        sb.append(FabricImpl.LIL[level + 1]).append("InterOperMode: ").append(this._base.getInterOperMode());
        sb.append(FabricImpl.LIL[level + 1]).append("MTU: ").append(this._base.getMtu());
        sb.append(FabricImpl.LIL[level + 1]).append("LoadBalancingType: ").append(this._base.getLoadBalancingType());
        sb.append(FabricImpl.LIL[level + 1]).append("IsInOrderDelivery: ").append(this._base.isInorderDelivery());
        sb.append(FabricImpl.LIL[level + 1]).append("NetworkDropLatency: ").append(this._base.getNetworkDropLatency());
        if (this._base.isFicon()) {
            sb.append(FabricImpl.LIL[level + 1]).append("FICON State: ").append(this._base.getFiconState() == 2 ? "online" : "offline");
        }
        sb.append(FabricImpl.LIL[level + 1]).append("Segmented: ").append(this.isSegmented());
        sb.append(FabricImpl.LIL[level + 1]).append("Principal Switch: ");
        Wwn wwn = this.getPrincipalSwitchWwn();
        if (wwn == null) {
            sb.append("none");
        } else {
            SwitchImpl sw = SanManager.getInstance().findSwitch(wwn, this.getFabric().getPK());
            if (sw != null) {
                sb.append(sw.getName());
            } else {
                sb.append(wwn);
            }
        }
        sb.append(FabricImpl.LIL[level + 1]).append("Seed Switch: ").append(this._seed == null ? "n/a" : this._seed.getIpAddress());
        if (this._fcAliasSeed != null) {
            sb.append(FabricImpl.LIL[level + 1]).append("FC Alias Seed: ").append(this._fcAliasSeed.getIpAddress());
        }
        sb.append(FabricImpl.LIL[level + 1]).append(this._switchByDid.size()).append(" Switches: ");
        for (Map.Entry<Integer, SwitchImpl> entry : this._switchByDid.entrySet()) {
            SwitchImpl sw = entry.getValue();
            sb.append(FabricImpl.LIL[level + 2]).append(sw.getName()).append(", ").append(sw.getWwn()).append(", IP: ").append(sw.getIpAddress()).append(", Domain: ").append(sw.isNpvEnabled() ? entry.getKey() & 0xFF : entry.getKey());
            if (sw.getWwn().equals(wwn)) {
                sb.append(" (principal)");
            }
            if (sw.equals(this._seed)) {
                sb.append(" (seed)");
            }
            if (sw.equals(this._fcAliasSeed)) {
                sb.append(" (FC alias seed)");
            }
            if (sw.getVsanIp(vid) == null) continue;
            sb.append(", VSAN-IP: ").append(sw.getVsanIp(vid).getHostAddress());
        }
        if (sb.indexOf(", ", sb.length() - 2) != -1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(FabricImpl.LIL[level + 1]).append(this._isls.size()).append(" ISLs: ");
        Iterator<IslImpl> it = this._isls.iterator();
        while (it.hasNext()) {
            sb.append(FabricImpl.LIL[level + 2]).append(it.next());
        }
        if (this._npvls.size() != 0) {
            List<SwitchImpl> npvsws = this.getNpvEdgeSwitches();
            sb.append(FabricImpl.LIL[level + 1]).append(npvsws.size()).append(" NPV Switches: ");
            for (SwitchImpl npvsw : npvsws) {
                sb.append(FabricImpl.LIL[level + 2]).append(npvsw.getName()).append(", ").append(npvsw.getWwn()).append(", IP: ").append(npvsw.getIpAddress());
            }
            sb.append(FabricImpl.LIL[level + 1]).append(this._npvls.size()).append(" NPV Links: ");
            Iterator<NpvLinkImpl> it2 = this._npvls.iterator();
            while (it2.hasNext()) {
                sb.append(FabricImpl.LIL[level + 2]).append(it2.next());
            }
        }
        sb.append(FabricImpl.LIL[level + 1]).append(this._endportByFcid.size()).append(" EndPorts: ");
        for (EndPortImpl ep : this._endportByFcid.values()) {
            sb.append(FabricImpl.LIL[level + 2]).append(ep.getPortWwn()).append(", FCID: 0x").append(Integer.toHexString(ep.getFcId(vid)));
        }
        Collection<FcPortAlias> fas = this._base.getAliasList();
        sb.append(FabricImpl.LIL[level + 1]).append(fas.size()).append(" FC Aliases: ");
        for (FcPortAlias alias : fas) {
            sb.append(FabricImpl.LIL[level + 2]).append(alias);
        }
        sb.append(this.dumpZoneset(level + 1)).append(FabricImpl.LIL[level + 1]).append("Discovery Flags: ").append(this._discFlags).append(FabricImpl.LIL[level + 1]).append("Last Scan Time: ").append(new Date(this._base.getLastScanTime()));
        return sb.toString();
    }

    public String dumpZoneset(int level) {
        StringBuffer sb = new StringBuffer();
        sb.append(FabricImpl.LIL[level]).append("Active Zoneset: ");
        if (this._base.getEnforcedZoneSetName() == null || this._base.getEnforcedZoneSetName().length() == 0) {
            sb.append("none");
        } else {
            sb.append(this._base.getEnforcedZoneSetName());
            sb.append(FabricImpl.LIL[level]).append("Zoneset Activate Time: ");
            if (this._base.getEnforcedZoneSetActivateTime() == 0L) {
                sb.append("none");
            } else {
                sb.append(new Date(this._base.getEnforcedZoneSetActivateTime()));
            }
            ZoneBase[] zones = this._base.getEnforcedZones();
            if (zones != null) {
                sb.append(FabricImpl.LIL[level]).append("Active Zones: ");
                for (int i = 0; i < zones.length; ++i) {
                    sb.append(ZoneImpl.dump(zones[i], level + 1));
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPreexistRecord(Connection con) throws SQLException {
        block6: {
            PreparedStatement stat = null;
            ResultSet rs = null;
            try {
                stat = con.prepareStatement(QuerySQLByFabricIDVsanIndex);
                this.setupCheckExistenceStatement(stat);
                rs = stat.executeQuery();
                if (rs.next()) {
                    this.setDBID(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stat);
            }
            DbUtil.close(stat);
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        FabricImpl fabric = this.getFabric();
        if (fabric == null) {
            return null;
        }
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() == 0L) {
            this.setDBID(Sequence.getSequence().getPK());
            PreparedStatement stat = con.prepareStatement(InsertSQL);
            this.setupInsertStatement(stat);
            return stat;
        }
        PreparedStatement stat = con.prepareStatement(UpdateSQL);
        this.setupUpdateStatement(stat);
        return stat;
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList loadFromDB(FabricImpl fImpl) throws SQLException {
        ArrayList<VsanImpl> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQLByFabricID);
            stat.setLong(1, fImpl.getDBID());
            rs = stat.executeQuery();
            arrayList = VsanImpl.loadDBRecord(rs, fImpl);
            DbUtil.close(rs);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            ArrayList arrayList2 = null;
            return arrayList2;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList<VsanImpl> loadDBRecord(ResultSet rs, FabricImpl fImpl) throws SQLException {
        ArrayList<VsanImpl> al = new ArrayList<VsanImpl>();
        while (rs.next()) {
            VsanImpl vImpl = fImpl.createVsan(new VsanPK(rs.getInt(7), new Wwn(rs.getBytes(8))), rs.getString(2), rs.getByte(13), rs.getBoolean(3) ? (byte)1 : 2, (byte)rs.getInt(11), rs.getInt(14), rs.getByte(15), rs.getBoolean(16), rs.getInt(17));
            vImpl.setDBID(rs.getLong(1));
            fImpl.addVsanByDbId(vImpl);
            vImpl._base.setEnforcedZoneSetName(rs.getString(5));
            vImpl._base.setEnforcedZoneSetActivateTime(rs.getLong(6));
            vImpl._base.setSegmented(rs.getBoolean(9));
            vImpl._base.setFiconState((byte)rs.getInt(10));
            vImpl._base.setAdminState(rs.getByte(13));
            vImpl._base.setMtu(rs.getInt(14));
            vImpl._base.setLoadBalancingType(rs.getByte(15));
            vImpl._base.setInorderDelivery(rs.getBoolean(16));
            vImpl._base.setNetworkDropLatency(rs.getInt(17));
            al.add(vImpl);
        }
        return al;
    }

    public static String getInsertSqlStr() {
        return InsertSQL;
    }

    public static String getUpdateSqlStr() {
        return UpdateSQL;
    }

    public static String getCheckExistenceSqlStr() {
        return QuerySQLByFabricIDVsanIndex;
    }

    public void setupInsertStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        FabricImpl fabric = this.getFabric();
        if (fabric == null) {
            throw new SQLException("Invalid Vsan: fabric is null");
        }
        stat.setLong(1, this.getDBID());
        stat.setString(2, this.getName());
        stat.setBoolean(3, this.isUp());
        if (this._seed != null) {
            stat.setLong(4, this._seed.getDBID());
        } else {
            stat.setNull(4, 4);
        }
        stat.setString(5, this._base.getEnforcedZoneSetName());
        stat.setLong(6, this.getEnforcedZoneSetActivateTime());
        stat.setLong(7, fabric.getDBID());
        stat.setInt(8, this.getId());
        VsanPK vsanPK = this.getVsanPK();
        stat.setBytes(9, vsanPK._prinSwwn.getValue());
        stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
        stat.setBoolean(11, this._base.isSegmented());
        stat.setInt(12, this._base.getFiconState() & 0xFF);
        stat.setInt(13, this._base.getInterOperMode() & 0xFF);
        stat.setLong(14, this.getPrincipalSwitchId());
        stat.setByte(15, this._base.getAdminState());
        stat.setInt(16, this._base.getMtu());
        stat.setByte(17, this._base.getLoadBalancingType());
        stat.setBoolean(18, this._base.isInorderDelivery());
        stat.setInt(19, this._base.getNetworkDropLatency());
    }

    public void setupUpdateStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        FabricImpl fabric = this.getFabric();
        if (fabric == null) {
            throw new SQLException("Can not persist " + this + ": fabric is null");
        }
        stat.setString(1, this.getName());
        stat.setBoolean(2, this.isUp());
        if (this._seed != null) {
            stat.setLong(3, this._seed.getDBID());
        } else {
            stat.setNull(3, 4);
        }
        stat.setString(4, this._base.getEnforcedZoneSetName());
        stat.setLong(5, this.getEnforcedZoneSetActivateTime());
        stat.setLong(6, fabric.getDBID());
        stat.setInt(7, this.getId());
        VsanPK vsanPK = this.getVsanPK();
        stat.setBytes(8, vsanPK._prinSwwn.getValue());
        stat.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
        stat.setBoolean(10, this._base.isSegmented());
        stat.setInt(11, this._base.getFiconState() & 0xFF);
        stat.setInt(12, this._base.getInterOperMode() & 0xFF);
        stat.setLong(13, this.getPrincipalSwitchId());
        stat.setByte(14, this._base.getAdminState());
        stat.setInt(15, this._base.getMtu());
        stat.setByte(16, this._base.getLoadBalancingType());
        stat.setBoolean(17, this._base.isInorderDelivery());
        stat.setInt(18, this._base.getNetworkDropLatency());
        stat.setLong(19, this.getDBID());
    }

    public void setupCheckExistenceStatement(PreparedStatement stat) throws SQLException {
        if (stat == null) {
            return;
        }
        stat.setLong(1, this.getFabric().getDBID());
        stat.setInt(2, this.getId());
        VsanPK vsanPK = this.getVsanPK();
        stat.setBytes(3, vsanPK._prinSwwn.getValue());
    }

    public ArrayList<EnclosureImpl> getHostEnclosures() {
        ArrayList<EnclosureImpl> list = new ArrayList<EnclosureImpl>();
        ArrayList<EndPortImpl> epList = new ArrayList<EndPortImpl>(this._endportByFcid.values());
        for (EndPortImpl ep : epList) {
            EnclosureImpl ec = ep.getEnclosure();
            if (ec == null || !ec.isHost() || list.contains(ec)) continue;
            list.add(ec);
        }
        epList.clear();
        epList = null;
        return list;
    }

    public EndPortImpl findIscsiEndport(String iScsiName) {
        List<EndPortImpl> epList = this.getEndPorts();
        for (EndPortImpl empl : epList) {
            if (!empl.isISCSI() || empl.getSymNodeName() == null || !empl.getSymNodeName().equals(iScsiName)) continue;
            return empl;
        }
        return null;
    }

    public FcPortAlias[] getFcAliases() {
        return this._base.getFcAliases();
    }

    public FcPortAlias createFcAlias(Wwn pwwn, String alias) {
        FcPortAlias fa = this._base.findFcAlias(alias);
        if (fa == null) {
            fa = new FcPortAlias(alias, pwwn);
            this._base.addFcAlias(fa);
            this.propertyChanged((short)786, null, fa);
        } else if (!fa.getWwn().equals(pwwn)) {
            this._base.updateFcAliasWwn(fa, pwwn);
            this.propertyChanged((short)786, null, fa);
        }
        return fa;
    }

    public List<String> getFcAliasNames() {
        return this._base.getFcAliasNames();
    }

    public void removeFcAlias(String alias) {
        FcPortAlias fa = this._base.removeFcAlias(alias);
        if (fa != null) {
            this.propertyChanged((short)786, fa, null);
        }
    }

    public FcPortAlias findFcAliasByName(String name) {
        return this._base.findFcAlias(name);
    }

    public String findFcAliasByWwn(Wwn pwwn) {
        FcPortAlias fa = this._base.findFcAlias(pwwn);
        return fa != null ? fa.getAlias() : null;
    }

    public String toDiscFlagString() {
        return VsanImpl.toDiscFlagString(this._discFlags);
    }

    static {
        String aliasRE = System.getProperties().getProperty("fabric.aliasRE");
        if (aliasRE != null && aliasRE.length() != 0) {
            String[] ss = aliasRE.split(",", -1);
            _Patterns = new ArrayList();
            for (String exp : ss) {
                try {
                    _Patterns.add(Pattern.compile(exp));
                }
                catch (PatternSyntaxException ex) {
                    _Logger.warn((Object)("invalid pattern expression in fabric.aliasRE ignored: " + exp));
                }
            }
        }
    }
}

