/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.CfsStaticPeerDto;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.npv.NPVhelper;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CFSStatisPeerListRunnable
extends NpvRunnable {
    static Logger _logger = LogManager.getLogger((String)"fms.npv");
    static final int[] _cfsStatPeerAddrRowStatus = MibNode.get("cfsStatPeerAddrRowStatus").getOid();
    static final SnmpInt ACTIVE = new SnmpInt(1);
    static final SnmpInt CREATE_AND_GO = new SnmpInt(4);
    static final SnmpInt DESTROY = new SnmpInt(6);
    protected SwitchBase _sw;
    protected SnmpUserOpt _snmpUserOpt;
    protected CommunicationObjectSender _sender;
    protected long _requestId;
    protected List<CfsStaticPeerDto> _cfsPeerList;

    public CFSStatisPeerListRunnable(long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, List<CfsStaticPeerDto> cfsPeerList, CommunicationObjectSender sender) {
        this._sw = sw;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        this._requestId = requestId;
        this._cfsPeerList = cfsPeerList;
    }

    @Override
    public void run() {
        try {
            QueueResponseObject result = this.setCFSStaticPeerList();
            this._sender.send(result);
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to set CFS Static Peer List for switch:" + this._sw.toString() + " received error: " + se.getMessage()));
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    public QueueResponseObject setCFSStaticPeerList() throws SnmpException {
        byte[] addr;
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        List<CfsStaticPeerDto> currentCfsList = NPVhelper.getCFSStaticPeerList(peer);
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        ArrayList<CfsStaticPeerDto> deleteCfsList = new ArrayList<CfsStaticPeerDto>();
        deleteCfsList.addAll(currentCfsList);
        deleteCfsList.removeAll(this._cfsPeerList);
        SnmpOID localToRemove = null;
        for (CfsStaticPeerDto next : deleteCfsList) {
            addr = next.getAddrByteArray();
            int[] index = new int[addr.length + 2];
            index[0] = next.getAddrType();
            index[1] = addr.length;
            int i = 2;
            for (byte nextB : addr) {
                index[i++] = new Integer(nextB & 0xFF);
            }
            if (next.getAddress().equals(this._sw.getInetAddress())) {
                localToRemove = new SnmpOID(_cfsStatPeerAddrRowStatus, index);
                continue;
            }
            pdu.addVar(new SnmpOID(_cfsStatPeerAddrRowStatus, index), DESTROY);
        }
        if (localToRemove != null) {
            pdu.addVar(localToRemove, DESTROY);
        }
        this._cfsPeerList.removeAll(currentCfsList);
        for (CfsStaticPeerDto next : this._cfsPeerList) {
            addr = next.getAddrByteArray();
            int addrType = next.getAddrType();
            int[] index = new int[addr.length + 2];
            index[0] = addrType;
            index[1] = addr.length;
            int i = 2;
            for (byte nextB : addr) {
                index[i++] = new Integer(nextB & 0xFF);
            }
            pdu.addVar(new SnmpOID(_cfsStatPeerAddrRowStatus, index), CREATE_AND_GO);
        }
        peer.set(pdu);
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }
}

