/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import java.util.Calendar;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class CopyRSRunnable
extends NpvRunnable {
    static final int[] _ccCopyEntryRowStatusOid = MibNode.get("ccCopyEntryRowStatus").getOid();
    static final int[] _ccCopySourceFileTypeOid = MibNode.get("ccCopySourceFileType").getOid();
    static final int[] _ccCopyDestFileTypeOid = MibNode.get("ccCopyDestFileType").getOid();
    static final int[] _ccCopyStateOid = MibNode.get("ccCopyState").getOid();
    static final int[] _ccCopyFailCauseOid = MibNode.get("ccCopyFailCause").getOid();
    static Logger _logger = LogManager.getLogger((String)"fms.npv");
    protected SwitchBase _sw;
    protected SnmpUserOpt _snmpUserOpt;
    protected CommunicationObjectSender _sender;
    protected long _requestId;

    public CopyRSRunnable(long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, CommunicationObjectSender sender) {
        this._sw = sw;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        this._requestId = requestId;
    }

    @Override
    public void run() {
        try {
            QueueResponseObject result = this.copyRS();
            this._sender.send(result);
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to save running config to startup for switch:" + this._sw.toString() + " received error: " + se.getMessage()));
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    public QueueResponseObject copyRS() throws SnmpException {
        QueueResponseObject result = null;
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        String sysName = this._sw.getSysName();
        if (sysName != null && sysName.length() > 0) {
            peer.setSysName(sysName);
        }
        if (peer.isV3()) {
            peer.sendDiscover();
        }
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        pdu.setIgnoreSetCount(true);
        pdu.setRetries(0);
        int uniqueIndex = Math.abs(new Long(Calendar.getInstance().getTimeInMillis()).intValue());
        if (uniqueIndex < 0 && uniqueIndex == Integer.MIN_VALUE) {
            uniqueIndex = Math.abs(uniqueIndex + 10);
        }
        pdu.addVar(new SnmpOID(_ccCopyEntryRowStatusOid, uniqueIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(_ccCopySourceFileTypeOid, uniqueIndex), new SnmpInt(4));
        pdu.addVar(new SnmpOID(_ccCopyDestFileTypeOid, uniqueIndex), new SnmpInt(3));
        SnmpPDU resp = peer.send(pdu);
        pdu = new SnmpPDU(-96, new VarBindList());
        pdu.addNull(new SnmpOID(_ccCopyStateOid, uniqueIndex));
        pdu.addNull(new SnmpOID(_ccCopyFailCauseOid, uniqueIndex));
        boolean done = false;
        String failureStr = null;
        while (!done) {
            resp = peer.send(pdu);
            VarBindList respVar = resp.getVariables();
            int state = respVar.intValue(0);
            block1 : switch (state) {
                case 1: 
                case 2: {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {}
                    break;
                }
                case 3: {
                    done = true;
                    break;
                }
                case 4: {
                    done = true;
                    int failureCause = respVar.intValue(1);
                    switch (failureCause) {
                        case 3: {
                            failureStr = "Copying of running config to startup timedout";
                            break block1;
                        }
                        case 4: {
                            failureStr = "The Agent wasn't able to allocate memory for the config-copy operation.";
                            break block1;
                        }
                        case 7: {
                            failureStr = "Applying of some of the configuration commands failed.";
                            break block1;
                        }
                        case 8: {
                            failureStr = "The system is not ready to copy.";
                            break block1;
                        }
                        case 9: {
                            failureStr = "config copy operation aborted.";
                            break block1;
                        }
                    }
                    failureStr = "unknown failure cause";
                }
            }
        }
        pdu = new SnmpPDU(-93, new VarBindList());
        pdu.addVar(new SnmpOID(_ccCopyEntryRowStatusOid, uniqueIndex), new SnmpInt(6));
        pdu.setIgnoreSetCount(true);
        peer.send(pdu);
        result = failureStr == null ? new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null) : new QueueResponseObject(this._requestId, this._sw, 4, null, new Exception(failureStr));
        return result;
    }
}

