/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.npv;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.common.dto.QueueResponseObject;
import com.cisco.dcbu.sm.common.event.CommunicationObjectSender;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.server.npv.NpvRunnable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SwitchAuthenticate
extends NpvRunnable {
    static final SnmpOID _SysContact = new SnmpOID(new int[]{1, 3, 6, 1, 2, 1, 1, 4, 0});
    static Logger _logger = LogManager.getLogger((String)"fms.npv");
    private SwitchBase _sw;
    private SnmpUserOpt _snmpUserOpt;
    private CommunicationObjectSender _sender;
    private long _requestId;

    public SwitchAuthenticate(long requestId, SwitchBase sw, SnmpUserOpt snmpUserOpt, CommunicationObjectSender sender) {
        this._sw = sw;
        this._snmpUserOpt = snmpUserOpt;
        this._sender = sender;
        this._requestId = requestId;
    }

    @Override
    public void run() {
        try {
            QueueResponseObject result = this.authenticate();
            this._sender.send(result);
        }
        catch (Exception se) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Unable to authenticate switch:" + this._sw.toString() + " received error: " + se.getMessage()));
            }
            QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 4, null, se);
            this._sender.send(result);
        }
    }

    public QueueResponseObject authenticate() throws SnmpException {
        SnmpPeer peer = this.generatePeer(this._sw, this._snmpUserOpt);
        String sysName = this._sw.getSysName();
        if (sysName != null && sysName.length() > 0) {
            peer.setSysName(sysName);
        }
        if (peer.isV3()) {
            peer.sendDiscover();
        }
        SnmpPDU pdu = new SnmpPDU(-96, new VarBindList());
        pdu.setRetries(0);
        pdu.addNull(_SysContact);
        peer.send(pdu);
        QueueResponseObject result = new QueueResponseObject(this._requestId, this._sw, 1, "Successful", null);
        return result;
    }
}

