/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.pm.PM;
import com.cisco.dcbu.sm.server.pm.PMStatisticsManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PMSwitchSummary {
    static final int STATS_TOTAL_SIZE = 28;
    static final int STATS_SIZE = 7;
    static final String[] GraLevels = new String[]{"Daily", "Weekly", "Monthly", "Yearly"};
    static final String QuerySrcEndPortSwitchStatisticsDaily = "select sw.id, sum(stat.avg_rx), sum(stat.avg_tx), sum(stat.total_rxtx), sum(stat.max_rx), sum(stat.max_tx), sum(stat.total_err), sum(stat.total_discard) from statistics stat, switch sw, switch_port sp, end_port ep where stat.avg_rx != 'NaN' and stat.avg_tx != 'NaN' and stat.total_rxtx != 'NaN' and stat.max_rx != 'NaN' and stat.max_tx != 'NaN' and stat.avg_rx >= 0 and stat.avg_tx >=0 and stat.total_rxtx >=0 and stat.max_rx >=0 and stat.max_tx >=0 and stat.total_err >=0 and stat.total_discard >=0 and stat.src_id = ep.id and ep.switch_port_id = sp.id and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcEndPortSwitchStatisticsWeekly = "select sw.id, sum(stat.last_week_avg_rx), sum(stat.last_week_avg_tx), sum(stat.last_week_total_rxtx), sum(stat.last_week_max_rx), sum(stat.last_week_max_tx), sum(stat.last_week_total_err), sum(stat.last_week_total_discard) from statistics stat, switch sw, switch_port sp, end_port ep where stat.last_week_avg_rx != 'NaN' and stat.last_week_avg_tx != 'NaN' and stat.last_week_total_rxtx != 'NaN' and stat.last_week_max_rx != 'NaN' and stat.last_week_max_tx != 'NaN' and stat.last_week_avg_rx >= 0 and stat.last_week_avg_tx >= 0 and stat.last_week_total_rxtx >= 0 and stat.last_week_max_rx >= 0 and stat.last_week_max_tx >= 0 and stat.last_week_total_err >= 0 and stat.last_week_total_discard >= 0 and stat.src_id = ep.id and ep.switch_port_id = sp.id and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcEndPortSwitchStatisticsMonthly = "select sw.id, sum(stat.last_month_avg_rx), sum(stat.last_month_avg_tx), sum(stat.last_month_total_rxtx), sum(stat.last_month_max_rx), sum(stat.last_month_max_tx), sum(stat.last_month_total_err), sum(stat.last_month_total_discard) from statistics stat, switch sw, switch_port sp, end_port ep where stat.last_month_avg_rx != 'NaN' and stat.last_month_avg_tx != 'NaN' and stat.last_month_total_rxtx != 'NaN' and stat.last_month_max_rx != 'NaN' and stat.last_month_max_tx != 'NaN' and stat.last_month_avg_rx >= 0 and stat.last_month_avg_tx >= 0 and stat.last_month_total_rxtx >= 0 and stat.last_month_max_rx >= 0 and stat.last_month_max_tx >= 0 and stat.last_month_total_err >= 0 and stat.last_month_total_discard >= 0 and stat.src_id = ep.id and ep.switch_port_id = sp.id and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcEndPortSwitchStatisticsYearly = "select sw.id, sum(stat.last_year_avg_rx), sum(stat.last_year_avg_tx), sum(stat.last_year_total_rxtx), sum(stat.last_year_max_rx), sum(stat.last_year_max_tx), sum(stat.last_year_total_err), sum(stat.last_year_total_discard) from statistics stat, switch sw, switch_port sp, end_port ep where stat.last_year_avg_rx != 'NaN' and stat.last_year_avg_tx != 'NaN' and stat.last_year_total_rxtx != 'NaN' and stat.last_year_max_rx != 'NaN' and stat.last_year_max_tx != 'NaN' and stat.last_year_avg_rx >= 0 and stat.last_year_avg_tx >= 0 and stat.last_year_total_rxtx >= 0 and stat.last_year_max_rx >= 0 and stat.last_year_max_tx >= 0 and stat.last_year_total_err >= 0 and stat.last_year_total_discard >= 0 and stat.src_id = ep.id and ep.switch_port_id = sp.id and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcISLSwitchStatisticsDaily = "select sw.id, sum(stat.avg_rx), sum(stat.avg_tx), sum(stat.total_rxtx), sum(stat.max_rx), sum(stat.max_tx), sum(stat.total_err), sum(stat.total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.avg_rx != 'NaN' and stat.avg_tx != 'NaN' and stat.total_rxtx != 'NaN' and stat.max_rx != 'NaN' and stat.max_tx != 'NaN' and  stat.avg_rx >= 0 and stat.avg_tx >= 0 and stat.total_rxtx >= 0 and stat.max_rx >= 0 and stat.max_tx >= 0 and stat.total_err >= 0 and stat.total_discard >= 0 and stat.src_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcISLSwitchStatisticsWeekly = "select sw.id, sum(stat.last_week_avg_rx), sum(stat.last_week_avg_tx), sum(stat.last_week_total_rxtx), sum(stat.last_week_max_rx), sum(stat.last_week_max_tx), sum(stat.last_week_total_err), sum(stat.last_week_total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.last_week_avg_rx != 'NaN' and stat.last_week_avg_tx != 'NaN' and stat.last_week_total_rxtx != 'NaN' and stat.last_week_max_rx != 'NaN' and stat.last_week_max_tx != 'NaN' and  stat.last_week_avg_rx >= 0 and stat.last_week_avg_tx >= 0 and stat.last_week_total_rxtx >= 0 and stat.last_week_max_rx >= 0 and stat.last_week_max_tx >= 0 and stat.last_week_total_err >= 0 and stat.last_week_total_discard >= 0 and stat.src_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcISLSwitchStatisticsMonthly = "select sw.id, sum(stat.last_month_avg_rx), sum(stat.last_month_avg_tx), sum(stat.last_month_total_rxtx), sum(stat.last_month_max_rx), sum(stat.last_month_max_tx), sum(stat.last_month_total_err), sum(stat.last_month_total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.last_month_avg_rx != 'NaN' and stat.last_month_avg_tx != 'NaN' and stat.last_month_total_rxtx != 'NaN' and stat.last_month_max_rx != 'NaN' and stat.last_month_max_tx != 'NaN' and  stat.last_month_avg_rx >= 0 and stat.last_month_avg_tx >= 0 and stat.last_month_total_rxtx >= 0 and stat.last_month_max_rx >= 0 and stat.last_month_max_tx >= 0 and stat.last_month_total_err >= 0 and stat.last_month_total_discard >= 0 and stat.src_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QuerySrcISLSwitchStatisticsYearly = "select sw.id, sum(stat.last_year_avg_rx), sum(stat.last_year_avg_tx), sum(stat.last_year_total_rxtx), sum(stat.last_year_max_rx), sum(stat.last_year_max_tx), sum(stat.last_year_total_err), sum(stat.last_year_total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.last_year_avg_rx != 'NaN' and stat.last_year_avg_tx != 'NaN' and stat.last_year_total_rxtx != 'NaN' and stat.last_year_max_rx != 'NaN' and stat.last_year_max_tx != 'NaN' and stat.last_year_avg_rx >= 0 and stat.last_year_avg_tx >= 0 and stat.last_year_total_rxtx >= 0 and stat.last_year_max_rx >= 0 and stat.last_year_max_tx >= 0 and stat.last_year_total_err >= 0 and stat.last_year_total_discard >= 0 and stat.src_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QueryDstSwitchStatisticsBySwitchIdDaily = "select sw.id, sum(stat.avg_tx), sum(stat.avg_rx), sum(stat.total_rxtx), sum(stat.max_tx), sum(stat.max_rx), sum(stat.total_err), sum(stat.total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.avg_rx != 'NaN' and stat.avg_tx != 'NaN' and stat.total_rxtx != 'NaN' and stat.max_rx != 'NaN' and stat.max_tx != 'NaN' and stat.avg_rx >= 0 and stat.avg_tx >= 0 and stat.total_rxtx >= 0 and stat.max_rx >= 0 and stat.max_tx >= 0 and stat.total_err >= 0 and stat.total_discard >= 0 and stat.dest_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QueryDstSwitchStatisticsBySwitchIdWeekly = "select sw.id, sum(stat.last_week_avg_rx), sum(stat.last_week_avg_tx), sum(stat.last_week_total_rxtx), sum(stat.last_week_max_rx), sum(stat.last_week_max_tx), sum(stat.last_week_total_err), sum(stat.last_week_total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.last_week_avg_rx != 'NaN' and stat.last_week_avg_tx != 'NaN' and stat.last_week_total_rxtx != 'NaN' and stat.last_week_max_rx != 'NaN' and stat.last_week_max_tx != 'NaN' and  stat.last_week_avg_rx >= 0 and stat.last_week_avg_tx >= 0 and stat.last_week_total_rxtx >= 0 and stat.last_week_max_rx >= 0 and stat.last_week_max_tx >= 0 and stat.last_week_total_err >= 0 and stat.last_week_total_discard >= 0 and stat.dest_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QueryDstSwitchStatisticsBySwitchIdMonthly = "select sw.id, sum(stat.last_month_avg_rx), sum(stat.last_month_avg_tx), sum(stat.last_month_total_rxtx), sum(stat.last_month_max_rx), sum(stat.last_month_max_tx), sum(stat.last_month_total_err), sum(stat.last_month_total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.last_month_avg_rx != 'NaN' and stat.last_month_avg_tx != 'NaN' and stat.last_month_total_rxtx != 'NaN' and stat.last_month_max_rx != 'NaN' and stat.last_month_max_tx != 'NaN' and stat.last_month_avg_rx >= 0 and stat.last_month_avg_tx >= 0 and stat.last_month_total_rxtx >= 0 and stat.last_month_max_rx >= 0 and stat.last_month_max_tx >= 0 and stat.last_month_total_err >= 0 and stat.last_month_total_discard >= 0 and stat.dest_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String QueryDstSwitchStatisticsBySwitchIdYearly = "select sw.id, sum(stat.last_year_avg_rx), sum(stat.last_year_avg_tx), sum(stat.last_year_total_rxtx), sum(stat.last_year_max_rx), sum(stat.last_year_max_tx), sum(stat.last_year_total_err), sum(stat.last_year_total_discard) from statistics stat, switch sw, switch_port sp, isl where stat.last_year_avg_rx != 'NaN' and stat.last_year_avg_tx != 'NaN' and stat.last_year_total_rxtx != 'NaN' and stat.last_year_max_rx != 'NaN' and stat.last_year_max_tx != 'NaN' and stat.last_year_avg_rx >= 0 and stat.last_year_avg_tx >= 0 and stat.last_year_total_rxtx >= 0 and stat.last_year_max_rx >= 0 and stat.last_year_max_tx >= 0 and stat.last_year_total_err >= 0 and stat.last_year_total_discard >= 0 and stat.dest_id = sp.id and (isl.port1_id = sp.id or isl.port2_id = sp.id) and sp.switch_id = sw.id group by sw.id";
    static final String InsertSwitchSummarySQL = "insert into statistics (src_id, dest_id, type, avg_rx, avg_tx, total_rxtx, max_rx, max_tx, total_err, total_discard, last_week_avg_rx, last_week_avg_tx, last_week_total_rxtx, last_week_max_rx, last_week_max_tx, last_week_total_err, last_week_total_discard, last_month_avg_rx, last_month_avg_tx, last_month_total_rxtx, last_month_max_rx, last_month_max_tx, last_month_total_err, last_month_total_discard, last_year_avg_rx, last_year_avg_tx, last_year_total_rxtx, last_year_max_rx, last_year_max_tx, last_year_total_err, last_year_total_discard, last_update_time)values (?,?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    static void aggregate2DB() throws Exception {
        PM._Logger.debug((Object)(new Date().toString() + ": Switch Total Bandwidth data aggregate to db"));
        PMStatisticsManager.cleanOldData(7);
        PMSwitchSummary.processSwitchData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSwitchData() {
        HashMap<Long, double[]> map = new HashMap<Long, double[]>();
        Connection conn = null;
        try {
            FileLicensingHelper flHelper = FileLicensingHelper.getInstance();
            List<SwitchAssignedLicenseInfo> assignedLicenseInfoList = flHelper.getLicenseInfoSwitchAssignment();
            List<Long> licensedSwList = PMSwitchSummary.getAllLicensedSwitch(assignedLicenseInfoList);
            conn = ConnectionManager.getConnection();
            PMSwitchSummary.processSQL(map, "QuerySrcEndPortSwitchStatistics", conn, licensedSwList);
            PMSwitchSummary.processSQL(map, "QuerySrcISLSwitchStatistics", conn, licensedSwList);
            PMSwitchSummary.processSQL(map, "QueryDstSwitchStatisticsBySwitchId", conn, licensedSwList);
            PMSwitchSummary.updateStats(map, InsertSwitchSummarySQL, conn);
        }
        catch (Exception ex) {
            try {
                PM._Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(conn);
        }
        DbUtil.close(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateStats(HashMap<Long, double[]> map, String insertSQL, Connection conn) {
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        long switchId = -1L;
        double[] values = null;
        try {
            Iterator<Map.Entry<Long, double[]>> itr = map.entrySet().iterator();
            Map.Entry<Long, double[]> entry = null;
            while (itr.hasNext()) {
                entry = itr.next();
                pstmt_s = conn.prepareStatement(insertSQL);
                switchId = entry.getKey();
                pstmt_s.setLong(1, switchId);
                pstmt_s.setLong(2, switchId);
                pstmt_s.setInt(3, 7);
                for (int i = 4; i <= 31; ++i) {
                    values = entry.getValue();
                    pstmt_s.setDouble(i, values[i - 4]);
                }
                pstmt_s.setTimestamp(32, new Timestamp(System.currentTimeMillis()));
                pstmt_s.execute();
                pstmt_s.close();
            }
        }
        catch (Exception ex) {
            PM._Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSQL(HashMap<Long, double[]> map, String sql, Connection conn, List<Long> licensedSwList) {
        PreparedStatement pstmt_s = null;
        ResultSet rs = null;
        long switchId = -1L;
        double[] values = null;
        try {
            for (int j = 0; j < GraLevels.length; ++j) {
                pstmt_s = conn.prepareStatement(PMSwitchSummary.class.getDeclaredField(sql + GraLevels[j]).get(PMSwitchSummary.class).toString());
                rs = pstmt_s.executeQuery();
                while (rs.next()) {
                    switchId = rs.getLong(1);
                    if (!licensedSwList.contains(switchId)) continue;
                    if (!map.containsKey(switchId)) {
                        map.put(switchId, new double[28]);
                    }
                    values = map.get(switchId);
                    for (int i = 2; i <= 8; ++i) {
                        int n = i - 2 + j * 7;
                        values[n] = values[n] + (rs.getObject(i) == null || ((Double)rs.getObject(i)).isNaN() ? 0.0 : (Double)rs.getObject(i));
                    }
                }
                rs.close();
                rs = null;
                pstmt_s.close();
                pstmt_s = null;
            }
        }
        catch (Exception ex) {
            PM._Logger.warn((Object)("PMSwitchSummary set switch data error: " + ex.getMessage()), (Throwable)ex);
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
        }
    }

    private static List<Long> getAllLicensedSwitch(List<SwitchAssignedLicenseInfo> assignedLicenseInfoList) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (SwitchAssignedLicenseInfo sw : assignedLicenseInfoList) {
            boolean isLicensed = sw.isLicensed();
            if (!isLicensed) continue;
            ret.add(sw.getDbID());
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            System.out.println(PMSwitchSummary.class.getDeclaredField("QuerySrcISLSwitchStatisticsDaily").get(PMSwitchSummary.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

