/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.sm.common.pm.PmConfig;
import com.cisco.dcbu.sm.server.pm.PM;
import com.cisco.dcbu.sm.server.pm.PMStatisticsManager;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmConfigUtil;
import com.cisco.dcbu.sm.server.pm.PmFileStoreManager;
import com.cisco.dcbu.sm.server.pm.PmMetadata;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jrobin.core.Datasource;
import org.jrobin.core.FetchPoint;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.Source;

public class PmDisplay {
    public static final int WIDTH = 600;
    public static final int HEIGHT = 220;
    static final long DAY_SECS = 86400L;
    static final long WEEK_SECS = 604800L;
    static final long MONTH_SECS = 2592000L;
    static final long YEAR_SECS = 31536000L;
    static PmMetadata _meta = null;
    private static final Color[] COLORS = new Color[]{Color.BLUE, new Color(0, 128, 64), Color.GREEN, Color.GRAY, Color.BLACK};
    private static final Color[] PEAK_COLORS = new Color[]{new Color(0, 200, 255), new Color(0, 100, 80)};
    private static final Color[] ERR_COLORS = new Color[]{Color.RED, Color.ORANGE, Color.MAGENTA, Color.YELLOW, Color.PINK};
    PmMetadata _MetaData;
    int _NumProcessed;
    int _TotalFiles;
    String _EndDate;
    String _DayStartDate;
    String _WeekStartDate;
    String _MonthStartDate;
    String _YearStartDate;
    String _CustomStartDate;
    public DateFormat _DateFormat = new SimpleDateFormat("yyyy MMM dd HH:mm");

    static long parseDateTime(String dateTime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        Date date = sdf.parse(dateTime);
        return date.getTime();
    }

    static synchronized PmMetadata loadMetaData(boolean doubleFlow) throws Exception {
        if (_meta == null) {
            _meta = new PmMetadata();
            PmDisplay._meta._doErrorDiscard = PmCollect._CollectErrorDiscard;
        }
        return _meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(String outDir) throws Exception {
        long end = System.currentTimeMillis() / 1000L;
        File odir = new File(outDir);
        if (!odir.exists() && !odir.mkdirs()) {
            throw new IOException("Can not create output directory: " + outDir);
        }
        this._MetaData = PmDisplay.loadMetaData(false);
        RrdDb db = null;
        System.out.println("start to export to:" + outDir);
        ArrayList<Datasource> dataSources = PmDisplay.getDataSource();
        if (dataSources == null) {
            System.out.println("Did not find anything to export");
            return;
        }
        for (int i = 0; i < dataSources.size(); ++i) {
            short dataIndex;
            String fileNameLogical = dataSources.get(i).getComment();
            if (fileNameLogical == null || fileNameLogical.length() == 0) continue;
            try {
                String fileName = PmFileStoreManager.getInstance().getMappedFileName(fileNameLogical);
                dataIndex = PmFileStoreManager.getInstance().getIndex(fileNameLogical);
                if (fileName == null) continue;
                db = new RrdDb(this._MetaData._dbPath + fileName);
            }
            catch (Exception ex) {
                System.out.println("problem to read RRD:" + fileNameLogical + " .. skipped");
                continue;
            }
            String rrd = fileNameLogical.substring(0, fileNameLogical.lastIndexOf(46));
            File f = new File(outDir + PmMetadata.SEPARATOR + rrd + ".csv");
            System.out.println("Exporting to file: " + f.toString());
            PrintStream os = null;
            try {
                os = new PrintStream(new FileOutputStream(f));
                if (rrd.indexOf("_err") != -1) {
                    PmDisplay.p(os, "Date, Time, Error, Discard");
                } else {
                    PmDisplay.p(os, "Date,Time,Rx,Tx");
                }
                this.export(db, os, dataIndex);
                os.flush();
                continue;
            }
            finally {
                if (os != null) {
                    os.close();
                }
                if (db != null) {
                    db.close();
                }
            }
        }
        System.out.println("PM export to " + outDir + " Success. Took " + (System.currentTimeMillis() / 1000L - end) + " secs");
    }

    static ArrayList<Datasource> getDataSource() throws IOException, RrdException {
        String filePath = PmCollect.getPmDir() + File.separator + "db";
        File pmDir = new File(filePath);
        if (!pmDir.exists() || !pmDir.isDirectory()) {
            System.out.println("Can not find Performance database directory in " + filePath);
            throw new IOException("Can not find Performance database directory in " + filePath);
        }
        File[] files = pmDir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        System.out.println("There are " + files.length + " rrd files needed to be extracted.");
        ArrayList<Datasource> dataSources = new ArrayList<Datasource>();
        RrdDb db = null;
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().endsWith(".rrd")) continue;
            try {
                db = new RrdDb(files[i].getPath());
            }
            catch (Exception ex) {
                System.out.println("Failed to read rrd file: " + files[i] + " .. skipped!");
                continue;
            }
            for (int j = 0; j < db.getDatasources().length; ++j) {
                dataSources.add(db.getDatasources()[j]);
            }
            db.close();
        }
        return dataSources;
    }

    public File export(String rrdFile, int dataType, String outDir) throws Exception {
        this._MetaData = PmDisplay.loadMetaData(false);
        PmConfig def = null;
        try {
            def = new PmConfigUtil(rrdFile, dataType).findPmConfig();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (def == null) {
            def = this._MetaData.findDef(rrdFile, dataType);
        }
        return this.export(def, outDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File export(PmConfig def, String outDir) throws Exception {
        String fileNameLogical = this._MetaData._dbPath + PmMetadata.SEPARATOR + def._rrdFile;
        String fileName = PmFileStoreManager.getInstance().getMappedFileName(fileNameLogical);
        short dataIndex = PmFileStoreManager.getInstance().getIndex(fileNameLogical);
        RrdDb db = new RrdDb(fileName);
        String rrd = def._rrdFile.substring(0, def._rrdFile.lastIndexOf(46));
        File f = new File(outDir + PmMetadata.SEPARATOR + rrd + ".csv");
        PrintStream os = null;
        try {
            os = new PrintStream(new FileOutputStream(f));
            PmDisplay.p(os, def._title);
            PmDisplay.p(os, "Date,Time,Rx,Tx");
            this.export(db, os, dataIndex);
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (db != null) {
                db.close();
            }
        }
        if (def._errRrdFile != null) {
            fileNameLogical = this._MetaData._dbPath + PmMetadata.SEPARATOR + def._errRrdFile;
            fileName = PmFileStoreManager.getInstance().getMappedFileName(fileNameLogical);
            dataIndex = PmFileStoreManager.getInstance().getIndex(fileNameLogical);
            if (this.isValidRrdFile(fileName)) {
                RrdDb edb = new RrdDb(fileName);
                String errd = def._errRrdFile.substring(0, def._errRrdFile.lastIndexOf(46));
                File ef = new File(outDir + PmMetadata.SEPARATOR + errd + ".csv");
                PrintStream eos = null;
                try {
                    eos = new PrintStream(new FileOutputStream(ef));
                    PmDisplay.p(eos, def._title);
                    PmDisplay.p(eos, String.valueOf(def._maxValuePerSec));
                    PmDisplay.p(eos, "Date, Time, Error, Discard");
                    this.export(edb, eos, dataIndex);
                }
                finally {
                    if (eos != null) {
                        eos.close();
                    }
                    edb.close();
                }
            }
        }
        return f;
    }

    private String formatRrdTime(long time) {
        Date date = new Date(time * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd, HH:mm:ss");
        return sdf.format(date);
    }

    private void export(RrdDb db, PrintStream os, int relativeIndex) throws Exception {
        try {
            int pollInterval = (int)db.getRrdDef().getStep();
            long lastUpdateTime = db.getLastUpdateTime();
            int i = 0;
            while (true) {
                if (i < PmMetadata._Intervals.length) {
                    long prevLen = 0L;
                    long prevInterval = 0L;
                    long start = lastUpdateTime - (long)(PmMetadata._Intervals[i][1] * PmMetadata._Intervals[i][0] * pollInterval);
                    if (i != 0) {
                        prevInterval = PmMetadata._Intervals[i - 1][0] * pollInterval;
                        prevLen = (long)PmMetadata._Intervals[i - 1][1] * prevInterval;
                        start -= prevLen;
                    }
                    long end = lastUpdateTime - prevLen;
                    FetchPoint[] fetchPoints = PMStatisticsManager.getRrdData(db, "AVERAGE", start, end, relativeIndex);
                    int valueSize = fetchPoints[0].getSize();
                    for (int ii = fetchPoints.length - 1; ii >= 0; --ii) {
                        long time = fetchPoints[ii].getTime();
                        if (time < start || time > end) continue;
                        StringBuffer sb = new StringBuffer(this.formatRrdTime(time));
                        for (int j = 0; j < valueSize; ++j) {
                            double value = fetchPoints[ii].getValue(j);
                            sb.append("," + String.valueOf(value));
                        }
                        PmDisplay.p(os, sb.toString());
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String process(String contextName, String rrdFile, int data_type, String startTime, String endTime, int chart_type, PrintStream ps) throws Exception {
        try {
            long end;
            long start = 0L;
            if (chart_type == 5) {
                start = PmDisplay.parseDateTime(startTime) / 1000L;
                end = PmDisplay.parseDateTime(endTime) / 1000L;
                if (end <= start) {
                    throw new Exception("Invalid time range: End Time is before Start time.");
                }
                this._EndDate = this._DateFormat.format(new Date(end * 1000L));
                this._CustomStartDate = this._DateFormat.format(new Date(start * 1000L)) + " to " + this._EndDate;
            } else {
                String pct = null;
                try {
                    pct = System.getProperty("pmchart.currenttime");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (pct == null || pct.equals("")) {
                    end = System.currentTimeMillis() / 1000L;
                } else {
                    try {
                        end = PmDisplay.parseDateTime(pct) / 1000L;
                    }
                    catch (Exception ex) {
                        System.out.println("PM Chart demo time is defined (" + pct + " ) incorrect. Use real time for chart.");
                        end = System.currentTimeMillis() / 1000L;
                    }
                }
                this._EndDate = this._DateFormat.format(new Date(end * 1000L));
            }
            this._DayStartDate = this._DateFormat.format(new Date((end - 86400L) * 1000L)) + " to " + this._EndDate;
            this._WeekStartDate = this._DateFormat.format(new Date((end - 604800L) * 1000L)) + " to " + this._EndDate;
            this._MonthStartDate = this._DateFormat.format(new Date((end - 2592000L) * 1000L)) + " to " + this._EndDate;
            this._YearStartDate = this._DateFormat.format(new Date((end - 31536000L) * 1000L)) + " to " + this._EndDate;
            this._MetaData = PmDisplay.loadMetaData(false);
            PmConfig def = null;
            try {
                def = new PmConfigUtil(rrdFile, data_type).findPmConfig();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (def == null) {
                def = this._MetaData.findDef(rrdFile, data_type);
            }
            PmConfig[] defs = new PmConfig[]{def};
            this.processDef(defs, start, end, chart_type);
            String file = this.buildDetailPage(contextName, rrdFile, data_type, def, chart_type, ps);
            return file.substring(file.indexOf(File.separator + "pm" + File.separator));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Map<String, byte[]> getPmCharts(String rrdFile, int data_type, long startTime, long endTime, int chart_type, double criticalThresholdValue, double warningThresholdValue, double yLowRng, double yUpRng) throws Exception {
        try {
            long end;
            long start = 0L;
            if (chart_type == 5) {
                end = endTime / 1000L;
                start = startTime / 1000L;
                if (end <= start) {
                    throw new Exception("Invalid time range: End Time is before Start time.");
                }
                this._EndDate = this._DateFormat.format(new Date(endTime));
                this._CustomStartDate = this._DateFormat.format(new Date(startTime)) + " to " + this._EndDate;
            } else {
                String pct = null;
                try {
                    pct = System.getProperty("pmchart.currenttime");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (pct == null || pct.equals("")) {
                    end = System.currentTimeMillis() / 1000L;
                } else {
                    try {
                        end = PmDisplay.parseDateTime(pct) / 1000L;
                    }
                    catch (Exception ex) {
                        System.out.println("PM Chart demo time is defined (" + pct + " ) incorrect. Use real time for chart.");
                        end = System.currentTimeMillis() / 1000L;
                    }
                }
                this._EndDate = this._DateFormat.format(new Date(end * 1000L));
            }
            this._DayStartDate = this._DateFormat.format(new Date((end - 86400L) * 1000L)) + " to " + this._EndDate;
            this._WeekStartDate = this._DateFormat.format(new Date((end - 604800L) * 1000L)) + " to " + this._EndDate;
            this._MonthStartDate = this._DateFormat.format(new Date((end - 2592000L) * 1000L)) + " to " + this._EndDate;
            this._YearStartDate = this._DateFormat.format(new Date((end - 31536000L) * 1000L)) + " to " + this._EndDate;
            this._MetaData = PmDisplay.loadMetaData(false);
            PmConfig def = null;
            try {
                def = new PmConfigUtil(rrdFile, data_type).findPmConfig();
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (def == null) {
                def = this._MetaData.findDef(rrdFile, data_type);
            }
            PmConfig[] defs = new PmConfig[]{def};
            return this.processDef(defs, "Single", start, end, chart_type, criticalThresholdValue, warningThresholdValue, yLowRng, yUpRng);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Map<String, byte[]> getPmCharts(List<String> rrdFile, String aggrTitle, int data_type, long startTime, long endTime, int chart_type, double criticalThresholdValue, double warningThresholdValue, double yLowRng, double yUpRng) throws Exception {
        try {
            long end;
            long start = 0L;
            if (chart_type == 5) {
                end = endTime / 1000L;
                start = startTime / 1000L;
                if (end <= start) {
                    throw new Exception("Invalid time range: End Time is before Start time.");
                }
                this._EndDate = this._DateFormat.format(new Date(endTime));
                this._CustomStartDate = this._DateFormat.format(new Date(startTime)) + " to " + this._EndDate;
            } else {
                String pct = null;
                try {
                    pct = System.getProperty("pmchart.currenttime");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (pct == null || pct.equals("")) {
                    end = System.currentTimeMillis() / 1000L;
                } else {
                    try {
                        end = PmDisplay.parseDateTime(pct) / 1000L;
                    }
                    catch (Exception ex) {
                        System.out.println("PM Chart demo time is defined (" + pct + " ) incorrect. Use real time for chart.");
                        end = System.currentTimeMillis() / 1000L;
                    }
                }
                this._EndDate = this._DateFormat.format(new Date(end * 1000L));
            }
            this._DayStartDate = this._DateFormat.format(new Date((end - 86400L) * 1000L)) + " to " + this._EndDate;
            this._WeekStartDate = this._DateFormat.format(new Date((end - 604800L) * 1000L)) + " to " + this._EndDate;
            this._MonthStartDate = this._DateFormat.format(new Date((end - 2592000L) * 1000L)) + " to " + this._EndDate;
            this._YearStartDate = this._DateFormat.format(new Date((end - 31536000L) * 1000L)) + " to " + this._EndDate;
            this._MetaData = PmDisplay.loadMetaData(false);
            PmConfig def = null;
            PmConfig[] defs = new PmConfig[rrdFile.size()];
            for (int i = 0; i < rrdFile.size(); ++i) {
                String e = rrdFile.get(i);
                try {
                    def = new PmConfigUtil(e, data_type).findPmConfig();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (def == null) {
                    def = this._MetaData.findDef(e, data_type);
                }
                defs[i] = def;
            }
            return this.processDef(defs, aggrTitle, start, end, chart_type, criticalThresholdValue, warningThresholdValue, yLowRng, yUpRng);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public RrdGraphDef[] process(String rrdFile, int data_type, String startTime, String endTime, int chart_type, double criticalThresholdValue, double warningThresholdValue) throws Exception {
        long start = 0L;
        long end = System.currentTimeMillis() / 1000L;
        this._EndDate = this._DateFormat.format(new Date(end * 1000L));
        this._DayStartDate = this._DateFormat.format(new Date((end - 86400L) * 1000L)) + " to " + this._EndDate;
        this._WeekStartDate = this._DateFormat.format(new Date((end - 604800L) * 1000L)) + " to " + this._EndDate;
        this._MonthStartDate = this._DateFormat.format(new Date((end - 2592000L) * 1000L)) + " to " + this._EndDate;
        this._YearStartDate = this._DateFormat.format(new Date((end - 31536000L) * 1000L)) + " to " + this._EndDate;
        this._MetaData = PmDisplay.loadMetaData(false);
        PmConfig def = null;
        try {
            def = new PmConfigUtil(rrdFile, data_type).findPmConfig();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (def == null) {
            def = this._MetaData.findDef(rrdFile, data_type);
        }
        return this.processSimpleDef(def, start, end, chart_type, criticalThresholdValue, warningThresholdValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildDetailPage(String contextName, String rrdFile, int type, PmConfig def, int chartType, PrintStream os) throws IOException, RrdException {
        String rrd = def._rrdFile.substring(0, def._rrdFile.lastIndexOf(46));
        File f = new File(this._MetaData._wwwPath + rrd + ".htm");
        boolean hasPO = true;
        try {
            String fileName;
            if (os == null) {
                hasPO = false;
                os = new PrintStream(new FileOutputStream(f));
            }
            if (contextName == null) {
                PmDisplay.p(os, "<html><head><title>" + def._title + " Traffic</title>");
            } else {
                PmDisplay.p(os, "<html><head><link rel=\"stylesheet\" href=\"../" + contextName + "/uii/global.css\"><title>" + def._title + " Traffic</title>");
                PmDisplay.p(os, "<script language=\"javascript\" type=\"text/javascript\" src=\"../../../" + contextName + "/js/datetimepicker.js\"></script>");
                PmDisplay.p(os, "<script language=\"javascript\" type=\"text/javascript\" src=\"../../../" + contextName + "/js/pmcombo.js\"></script>");
            }
            PmDisplay.p(os, "<META http-equiv=\"Expires\" content=\"Tue, 20 Aug 2000 14:00:00 GMT\">");
            PmDisplay.p(os, "</head>");
            if (contextName == null) {
                PmDisplay.p(os, "<body topmargin=0 leftmargin=0><font face=Arial>");
                PmDisplay.p(os, "<table border=0 width=100%>");
            } else {
                PmDisplay.p(os, "<body topmargin=0 leftmargin=0 onLoad=\"setCombo();\"><form name=\"comboForm\" method=\"post\" onSubmit=\"return submitForm('" + contextName + "');\">");
                PmDisplay.p(os, "<table border=0 height=\"350\" cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"top\" colspan=\"2\"><table border=0 cellspacing=\"0\" cellpadding=\"2\">");
            }
            PmDisplay.p(os, "<tr><td colspan=\"2\" nowrap background=\"../" + contextName + "/RSRC/en_US/images/vertlines_dk.gif\" ><img src=\"../" + contextName + "/RSRC/en_US/images/shim.gif\" /></td></tr>");
            PmDisplay.p(os, "<tr bgcolor=\"#cecfce\"><td width=\"75%\" colspan=\"1\"><b>");
            if (def._message != null) {
                PmDisplay.p(os, def._message);
            }
            PmDisplay.p(os, " </b></td><td align=right>&nbsp;<a style=\"cursor:pointer;cursor:hand; color:#6666CC;\" onClick=\"javascript:window.open(self.location,'_blank','width=606,height=370,directories=no,location=no,menubar=no,scrollbars=no,status=no,toolbar=no,resizable=yes');\">Clone</a></td></tr>");
            PmDisplay.p(os, "<tr><td colspan=\"2\" nowrap background=\"../" + contextName + "/RSRC/en_US/images/vertlines_dk.gif\" ><img src=\"../" + contextName + "/RSRC/en_US/images/shim.gif\" /></td></tr>");
            PmDisplay.p(os, "<tr>");
            PmDisplay.p(os, "<td align=\"left\" valign=\"middle\" nowrap=\"nowrap\"><span id=\"timediv\" style=\"display:none; padding-right: 5px;\"><INPUT id=\"StartTime\" type=\"text\" name=\"startTime\" size=\"16\" value=\"Start Time\">");
            PmDisplay.p(os, "<a href=\"javascript:NewCal('StartTime', 'ddmmyyyy', true, 24)\"><img src=\"../../../" + contextName + "/dTree/img/cal.gif\" width=\"20\" height=\"16\" border=\"0\" alt=\"Pick a date\" style=\"vertical-align:-22%;\"></a>");
            PmDisplay.p(os, "<INPUT id=\"EndTime\" type=\"text\" name=\"endTime\" size=\"16\" value=\"End Time\">");
            PmDisplay.p(os, "<a href=\"javascript:NewCal('EndTime', 'ddmmyyyy', true, 24)\"><img src=\"../../../" + contextName + "/dTree/img/cal.gif\" width=\"20\" height=\"16\" border=\"0\" alt=\"Pick a date\" style=\"vertical-align:-22%;\"></a>");
            PmDisplay.p(os, "<input type=\"submit\" value=\"Show\"/></span></td>");
            PmDisplay.p(os, "<td align=\"right\" valign=\"middle\" nowrap=\"nowrap\"><span style=\"vertical-align: -45%;\">Last:  <select name=\"charttype\" size=\"1\" onchange=\"changeCombo('" + contextName + "');\">");
            PmDisplay.p(os, "\t<option " + (chartType == 1 ? "selected" : "") + ">24 Hours</option>");
            PmDisplay.p(os, "\t<option " + (chartType == 2 ? "selected" : "") + ">Week</option>");
            PmDisplay.p(os, "\t<option " + (chartType == 3 ? "selected" : "") + ">Month</option>");
            PmDisplay.p(os, "\t<option " + (chartType == 4 ? "selected" : "") + ">Year</option>");
            PmDisplay.p(os, "\t<option " + (chartType == 5 ? "selected" : "") + ">Custom</option></select></span>");
            if (contextName != null) {
                String url = contextName + "pmreport?command=Export&rrd=" + rrdFile + "&type=" + type;
                String img = "../" + contextName + "/RSRC/en_US/images/btn_export32.gif";
                PmDisplay.p(os, "<a href=\"" + url + "\"><img src=\"" + img + "\" alt=\"Export current report to CSV format\" border=\"0\" style=\"vertical-align:middle;\" /></a>");
            }
            PmDisplay.p(os, "</td></tr>");
            PmDisplay.p(os, "<tr>");
            PmDisplay.p(os, "<td colspan=\"2\"><div id=\"otherdiv\" style=\"display:none\"><INPUT id=\"xmlFile\" type=\"text\" name=\"xmlFile\" size=\"16\" value=\"\">");
            PmDisplay.p(os, "<INPUT id=\"rrdFile\" type=\"text\" name=\"rrdFile\" size=\"16\" value=\"" + rrdFile + "\">");
            PmDisplay.p(os, "<INPUT id=\"type\" type=\"text\" name=\"type\" size=\"16\" value=\"" + type + "\"></div></td></tr>");
            PmDisplay.p(os, "<tr><td width=100% colspan=2 bgcolor=#C0C0C0 size=2><b>");
            PmDisplay.p(os, " </b></font></td></tr><tr>");
            String[] defs = null;
            if (def._rrdFile.endsWith("_flow.rrd") || def._errRrdFile == null || !def._hasValidError) {
                defs = new String[]{"_day", "_week", "_month", "_year", "_custom"};
                fileName = PmCollect.getPmDir() + File.separator + "db" + File.separator + PmFileStoreManager.getInstance().getMappedFileName(rrdFile);
                File testFile = new File(fileName);
                if (testFile.exists()) {
                    PmDisplay.p(os, "<td colspan=\"2\"><img border=\"0\" src=\"/pm/www/" + rrd + defs[chartType - 1] + ".png?\"></td>");
                } else {
                    PmDisplay.p(os, "<td colspan=\"2\">" + rrdFile + " not found." + "</td>");
                }
                if (def._errRrdFile != null) {
                    PmDisplay.p(os, "</tr><tr>");
                    PmDisplay.p(os, "<td colspan=\"2\">No Errors or Discards found.</td>");
                }
            } else {
                defs = new String[]{"_day", "_week", "_month", "_year", "_custom", "err_day", "err_week", "err_month", "err_year", "err_custom"};
                fileName = PmCollect.getPmDir() + File.separator + "db" + File.separator + PmFileStoreManager.getInstance().getMappedFileName(rrdFile);
                File testFile = new File(fileName);
                if (testFile.exists()) {
                    PmDisplay.p(os, "<td colspan=\"2\"><img border=\"0\" src=\"/pm/www/" + rrd + defs[chartType - 1] + ".png?\"></td>");
                    PmDisplay.p(os, "</tr><tr>");
                    PmDisplay.p(os, "<td colspan=\"2\"><script type=\"text/javascript\" language=\"javascript\">window.resizeTo(606,550);if(document.all) {offW = document.body.clientWidth; offH = document.body.clientHeight; diffW = 606 - offW; diffH = 550 - offH; window.resizeBy(diffW, diffH); }</script><img border=\"0\" src=\"/pm/www/" + rrd + defs[chartType + 4] + ".png?\"></td>");
                } else {
                    for (int i = 0; i < defs.length / 2 - 1; i += 2) {
                        PmDisplay.p(os, "<td width=50%><img border=\"0\" src=\"" + rrd + defs[i] + ".png?\"></td>");
                        PmDisplay.p(os, "<td width=50%><img border=\"0\" src=\"" + rrd + defs[i + 1] + ".png?\"></td>");
                        PmDisplay.p(os, "</tr><tr>");
                        PmDisplay.p(os, "<td width=50%><img border=\"0\" src=\"" + rrd + defs[i + 5] + ".png?\"></td>");
                        PmDisplay.p(os, "<td width=50%><img border=\"0\" src=\"" + rrd + defs[i + 6] + ".png?\"></td>");
                        PmDisplay.p(os, "</tr><tr>");
                    }
                }
            }
            PmDisplay.p(os, "</tr></table></td></tr><tr height=\"2%\">");
            if (chartType == 1) {
                PmDisplay.p(os, "<td align=\"left\"><font size=\"-2\"><i>Note: Values updated every " + this.getIntervalString(def) + ".</i></font></td>");
            }
            PmDisplay.p(os, "</tr></table></form></body></html>");
            String string = f.getAbsolutePath();
            return string;
        }
        finally {
            if (!hasPO && os != null) {
                os.close();
            }
        }
    }

    public static boolean checkValidError(Source[] srs) {
        if (srs == null) {
            return false;
        }
        for (int i = srs.length - 1; i >= 0; --i) {
            double max = srs[i].getAggregate(0);
            if (Double.isNaN(max) || !(max > 0.0)) continue;
            return true;
        }
        return false;
    }

    private String getIntervalString(PmConfig config) throws RrdException, IOException {
        long steps = PmMetadata.POLL_INTERVAL;
        if (config.getType() == 1) {
            steps = this._MetaData._isl_interval;
        }
        long min = steps / 60L;
        long sec = steps % 60L;
        StringBuffer ret = new StringBuffer(Long.toString(min) + " min ");
        if (sec != 0L) {
            ret.append(Long.toString(sec) + " sec ");
        }
        return ret.toString();
    }

    private Map<String, byte[]> processDef(PmConfig[] defs, long start, long end, int chartType) throws RrdException, IOException {
        return this.processDef(defs, "Single", start, end, chartType, -1.0, -1.0, -1.0, -1.0);
    }

    private Map<String, byte[]> processDef(PmConfig[] defs, String aggrTitle, long start, long end, int chartType, double criticalThresholdValue, double warningThresholdValue, double yLowRng, double yUpRng) throws RrdException, IOException {
        RrdGraph eGraph;
        File f;
        RrdGraph graph;
        RrdGraph eGraph2;
        RrdGraphDef gDef;
        String xTitle;
        HashMap<String, byte[]> graphMap = new HashMap<String, byte[]>();
        ArrayList<String> rrdFile = new ArrayList<String>();
        ArrayList<String> errRrdFile = new ArrayList<String>();
        ArrayList<String> rrdFileLogical = new ArrayList<String>();
        ArrayList<String> errRrdFileLogical = new ArrayList<String>();
        for (int i = 0; i < defs.length; ++i) {
            PmConfig def = defs[i];
            String temprrdFileLogical = this._MetaData._dbPath + def._rrdFile;
            String tempRrdFile = PmFileStoreManager.getInstance().getMappedFileName(temprrdFileLogical);
            if (tempRrdFile == null) {
                throw new RrdException("Can not map logical file" + rrdFileLogical);
            }
            File f2 = new File(tempRrdFile);
            if (!f2.exists()) {
                System.out.println(rrdFile + " not found");
                return graphMap;
            }
            rrdFile.add(tempRrdFile);
            rrdFileLogical.add(temprrdFileLogical);
            File errF = null;
            if (this._MetaData._doErrorDiscard && def._errRrdFile != null) {
                String temperrRrdFileLogical = this._MetaData._dbPath + def._errRrdFile;
                String tempErrRrdFile = PmFileStoreManager.getInstance().getMappedFileName(temperrRrdFileLogical);
                errF = new File(tempErrRrdFile);
                if (!errF.exists()) {
                    System.out.println(errRrdFile + "not found");
                    continue;
                }
                errRrdFile.add(tempErrRrdFile);
                errRrdFileLogical.add(temperrRrdFileLogical);
                continue;
            }
            System.out.println(def._rrdFile + " has no err rrd file");
        }
        String graphFile = this._MetaData._wwwPath + (defs.length == 1 ? defs[0]._rrdFile.substring(0, defs[0]._rrdFile.lastIndexOf(46)) : aggrTitle);
        String title = defs.length == 1 ? defs[0]._title : aggrTitle;
        String yTitle = defs[0]._yTitle;
        String opt = defs[0]._options;
        String errGraphFile = null;
        String errYTitle = null;
        if (errRrdFile.size() > 0) {
            errGraphFile = this._MetaData._wwwPath + defs[0]._errRrdFile.substring(0, defs[0]._errRrdFile.lastIndexOf(46));
            errYTitle = defs[0].getErrYTitle();
        }
        RrdGraphDef errGDef = null;
        if (chartType == 1 || chartType == 0) {
            xTitle = title.startsWith("CPU") ? title + " - Past 24 Hours" : title + " Traffic - Past 24 Hours";
            gDef = this.createGraph(rrdFile, xTitle, yTitle, this._DayStartDate, opt, end - 86400L, end, this.getLabelList(defs), PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (errRrdFile.size() > 0) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past 24 Hours", errYTitle + " / " + this.getIntervalString(defs[0]), this._DayStartDate, opt, end - 86400L, end, this.getErrorLabelList(defs), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
                if (errGDef == null || !PmDisplay.checkValidError(errGDef.getSources())) {
                    defs[0]._hasValidError = false;
                } else {
                    if (yLowRng >= 0.0 && yUpRng > 0.0) {
                        errGDef.setValueRange(yLowRng, yUpRng);
                    }
                    eGraph2 = new RrdGraph(errGDef, null, "");
                    eGraph2.saveAsPNG(graphFile + "err_day.png", 600, 220);
                    graphMap.put(graphFile + "err_day.png", eGraph2.getPNGBytes(600, 220));
                    defs[0]._hasValidError = true;
                }
            }
            if (gDef != null) {
                if (yLowRng >= 0.0 && yUpRng > 0.0) {
                    gDef.setValueRange(yLowRng, yUpRng);
                }
                if (criticalThresholdValue > 0.0) {
                    gDef.rule(criticalThresholdValue, Color.RED, "--Critical");
                }
                if (warningThresholdValue > 0.0 && gDef != null) {
                    gDef.rule(warningThresholdValue, Color.PINK, "--Warning");
                }
            }
            graph = new RrdGraph(gDef, null, "Total Error,Discard/" + this.getIntervalString(defs[0]));
            graph.saveAsPNG(graphFile + "_day.png", 600, 220);
            graphMap.put(graphFile + "_day.png", graph.getPNGBytes(600, 220));
            Source[] sources = gDef.getSources();
            defs[0]._avg = new double[sources.length];
            defs[0]._max = new double[sources.length];
            for (int j = 0; j < sources.length; ++j) {
                defs[0]._avg[j] = sources[j].getAggregate(3);
                defs[0]._both += defs[0]._avg[j];
                defs[0]._max[j] = sources[j].getAggregate(0);
            }
        }
        if (chartType == 2 || chartType == 0) {
            gDef = null;
            errGDef = null;
            xTitle = title.startsWith("CPU") ? title + " - Past Week" : title + " Traffic - Past Week";
            gDef = this.createGraphWithPeak(rrdFile, xTitle, yTitle, this._WeekStartDate, opt, end - 604800L, end, this.getLabelList(defs), this.getPeakLabelList(defs), PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (errRrdFile.size() > 0) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past Week", errYTitle + " / 30 mins", this._WeekStartDate, opt, end - 604800L, end, this.getErrorLabelList(defs), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
                if (errGDef != null && PmDisplay.checkValidError(errGDef.getSources())) {
                    if (yLowRng > 0.0 && yUpRng > 0.0) {
                        errGDef.setValueRange(yLowRng, yUpRng);
                    }
                    eGraph2 = new RrdGraph(errGDef, null, "Total Error,Discard/30 Mins");
                    eGraph2.saveAsPNG(graphFile + "err_week.png", 600, 220);
                    graphMap.put(graphFile + "err_week.png", eGraph2.getPNGBytes(600, 220));
                    defs[0]._hasValidError = true;
                } else {
                    defs[0]._hasValidError = false;
                }
            }
            if (gDef != null) {
                if (yLowRng > 0.0 && yUpRng > 0.0) {
                    gDef.setValueRange(yLowRng, yUpRng);
                }
                if (criticalThresholdValue > 0.0) {
                    gDef.rule(criticalThresholdValue, Color.RED, "--Critical");
                }
                if (warningThresholdValue > 0.0 && gDef != null) {
                    gDef.rule(warningThresholdValue, Color.PINK, "--Warning");
                }
            }
            graph = new RrdGraph(gDef, null, "Total Error,Discard/30 Mins");
            graph.saveAsPNG(graphFile + "_week.png", 600, 220);
            graphMap.put(graphFile + "_week.png", graph.getPNGBytes(600, 220));
        }
        if (chartType == 3 || chartType == 0) {
            gDef = null;
            errGDef = null;
            xTitle = title.startsWith("CPU") ? title + " - Past Month" : title + " Traffic - Past Month";
            gDef = this.createGraphWithPeak(rrdFile, xTitle, yTitle, this._MonthStartDate, opt, end - 2592000L, end, this.getLabelList(defs), this.getPeakLabelList(defs), PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (errRrdFile.size() > 0) {
                f = new File(errGraphFile + "_month.png");
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past Month", errYTitle + " / 2 hours", this._MonthStartDate, opt, end - 2592000L, end, this.getErrorLabelList(defs), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
                if (errGDef != null && PmDisplay.checkValidError(errGDef.getSources())) {
                    if (yLowRng > 0.0 && yUpRng > 0.0) {
                        errGDef.setValueRange(yLowRng, yUpRng);
                    }
                    eGraph = new RrdGraph(errGDef, null, "Total Error,Discard/2 hours");
                    eGraph.saveAsPNG(graphFile + "err_month.png", 600, 220);
                    graphMap.put(graphFile + "err_month.png", eGraph.getPNGBytes(600, 220));
                    defs[0]._hasValidError = true;
                } else {
                    defs[0]._hasValidError = false;
                }
            }
            if (gDef != null) {
                if (yLowRng > 0.0 && yUpRng > 0.0) {
                    gDef.setValueRange(yLowRng, yUpRng);
                }
                if (criticalThresholdValue > 0.0) {
                    gDef.rule(criticalThresholdValue, Color.RED, "--Critical");
                }
                if (warningThresholdValue > 0.0 && gDef != null) {
                    gDef.rule(warningThresholdValue, Color.PINK, "--Warning");
                }
            }
            graph = new RrdGraph(gDef, null, "Total Error,Discard /2 hours");
            graph.saveAsPNG(graphFile + "_month.png", 600, 220);
            graphMap.put(graphFile + "_month.png", graph.getPNGBytes(600, 220));
        }
        if (chartType == 4 || chartType == 0) {
            gDef = null;
            errGDef = null;
            xTitle = title.startsWith("CPU") ? title + " - Past Year" : title + " Traffic - Past Year";
            gDef = this.createGraphWithPeak(rrdFile, xTitle, yTitle, this._YearStartDate, opt, end - 31536000L, end, this.getLabelList(defs), this.getPeakLabelList(defs), PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (errRrdFile.size() > 0) {
                f = new File(errGraphFile + "_year.png");
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past Year", errYTitle + " / day", this._YearStartDate, opt, end - 31536000L, end, this.getErrorLabelList(defs), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
                if (errGDef != null && PmDisplay.checkValidError(errGDef.getSources())) {
                    if (yLowRng > 0.0 && yUpRng > 0.0) {
                        errGDef.setValueRange(yLowRng, yUpRng);
                    }
                    eGraph = new RrdGraph(errGDef, null, "Total Error,Discard/1 day");
                    eGraph.saveAsPNG(graphFile + "err_year.png", 600, 220);
                    graphMap.put(graphFile + "err_year.png", eGraph.getPNGBytes(600, 220));
                    defs[0]._hasValidError = true;
                } else {
                    defs[0]._hasValidError = false;
                }
            }
            if (gDef != null) {
                if (yLowRng > 0.0 && yUpRng > 0.0) {
                    gDef.setValueRange(yLowRng, yUpRng);
                }
                if (criticalThresholdValue > 0.0) {
                    gDef.rule(criticalThresholdValue, Color.RED, "--Critical");
                }
                if (warningThresholdValue > 0.0 && gDef != null) {
                    gDef.rule(warningThresholdValue, Color.PINK, "--Warning");
                }
            }
            graph = new RrdGraph(gDef, null, "Total Error,Discard /1 day");
            graph.saveAsPNG(graphFile + "_year.png", 600, 220);
            graphMap.put(graphFile + "_year.png", graph.getPNGBytes(600, 220));
        }
        if (chartType == 5) {
            gDef = null;
            errGDef = null;
            gDef = this.createGraph(rrdFile, title + " Traffic - " + this._CustomStartDate, yTitle, this._CustomStartDate, opt, start, end, this.getLabelList(defs), PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (errRrdFile.size() > 0) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - " + this._CustomStartDate, errYTitle, this._CustomStartDate, opt, start, end, this.getErrorLabelList(defs), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
                if (errGDef != null && PmDisplay.checkValidError(errGDef.getSources())) {
                    if (yLowRng > 0.0 && yUpRng > 0.0) {
                        errGDef.setValueRange(yLowRng, yUpRng);
                    }
                    RrdGraph eGraph3 = new RrdGraph(errGDef, null, "Total Error,Discard");
                    eGraph3.saveAsPNG(graphFile + "err_custom.png", 600, 220);
                    graphMap.put(graphFile + "err_custom.png", eGraph3.getPNGBytes(600, 220));
                    defs[0]._hasValidError = true;
                } else {
                    defs[0]._hasValidError = false;
                }
            }
            if (gDef != null) {
                if (yLowRng > 0.0 && yUpRng > 0.0) {
                    gDef.setValueRange(yLowRng, yUpRng);
                }
                if (criticalThresholdValue > 0.0) {
                    gDef.rule(criticalThresholdValue, Color.RED, "--Critical");
                }
                if (warningThresholdValue > 0.0 && gDef != null) {
                    gDef.rule(warningThresholdValue, Color.PINK, "--Warning");
                }
            }
            RrdGraph graph2 = new RrdGraph(gDef, null, "Total Error,Discard");
            graph2.saveAsPNG(graphFile + "_custom.png", 600, 220);
            graphMap.put(graphFile + "_custom.png", graph2.getPNGBytes(600, 220));
        }
        return graphMap;
    }

    private List<String[]> getLabelList(PmConfig[] defs) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        if (defs.length == 1) {
            ret.add(defs[0]._labels);
        }
        for (int i = 0; i < defs.length; ++i) {
            String[] labels = new String[defs[i]._labels.length];
            for (int j = 0; j < labels.length; ++j) {
                labels[j] = new String(defs[i]._title + " " + defs[i]._labels[j]);
            }
            ret.add(labels);
        }
        return ret;
    }

    private List<String[]> getPeakLabelList(PmConfig[] defs) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        if (defs.length == 1) {
            ret.add(defs[0]._peakLabels);
        }
        for (int i = 0; i < defs.length; ++i) {
            String[] labels = new String[defs[i]._peakLabels.length];
            for (int j = 0; j < labels.length; ++j) {
                labels[j] = new String(defs[i]._title + " " + defs[i]._peakLabels[j]);
            }
            ret.add(labels);
        }
        return ret;
    }

    private List<String[]> getErrorLabelList(PmConfig[] defs) {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        for (int i = 0; i < defs.length; ++i) {
            ret.add(defs[i].getErrorDiscardLabelStrings());
        }
        return ret;
    }

    public RrdGraphDef[] processSimpleDef(PmConfig def, long start, long end, int chartType, double critalThreshold, double warningThreshold) throws RrdException, IOException {
        String rrdFileLogical = this._MetaData._dbPath + def._rrdFile;
        String rrdFile = PmFileStoreManager.getInstance().getMappedFileName(rrdFileLogical);
        if (rrdFile == null) {
            throw new RrdException("can not map logical file name" + rrdFileLogical);
        }
        File f = new File(rrdFile);
        if (!f.exists()) {
            System.out.println(rrdFile + " not found");
            return null;
        }
        String errRrdFile = null;
        File errF = null;
        String errRrdFileLogical = null;
        if (this._MetaData._doErrorDiscard && def._errRrdFile != null) {
            errRrdFileLogical = this._MetaData._dbPath + def._errRrdFile;
            errRrdFile = PmFileStoreManager.getInstance().getMappedFileName(errRrdFileLogical);
            errF = new File(errRrdFile);
            if (!errF.exists()) {
                System.out.println(errRrdFile + "not found");
            }
        } else {
            System.out.println(def._rrdFile + " has no err rrd file");
        }
        String title = def._title;
        String yTitle = def._yTitle;
        String opt = def._options;
        String errYTitle = null;
        if (errF != null) {
            errYTitle = def.getErrYTitle();
        }
        RrdGraphDef errGDef = null;
        if (chartType == 1) {
            RrdGraphDef gDef = this.createGraph(rrdFile, title + " - Past 24 Hours", yTitle, this._DayStartDate, opt, end - 86400L, end, def._labels, PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (critalThreshold > 0.0 && gDef != null) {
                gDef.rule(critalThreshold, Color.RED, "--Critical");
            }
            if (warningThreshold > 0.0 && gDef != null) {
                gDef.rule(warningThreshold, Color.PINK, "--Warning");
            }
            if (errF != null) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past 24 Hours", errYTitle + " / " + this.getIntervalString(def), this._DayStartDate, opt, end - 86400L, end, def.getErrorDiscardLabelStrings(), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
            }
            RrdGraphDef[] rv = new RrdGraphDef[]{gDef, errGDef};
            return rv;
        }
        if (chartType == 2) {
            errGDef = null;
            RrdGraphDef gDef = this.createGraph(rrdFile, title + " - Past Week", yTitle, this._WeekStartDate, opt, end - 604800L, end, def._labels, PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (critalThreshold > 0.0 && gDef != null) {
                gDef.rule(critalThreshold, Color.RED, "--Critical");
            }
            if (warningThreshold > 0.0 && gDef != null) {
                gDef.rule(warningThreshold, Color.PINK, "--Warning");
            }
            if (errF != null) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past Week", errYTitle + " / 30 mins", this._WeekStartDate, opt, end - 604800L, end, def.getErrorDiscardLabelStrings(), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
            }
            RrdGraphDef[] rv = new RrdGraphDef[]{gDef, errGDef};
            return rv;
        }
        if (chartType == 3) {
            errGDef = null;
            RrdGraphDef gDef = this.createGraph(rrdFile, title + " - Past Month", yTitle, this._MonthStartDate, opt, end - 2592000L, end, def._labels, PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (critalThreshold > 0.0 && gDef != null) {
                gDef.rule(critalThreshold, Color.RED, "--Critial");
            }
            if (warningThreshold > 0.0 && gDef != null) {
                gDef.rule(warningThreshold, Color.PINK, "--Warning");
            }
            if (errF != null) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past Month", errYTitle + " / 2 hours", this._MonthStartDate, opt, end - 2592000L, end, def.getErrorDiscardLabelStrings(), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
            }
            RrdGraphDef[] rv = new RrdGraphDef[]{gDef, errGDef};
            return rv;
        }
        if (chartType == 4) {
            errGDef = null;
            RrdGraphDef gDef = this.createGraph(rrdFile, title + " - Past Year", yTitle, this._YearStartDate, opt, end - 31536000L, end, def._labels, PmFileStoreManager.getInstance().getIndex(rrdFileLogical));
            if (critalThreshold > 0.0 && gDef != null) {
                gDef.rule(critalThreshold, Color.RED, "--Critical");
            }
            if (warningThreshold > 0.0 && gDef != null) {
                gDef.rule(warningThreshold, Color.PINK, "--Warning");
            }
            if (errF != null) {
                errGDef = this.createGraph(errRrdFile, title + " Error/Discard - Past Year", errYTitle + " / day", this._YearStartDate, opt, end - 31536000L, end, def.getErrorDiscardLabelStrings(), PmFileStoreManager.getInstance().getIndex(errRrdFileLogical));
            }
            RrdGraphDef[] rv = new RrdGraphDef[]{gDef, errGDef};
            return rv;
        }
        return null;
    }

    private boolean isValidRrdFile(String rrdFile) {
        File rrdFd = new File(rrdFile);
        if (!rrdFd.exists() || !rrdFd.isFile()) {
            return false;
        }
        return rrdFd.length() >= 100L;
    }

    private RrdGraphDef createGraph(String rrdFile, String title, String yTitle, String xTitle, String options, long start, long end, String[] labels, int dsIndex) throws RrdException, IOException {
        if (!this.isValidRrdFile(rrdFile)) {
            return null;
        }
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setTimePeriod(start, end);
        gDef.setTitle(title);
        if (options != null && options.indexOf("-log") != -1) {
            gDef.setLogarithmic(true);
        }
        gDef.setValueAxisLabel(yTitle);
        gDef.setTimeAxisLabel(xTitle);
        for (int i = 0; i < labels.length; ++i) {
            String dataset = Integer.toString(dsIndex) + "." + Integer.toString(i);
            gDef.datasource(dataset, rrdFile, dataset, "AVERAGE");
            if (rrdFile.endsWith("err.rrd")) {
                gDef.line(dataset, ERR_COLORS[i % ERR_COLORS.length], labels[i]);
                continue;
            }
            gDef.line(dataset, COLORS[i % COLORS.length], labels[i]);
        }
        return gDef;
    }

    private RrdGraphDef createGraph(List<String> rrdFile, String title, String yTitle, String xTitle, String options, long start, long end, List<String[]> labelList, List<Short> dsIndex) throws RrdException, IOException {
        for (String e : rrdFile) {
            if (this.isValidRrdFile(e)) continue;
            return null;
        }
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setTimePeriod(start, end);
        gDef.setTitle(title);
        if (options != null && options.indexOf("-log") != -1) {
            gDef.setLogarithmic(true);
        }
        gDef.setValueAxisLabel(yTitle);
        gDef.setTimeAxisLabel(xTitle);
        for (int j = 0; j < rrdFile.size(); ++j) {
            String[] labels = labelList.get(j);
            for (int i = 0; i < labels.length; ++i) {
                String dataset = Integer.toString(dsIndex.get(j).shortValue()) + "." + Integer.toString(i);
                gDef.datasource(dataset, rrdFile.get(j), dataset, "AVERAGE");
                if (rrdFile.get(j).endsWith("err.rrd")) {
                    gDef.line(dataset, ERR_COLORS[i % ERR_COLORS.length], labels[i]);
                    continue;
                }
                gDef.line(dataset, COLORS[i % COLORS.length], labels[i]);
            }
        }
        return gDef;
    }

    private RrdGraphDef createGraphWithPeak(List<String> rrdFile, String title, String yTitle, String xTitle, String options, long start, long end, List<String[]> labelList, List<String[]> peakLabelList, List<Short> dsIndex) throws RrdException, IOException {
        for (String e : rrdFile) {
            if (this.isValidRrdFile(e)) continue;
            return null;
        }
        RrdGraphDef gDef = new RrdGraphDef();
        gDef.setTimePeriod(start, end);
        gDef.setTitle(title);
        if (options != null && options.indexOf("-log") != -1) {
            gDef.setLogarithmic(true);
        }
        gDef.setValueAxisLabel(yTitle);
        gDef.setTimeAxisLabel(xTitle);
        for (int j = 0; j < rrdFile.size(); ++j) {
            String dataset;
            int i;
            String[] labels = labelList.get(j);
            String[] peakLabels = peakLabelList.get(j);
            for (i = 0; i < labels.length; ++i) {
                dataset = Integer.toString(dsIndex.get(j).shortValue()) + "." + Integer.toString(i);
                gDef.datasource(dataset, rrdFile.get(j), dataset, "AVERAGE");
                gDef.line(dataset, COLORS[i % COLORS.length], labels[i]);
            }
            for (i = 0; i < peakLabels.length; ++i) {
                dataset = Integer.toString(dsIndex.get(j).shortValue()) + "." + Integer.toString(i);
                gDef.datasource(dataset, rrdFile.get(j), dataset, "MAX");
                gDef.line(dataset, PEAK_COLORS[i % PEAK_COLORS.length], peakLabels[i]);
            }
        }
        return gDef;
    }

    private static void p(PrintStream os, String msg) {
        os.println(msg);
    }

    public static void mainx(String[] args) {
        try {
            PM.loadProperties();
            ArrayList<String> files = new ArrayList<String>();
            files.add("200000053000371e_20488192_2000000b4679f180_17305600.rrd");
            files.add("200000053000371e_20484096_2000000b4679f180_17301504.rrd");
            Map<String, byte[]> chartFromServer = new PmDisplay().getPmCharts(files, "Aggregated Name Here", 1, 0L, System.currentTimeMillis() / 1000L, 1, -1.0, -1.0, -1.0, -1.0);
            System.out.println(chartFromServer);
            chartFromServer = new PmDisplay().getPmCharts("200000053000371e_20488192_2000000b4679f180_17305600.rrd", 1, 0L, System.currentTimeMillis() / 1000L, 1, -1.0, -1.0, -1.0, -1.0);
            System.out.println(chartFromServer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            PM.loadProperties();
            Map<String, byte[]> chartFromServer = new PmDisplay().getPmCharts("172.22.31.108_1.3.6.1.4.1.9.9.305.1.1.1.0.rrd", 15, 0L, System.currentTimeMillis() / 1000L, 1, -1.0, -1.0, -1.0, -1.0);
            System.out.println(chartFromServer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

