/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpFcAddressId;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.sm.common.model.PmExtraOidBase;
import com.cisco.dcbu.sm.common.model.PmPolicyBase;
import com.cisco.dcbu.sm.common.model.SwitchBase;
import com.cisco.dcbu.sm.common.pm.PmConfig;
import com.cisco.dcbu.sm.common.pm.PmErrorDiscardConfig;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.licmgr.LicenseManager;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.PmExtraOidImpl;
import com.cisco.dcbu.sm.server.pm.FlowPair;
import com.cisco.dcbu.sm.server.pm.FlowPairKey;
import com.cisco.dcbu.sm.server.pm.FlowPort;
import com.cisco.dcbu.sm.server.pm.PM;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmDoubleFlowData;
import com.cisco.dcbu.sm.server.pm.PmMetadata;
import com.cisco.dcbu.sm.server.pm.SwitchInfo;
import com.cisco.dcbu.sm.server.security.SnmpUserImpl;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

public final class PmMetaDataUtil {
    static final String QueryISLSQLByFabricId = "select vsan.vsan_id, isl.id, isl.port1_id, isl.port2_id, isl.channel_current_child_count from vsan, vsan_isl_info vii, isl where vsan.fabric_id=? and vii.vsan_id=vsan.id and vii.isl_id = isl.id  and (isl.IS_CHANNELMEMBER=FALSE or isl.IS_CHANNELMEMBER is null ) and isl.is_present=true";
    static final String QueryEtherISLSQLByFabricId = "select id, port1_id, port2_id from ethisl where is_present=true and  ((port1_id in  (select sp.id from ethswitch_port sp , ethswitch s, lanswitch_map m  where sp.switch_id = s.id and m.id=s.id and s.is_pm_collect=true and m.lan_id=? ))  or  (port2_id in  (select sp.id from ethswitch_port sp , ethswitch s, lanswitch_map m   where sp.switch_id = s.id and m.id=s.id and s.is_pm_collect=true and m.lan_id=? ))) ";
    static final String QueryEtherPortSQLByFabricId = "select sp.if_name, s.ip_address, sp.if_index, sp.if_speed  from ethswitch s, ethswitch_port sp, lanswitch_map m where m.id=s.id and sp.switch_id = s.id and (sp.id not in (select port1_id from ethisl)) and (sp.id not in (select port2_id from ethisl)) and (sp.if_type=53 or sp.if_type=117 or sp.if_type=6) and s.is_pm_collect=true and m.lan_id=? ";
    static final String QueryNPVSQLByFabricId = "select vsan.vsan_id, npv.id, npv.core_switch_id, npv.f_port_index, npv.np_switch_id, npv.np_port_index, npv.speed from vsan, vsan_npvl_info vnpv, npv_link npv where vsan.fabric_id=? and vnpv.vsan_id=vsan.id and vnpv.npvl_id = npv.id and npv.is_present=true and ( npv.IS_CHANNELMEMBER=FALSE or npv.IS_CHANNELMEMBER is null  ) ";
    static final String QueryEtherISLPortSQLByISLPortId = "select sp1.if_index, sp1.if_speed, s1.sys_name, s1.ip_address, sp1.if_name,  sp2.if_index, sp2.if_speed, s2.sys_name, s2.ip_address, sp2.if_name  from ethswitch s1, ethswitch_port sp1, ethswitch s2, ethswitch_port sp2 where sp1.id=? and sp2.id=? and sp1.switch_id=s1.id and sp2.switch_id=s2.id ";
    static final String QueryISLPortSQLByISLPortId = "select sp1.if_index, sp1.if_speed, s1.sys_name, s1.ip_address, s1.wwn, sp2.if_index, sp2.if_speed, s2.sys_name, s2.ip_address, s2.wwn, s1.is_managable, s2.is_managable, s1.is_mds, s2.is_mds  from switch s1, switch_port sp1, switch s2, switch_port sp2 where sp1.id=? and sp2.id=? and s1.fabric_id=? and s2.fabric_id=? and sp1.switch_id=s1.id and sp2.switch_id=s2.id";
    static final String QueryEndPortSQLByFabricId = "select ep.fc4_features, ep.id, ep.name, ep.wwn, s.ip_address, sp.if_index, sp.if_speed, ep.fc4_types, vsan.vsan_id, s.is_managable, s.is_mds, ep.is_loop, ep.enclosure_id, s.non_mds_model from switch s, switch_port sp, end_port ep, vsan, vsan_endport_info vei where vsan.fabric_id=? and ep.is_present=true and vei.vsan_id=vsan.id and vei.endport_id=ep.id and ep.switch_port_id=sp.id and sp.switch_id = s.id and sp.if_name not like '%internal%' ";
    static final String QueryChannelSQLByChannelId = "select isl.port1_id, isl.port2_id, isl.channel_id from  isl where isl.channel_id= ? ";
    static final String QueryGigePortSQLByFabricId = "select s.wwn, sp.if_name, s.ip_address, sp.if_index, sp.if_speed, s.is_managable, s.is_mds, s.non_mds_model from switch s, switch_port sp where s.fabric_id=?  and sp.switch_id = s.id and (sp.if_type=53 or sp.if_type=117 or sp.if_type=6) ";
    static final String QuerySwitchByFabricId = "select s.ip_address, s.is_managable, s.is_mds, s.wwn from switch s where s.fabric_id=?";
    static final String QuerySwitchBySwitchId = "select s.ip_address, s.is_managable, s.is_mds, s.wwn, s.sys_name from switch s where s.id=?";
    static final String QuerySwitchByIp = "select s.wwn from switch s where s.ip_address=?";
    static final String QueryFabricIdByDbId = "select f.fid, f.name from fabric f where f.id=?";
    static final String QueryFabricsInCollection = "select fabric_id, fabric.name  from pm_collection, fabric where fabric_id = fabric.id";
    static final String QueryFabricInCollection = "select id  from pm_collection where fabric_id = ?";
    static final String QueryFlowPortByVsanFcId = "select ep.wwn, ep.name, ep.fc4_types, ep.fc4_features, s.ip_address from end_port ep, vsan_endport_info vei, vsan, switch_port sp, switch s where vsan.vsan_id=? and vei.fcid=? and vei.vsan_id=vsan.id and vei.endport_id = ep.id and ep.switch_port_id=sp.id and sp.switch_id=s.id ";
    static final String QueryEthSwitchInCollectionById = "select is_pm_collect from ethswitch where id=?";
    static final String QueryLanByDbId = "select lan.lan_id, lan.lan_name from lan where lan.id=?";
    static final String QueryLanByServerId = "select lan.id, lan.lan_id, lan.lan_name from lan, logicsvr_fabric where lan.lan_id=logicsvr_fabric.f_id and logicsvr_fabric.lsvr_id=?";
    static final String[] OTHER_LABELS = new String[]{"Oo"};
    static final String[] LABELS = new String[]{"Rx", "Tx"};
    static final String SEPARATOR = System.getProperty("file.separator");
    static final String YTITLE = "Rx,Tx Bytes/sec";
    static final String[] VARS = new String[]{"1.3.6.1.4.1.9.9.284.1.2.1.1.2", "1.3.6.1.4.1.9.9.284.1.2.1.1.6", "1.3.6.1.4.1.9.9.284.1.2.1.1.3", "1.3.6.1.4.1.9.9.284.1.2.1.1.4", "1.3.6.1.4.1.9.9.284.1.2.1.1.5", "1.3.6.1.4.1.9.9.284.1.2.1.1.9"};
    static final String UNKNOWN = "N/A";

    static String getName(Wwn wwn, String sysName) {
        if (sysName != null && sysName.length() > 0) {
            return sysName;
        }
        WwnDictionary.setEnabled(true);
        return wwn.toString().replaceAll(":", "");
    }

    static String getName(InetAddress ip, String sysName) {
        if (sysName != null && sysName.length() > 0) {
            return sysName;
        }
        return ip.toString().replaceAll("//", "");
    }

    static ArrayList<ArrayList<PmConfig>> findPmConfig(PmMetadata pmeta, long fabricId, String vsanList, PmPolicyBase ppb) throws Exception {
        ArrayList<ArrayList<PmConfig>> result = new ArrayList<ArrayList<PmConfig>>();
        boolean allVsan = false;
        long[] vsans = new long[]{};
        if (vsanList == null || vsanList.equals("")) {
            allVsan = true;
        } else {
            vsans = SnmpLongList.parse(vsanList);
        }
        byte[] vsanbm = new byte[512];
        for (int i = 0; i < vsans.length; ++i) {
            if (vsans[i] == 0L) {
                allVsan = true;
                break;
            }
            SnmpString.setBit(vsanbm, (int)vsans[i]);
        }
        try {
            FabricPK fpk = FabricImpl.findFPKByDbId(fabricId);
            List<SwitchBase> unLicensedSwitches = LicenseManager.getInstance().getAllUnLicensedSwitches(fpk);
            HashMap<InetAddress, InetAddress> unLicensedSwMap = new HashMap<InetAddress, InetAddress>();
            for (SwitchBase sw : unLicensedSwitches) {
                if (sw.getInetAddress() == null) continue;
                unLicensedSwMap.put(sw.getInetAddress(), sw.getInetAddress());
            }
            PmMetaDataUtil.logUnLicensedSwMap(unLicensedSwMap);
            ArrayList isls = ppb.isMonitoringISL() ? PmMetaDataUtil.findLinkPmConfig(fabricId, allVsan, vsanbm, unLicensedSwMap) : new ArrayList();
            ArrayList<ArrayList<PmConfig>> eps = ppb.isMonitoringHost() || ppb.isMonitoringStorage() ? PmMetaDataUtil.findEndPortPmConfig(fabricId, allVsan, vsanbm, unLicensedSwMap) : new ArrayList<ArrayList<PmConfig>>();
            ArrayList flows = ppb.isMonitoringFlow() ? PmMetaDataUtil.findFlowPmConfig(pmeta, fabricId, allVsan, vsanbm, unLicensedSwMap) : new ArrayList();
            ArrayList others = ppb.isMonitoringOther() ? PmMetaDataUtil.findOtherPmConfig(fabricId, allVsan, vsanbm, unLicensedSwMap) : new ArrayList();
            ArrayList giges = ppb.isMonitoringGige() ? PmMetaDataUtil.findGigePortPmConfig(fabricId, allVsan, vsanbm, unLicensedSwMap) : new ArrayList();
            result.add(isls);
            result.add(eps != null && eps.size() != 0 ? eps.get(0) : new ArrayList());
            result.add(eps != null && eps.size() > 1 ? eps.get(1) : new ArrayList());
            result.add(flows);
            result.add(others);
            result.add(giges);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    static void logUnLicensedSwMap(HashMap<InetAddress, InetAddress> unLicensedSwMap) {
        if (unLicensedSwMap == null || unLicensedSwMap.size() == 0) {
            return;
        }
        Iterator<InetAddress> iter = unLicensedSwMap.keySet().iterator();
        PM._Logger.info((Object)"Skip unlicense switches:");
        while (iter.hasNext()) {
            PM._Logger.info((Object)("    " + iter.next().toString()));
        }
    }

    static boolean isTarget(int fc4Features) {
        return (fc4Features & 1) == 1;
    }

    static boolean isInitiator(int fc4Features) {
        return (fc4Features & 2) == 2;
    }

    static boolean isInitiatorOnly(int fc4Features) {
        return PmMetaDataUtil.isInitiator(fc4Features) && !PmMetaDataUtil.isTarget(fc4Features);
    }

    static boolean isFcDevice(int[] fc4Types, Wwn wwn) {
        boolean ret = Fc4Decoder.isFc4TypeSet(fc4Types, 8);
        return ret;
    }

    static boolean isISCSI(int[] fc4Types) {
        return Fc4Decoder.isFc4TypeSet(fc4Types, 225);
    }

    static boolean isFV(int fc4Features) {
        return PmMetaDataUtil.isFc4FeatureSet(fc4Features, 1024) || PmMetaDataUtil.isFc4FeatureSet(fc4Features, 512);
    }

    static boolean isFiconCup(int fc4Features) {
        return (fc4Features & 4) == 4;
    }

    static boolean isSVC(int fc4Features) {
        return PmMetaDataUtil.isFc4FeatureSet(fc4Features, 128);
    }

    static boolean isFc4FeatureSet(int fc4Features, int flagmask) {
        return (fc4Features & flagmask) == flagmask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEthSwitchInCollection(long ethSwitchId) {
        boolean isCollectPm = false;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QueryEthSwitchInCollectionById);
            stat.setLong(1, ethSwitchId);
            rs = stat.executeQuery();
            while (rs.next()) {
                isCollectPm = rs.getBoolean(1);
            }
        }
        catch (Exception ex) {
            try {
                PM._Logger.error((Object)("PM isEthSwitchInCollection error: " + ex.getMessage()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return isCollectPm;
    }

    static PmConfig getNpvPmConfig(long fabricId, long swId, int ifIndex, long npswId, int npifIndex, long speed, HashMap<InetAddress, InetAddress> unLicensedSwMap, int vsan) throws Exception {
        SwitchInfo coresw = PmMetaDataUtil.findSwitchBySwitchId(swId);
        SwitchInfo npsw = PmMetaDataUtil.findNPVSwitchBySwitchId(npswId);
        if (coresw == null || npsw == null) {
            PM._Logger.warn((Object)("NPV core switch:" + swId + "(DBID) or np switch " + npswId + "(DBID) is null"));
            return null;
        }
        if (!coresw._isManagable || !coresw._isMDS) {
            PM._Logger.debug((Object)("NPV core switch " + swId + " is non managed MDS"));
            return null;
        }
        if (unLicensedSwMap.get(coresw._ip) != null && unLicensedSwMap.get(npsw._ip) != null) {
            PM._Logger.debug((Object)("skip collection on NPV Link, NPV core switch " + swId + " and NPV device " + npswId + " are not licensed. "));
            return null;
        }
        WwnDictionary.setEnabled(false);
        WwnDictionary.setPrepend(false);
        String rrd = coresw._wwn.toString().replaceAll(":", "") + "_" + ifIndex + "_" + npsw._wwn.toString().replaceAll(":", "") + "_" + npifIndex + ".rrd";
        PmConfig pc = new PmConfig(rrd, coresw._ip.getHostAddress(), coresw._wwn + " " + IfIndexUtil.ifIndexToName(ifIndex) + " - " + npsw._wwn + " " + IfIndexUtil.ifIndexToName(npifIndex) + " Traffic", YTITLE, new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, LABELS, String.valueOf(speed), 0, 8);
        String msgStr = "NPV Link:" + coresw._name + " " + IfIndexUtil.ifIndexToName(ifIndex) + " - " + npsw._name + " " + IfIndexUtil.ifIndexToName(npifIndex) + ", Port: " + IfIndexUtil.ifIndexToName(ifIndex) + ", VSAN: " + vsan + ", %s>=%d%%, Speed:" + DisplayUtil.formatSpeed(speed);
        pc.setMsgString(msgStr);
        pc.setIfname(IfIndexUtil.ifIndexToName(ifIndex));
        pc.setEntity(coresw._name + " " + IfIndexUtil.ifIndexToName(ifIndex) + " - " + npsw._name + " " + IfIndexUtil.ifIndexToName(npifIndex));
        PM._Logger.debug((Object)("found npvLink " + coresw._wwn + " " + IfIndexUtil.ifIndexToName(ifIndex) + " - " + npsw._wwn + " " + IfIndexUtil.ifIndexToName(npifIndex)));
        if (PmCollect._CollectErrorDiscard) {
            PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
            pc.addErrorDiscardConfig(edconf);
            edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
            pc.addErrorDiscardConfig(edconf);
        }
        return pc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PmConfig getISLPmConfig(long fabricId, long sp1Id, long sp2Id, boolean isChannel, HashMap<InetAddress, InetAddress> unLicensedSwMap, int vsan) throws Exception {
        ResultSet rs;
        PreparedStatement pstmt_s;
        Connection conn;
        block14: {
            boolean s1_managedMds;
            Wwn swwn2;
            InetAddress ip2;
            String sname2;
            int ifIndex2;
            Wwn swwn1;
            InetAddress ip1;
            String sname1;
            long speed1;
            int ifIndex1;
            block17: {
                block16: {
                    block15: {
                        boolean s2_managedMds;
                        conn = ConnectionManager.getConnection();
                        pstmt_s = null;
                        rs = null;
                        pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryISLPortSQLByISLPortId));
                        pstmt_s.setLong(1, sp1Id);
                        pstmt_s.setLong(2, sp2Id);
                        pstmt_s.setLong(3, fabricId);
                        pstmt_s.setLong(4, fabricId);
                        rs = pstmt_s.executeQuery();
                        if (!rs.next()) break block14;
                        ifIndex1 = rs.getInt(1);
                        speed1 = rs.getLong(2);
                        sname1 = rs.getString(3);
                        byte[] ipAddr1 = rs.getBytes(4);
                        ip1 = null;
                        if (ipAddr1 == null || ipAddr1.length == 0) {
                            PM._Logger.debug((Object)("ISL " + sp1Id + " ip address is null"));
                        } else {
                            ip1 = InetAddress.getByAddress(ipAddr1);
                        }
                        swwn1 = new Wwn(rs.getBytes(5));
                        ifIndex2 = rs.getInt(6);
                        sname2 = rs.getString(8);
                        byte[] ipAddr2 = rs.getBytes(9);
                        ip2 = null;
                        if (ipAddr2 == null || ipAddr2.length == 0) {
                            PM._Logger.debug((Object)("ISL " + sp1Id + " ip address is null"));
                        } else {
                            ip2 = InetAddress.getByAddress(ipAddr2);
                        }
                        swwn2 = new Wwn(rs.getBytes(10));
                        s1_managedMds = rs.getBoolean(11) && rs.getBoolean(13);
                        boolean bl = s2_managedMds = rs.getBoolean(12) && rs.getBoolean(14);
                        if (s1_managedMds || s2_managedMds) break block15;
                        PM._Logger.debug((Object)("ISL " + sp1Id + ":" + sp2Id + " :both end is non managed MDS"));
                        PmConfig pmConfig = null;
                        DbUtil.close(rs);
                        DbUtil.close(pstmt_s);
                        DbUtil.close(conn);
                        return pmConfig;
                    }
                    if (ip2 != null || ip1 != null) break block16;
                    PM._Logger.debug((Object)("ISL " + sp1Id + ":" + sp2Id + " :both end ip addres is null"));
                    PmConfig pmConfig = null;
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    return pmConfig;
                }
                if (unLicensedSwMap.get(ip1) == null || unLicensedSwMap.get(ip2) == null) break block17;
                PM._Logger.debug((Object)("Skip ISL " + sp1Id + ":" + sp2Id + " :both are not licensed"));
                PmConfig pmConfig = null;
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                return pmConfig;
            }
            int ifIndex = s1_managedMds ? ifIndex1 : ifIndex2;
            WwnDictionary.setEnabled(false);
            WwnDictionary.setPrepend(false);
            String rrd = swwn1.toString().replaceAll(":", "") + "_" + ifIndex1 + "_" + swwn2.toString().replaceAll(":", "") + "_" + ifIndex2 + ".rrd";
            String switchIpToUse = s1_managedMds ? ip1.getHostAddress() : ip2.getHostAddress();
            PmConfig pc = new PmConfig(rrd, switchIpToUse, PmMetaDataUtil.getName(swwn1, sname1) + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + PmMetaDataUtil.getName(swwn2, sname2) + " " + IfIndexUtil.ifIndexToName(ifIndex2) + " Traffic", YTITLE, new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, LABELS, String.valueOf(speed1), 0, isChannel ? 9 : 1);
            String msgStr = "ISL:" + sname1 + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + sname2 + " " + IfIndexUtil.ifIndexToName(ifIndex2) + ", Port:" + IfIndexUtil.ifIndexToName(ifIndex1) + ", %s>=%d%%, Speed:" + DisplayUtil.formatSpeed(speed1);
            pc.setMsgString(msgStr);
            pc.setIfname(IfIndexUtil.ifIndexToName(ifIndex1));
            pc.setEntity(sname1 + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + sname2 + " " + IfIndexUtil.ifIndexToName(ifIndex2));
            PM._Logger.debug((Object)("found isl " + PmMetaDataUtil.getName(swwn1, sname1) + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + PmMetaDataUtil.getName(swwn2, sname2) + " " + IfIndexUtil.ifIndexToName(ifIndex2)));
            if (PmCollect._CollectErrorDiscard) {
                PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
                pc.addErrorDiscardConfig(edconf);
                edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
                pc.addErrorDiscardConfig(edconf);
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            PmConfig pmConfig = pc;
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return pmConfig;
        }
        try {
            try {
                throw new Exception("ISL with port " + sp1Id + " -- port " + sp2Id + " not found in database.");
            }
            catch (Exception ex) {
                PM._Logger.error((Object)("PM find ISL PmConfig error: " + ex.getMessage()), (Throwable)ex);
                PmConfig pmConfig = null;
                return pmConfig;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static PmConfig getEtherISLPmConfig(long sp1Id, long sp2Id, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        block10: {
            block14: {
                block13: {
                    block12: {
                        block15: {
                            block11: {
                                conn = ConnectionManager.getConnection();
                                pstmt_s = null;
                                rs = null;
                                pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString("select sp1.if_index, sp1.if_speed, s1.sys_name, s1.ip_address, sp1.if_name,  sp2.if_index, sp2.if_speed, s2.sys_name, s2.ip_address, sp2.if_name  from ethswitch s1, ethswitch_port sp1, ethswitch s2, ethswitch_port sp2 where sp1.id=? and sp2.id=? and sp1.switch_id=s1.id and sp2.switch_id=s2.id "));
                                pstmt_s.setLong(1, sp1Id);
                                pstmt_s.setLong(2, sp2Id);
                                rs = pstmt_s.executeQuery();
                                if (!rs.next()) break block10;
                                ifIndex1 = rs.getInt(1);
                                speed1 = rs.getLong(2);
                                sname1 = rs.getString(3);
                                ipAddr1 = rs.getBytes(4);
                                ifName1 = rs.getString(5);
                                ip1 = null;
                                ifIndex2 = rs.getInt(6);
                                speed2 = rs.getLong(7);
                                sname2 = rs.getString(8);
                                ipAddr2 = rs.getBytes(9);
                                ifName2 = rs.getString(10);
                                ip2 = null;
                                if (ipAddr1 != null && ipAddr1.length != 0) break block11;
                                PM._Logger.debug((Object)("ISL " + sp1Id + " ip address is null"));
                                var23_19 = null;
                                DbUtil.close(rs);
                                DbUtil.close(pstmt_s);
                                DbUtil.close(conn);
                                return var23_19;
                            }
                            ip1 = InetAddress.getByAddress(ipAddr1);
                            if (ipAddr2 != null && ipAddr2.length != 0) break block12;
                            PM._Logger.debug((Object)(sname1 + ":" + sname2));
                            PM._Logger.debug((Object)("found: " + ifName1 + " - " + ifName2));
                            if (!ifName2.startsWith("up")) break block15;
                            ip2 = InetAddress.getByAddress(ipAddr1);
                            ** GOTO lbl47
                        }
                        var23_20 = null;
                        DbUtil.close(rs);
                        DbUtil.close(pstmt_s);
                        DbUtil.close(conn);
                        return var23_20;
                    }
                    ip2 = InetAddress.getByAddress(ipAddr2);
lbl47:
                    // 2 sources

                    if (ip1 != null) break block13;
                    PM._Logger.debug((Object)("ISL " + sp1Id + ":" + sp2Id + " :both end ip addres is null"));
                    var23_21 = null;
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    return var23_21;
                }
                if (unLicensedSwMap.get(ip1) == null || unLicensedSwMap.get(ip2) == null) break block14;
                PM._Logger.info((Object)("Skip EthISL " + sp1Id + ":" + sp2Id + " :both are not licensed"));
                var23_22 = null;
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                return var23_22;
            }
            ifIndex = ifIndex1;
            rrd = ip1.getHostAddress().replace(".", "X") + "_" + ifIndex1 + "_" + ip2.getHostAddress().replace(".", "X") + "_" + ifIndex2 + ".rrd";
            switchIpToUse = ip1.getHostAddress();
            pc = new PmConfig(rrd, switchIpToUse, PmMetaDataUtil.getName(ip1, sname1) + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + PmMetaDataUtil.getName(ip2, sname2) + " " + IfIndexUtil.ifIndexToName(ifIndex2) + " Traffic", "Rx,Tx Bytes/sec", new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, PmMetaDataUtil.LABELS, String.valueOf(speed1), 0, 10);
            PM._Logger.debug((Object)("found isl " + PmMetaDataUtil.getName(ip1, sname1) + " " + IfIndexUtil.ifIndexToName(ifIndex1) + " - " + PmMetaDataUtil.getName(ip2, sname2) + " " + IfIndexUtil.ifIndexToName(ifIndex2)));
            if (PmCollect._MetaData._collectLanError) {
                edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
                pc.addErrorDiscardConfig(edconf);
                edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
                pc.addErrorDiscardConfig(edconf);
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            var26_28 = pc;
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return var26_28;
        }
        try {
            try {
                throw new Exception("ISL with port " + sp1Id + " -- port " + sp2Id + " not found in database.");
            }
            catch (Exception ex) {
                PM._Logger.error((Object)("PM find ISL PmConfig error: " + ex.getMessage()), (Throwable)ex);
                var9_7 = null;
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                return var9_7;
            }
        }
        catch (Throwable var27_29) {
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            throw var27_29;
        }
    }

    static ArrayList<PmConfig> findLinkPmConfig(long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<PmConfig> list2;
        ArrayList<PmConfig> list = PmMetaDataUtil.findISLPmConfig(fabricId, allVsan, vsans, unLicensedSwMap);
        if (list != null && (list2 = PmMetaDataUtil.findNpvLinkPmConfig(fabricId, allVsan, vsans, unLicensedSwMap)) != null) {
            list.addAll(list2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<PmConfig> findNpvLinkPmConfig(long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<PmConfig> arrayList;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        ArrayList<PmConfig> result = new ArrayList<PmConfig>();
        ResultSet rs = null;
        try {
            pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryNPVSQLByFabricId));
            pstmt_s.setLong(1, fabricId);
            rs = pstmt_s.executeQuery();
            HashSet isls = new HashSet();
            while (rs.next()) {
                int vsan = rs.getInt("vsan_id");
                if (!allVsan && !SnmpString.getBit(vsans, vsan)) continue;
                long coreSwitchId = rs.getLong(3);
                int coreIfindex = rs.getInt(4);
                long npSwitchId = rs.getLong(5);
                int npIfindex = rs.getInt(6);
                long speed = rs.getLong(7);
                try {
                    PmConfig pc = PmMetaDataUtil.getNpvPmConfig(fabricId, coreSwitchId, coreIfindex, npSwitchId, npIfindex, speed, unLicensedSwMap, vsan);
                    if (pc == null) continue;
                    result.add(pc);
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("find isl port error " + ex.getMessage()));
                }
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            arrayList = result;
        }
        catch (Exception ex) {
            ArrayList<PmConfig> arrayList2;
            try {
                PM._Logger.error((Object)("PM find ISL PmConfig error: " + ex.getMessage()));
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<PmConfig> findISLPmConfig(long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<PmConfig> arrayList;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        ArrayList<PmConfig> result = new ArrayList<PmConfig>();
        ResultSet rs = null;
        HashMap<Long, Integer> channelList = new HashMap<Long, Integer>();
        try {
            pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryISLSQLByFabricId));
            pstmt_s.setLong(1, fabricId);
            rs = pstmt_s.executeQuery();
            HashSet<Long> isls = new HashSet<Long>();
            while (rs.next()) {
                long islId;
                int vsan = rs.getInt("vsan_id");
                if (!allVsan && !SnmpString.getBit(vsans, vsan) || isls.contains(new Long(islId = rs.getLong(2)))) continue;
                isls.add(islId);
                long sp1Id = rs.getLong(3);
                long sp2Id = rs.getLong(4);
                long childCount = rs.getLong(5);
                if (childCount != 0L) {
                    channelList.put(islId, vsan);
                }
                try {
                    PmConfig pc = PmMetaDataUtil.getISLPmConfig(fabricId, sp1Id, sp2Id, false, unLicensedSwMap, vsan);
                    if (pc == null) continue;
                    result.add(pc);
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("find isl port error " + ex.getMessage()));
                }
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            Iterator i$ = channelList.keySet().iterator();
            while (i$.hasNext()) {
                long l = (Long)i$.next();
                List<PmConfig> confList = PmMetaDataUtil.getChannelPmConfig(fabricId, l, unLicensedSwMap, (Integer)channelList.get(l));
                if (confList == null || confList.size() < 0) continue;
                result.addAll(confList);
            }
            arrayList = result;
        }
        catch (Exception ex) {
            ArrayList<PmConfig> arrayList2;
            try {
                PM._Logger.error((Object)("PM find ISL PmConfig error: " + ex.getMessage()));
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<PmConfig> findEthISLPmConfig(long lanDBId, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<PmConfig> arrayList;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        ArrayList<PmConfig> result = new ArrayList<PmConfig>();
        ResultSet rs = null;
        ArrayList channelList = new ArrayList();
        try {
            pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryEtherISLSQLByFabricId));
            pstmt_s.setLong(1, lanDBId);
            pstmt_s.setLong(2, lanDBId);
            rs = pstmt_s.executeQuery();
            HashSet<Long> isls = new HashSet<Long>();
            while (rs.next()) {
                long islId = rs.getLong(1);
                if (isls.contains(new Long(islId))) continue;
                isls.add(islId);
                long sp1Id = rs.getLong(2);
                long sp2Id = rs.getLong(3);
                try {
                    PmConfig pc = PmMetaDataUtil.getEtherISLPmConfig(sp1Id, sp2Id, unLicensedSwMap);
                    if (pc == null) {
                        pc = PmMetaDataUtil.getEtherISLPmConfig(sp2Id, sp1Id, unLicensedSwMap);
                    }
                    if (pc == null) continue;
                    result.add(pc);
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("find ethisl port error " + ex.getMessage()));
                }
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            arrayList = result;
        }
        catch (Exception ex) {
            ArrayList<PmConfig> arrayList2;
            try {
                PM._Logger.error((Object)("PM find EthISL PmConfig error: " + ex.getMessage()));
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<PmConfig> getChannelPmConfig(long fabricId, long channelId, HashMap<InetAddress, InetAddress> unLicensedSwMap, int vsan) throws Exception {
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        ArrayList<PmConfig> result = new ArrayList<PmConfig>();
        ResultSet rs = null;
        ArrayList channelList = new ArrayList();
        PmConfig conf = null;
        try {
            pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryChannelSQLByChannelId));
            pstmt_s.setLong(1, channelId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                long sp1Id = rs.getLong(1);
                long sp2Id = rs.getLong(2);
                try {
                    conf = PmMetaDataUtil.getISLPmConfig(fabricId, sp1Id, sp2Id, true, unLicensedSwMap, vsan);
                    if (conf == null) continue;
                    result.add(conf);
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("find isl port error " + ex.getMessage()));
                }
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
        }
        catch (Exception ex) {
            List<PmConfig> list;
            try {
                PM._Logger.error((Object)("PM find ISL PmConfig error: " + ex.getMessage()));
                list = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return list;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return result;
    }

    static ArrayList<PmConfig> findOtherPmConfig(long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<PmConfig> ret = new ArrayList<PmConfig>();
        try {
            List list = PmMetaDataUtil.getExtraOid(fabricId);
            if (list == null) {
                return ret;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                PmExtraOidBase oid = ((PmExtraOidImpl)iter.next()).getBase();
                InetAddress ip = InetAddress.getByName(oid.getSwitchIp());
                if (unLicensedSwMap.get(ip) != null) {
                    PM._Logger.debug((Object)("skip " + oid.getDisplayName() + " for unlicensed sw:" + ip));
                    continue;
                }
                Wwn wwn = PmMetaDataUtil.findSwitcheByIp(ip);
                if (wwn == null || oid.getName() == null) continue;
                String oidString = oid.getName().toString();
                oidString = oidString.replace('.', '-');
                String wwnString = SnmpString.toHexString(wwn.getValue(), 0, wwn.getValue().length);
                PmConfig pc = new PmConfig(wwnString.replaceAll(":", "") + "_" + oidString + ".rrd", ip.getHostAddress(), oid.getDisplayName() + " " + oid.getSwitchName(), YTITLE, new String[]{oid.getName()}, OTHER_LABELS, "0", 0, 5);
                if (pc != null) {
                    pc.setRrdDsType(oid.getType());
                }
                ret.add(pc);
            }
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PM._Logger.error((Object)("PM find Other PmConfig error: " + ex.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<ArrayList<PmConfig>> findEndPortPmConfig(long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<ArrayList<PmConfig>> vsan2;
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        ArrayList<ArrayList<PmConfig>> result = new ArrayList<ArrayList<PmConfig>>();
        ArrayList<PmConfig> hosts = new ArrayList<PmConfig>();
        ArrayList<PmConfig> targets = new ArrayList<PmConfig>();
        result.add(hosts);
        result.add(targets);
        int num_fv = 0;
        int num_svc = 0;
        int num_loop = 0;
        int numFiconCup = 0;
        int num_nonMan = 0;
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryEndPortSQLByFabricId));
            pstmt_s.setLong(1, fabricId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                int vsan2 = rs.getInt("vsan_id");
                if (!allVsan && !SnmpString.getBit(vsans, vsan2)) continue;
                int fc4Features = rs.getInt(1);
                String name = rs.getString(3);
                Wwn wwn = new Wwn(rs.getBytes(4));
                byte[] ipAddr = rs.getBytes(5);
                if (ipAddr == null || ipAddr.length == 0) continue;
                InetAddress ip = InetAddress.getByAddress(ipAddr);
                int ifIndex = rs.getInt(6);
                long speed = rs.getLong(7);
                byte[] byteValue = rs.getBytes(8);
                if (byteValue == null) {
                    byteValue = new byte[]{};
                }
                boolean is_managableMds = rs.getBoolean(10) && rs.getBoolean(11);
                boolean is_loop = rs.getBoolean(12);
                long encId = rs.getLong(13);
                String model = rs.getString(14);
                String string = model = model == null ? "" : model;
                if (is_loop && !PmCollect._CollectLoopDevice) {
                    ++num_loop;
                    continue;
                }
                if (!is_managableMds) {
                    ++num_nonMan;
                    continue;
                }
                if (PmMetaDataUtil.isFV(fc4Features)) {
                    ++num_fv;
                    continue;
                }
                if (PmMetaDataUtil.isSVC(fc4Features)) {
                    ++num_svc;
                    continue;
                }
                if (PmMetaDataUtil.isFiconCup(fc4Features)) {
                    ++numFiconCup;
                    continue;
                }
                if (unLicensedSwMap.get(ip) != null && !model.startsWith("UCS")) {
                    PM._Logger.info((Object)("skip end port " + name + " on unlicensed " + model + " sw:" + ip));
                    continue;
                }
                boolean isTarget = PmMetaDataUtil.isTarget(fc4Features);
                boolean isInitiator = PmMetaDataUtil.isInitiatorOnly(fc4Features);
                PM._Logger.debug((Object)("found end port " + name));
                WwnDictionary.setEnabled(false);
                PmConfig pc = new PmConfig(wwn.toString().replaceAll(":", "") + ".rrd", ip.getHostAddress(), name, YTITLE, new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, LABELS, String.valueOf(speed), 0, isTarget ? 4 : 3);
                String nameStr = name;
                if (name == null) {
                    nameStr = wwn.toString().replaceAll(":", "");
                }
                String msgStr = (isTarget ? "Storage:" : "Host:") + nameStr + ", Port: " + IfIndexUtil.ifIndexToName(ifIndex) + ", VSAN: " + vsan2 + ", %s>=%d%%, Speed:" + DisplayUtil.formatSpeed(speed);
                pc.setMsgString(msgStr);
                pc.setEntity(nameStr);
                pc.setIncId(encId);
                pc.setIfname(IfIndexUtil.ifIndexToName(ifIndex));
                if (PmCollect._CollectErrorDiscard) {
                    PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
                    pc.addErrorDiscardConfig(edconf);
                    edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
                    pc.addErrorDiscardConfig(edconf);
                }
                if (isTarget) {
                    targets.add(pc);
                    continue;
                }
                if (!isInitiator) continue;
                hosts.add(pc);
            }
            if (num_nonMan > 0) {
                PM._Logger.info((Object)("\tIgnoring " + num_nonMan + " non managed/mds ports."));
            }
            if (num_loop > 0) {
                PM._Logger.info((Object)("\tIgnoring " + num_loop + " loop ports."));
            }
            if (num_fv > 0) {
                PM._Logger.info((Object)("\tIgnoring " + num_fv + " virtual ports."));
            }
            if (num_svc > 0) {
                PM._Logger.info((Object)("\tIgnoring " + num_svc + " volume ports."));
            }
            if (numFiconCup > 0) {
                PM._Logger.info((Object)("\tIgnoring " + numFiconCup + " Ficon CUP ports."));
            }
            vsan2 = result;
        }
        catch (Exception ex) {
            ArrayList<ArrayList<PmConfig>> arrayList;
            try {
                PM._Logger.error((Object)("PM find EndPort PmConfig error: " + ex.getMessage()));
                arrayList = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return vsan2;
    }

    static ArrayList<PmConfig> findEthSwitchPmConfig(long fabricId, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        ArrayList<PmConfig> ret = new ArrayList<PmConfig>();
        try {
            List list = PmMetaDataUtil.getExtraOid(fabricId);
            if (list == null) {
                return ret;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                PmExtraOidBase oid = ((PmExtraOidImpl)iter.next()).getBase();
                InetAddress ip = InetAddress.getByName(oid.getSwitchIp());
                String ipStr = ip.getHostAddress();
                if (unLicensedSwMap.get(ip) != null) {
                    PM._Logger.info((Object)("skip EthSwitchPmconfig PmExtraOid: " + oid + " on unlicensed sw:" + ip));
                    continue;
                }
                long switchId = oid.getSwitchId();
                boolean isPmCollected = PmMetaDataUtil.isEthSwitchInCollection(switchId);
                if (!isPmCollected) continue;
                PmConfig pc = new PmConfig(ipStr.replaceAll("/.", "-") + "_" + oid.getName() + ".rrd", ip.getHostAddress(), oid.getDisplayName() + " " + oid.getSwitchName(), YTITLE, new String[]{oid.getName()}, OTHER_LABELS, "0", 0, 15);
                if (pc != null) {
                    pc.setRrdDsType(oid.getType());
                }
                ret.add(pc);
            }
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            PM._Logger.error((Object)("PM find EtherSwitch PmConfig error: " + ex.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<PmConfig> findEthIntfPmConfig(long lanDBId, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        Object name;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        ArrayList<PmConfig> giges = new ArrayList<PmConfig>();
        ResultSet rs = null;
        try {
            pstmt_s = conn.prepareStatement(PersistentHelper.getHelper().getQueryString(QueryEtherPortSQLByFabricId));
            pstmt_s.setLong(1, lanDBId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                name = rs.getString(1);
                byte[] ipAddr = rs.getBytes(2);
                if (ipAddr == null || ipAddr.length == 0) continue;
                InetAddress ip = InetAddress.getByAddress(ipAddr);
                if (unLicensedSwMap.get(ip) != null) {
                    PM._Logger.info((Object)("skip EthIntf " + (String)name + " on unlicensed sw:" + ip));
                    continue;
                }
                int ifIndex = rs.getInt(3);
                long speed = rs.getLong(4);
                PM._Logger.debug((Object)("found eth port " + ip.toString() + " " + (String)name));
                String rrd = ip.getHostAddress().replace(".", "X") + "_" + ifIndex + "_" + "ethintf" + ".rrd";
                PM._Logger.debug((Object)("rrd file for eth port " + ip + " " + (String)name + " is: " + rrd));
                PmConfig pc = new PmConfig(rrd, ip.getHostAddress(), (String)name, YTITLE, new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, LABELS, String.valueOf(speed), 0, 11);
                if (PmCollect._MetaData._collectLanError) {
                    PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
                    pc.addErrorDiscardConfig(edconf);
                    edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
                    pc.addErrorDiscardConfig(edconf);
                }
                giges.add(pc);
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            name = giges;
        }
        catch (Exception ex) {
            ArrayList<PmConfig> arrayList;
            try {
                PM._Logger.error((Object)("PM find EtherPort PmConfig error: " + ex.getMessage()));
                arrayList = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<PmConfig> findGigePortPmConfig(long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        Serializable wwn;
        Connection conn = ConnectionManager.getConnection();
        PreparedStatement pstmt_s = null;
        ArrayList<PmConfig> giges = new ArrayList<PmConfig>();
        ResultSet rs = null;
        try {
            pstmt_s = conn.prepareStatement(QueryGigePortSQLByFabricId);
            pstmt_s.setLong(1, fabricId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                boolean is_managableMds;
                wwn = new Wwn(rs.getBytes(1));
                String name = rs.getString(2);
                byte[] ipAddr = rs.getBytes(3);
                if (ipAddr == null || ipAddr.length == 0) continue;
                InetAddress ip = InetAddress.getByAddress(ipAddr);
                String model = rs.getString(8);
                String string = model = model == null ? "" : model;
                if (unLicensedSwMap.get(ip) != null && !model.startsWith("UCS")) {
                    PM._Logger.info((Object)("skip GigE " + name + " on unlicensed " + model + " sw:" + ip));
                    continue;
                }
                int ifIndex = rs.getInt(4);
                long speed = rs.getLong(5);
                boolean bl = is_managableMds = rs.getBoolean(7) && rs.getBoolean(6);
                if (!is_managableMds) continue;
                PM._Logger.debug((Object)("found gige/non-IPS eth port " + name));
                WwnDictionary.setEnabled(false);
                PmConfig pc = new PmConfig(((Wwn)wwn).toString().replaceAll(":", "") + "_" + ifIndex + "_gige.rrd", ip.getHostAddress(), name, YTITLE, new String[]{"1.3.6.1.2.1.31.1.1.1.6." + ifIndex, "1.3.6.1.2.1.31.1.1.1.10." + ifIndex}, LABELS, String.valueOf(speed), 0, 6);
                if (PmCollect._CollectErrorDiscard) {
                    PmErrorDiscardConfig edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.13." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.19." + ifIndex}, new String[]{"Discard"});
                    pc.addErrorDiscardConfig(edconf);
                    edconf = new PmErrorDiscardConfig("Total Counts", new String[]{"1.3.6.1.2.1.2.2.1.14." + ifIndex + "+" + "1.3.6.1.2.1.2.2.1.20." + ifIndex}, new String[]{"Error"});
                    pc.addErrorDiscardConfig(edconf);
                }
                giges.add(pc);
            }
            rs.close();
            rs = null;
            pstmt_s.close();
            pstmt_s = null;
            wwn = giges;
        }
        catch (Exception ex) {
            ArrayList<PmConfig> arrayList;
            try {
                PM._Logger.error((Object)("PM find GigePort PmConfig error: " + ex.getMessage()));
                arrayList = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return arrayList;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return wwn;
    }

    static ArrayList<PmConfig> findFlowPmConfig(PmMetadata pmeta, long fabricId, boolean allVsan, byte[] vsans, HashMap<InetAddress, InetAddress> unLicensedSwMap) throws Exception {
        HashMap<FlowPairKey, FlowPair> flowsByKey = new HashMap<FlowPairKey, FlowPair>();
        ArrayList<PmConfig> result = new ArrayList<PmConfig>();
        SwitchInfo[] sw = PmMetaDataUtil.findSwitches(fabricId);
        if (sw != null && sw.length > 0) {
            for (int i = 0; i < sw.length; ++i) {
                if (unLicensedSwMap.get(sw[i]._ip) != null) {
                    PM._Logger.debug((Object)("skip flow inquiry for sw:  " + sw[i]._ip));
                    continue;
                }
                try {
                    VarBindList vbl = new VarBindList();
                    for (int k = 0; k < VARS.length; ++k) {
                        vbl.add(new SnmpVarBind(new SnmpOID(VARS[k])));
                    }
                    SnmpPDU pdu = SnmpFetch.getBulk(sw[i]._peer, vbl);
                    VarBindList resp = pdu.getVariables();
                    for (int j = 0; j < resp.size(); j += VARS.length) {
                        byte[] mask;
                        if (resp.byteValue(j)[0] != -32 || (mask = resp.byteValue(j + 1)).length != 3 || (mask[2] & 0xFF) != 255) continue;
                        int vId = resp.intValue(j + 2);
                        if (!allVsan && !SnmpString.getBit(vsans, vId)) continue;
                        byte[] destId = resp.byteValue(j + 3);
                        int did = ((destId[0] & 0xFF) << 16) + ((destId[1] & 0xFF) << 8) + (destId[2] & 0xFF);
                        FlowPort destPort = PmMetaDataUtil.findFlowPort(vId, did);
                        byte[] srcId = resp.byteValue(j + 4);
                        int sid = ((srcId[0] & 0xFF) << 16) + ((srcId[1] & 0xFF) << 8) + (srcId[2] & 0xFF);
                        FlowPort srcPort = PmMetaDataUtil.findFlowPort(vId, sid);
                        if (srcPort == null || destPort == null) {
                            PM._Logger.debug((Object)("Unknown flow fcid: Vsan " + vId + ", " + SnmpFcAddressId.toHexString(srcId) + " - " + SnmpFcAddressId.toHexString(destId)));
                            continue;
                        }
                        FlowPairKey key = new FlowPairKey(vId, srcPort, destPort);
                        PM._Logger.debug((Object)(sw[i]._peer.getAddress().getHostAddress() + " found flow pair " + srcPort.toString() + " -- " + destPort.toString()));
                        FlowPair flow = (FlowPair)flowsByKey.get(key);
                        if (flow == null) {
                            flow = new FlowPair(key);
                            flowsByKey.put(key, flow);
                        } else {
                            PM._Logger.debug((Object)("find match in flowkeyhash:" + key));
                        }
                        String varName = resp.getVb(j).getOid().toString().replaceFirst("1.3.6.1.4.1.9.9.284.1.2.1.1.2", "1.3.6.1.4.1.9.9.284.1.2.1.1.9");
                        flow.addVar(sw[i]._peer, varName, destPort);
                    }
                    continue;
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        for (FlowPair f : flowsByKey.values()) {
            PmConfig pc;
            String[] varsStr;
            ArrayList<String> vars;
            int dataSet = 0;
            boolean doubleFlow = false;
            String rrdFile = PmMetaDataUtil.getRrdFile(f._key._src._wwn.getValue(), "") + "_" + PmMetaDataUtil.getRrdFile(f._key._dst._wwn.getValue(), "") + "_flow.rrd";
            String title = f._key._src._name + " - " + f._key._dst._name;
            PmDoubleFlowData pd = new PmDoubleFlowData();
            if (f._txPeer == null && f._rxPeer == null) {
                PM._Logger.debug((Object)("both peer are null, skip " + f));
                continue;
            }
            doubleFlow = f._txPeer != null && f._rxPeer != null;
            if (f._txPeer != null) {
                if (!doubleFlow) {
                    PM._Logger.debug((Object)("find one single flow " + f));
                } else {
                    PM._Logger.debug((Object)("find one double flow " + f));
                }
                vars = f.getDestVars();
                varsStr = vars.toArray(new String[vars.size()]);
                pc = new PmConfig(rrdFile, f._txPeer.getAddress().getHostAddress(), title, YTITLE, varsStr, new String[]{"Tx"}, null, dataSet++, f._rxPeer != null, 2);
                if (f._rxPeer != null && doubleFlow) {
                    pmeta._flowHash.put(pc, pd);
                }
                result.add(pc);
            }
            if (f._rxPeer == null) continue;
            if (!doubleFlow) {
                PM._Logger.debug((Object)("find one single flow " + f));
            }
            vars = f.getSrcVars();
            varsStr = vars.toArray(new String[vars.size()]);
            pc = new PmConfig(rrdFile, f._rxPeer.getAddress().getHostAddress(), title, YTITLE, varsStr, new String[]{"Rx"}, null, dataSet++, f._txPeer != null, 2);
            if (f._txPeer != null && doubleFlow) {
                pmeta._flowHash.put(pc, pd);
            }
            result.add(pc);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static SwitchInfo findSwitchBySwitchId(long switchId) throws Exception {
        ResultSet rs;
        SwitchInfo result;
        PreparedStatement pstmt_s;
        Connection conn;
        block10: {
            conn = null;
            pstmt_s = null;
            result = null;
            HashMap<InetAddress, SnmpPeer> inetPeer = new HashMap<InetAddress, SnmpPeer>();
            rs = null;
            try {
                byte[] ipAddr;
                SwitchInfo si;
                block11: {
                    conn = ConnectionManager.getConnection();
                    pstmt_s = conn.prepareStatement(QuerySwitchBySwitchId);
                    pstmt_s.setLong(1, switchId);
                    rs = pstmt_s.executeQuery();
                    if (!rs.next()) break block10;
                    si = new SwitchInfo();
                    ipAddr = rs.getBytes(1);
                    if (ipAddr != null && ipAddr.length != 0) break block11;
                    SwitchInfo switchInfo = null;
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    return switchInfo;
                }
                try {
                    InetAddress ip = InetAddress.getByAddress(ipAddr);
                    si._isManagable = rs.getBoolean(2);
                    si._isMDS = rs.getBoolean(3);
                    si._ip = ip;
                    si._wwn = new Wwn(rs.getBytes(4));
                    si._name = rs.getString(5);
                    if (!si._isManagable || !si._isMDS || ip == null) break block10;
                    SnmpPeer peer = (SnmpPeer)inetPeer.get(ip);
                    if (peer == null) {
                        peer = PmMetaDataUtil.findPeer(ip);
                    }
                    if (peer != null) {
                        si._peer = peer;
                        result = si;
                        inetPeer.put(ip, peer);
                    }
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("PmMetaDataUtil find switch error: " + ex.getMessage()), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                try {
                    PM._Logger.error((Object)("PmMetaDataUtil find switch sql error: " + ex.getMessage()), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                return result;
            }
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SwitchInfo findNPVSwitchBySwitchId(long switchId) throws Exception {
        ResultSet rs;
        SwitchInfo result;
        PreparedStatement pstmt_s;
        Connection conn;
        block12: {
            conn = null;
            pstmt_s = null;
            result = null;
            HashMap<InetAddress, SnmpPeer> inetPeer = new HashMap<InetAddress, SnmpPeer>();
            rs = null;
            try {
                conn = ConnectionManager.getConnection();
                pstmt_s = conn.prepareStatement(QuerySwitchBySwitchId);
                pstmt_s.setLong(1, switchId);
                rs = pstmt_s.executeQuery();
                if (!rs.next()) break block12;
                try {
                    SwitchInfo si = new SwitchInfo();
                    byte[] ipAddr = rs.getBytes(1);
                    InetAddress ip = null;
                    if (ipAddr != null) {
                        ip = InetAddress.getByAddress(ipAddr);
                    }
                    si._isManagable = rs.getBoolean(2);
                    si._isMDS = rs.getBoolean(3);
                    si._ip = ip;
                    si._wwn = new Wwn(rs.getBytes(4));
                    si._name = rs.getString(5);
                    if (ip != null) {
                        SnmpPeer peer = (SnmpPeer)inetPeer.get(ip);
                        if (peer == null) {
                            try {
                                peer = PmMetaDataUtil.findPeer(ip);
                            }
                            catch (Exception e) {
                                PM._Logger.error((Object)("PmMetaDataUtil findPeer error: " + e.getMessage()), (Throwable)e);
                            }
                        }
                        if (peer != null) {
                            si._peer = peer;
                            inetPeer.put(ip, peer);
                        }
                    }
                    result = si;
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("PmMetaDataUtil find switch error: " + ex.getMessage()), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                try {
                    PM._Logger.error((Object)("PmMetaDataUtil find switch sql error: " + ex.getMessage()), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SwitchInfo[] findSwitches(long fabricId) throws Exception {
        Connection conn = null;
        PreparedStatement pstmt_s = null;
        ArrayList<SwitchInfo> result = new ArrayList<SwitchInfo>();
        HashMap<InetAddress, SnmpPeer> inetPeer = new HashMap<InetAddress, SnmpPeer>();
        ResultSet rs = null;
        try {
            conn = ConnectionManager.getConnection();
            pstmt_s = conn.prepareStatement(QuerySwitchByFabricId);
            pstmt_s.setLong(1, fabricId);
            rs = pstmt_s.executeQuery();
            while (rs.next()) {
                try {
                    SwitchInfo si = new SwitchInfo();
                    byte[] ipAddr = rs.getBytes(1);
                    if (ipAddr == null || ipAddr.length == 0) continue;
                    InetAddress ip = InetAddress.getByAddress(ipAddr);
                    si._isManagable = rs.getBoolean(2);
                    si._isMDS = rs.getBoolean(3);
                    si._ip = ip;
                    si._wwn = new Wwn(rs.getBytes(4));
                    if (!si._isManagable || !si._isMDS || ip == null) continue;
                    SnmpPeer peer = (SnmpPeer)inetPeer.get(ip);
                    if (peer == null) {
                        peer = PmMetaDataUtil.findPeer(ip);
                    }
                    if (peer == null) continue;
                    si._peer = peer;
                    result.add(si);
                    inetPeer.put(ip, peer);
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("PmMetaDataUtil find switch error: " + ex.getMessage()), (Throwable)ex);
                }
            }
        }
        catch (Exception ex) {
            try {
                PM._Logger.error((Object)("PmMetaDataUtil find switch sql error: " + ex.getMessage()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return result.toArray(new SwitchInfo[result.size()]);
    }

    public static int findFabricIdByDbId(long id) throws Exception {
        FabricPK pk = PmMetaDataUtil.findFabricPKByDbId(id);
        if (pk == null) {
            return -1;
        }
        return pk._fid;
    }

    /*
     * Exception decompiling
     */
    public static LanPK findLanPKByServerId() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static LanPK findLanPKByDbId(long id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static FabricPK findFabricPKByDbId(long id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FabricPK> findFabricPKsInCollection() throws Exception {
        ResultSet rs;
        ArrayList<FabricPK> fpkList;
        PreparedStatement pstmt_s;
        Connection conn;
        block6: {
            conn = null;
            pstmt_s = null;
            fpkList = new ArrayList<FabricPK>();
            rs = null;
            try {
                conn = ConnectionManager.getConnection();
                pstmt_s = conn.prepareStatement(QueryFabricsInCollection);
                rs = pstmt_s.executeQuery();
                if (!rs.next()) break block6;
                try {
                    int fid = rs.getInt(1);
                    String name = rs.getString(2);
                    FabricPK fpk = new FabricPK(fid);
                    fpk.setName(name);
                    fpkList.add(fpk);
                }
                catch (Exception ex) {
                    PM._Logger.error((Object)("PmMetaDataUtil find fabric in collection error: " + ex.getMessage()));
                }
            }
            catch (Exception ex) {
                try {
                    PM._Logger.error((Object)("PmMetaDataUtil find fabric in collection sql error: " + ex.getMessage()), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return fpkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFabricInPmCollection(long fabricDbId) throws Exception {
        ResultSet rs;
        PreparedStatement pstmt_s;
        Connection conn;
        block4: {
            boolean bl;
            conn = null;
            pstmt_s = null;
            rs = null;
            try {
                conn = ConnectionManager.getConnection();
                pstmt_s = conn.prepareStatement(QueryFabricInCollection);
                pstmt_s.setLong(1, fabricDbId);
                rs = pstmt_s.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (Exception ex) {
                try {
                    PM._Logger.error((Object)("PmMetaDataUtil find fabric in pm collection sql error: " + ex.getMessage()), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(pstmt_s);
                    DbUtil.close(conn);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(pstmt_s);
                DbUtil.close(conn);
            }
            DbUtil.close(rs);
            DbUtil.close(pstmt_s);
            DbUtil.close(conn);
            return bl;
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt_s);
        DbUtil.close(conn);
        return false;
    }

    /*
     * Exception decompiling
     */
    static Wwn findSwitcheByIp(InetAddress ip) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static SnmpPeer findPeer(InetAddress ip) throws Exception {
        SnmpUser user = null;
        user = SnmpUserImpl.loadFromDB(ip);
        SnmpPeer peer = null;
        if (user == null) {
            return null;
        }
        if (user instanceof UsmUser) {
            UsmUser usmUser = (UsmUser)user;
            peer = PmCollect.getPeer(ip.getHostAddress(), SnmpSession.getInstance(), usmUser.getUserName(), usmUser.getAuthPassword(), usmUser.getAuthProtocol(), usmUser.getPrivacyPassword(), usmUser.getPrivacyProtocol(), true);
        } else {
            CommunityUser commUser = (CommunityUser)user;
            peer = PmCollect.getPeer(ip.getHostAddress(), SnmpSession.getInstance(), commUser.getCommunity(), null, 0, null, 0, false);
        }
        return peer;
    }

    static List getExtraOid(long fabricId) {
        List<Object> list = new ArrayList();
        try {
            list = PmExtraOidImpl.findAllByFid(fabricId);
        }
        catch (SQLException ex) {
            PM._Logger.error((Object)("Error during retrieving PmExtraPod. Error " + ex.getMessage()), (Throwable)ex);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    static FlowPort findFlowPort(int vId, int fcId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String formatData(double avgRx) {
        return !Double.isNaN(avgRx) ? DefaultSnmpNumberRenderer.formatLong((long)avgRx) + "b" : UNKNOWN;
    }

    String formatSpeed(long speed) {
        String s;
        if (speed > 1000000000L) {
            double sd = (double)speed / 1.0E9;
            s = sd + "G";
        } else if (speed > 1000000L) {
            double sd = (double)speed / 1000000.0;
            s = sd + "M";
        } else {
            s = String.valueOf(speed);
        }
        return s;
    }

    private static String getRrdFile(byte[] b, String suffix) {
        StringBuffer rrdFile = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int n = b[i] & 0xFF;
            rrdFile.append(SnmpString.HEX_DIGIT[n >> 4 & 0xF]);
            rrdFile.append(SnmpString.HEX_DIGIT[n & 0xF]);
        }
        rrdFile.append(suffix);
        return rrdFile.toString();
    }

    static ArrayList<Datasource> getDataSource() throws IOException, RrdException {
        String filePath = PmCollect.getPmDir() + SEPARATOR + "db";
        File pmDir = new File(filePath);
        if (!pmDir.exists() || !pmDir.isDirectory()) {
            System.out.println("Can not find Performance database directory in " + filePath);
            throw new IOException("Can not find Performance database directory in " + filePath);
        }
        File[] files = pmDir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        System.out.println("There are " + files.length + " rrd files needed to be extracted.");
        ArrayList<Datasource> dataSources = new ArrayList<Datasource>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().endsWith(".rrd")) continue;
            RrdDb db = new RrdDb(files[i].getPath());
            for (int j = 0; j < db.getDatasources().length; ++j) {
                dataSources.add(db.getDatasources()[j]);
            }
            db.close();
        }
        return dataSources;
    }
}

