/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.pm;

import com.cisco.dcbu.lib.serviceconf.ServiceConfig;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.StringUtil;
import com.cisco.dcbu.sm.common.event.LogEvent;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.model.PmPolicyBase;
import com.cisco.dcbu.sm.common.pm.PmEventDef;
import com.cisco.dcbu.sm.common.pm.PmStatsUpdate;
import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.ServerRefFactory;
import com.cisco.dcbu.sm.server.event.EventLoggerService;
import com.cisco.dcbu.sm.server.facade.PMImpl;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.model.GlobalFabricManager;
import com.cisco.dcbu.sm.server.pm.PMEventConsumerImpl;
import com.cisco.dcbu.sm.server.pm.PMStatistics;
import com.cisco.dcbu.sm.server.pm.PMStatisticsManager;
import com.cisco.dcbu.sm.server.pm.PduPair;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.pm.PmDoubleFlowData;
import com.cisco.dcbu.sm.server.pm.PmMetaDataUtil;
import com.cisco.dcbu.sm.server.pm.PmMetadata;
import com.cisco.dcbu.sm.server.pm.Query;
import com.cisco.dcbu.sm.server.pm.SysUpTimeStamp;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdTimeOutOfSeqException;
import org.jrobin.core.RrdUpdateClosedFileException;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;

class PmStore
implements Runnable {
    static int _errCounter_index = 2;
    static PMRif _pmRif = null;
    LinkedList<byte[]> _ll = null;
    HashMap<byte[], List<PduPair>> _pdus = null;
    PmCollect _collector;
    boolean _stop = false;
    boolean _externalFlush = false;
    PmStatsUpdate _updater = null;
    EventLoggerService eventService = (EventLoggerService)ServiceConfig.findService("Event Logger Service");
    static Logger _storeLogger = Logger.getLogger((String)"PM.store");

    PmStore(PmCollect collector) throws SnmpException, IOException, RrdException, UnknownHostException, Exception {
        String updater;
        PmEventDef ped = new PmEventDef(PmMetadata._PmPolicys.toArray(new PmPolicyBase[PmMetadata._PmPolicys.size()]));
        PMEventConsumerImpl pec = PMEventConsumerImpl.getInstance();
        if (_pmRif == null) {
            _pmRif = EjbRegistry.getInstance().getPM();
        }
        if (_pmRif != null) {
            PMImpl.getInstance().registerPmEvent(ped, pec);
        }
        this._collector = collector;
        if (this._ll == null) {
            this._ll = new LinkedList();
        }
        if (this._pdus == null) {
            this._pdus = new HashMap();
        }
        if ((updater = System.getProperty("pm.statsUpdate")) != null && !updater.trim().isEmpty()) {
            Class<?> cls = Class.forName(updater.trim());
            this._updater = (PmStatsUpdate)cls.newInstance();
            this._externalFlush = true;
        }
        new Thread((Runnable)this, "PmStore").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._stop = true;
        LinkedList<byte[]> linkedList = this._ll;
        synchronized (linkedList) {
            this._ll.notifyAll();
        }
    }

    static boolean bindEventMgr() {
        try {
            if (_pmRif == null) {
                _pmRif = ServerRefFactory.getInstance().getPM();
                PmEventDef ped = new PmEventDef(PmMetadata._PmPolicys.toArray(new PmPolicyBase[PmMetadata._PmPolicys.size()]));
                PMEventConsumerImpl pec = PMEventConsumerImpl.getInstance();
                _pmRif.registerPmEvent(ped, pec);
            }
            _storeLogger.info((Object)"successfully bind to FMS");
            return true;
        }
        catch (Exception ex) {
            _storeLogger.warn((Object)("PM look up event manager error: " + ex.getMessage()));
            _pmRif = null;
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enQueue(SnmpPDU pdu, PmCollect collector) {
        byte[] addr = pdu.getAddress().getAddress();
        LinkedList<byte[]> linkedList = this._ll;
        synchronized (linkedList) {
            List<PduPair> al;
            if (!this._ll.contains(addr)) {
                this._ll.add(addr);
            }
            if ((al = this._pdus.get(addr)) == null) {
                al = new ArrayList<PduPair>();
                this._pdus.put(addr, al);
            }
            al.add(new PduPair(pdu, collector));
            this._ll.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        _storeLogger.info((Object)("PmStore " + this + " starting: \n"));
        while (!this._stop) {
            try {
                List<Object> pdus;
                while (this._ll.size() > 0) {
                    pdus = null;
                    LinkedList<byte[]> linkedList = this._ll;
                    synchronized (linkedList) {
                        pdus = this._pdus.remove(this._ll.remove(0));
                    }
                    if (PmCollect._IsShuttingDown || this._stop) {
                        _storeLogger.info((Object)("PmStore " + this + " Shutting down: " + this._ll.size() + " left in Q\n"));
                        return;
                    }
                    if (pdus == null) continue;
                    this.store(pdus);
                }
                pdus = this._ll;
                synchronized (pdus) {
                    this._ll.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        _storeLogger.info((Object)("PmStore " + this + " Shutting down: \n"));
    }

    public void store(List<PduPair> pduHs) {
        if (pduHs == null || pduHs.size() == 0) {
            return;
        }
        for (PduPair pair : pduHs) {
            if (this._stop) {
                _storeLogger.info((Object)"Collection stopped, skip storing");
                break;
            }
            try {
                this.store(pair);
            }
            catch (RrdUpdateClosedFileException rrdEx) {
                _storeLogger.warn((Object)rrdEx.getMessage());
                return;
            }
        }
    }

    public void store(PduPair pduHs) throws RrdUpdateClosedFileException {
        List<Query> l;
        InetAddress addr = pduHs.getPdu().getAddress();
        SnmpPeer peer = pduHs.getPdu().getPeer();
        if (peer == null) {
            _storeLogger.warn((Object)("PmStore:store - " + addr.getHostAddress() + ": peer is null"));
        }
        if ((l = PmCollect._QueryByIp.get(addr)) == null) {
            _storeLogger.warn((Object)("Could not find list for addr:" + addr + " in PmStore"));
            return;
        }
        SnmpPDU pdu = pduHs.getPdu();
        long now = pdu.getTimeReceived() / 1000L;
        PmCollect collector = pduHs.getCollect();
        _storeLogger.debug((Object)("pdu " + pdu + " time is " + now));
        VarBindList vbl = pdu.getVariables();
        int vblNo = 0;
        for (int i = 0; i < l.size(); ++i) {
            try {
                Sample errSample;
                Sample sample;
                PmDoubleFlowData pd;
                boolean isOther;
                boolean updateDoubleFlow;
                boolean isDoubleFlow;
                short relativeErrRrdIndex;
                short relativeRrdIndex;
                RrdDb errDb;
                RrdDb db;
                int startVblNo;
                Query q;
                block48: {
                    block49: {
                        if (vblNo >= vbl.size()) break;
                        q = l.get(i);
                        if (!q._vars[0].getOid().equals(vbl.getVb(vblNo).getOid())) continue;
                        startVblNo = vblNo;
                        db = q.getDB();
                        errDb = q.getErrDB();
                        relativeRrdIndex = q.getIndex();
                        relativeErrRrdIndex = q.getErrIndex();
                        _storeLogger.debug((Object)("\t" + new Date().toString() + " storing into rrd " + q._def._rrdFile));
                        isDoubleFlow = false;
                        updateDoubleFlow = false;
                        isOther = false;
                        pd = null;
                        if (q._def._isDoubleFlow) {
                            pd = collector._flowHash.get(q._def);
                            isDoubleFlow = true;
                            _storeLogger.debug((Object)("\nfound double flow " + q._def._rrdFile));
                            if (pd != null) {
                                if (!pd._skip && pd._hasData) {
                                    updateDoubleFlow = true;
                                    _storeLogger.debug((Object)("\t ready to update double flow " + q._def._rrdFile));
                                } else if (pd._skip) {
                                    _storeLogger.debug((Object)("\t Flow already marked as skip " + q._def._rrdFile));
                                } else {
                                    _storeLogger.debug((Object)("\t Flow only need to update data " + q._def._rrdFile));
                                }
                            }
                        } else if (q._def.getType() == 5 || q._def.getType() == 15) {
                            isOther = true;
                        }
                        sample = isDoubleFlow ? (updateDoubleFlow ? db.createSample(now) : null) : db.createSample(now);
                        errSample = null;
                        if (errDb == null) break block48;
                        if (PmCollect._MetaData._doErrorDiscard) break block49;
                        if (!PmCollect._MetaData._collectLanError) break block48;
                    }
                    if (q._num2add.length > _errCounter_index && !isDoubleFlow) {
                        errSample = errDb.createSample(now);
                    }
                }
                double[] currentValues = new double[q._num2add.length];
                for (int j = 0; j < q._num2add.length; ++j) {
                    int dsIndex;
                    if (vbl.getVb(vblNo).getVar().getType() == 5) {
                        _storeLogger.debug((Object)("Ignoring " + vbl.getVb(vblNo).getOid() + " for " + q._def.getVars().get(j)));
                        vblNo += q._num2add[j];
                        continue;
                    }
                    long tempLongValue = vbl.longValue(vblNo++);
                    double newValue = tempLongValue;
                    if (tempLongValue == Long.MAX_VALUE) {
                        newValue = Double.NaN;
                    }
                    for (int k = 1; k < q._num2add[j]; ++k) {
                        newValue = (tempLongValue = vbl.longValue(vblNo++)) == Long.MAX_VALUE ? Double.NaN : (newValue += (double)tempLongValue);
                        if (vblNo >= vbl.size()) break;
                    }
                    int datasetNo = j + q._def._flowDataSet;
                    _storeLogger.debug((Object)("\tCollect " + newValue + " for " + q._def._rrdFile));
                    if (j < _errCounter_index) {
                        int flowIndex;
                        if (sample != null) {
                            if (!isDoubleFlow) {
                                _storeLogger.debug((Object)("\t\t update data.for non double flow " + q._def._rrdFile));
                                int dsIdx = datasetNo + q.getRrdStoreIndex(relativeRrdIndex);
                                if (dsIdx > -1) {
                                    sample.setValue(dsIdx, newValue);
                                }
                            } else if (updateDoubleFlow) {
                                pd._data[datasetNo] = newValue;
                                currentValues = new double[2];
                                for (flowIndex = 0; flowIndex < 2; ++flowIndex) {
                                    _storeLogger.debug((Object)("\t\t update data rrd for double flow " + q._def._rrdFile + " " + flowIndex + " -- " + pd._data[flowIndex]));
                                    int dsIdx = flowIndex + q.getRrdStoreIndex(relativeRrdIndex);
                                    if (dsIdx > -1) {
                                        sample.setValue(dsIdx, pd._data[flowIndex]);
                                    }
                                    currentValues[flowIndex] = pd._data[flowIndex];
                                }
                            }
                        } else if (isDoubleFlow) {
                            _storeLogger.debug((Object)("\t\t only store data.for flow " + q._def._rrdFile + " " + datasetNo + " -- " + newValue));
                            if (pd != null && pd._data != null) {
                                pd._data[datasetNo] = newValue;
                                if (pd._hasData) {
                                    sample = db.createSample(now);
                                    currentValues = new double[2];
                                    for (flowIndex = 0; flowIndex < 2; ++flowIndex) {
                                        _storeLogger.debug((Object)("\t\t update data rrd for double flow " + q._def._rrdFile + " " + flowIndex + " -- " + pd._data[flowIndex]));
                                        sample.setValue(flowIndex + q.getRrdStoreIndex(relativeRrdIndex), pd._data[flowIndex]);
                                        currentValues[flowIndex] = pd._data[flowIndex];
                                    }
                                    updateDoubleFlow = true;
                                }
                                pd._hasData = true;
                            }
                        }
                    } else if (errSample != null && (dsIndex = datasetNo - _errCounter_index + q.getErrRrdStoreIndex(relativeErrRrdIndex)) > -1) {
                        errSample.setValue(dsIndex, newValue);
                    }
                    if (updateDoubleFlow) continue;
                    currentValues[j] = newValue;
                }
                if (PmCollect._MetaData._doInterpolation && !isOther && (!isDoubleFlow || updateDoubleFlow) && vbl.getVb(startVblNo) != null) {
                    this.checkInterpolation(db, peer, vbl.getVb(startVblNo).getOid().getIndexFromEnd(0), now, currentValues, PmCollect.getPollIntervalByQuery(q), q);
                }
                if (sample != null) {
                    if (sample.getValueSetIdxList().size() == 0) {
                        _storeLogger.debug((Object)("There is no data source in sample." + db.getRrdFile().getFilePath()));
                    } else {
                        this.updateSample(sample, q);
                    }
                }
                if (errSample != null) {
                    if (errSample.getValueSetIdxList().size() == 0) {
                        _storeLogger.debug((Object)("There is no data source in errsample." + errDb.getRrdFile().getFilePath()));
                    } else {
                        errSample.update();
                    }
                }
                this.checkThreshold(peer, q, db, isDoubleFlow, updateDoubleFlow, isOther);
            }
            catch (RrdTimeOutOfSeqException ex) {
                _storeLogger.debug((Object)ex);
            }
            catch (NullPointerException ex) {
                if (PmCollect._IsShuttingDown || this._stop) {
                    _storeLogger.warn((Object)"PM is shutting down, ignore the rrd updates!");
                    throw new RrdUpdateClosedFileException("Try to update a closed rrd file!");
                }
                _storeLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                _storeLogger.warn((Object)(peer.getAddress().getHostAddress() + " error: "), (Throwable)ex);
            }
            _storeLogger.debug((Object)(addr.getHostAddress() + " is done"));
        }
    }

    private void updateSample(Sample sample, Query q) throws IOException, RrdException {
        sample.update();
        if (this._externalFlush) {
            double tx = sample.getValues()[sample.getValueSetIdxList().get(0)];
            double rx = Double.NaN;
            if (sample.getValueSetIdxList().size() > 1) {
                rx = sample.getValues()[sample.getValueSetIdxList().get(1)];
            }
            double txput = Double.NaN;
            double rxput = Double.NaN;
            if (q._def._type == 1) {
                if (tx != Double.NaN && q._tx != Double.NaN && tx > q._tx) {
                    txput = (tx - q._tx) / (double)PmCollect._MetaData._isl_interval;
                }
                if (rx != Double.NaN && q._rx != Double.NaN && rx > q._rx) {
                    rxput = (rx - q._rx) / (double)PmCollect._MetaData._isl_interval;
                }
                this._updater.updateEPortStats(q._def._ipAddr, q._def.getIfname(), q._def.getEntity(), PmCollect._MetaData._isl_interval, txput, rxput);
            } else if (q._def._type == 4 || q._def._type == 3) {
                if (tx != Double.NaN && q._tx != Double.NaN && tx > q._tx) {
                    txput = (tx - q._tx) / (double)PmMetadata.POLL_INTERVAL;
                }
                if (rx != Double.NaN && q._rx != Double.NaN && rx > q._rx) {
                    rxput = (rx - q._rx) / (double)PmMetadata.POLL_INTERVAL;
                }
                this._updater.updateFPortStats(q._def._ipAddr, q._def.getIfname(), q._def.getEntity(), PmMetadata.POLL_INTERVAL, txput, rxput);
            }
            q._tx = tx;
            q._rx = rx;
        }
    }

    private void checkThreshold(SnmpPeer peer, Query q, RrdDb db, boolean isDoubleFlow, boolean updateDoubleFlow, boolean isOther) {
        block5: {
            if (PmCollect._MetaData._thresholdISLOnly && q._def._type != 1 && q._def._type != 10) {
                return;
            }
            if (PmCollect._MetaData._thresholdDef != null) {
                if (!(!PmCollect._MetaData._thresholdDef._checkThreshold || isOther || isDoubleFlow && !updateDoubleFlow || q._def._title.startsWith("Vlan"))) {
                    try {
                        this.checkThreshold(q._def._rrdFile, db, q._def._maxValuePerSec, q._def._title, PmCollect.getPollIntervalByQuery(q), q.getIndex(), q._def.getMsgString(), peer.getAddress());
                    }
                    catch (Exception ex) {
                        _storeLogger.warn((Object)(peer.getAddress().getHostAddress() + " check threshold exception: " + ex));
                        if (!SnmpSession.isTrace()) break block5;
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public double getLastValue(RrdDb db, int dsIndex) throws IOException {
        Datasource[] dss = db.getDatasources();
        return dss[dsIndex].getLastValue();
    }

    void sendEvent(String fileName, int severity, String origin, String descr, InetAddress ipaddr) throws Exception {
        String[] v = StringUtil.tokenize(fileName.substring(0, fileName.indexOf(".rrd")), "_");
        List<PMStatistics> pslist = PMStatistics.findPMStatistics(v);
        if (pslist == null || pslist.size() == 0) {
            return;
        }
        boolean isLan = false;
        for (PMStatistics ps : pslist) {
            ps.setEventCount(0);
            ps.setLastEventTime();
            ps.persistObject();
            long[] ids = null;
            long switchId = -1L;
            long lanId = -1L;
            try {
                ids = ps.findPMStatisticsSanFabric();
                switchId = GlobalFabricManager.getInstance().findSwitchId(ipaddr);
            }
            catch (SQLException ex) {
                _storeLogger.warn((Object)("PM SendEvent: find san/fabric error " + ex.getMessage()));
                return;
            }
            if (ids == null || ids[1] == 0L) {
                try {
                    lanId = ps.findPMStatisticsLanId();
                    switchId = GlobalDCManager.getInstance().getSwitchDBIDBySwIP(ipaddr);
                }
                catch (SQLException ex) {
                    _storeLogger.warn((Object)("PM SendEvent: find lan error " + ex.getMessage()));
                    return;
                }
                if (lanId == -1L) {
                    _storeLogger.warn((Object)"PM SendEvent: no Lan or Fabric Id found. ");
                    return;
                }
                isLan = true;
            }
            LogEvent event = new LogEvent(ids == null ? lanId : ids[1], ps._src_id, ps._dest_id, LogEventType.PORT_ALARM, severity == 0 ? Severity.CRITICAL : Severity.WARNING, origin, descr, switchId);
            if (!isLan) {
                FabricPK fpk = PmMetaDataUtil.findFabricPKByDbId(ids[1]);
                event.setSource(fpk);
            } else {
                LanPK lpk = PmMetaDataUtil.findLanPKByDbId(lanId);
                event.setSource(lpk);
                event.setDCType(1);
            }
            this.eventService.logEvent(event);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void checkThreshold(String fileName, RrdDb db, long maxBytePerSec, String title, int interval, short relativeIdx, String msgStr, InetAddress swIp) throws RrdException, IOException, Exception {
        block36: {
            cvalues = PMStatisticsManager.getRrdDataWithTime(db, "AVERAGE", db.getLastUpdateTime(), db.getRrdDef().getStep(), relativeIdx);
            enableAbsoluteCritical = (PmCollect._MetaData._thresholdDef._thresholdType & 2) > 0;
            enableAbsoluteWarning = (PmCollect._MetaData._thresholdDef._thresholdType & 4) > 0;
            enableBaselineCritical = (PmCollect._MetaData._thresholdDef._thresholdType & 8) > 0;
            v0 = enableBaselineWarning = (PmCollect._MetaData._thresholdDef._thresholdType & 16) > 0;
            if (enableAbsoluteCritical || enableAbsoluteWarning) {
                if (fileName.endsWith("_flow.rrd")) {
                    return;
                }
                if (maxBytePerSec <= 0L) {
                    return;
                }
                for (i = 0; i < cvalues.length; ++i) {
                    v1 = trafficName = i == 0 ? " Rx Bytes" : " Tx Bytes";
                    if (Double.isNaN(cvalues[i])) continue;
                    value = cvalues[i];
                    highWater = maxBytePerSec / 10L * (long)PmCollect._MetaData._thresholdDef._highWaterMark / 100L;
                    lowWater = maxBytePerSec / 10L * (long)PmCollect._MetaData._thresholdDef._lowWaterMark / 100L;
                    pct = value * 1000.0 / (double)maxBytePerSec;
                    if (pct > 100.0) {
                        PmStore._storeLogger.debug((Object)"checkThreshold:pct:over 100");
                        return;
                    }
                    currentStr = trafficName;
                    if (value > 1000000.0) {
                        PmStore._storeLogger.debug((Object)("Value " + value));
                    }
                    if (PmCollect._MetaData._thresholdDef._highWaterMark > 0 && value > highWater && enableAbsoluteCritical) {
                        descr = title + " > " + Util.format(value) + trafficName;
                        if (msgStr != null) {
                            v2 = new Object[2];
                            v2[0] = currentStr;
                            v2[1] = PmCollect._MetaData._thresholdDef._highWaterMark;
                            descr = String.format(msgStr, v2);
                        }
                        PmStore._storeLogger.debug((Object)descr);
                        PmStore._storeLogger.debug((Object)("value compare is " + value + " / " + highWater + " = " + value / highWater + "maxBytes=" + maxBytePerSec));
                        this.sendEvent(fileName, PmCollect._MetaData._thresholdDef._highSeverity, "Performance Monitor", descr, swIp);
                        continue;
                    }
                    if (PmCollect._MetaData._thresholdDef._lowWaterMark > 0 && value > lowWater && enableAbsoluteWarning) {
                        descr = title + " > " + Util.format(value) + trafficName;
                        if (msgStr != null) {
                            v3 = new Object[2];
                            v3[0] = currentStr;
                            v3[1] = PmCollect._MetaData._thresholdDef._lowWaterMark;
                            descr = String.format(msgStr, v3);
                        }
                        PmStore._storeLogger.debug((Object)descr);
                        PmStore._storeLogger.debug((Object)("value compare is " + value + " / " + lowWater + " = " + value / lowWater));
                        this.sendEvent(fileName, PmCollect._MetaData._thresholdDef._lowSeverity, "Performance Monitor", descr, swIp);
                        continue;
                    }
                    PmStore._storeLogger.debug((Object)("Value " + value + " is ok for absolute warn threshold."));
                }
            }
            if (!enableBaselineCritical && !enableBaselineWarning) break block36;
            try {
                PmStore._storeLogger.debug((Object)("\n\ncheck threshold for " + db.getRrdFile().getFilePath()));
                currentHourEnd = db.getLastUpdateTime();
                periodSeconds = (long)PmCollect._MetaData._thresholdDef._period * 86400L;
                arch = db.getArchive(interval, "AVERAGE");
                vals = new ArrayList<double[]>();
                for (i = 1; i < 60; ++i) {
                    arcStep = arch.getArcStep();
                    arcStart = arch.getStartTime();
                    arcEnd = arch.getEndTime();
                    fetchStart = currentHourEnd - ((long)i * periodSeconds + 3600L);
                    fetchEnd = currentHourEnd - (long)i * periodSeconds;
                    if (arcStart <= fetchStart && arcEnd >= fetchEnd) {
                        request = db.createFetchRequest("AVERAGE", fetchStart, fetchEnd, 1L, relativeIdx);
                        fetchPoints = request.fetch();
                        numPoints = fetchPoints.length;
                        if (numPoints <= 0) break;
                        values = new double[fetchPoints[0].getSize()];
                        if (arcStep == 300L) {
                            numVals = new int[values.length];
                            for (nvi = 0; nvi < numVals.length; ++nvi) {
                                numVals[nvi] = 0;
                            }
                            for (fi = fetchPoints.length - 2; fi > 0; --fi) {
                                for (di = fetchPoints[fi].getSize() - 1; di >= 0; --di) {
                                    if (Double.isNaN(fetchPoints[fi].getValue(di))) continue;
                                    v4 = di;
                                    numVals[v4] = numVals[v4] + 1;
                                    v5 = di;
                                    values[v5] = values[v5] + fetchPoints[fi].getValue(di);
                                }
                            }
                            for (di = values.length - 1; di >= 0; --di) {
                                values[di] = values[di] / (double)numVals[di];
                            }
                        } else if (arcStep == 1800L && numPoints == 4) {
                            numVals = new int[values.length];
                            for (nvi = 0; nvi < numVals.length; ++nvi) {
                                numVals[nvi] = 0;
                            }
                            for (fi = fetchPoints.length - 2; fi > 0; --fi) {
                                for (di = fetchPoints[fi].getSize() - 1; di >= 0; --di) {
                                    if (Double.isNaN(fetchPoints[fi].getValue(di))) continue;
                                    v6 = di;
                                    numVals[v6] = numVals[v6] + 1;
                                    v7 = di;
                                    values[v7] = values[v7] + fetchPoints[fi].getValue(di);
                                }
                            }
                            for (di = values.length - 1; di >= 0; --di) {
                                values[di] = values[di] / (double)numVals[di];
                            }
                        } else {
                            if (arcStep != 7200L || numPoints != 3) break;
                            for (di = fetchPoints[1].getSize() - 1; di >= 0; --di) {
                                v8 = di;
                                values[v8] = values[v8] + fetchPoints[1].getValue(di);
                            }
                        }
                        PmStore._storeLogger.debug((Object)(i + " baseline hour sample value is "));
                        for (vi = 0; vi < values.length; ++vi) {
                            PmStore._storeLogger.debug((Object)("\t" + values[vi]));
                        }
                        vals.add(values);
                        continue;
                    }
                    if ((arch = db.getNextArchive(arch, "AVERAGE")).getArcStep() > 7200L) break;
                    --i;
                }
                if (vals.size() == 0) {
                    return;
                }
                baseValues = new double[cvalues.length];
                for (i = 0; i < baseValues.length; ++i) {
                    val = 0.0;
                    numVal = 0;
                    for (ii = vals.size() - 1; ii >= 0; --ii) {
                        if (Double.isNaN(((double[])vals.get(ii))[i])) continue;
                        PmStore._storeLogger.debug((Object)(++numVal + " baseline value is " + ((double[])vals.get(ii))[i]));
                        val += ((double[])vals.get(ii))[i];
                    }
                    baseValues[i] = val / (double)numVal;
                    PmStore._storeLogger.debug((Object)(i + " avg. baseline val is " + val + " / " + numVal + " = " + baseValues[i]));
                }
                for (i = 0; i < baseValues.length; ++i) {
                    if (PmCollect._MetaData._thresholdDef._highWaterMark <= 0) ** GOTO lbl-1000
                    if (cvalues[i] > baseValues[i] * (double)PmCollect._MetaData._thresholdDef._highWaterMark / 100.0 && enableBaselineCritical) {
                        descr = title + " > " + Util.format(cvalues[i]) + " traffic bytes/sec";
                        this.sendEvent(fileName, PmCollect._MetaData._thresholdDef._highSeverity, "Performance Monitor", descr, swIp);
                        PmStore._storeLogger.debug((Object)descr);
                    } else lbl-1000:
                    // 2 sources

                    {
                        PmStore._storeLogger.debug((Object)(cvalues[i] + " vs " + baseValues[i] + " is ok (Baseline Critical)"));
                    }
                    if (PmCollect._MetaData._thresholdDef._lowWaterMark > 0) {
                        if (cvalues[i] > baseValues[i] * (double)PmCollect._MetaData._thresholdDef._lowWaterMark / 100.0 && enableBaselineWarning) {
                            descr = title + " > " + Util.format(cvalues[i]) + " traffic bytes/sec";
                            this.sendEvent(fileName, PmCollect._MetaData._thresholdDef._lowSeverity, "Performance Monitor", descr, swIp);
                            PmStore._storeLogger.debug((Object)descr);
                            continue;
                        }
                    }
                    PmStore._storeLogger.debug((Object)(cvalues[i] + " vs " + baseValues[i] + " is ok (Baseline warn"));
                }
            }
            catch (Exception ex) {
                PmStore._storeLogger.warn((Object)("PM check threshold error: " + ex.getMessage() + " interval: " + interval));
                ex.printStackTrace();
                if (!SnmpSession.isTrace()) break block36;
                ex.printStackTrace();
            }
        }
    }

    void checkInterpolation(RrdDb db, SnmpPeer peer, int ifIndex, long now, double[] currentValues, int interval, Query query) throws IOException, RrdException {
        block13: {
            short relativeRrdIndex = query.getIndex();
            long lastUpdateTime = db.getLastUpdateTimeForDsIndex(query.getRrdStoreIndex(relativeRrdIndex));
            if (now - lastUpdateTime > 259200000L) {
                return;
            }
            if (!db.getRrdFile().getFilePath().endsWith("_flow.rrd")) {
                _storeLogger.debug((Object)("checking interpolation for " + db.getRrdFile().getFilePath()));
                if (now - lastUpdateTime > (long)interval) {
                    _storeLogger.debug((Object)("\t" + db.getRrdFile().getFilePath() + " missing data, checking sysuptime"));
                    VarBindList ifVbl = new VarBindList();
                    ifVbl.add(PmCollect._IfLastChange, ifIndex);
                    SysUpTimeStamp sts = PmCollect._SysUpTimeByPeer.get(peer);
                    if (sts == null) {
                        ifVbl.add(PmCollect._SysUpTime, 0);
                    }
                    try {
                        SnmpPDU ifPdu = SnmpFetch.get(peer, ifVbl);
                        if (ifPdu != null) {
                            long ifLastChangeTimeStamp;
                            long ifLastChange = ifPdu.getVariables().longValue(0);
                            if (sts == null) {
                                sts = new SysUpTimeStamp();
                                sts._sysUpTime = ifPdu.getVariables().longValue(1);
                                sts._sysUpTimeStamp = ifPdu.getTimeReceived();
                            }
                            if ((ifLastChangeTimeStamp = (sts._sysUpTimeStamp - (sts._sysUpTime - ifLastChange) * 10L) / 1000L) < lastUpdateTime) {
                                long endTime = lastUpdateTime;
                                Datasource[] dss = this.getRelatedDataSource(db, query.getIndex());
                                double[] startValues = new double[dss.length];
                                for (int svindex = 0; svindex < startValues.length && svindex < currentValues.length; ++svindex) {
                                    startValues[svindex] = dss[svindex].getLastValue();
                                    _storeLogger.debug((Object)("interpolation start value " + svindex + " ::" + startValues[svindex]));
                                    _storeLogger.debug((Object)("interpolation ended value " + svindex + " ::" + currentValues[svindex]));
                                }
                                double[] baseValues = PMStatisticsManager.getRrdDataWithTime(db, "AVERAGE", lastUpdateTime, db.getRrdDef().getStep(), relativeRrdIndex);
                                for (int bvi = baseValues.length - 1; bvi >= 0; --bvi) {
                                    baseValues[bvi] = baseValues[bvi] * (double)db.getRrdDef().getStep();
                                }
                                _storeLogger.debug((Object)("\t\t" + db.getRrdFile().getFilePath() + " " + ifIndex + " Doing interpolation"));
                                this.doInterpolation(db, endTime, now, startValues, currentValues, baseValues, interval, query);
                            } else {
                                _storeLogger.debug((Object)(db.getRrdFile().getFilePath() + " " + ifIndex + " IfLastChange during last data gap, skip interpolation"));
                            }
                        } else {
                            _storeLogger.debug((Object)("\tcan't not get iflastchange from " + peer));
                        }
                    }
                    catch (SnmpException ex) {
                        _storeLogger.warn((Object)(peer.getAddress().getHostAddress() + " error: " + ex + ". Interpolation skipped"));
                        if (!SnmpSession.isTrace()) break block13;
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    private Datasource[] getRelatedDataSource(RrdDb db, short index) throws IOException {
        Datasource[] dss = db.getDatasources();
        ArrayList<Datasource> list = new ArrayList<Datasource>();
        for (int i = 0; i < dss.length; ++i) {
            if (dss[i].getDsName().indexOf(Short.toString(index) + ".") != 0) continue;
            list.add(dss[i]);
        }
        return list.toArray(new Datasource[list.size()]);
    }

    private void doInterpolation(RrdDb rrdDb, long start, long end, double[] startValue, double[] endValue, double[] baseValue, int interval, Query query) throws IOException, RrdException {
        int i;
        long nstart = Util.normalize(start, interval);
        long nend = Util.normalize(end, interval);
        long numSamples = (nend - nstart) / (long)interval - 1L;
        short relativeRrdIndex = query.getIndex();
        if (numSamples <= 0L) {
            return;
        }
        if (end - nend > start - nstart) {
            ++numSamples;
        }
        long dividend = numSamples;
        if (numSamples > 1L) {
            dividend = (numSamples + 1L) * (numSamples / 2L);
            if (numSamples % 2L == 1L) {
                dividend += numSamples / 2L + 1L;
            }
        }
        double[] incrementValue = new double[startValue.length];
        for (i = 0; i < incrementValue.length && i < endValue.length; ++i) {
            _storeLogger.debug((Object)("\n" + i + " during interpolation traffic is " + (endValue[i] - startValue[i]) / (double)(end - start)));
            _storeLogger.debug((Object)(i + " before interpolation traffic is " + baseValue[i] / (double)interval));
            endValue[i] = (endValue[i] - startValue[i]) * (double)(numSamples * (long)interval) / (double)(end - start) + startValue[i];
            incrementValue[i] = (endValue[i] - startValue[i] - baseValue[i] * (double)numSamples) / (double)dividend;
            _storeLogger.debug((Object)(i + " interpolation increment " + incrementValue[i] + " -- baseValue " + baseValue[i]));
            _storeLogger.debug((Object)("\t\t end value " + endValue[i] + " dividend " + dividend));
        }
        i = 1;
        while ((long)i <= numSamples) {
            Sample sample = rrdDb.createSample(start += (long)interval);
            for (int dsIndex = 0; dsIndex < startValue.length; ++dsIndex) {
                int n = dsIndex;
                startValue[n] = startValue[n] + (incrementValue[dsIndex] * (double)i + baseValue[dsIndex]);
                double value = startValue[dsIndex];
                sample.setValue(dsIndex + query.getRrdStoreIndex(relativeRrdIndex), value);
                _storeLogger.debug((Object)(i + " interpolation value " + value));
            }
            sample.update();
            ++i;
        }
    }
}

