/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.scheduler.jobs;

import com.cisco.dcbu.install.PortConfigurator;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.SchedulerUtil;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.model.FMUserBase;
import com.cisco.dcbu.sm.common.rif.EjbRegistryIf;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.security.SecurityManager;
import com.cisco.dcbu.sm.server.security.UserManager;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public abstract class ReportJob
implements StatefulJob,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String LOCAL_HOST = "127.0.0.1";
    static final String HTTPS = "https";
    final int WEB_SERVER_SCHEME = 0;
    final int WEB_SERVER_PORT = 1;
    Logger _Log = LogManager.getLogger((String)"Scheduler");
    final String SMTP_SIZE_MSG = "The report is too big for smtp, please follow the link to see report";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail jobDetail = context.getJobDetail();
        String groupJobName = jobDetail.getFullName();
        String jobName = groupJobName.substring(groupJobName.indexOf(46) + 1, groupJobName.length());
        String reportUrl = null;
        String username = (String)jobDetail.getJobDataMap().get((Object)"UserName");
        String emailNotify = (String)jobDetail.getJobDataMap().get((Object)"Email");
        String scheme = (String)jobDetail.getJobDataMap().get((Object)"ServerScheme");
        String exp2Csv = (String)jobDetail.getJobDataMap().get((Object)"exp2Csv");
        String templateName = (String)jobDetail.getJobDataMap().get((Object)"Template");
        String fileName = (String)jobDetail.getJobDataMap().get((Object)"fileName");
        String filePath = (String)jobDetail.getJobDataMap().get((Object)"filePath");
        Long lan_grp_id = (Long)jobDetail.getJobDataMap().get((Object)"Lan_Group_Id");
        if (filePath == null) {
            File reportDir = new File(ClientCache.getReportsDir() + File.separator + username + File.separator + "custom" + File.separator + templateName);
            filePath = reportDir.getAbsolutePath() + File.separator + fileName;
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd_kk-mm-ss-SSS");
        String generationTime = f.format(new Date());
        reportUrl = this.getReportUrl(jobDetail, generationTime);
        String reportStatus = "";
        try {
            String report = "";
            report = this.generateReport(reportUrl, username, scheme);
            if (exp2Csv != null && exp2Csv.equals("on")) {
                String excelSuffix = lan_grp_id > 0L || lan_grp_id == -99L ? ".xls" : ".csv";
                fileName = fileName.indexOf(excelSuffix) < 0 ? fileName + excelSuffix : fileName;
            } else {
                fileName = fileName.indexOf(".html") < 0 ? fileName + ".html" : fileName;
            }
            File flN = null;
            flN = emailNotify != null && jobDetail.getJobDataMap().get((Object)"DisplayLink") == null ? new File(fileName) : null;
            boolean dataInReport = this.generateReportFile(reportUrl, username, scheme, flN);
            if (dataInReport) {
                if (emailNotify != null) {
                    String recipient = (String)jobDetail.getJobDataMap().get((Object)"Recipient");
                    String subject = (String)jobDetail.getJobDataMap().get((Object)"Subject");
                    try {
                        if (jobDetail.getJobDataMap().get((Object)"DisplayLink") != null) {
                            report = this.constructURL(jobDetail, jobName, generationTime);
                            SchedulerUtil.sendMail(recipient, subject, report);
                        }
                        SchedulerUtil.sendMail(recipient, subject, flN.getAbsolutePath(), fileName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (e.getMessage().contains("523")) {
                            try {
                                report = this.constructURL(jobDetail, jobName, generationTime);
                                report = "The report is too big for smtp, please follow the link to see report\n" + report;
                                SchedulerUtil.sendMail(recipient, subject, report);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                throw ex;
                            }
                        }
                        throw e;
                    }
                }
            } else {
                throw new Exception("Report failed (see fmserver.log).");
            }
            this._Log.info((Object)("Report says: " + groupJobName + " executed at " + new Date()));
            if (flN != null) {
                flN.delete();
                flN = null;
            }
        }
        catch (Exception ex) {
            reportStatus = ex.getMessage();
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            this._Log.warn((Object)("Report says: " + groupJobName + " executed at " + new Date() + " failed!"));
        }
        jobDetail.getJobDataMap().put("reportStatus", reportStatus);
    }

    protected String getReportUrl(JobDetail jobDetail, String generationTime) throws JobExecutionException {
        ArrayList<String> webProperties;
        String reportUrl = (String)jobDetail.getJobDataMap().get((Object)"ReportUrl");
        String hostAddr = (String)jobDetail.getJobDataMap().get((Object)"ServerAddr");
        reportUrl = this.modifyReportURLForFederation(reportUrl, jobDetail);
        reportUrl = reportUrl + "_" + generationTime;
        try {
            webProperties = this.getWebServerConfig();
        }
        catch (RemoteException re) {
            this._Log.warn((Object)"Error getting web server properties:", (Throwable)re);
            throw new JobExecutionException("Error getting web server properties!");
        }
        reportUrl = (Boolean.valueOf(webProperties.get(0)) != false ? HTTPS : "http") + "://" + hostAddr + ":" + Integer.parseInt(webProperties.get(1)) + reportUrl;
        return reportUrl;
    }

    protected String modifyReportURLForFederation(String reportURL, JobDetail jobDetail) {
        return reportURL;
    }

    protected String generateReport(String reportUrl, String username, String scheme) throws Exception {
        URL u = null;
        InputStream is = null;
        StringBuffer sb = new StringBuffer();
        try {
            String auth_mode = System.getProperty("authentication.mode");
            username = auth_mode.equalsIgnoreCase("local") ? username : username + "@" + auth_mode;
            String fullUrl = reportUrl + "&token=" + URLEncoder.encode(SecurityManager.getSSOToken(username), "UTF-8");
            u = new URL(fullUrl);
            this._Log.info((Object)("Full URL:" + fullUrl));
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            if (scheme.equalsIgnoreCase(HTTPS)) {
                ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String rserver, SSLSession sses) {
                        if (!rserver.equals(sses.getPeerHost())) {
                            ReportJob.this._Log.info((Object)("certificate <" + sses.getPeerHost() + "> does not match host <" + rserver + "> but " + "continuing anyway"));
                        }
                        return true;
                    }
                });
            }
            is = conn.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            this._Log.warn((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    this._Log.warn((Object)"Failed to close report stream", (Throwable)ioe);
                }
            }
        }
        return sb.toString();
    }

    protected boolean generateReportFile(String reportUrl, String username, String scheme, File flN) throws Exception {
        URL u = null;
        InputStream is = null;
        FileOutputStream fo = null;
        BufferedReader br = null;
        boolean dataInReport = false;
        try {
            String auth_mode = System.getProperty("authentication.mode");
            username = auth_mode.equalsIgnoreCase("local") ? username : username + "@" + auth_mode;
            String fullUrl = reportUrl + "&token=" + URLEncoder.encode(SecurityManager.getSSOToken(username), "UTF-8");
            u = new URL(this.getModURL(fullUrl));
            this._Log.info((Object)("Full URL:" + fullUrl));
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            if (scheme.equalsIgnoreCase(HTTPS)) {
                ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String rserver, SSLSession sses) {
                        if (!rserver.equals(sses.getPeerHost())) {
                            ReportJob.this._Log.info((Object)("certificate <" + sses.getPeerHost() + "> does not match host <" + rserver + "> but " + "continuing anyway"));
                        }
                        return true;
                    }
                });
            }
            is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            if (flN != null) {
                int b;
                fo = new FileOutputStream(flN);
                OutputStreamWriter wr = new OutputStreamWriter(fo);
                byte[] bs = new byte[1024];
                int numBytes = 0;
                while ((b = br.read()) != -1) {
                    dataInReport = true;
                    bs[numBytes++] = (byte)b;
                    if (numBytes != 1024) continue;
                    fo.write(bs, 0, 1024);
                    fo.flush();
                    numBytes = 0;
                }
                if (numBytes > 0) {
                    fo.write(bs, 0, numBytes);
                    fo.flush();
                }
            } else {
                is = conn.getInputStream();
                String line = null;
                StringBuffer sb = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                dataInReport = sb.length() > 0;
            }
        }
        catch (Exception e) {
            this._Log.warn((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    this._Log.warn((Object)"Failed to close report stream", (Throwable)ioe);
                }
            }
            if (fo != null) {
                fo.close();
                fo = null;
            }
            if (br != null) {
                br.close();
                br = null;
            }
        }
        return dataInReport;
    }

    protected String getModURL(String url) {
        return url;
    }

    private String getPassword(String username) {
        FMUserBase fmUserBase = null;
        try {
            fmUserBase = UserManager.findUserFromDB(username);
            if (fmUserBase != null) {
                return StringEncrypter.DESedeDecrypt(fmUserBase.getEncryptedPassword());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected abstract String constructURL(JobDetail var1, String var2, String var3) throws UnknownHostException;

    public ArrayList<String> getWebServerConfig() throws RemoteException {
        PortConfigurator pc = new PortConfigurator(ClientCache.getDcmDir(), "fm");
        try {
            pc.load(ClientCache.getDcmDir() + File.separator + pc.WEB);
            pc.getWebPortsFromTomcat();
        }
        catch (Exception e) {
            this._Log.warn((Object)"Error loading server.xml:", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        this._Log.info((Object)("Server.xml is loaded: scheme -- " + pc.isHTTPS() + " ::" + "port -- " + pc.getWebPort()));
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(String.valueOf(pc.isHTTPS()));
        ret.add(String.valueOf(pc.getWebPort()));
        return ret;
    }

    public String getServerForFabricInFederatedMode(int fId) {
        String serverIp = null;
        String server = System.getProperty("server.bindaddrs", LOCAL_HOST);
        if (server == null || server.equals("")) {
            server = "localhost";
        }
        try {
            EjbRegistryIf rif = WebReferenceManager.getInstance().getLocalRef();
            if (rif != null) {
                return rif.getFMServer().getServerForFabric(new FabricPK(fId));
            }
        }
        catch (Exception ex) {
            this._Log.error((Object)ex.getMessage());
        }
        return serverIp;
    }
}

