/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.security;

import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.model.SnmpUserOpt;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DBException;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.Sequence;
import com.cisco.dcbu.sm.server.facade.SessionImpl;
import com.cisco.dcbu.sm.server.model.AbstractDBObjectImpl;
import com.cisco.dcbu.sm.server.security.FMUser;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class SnmpUserImpl
extends AbstractDBObjectImpl {
    public static Logger _Logger = Logger.getLogger((String)SnmpUserImpl.class.getName());
    static final String QuerySQLByIp = "select snmpuser.id, snmpuser.version, snmpuser.user_name, snmpuser.auth_password, snmpuser.priv_password, snmpuser.auth_protocol, snmpuser.priv_protocol, snmpuser.security_name, snmpuser.role_name, snmpuser.is_logging_in, snmpuser.last_update_time from snmpuser, fabric, switch where switch.ip_address=? and  snmpuser.id=fabric.fmuser_id and switch.fabric_id = fabric.id";
    static final String QuerySQLByEthSwIp = "select snmpuser.id, snmpuser.version, snmpuser.user_name, snmpuser.auth_password, snmpuser.priv_password, snmpuser.auth_protocol, snmpuser.priv_protocol, snmpuser.security_name, snmpuser.role_name, snmpuser.is_logging_in, snmpuser.last_update_time from snmpuser, cdp_seed, ethswitch_seed, ethswitch where ethswitch.ip_address=? and  snmpuser.id=cdp_seed.cred_id and cdp_seed.id=ethswitch_seed.seed_id and ethswitch_seed.switch_id=ethswitch.id";
    static final String QuerySQLByCommunity = "select id, version, user_name, security_name, role_name, is_logging_in, last_update_time from snmpuser where (version=0 or version=1 or version=2) and user_name=?";
    static final String QuerySQLByUser = "select id, version, user_name, auth_password, priv_password, auth_protocol, priv_protocol, security_name, role_name, is_logging_in, last_update_time from snmpuser where version=3 and user_name=? and auth_password=? and auth_protocol=? and priv_protocol=?";
    static final String QuerySQLById = "select id, version, user_name, auth_password, priv_password, auth_protocol, priv_protocol, security_name, role_name, is_logging_in, last_update_time from snmpuser where id=?";
    static final String QuerySQLByUserName = "select id, version, user_name, auth_password, priv_password, auth_protocol, priv_protocol, security_name, role_name, is_logging_in, last_update_time from snmpuser where user_name=?";
    static final String QuerySQL = "select id, version, user_name, auth_password, priv_password, auth_protocol, priv_protocol, security_name, role_name, is_logging_in, last_update_time from snmpuser";
    static final String InsertSQL = "insert into snmpuser(id, version, user_name, auth_password, priv_password, auth_protocol, priv_protocol, security_name, role_name, last_update_time) values(?,?,?,?,?, ?,?,?,?,?)";
    static final String UpdateSQL = "update snmpuser set version=?, user_name=?, auth_password=?, priv_password=?, auth_protocol=?, priv_protocol=?, security_name=?, role_name=?, last_update_time=? where id=?";
    static final String TableName = "snmpuser";
    final SnmpUser _user;

    public SnmpUserImpl(FMUser fmUser, FabricPK fabricPK) throws IllegalArgumentException {
        if (fabricPK == null || fmUser == null) {
            throw new IllegalArgumentException("Null FMUser or Fabric key is not allowed");
        }
        SnmpUser user = fmUser.getSnmpUser(fabricPK);
        if (user == null) {
            throw new IllegalArgumentException("Null Snmp User is not allowed");
        }
        this._user = user;
    }

    public SnmpUserImpl(SnmpUser user) throws IllegalArgumentException {
        if (user == null) {
            throw new IllegalArgumentException("Null Snmp User is not allowed");
        }
        this._user = user;
    }

    public SnmpUserImpl(SnmpUserOpt userOpt) {
        this._user = SessionImpl.convertSnmpUser(userOpt);
    }

    void checkPreexistRecord(Connection con) throws SQLException {
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            if (this._user.getSecurityModel() == 3) {
                stat = con.prepareStatement(QuerySQLByUser);
                stat.setString(1, StringEncrypter.encryptString("DES", ((UsmUser)this._user).getUserName()));
                stat.setString(2, StringEncrypter.encryptString("DES", ((UsmUser)this._user).getAuthPassword()));
                stat.setInt(3, ((UsmUser)this._user).getAuthProtocol());
                stat.setInt(4, ((UsmUser)this._user).getPrivacyProtocol());
            } else {
                stat = con.prepareStatement(QuerySQLByCommunity);
                stat.setString(1, StringEncrypter.encryptString("DES", ((CommunityUser)this._user).getCommunity()));
            }
            rs = stat.executeQuery();
            if (rs.next()) {
                this.setDBID(rs.getLong(1));
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SQLException(ex.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public PreparedStatement getPersistentSql(Connection con) throws DBException, SQLException {
        Statement stat = null;
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        try {
            boolean useV3;
            boolean bl = useV3 = this._user.getSecurityModel() == 3;
            if (this.getDBID() == 0L) {
                this.setDBID(Sequence.getSequence().getPK());
                stat = con.prepareStatement(InsertSQL);
                stat.setLong(1, this.getDBID());
                stat.setLong(2, useV3 ? 3L : (long)((CommunityUser)this._user).getVersion());
                if (useV3) {
                    UsmUser usmUser = (UsmUser)this._user;
                    stat.setString(3, StringEncrypter.encryptString("DES", usmUser.getUserName()));
                    stat.setString(4, StringEncrypter.encryptString("DES", usmUser.getAuthPassword()));
                    if (usmUser.getPrivacyPassword() != null) {
                        stat.setString(5, StringEncrypter.encryptString("DES", usmUser.getPrivacyPassword()));
                    } else {
                        stat.setNull(5, 12);
                    }
                    stat.setInt(6, usmUser.getAuthProtocol());
                    stat.setInt(7, usmUser.getPrivacyProtocol());
                    stat.setString(8, usmUser.getSecurityName());
                    stat.setString(9, usmUser.getRoleName());
                } else {
                    CommunityUser communityUser = (CommunityUser)this._user;
                    stat.setString(3, StringEncrypter.encryptString("DES", communityUser.getCommunity()));
                    stat.setNull(4, 12);
                    stat.setNull(5, 12);
                    stat.setNull(6, 4);
                    stat.setNull(7, 4);
                    stat.setString(8, communityUser.getSecurityName());
                    stat.setString(9, communityUser.getRoleName());
                }
                stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
                return stat;
            }
            stat = con.prepareStatement(UpdateSQL);
            stat.setLong(1, useV3 ? 3L : (long)((CommunityUser)this._user).getVersion());
            if (useV3) {
                UsmUser usmUser = (UsmUser)this._user;
                stat.setString(2, StringEncrypter.encryptString("DES", usmUser.getUserName()));
                stat.setString(3, StringEncrypter.encryptString("DES", usmUser.getAuthPassword()));
                if (usmUser.getPrivacyPassword() != null) {
                    stat.setString(4, StringEncrypter.encryptString("DES", usmUser.getPrivacyPassword()));
                } else {
                    stat.setNull(4, 12);
                }
                stat.setInt(5, usmUser.getAuthProtocol());
                stat.setInt(6, usmUser.getPrivacyProtocol());
                stat.setString(7, usmUser.getSecurityName());
                stat.setString(8, usmUser.getRoleName());
            } else {
                CommunityUser communityUser = (CommunityUser)this._user;
                stat.setString(2, StringEncrypter.encryptString("DES", communityUser.getCommunity()));
                stat.setNull(3, 12);
                stat.setNull(4, 12);
                stat.setNull(5, 4);
                stat.setNull(6, 4);
                stat.setString(7, communityUser.getSecurityName());
                stat.setString(8, communityUser.getRoleName());
            }
            stat.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
            stat.setLong(10, this.getDBID());
            return stat;
        }
        catch (Exception ex) {
            if (stat != null) {
                stat.close();
            }
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public PreparedStatement getUpdateSql(Connection con) throws DBException, SQLException {
        Statement stat = null;
        if (this.getDBID() == 0L) {
            this.checkPreexistRecord(con);
        }
        if (this.getDBID() != 0L) {
            return stat;
        }
        try {
            boolean useV3 = this._user.getSecurityModel() == 3;
            this.setDBID(Sequence.getSequence().getPK());
            stat = con.prepareStatement(InsertSQL);
            stat.setLong(1, this.getDBID());
            stat.setLong(2, useV3 ? 3L : (long)((CommunityUser)this._user).getVersion());
            if (useV3) {
                UsmUser usmUser = (UsmUser)this._user;
                stat.setString(3, StringEncrypter.encryptString("DES", usmUser.getUserName()));
                stat.setString(4, StringEncrypter.encryptString("DES", usmUser.getAuthPassword()));
                if (usmUser.getPrivacyPassword() != null) {
                    stat.setString(5, StringEncrypter.encryptString("DES", usmUser.getPrivacyPassword()));
                } else {
                    stat.setNull(5, 12);
                }
                stat.setInt(6, usmUser.getAuthProtocol());
                stat.setInt(7, usmUser.getPrivacyProtocol());
                stat.setString(8, usmUser.getSecurityName());
                stat.setString(9, usmUser.getRoleName());
            } else {
                CommunityUser communityUser = (CommunityUser)this._user;
                stat.setString(3, StringEncrypter.encryptString("DES", communityUser.getCommunity()));
                stat.setNull(4, 12);
                stat.setNull(5, 12);
                stat.setNull(6, 4);
                stat.setNull(7, 4);
                stat.setString(8, communityUser.getSecurityName());
                stat.setString(9, communityUser.getRoleName());
            }
            stat.setTimestamp(10, new Timestamp(System.currentTimeMillis()));
            return stat;
        }
        catch (Exception ex) {
            if (stat != null) {
                stat.close();
            }
            throw new SQLException(ex.getMessage());
        }
    }

    @Override
    public String getDBTableName() {
        return TableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpUser loadFromDB(long id) {
        SnmpUser snmpUser;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLById);
            stat.setLong(1, id);
            rs = stat.executeQuery();
            ArrayList<SnmpUser> al = SnmpUserImpl.loadDBRecord(rs);
            snmpUser = al.size() == 0 ? null : al.get(0);
        }
        catch (SQLException ex) {
            SnmpUser snmpUser2;
            try {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Cannot load credential from DB with id:" + id), (Throwable)ex);
                } else {
                    _Logger.warn((Object)("Cannot load credential from DB with id:" + id));
                }
                snmpUser2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return snmpUser2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return snmpUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static SnmpUser getSnmpUser(String userName) {
        SnmpUser snmpUser;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(QuerySQLByUserName);
            stat.setString(1, StringEncrypter.encryptString("DES", userName));
            rs = stat.executeQuery();
            ArrayList<SnmpUser> al = SnmpUserImpl.loadDBRecord(rs);
            snmpUser = al.size() == 0 ? null : al.get(0);
        }
        catch (SQLException ex) {
            block7: {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)("Cannot get credential from DB with user name" + userName), (Throwable)ex);
                    break block7;
                }
                _Logger.warn((Object)("Cannot get credential from DB with user name:" + userName));
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        catch (Exception e) {
            _Logger.warn((Object)("Cannot get credential from DB with user name" + userName), (Throwable)e);
            {
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stat);
                    DbUtil.close(con);
                    throw throwable;
                }
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return snmpUser;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnmpUser loadFromDB(InetAddress inet) {
        SnmpUser snmpUser;
        PreparedStatement stat2;
        ResultSet rs;
        PreparedStatement stat;
        Connection con;
        block16: {
            ResultSet rs2;
            block14: {
                SnmpUser snmpUser2;
                block15: {
                    block12: {
                        SnmpUser snmpUser3;
                        block13: {
                            con = null;
                            stat = null;
                            rs = null;
                            stat2 = null;
                            rs2 = null;
                            con = ConnectionManager.getConnection();
                            stat = con.prepareStatement(QuerySQLByIp);
                            stat.setBytes(1, inet.getAddress());
                            rs = stat.executeQuery();
                            ArrayList<SnmpUser> al = SnmpUserImpl.loadDBRecord(rs);
                            if (al.size() <= 0) break block12;
                            snmpUser3 = al.get(0);
                            if (rs2 == null) break block13;
                            DbUtil.close(rs2);
                        }
                        if (stat2 != null) {
                            DbUtil.close(stat2);
                        }
                        DbUtil.close(rs);
                        DbUtil.close(stat);
                        DbUtil.close(con);
                        return snmpUser3;
                    }
                    stat2 = con.prepareStatement(QuerySQLByEthSwIp);
                    stat2.setBytes(1, inet.getAddress());
                    rs2 = stat2.executeQuery();
                    ArrayList<SnmpUser> al2 = SnmpUserImpl.loadDBRecord(rs2);
                    if (al2.size() <= 0) break block14;
                    snmpUser2 = al2.get(0);
                    if (rs2 == null) break block15;
                    DbUtil.close(rs2);
                }
                if (stat2 != null) {
                    DbUtil.close(stat2);
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return snmpUser2;
            }
            try {
                snmpUser = null;
                if (rs2 == null) break block16;
            }
            catch (SQLException ex) {
                SnmpUser snmpUser4;
                block17: {
                    try {
                        _Logger.trace((Object)ex.getMessage());
                        snmpUser4 = null;
                        if (rs2 == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs2 != null) {
                            DbUtil.close(rs2);
                        }
                        if (stat2 != null) {
                            DbUtil.close(stat2);
                        }
                        DbUtil.close(rs);
                        DbUtil.close(stat);
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rs2);
                }
                if (stat2 != null) {
                    DbUtil.close(stat2);
                }
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                return snmpUser4;
            }
            DbUtil.close(rs2);
        }
        if (stat2 != null) {
            DbUtil.close(stat2);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return snmpUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<SnmpUser> loadFromDB() throws SQLException {
        ArrayList<SnmpUser> arrayList;
        Connection con = ConnectionManager.getConnection();
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            stat = con.prepareStatement(QuerySQL);
            rs = stat.executeQuery();
            arrayList = SnmpUserImpl.loadDBRecord(rs);
        }
        catch (SQLException ex) {
            ArrayList<SnmpUser> arrayList2;
            try {
                _Logger.trace((Object)ex.getMessage());
                arrayList2 = null;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
            return arrayList2;
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return arrayList;
    }

    public static ArrayList<SnmpUser> loadDBRecord(ResultSet rs) throws SQLException {
        ArrayList<SnmpUser> al = new ArrayList<SnmpUser>();
        while (rs.next()) {
            int version = rs.getInt(2);
            SnmpUser user = null;
            try {
                if (version == 3) {
                    String privPass = rs.getString(5);
                    user = new UsmUser(StringEncrypter.decryptString("DES", rs.getString(3)), rs.getInt(6), StringEncrypter.decryptString("DES", rs.getString(4)), rs.getInt(7), privPass == null ? privPass : StringEncrypter.decryptString("DES", privPass));
                } else {
                    user = new CommunityUser(StringEncrypter.decryptString("DES", rs.getString(3)), version);
                }
                user.setRoleName(rs.getString(9));
            }
            catch (Exception ex) {
                if (_Logger.isDebugEnabled()) {
                    _Logger.debug((Object)"Caught exception from  load snmpuser db record", (Throwable)ex);
                    continue;
                }
                _Logger.warn((Object)ex.getMessage());
                continue;
            }
            al.add(user);
        }
        return al;
    }
}

