/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web;

import com.cisco.dcbu.sm.common.model.FileBase;
import com.cisco.dcbu.sm.common.model.FileWrapper;
import com.cisco.dcbu.sm.common.model.NameValuePair;
import com.cisco.dcbu.sm.common.model.ServerReference;
import com.cisco.dcbu.sm.common.rif.ClusterProcessRif;
import com.cisco.dcbu.sm.common.rif.EMRif;
import com.cisco.dcbu.sm.common.rif.FMServerRif;
import com.cisco.dcbu.sm.common.rif.IscRif;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.rif.TopologyManager;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.ServerMonitor;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.facade.FMServerImpl;
import com.cisco.dcbu.sm.server.facade.FMSessionManager;
import com.cisco.dcbu.sm.server.model.GlobalDCManager;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterProcessor
implements ClusterProcessRif,
Serializable {
    private static final long serialVersionUID = 1L;
    private static ClusterProcessor _Instance = null;

    private ClusterProcessor() {
    }

    public static ClusterProcessor getInstance() {
        if (_Instance == null) {
            _Instance = new ClusterProcessor();
        }
        return _Instance;
    }

    @Override
    public ArrayList<NameValuePair> getAllTemplates(File reportDir) throws Exception {
        ArrayList<NameValuePair> templateList = new ArrayList<NameValuePair>();
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FMServerRif server = null;
        if (references != null) {
            for (ServerReference serverRef : references) {
                try {
                    server = (FMServerRif)this.getReference(webRefMgr, ServerReference.Beans.FMSERVER_BEAN, serverRef);
                    if (server == null) continue;
                    ArrayList<NameValuePair> hostList = server.getLocalTemplates(reportDir);
                    templateList.addAll(hostList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return templateList;
    }

    @Override
    public ArrayList<FileWrapper> getAllReports(File reportDir, String base, Map dataMap) throws Exception {
        ArrayList<FileWrapper> reportsList = new ArrayList<FileWrapper>();
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FMServerRif server = null;
        if (references != null) {
            for (ServerReference serverRef : references) {
                try {
                    server = (FMServerRif)this.getReference(webRefMgr, ServerReference.Beans.FMSERVER_BEAN, serverRef);
                    if (server == null) continue;
                    FileBase[] baseList = server.getLocalReports(reportDir, base, dataMap);
                    ArrayList<FileWrapper> rstList = new ArrayList<FileWrapper>();
                    for (int i = 0; i < baseList.length; ++i) {
                        FileWrapper wrapper = new FileWrapper(baseList[i]);
                        rstList.add(wrapper);
                    }
                    reportsList.addAll(rstList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return reportsList;
    }

    @Override
    public Map<String, List<String>> getAllSysLogs() throws Exception {
        HashMap<String, List<String>> sysLogMap = new HashMap<String, List<String>>();
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FMServerRif server = null;
        if (references != null) {
            for (ServerReference serverRef : references) {
                try {
                    server = (FMServerRif)this.getReference(webRefMgr, ServerReference.Beans.FMSERVER_BEAN, serverRef);
                    if (server == null) continue;
                    Map<String, List<String>> map = server.getSysLogs();
                    sysLogMap.putAll(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sysLogMap;
    }

    @Override
    public void deleteFiles(File report, String serverIP) throws Exception {
        this.deleteFiles(report, serverIP, true);
    }

    public void deleteFiles(File report, String serverIP, boolean pattern) throws Exception {
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FMServerRif server = null;
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP()) || (server = (FMServerRif)this.getReference(webRefMgr, ServerReference.Beans.FMSERVER_BEAN, serverRef)) == null) continue;
                server.deleteFiles(report, serverIP, pattern);
                return;
            }
        }
    }

    @Override
    public String[][] getPMInfo() throws Exception {
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[][] pmInfos = new String[references == null ? 1 : references.size()][2];
        PMRif pmRif = null;
        int idx = 0;
        if (references != null) {
            for (ServerReference serverRef : references) {
                try {
                    pmRif = (PMRif)this.getReference(webRefMgr, ServerReference.Beans.PM_BEAN, serverRef);
                    if (pmRif == null) continue;
                    pmInfos[idx][0] = serverRef.getServerIP();
                    pmInfos[idx][1] = pmRif.getStatus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    pmInfos[idx] = null;
                    continue;
                }
                ++idx;
            }
        }
        return pmInfos;
    }

    @Override
    public ArrayList<PMRif> getPMRifs() throws Exception {
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PMRif pmRif = null;
        ArrayList<PMRif> pmRifList = new ArrayList<PMRif>();
        if (references != null) {
            for (ServerReference serverRef : references) {
                pmRif = (PMRif)this.getReference(webRefMgr, ServerReference.Beans.PM_BEAN, serverRef);
                if (pmRif == null) {
                    System.err.println("Can find pm reference in server:" + serverRef.getServerIP());
                    continue;
                }
                pmRifList.add(pmRif);
            }
        }
        return pmRifList;
    }

    @Override
    public PMRif getPMByPK(FabricPK fpk) throws Exception {
        String serverIP = FMServerImpl.getInstance().getServerForFabric(fpk);
        PMRif pmRif = this.getPMByIp(serverIP);
        if (pmRif == null && fpk instanceof LanPK) {
            serverIP = GlobalDCManager.getInstance().getServerForLan((LanPK)fpk);
            pmRif = this.getPMByIp(serverIP);
        }
        return pmRif;
    }

    @Override
    public PMRif getPMByIp(String serverIP) throws Exception {
        PMRif pmRif = null;
        serverIP = this.getUnifiedIp(serverIP);
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP())) continue;
                pmRif = (PMRif)this.getReference(webRefMgr, ServerReference.Beans.PM_BEAN, serverRef);
            }
        }
        return pmRif;
    }

    @Override
    public FMServerRif getFmsByIp(String serverIP) throws Exception {
        FMServerRif fmsRif = null;
        serverIP = this.getUnifiedIp(serverIP);
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP())) continue;
                fmsRif = (FMServerRif)this.getReference(webRefMgr, ServerReference.Beans.FMSERVER_BEAN, serverRef);
            }
        }
        return fmsRif;
    }

    @Override
    public IscRif getIscByPK(FabricPK fpk) throws Exception {
        IscRif iscRif = null;
        String serverIP = FMServerImpl.getInstance().getServerForFabric(fpk);
        serverIP = this.getUnifiedIp(serverIP);
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP())) continue;
                iscRif = (IscRif)this.getReference(webRefMgr, ServerReference.Beans.ISC_BEAN, serverRef);
            }
        }
        return iscRif;
    }

    @Override
    public void buildIndex() throws Exception {
        IscRif iscRif = null;
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                iscRif = (IscRif)this.getReference(webRefMgr, ServerReference.Beans.ISC_BEAN, serverRef);
                iscRif.buildIndex();
            }
        }
    }

    @Override
    public TopologyManager getTopologyByPK(FabricPK fpk) throws Exception {
        TopologyManager topologyRif = null;
        String serverIP = FMServerImpl.getInstance().getServerForFabric(fpk);
        serverIP = this.getUnifiedIp(serverIP);
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (int i = 0; i < references.size(); ++i) {
                if (!serverIP.equalsIgnoreCase(references.get(i).getServerIP()) || (topologyRif = (TopologyManager)references.get(i).getRef(ServerReference.Beans.TOPOLOGY_BEAN)) != null) continue;
                topologyRif = (TopologyManager)this.getReference(webRefMgr, ServerReference.Beans.TOPOLOGY_BEAN, references.get(i));
            }
        }
        return topologyRif;
    }

    @Override
    public EMRif getEMByPK(FabricPK fpk) throws Exception {
        String serverIP = FMServerImpl.getInstance().getServerForFabric(fpk);
        return this.getEMByServerIp(serverIP);
    }

    public EMRif getEMBySwitchID(long switchId) throws Exception {
        long lanId = GlobalDCManager.getInstance().getLanDBIDBySwitchDBID(switchId);
        String serverIP = ClusterMapping.getInstance().qIPStrfromFID(lanId);
        return this.getEMByServerIp(serverIP);
    }

    public EMRif getEMByServerIp(String serverIP) throws Exception, RemoteException {
        EMRif emRif = null;
        serverIP = this.getUnifiedIp(serverIP);
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP()) || (emRif = (EMRif)this.getReference(webRefMgr, ServerReference.Beans.EM_BEAN, serverRef)) == null) continue;
                emRif.getSyslogPort();
            }
        }
        return emRif;
    }

    @Override
    public IscRif getIscByIp(String serverIP) throws Exception {
        IscRif iscRif = null;
        serverIP = this.getUnifiedIp(serverIP);
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP())) continue;
                iscRif = (IscRif)this.getReference(webRefMgr, ServerReference.Beans.ISC_BEAN, serverRef);
            }
        }
        return iscRif;
    }

    @Override
    public void executePM(String serverIP, int pmCmd) throws Exception {
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PMRif pmRif = null;
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP()) || (pmRif = (PMRif)this.getReference(webRefMgr, ServerReference.Beans.PM_BEAN, serverRef)) == null) continue;
                try {
                    switch (pmCmd) {
                        case 1: {
                            pmRif.start();
                            break;
                        }
                        case 2: {
                            pmRif.stop();
                            break;
                        }
                        case 3: {
                            pmRif.restart();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return;
            }
        }
    }

    private Object getReference(WebReferenceManager webRefMgr, ServerReference.Beans bean, ServerReference serverRef) throws Exception {
        Object ref = serverRef.getRef(bean);
        if (ref == null) {
            try {
                ref = webRefMgr.reAttach(serverRef.getBindAddr(), bean);
                serverRef.setRef(ref, bean);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (!InetAddress.getLocalHost().getHostAddress().equalsIgnoreCase(serverRef.getServerIP()) && !ServerMonitor.getInstance().isServerActive(InetAddress.getByName(serverRef.getServerIP()))) {
            webRefMgr.removeReference(serverRef);
            throw new Exception("Server:" + serverRef.getServerIP() + " is not active.");
        }
        return ref;
    }

    public void init() {
        WebReferenceManager refMgr = WebReferenceManager.getInstance();
        try {
            refMgr.syncReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<FMServerRif> getFMServers() {
        List<ServerReference> svrRefList = WebReferenceManager.getInstance().getReferences();
        ArrayList<FMServerRif> fmsList = new ArrayList<FMServerRif>();
        for (ServerReference serverReference : svrRefList) {
            fmsList.add((FMServerRif)serverReference.getRef(ServerReference.Beans.FMSERVER_BEAN));
        }
        return fmsList;
    }

    @Override
    public void removeSessionById(int sessionId) throws RemoteException {
        String serverIp = null;
        try {
            serverIp = FMSessionManager.getInstance().getServerIP(sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException("Failed to find session: " + sessionId);
        }
        ServerReference ref = this.getReferenceByIp(serverIp);
        if (ref == null) {
            throw new RemoteException("Can not locate the server. ");
        }
        FMServerRif fmsRif = ref.getServerMgr();
        fmsRif.logOffSessionByID(sessionId);
    }

    private ServerReference getReferenceByIp(String serverIP) {
        List<ServerReference> references = null;
        WebReferenceManager webRefMgr = null;
        try {
            webRefMgr = WebReferenceManager.getInstance();
            references = webRefMgr.getReferences();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (references != null) {
            for (ServerReference serverRef : references) {
                if (!serverIP.equalsIgnoreCase(serverRef.getServerIP())) continue;
                return serverRef;
            }
        }
        return null;
    }

    private String getUnifiedIp(String serverIP) throws Exception {
        String ipAddr = serverIP.contains("0.0.0.0") || serverIP.contains("127.0.0.1") || serverIP.contains("localhost") ? InetAddress.getLocalHost().getHostAddress() : serverIP;
        return ipAddr;
    }

    public List<String> getAllServerNodes() throws RemoteException {
        try {
            return ClusterMapping.getInstance().qALlIPStrings();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public String getServerIpByPK(FabricPK fpk) throws SQLException, UnknownHostException {
        return ClusterMapping.getInstance().qIPStrfromFID(fpk._fid);
    }

    public String getServerIpByFabricDBID(long fDbID) throws SQLException, UnknownHostException {
        return ClusterMapping.getInstance().qIPStrfromFDBID(fDbID);
    }

    static class MyFileFilter
    implements FileFilter {
        private String _pattern;

        MyFileFilter(String pattern) {
            this._pattern = pattern;
        }

        @Override
        public boolean accept(File file) {
            if (this._pattern == null) {
                return true;
            }
            if (file == null || !file.exists()) {
                return false;
            }
            return file.getAbsolutePath().indexOf(this._pattern) >= 0;
        }
    }
}

