/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.cfgdelivery;

import com.cisco.dcbu.dcm.common.Cloner;
import com.cisco.dcbu.dcm.model.AppException;
import com.cisco.dcbu.dcm.model.InstanceNameId;
import com.cisco.dcbu.dcm.model.InternalServerException;
import com.cisco.dcbu.dcm.model.PersistentManagedElement;
import com.cisco.dcbu.dcm.model.cfgdelivery.ConfigDeliveryTask;
import com.cisco.dcbu.dcm.model.cfgdelivery.ConfigDeliveryTaskDeviceDetails;
import com.cisco.dcbu.dcm.model.cfgdelivery.TemplateConfigDeliveryTask;
import com.cisco.dcbu.dcm.model.cfgdelivery.util.CfgDeliveryInstanceNameHelper;
import com.cisco.dcbu.dcm.model.cfgdelivery.util.CfgDeliveryValidationHelper;
import com.cisco.dcbu.dcm.model.cfgtemplate.ConfigTemplate;
import com.cisco.dcbu.dcm.model.datatype.IpAddress;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskDeliveryOrderSetting;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskRollbackSetting;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskSourceType;
import com.cisco.dcbu.dcm.model.enumkind.ConfigDeliveryTaskStatus;
import com.cisco.dcbu.dcm.model.util.TopObjectHelper;
import com.cisco.dcbu.jaxws.san.wo.ConfigDeliveryTaskDO;
import com.cisco.dcbu.jaxws.san.wo.ConfigDeliveryTaskDeviceDO;
import com.cisco.dcbu.jaxws.san.wo.ConfigDeliveryTaskDeviceDetailsDO;
import com.cisco.dcbu.jaxws.san.wo.InstanceNameIdDO;
import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.san.wo.TemplateConfigDeliveryTaskDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.type.PlatformType;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryHelper;
import com.cisco.dcbu.sm.server.web.cfgdelivery.ConfigDeliveryJobController;
import com.cisco.dcbu.sm.server.web.cfgtemplates.ConfigTemplateHandler;
import com.cisco.dcbu.sm.server.web.inventory.SwitchHandler;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.lan.persister.CommonSessionPersisterFactory;
import com.cisco.dcbu.sm.server.web.lan.persister.SessionPersister;
import com.cisco.dcbu.sm.server.web.lan.persister.Transaction;
import com.cisco.dcbu.sm.server.web.lan.util.ExceptionHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.proxy.HibernateProxy;

public class ConfigDeliveryHandler {
    String templateFilesFolder;
    private Logger log = LogManager.getLogger((String)"fms");
    private static ConfigDeliveryHandler _Instance = null;
    List<ConfigTemplate> templates = new ArrayList<ConfigTemplate>();
    private Map<String, String> _FilterHash;
    private Map<String, String> _FilterValues;

    public static ConfigDeliveryHandler getInstance() {
        if (_Instance == null) {
            _Instance = new ConfigDeliveryHandler();
        }
        return _Instance;
    }

    private ConfigDeliveryHandler() {
        ConfigTemplateHandler.getInstance();
        this._FilterHash = new HashMap<String, String>();
        this._FilterValues = new HashMap<String, String>();
        this.initSqlSortSuffix();
    }

    private void initSqlSortSuffix() {
        this._FilterHash.put("jobId", "eq");
        this._FilterHash.put("configDeliveryTaskStatus", "eq");
        this._FilterHash.put("description", "like");
        this._FilterHash.put("deviceLabels", "custom");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableSingleton() {
        ConfigDeliveryJobController.INSTANCE.initialize();
        try (SessionPersister readOnlySession = CommonSessionPersisterFactory.INSTANCE.openReadOnlySession();){
            List listOfTask = readOnlySession.createCriteria(ConfigDeliveryTask.class).add((Criterion)Restrictions.eq((String)"taskEnabled", (Object)Boolean.TRUE)).add((Criterion)Restrictions.eq((String)"configDeliveryTaskStatus", (Object)ConfigDeliveryTaskStatus.NOT_STARTED)).setFetchMode("configDeliveryTaskDeviceDetailsCol", FetchMode.JOIN).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
            for (ConfigDeliveryTask configDeliveryTask : listOfTask) {
                this.deliverCommandsToDevices(configDeliveryTask);
            }
        }
    }

    public void disableSingleton() {
        ConfigDeliveryJobController.INSTANCE.cleanup();
    }

    public List<ConfigTemplate> getAllTemplates() {
        return this.templates;
    }

    public ConfigDeliveryTask getConfigDeliveryTaskFromDO(ConfigDeliveryTaskDO taskDO, boolean isCreate) {
        if (taskDO.getConfigDeliveryTaskSourceType().equals(ConfigDeliveryTaskSourceType.TEMPLATE.getKeyword())) {
            TemplateConfigDeliveryTask task = new TemplateConfigDeliveryTask();
            if (!isCreate && taskDO.getInstanceClassId() != -1) {
                task.setInstanceClassId(Long.getLong(taskDO.getInstanceClassId() + ""));
            }
            if (!isCreate && taskDO.getInstanceName() != null) {
                task.setInstanceName(taskDO.getInstanceName());
            }
            if (!isCreate && taskDO.getCreatedTime() != -1L) {
                task.setCreatedTime(new Timestamp(taskDO.getCreatedTime()));
            }
            if (!isCreate && taskDO.getEndTime() != -1L) {
                task.setEndTime(new Timestamp(taskDO.getEndTime()));
            }
            if (!isCreate && taskDO.getStartTime() != -1L) {
                task.setStartTime(new Timestamp(taskDO.getStartTime()));
            }
            if (taskDO.getScheduledTime() != -1L) {
                try {
                    task.setScheduledTime(new Timestamp(this.convertUtcToLocalTime(taskDO.getScheduledTime())));
                }
                catch (ParseException e) {
                    this.log.error((Object)"Error parsing Config delivery job schedule time. Setting default provided.", (Throwable)e);
                    task.setScheduledTime(new Timestamp(taskDO.getScheduledTime()));
                }
            }
            task.setDescription(taskDO.getDescription());
            if (!isCreate && taskDO.getProgress() != -1) {
                task.setProgress(taskDO.getProgress());
            }
            if (taskDO.getTimeout() != null) {
                task.setTimeout(taskDO.getTimeout());
            } else {
                task.setTimeout(new Integer(ConfigDeliveryJobController.DEFAULT_CLI_TIMEOUT));
            }
            task.setTaskEnabled(taskDO.getTaskEnabled());
            task.setConfigDeliveryTaskDeliveryOrderSetting(ConfigDeliveryTaskDeliveryOrderSetting.getInstance((String)taskDO.getConfigDeliveryTaskDeliveryOrderSetting()));
            if (taskDO.getConfigDeliveryTaskDeviceDetailsCol() != null && taskDO.getConfigDeliveryTaskDeviceDetailsCol().length > 0) {
                for (ConfigDeliveryTaskDeviceDetailsDO detailsDO : taskDO.getConfigDeliveryTaskDeviceDetailsCol()) {
                    ConfigDeliveryTaskDeviceDetails details = this.getConfigDeliveryTaskDeviceDetailsFromDO(detailsDO, isCreate);
                    task.addConfigDeliveryTaskDeviceDetails(details);
                    String[] paramNames = ((TemplateConfigDeliveryTaskDO)taskDO).getParamNames();
                    if (paramNames == null || paramNames.length <= 0 || detailsDO.getParamValues() == null || detailsDO.getParamValues().length <= 0) continue;
                    int idx = 0;
                    HashMap<String, String> rows = new HashMap<String, String>();
                    for (String paramName : paramNames) {
                        rows.put(paramName, detailsDO.getParamValues()[idx++]);
                    }
                    TemplateConfigDeliveryTask.addTemplateRow(rows, (ConfigDeliveryTaskDeviceDetails)details);
                }
            }
            task.setSourceTemplate(((TemplateConfigDeliveryTaskDO)taskDO).getSourceTemplate());
            if (((TemplateConfigDeliveryTaskDO)taskDO).getConfigTemplateRef() != null) {
                task.setConfigTemplateRef(((TemplateConfigDeliveryTaskDO)taskDO).getConfigTemplateRef());
            }
            task.setConfigDeliveryTaskRollbackSetting(ConfigDeliveryTaskRollbackSetting.getInstance((String)taskDO.getConfigDeliveryTaskRollbackSetting()));
            task.setConfigDeliveryTaskSourceType(ConfigDeliveryTaskSourceType.getInstance((String)taskDO.getConfigDeliveryTaskSourceType()));
            task.setConfigDeliveryTaskStatus(ConfigDeliveryTaskStatus.getInstance((String)taskDO.getConfigDeliveryTaskStatus()));
            task.setIsCopyRunToStartTask(taskDO.getIsCopyRunToStartTask());
            task.setUserName(taskDO.getUserName());
            String temp = taskDO.getPassword();
            if (temp != null) {
                try {
                    task.setPassword(StringEncrypter.DESedeEncrypt(temp));
                }
                catch (Exception e) {
                    this.log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            if ((temp = taskDO.getEnablePassword()) != null && temp.trim().length() > 0) {
                try {
                    task.setEnablePwd(StringEncrypter.DESedeEncrypt(temp));
                }
                catch (Exception e) {
                    this.log.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            return task;
        }
        return null;
    }

    public ConfigDeliveryTaskDeviceDetails getConfigDeliveryTaskDeviceDetailsFromDO(ConfigDeliveryTaskDeviceDetailsDO detailsDO, boolean isCreate) {
        ConfigDeliveryTaskDeviceDetails details = new ConfigDeliveryTaskDeviceDetails();
        if (detailsDO.getConfigCommands() != null) {
            details.setConfigCommands(new StringBuilder(detailsDO.getConfigCommands()));
        }
        details.setFailureCause(new StringBuilder(detailsDO.getFailureCause()));
        if (detailsDO.getFailedCommands() != null) {
            details.setFailedCommands(new StringBuilder(detailsDO.getFailedCommands()));
        }
        details.setConfigDeliveryTaskDeviceStatus(detailsDO.getConfigDeliveryTaskDeviceStatus());
        details.setIpAddress(IpAddress.getAddress((String)detailsDO.getIpAddress()));
        if (!isCreate && detailsDO.getInstanceClassId() != -1) {
            details.setInstanceClassId(Long.valueOf(Long.parseLong(detailsDO.getInstanceClassId() + "")));
        }
        if (!isCreate && detailsDO.getInstanceName() != null) {
            details.setInstanceName(detailsDO.getInstanceName());
        }
        return details;
    }

    public List<ConfigDeliveryTask> getConfigDeliveryTasksFromDOs(ConfigDeliveryTaskDO[] taskDOArr, boolean isCreate) {
        ArrayList<ConfigDeliveryTask> taskList = new ArrayList<ConfigDeliveryTask>();
        ConfigDeliveryTask task = null;
        for (ConfigDeliveryTaskDO taskDO : Arrays.asList(taskDOArr)) {
            task = this.getConfigDeliveryTaskFromDO(taskDO, isCreate);
            if (task == null) continue;
            taskList.add(task);
        }
        return taskList;
    }

    public InstanceNameIdDO createConfigDeliveryTask(ConfigDeliveryTaskDO taskDO) throws AppException {
        InstanceNameIdDO retVal = null;
        ArrayList paramValues = new ArrayList();
        Object deviceValues = null;
        if (taskDO == null || taskDO.getConfigDeliveryTaskDeviceDetailsCol() == null || taskDO.getConfigDeliveryTaskDeviceDetailsCol().length == 0) {
            return null;
        }
        ConfigDeliveryTaskDO[] taskDOCol = new ConfigDeliveryTaskDO[]{taskDO};
        List<InstanceNameId> idList = this.createConfigDeliveryTasksInternal(this.getConfigDeliveryTasksFromDOs(taskDOCol, true), taskDO.getUserName(), taskDO.getPassword(), taskDO.getEnablePassword());
        InstanceNameIdDO idDO = null;
        for (InstanceNameId id : idList) {
            idDO = new InstanceNameIdDO();
            idDO.setInstanceClassId(id.getInstanceClassId().intValue());
            idDO.setInstanceName(id.getInstanceName());
            retVal = idDO;
        }
        return retVal;
    }

    private List<InstanceNameId> createConfigDeliveryTasksInternal(List<ConfigDeliveryTask> tasks, String userName, String password, String enablePwd) throws InternalServerException, AppException {
        SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();
        Transaction transaction = null;
        ArrayList<InstanceNameId> nameIds = new ArrayList<InstanceNameId>();
        try {
            transaction = session.beginTransaction();
            for (ConfigDeliveryTask task : tasks) {
                CfgDeliveryValidationHelper.validateConfigDeliveryTaskCreation((ConfigDeliveryTask)task, (boolean)true);
                if (ConfigDeliveryTaskSourceType.TEMPLATE.equals((Object)task.getConfigDeliveryTaskSourceType())) {
                    ConfigTemplate template;
                    TemplateConfigDeliveryTask templateTask = (TemplateConfigDeliveryTask)task;
                    if (templateTask.getSourceTemplate() == null) {
                        templateTask.setSourceTemplate(templateTask.getConfigTemplateRef().getName());
                    }
                    if ((template = (ConfigTemplate)session.createCriteria(ConfigTemplate.class).add((Criterion)Restrictions.eq((String)"instanceClassId", (Object)templateTask.getConfigTemplateRef().getInstanceClassId())).uniqueResult()) != null && template.getContent() != null) {
                        templateTask.getConfigTemplateRef().setContent(template.getContent());
                    }
                }
                List cfgDeliveryTaskDevDetailsCol = task.getConfigDeliveryTaskDeviceDetailsCol();
                task.setInstanceName(CfgDeliveryInstanceNameHelper.buildConfigDeliveryTaskInstanceName(task.getClass(), (Long)((Long)session.save(task))));
                for (ConfigDeliveryTaskDeviceDetails configDeliveryTaskDeviceDetails : cfgDeliveryTaskDevDetailsCol) {
                    configDeliveryTaskDeviceDetails.setInstanceName(CfgDeliveryInstanceNameHelper.buildConfigDeliveryTaskDetailsInstanceName((String)configDeliveryTaskDeviceDetails.getIpAddress().toString(), (ConfigDeliveryTask)task));
                    this.log.info((Object)("saving details obj with instance name : " + configDeliveryTaskDeviceDetails.getInstanceName()));
                    configDeliveryTaskDeviceDetails.setConfigDeliveryTaskRef(task);
                }
                task.setProgress(Integer.valueOf(0));
                nameIds.add(task.buildInstanceNameId());
                task.setCreatedTime(new Timestamp(System.currentTimeMillis()));
            }
            List copiedTasks = (List)Cloner.deepClone(tasks);
            for (ConfigDeliveryTask configDeliveryTask : tasks) {
                this.writeConfigCommands(configDeliveryTask);
            }
            transaction.commit();
            for (ConfigDeliveryTask configDeliveryTask : copiedTasks) {
                if (configDeliveryTask.getTaskEnabled() == null || !configDeliveryTask.getTaskEnabled().booleanValue()) continue;
                this.deliverCommandsToDevices(configDeliveryTask);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            this.log.error((Object)e.getMessage());
            if (!(e instanceof AppException)) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw ExceptionHelper.internalServerException(e);
            }
            throw (AppException)e;
        }
        finally {
            session.close();
        }
        return nameIds;
    }

    public void handleRunTimeException(org.hibernate.Transaction tx, Exception e) throws AppException {
        this.rollback(tx);
        this.handleException(e);
    }

    public void handleException(Exception e) throws AppException {
        if (!(e instanceof AppException)) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw ExceptionHelper.internalServerException(e);
        }
        throw (AppException)e;
    }

    public void rollback(org.hibernate.Transaction tx) {
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
    }

    public void deleteConfigDeliveryTasksAssociatedWithTemplate(InstanceNameId templateId) throws Exception {
        SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();
        ArrayList<InstanceNameId> deletedTaskIds = new ArrayList<InstanceNameId>();
        ArrayList events = new ArrayList();
        List tasks = session.createCriteria(ConfigDeliveryTask.class).list();
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        for (ConfigDeliveryTask task : tasks) {
            if (!ConfigDeliveryTaskSourceType.TEMPLATE.equals((Object)task.getConfigDeliveryTaskSourceType())) continue;
            TemplateConfigDeliveryTask dTask = null;
            dTask = task instanceof HibernateProxy ? (TemplateConfigDeliveryTask)((HibernateProxy)task).getHibernateLazyInitializer().getImplementation() : (TemplateConfigDeliveryTask)task;
            ConfigTemplate template = dTask.getConfigTemplateRef();
            if (template == null || !templateId.equals((Object)template.buildInstanceNameId())) continue;
            deletedTaskIds.add(dTask.buildInstanceNameId());
        }
        if (deletedTaskIds.size() > 0) {
            this.deleteConfigDeliveryTasks(session, deletedTaskIds);
        }
        session.close();
    }

    private void deleteConfigDeliveryTasks(SessionPersister session, List<InstanceNameId> taskIds) throws AppException {
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            ArrayList<Long> listOfIds = new ArrayList<Long>();
            for (InstanceNameId instanceNameId : taskIds) {
                listOfIds.add(instanceNameId.getInstanceClassId());
            }
            List listOfTasks = session.createCriteria(ConfigDeliveryTask.class).add(Restrictions.in((String)"instanceClassId", listOfIds)).list();
            for (ConfigDeliveryTask configDeliveryTask : listOfTasks) {
                List configDeliveryTaskDeviceDetailsCol = configDeliveryTask.getConfigDeliveryTaskDeviceDetailsCol();
                session.delete(configDeliveryTask);
                for (ConfigDeliveryTaskDeviceDetails cfgDeliTaskDevDetail : configDeliveryTaskDeviceDetailsCol) {
                    TopObjectHelper.clearAssociations((PersistentManagedElement)cfgDeliTaskDevDetail, null, (boolean)true);
                }
                TopObjectHelper.clearAssociations((PersistentManagedElement)configDeliveryTask, null, (boolean)true);
            }
            transaction.commit();
            for (ConfigDeliveryTask configDeliveryTask : listOfTasks) {
                if (configDeliveryTask.getScheduledTime() != null) {
                    ConfigDeliveryJobController.INSTANCE.deleteConfigDeliveryJobSchedule(configDeliveryTask);
                }
                this.deleteConfigCommands(configDeliveryTask);
            }
        }
        catch (Exception e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            this.log.error((Object)e.getMessage());
            if (!(e instanceof AppException)) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw ExceptionHelper.internalServerException(e);
            }
            throw (AppException)e;
        }
    }

    public void deleteConfigCommands(ConfigDeliveryTask task) throws Exception {
    }

    public void readConfigCommands(ConfigDeliveryTask task) throws Exception {
        String[] cmdLines;
        if (task.getInstanceClassId() == null) {
            this.log.warn((Object)"Given task object does not have instance class id populated.");
            return;
        }
        if (task.getConfigDeliveryTaskDeviceDetailsCol().size() == 0) {
            this.log.warn((Object)"Given task object does not have target device details populated.");
            return;
        }
        HashMap<String, StringBuffer> cmdsMap = new HashMap<String, StringBuffer>();
        String currentDevice = null;
        StringBuffer currentBuffer = new StringBuffer();
        StringBuilder rdr = task.getAllCommandsStr();
        if (rdr == null || rdr.toString().trim().equals("")) {
            return;
        }
        for (String line : cmdLines = rdr.toString().split("\n")) {
            if (line.startsWith("[]")) {
                if (currentDevice != null) {
                    cmdsMap.put(currentDevice, currentBuffer);
                }
                currentDevice = null;
                currentBuffer = new StringBuffer();
                continue;
            }
            if (line.startsWith("[")) {
                currentDevice = line.substring(1, line.indexOf("]"));
                continue;
            }
            currentBuffer.append(line);
            currentBuffer.append("\n");
        }
        for (ConfigDeliveryTaskDeviceDetails details : task.getConfigDeliveryTaskDeviceDetailsCol()) {
            int idxOfEndCurlyBrace;
            StringBuffer cmds = (StringBuffer)cmdsMap.get(details.getIpAddress().toString());
            if (cmds == null) continue;
            int idxOfOpenCurlyBrace = cmds.lastIndexOf("{{");
            if (idxOfOpenCurlyBrace > -1 && (idxOfEndCurlyBrace = cmds.indexOf("}}", idxOfOpenCurlyBrace)) > -1) {
                details.setFailedCommands(new StringBuilder(cmds.substring(idxOfOpenCurlyBrace + 2, idxOfEndCurlyBrace)));
                cmds.delete(idxOfOpenCurlyBrace, idxOfEndCurlyBrace + 2);
            }
            details.appendConfigCommandsAsArray(cmds.toString().split("\n"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigCommands(Long taskId, ConfigDeliveryTaskDeviceDetails details, ConfigDeliveryTask task) throws Exception {
        ConfigDeliveryHandler configDeliveryHandler = this;
        synchronized (configDeliveryHandler) {
            String[] cmdLines;
            HashMap<String, StringBuffer> cmdsMap = new HashMap<String, StringBuffer>();
            String currentDevice = null;
            StringBuffer currentBuffer = new StringBuffer();
            StringBuilder rdr = task.getAllCommandsStr();
            for (String line : cmdLines = rdr.toString().split("\n")) {
                if (line.startsWith("[]")) {
                    if (currentDevice != null) {
                        cmdsMap.put(currentDevice, currentBuffer);
                    }
                    currentDevice = null;
                    currentBuffer = new StringBuffer();
                    continue;
                }
                if (line.startsWith("[")) {
                    currentDevice = line.substring(1, line.indexOf("]"));
                    continue;
                }
                currentBuffer.append(line);
                currentBuffer.append("\n");
            }
            String ipAddress = details.getIpAddress() != null ? details.getIpAddress().toString() : "";
            StringBuilder writer = new StringBuilder();
            for (String ipAdd : cmdsMap.keySet()) {
                if (ipAdd.equals(ipAddress)) {
                    writer.append("[");
                    writer.append(details.getIpAddress().toString());
                    writer.append("]\n");
                    if (details.fetchConfigCommandsAsArray() != null && details.fetchConfigCommandsAsArray().length > 0) {
                        for (String cmd : details.fetchConfigCommandsAsArray()) {
                            writer.append(cmd);
                            writer.append("\n");
                        }
                    }
                    if (details.getFailedCommands() != null) {
                        writer.append("{{");
                        writer.append((CharSequence)details.getFailedCommands());
                        writer.append("}}\n");
                    }
                    writer.append("[]\n");
                    continue;
                }
                writer.append("[");
                writer.append(ipAdd);
                writer.append("]\n");
                writer.append(((StringBuffer)cmdsMap.get(ipAdd)).toString());
                writer.append("[]\n");
            }
            task.setAllCommandsStr(writer);
        }
    }

    public void deliverCommandsToDevices(ConfigDeliveryTask task) throws Exception {
        if (task.getScheduledTime() == null) {
            ConfigDeliveryJobController.INSTANCE.executeDeliveryJobs(task);
        } else {
            ConfigDeliveryJobController.INSTANCE.scheduleConfigDeliveryJob(task);
        }
    }

    public void writeConfigCommands(ConfigDeliveryTask task) throws Exception {
        if (task.getInstanceClassId() == null) {
            this.log.warn((Object)"Given task object does not have instance class id populated.");
            return;
        }
        if (task.getConfigDeliveryTaskDeviceDetailsCol().size() == 0) {
            this.log.warn((Object)"Given task object does not have target device details populated.");
            return;
        }
        StringBuilder writer = new StringBuilder();
        for (ConfigDeliveryTaskDeviceDetails details : task.getConfigDeliveryTaskDeviceDetailsCol()) {
            writer.append("[");
            writer.append(details.getIpAddress().toString());
            writer.append("]\n");
            if (details.fetchConfigCommandsAsArray() != null && details.fetchConfigCommandsAsArray().length > 0) {
                for (String cmd : details.fetchConfigCommandsAsArray()) {
                    writer.append(cmd);
                    writer.append("\n");
                }
            }
            if (details.getFailedCommands() != null && details.getFailedCommands().toString().trim().length() != 0) {
                writer.append("{{");
                writer.append((CharSequence)details.getFailedCommands());
                writer.append("}}");
            }
            writer.append("[]\n");
        }
        task.setAllCommandsStr(writer);
    }

    public void writeConfigCommands(Long taskId, ConfigDeliveryTaskDeviceDetails details) throws Exception {
        StringBuilder writer = new StringBuilder();
        writer.append("[");
        writer.append(details.getIpAddress().toString());
        writer.append("]\n");
        if (details.fetchConfigCommandsAsArray() != null && details.fetchConfigCommandsAsArray().length > 0) {
            for (String cmd : details.fetchConfigCommandsAsArray()) {
                writer.append(cmd);
                writer.append("\n");
            }
        }
        if (details.getFailedCommands() != null) {
            writer.append("{{");
            writer.append((CharSequence)details.getFailedCommands());
            writer.append("}}");
        }
        writer.append("[]\n");
    }

    public void deleteConfigDeliveryTasksAssociatedWithNe(String ipAddr) throws Exception {
        SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();
        ArrayList<InstanceNameId> deletedTaskIds = new ArrayList<InstanceNameId>();
        List tasks = session.createCriteria(ConfigDeliveryTask.class).list();
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        block0: for (ConfigDeliveryTask task : tasks) {
            if (task.getConfigDeliveryTaskDeviceDetailsCol() == null || task.getConfigDeliveryTaskDeviceDetailsCol().size() == 0) continue;
            for (ConfigDeliveryTaskDeviceDetails details : task.getConfigDeliveryTaskDeviceDetailsCol()) {
                if (!ipAddr.equals(details.getIpAddress().toString())) continue;
                this.unbindTargetDeviceDetails(session, task.buildInstanceNameId(), details);
                continue block0;
            }
        }
        if (deletedTaskIds.size() > 0) {
            this.deleteConfigDeliveryTasks(session, deletedTaskIds);
        }
        session.close();
    }

    private void unbindTargetDeviceDetails(SessionPersister session, InstanceNameId configDeliveryTaskId, ConfigDeliveryTaskDeviceDetails details) throws AppException {
        Transaction transaction = null;
        try {
            transaction = session.beginTransaction();
            ConfigDeliveryTask task = (ConfigDeliveryTask)session.getByNameId(configDeliveryTaskId);
            details.setConfigDeliveryTaskRef(task);
            ConfigDeliveryTaskDeviceDetails perDetails = (ConfigDeliveryTaskDeviceDetails)session.getByNameId(details.buildInstanceNameId());
            session.delete(perDetails);
            task.removeConfigDeliveryTaskDeviceDetails(perDetails);
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            this.log.error((Object)e.getMessage());
            if (!(e instanceof AppException)) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw ExceptionHelper.internalServerException(e);
            }
            throw (AppException)e;
        }
    }

    public void deleteConfigDeliveryTasks(List<InstanceNameIdDO> taskInstanceNameIdDOCol) throws AppException {
        ArrayList<InstanceNameId> templateInstanceNameIdCol = new ArrayList<InstanceNameId>();
        InstanceNameId id = null;
        for (InstanceNameIdDO idDO : taskInstanceNameIdDOCol) {
            id = new InstanceNameId(idDO.getInstanceName(), Long.valueOf(Long.parseLong(idDO.getInstanceClassId() + "")));
            templateInstanceNameIdCol.add(id);
        }
        this._deleteConfigDeliveryTasks(templateInstanceNameIdCol);
    }

    public void _deleteConfigDeliveryTasks(List<InstanceNameId> taskIds) throws AppException {
        Transaction transaction = null;
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            transaction = session.beginTransaction();
            ArrayList<Long> listOfIds = new ArrayList<Long>();
            for (InstanceNameId instanceNameId : taskIds) {
                listOfIds.add(instanceNameId.getInstanceClassId());
            }
            List listOfTasks = session.createCriteria(ConfigDeliveryTask.class).add(Restrictions.in((String)"instanceClassId", listOfIds)).list();
            for (ConfigDeliveryTask configDeliveryTask : listOfTasks) {
                List configDeliveryTaskDeviceDetailsCol = configDeliveryTask.getConfigDeliveryTaskDeviceDetailsCol();
                session.delete(configDeliveryTask);
                for (ConfigDeliveryTaskDeviceDetails cfgDeliTaskDevDetail : configDeliveryTaskDeviceDetailsCol) {
                    TopObjectHelper.clearAssociations((PersistentManagedElement)cfgDeliTaskDevDetail, null, (boolean)true);
                }
                TopObjectHelper.clearAssociations((PersistentManagedElement)configDeliveryTask, null, (boolean)true);
            }
            transaction.commit();
            for (ConfigDeliveryTask configDeliveryTask : listOfTasks) {
                if (configDeliveryTask.getScheduledTime() != null) {
                    ConfigDeliveryJobController.INSTANCE.deleteConfigDeliveryJobSchedule(configDeliveryTask);
                }
                this.deleteConfigCommands(configDeliveryTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigDeliveryTaskDO> getAllConfigDeliveryTasks(DbFilterDO dbFilter, String status, int startIdx, int recordSize) throws AppException {
        SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();
        List<ConfigDeliveryTask> cfgDeliveryTasks = new ArrayList<ConfigDeliveryTask>();
        try {
            List<ConfigDeliveryTask> _tasks = this.getAllConfigDeliveryTasksBeforPaginating(dbFilter, session);
            if (_tasks == null) {
                List<ConfigDeliveryTaskDO> list = this.getConfigDeliveryTaskDOs(cfgDeliveryTasks);
                return list;
            }
            cfgDeliveryTasks = _tasks.subList(startIdx, startIdx + recordSize > _tasks.size() ? _tasks.size() : startIdx + recordSize);
            for (ConfigDeliveryTask configDeliveryTask : cfgDeliveryTasks) {
                if (configDeliveryTask instanceof TemplateConfigDeliveryTask) {
                    String templateName = ((TemplateConfigDeliveryTask)configDeliveryTask).getSourceTemplate();
                    ((TemplateConfigDeliveryTask)configDeliveryTask).setConfigTemplateRef(this.getConfigTemplate(templateName));
                }
                configDeliveryTask.setConfigDeliveryTaskDeviceDetailsCol(this.getTargetDeviceDetails(configDeliveryTask.buildInstanceNameId()));
            }
        }
        catch (RuntimeException re) {
            this.handleRunTimeException(session.getTransaction(), re);
        }
        finally {
            session.close();
            this._FilterValues.clear();
        }
        return this.getConfigDeliveryTaskDOs(cfgDeliveryTasks);
    }

    private List<ConfigDeliveryTask> getAllConfigDeliveryTasksBeforPaginating(DbFilterDO dbFilter, SessionPersister session) {
        String queryStr = "select {TASK.*} from san_ConfigDeliveryTask TASK where TASK.instancename IS NOT NULL";
        queryStr = this.getQueryStr(dbFilter.getColFilterStr(), queryStr);
        if (dbFilter.getSortField() != null && !dbFilter.getSortField().trim().equalsIgnoreCase("")) {
            if (dbFilter.getSortField().trim().equalsIgnoreCase("jobId")) {
                dbFilter.setSortField("instanceclassId");
            }
            queryStr = dbFilter.getSortType() != null && dbFilter.getSortType().trim().equalsIgnoreCase("DESC") ? queryStr.concat(" order by " + dbFilter.getSortField().trim() + " DESC") : queryStr.concat(" order by " + dbFilter.getSortField().trim());
        }
        SQLQuery query = session.createSQLQuery(queryStr);
        query.addEntity("TASK", ConfigDeliveryTask.class);
        List _tasks = query.list();
        return _tasks;
    }

    private String getQueryStr(String colFilterStr, String queryStr) {
        if (colFilterStr != null && colFilterStr.length() > 0 && queryStr != null) {
            String[] pairs = colFilterStr.split(";");
            for (int i = 0; i < pairs.length; ++i) {
                String item = pairs[i];
                String key = item.split(":")[0].trim();
                String vlu = item.split(":")[1].trim();
                if (vlu.equals("")) continue;
                if (key.equalsIgnoreCase("jobId")) {
                    queryStr = queryStr.concat(" and TASK.instanceclassId ='" + vlu.trim() + "' ");
                } else if (key.equalsIgnoreCase("description")) {
                    queryStr = queryStr.concat(" and TASK.description like '%" + vlu.trim() + "%' ");
                } else if (key.equalsIgnoreCase("configDeliveryTaskStatus")) {
                    if (vlu.toLowerCase().equalsIgnoreCase("all")) continue;
                    queryStr = queryStr.concat(" and TASK.configdeliverytaskstatus='" + ConfigDeliveryTaskStatus.getInstance((String)vlu).getOrdinal() + "' ");
                } else if (key.equalsIgnoreCase("deviceLabels")) {
                    if (vlu.trim().equalsIgnoreCase("All") || vlu.trim().equalsIgnoreCase("")) continue;
                    queryStr = queryStr.concat(" and TASK.instanceclassid in(select distinct san_cfgdeliverytask_id from san_ConfDelTaskDevDetails where ipaddress like '%" + vlu.trim() + "%') ");
                } else if (key.equalsIgnoreCase("configtemplate_id")) {
                    if (vlu == null || vlu.trim().equalsIgnoreCase("")) continue;
                    queryStr = queryStr.concat(" and TASK.configtemplate_id ='" + vlu.trim() + "' ");
                }
                this._FilterValues.put(key, vlu);
            }
        }
        return queryStr;
    }

    public static void main(String[] a) {
        String filterStr = "jobId:3;configDeliveryTaskStatus:failed;description:vlan;deviceLabels:abc;";
        String queryStr = "select * from san_ConfigDeliveryTask TASK where TASK.instancename IS NOT NULL";
        System.out.println(ConfigDeliveryHelper.isCopyRunCmd("copy ru st"));
    }

    private Criteria getQueryCriteria(String colFilterStr, Criteria crit) {
        if (colFilterStr != null && colFilterStr.length() > 0 && crit != null) {
            String[] pairs = colFilterStr.split(";");
            for (int i = 0; i < pairs.length; ++i) {
                String item = pairs[i];
                String key = item.split(":")[0];
                String vlu = item.split(":")[1];
                if (this._FilterHash.containsKey(key)) {
                    if (this._FilterHash.get(key) == "like") {
                        crit.add((Criterion)Restrictions.like((String)key, (Object)("%" + vlu + "%")));
                    } else if (this._FilterHash.get(key) == "eq") {
                        if (key.equalsIgnoreCase("jobId")) {
                            crit.add((Criterion)Restrictions.eq((String)"instanceClassId", (Object)Long.parseLong(vlu)));
                        } else if (key.equalsIgnoreCase("configDeliveryTaskStatus")) {
                            if (vlu.trim().equalsIgnoreCase("All") || vlu.trim().equalsIgnoreCase("")) continue;
                            crit.add((Criterion)Restrictions.eq((String)key, (Object)ConfigDeliveryTaskStatus.getInstance((String)vlu)));
                        } else {
                            crit.add((Criterion)Restrictions.eq((String)key, (Object)vlu));
                        }
                    }
                }
                this._FilterValues.put(key, vlu);
            }
        }
        return crit;
    }

    private List<ConfigDeliveryTaskDO> getConfigDeliveryTaskDOs(List<ConfigDeliveryTask> cfgDeliveryTasks) {
        ArrayList<ConfigDeliveryTaskDO> retCol = new ArrayList<ConfigDeliveryTaskDO>();
        ConfigDeliveryTaskDO taskDO = null;
        for (ConfigDeliveryTask task : cfgDeliveryTasks) {
            taskDO = this.getConfigDeliveryTaskDO(task);
            if (taskDO == null) continue;
            retCol.add(taskDO);
        }
        return retCol;
    }

    private ConfigDeliveryTaskDO getConfigDeliveryTaskDO(ConfigDeliveryTask task) {
        ConfigDeliveryTaskDO taskDO = new ConfigDeliveryTaskDO();
        taskDO.setDescription(task.getDescription());
        taskDO.setIsCopyRunToStartTask(task.getIsCopyRunToStartTask());
        taskDO.setProgress(task.getProgress());
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getRawOffset();
        String timeDiffUTC = String.format("UTC %s%02d:%02d", offset >= 0 ? "+" : "", offset / 3600000, offset / 60000 % 60);
        if (task.getStartTime() != null) {
            taskDO.setStartTime(task.getStartTime().getTime());
            taskDO.setStartTimeStr(SnmpTimeticks.getDateFormat().format(task.getStartTime().getTime()) + " " + timeDiffUTC);
        }
        if (task.getEndTime() != null) {
            taskDO.setEndTime(task.getEndTime().getTime());
            taskDO.setEndTimeStr(SnmpTimeticks.getDateFormat().format(task.getEndTime().getTime()) + " " + timeDiffUTC);
        }
        if (task.getScheduledTime() != null) {
            taskDO.setScheduledTime(task.getScheduledTime().getTime());
            taskDO.setScheduledTimeStr(SnmpTimeticks.getDateFormat().format(task.getScheduledTime().getTime()) + " " + timeDiffUTC);
        }
        if (task.getCreatedTime() != null) {
            taskDO.setCreatedTime(task.getCreatedTime().getTime());
            taskDO.setCreatedTimeStr(SnmpTimeticks.getDateFormat().format(task.getCreatedTime().getTime()) + " " + timeDiffUTC);
        }
        taskDO.setConfigDeliveryTaskDeliveryOrderSetting(task.getConfigDeliveryTaskDeliveryOrderSetting().getKeyword());
        taskDO.setConfigDeliveryTaskRollbackSetting(task.getConfigDeliveryTaskRollbackSetting().getKeyword());
        taskDO.setConfigDeliveryTaskSourceType(task.getConfigDeliveryTaskSourceType().getKeyword());
        taskDO.setConfigDeliveryTaskStatus(task.getConfigDeliveryTaskStatus().getKeyword());
        if (task.getConfigDeliveryTaskStatus() != ConfigDeliveryTaskStatus.IN_PROGRESS) {
            task.setProgress(Integer.valueOf(-1));
        }
        taskDO.setTimeout(task.getTimeout());
        taskDO.setTaskEnabled(task.getTaskEnabled());
        taskDO.setInstanceClassId(task.getInstanceClassId().intValue());
        taskDO.setJobId(task.getInstanceClassId() + "");
        taskDO.setDeviceLabels(this.getDeviceLabels(task.getConfigDeliveryTaskDeviceDetailsCol()));
        taskDO.setInstanceName(task.getInstanceName());
        taskDO.setPassword(task.getPassword());
        taskDO.setEnablePassword(task.getEnablePwd());
        taskDO.setUserName(task.getUserName());
        if (task.getConfigDeliveryTaskDeviceDetailsCol() != null && task.getConfigDeliveryTaskDeviceDetailsCol().size() > 0) {
            ArrayList<ConfigDeliveryTaskDeviceDetailsDO> detailsDOArr = new ArrayList<ConfigDeliveryTaskDeviceDetailsDO>();
            ConfigDeliveryTaskDeviceDetailsDO detailsDO = null;
            for (ConfigDeliveryTaskDeviceDetails details : task.getConfigDeliveryTaskDeviceDetailsCol()) {
                detailsDO = this.getConfigDeliveryTaskDeviceDetailsDO(details);
                detailsDOArr.add(detailsDO);
            }
            ConfigDeliveryTaskDeviceDetailsDO[] resArr = new ConfigDeliveryTaskDeviceDetailsDO[detailsDOArr.size()];
            taskDO.setConfigDeliveryTaskDeviceDetailsCol(detailsDOArr.toArray(resArr));
        }
        return taskDO;
    }

    private long convertUtcToLocalTime(long utcTime) throws ParseException {
        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        utcFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date utcDate = new Date(utcTime);
        Date date = utcFormat.parse(utcFormat.format(utcDate));
        SimpleDateFormat localFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        localFormat.setTimeZone(TimeZone.getDefault());
        this.log.info((Object)("Input UTC date: " + utcDate + " Converted UTC :" + date + " Converted Local time: " + localFormat.format(date)));
        return localFormat.parse(localFormat.format(date)).getTime();
    }

    private String getDeviceLabels(List<ConfigDeliveryTaskDeviceDetails> configDeliveryTaskDeviceDetailsCol) {
        String retStr = "";
        int idx = 0;
        for (ConfigDeliveryTaskDeviceDetails device : configDeliveryTaskDeviceDetailsCol) {
            retStr = idx < configDeliveryTaskDeviceDetailsCol.size() - 1 ? retStr.concat(device.getIpAddress().toString() + ",") : retStr.concat(device.getIpAddress().toString());
            ++idx;
        }
        return retStr;
    }

    private ConfigDeliveryTaskDeviceDetailsDO getConfigDeliveryTaskDeviceDetailsDO(ConfigDeliveryTaskDeviceDetails details) {
        ConfigDeliveryTaskDeviceDetailsDO detailsDO = new ConfigDeliveryTaskDeviceDetailsDO();
        detailsDO.setAssignedInstanceClassId(details.getInstanceClassId().intValue());
        detailsDO.setInstanceName(details.getInstanceName());
        if (details.getConfigCommands() != null) {
            detailsDO.setConfigCommands(details.getConfigCommands().toString());
        }
        detailsDO.setConfigDeliveryTaskDeviceStatus(details.getConfigDeliveryTaskDeviceStatus());
        detailsDO.setFailureCause(details.getFailureCause().toString());
        if (details.getFailedCommands() != null) {
            detailsDO.setFailedCommands(details.getFailedCommands().toString());
        }
        detailsDO.setIpAddress(details.getIpAddress().toString());
        return detailsDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigTemplate getConfigTemplate(String templateName) {
        ConfigTemplate template = null;
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            template = (ConfigTemplate)session.createCriteria(ConfigTemplate.class).add((Criterion)Restrictions.eq((String)"name", (Object)templateName)).uniqueResult();
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigDeliveryTaskDeviceDetails> getTargetDeviceDetails(InstanceNameId taskId) throws AppException {
        List<ConfigDeliveryTaskDeviceDetails> targetDeviceDetails = new ArrayList();
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            ConfigDeliveryTask task = (ConfigDeliveryTask)session.getByNameId(taskId);
            targetDeviceDetails = session.createCriteria(ConfigDeliveryTaskDeviceDetails.class).add((Criterion)Restrictions.eq((String)"configDeliveryTaskRef", (Object)task)).setFetchMode("configDeliveryTaskRef", FetchMode.JOIN).list();
            try {
                if (targetDeviceDetails.size() > 0) {
                    Hibernate.initialize((Object)((ConfigDeliveryTaskDeviceDetails)targetDeviceDetails.get(0)).getConfigDeliveryTaskRef());
                    Hibernate.initialize((Object)targetDeviceDetails.get(0).getConfigDeliveryTaskRef().getConfigDeliveryTaskDeviceDetailsCol());
                    this.readConfigCommands(targetDeviceDetails.get(0).getConfigDeliveryTaskRef());
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
                throw ExceptionHelper.internalServerException(e);
            }
        }
        return targetDeviceDetails;
    }

    public List<ConfigDeliveryTaskDeviceDO> getConfigDeliveryTaskDevices(DbFilterDO dbFilter, String status, int startIdx, int recordSize, String[] filterPlatforms) {
        ArrayList<ConfigDeliveryTaskDeviceDO> retList = null;
        int length = SwitchHandler.getInstance().getSwitchDataLength(dbFilter, status);
        ArrayList<SwitchDO> allList = SwitchHandler.getInstance().getSwitchList(dbFilter, status, 0, length);
        if (filterPlatforms == null || filterPlatforms.length == 0) {
            retList = new ArrayList<ConfigDeliveryTaskDeviceDO>();
            if (recordSize >= allList.size()) {
                for (SwitchDO switchDO : allList) {
                    if (SwitchHandler.getSwitchStatusType(switchDO).equals("Unmanaged")) continue;
                    retList.add(this.getTaskDeviceDOFromSwitchDO(switchDO));
                }
            } else {
                for (int idx = 0; idx < recordSize; ++idx) {
                    if (SwitchHandler.getSwitchStatusType(allList.get(idx)).equals("Unmanaged")) continue;
                    retList.add(this.getTaskDeviceDOFromSwitchDO(allList.get(idx)));
                }
            }
        } else {
            int curMatchIdx = 0;
            String switchPfm = "";
            boolean switchSupp = false;
            InetAddress ipAddr = null;
            retList = new ArrayList();
            for (int idx = 0; idx < allList.size(); ++idx) {
                if (SwitchHandler.getSwitchStatusType(allList.get(idx)).equals("Unmanaged")) continue;
                switchSupp = false;
                switchPfm = "";
                String ip = allList.get(idx).getIpAddress();
                try {
                    if (ip != null) {
                        ipAddr = InetAddress.getByName(ip);
                        EthSwitchImpl eswImpl = DCManager.getInstance().findEthSwitchBySwIp(ipAddr);
                        if (eswImpl != null) {
                            if (eswImpl.isN5K5()) {
                                switchPfm = "N5500";
                            } else if (eswImpl.isN3K5()) {
                                switchPfm = "N3500";
                            }
                        }
                        if (switchPfm == null || switchPfm.equals("")) {
                            switchPfm = ConfigDeliveryHelper.getPlatformTypeDefKey(ip);
                        }
                    }
                }
                catch (UnknownHostException e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    this.log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (switchPfm == null) {
                    PlatformType ptype = PlatformType.getTypeByDeviceKey(allList.get(idx).getModel());
                    switchPfm = ptype != null ? ptype.getDefineKey() : allList.get(idx).getModel();
                }
                if (switchPfm == null) continue;
                for (String filterPfm : filterPlatforms) {
                    if (filterPfm.equals("C6500")) {
                        filterPfm = "CAT6K";
                    } else if (filterPfm.equals("N1K")) {
                        filterPfm = "N1KV";
                    } else if (filterPfm.equals("N1110")) {
                        filterPfm = "N1K1";
                    } else if (filterPfm.equals("N1010")) {
                        filterPfm = "N1K";
                    } else if (switchPfm.equals("MDS9000") || switchPfm.equals("MDS9100") || switchPfm.equals("MDS9200") || switchPfm.equals("MDS9500") || switchPfm.equals("MDS9700")) {
                        switchPfm = "MDS";
                    }
                    if (!switchPfm.equals(filterPfm)) continue;
                    switchSupp = true;
                    break;
                }
                if (!switchSupp) continue;
                retList.add(this.getTaskDeviceDOFromSwitchDO(allList.get(idx)));
                if (curMatchIdx++ > startIdx || retList.size() <= recordSize) {
                    continue;
                }
                break;
            }
        }
        return retList;
    }

    private ConfigDeliveryTaskDeviceDO getTaskDeviceDOFromSwitchDO(SwitchDO switchDO) {
        PlatformType ptype;
        ConfigDeliveryTaskDeviceDO deviceDO = new ConfigDeliveryTaskDeviceDO();
        deviceDO.setHostName(switchDO.getLogicalName());
        deviceDO.setIpAddress(switchDO.getIpAddress());
        deviceDO.setVersion(switchDO.getRelease());
        deviceDO.setGroup(switchDO.getNetwork());
        String platform = ConfigDeliveryHelper.getPlatformName(switchDO.getIpAddress());
        if ((platform == null || platform.trim().length() == 0) && (ptype = PlatformType.getTypeByDeviceKey(switchDO.getModel())) != null) {
            platform = ptype.getName();
        }
        deviceDO.setPlatform(platform);
        return deviceDO;
    }

    public String exportConfigDeliveryJobTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws AppException {
        List<Object> taskDOs = new ArrayList();
        try {
            taskDOs = this.getAllConfigDeliveryTasks(dbFilter, null, startIdx, recordSize);
        }
        catch (AppException e) {
            this.log.error((Object)("Exception caught while printing config delivery tasks" + (Object)((Object)e)));
        }
        String title = "Config Jobs Report";
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, taskDOs);
    }

    public String printConfigDeliveryJobTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws AppException {
        List<Object> taskDOs = new ArrayList();
        try {
            taskDOs = this.getAllConfigDeliveryTasks(dbFilter, null, startIdx, recordSize);
        }
        catch (AppException e) {
            this.log.error((Object)("Exception caught while printing config delivery tasks" + (Object)((Object)e)));
        }
        String title = "Config Jobs Report";
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, taskDOs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConfigDeliveryJobLength(DbFilterDO dbFilter) throws AppException {
        int length = 0;
        try (SessionPersister session = CommonSessionPersisterFactory.INSTANCE.openSession();){
            List<ConfigDeliveryTask> tasks = this.getAllConfigDeliveryTasksBeforPaginating(dbFilter, session);
            length = tasks == null ? 0 : tasks.size();
        }
        return length;
    }
}

