/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.dashboard;

import com.cisco.dcbu.jaxws.wo.CapacityDO;
import com.cisco.dcbu.jaxws.wo.CapacityItemDO;
import com.cisco.dcbu.jaxws.wo.CapacitySmisDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.server.db.MondrianConnection;
import com.cisco.dcbu.sm.server.web.dashboard.CapacityDataDO;
import com.cisco.dcbu.sm.server.web.dashboard.CapacityDataItemDO;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Connection;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import org.apache.log4j.Logger;

public class CapacityMgrHandler {
    private static CapacityMgrHandler _Instance = null;
    static Logger _Log = Logger.getLogger((String)"capacity");
    private static int TYPE_ALL = 0;
    private static int TYPE_FABRIC = 1;
    private static int TYPE_LAN = 2;
    private static int TYPE_FABRIC_SWITCH = 3;
    private static int TYPE_LAN_SWITCH = 4;
    private static int TYPE_SMIS_ALL = 0;
    private static int TYPE_SMIS_SYS = 1;
    private static int TYPE_SMIS_POOL = 2;
    private static int TYPE_SMIS_LUN = 3;
    private static String Mondrian_Query_All = "select {[Measures].[Avail_1G], [Measures].[Total_1G], [Measures].[Avail_2G], [Measures].[Total_2G], [Measures].[Avail_4G], [Measures].[Total_4G], [Measures].[Avail_8G], [Measures].[Total_8G], [Measures].[Avail_10G], [Measures].[Total_10G], [Measures].[Avail_16G], [Measures].[Total_16G], [Measures].[Avail_40G], [Measures].[Total_40G], [Measures].[Avail_100G], [Measures].[Total_100G], [Measures].[Avail_NA], [Measures].[Total_NA], [Measures].[Health]} ON COLUMNS, {[TIME.DAILY].children} ON ROWS from [Usage]";
    private static String Mondrian_Query_Pct_ALL = "select {[Measures].[AvailPct_1G], [Measures].[Avail_1G], [Measures].[Total_1G], [Measures].[AvailPct_2G], [Measures].[Avail_2G], [Measures].[Total_2G], [Measures].[AvailPct_4G], [Measures].[Avail_4G], [Measures].[Total_4G], [Measures].[AvailPct_8G], [Measures].[Avail_8G], [Measures].[Total_8G], [Measures].[AvailPct_10G], [Measures].[Avail_10G], [Measures].[Total_10G], [Measures].[AvailPct_16G], [Measures].[Avail_16G], [Measures].[Total_16G], [Measures].[AvailPct_40G], [Measures].[Avail_40G], [Measures].[Total_40G], [Measures].[AvailPct_100G], [Measures].[Avail_100G], [Measures].[Total_100G], [Measures].[AvailPct_NA], [Measures].[Avail_NA], [Measures].[Total_NA], [Measures].[Health]} ON COLUMNS, {[TIME.DAILY].children} ON ROWS from [Usage]";
    private static String Mondrian_Query_Pct_SMIS_ALL = "select {[Measures].[UsedPct_RAW], [Measures].[Remaining_raw_capacity], [Measures].[Raw_capacity], [Measures].[UsedPct_Managed], [Measures].[Remaining_managed], [Measures].[Total_managed]} ON COLUMNS, {[TIME.DAILY].children} ON ROWS from [UsageSmis]";
    private static String Mondrian_Query_Pct_SMIS_LUN_ALL = "select {[Measures].[UsedPct], [Measures].[Remaining_managed], [Measures].[Total_managed]} ON COLUMNS, {[TIME.DAILY].children} ON ROWS from [UsageSmisLun]";

    public static CapacityMgrHandler getInstance() {
        if (_Instance == null) {
            _Instance = new CapacityMgrHandler();
        }
        return _Instance;
    }

    private CapacityMgrHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CapacityDO getCapacity(DbFilterDO dbFilter) {
        CapacityDO ret = new CapacityDO();
        CapacityDataDO cdo = new CapacityDataDO();
        cdo.setDbid(dbFilter.getGroupId());
        Connection con = null;
        try {
            con = MondrianConnection.getConnection();
            if (dbFilter.getGroupFilterXml() == null || dbFilter.getGroupFilterXml().startsWith("<groupList")) {
                this.getPortUsage(con, cdo, -1L, TYPE_ALL);
            } else {
                String fids = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 0);
                int cntFabric = NavigationUtil.getInstance().getCountEntitiesInGroup(dbFilter.getGroupFilterXml(), 0);
                int cntLans = NavigationUtil.getInstance().getCountEntitiesInGroup(dbFilter.getGroupFilterXml(), 1);
                if (fids.equals("")) {
                    this.getPortUsage(con, cdo, -1L, TYPE_ALL);
                } else {
                    String lanids;
                    if (!fids.equals("-1")) {
                        String[] fidLists = fids.split(",");
                        for (int i = 0; i < fidLists.length; ++i) {
                            try {
                                long fid = Long.parseLong(fidLists[i]);
                                this.getPortUsage(con, cdo, fid, TYPE_FABRIC);
                                continue;
                            }
                            catch (Exception e) {
                                _Log.error((Object)"Exception in CapacityMgrHandler.getCapacity ", (Throwable)e);
                            }
                        }
                    }
                    if (!(lanids = NavigationUtil.getInstance().getEntitiesInGroup(dbFilter.getGroupFilterXml(), 1)).equals("-1")) {
                        String[] lanidLists = lanids.split(",");
                        for (int i = 0; i < lanidLists.length; ++i) {
                            try {
                                long lid = Long.parseLong(lanidLists[i]);
                                this.getPortUsage(con, cdo, lid, TYPE_LAN_SWITCH);
                                continue;
                            }
                            catch (Exception e) {
                                _Log.error((Object)"Exception in CapacityMgrHandler.getCapacity ", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            _Log.error((Object)"Exception in CapacityMgrHandler.getCapacity ", (Throwable)ex);
        }
        finally {
            MondrianConnection.close(con);
        }
        this.convertCapacityData(ret, cdo);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CapacityDO getCapacityBySwitchId(long switchId, int type) {
        CapacityDO ret = new CapacityDO();
        CapacityDataDO cdo = new CapacityDataDO();
        cdo.setDbid(switchId);
        Connection con = null;
        try {
            con = MondrianConnection.getConnection();
            this.getPortUsage(con, cdo, switchId, type);
        }
        catch (Exception ex) {
            _Log.error((Object)"Exception in CapacityMgrHandler.getCapacityBySwitchId ", (Throwable)ex);
        }
        finally {
            MondrianConnection.close(con);
        }
        this.convertCapacityData(ret, cdo);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPortUsage(Connection con, CapacityDataDO cdo, long id, int type) {
        try (Result result = null;){
            ArrayList<String> itemListDays = new ArrayList<String>();
            ArrayList<CapacityDataItemDO> itemListAvail_1G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_2G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_4G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_8G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_10G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_16G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_40G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_100G = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListAvail_NA = new ArrayList<CapacityDataItemDO>();
            ArrayList<CapacityDataItemDO> itemListHealth = new ArrayList<CapacityDataItemDO>();
            Query query = null;
            if (id < 0L) {
                query = con.parseQuery(Mondrian_Query_Pct_ALL);
            } else if (id > 0L && type == TYPE_FABRIC) {
                query = con.parseQuery(Mondrian_Query_Pct_ALL + " WHERE [Fabric].[" + id + "]");
            } else if (id > 0L && type == TYPE_LAN) {
                query = con.parseQuery(Mondrian_Query_Pct_ALL + " WHERE [Lan].[" + id + "]");
            } else if (id > 0L && type == TYPE_FABRIC_SWITCH) {
                query = con.parseQuery(Mondrian_Query_Pct_ALL + " WHERE [Switch].[" + id + "]");
            } else if (id > 0L && type == TYPE_LAN_SWITCH) {
                query = con.parseQuery(Mondrian_Query_Pct_ALL + " WHERE [EthSwitch].[" + id + "]");
            }
            result = con.execute(query);
            Axis[] axes = result.getAxes();
            List positions = axes[1].getPositions();
            for (Position position : positions) {
                for (Member member : position) {
                    String[] tempDate1 = member.getUniqueName().toString().split("\\[");
                    itemListDays.add(tempDate1[2].substring(0, tempDate1[2].length() - 1));
                }
            }
            for (int i = 0; i < itemListDays.size(); ++i) {
                CapacityDataItemDO item_avail_1g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_2g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_4g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_8g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_10g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_16g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_40g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_100g = new CapacityDataItemDO();
                CapacityDataItemDO item_avail_na = new CapacityDataItemDO();
                CapacityDataItemDO item_health = new CapacityDataItemDO();
                int[] pos_avail_pct_1g = new int[]{0, i};
                int[] pos_avail_1g = new int[]{1, i};
                int[] pos_total_1g = new int[]{2, i};
                int[] pos_avail_pct_2g = new int[]{3, i};
                int[] pos_avail_2g = new int[]{4, i};
                int[] pos_total_2g = new int[]{5, i};
                int[] pos_avail_pct_4g = new int[]{6, i};
                int[] pos_avail_4g = new int[]{7, i};
                int[] pos_total_4g = new int[]{8, i};
                int[] pos_avail_pct_8g = new int[]{9, i};
                int[] pos_avail_8g = new int[]{10, i};
                int[] pos_total_8g = new int[]{11, i};
                int[] pos_avail_pct_10g = new int[]{12, i};
                int[] pos_avail_10g = new int[]{13, i};
                int[] pos_total_10g = new int[]{14, i};
                int[] pos_avail_pct_16g = new int[]{15, i};
                int[] pos_avail_16g = new int[]{16, i};
                int[] pos_total_16g = new int[]{17, i};
                int[] pos_avail_pct_40g = new int[]{18, i};
                int[] pos_avail_40g = new int[]{19, i};
                int[] pos_total_40g = new int[]{20, i};
                int[] pos_avail_pct_100g = new int[]{21, i};
                int[] pos_avail_100g = new int[]{22, i};
                int[] pos_total_100g = new int[]{23, i};
                int[] pos_avail_pct_na = new int[]{24, i};
                int[] pos_avail_na = new int[]{25, i};
                int[] pos_total_na = new int[]{26, i};
                int[] pos_health = new int[]{27, i};
                boolean noDataForTheDate = false;
                if (result.getCell(pos_avail_pct_1g).getValue() == null || result.getCell(pos_avail_pct_1g).getValue() == null || result.getCell(pos_total_1g).getValue() == null) {
                    noDataForTheDate = true;
                    continue;
                }
                if (result.getCell(pos_avail_pct_1g).getValue() != null) {
                    item_avail_1g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_1g).getValue().toString()));
                }
                if (result.getCell(pos_avail_1g).getValue() != null) {
                    item_avail_1g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_1g).getValue().toString()));
                }
                if (result.getCell(pos_total_1g).getValue() != null) {
                    item_avail_1g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_1g).getValue().toString()));
                }
                item_avail_1g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_2g).getValue() != null) {
                    item_avail_2g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_2g).getValue().toString()));
                }
                if (result.getCell(pos_avail_2g).getValue() != null) {
                    item_avail_2g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_2g).getValue().toString()));
                }
                if (result.getCell(pos_total_2g).getValue() != null) {
                    item_avail_2g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_2g).getValue().toString()));
                }
                item_avail_2g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_4g).getValue() != null) {
                    item_avail_4g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_4g).getValue().toString()));
                }
                if (result.getCell(pos_avail_4g).getValue() != null) {
                    item_avail_4g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_4g).getValue().toString()));
                }
                if (result.getCell(pos_total_4g).getValue() != null) {
                    item_avail_4g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_4g).getValue().toString()));
                }
                item_avail_4g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_8g).getValue() != null) {
                    item_avail_8g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_8g).getValue().toString()));
                }
                if (result.getCell(pos_avail_8g).getValue() != null) {
                    item_avail_8g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_8g).getValue().toString()));
                }
                if (result.getCell(pos_total_8g).getValue() != null) {
                    item_avail_8g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_8g).getValue().toString()));
                }
                item_avail_8g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_10g).getValue() != null) {
                    item_avail_10g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_10g).getValue().toString()));
                }
                if (result.getCell(pos_avail_10g).getValue() != null) {
                    item_avail_10g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_10g).getValue().toString()));
                }
                if (result.getCell(pos_total_10g).getValue() != null) {
                    item_avail_10g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_10g).getValue().toString()));
                }
                item_avail_10g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_16g).getValue() != null) {
                    item_avail_16g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_16g).getValue().toString()));
                }
                if (result.getCell(pos_avail_16g).getValue() != null) {
                    item_avail_16g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_16g).getValue().toString()));
                }
                if (result.getCell(pos_total_16g).getValue() != null) {
                    item_avail_16g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_16g).getValue().toString()));
                }
                item_avail_16g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_40g).getValue() != null) {
                    item_avail_40g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_40g).getValue().toString()));
                }
                if (result.getCell(pos_avail_40g).getValue() != null) {
                    item_avail_40g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_40g).getValue().toString()));
                }
                if (result.getCell(pos_total_40g).getValue() != null) {
                    item_avail_40g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_40g).getValue().toString()));
                }
                item_avail_40g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_100g).getValue() != null) {
                    item_avail_100g.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_100g).getValue().toString()));
                }
                if (result.getCell(pos_avail_100g).getValue() != null) {
                    item_avail_100g.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_100g).getValue().toString()));
                }
                if (result.getCell(pos_total_100g).getValue() != null) {
                    item_avail_100g.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_100g).getValue().toString()));
                }
                item_avail_100g.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_avail_pct_na).getValue() != null) {
                    item_avail_na.setValue((float)this.parseDataValue(result.getCell(pos_avail_pct_na).getValue().toString()));
                }
                if (result.getCell(pos_avail_na).getValue() != null) {
                    item_avail_na.setAvailPorts((int)Double.parseDouble(result.getCell(pos_avail_na).getValue().toString()));
                }
                if (result.getCell(pos_total_na).getValue() != null) {
                    item_avail_na.setTotalPorts((int)Double.parseDouble(result.getCell(pos_total_na).getValue().toString()));
                }
                item_avail_na.setDay((String)itemListDays.get(i));
                if (result.getCell(pos_health).getValue() != null) {
                    item_health.setValue((float)Double.parseDouble(result.getCell(pos_health).getValue().toString()));
                }
                item_health.setDay((String)itemListDays.get(i));
                itemListAvail_1G.add(item_avail_1g);
                itemListAvail_2G.add(item_avail_2g);
                itemListAvail_4G.add(item_avail_4g);
                itemListAvail_8G.add(item_avail_8g);
                itemListAvail_10G.add(item_avail_10g);
                itemListAvail_16G.add(item_avail_16g);
                itemListAvail_40G.add(item_avail_40g);
                itemListAvail_100G.add(item_avail_100g);
                itemListAvail_NA.add(item_avail_na);
                itemListHealth.add(item_health);
            }
            if (itemListAvail_1G.size() > 0) {
                cdo.setCapDataItemDO(itemListAvail_1G, 1);
                cdo.setCapDataItemDO(itemListAvail_2G, 2);
                cdo.setCapDataItemDO(itemListAvail_4G, 3);
                cdo.setCapDataItemDO(itemListAvail_8G, 4);
                cdo.setCapDataItemDO(itemListAvail_10G, 5);
                cdo.setCapDataItemDO(itemListAvail_16G, 6);
                cdo.setCapDataItemDO(itemListAvail_40G, 7);
                cdo.setCapDataItemDO(itemListAvail_100G, 8);
                cdo.setCapDataItemDO(itemListAvail_NA, 9);
                cdo.setCapDataItemDO(itemListHealth, 10);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CapacitySmisDO> getCapacitySmisById(long id, int type) {
        ArrayList<CapacitySmisDO> capSmisDO = new ArrayList<CapacitySmisDO>();
        Connection con = null;
        try {
            con = MondrianConnection.getConnection();
            this.getSmisUsage(con, capSmisDO, id, type);
        }
        catch (Exception ex) {
            _Log.error((Object)"Exception in CapacityMgrHandler.getCapacitySmisById ", (Throwable)ex);
        }
        finally {
            MondrianConnection.close(con);
        }
        return capSmisDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSmisUsage(Connection con, ArrayList<CapacitySmisDO> smisDOArr, long id, int type) {
        try (Result result = null;){
            CapacitySmisDO item;
            ArrayList<String> itemListDays = new ArrayList<String>();
            Query query = null;
            if (id <= 0L) {
                query = con.parseQuery(Mondrian_Query_Pct_SMIS_ALL);
            } else if (id > 0L && type == TYPE_SMIS_SYS) {
                query = con.parseQuery(Mondrian_Query_Pct_SMIS_ALL + " WHERE [SystemDbId].[" + id + "]");
            } else if (id > 0L && type == TYPE_SMIS_POOL) {
                query = con.parseQuery(Mondrian_Query_Pct_SMIS_ALL + " WHERE [Pool].[" + id + "]");
            } else if (id > 0L && type == TYPE_SMIS_LUN) {
                query = con.parseQuery(Mondrian_Query_Pct_SMIS_LUN_ALL + " WHERE [Lun].[" + id + "]");
            }
            result = con.execute(query);
            Axis[] axes = result.getAxes();
            List positions = axes[1].getPositions();
            for (Position position : positions) {
                for (Member member : position) {
                    String[] tempDate1 = member.getUniqueName().toString().split("\\[");
                    itemListDays.add(tempDate1[2].substring(0, tempDate1[2].length() - 1));
                }
            }
            if (type != TYPE_SMIS_LUN) {
                for (int i = 0; i < itemListDays.size(); ++i) {
                    item = new CapacitySmisDO();
                    int[] pos_used_pct_raw = new int[]{0, i};
                    int[] pos_raw_rem = new int[]{1, i};
                    int[] pos_raw_toal = new int[]{2, i};
                    int[] pos_used_pct_managed = new int[]{3, i};
                    int[] pos_managed_rem = new int[]{4, i};
                    int[] pos_managed_total = new int[]{5, i};
                    boolean noDataForTheDate = false;
                    if (result.getCell(pos_used_pct_raw).getValue() == null || result.getCell(pos_raw_rem).getValue() == null || result.getCell(pos_raw_toal).getValue() == null) {
                        noDataForTheDate = true;
                        continue;
                    }
                    if (result.getCell(pos_used_pct_raw).getValue() != null) {
                        item.setUsedPct_raw((float)this.parseDataValue(result.getCell(pos_used_pct_raw).getValue().toString()));
                    }
                    if (result.getCell(pos_raw_rem).getValue() != null) {
                        item.setRaw_rem((long)Double.parseDouble(result.getCell(pos_raw_rem).getValue().toString()));
                    }
                    if (result.getCell(pos_raw_toal).getValue() != null) {
                        item.setRaw_total((long)Double.parseDouble(result.getCell(pos_raw_toal).getValue().toString()));
                    }
                    if (result.getCell(pos_used_pct_managed).getValue() != null) {
                        item.setUsedPct_managed((float)this.parseDataValue(result.getCell(pos_used_pct_managed).getValue().toString()));
                    }
                    if (result.getCell(pos_managed_rem).getValue() != null) {
                        item.setManaged_rem((long)Double.parseDouble(result.getCell(pos_managed_rem).getValue().toString()));
                    }
                    if (result.getCell(pos_managed_total).getValue() != null) {
                        item.setManaged_total((long)Double.parseDouble(result.getCell(pos_managed_total).getValue().toString()));
                    }
                    item.setTime(this.getTimeFromDayString((String)itemListDays.get(i)));
                    smisDOArr.add(item);
                }
            } else {
                for (int i = 0; i < itemListDays.size(); ++i) {
                    item = new CapacitySmisDO();
                    int[] pos_used_pct = new int[]{0, i};
                    int[] pos_managed_rem = new int[]{1, i};
                    int[] pos_managed_total = new int[]{2, i};
                    boolean noDataForTheDate = false;
                    if (result.getCell(pos_used_pct).getValue() == null || result.getCell(pos_used_pct).getValue() == null || result.getCell(pos_used_pct).getValue() == null) {
                        noDataForTheDate = true;
                        continue;
                    }
                    if (result.getCell(pos_used_pct).getValue() != null) {
                        item.setUsedPct_managed((float)this.parseDataValue(result.getCell(pos_used_pct).getValue().toString()));
                    }
                    if (result.getCell(pos_managed_rem).getValue() != null) {
                        item.setManaged_rem((long)Double.parseDouble(result.getCell(pos_managed_rem).getValue().toString()));
                    }
                    if (result.getCell(pos_managed_total).getValue() != null) {
                        item.setManaged_total((long)Double.parseDouble(result.getCell(pos_managed_total).getValue().toString()));
                    }
                    item.setTime(this.getTimeFromDayString((String)itemListDays.get(i)));
                    smisDOArr.add(item);
                }
            }
        }
    }

    private long getTimeFromDayString(String day) {
        long ret = 0L;
        try {
            Date dd = CapacityDataItemDO.dateFormat.parse(day);
            ret = dd.getTime();
        }
        catch (Exception e) {
            System.err.println("Error to parse day: " + day);
        }
        return ret;
    }

    private double parseDataValue(String value) {
        double d = -1.0;
        try {
            if (value != null && value.length() > 0 && (Double.isInfinite(d = Double.parseDouble(value)) || Double.isNaN(d))) {
                d = Double.NaN;
            }
        }
        catch (NumberFormatException e) {
            _Log.warn((Object)("CapacityMgr: the value is not a number: " + value));
            d = Double.NaN;
        }
        return d;
    }

    private void convertCapacityData(CapacityDO ret, CapacityDataDO cdo) {
        double[] slope;
        double[][] datas;
        ret.setDbid(cdo.getDbid());
        CapacityDataItemDO[] avail = cdo.getAvail_1g();
        if (avail == null) {
            return;
        }
        boolean doSlope = true;
        if (avail.length == 1) {
            doSlope = false;
        }
        CapacityItemDO[] ido = this.convertToCapacityItem(avail);
        ret.setAvail_1g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_1g(slope[0]);
            ret.setIntercept_avail_1g(slope[1]);
        } else {
            ret.setIntercept_avail_1g(ido[0].getValue());
        }
        avail = cdo.getAvail_2g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_2g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_2g(slope[0]);
            ret.setIntercept_avail_2g(slope[1]);
        } else {
            ret.setIntercept_avail_2g(ido[0].getValue());
        }
        avail = cdo.getAvail_4g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_4g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_4g(slope[0]);
            ret.setIntercept_avail_4g(slope[1]);
        } else {
            ret.setIntercept_avail_4g(ido[0].getValue());
        }
        avail = cdo.getAvail_8g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_8g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_8g(slope[0]);
            ret.setIntercept_avail_8g(slope[1]);
        } else {
            ret.setIntercept_avail_8g(ido[0].getValue());
        }
        avail = cdo.getAvail_10g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_10g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_10g(slope[0]);
            ret.setIntercept_avail_10g(slope[1]);
        } else {
            ret.setIntercept_avail_10g(ido[0].getValue());
        }
        avail = cdo.getAvail_16g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_16g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_16g(slope[0]);
            ret.setIntercept_avail_16g(slope[1]);
        } else {
            ret.setIntercept_avail_16g(ido[0].getValue());
        }
        avail = cdo.getAvail_40g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_40g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_40g(slope[0]);
            ret.setIntercept_avail_40g(slope[1]);
        } else {
            ret.setIntercept_avail_40g(ido[0].getValue());
        }
        avail = cdo.getAvail_100g();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_100g(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_100g(slope[0]);
            ret.setIntercept_avail_100g(slope[1]);
        } else {
            ret.setIntercept_avail_100g(ido[0].getValue());
        }
        avail = cdo.getAvail_na();
        ido = this.convertToCapacityItem(avail);
        ret.setAvail_na(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_avail_na(slope[0]);
            ret.setIntercept_avail_na(slope[1]);
        } else {
            ret.setIntercept_avail_na(ido[0].getValue());
        }
        avail = cdo.getHealth();
        ido = this.convertToCapacityItem(avail);
        ret.setHealth(ido);
        if (doSlope) {
            datas = this.convertToDouble(avail);
            slope = this.computeSlope(datas);
            ret.setSlope_health(slope[0]);
            ret.setIntercept_health(slope[1]);
        } else {
            ret.setIntercept_health(ido[0].getValue());
        }
    }

    private CapacityItemDO[] convertToCapacityItem(CapacityDataItemDO[] ido) {
        CapacityItemDO[] cdo = new CapacityItemDO[ido.length];
        for (int i = 0; i < ido.length; ++i) {
            float avg = ido[i].getAvgValue();
            long tt = ido[i].getTime();
            int availPorts = ido[i].getAvailPorts();
            int totalPorts = ido[i].getTotalPorts();
            cdo[i] = new CapacityItemDO(avg, availPorts, totalPorts, tt);
        }
        return cdo;
    }

    private double[][] convertToDouble(CapacityDataItemDO[] ido) {
        double[][] cdo = new double[ido.length][2];
        for (int i = 0; i < ido.length; ++i) {
            cdo[i][0] = ido[i].getTime();
            cdo[i][1] = ido[i].getAvgValue();
        }
        return cdo;
    }

    private double[] computeSlope(double[][] data) {
        double n = data.length;
        double sumy = 0.0;
        double sumx = 0.0;
        double sumx2 = 0.0;
        double sumy2 = 0.0;
        double sumxy = 0.0;
        int i = 0;
        while ((double)i < n) {
            sumx += data[i][0];
            sumx2 += data[i][0] * data[i][0];
            sumy += data[i][1];
            sumy2 += data[i][1] * data[i][1];
            sumxy += data[i][0] * data[i][1];
            ++i;
        }
        double meanX = sumx / n;
        double meanY = sumy / n;
        double slope = (sumxy - sumx * meanY) / (sumx2 - sumx * meanX);
        double intercept = meanY - slope * meanX;
        double[] ret = new double[]{slope, intercept};
        return ret;
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(_Log);
        CapacityMgrHandler mgr = CapacityMgrHandler.getInstance();
        ArrayList<CapacitySmisDO> smisArr = mgr.getCapacitySmisById(3396930L, 3);
        for (int i = 0; i < smisArr.size(); ++i) {
            System.out.println(smisArr.get(i));
        }
        System.exit(0);
    }
}

