/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.dashboard;

import com.cisco.dcbu.jaxws.san.wo.PerformanceSummaryDO;
import com.cisco.dcbu.jaxws.san.wo.PerformanceSummaryItemDO;
import com.cisco.dcbu.jaxws.wo.CredentialDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.sm.common.model.ZoneBase;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.model.FabricImpl;
import com.cisco.dcbu.sm.server.model.SanManager;
import com.cisco.dcbu.sm.server.model.VsanImpl;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceHandler;
import com.cisco.dcbu.sm.server.web.inventory.EndDeviceStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.FlowStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslHandler;
import com.cisco.dcbu.sm.server.web.inventory.IslStatHandler;
import com.cisco.dcbu.sm.server.web.inventory.NpvLinkHandler;
import com.cisco.dcbu.sm.server.web.inventory.NpvLinkStatHandler;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class PerformanceSummaryHandler {
    private static PerformanceSummaryHandler _Instance = null;
    private static Timestamp LAST_UPDATE_TIME = null;
    private long _vsan = -1L;
    private long _dbFid = -1L;
    private boolean _isGroup = false;
    double _totalErrors = 0.0;
    double _totalDiscards = 0.0;
    double _totalThroughput = 0.0;
    double _totalUtilization = 0.0;
    private int _totalRows = 0;
    public static String ntDelimiters = System.getProperty("web.performance.networkThroughput.delimitingValues", "10,20,40,60,100");
    public static int[] ntDelimiter = new int[]{10, 20, 40, 60, 100};
    private static String[] netThroughLabels = new String[]{"0-10 MB/s", "10-20 MB/s", "20-40 MB/s", "40-60 MB/s", "60-100 MB/s", ">=100 MB/s"};
    private static String[] barNetThroughLabels = new String[]{"zerototen", "tentotwenty", "twentytofourty", "fourtytosixty", "sixtytohundred", "hundredtoinf"};
    public static int[] islDelimiter = new int[]{50, 100, 200, 500, 1000};
    private static String[] islThroughLabels = new String[]{"0-50 MB/s", "50-100 MB/s", "100-200 MB/s", "200-500 MB/s", "500-1000 MB/s", ">=1 GB/s"};
    private static String[] barNetThroughISLLabels = new String[]{"zerotofifty", "fiftytohundred", "hundredtotwohundred", "twohundredtofivehundred", "fivehundredtothousand", "thousandtoinf"};
    private static String[] linkUtilLabels = new String[]{"0-9%", "10-19%", "20-39%", "40-59%", "60-79%", "80-100%"};
    private static String[] barLinkUtilLabels = new String[]{"zerototen", "tentotwenty", "twentytofourty", "fourtytosixty", "sixtytoeighty", "eightytohundred"};
    private Logger _Log = Logger.getLogger((String)"fms");

    public static PerformanceSummaryHandler getInstance() {
        if (_Instance == null) {
            _Instance = new PerformanceSummaryHandler();
        }
        return _Instance;
    }

    private PerformanceSummaryHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerformanceSummaryDO getPerformanceSummary(CredentialDO cred, DbFilterDO dbFilter) {
        PerformanceSummaryDO psdo = new PerformanceSummaryDO();
        psdo.setDataSource(dbFilter.getFilterStr());
        if (dbFilter.getFabricDbId() == -3L) {
            dbFilter.setFabricDbId(-1L);
        }
        this._isGroup = dbFilter.isGroup();
        this._dbFid = dbFilter.getFabricDbId();
        this._vsan = dbFilter.getVsanDbId();
        this._isGroup = dbFilter.isGroup();
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            psdo.setPmIsRunning(this.isPmRunning(con, dbFilter));
            String[] delimiters = ntDelimiters.split(",");
            try {
                for (int i = 0; i < 5; ++i) {
                    PerformanceSummaryHandler.ntDelimiter[i] = Integer.parseInt(delimiters[i].trim());
                }
            }
            catch (NumberFormatException e) {
                ntDelimiter = new int[]{10, 20, 40, 60, 100};
            }
            catch (Exception ex) {
                ntDelimiter = new int[]{10, 20, 40, 60, 100};
            }
            Arrays.sort(ntDelimiter);
            this._totalErrors = 0.0;
            this._totalDiscards = 0.0;
            this._totalThroughput = 0.0;
            this._totalUtilization = 0.0;
            ArrayList<String> chartData = this.getDashBoardData(con, psdo, cred);
            String s1 = DefaultSnmpNumberRenderer.formatLong((long)this._totalThroughput);
            String s2 = Math.round(this._totalUtilization / (double)this._totalRows) + "";
            String t1 = s1 + "B/s";
            String t2 = "Link Utilization = " + s2 + "% (Rx + Tx)/(2 x Speed)";
            String data = "<document>\n";
            for (String s : chartData) {
                data = data + s;
            }
            data = data + "  </document>\n";
            psdo.setTotalErrors(DefaultSnmpNumberRenderer.formatLong((long)this._totalErrors));
            psdo.setTotalDiscards(DefaultSnmpNumberRenderer.formatLong((long)this._totalDiscards));
            psdo.setTotalThroughput(DefaultSnmpNumberRenderer.formatLong((long)this._totalThroughput) + "B/s");
            psdo.setTotalUtilization((long)this._totalUtilization + "%");
            psdo.setDisplayNetworkThroughput(t1);
            psdo.setDisplayLinkUtilization(t2);
            psdo.setData(data);
            int monitoredEndDevices = 0;
            int totalEndDevices = 0;
            int monitoredIsls = 0;
            int totalIsls = 0;
            if (dbFilter.getNetworkType().equals("Data Center") || dbFilter.getNetworkType().equals("SAN")) {
                monitoredEndDevices = EndDeviceStatHandler.getInstance().getEndDeviceStatDataLength(dbFilter, "All Ports", "24 Hours");
                totalEndDevices = EndDeviceHandler.getInstance().getEndDevicesDataLength(dbFilter, "All", "All");
            }
            try {
                dbFilter.setSortField("Name");
                dbFilter.setSortType("ASC");
                totalIsls = IslHandler.getInstance().getIslDataLength(dbFilter, "All");
                totalIsls += NpvLinkHandler.getInstance().getDataLength(dbFilter, "All");
                monitoredIsls = IslStatHandler.getInstance().getIslStatDataLength(dbFilter, "24 Hours");
                monitoredIsls += NpvLinkStatHandler.getInstance().getNpvLinkStatDataLength(dbFilter, "24 Hours");
            }
            catch (Throwable e) {
                // empty catch block
            }
            psdo.setMonitoredEndDevices(monitoredEndDevices);
            psdo.setTotalEndDevices(totalEndDevices);
            psdo.setMonitoredISLs(monitoredIsls);
            psdo.setTotalISLs(totalIsls);
            if (dbFilter.getSortField() == null || dbFilter.getSortField().length() == 0) {
                dbFilter.setSortField("totalRxTxStr");
            }
            int flows = FlowStatHandler.getInstance().getFlowStatDataLength(dbFilter, "24 Hours");
            psdo.setFlows(flows);
            int zones = this.getZoneSize(dbFilter);
            psdo.setZones(zones);
        }
        catch (Exception ex) {
            this._Log.warn((Object)"Exception getting performance chart data", (Throwable)ex);
        }
        finally {
            DbUtil.close(con);
        }
        return psdo;
    }

    public ArrayList<String> getDashBoardData(Connection con, PerformanceSummaryDO psdo, CredentialDO credentials) throws Exception {
        int i;
        int[] l;
        int[] t;
        PerformanceSummaryItemDO item;
        int i2;
        int[] l2;
        PerformanceSummaryItemDO item2;
        int[] t2;
        ArrayList<String> chartData = new ArrayList<String>();
        ArrayList<PerformanceSummaryItemDO> throughputISL = new ArrayList<PerformanceSummaryItemDO>();
        ArrayList<PerformanceSummaryItemDO> throughputHost = new ArrayList<PerformanceSummaryItemDO>();
        ArrayList<PerformanceSummaryItemDO> throughputStorage = new ArrayList<PerformanceSummaryItemDO>();
        ArrayList<PerformanceSummaryItemDO> utilISL = new ArrayList<PerformanceSummaryItemDO>();
        ArrayList<PerformanceSummaryItemDO> utilHost = new ArrayList<PerformanceSummaryItemDO>();
        ArrayList<PerformanceSummaryItemDO> utilStorage = new ArrayList<PerformanceSummaryItemDO>();
        this._totalErrors = 0.0;
        this._totalDiscards = 0.0;
        this._totalThroughput = 0.0;
        this._totalUtilization = 0.0;
        this._totalRows = 0;
        LAST_UPDATE_TIME = new Timestamp(0L);
        ArrayList hostPerf = this.getPerformanceData(con, credentials, 3, ntDelimiter);
        ArrayList storagePerf = this.getPerformanceData(con, credentials, 4, ntDelimiter);
        ArrayList islPerf = this.getPerformanceData(con, credentials, 1, islDelimiter);
        if (hostPerf.size() > 0) {
            String ntHostUrl = "context+hostUrl&linkUtilization=All&throughput=";
            String ntHost = "<Chart type=\"Hosts\" name =\"Network Throughput\" url=\"" + ntHostUrl + "\">\n";
            t2 = (int[])hostPerf.get(0);
            for (int i3 = 0; i3 < t2.length; ++i3) {
                ntHost = ntHost + "    <row>\n";
                ntHost = ntHost + "        <Type>" + netThroughLabels[i3] + "</Type>\n";
                ntHost = ntHost + "        <Value>" + t2[i3] + "</Value>\n";
                ntHost = ntHost + "    </row>\n";
                item2 = new PerformanceSummaryItemDO();
                item2.setName(netThroughLabels[i3]);
                item2.setValue(t2[i3]);
                throughputHost.add(item2);
            }
            ntHost = ntHost + "</Chart>";
            chartData.add(ntHost);
            String luHostUrl = "context+hostUrl&throughput=All&linkUtilization=";
            String luHost = "<Chart type=\"Hosts\" name =\"Link Utilization\" url=\"" + luHostUrl + "\">\n";
            l2 = (int[])hostPerf.get(1);
            for (i2 = 0; i2 < l2.length; ++i2) {
                luHost = luHost + "    <row>\n";
                luHost = luHost + "        <Type>" + linkUtilLabels[i2] + "</Type>\n";
                luHost = luHost + "        <Value>" + t2[i2] + "</Value>\n";
                luHost = luHost + "    </row>\n";
                item = new PerformanceSummaryItemDO();
                item.setName(linkUtilLabels[i2]);
                item.setValue(t2[i2]);
                utilHost.add(item);
            }
            luHost = luHost + "</Chart>";
            chartData.add(luHost);
        }
        if (storagePerf.size() > 0) {
            String ntStorageUrl = "context+storageUrl&linkUtilization=All&throughput=";
            String ntStorage = "<Chart type=\"Storage\" name =\"Network Throughput\" url=\"" + ntStorageUrl + "\">\n";
            t2 = (int[])storagePerf.get(0);
            for (int i4 = 0; i4 < t2.length; ++i4) {
                ntStorage = ntStorage + "    <row>\n";
                ntStorage = ntStorage + "        <Type>" + netThroughLabels[i4] + "</Type>\n";
                ntStorage = ntStorage + "        <Value>" + t2[i4] + "</Value>\n";
                ntStorage = ntStorage + "    </row>\n";
                item2 = new PerformanceSummaryItemDO();
                item2.setName(netThroughLabels[i4]);
                item2.setValue(t2[i4]);
                throughputStorage.add(item2);
            }
            ntStorage = ntStorage + "</Chart>";
            chartData.add(ntStorage);
            String luStorageUrl = "context+storageUrl&throughput=All&linkUtilization=";
            String luStorage = "<Chart type=\"Storage\" name =\"Link Utilization\" url=\"" + luStorageUrl + "\">\n";
            l2 = (int[])storagePerf.get(1);
            for (i2 = 0; i2 < l2.length; ++i2) {
                luStorage = luStorage + "    <row>\n";
                luStorage = luStorage + "        <Type>" + linkUtilLabels[i2] + "</Type>\n";
                luStorage = luStorage + "        <Value>" + t2[i2] + "</Value>\n";
                luStorage = luStorage + "    </row>\n";
                item = new PerformanceSummaryItemDO();
                item.setName(linkUtilLabels[i2]);
                item.setValue(t2[i2]);
                utilStorage.add(item);
            }
            luStorage = luStorage + "</Chart>";
            chartData.add(luStorage);
        }
        if (islPerf.size() > 0) {
            String ntIslUrl = "context+IslUrl&linkUtilization=All&throughput=";
            String ntIsl = "<Chart type=\"Isl\" name =\"Network Throughput\" url=\"" + ntIslUrl + "\">\n";
            t2 = (int[])islPerf.get(0);
            for (int i5 = 0; i5 < t2.length; ++i5) {
                ntIsl = ntIsl + "    <row>\n";
                ntIsl = ntIsl + "        <Type>" + islThroughLabels[i5] + "</Type>\n";
                ntIsl = ntIsl + "        <Value>" + t2[i5] + "</Value>\n";
                ntIsl = ntIsl + "    </row>\n";
                item2 = new PerformanceSummaryItemDO();
                item2.setName(islThroughLabels[i5]);
                item2.setValue(t2[i5]);
                throughputISL.add(item2);
            }
            ntIsl = ntIsl + "</Chart>";
            chartData.add(ntIsl);
            String luIslUrl = "context+IslUrl&throughput=All&linkUtilization=";
            String luIsl = "<Chart type=\"Isl\" name =\"Link Utilization\" url=\"" + luIslUrl + "\">\n";
            l2 = (int[])islPerf.get(1);
            for (i2 = 0; i2 < l2.length; ++i2) {
                luIsl = luIsl + "    <row>\n";
                luIsl = luIsl + "        <Type>" + linkUtilLabels[i2] + "</Type>\n";
                luIsl = luIsl + "        <Value>" + t2[i2] + "</Value>\n";
                luIsl = luIsl + "    </row>\n";
                item = new PerformanceSummaryItemDO();
                item.setName(linkUtilLabels[i2]);
                item.setValue(t2[i2]);
                utilISL.add(item);
            }
            luIsl = luIsl + "</Chart>";
            chartData.add(luIsl);
        }
        chartData.add("<Chart>\n");
        if (hostPerf.size() > 0) {
            String normalNtHost = "<row>\n";
            normalNtHost = normalNtHost + "  <SnapDate>Hosts%</SnapDate>\n";
            t = (int[])hostPerf.get(0);
            long totalNtHost = 0L;
            for (int i6 = 0; i6 < t.length; ++i6) {
                totalNtHost += (long)t[i6];
            }
            int highestRange = 0;
            for (int i7 = 0; i7 < t.length; ++i7) {
                if (t[i7] < t[highestRange]) continue;
                highestRange = i7;
            }
            double percentTotal = 0.0;
            for (int i8 = 0; i8 < t.length; ++i8) {
                percentTotal += this.percentize(t[i8], totalNtHost, 0.0, false);
            }
            double percentDelta = 100.0 - percentTotal;
            for (int i9 = 0; i9 < t.length; ++i9) {
                normalNtHost = normalNtHost + "  <" + barNetThroughLabels[i9] + ">" + this.percentize(t[i9], totalNtHost, percentDelta, i9 == highestRange) + "</" + barNetThroughLabels[i9] + ">\n";
            }
            normalNtHost = normalNtHost + "</row>\n";
            chartData.add(normalNtHost);
            String luHost = "<row>\n";
            luHost = luHost + "  <SnapDate>Hosts - Link Utilization</SnapDate>\n";
            l = (int[])hostPerf.get(1);
            for (i = 0; i < l.length; ++i) {
                luHost = luHost + "  <" + barLinkUtilLabels[i] + ">" + t[i] + "</" + barLinkUtilLabels[i] + ">\n";
            }
            luHost = luHost + "</row>";
        }
        if (storagePerf.size() > 0) {
            String normalNtStorage = "<row>\n";
            normalNtStorage = normalNtStorage + "  <SnapDate>Storage%</SnapDate>\n";
            t = (int[])storagePerf.get(0);
            long totalNtStorage = 0L;
            for (int i10 = 0; i10 < t.length; ++i10) {
                totalNtStorage += (long)t[i10];
            }
            int highestRange = 0;
            for (int i11 = 0; i11 < t.length; ++i11) {
                if (t[i11] < t[highestRange]) continue;
                highestRange = i11;
            }
            double percentTotal = 0.0;
            for (int i12 = 0; i12 < t.length; ++i12) {
                percentTotal += this.percentize(t[i12], totalNtStorage, 0.0, false);
            }
            double percentDelta = 100.0 - percentTotal;
            for (int i13 = 0; i13 < t.length; ++i13) {
                normalNtStorage = normalNtStorage + "  <" + barNetThroughLabels[i13] + ">" + this.percentize(t[i13], totalNtStorage, percentDelta, i13 == highestRange) + "</" + barNetThroughLabels[i13] + ">\n";
            }
            normalNtStorage = normalNtStorage + "</row>\n";
            chartData.add(normalNtStorage);
            String luStorage = "<row>\n";
            luStorage = luStorage + "  <SnapDate>Storage - Link Utilization</SnapDate>\n";
            l = (int[])storagePerf.get(1);
            for (i = 0; i < l.length; ++i) {
                luStorage = luStorage + "  <" + barLinkUtilLabels[i] + ">" + t[i] + "</" + barLinkUtilLabels[i] + ">\n";
            }
            luStorage = luStorage + "</row>\n";
        }
        if (islPerf.size() > 0) {
            String normalNtIsl = "<row>\n";
            normalNtIsl = normalNtIsl + "  <SnapDate>ISL%</SnapDate>\n";
            t = (int[])islPerf.get(0);
            long totalNtISL = 0L;
            for (int i14 = 0; i14 < t.length; ++i14) {
                totalNtISL += (long)t[i14];
            }
            int highestRange = 0;
            for (int i15 = 0; i15 < t.length; ++i15) {
                if (t[i15] < t[highestRange]) continue;
                highestRange = i15;
            }
            double percentTotal = 0.0;
            for (int i16 = 0; i16 < t.length; ++i16) {
                percentTotal += this.percentize(t[i16], totalNtISL, 0.0, false);
            }
            double percentDelta = 100.0 - percentTotal;
            for (int i17 = 0; i17 < t.length; ++i17) {
                normalNtIsl = normalNtIsl + "  <" + barNetThroughISLLabels[i17] + ">" + this.percentize(t[i17], totalNtISL, percentDelta, i17 == highestRange) + "</" + barNetThroughISLLabels[i17] + ">\n";
            }
            normalNtIsl = normalNtIsl + "</row>\n";
            chartData.add(normalNtIsl);
            String luIsl = "<row>\n";
            luIsl = luIsl + "  <SnapDate>ISL - Link Utilization</SnapDate>\n";
            l = (int[])islPerf.get(1);
            for (i = 0; i < l.length; ++i) {
                luIsl = luIsl + "  <" + barLinkUtilLabels[i] + ">" + t[i] + "</" + barLinkUtilLabels[i] + ">\n";
            }
            luIsl = luIsl + "</row>\n";
        }
        chartData.add("</Chart>\n");
        psdo.setThroughputISL(throughputISL.toArray(new PerformanceSummaryItemDO[throughputISL.size()]));
        psdo.setThroughputHost(throughputHost.toArray(new PerformanceSummaryItemDO[throughputHost.size()]));
        psdo.setThroughputStorage(throughputStorage.toArray(new PerformanceSummaryItemDO[throughputStorage.size()]));
        psdo.setUtilISL(utilISL.toArray(new PerformanceSummaryItemDO[utilISL.size()]));
        psdo.setUtilHost(utilHost.toArray(new PerformanceSummaryItemDO[utilHost.size()]));
        psdo.setUtilStorage(utilStorage.toArray(new PerformanceSummaryItemDO[utilStorage.size()]));
        return chartData;
    }

    private double percentize(long value, long total, double percentDelta, boolean highestRange) {
        if (total == 0L) {
            return 0.0;
        }
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        if (highestRange) {
            return Double.valueOf(twoDForm.format((double)value * Double.valueOf(100.0) / (double)total + percentDelta));
        }
        return Double.valueOf(twoDForm.format((double)value * Double.valueOf(100.0) / (double)total));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPerformanceData(Connection con, CredentialDO credentials, int type, int[] delimiter) throws Exception {
        int[] utilCount;
        int[] dataCount;
        ArrayList<int[]> list;
        block41: {
            list = new ArrayList<int[]>();
            dataCount = new int[]{0, 0, 0, 0, 0, 0};
            utilCount = new int[]{0, 0, 0, 0, 0, 0};
            if (credentials == null) {
                list.add(dataCount);
                list.add(utilCount);
                return list;
            }
            if (!SQLLoader.canExecute()) {
                list.add(dataCount);
                list.add(utilCount);
                return list;
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                String sql = null;
                String prefix = "DashboardAction.";
                switch (type) {
                    case 3: {
                        prefix = prefix + "HOST_";
                        break;
                    }
                    case 4: {
                        prefix = prefix + "STORAGE_";
                        break;
                    }
                    case 1: {
                        prefix = prefix + "ISL_";
                    }
                }
                prefix = this._vsan != -1L ? prefix + "VSAN_" : (this._dbFid >= 0L ? (this._isGroup ? prefix + "GROUP_" : prefix + "FABRIC_") : prefix + "");
                prefix = prefix + "STMT";
                if (this._vsan != -1L) {
                    sql = SQLLoader.getSql(prefix);
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, this._dbFid);
                    stmt.setLong(2, this._vsan);
                } else if (this._dbFid >= 0L) {
                    sql = SQLLoader.getSql(prefix);
                    stmt = con.prepareStatement(sql);
                    if (this._isGroup) {
                        stmt.setLong(1, this._dbFid);
                    } else {
                        stmt.setLong(1, this._dbFid);
                    }
                } else {
                    sql = SQLLoader.getSql(prefix);
                    stmt = con.prepareStatement(sql);
                }
                long MB = 1000000L;
                rs = SQLLoader.execute(stmt);
                Hashtable<String, Long> ht = new Hashtable<String, Long>();
                while (rs.next()) {
                    double throughput;
                    double utilization;
                    long islId = -1L;
                    Double rxTx = PersistentHelper.getHelper().getPmDouble(rs, 1);
                    long speed = rs.getLong(2) / 10L;
                    Double errors = PersistentHelper.getHelper().getPmDouble(rs, 3);
                    Double discards = PersistentHelper.getHelper().getPmDouble(rs, 4);
                    Timestamp updateTime = rs.getTimestamp(5);
                    if (updateTime != null && updateTime.after(LAST_UPDATE_TIME)) {
                        LAST_UPDATE_TIME = updateTime;
                    }
                    if (rxTx.isNaN()) {
                        rxTx = new Double(0.0);
                    }
                    if (errors.isNaN()) {
                        errors = new Double(0.0);
                    }
                    if (discards.isNaN()) {
                        discards = new Double(0.0);
                    }
                    if (Double.isNaN(utilization = (throughput = rxTx.doubleValue()) / (double)(2L * speed)) || speed < 1L) {
                        utilization = 0.0;
                    }
                    throughput = Math.round(throughput);
                    utilization = (long)(utilization * 100.0);
                    if (type == 1) {
                        islId = rs.getLong(6);
                        if (this.isCounted(ht, islId)) continue;
                        ht.put(islId + "", new Long(islId));
                        this._totalThroughput += throughput;
                        this._totalUtilization += utilization;
                        ++this._totalRows;
                    } else {
                        this._totalThroughput += throughput;
                        this._totalUtilization += utilization;
                        ++this._totalRows;
                    }
                    this._totalThroughput = Math.round(this._totalThroughput);
                    this._totalUtilization = Math.round(this._totalUtilization);
                    if (throughput >= (double)((long)delimiter[4] * MB)) {
                        dataCount[5] = dataCount[5] + 1;
                    } else if (throughput >= (double)((long)delimiter[3] * MB) && throughput < (double)((long)delimiter[4] * MB)) {
                        dataCount[4] = dataCount[4] + 1;
                    } else if (throughput >= (double)((long)delimiter[2] * MB) && throughput < (double)((long)delimiter[3] * MB)) {
                        dataCount[3] = dataCount[3] + 1;
                    } else if (throughput >= (double)((long)delimiter[1] * MB) && throughput < (double)((long)delimiter[2] * MB)) {
                        dataCount[2] = dataCount[2] + 1;
                    } else if (throughput >= (double)((long)delimiter[0] * MB) && throughput < (double)((long)delimiter[1] * MB)) {
                        dataCount[1] = dataCount[1] + 1;
                    } else {
                        dataCount[0] = dataCount[0] + 1;
                    }
                    if (utilization >= 80.0) {
                        utilCount[5] = utilCount[5] + 1;
                        continue;
                    }
                    if (utilization >= 60.0 && utilization < 80.0) {
                        utilCount[4] = utilCount[4] + 1;
                        continue;
                    }
                    if (utilization >= 40.0 && utilization < 60.0) {
                        utilCount[3] = utilCount[3] + 1;
                        continue;
                    }
                    if (utilization >= 20.0 && utilization < 40.0) {
                        utilCount[2] = utilCount[2] + 1;
                        continue;
                    }
                    if (utilization >= 10.0 && utilization < 20.0) {
                        utilCount[1] = utilCount[1] + 1;
                        continue;
                    }
                    utilCount[0] = utilCount[0] + 1;
                }
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                this._Log.error((Object)"SQL Error in PerformanceSummaryHandler ", (Throwable)ex);
                break block41;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
            DbUtil.close(stmt);
        }
        list.add(dataCount);
        list.add(utilCount);
        return list;
    }

    private boolean isCounted(Hashtable ht, long id) {
        Object obj = ht.get(id + "");
        return obj != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIslCount(Connection con, DbFilterDO dbFilter) {
        int totalCount;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            String sql = null;
            rs = null;
            totalCount = 0;
            long dbid = dbFilter.getFabricDbId();
            try {
                if (dbid >= 0L) {
                    sql = SQLLoader.getSql("DashboardFlex.COUNT_ISL_FABRIC_STMT");
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, dbid);
                } else {
                    sql = SQLLoader.getSqlWithoutLicensingCheck("DashboardFlex.COUNT_ISL_STMT");
                    stmt = con.prepareStatement(sql);
                }
                rs = SQLLoader.execute(stmt);
                if (!rs.next()) break block6;
                totalCount = rs.getInt(1);
            }
            catch (SQLException ex) {
                try {
                    this._Log.error((Object)"Exception in PerformanceSummaryHandler.getISLs ", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEthIslCount(Connection con, DbFilterDO dbFilter) {
        int regularCount;
        ResultSet rs9;
        PreparedStatement stmt1;
        block4: {
            stmt1 = null;
            String sql = null;
            rs9 = null;
            regularCount = 0;
            try {
                sql = SQLLoader.getSql("SummaryAction.LAN_ISL_REGULAR_STMT");
                stmt1 = con.prepareStatement(sql);
                rs9 = SQLLoader.execute(stmt1);
                if (!rs9.next()) break block4;
                regularCount = rs9.getInt(1);
            }
            catch (SQLException ex) {
                try {
                    this._Log.error((Object)"Exception in PerformanceSummaryHandler.getEthIslCount ", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs9);
                    DbUtil.close(stmt1);
                    throw throwable;
                }
                DbUtil.close(rs9);
                DbUtil.close(stmt1);
            }
        }
        DbUtil.close(rs9);
        DbUtil.close(stmt1);
        return regularCount;
    }

    public int getZoneSize(DbFilterDO dbFilter) {
        FabricImpl[] fabricList;
        int numberZones = 0;
        for (FabricImpl fImpl : fabricList = SanManager.getInstance().getFabrics()) {
            VsanImpl[] vsanList;
            for (VsanImpl vImpl : vsanList = fImpl.getVsans()) {
                ZoneBase[] zoneList = vImpl.getEnforcedZones();
                if (zoneList == null) continue;
                numberZones += zoneList.length;
                for (ZoneBase z : zoneList) {
                    this._Log.debug((Object)("Vsan " + vImpl.getName() + " zone " + z.getName()));
                }
            }
            List<ZoneBase> ivrZoneList = fImpl.getAllIvrEnforcedZones();
            if (ivrZoneList == null) continue;
            numberZones += ivrZoneList.size();
            for (ZoneBase z : ivrZoneList) {
                this._Log.debug((Object)("ivr zone " + z.getName()));
            }
        }
        return numberZones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPmRunning(Connection con, DbFilterDO dbFilter) {
        this._Log.debug((Object)"isPMRunning?");
        boolean found = false;
        PreparedStatement stmt = null;
        String sql = null;
        ResultSet rs = null;
        try {
            sql = dbFilter.getFabricDbId() > 0L ? SQLLoader.getSql("DashboardFlex.PM_STATUS_FABRIC_STMT") : SQLLoader.getSql("DashboardFlex.PM_STATUS_STMT");
            stmt = con.prepareStatement(sql);
            if (dbFilter.getFabricDbId() > 0L) {
                stmt.setLong(1, dbFilter.getFabricDbId());
            }
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                found = true;
                boolean isl = rs.getBoolean(1);
                boolean host = rs.getBoolean(2);
                boolean storage = rs.getBoolean(3);
                Timestamp t = rs.getTimestamp(4);
                this._Log.debug((Object)("Dashboard.PM status query mon isl=" + isl + " mon host=" + host + " mon stor=" + storage + "lastUpdated=" + t));
            }
        }
        catch (SQLException ex) {
            try {
                this._Log.error((Object)"Exception in PerformanceSummaryHandler.getEthIslCount ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return found;
    }
}

