/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.san.wo.StatDO;
import com.cisco.dcbu.jaxws.san.wo.StatisticsDataDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.NameValueDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.pm.PmChart;
import com.cisco.dcbu.sm.server.pm.PmCollect;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.inventory.HostEnclHandler;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.NavigationUtil;
import com.cisco.dcbu.sm.server.web.util.PerfUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.util.WebUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EndDeviceStatHandler {
    public static final String PORT_GROUPS = "Port Groups";
    public static final String STORAGE_ENCLOSURES = "Storage Enclosures";
    public static final String HOST_ENCLOSURES = "Host Enclosures";
    public static final String ALL_PORTS = "All Ports";
    public static final String STORAGE_PORTS = "Storage Ports";
    public static final String HOST_PORTS = "Host Ports";
    private static EndDeviceStatHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private DateFormat _dateFormat;
    private Map<String, String> _Name2SqlHash;
    private Map<String, String> _FilterHash;
    private boolean sortAsc = true;
    private Comparator<StatisticsDataDO> c = new Comparator<StatisticsDataDO>(){

        @Override
        public int compare(StatisticsDataDO o1, StatisticsDataDO o2) {
            int tmp;
            int n = tmp = EndDeviceStatHandler.this.sortAsc ? 1 : -1;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return -1 * tmp;
            }
            if (o2 == null && o1 != null) {
                return 1 * tmp;
            }
            if (o1 == o2) {
                return 0;
            }
            return o1.getEntityName().compareTo(o2.getEntityName()) * tmp;
        }
    };

    public static EndDeviceStatHandler getInstance() {
        if (_Instance == null) {
            _Instance = new EndDeviceStatHandler();
        }
        return _Instance;
    }

    private EndDeviceStatHandler() {
        this._Name2SqlHash = new HashMap<String, String>();
        this._FilterHash = new HashMap<String, String>();
        this.initSqlSortSuffix();
    }

    public ArrayList<StatisticsDataDO> getEndDeviceStatList(DbFilterDO dbFilter, String asked, String interval, int startIdx, int recordSize, boolean calculateLimit) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        this.getEndDeviceStatListWithVsan(records, dbFilter, asked, interval, startIdx, recordSize, false, calculateLimit);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getEndDeviceStatListWithVsan(ArrayList<StatisticsDataDO> records, DbFilterDO dbFilter, String asked, String interval, int startIdx, int recordSize, boolean lengthOnly, boolean calculateLimit) {
        block41: {
            Connection con = null;
            PreparedStatement stmt = null;
            Statement infoStmt = null;
            ResultSet rs = null;
            ResultSet rsInfo = null;
            String filterStr = "";
            if (dbFilter.getFilterStr() != null && dbFilter.getFilterStr().contains("&")) {
                filterStr = " AND STAT.SRC_ID=" + dbFilter.getFilterStr().split("&")[0] + " AND STAT.DEST_ID=" + dbFilter.getFilterStr().split("&")[1];
            }
            String groupFabricFilterSqlSuffix = NavigationUtil.getInstance().getFabricIdsInGroup(dbFilter.getGroupFilterXml());
            String colFilterSqlSuffix = WebUtil.getColFilterSql(dbFilter.getColFilterStr(), this._FilterHash);
            filterStr = filterStr + groupFabricFilterSqlSuffix + colFilterSqlSuffix;
            String suffix = this.getSqlSortSuffix(dbFilter.getSortField(), dbFilter.getSortType(), interval);
            suffix = suffix == null ? " ORDER BY " + PersistentHelper.getHelper().getNanVL("STAT.TOTAL_RXTX") + " DESC, FABRIC.NAME ASC" : " ORDER BY " + suffix;
            if (dbFilter.getFilterId() >= 0) {
                suffix = this.getThroughputSql(dbFilter.getFilterId()) + suffix;
            }
            try {
                con = ConnectionManager.getConnection();
                String sql = null;
                String avgRxCol = PerfUtil.getAvgIntervalColumn(interval) + "RX";
                String avgTxCol = PerfUtil.getAvgIntervalColumn(interval) + "TX";
                String maxRxCol = PerfUtil.getMaxIntervalColumn(interval) + "RX";
                String maxTxCol = PerfUtil.getMaxIntervalColumn(interval) + "TX";
                String errorCol = PerfUtil.getErrorIntervalColumn(interval);
                String discardCol = PerfUtil.getDiscardIntervalColumn(interval);
                String totalCol = PerfUtil.getTotalIntervalColumn(interval);
                String typeCol = " ( STAT.TYPE=3)OR (STAT.TYPE=4) ";
                if (asked.equals(STORAGE_PORTS) || asked.equals(STORAGE_ENCLOSURES)) {
                    typeCol = " (STAT.TYPE=4) ";
                } else if (asked.equals(HOST_PORTS) || asked.equals(HOST_ENCLOSURES)) {
                    typeCol = " (STAT.TYPE=3) ";
                }
                int[] indices = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
                String[] columns = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, typeCol};
                String prefix = "PerformanceAction.";
                String roleFilter = "FABRIC.LICENSE_ID > 1 ";
                int[] ind = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 99};
                String[] rep = new String[]{avgRxCol, avgTxCol, maxRxCol, maxTxCol, errorCol, discardCol, totalCol, typeCol, roleFilter};
                sql = SQLLoader.getSql(prefix + "END_DEVICE_STAT_VSAN_STMT", ind, rep);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + filterStr + suffix, 1004, 1007);
                long sTime = System.currentTimeMillis();
                rs = SQLLoader.execute(stmt);
                if (lengthOnly) {
                    rs.last();
                    int n = rs.getRow();
                    DbUtil.close(rs);
                    DbUtil.close(rsInfo);
                    DbUtil.close(infoStmt);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    return n;
                }
                sTime = System.currentTimeMillis();
                long eTime = System.currentTimeMillis();
                this._Log.info((Object)("vsan info query time: " + (eTime - sTime)));
                int noOfRecords = 0;
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    String fabric = rs.getString(1);
                    long srcId = rs.getLong(2);
                    long dstId = rs.getLong(3);
                    double rx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 4));
                    double tx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 5));
                    double maxRx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 6));
                    double maxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 7));
                    double errors = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 8));
                    double discards = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 9));
                    long speed = rs.getLong(10) / 10L;
                    long sourceId = rs.getLong(11);
                    String rrd = rs.getString(13);
                    String name = "Unknown";
                    byte[] srcWwn = rs.getBytes(15);
                    String src = null;
                    if (src == null) {
                        src = rs.getString(14);
                    }
                    double rxTx = DisplayUtil.formatPmStat(PersistentHelper.getHelper().getPmDouble(rs, 18));
                    int paramType = rs.getInt(19);
                    long switchId = rs.getLong(22);
                    long enclosureId = rs.getLong(23);
                    Timestamp lastUpdated = rs.getTimestamp(25);
                    String switchName = rs.getString(26);
                    String alias = rs.getString(28);
                    String portName = rs.getString(29);
                    long fid = rs.getLong(30);
                    src = alias == null ? portName : alias;
                    long vfcBindIfIndex = rs.getLong(31);
                    String ifName = rs.getString(32);
                    int modelType = rs.getInt(33);
                    int vsanId = rs.getInt(34);
                    int rxUtil = -1;
                    int txUtil = -1;
                    int pRxUtil = -1;
                    int pTxUtil = -1;
                    StatisticsDataDO wrapper = null;
                    double tp = Double.isNaN(rxTx) ? 0.0 : rxTx;
                    src = src == null || "".equals(src) ? DisplayUtil.getWwn(srcWwn).toString() : src;
                    wrapper = new StatisticsDataDO(srcId, dstId);
                    ++noOfRecords;
                    if (src != null) {
                        name = src;
                    }
                    if (speed == 0L && FRUConstants.isN5K(modelType)) {
                        speed = 1000000000L;
                    }
                    if (speed > 0L) {
                        rx = this.capTrafficWithSpeed(rx, speed);
                        tx = this.capTrafficWithSpeed(tx, speed);
                        maxRx = this.capTrafficWithSpeed(maxRx, speed);
                        maxTx = this.capTrafficWithSpeed(maxTx, speed);
                        rxUtil = !Double.isNaN(rx) ? (int)(rx / (double)speed * 100.0) : -1;
                        txUtil = !Double.isNaN(tx) ? (int)(tx / (double)speed * 100.0) : -1;
                        pRxUtil = !Double.isNaN(maxRx) ? (int)(maxRx / (double)speed * 100.0) : -1;
                        pTxUtil = !Double.isNaN(maxTx) ? (int)(maxTx / (double)speed * 100.0) : -1;
                    }
                    wrapper.setLastUpdate(((Date)lastUpdated).getTime());
                    wrapper.setLastUpdateTimeStr(this.getDateFormat().format(lastUpdated));
                    wrapper.setFabric(fabric);
                    wrapper.setLastDayAvgRx(rx);
                    wrapper.setLastDayAvgTx(tx);
                    wrapper.setLastDayMaxRx(maxRx);
                    wrapper.setLastDayMaxTx(maxTx);
                    wrapper.setSpeedStr(DisplayUtil.formatSpeed(speed * 10L));
                    if (speed == 0L) {
                        wrapper.setSpeedStr("n/a");
                    }
                    wrapper.setVsanStrForEP(String.valueOf(vsanId));
                    wrapper.setAvgRxStr(!Double.isNaN(rx) ? DefaultSnmpNumberRenderer.formatLong((long)rx) : "n/a");
                    wrapper.setAvgTxStr(!Double.isNaN(tx) ? DefaultSnmpNumberRenderer.formatLong((long)tx) : "n/a");
                    wrapper.setMaxRxStr(!Double.isNaN(maxRx) ? DefaultSnmpNumberRenderer.formatLong((long)maxRx) : "n/a");
                    wrapper.setMaxTxStr(!Double.isNaN(maxTx) ? DefaultSnmpNumberRenderer.formatLong((long)maxTx) : "n/a");
                    wrapper.setErrorStr(!Double.isNaN(errors) ? DefaultSnmpNumberRenderer.formatLong((long)errors) : "n/a");
                    wrapper.setDiscardStr(!Double.isNaN(discards) ? DefaultSnmpNumberRenderer.formatLong((long)discards) : "n/a");
                    wrapper.setRxTxStr(!Double.isNaN(rxTx) ? DefaultSnmpNumberRenderer.formatLong((long)rxTx) : "n/a");
                    wrapper.setRxTx(rxTx);
                    wrapper.setEnclDbId(enclosureId);
                    if (interval != null) {
                        if (interval.equals("24 Hours")) {
                            wrapper.setLastDayAvgRx(rx);
                            wrapper.setLastDayAvgTx(tx);
                            wrapper.setLastDayMaxRx(maxRx);
                            wrapper.setLastDayMaxTx(maxTx);
                        } else if (interval.equals("Week")) {
                            wrapper.setLastWeekAvgRx(rx);
                            wrapper.setLastWeekAvgTx(tx);
                            wrapper.setLastWeekMaxRx(maxRx);
                            wrapper.setLastWeekMaxTx(maxTx);
                        } else if (interval.equals("Month")) {
                            wrapper.setLastMonthAvgRx(rx);
                            wrapper.setLastMonthAvgTx(tx);
                            wrapper.setLastMonthMaxRx(maxRx);
                            wrapper.setLastMonthMaxTx(maxTx);
                        } else if (interval.equals("Year")) {
                            wrapper.setLastYearAvgRx(rx);
                            wrapper.setLastYearAvgTx(tx);
                            wrapper.setLastYearMaxRx(maxRx);
                            wrapper.setLastYearMaxTx(maxTx);
                        }
                    }
                    wrapper.setSpeed(speed);
                    wrapper.setTitle(name);
                    wrapper.setEntityName(name);
                    wrapper.setPmtype(paramType);
                    wrapper.setRrdFile(rrd);
                    wrapper.setFid(fid);
                    wrapper.setIndex(curIdx + startIdx + 1);
                    if (switchName != null) {
                        wrapper.setSwIfName(switchName + " " + ifName);
                    } else {
                        wrapper.setSwIfName(ifName);
                    }
                    wrapper.setBindEntityName("");
                    wrapper.setBindRrdFile("");
                    if (vfcBindIfIndex != -1L) {
                        PreparedStatement bind_stmt = null;
                        ResultSet bind_rs = null;
                        try {
                            String bind_sql = "SELECT SP.IF_NAME, SP.IF_TYPE, STAT.RRD_FILE FROM SWITCH_PORT SP, STATISTICS STAT WHERE (STAT.SRC_ID=SP.ID) AND (SP.IF_INDEX=?) AND (SP.SWITCH_ID=?)";
                            bind_stmt = PersistentHelper.getHelper().getPreparedStmt(con, bind_sql, 1004, 1007);
                            bind_stmt.setLong(1, vfcBindIfIndex);
                            bind_stmt.setLong(2, switchId);
                            bind_rs = SQLLoader.execute(bind_stmt);
                            while (bind_rs.next()) {
                                String bind_ifName = bind_rs.getString(1);
                                String bind_rrd = bind_rs.getString(3);
                                if (bind_ifName != null) {
                                    wrapper.setBindEntityName(switchName + " " + bind_ifName);
                                }
                                if (bind_rrd == null) continue;
                                wrapper.setBindRrdFile(bind_rrd);
                            }
                        }
                        catch (Exception ex) {
                            try {
                                this._Log.error((Object)"EndDeviceStatHandler error In Binding Stmt", (Throwable)ex);
                            }
                            catch (Throwable throwable) {
                                DbUtil.close(bind_rs);
                                DbUtil.close(bind_stmt);
                                throw throwable;
                            }
                            DbUtil.close(bind_rs);
                            DbUtil.close(bind_stmt);
                        }
                        DbUtil.close(bind_rs);
                        DbUtil.close(bind_stmt);
                    }
                    int threshold = PmCollect._MetaData._thresholdDef._highWaterMark;
                    wrapper.setHighThreshold(threshold);
                    wrapper.setRxUtil(rxUtil);
                    wrapper.setTxUtil(txUtil);
                    wrapper.setpRxUtil(pRxUtil);
                    wrapper.setpTxUtil(pTxUtil);
                    if (calculateLimit) {
                        int pmType = 3;
                        if (asked.equals(STORAGE_PORTS)) {
                            pmType = 4;
                        }
                        double limit = speed * (long)threshold / 100L;
                        double exceedPct = PerfUtil.getExceedThresholdCoumn(rrd, pmType, (int)fid, 1, limit);
                        wrapper.setExceedPct(exceedPct);
                    }
                    records.add(wrapper);
                    if (++curIdx < recordSize) continue;
                }
                eTime = System.currentTimeMillis();
                this._Log.info((Object)("Real query time: " + (eTime - sTime)));
                DbUtil.close(rs);
            }
            catch (SQLException ex) {
                this._Log.error((Object)"EndDeviceStatHandler error", (Throwable)ex);
                break block41;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (Exception ex2) {
                    this._Log.error((Object)"EndDeviceStatHandler error", (Throwable)ex2);
                    break block41;
                }
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(rsInfo);
                DbUtil.close(infoStmt);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(rsInfo);
            DbUtil.close(infoStmt);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        if (records.size() <= 0) return records.size();
        if (!"entityName".equals(dbFilter.getSortField())) return records.size();
        this.sortAsc = "ASC".equals(dbFilter.getSortType());
        Collections.sort(records, this.c);
        this.resetIndexForRecords(records);
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NameValueDO[] getInterfacePmData(long interfaceDbId) throws Exception {
        ArrayList<NameValueDO> pmData = new ArrayList<NameValueDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String sql = "SELECT  STAT.rrd_File, STAT.type from STATISTICS STAT WHERE STAT.SRC_ID = ? OR STAT.DEST_ID = ? ORDER BY STAT.last_update_time";
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.setLong(1, interfaceDbId);
            stmt.setLong(2, interfaceDbId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                String rrdFile = rs.getString(1);
                int pmType = rs.getInt(2);
                pmData.add(new NameValueDO("rrdFile", rrdFile));
                pmData.add(new NameValueDO("pmType", "" + pmType));
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return pmData.toArray(new NameValueDO[0]);
    }

    public double[][] getDataInEnclosure(long encId, int pmType, int chartType) throws Exception {
        double[][] totalStats = null;
        double[][] stats = null;
        long[] interval = null;
        try {
            interval = PmChart.getInterval(chartType, -1L, -1L);
            List<String> rrdList = HostEnclHandler.getInstance().getRrd(encId, pmType);
            for (String rrdFidStr : rrdList) {
                String[] rstArr = rrdFidStr.split(";");
                String rrdFile = rstArr[0];
                int fid = Integer.parseInt(rstArr[1]);
                PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new FabricPK(fid));
                stats = pmRif.getPmChartData(rrdFile, pmType == 12 ? 3 : 4, chartType);
                if (totalStats == null) {
                    totalStats = new double[stats.length][5];
                }
                for (int i = 0; i < stats.length; ++i) {
                    double[] dArray = totalStats[i];
                    dArray[0] = dArray[0] + stats[i][0];
                    double[] dArray2 = totalStats[i];
                    dArray2[1] = dArray2[1] + stats[i][1];
                    totalStats[i][2] = stats[i][2];
                    totalStats[i][3] = stats[i][3];
                    totalStats[i][4] = stats[i][4];
                }
            }
            if (totalStats == null || totalStats.length == 0) {
                throw new Exception("No chart data found");
            }
            StatDO[] statArr = new StatDO[totalStats.length];
            for (int i = 0; i < totalStats.length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2]);
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return totalStats;
    }

    private void resetIndexForRecords(ArrayList<StatisticsDataDO> records) {
        for (int i = 0; i < records.size(); ++i) {
            StatisticsDataDO sdo = records.get(i);
            sdo.setIndex(i + 1);
        }
    }

    private double capTrafficWithSpeed(double traffic, long speed) {
        double ret = traffic;
        if (traffic > (double)speed) {
            ret = speed;
        }
        return ret;
    }

    public int getEndDeviceStatDataLength(DbFilterDO dbFilter, String asked, String interval) {
        ArrayList<StatisticsDataDO> records = new ArrayList<StatisticsDataDO>();
        return this.getEndDeviceStatListWithVsan(records, dbFilter, asked, interval, 0, 1, true, false);
    }

    private DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        }
        return this._dateFormat;
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("displayName", " ORDER BY NPORTS.ALIAS ");
        this._Name2SqlHash.put("Name", " ORDER BY NPORTS.ALIAS ");
        this._Name2SqlHash.put("enclosure", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("Enclosure", " ORDER BY ENC.NAME ");
        this._FilterHash.put("vsanStrForEP", " vsan.vsan_id = ");
    }

    private String getSqlSortSuffix(String sortField, String sortType, String interval) {
        if (sortField == null || sortField.equals("")) {
            return null;
        }
        if (sortType == null || sortType.trim().length() == 0) {
            sortType = "DESC";
        }
        StringBuilder sortStr = new StringBuilder();
        if (sortField.equals("avgRxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getAvgIntervalColumn(interval) + "RX"));
        } else if (sortField.equals("avgTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getAvgIntervalColumn(interval) + "TX"));
        } else if (sortField.equals("maxRxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getMaxIntervalColumn(interval) + "RX"));
        } else if (sortField.equals("maxTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getMaxIntervalColumn(interval) + "TX"));
        } else if (sortField.equals("errorStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getErrorIntervalColumn(interval)));
        } else if (sortField.equals("discardStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getDiscardIntervalColumn(interval)));
        } else if (sortField.equals("rxTxStr")) {
            sortStr.append(PersistentHelper.getHelper().getNanVL(PerfUtil.getTotalIntervalColumn(interval)));
        } else if (sortField.equals("speedStr")) {
            sortStr.append("SP.IF_SPEED");
        } else if (sortField.equals("entityName")) {
            sortStr.append("END_PORT.ALIAS");
        } else if (sortField.equals("swIfName")) {
            sortStr.append("SWITCH.SYS_NAME " + sortType + ", SP.DISPLAY_NAME " + sortType);
        } else if (sortField.equals("rxUtil")) {
            sortStr.append("RX_UTIL");
        } else if (sortField.equals("txUtil")) {
            sortStr.append("TX_UTIL");
        } else if (sortField.equals("pRxUtil")) {
            sortStr.append("PEAK_RX_UTIL");
        } else if (sortField.equals("pTxUtil")) {
            sortStr.append("PEAK_TX_UTIL");
        } else {
            sortStr.append(PerfUtil.getTotalIntervalColumn(interval));
        }
        if (!sortField.equals("swIfName")) {
            sortStr.append(" ").append(sortType);
        }
        return sortStr.toString();
    }

    private String getThroughputSql(int idx) {
        String sql = "";
        switch (idx) {
            case 0: {
                return " AND (stat.total_rxtx >= 0 and stat.total_rxtx < 10000000) ";
            }
            case 1: {
                return " AND (stat.total_rxtx >= 10000000 and stat.total_rxtx < 20000000) ";
            }
            case 2: {
                return " AND (stat.total_rxtx >= 20000000 and stat.total_rxtx < 40000000) ";
            }
            case 3: {
                return " AND (stat.total_rxtx >= 40000000 and stat.total_rxtx < 60000000) ";
            }
            case 4: {
                return " AND (stat.total_rxtx >= 60000000 and stat.total_rxtx < 100000000) ";
            }
            case 5: {
                return " AND (stat.total_rxtx >= 100000000) ";
            }
        }
        return sql;
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        dbFilter.setSortField("rxTxStr");
        System.out.println("*********get storage ************ :");
        int length = EndDeviceStatHandler.getInstance().getEndDeviceStatDataLength(dbFilter, STORAGE_PORTS, "24 Hours");
        System.out.println("length is : " + length);
        ArrayList<StatisticsDataDO> rstList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, STORAGE_PORTS, "24 Hours", 0, 10, true);
        int count = 0;
        for (StatisticsDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getRxTxStr() + ":" + e.getEntityName() + " : " + e.getLastUpdateTimeStr() + ":" + e.getRrdFile() + ":" + e.getFid() + ":" + e.getPmtype());
        }
        System.out.println("*********get host ************ :");
        length = EndDeviceStatHandler.getInstance().getEndDeviceStatDataLength(dbFilter, HOST_PORTS, "24 Hours");
        rstList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, HOST_PORTS, "24 Hours", 0, 10, true);
        count = 0;
        for (StatisticsDataDO e : rstList) {
            System.out.println(count++ + " : " + e.getRxTxStr() + ":" + e.getEntityName() + " : " + e.getLastUpdateTimeStr() + ":" + e.getRrdFile() + ":" + e.getFid() + ":" + e.getPmtype());
        }
    }

    public String printEndDeviceStatTable(DbFilterDO dbFilter, String asked, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, asked, interval, startIdx, recordSize, false);
        String title = "Performance All Ports";
        if (asked.equals(STORAGE_PORTS)) {
            title = "Performance Storage Ports";
        } else if (asked.equals(HOST_PORTS)) {
            title = "Performance Host Ports";
        }
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("VSAN", HorizontalAlign.RIGHT);
        columnAlignment.put("Speed", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg.", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg%", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak%", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxUtil", "rxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "txUtil", "txUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pRxUtil", "pRxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pTxUtil", "pTxUtilStr");
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, columnAlignment, rstList);
    }

    public String exportEndDeviceStatTable(DbFilterDO dbFilter, String asked, String interval, int startIdx, int recordSize, String[] columnHeader) {
        ArrayList<StatisticsDataDO> rstList = EndDeviceStatHandler.getInstance().getEndDeviceStatList(dbFilter, asked, interval, startIdx, recordSize, false);
        String title = "Performance All Ports";
        if (asked.equals(STORAGE_PORTS)) {
            title = "Performance Storage Ports";
        } else if (asked.equals(STORAGE_ENCLOSURES)) {
            title = "Performance Storage Enclosure";
        } else if (asked.equals(HOST_PORTS)) {
            title = "Performance Host Ports";
        } else if (asked.equals(HOST_ENCLOSURES)) {
            title = "Performance Host Enclosure";
        }
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("VSAN", HorizontalAlign.RIGHT);
        columnAlignment.put("Speed", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg.", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg%", HorizontalAlign.RIGHT);
        columnAlignment.put("Rx+Tx", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak", HorizontalAlign.RIGHT);
        columnAlignment.put("Peak%", HorizontalAlign.RIGHT);
        columnAlignment.put("Errors", HorizontalAlign.RIGHT);
        columnAlignment.put("Discards", HorizontalAlign.RIGHT);
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxUtil", "rxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "txUtil", "txUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pRxUtil", "pRxUtilStr");
        JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "pTxUtil", "pTxUtilStr");
        boolean unitlessFlag = true;
        String export_unitless = System.getProperties().getProperty("export.unitless");
        if (export_unitless != null) {
            unitlessFlag = Boolean.getBoolean("export.unitless");
        }
        String export_unit = System.getProperties().getProperty("export.unit");
        if (unitlessFlag) {
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "speedStr", "speed");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgRxStr", "lastDayAvgRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "avgTxStr", "lastDayAvgTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "rxTxStr", "rxTx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxRxStr", "lastDayMaxRx");
            JasperPrintGenerator.getInstance().replaceColumnHeaderString(columnHeader, "maxTxStr", "lastDayMaxTx");
        } else if (export_unit != null) {
            DisplayUtil.convertToExportUnit(rstList, export_unit);
        }
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, columnAlignment, rstList);
    }
}

