/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.inventory;

import com.cisco.dcbu.jaxws.san.wo.CallResultDO;
import com.cisco.dcbu.jaxws.san.wo.EnclosureDO;
import com.cisco.dcbu.jaxws.san.wo.StatDO;
import com.cisco.dcbu.jaxws.san.wo.TopoTrafficDO;
import com.cisco.dcbu.jaxws.san.wo.TopoTrafficItemDO;
import com.cisco.dcbu.jaxws.san.wo.VmDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.util.HashedArrayList;
import com.cisco.dcbu.lib.util.StringEncrypter;
import com.cisco.dcbu.sm.common.event.LogEventType;
import com.cisco.dcbu.sm.common.event.Severity;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.FabricPK;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.common.type.VcenterPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.model.HostImpl;
import com.cisco.dcbu.sm.server.model.HostManager;
import com.cisco.dcbu.sm.server.model.PhyNicImpl;
import com.cisco.dcbu.sm.server.model.VHostImpl;
import com.cisco.dcbu.sm.server.pm.PmChart;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.vi.model.ViManager;
import com.cisco.dcbu.vi.model.VirtualCenterBase;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class HostEnclHandler {
    private static HostEnclHandler _Instance = null;
    private static final String NOT_APPLICABLE = "NA";
    private static final int ERR_STATUS = -1;
    public static final int TRAFFIC_FOR_TX = 0;
    public static final int TRAFFIC_FOR_RX = 1;
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    private String _CountPortSqlHost = "SELECT  ENC.ID ,COUNT(SP.ID) FROM END_PORT EP,ENCLOSURE ENC,SWITCH_PORT SP WHERE  ( EP.SWITCH_PORT_ID = SP.ID )  AND ( EP.ENCLOSURE_ID = ENC.ID ) AND ( ENC.ENC_TYPE=47) group by (ENC.ID)";
    private String _CountPortSqlStorage = "SELECT  ENC.ID ,COUNT(SP.ID) FROM END_PORT EP,ENCLOSURE ENC,SWITCH_PORT SP WHERE  ( EP.SWITCH_PORT_ID = SP.ID )  AND ( EP.ENCLOSURE_ID = ENC.ID ) AND ( ENC.ENC_TYPE!=47) group by (ENC.ID)";
    public static final int LAN_ENCLOSURE = 15;

    public static HostEnclHandler getInstance() {
        if (_Instance == null) {
            _Instance = new HostEnclHandler();
        }
        return _Instance;
    }

    private HostEnclHandler() {
        this.initSqlSortSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countPort(Connection con, boolean isHost, Map<Long, String> _CountMap) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(isHost ? this._CountPortSqlHost : this._CountPortSqlStorage);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                long hostEnclId = rs.getLong(1);
                int fcportCnt = rs.getInt(2);
                _CountMap.put(hostEnclId, fcportCnt + "");
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EnclosureDO> getHostEnclList(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isHost) {
        ArrayList<EnclosureDO> resultList;
        block11: {
            if (isHost) {
                return this.getHostEnclList(dbFilter, startIdx, recordSize);
            }
            HashMap _CountMap = new HashMap();
            String sqlSt = "StorageEnclHandler.DATA_LIST_STMT";
            resultList = new ArrayList<EnclosureDO>();
            HashMap<String, String> _Storage2SqlHash = new HashMap<String, String>();
            _Storage2SqlHash.put("name", " ORDER BY S_ENC.NAME ");
            _Storage2SqlHash.put("Name", " ORDER BY S_ENC.NAME ");
            _Storage2SqlHash.put("storage_system_id", " ORDER BY S_ENC.STORAGE_SYSTEM_ID > 0 ");
            String sortSql = (String)_Storage2SqlHash.get(dbFilter.getSortField());
            String sortSqlSuffix = "";
            if (sortSql != null) {
                sortSqlSuffix = (String)_Storage2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
            }
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            String filterSql = this.getFilterSql(dbFilter.getFilterStr());
            try {
                con = ConnectionManager.getConnection();
                long start = System.currentTimeMillis();
                sql = SQLLoader.getSqlStmt(sqlSt, false);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + filterSql + sortSqlSuffix, 1004, 1007);
                long end = System.currentTimeMillis();
                start = System.currentTimeMillis();
                rs = SQLLoader.execute(stmt);
                end = System.currentTimeMillis();
                this.timer(start, end, "Sql Execution");
                start = System.currentTimeMillis();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long hostEnclId = rs.getLong(1);
                    String hostEncName = rs.getString(2);
                    String ipAddrStr = rs.getString(3);
                    long stor_sys_id = rs.getLong(4);
                    int fcportCnt = 0;
                    EnclosureDO enclDo = new EnclosureDO();
                    enclDo.setEnclId(hostEnclId);
                    enclDo.setName(hostEncName);
                    enclDo.setIpAddress(ipAddrStr);
                    enclDo.setIndex(curIdx + startIdx + 1);
                    enclDo.setStorageSystemId(stor_sys_id);
                    List<String> wwnStrings = this.getWwnForEnclosure(hostEnclId, con);
                    if (wwnStrings != null) {
                        StringBuffer buf = new StringBuffer();
                        for (int i = 0; i < wwnStrings.size(); ++i) {
                            ++fcportCnt;
                            buf.append(wwnStrings.get(i));
                            if (i >= wwnStrings.size() - 1) continue;
                            buf.append(", ");
                        }
                        enclDo.setWwnStr(buf.toString());
                    }
                    enclDo.setFcportCnt(fcportCnt);
                    resultList.add(enclDo);
                    if (++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block11;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<EnclosureDO> getHostEnclList(DbFilterDO dbFilter, int startIdx, int recordSize) {
        ArrayList<EnclosureDO> resultList;
        long fStart;
        block22: {
            fStart = System.currentTimeMillis();
            HashMap<Long, String> _vmUsageMap = new HashMap<Long, String>();
            HashMap<Long, List<VmDO>> _Host2vmHash = new HashMap<Long, List<VmDO>>();
            resultList = new ArrayList<EnclosureDO>();
            HashMap<String, String> _Host2SqlHash = new HashMap<String, String>();
            _Host2SqlHash.put("name", " ORDER BY NAME ");
            _Host2SqlHash.put("Name", " ORDER BY NAME ");
            _Host2SqlHash.put("vhostName", " ORDER BY NAME ");
            _Host2SqlHash.put("vcluster", " ORDER BY VCLUSTER ");
            _Host2SqlHash.put("multipath", " ORDER BY MULTIPATH ");
            String sortSql = (String)_Host2SqlHash.get(dbFilter.getSortField());
            String sortSqlSuffix = "";
            if (sortSql != null) {
                sortSqlSuffix = (String)_Host2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
            }
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            String filterSql = this.getFilterSqlForHost(dbFilter.getFilterStr());
            try {
                con = ConnectionManager.getConnection();
                this.processVm(con, _Host2vmHash);
                this.processUsageCount(con, _vmUsageMap);
                long start = System.currentTimeMillis();
                sql = SQLLoader.getSqlStmt("HostEnclHandler.COMBO_DATA_LIST_STMT", false);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + filterSql + sortSqlSuffix, 1004, 1007);
                long end = System.currentTimeMillis();
                start = System.currentTimeMillis();
                rs = SQLLoader.execute(stmt);
                end = System.currentTimeMillis();
                this.timer(start, end, "Sql Execution");
                start = System.currentTimeMillis();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    long hostId = rs.getLong(1);
                    String hostName = rs.getString(2);
                    String vhostFullName = rs.getString(3);
                    long enclId = rs.getLong(4);
                    long vhostId = rs.getLong(5);
                    String myMacStr = rs.getString(6);
                    String ipAddrStr = rs.getString(7);
                    String myPwwnStr = rs.getString(8);
                    String multiPath = rs.getString(9);
                    String osInfo = rs.getString(10);
                    String hbas = rs.getString(11);
                    String vcluster = rs.getString(12);
                    EnclosureDO enclDo = new EnclosureDO();
                    enclDo.setEnclId(enclId);
                    enclDo.setName(hostName);
                    enclDo.setHostId(hostId);
                    enclDo.setOsInfo(osInfo == null ? "" : osInfo);
                    enclDo.setMultipath(multiPath);
                    enclDo.setVhostName(vhostId < 1L ? "" : hostName);
                    enclDo.setVhostIp(vhostFullName);
                    enclDo.setVcluster(vcluster);
                    enclDo.setVhostId(vhostId);
                    enclDo.setVmware(vhostId > 0L);
                    enclDo.setIpAddress(ipAddrStr == null ? "" : ipAddrStr);
                    enclDo.setMacAddr(myMacStr == null ? "" : myMacStr);
                    enclDo.setMacStr(myMacStr == null ? "" : myMacStr);
                    if (enclDo.getMacAddr().length() > 0) {
                        enclDo.setNicCnt(this.getHbaCount(enclDo.getMacAddr(), ","));
                    }
                    enclDo.setWwnStr(myPwwnStr);
                    enclDo.setFcportCnt(this.getHbaCount(myPwwnStr, ","));
                    ArrayList<String> wwnStrings = new ArrayList<String>();
                    ArrayList vHostVm = new ArrayList();
                    ArrayList vHostVmUsage = new ArrayList();
                    HostImpl hostImpl = HostManager.getInstance().getHostById(hostId);
                    if (hostImpl != null && hostImpl != null) {
                        if (hostImpl.getEnclosureId() != 0L && (enclId = hostImpl.getEnclosureId()) > 0L) {
                            wwnStrings.addAll(this.getWwnForEnclosure(enclId, con));
                        }
                        if (hostImpl.getVhostId() != 0L) {
                            vhostId = hostImpl.getVhostId();
                            ArrayList vmList = (ArrayList)_Host2vmHash.get(vhostId);
                            if (vmList == null) {
                                vmList = new ArrayList();
                            }
                            vHostVm.addAll(vmList);
                            vHostVmUsage.add(_vmUsageMap.get(vhostId));
                        }
                    }
                    enclDo.setIndex(curIdx + startIdx + 1);
                    String vmUsage = (String)_vmUsageMap.get(vhostId);
                    if (vmUsage == null || vmUsage.trim().length() == 0) {
                        vmUsage = "0";
                    }
                    enclDo.setUsageCnt(vmUsage);
                    if (vhostId > 0L) {
                        int used = 0;
                        int total = 0;
                        if (vHostVmUsage != null && vHostVmUsage.size() > 0) {
                            block9: for (int i = 0; i < vHostVmUsage.size(); ++i) {
                                String[] s = null;
                                String usage = (String)vHostVmUsage.get(i);
                                if (usage != null) {
                                    s = usage.split("/");
                                }
                                if (s == null || s.length <= 0) continue;
                                switch (s.length) {
                                    case 1: {
                                        used += Integer.parseInt(s[0]);
                                        continue block9;
                                    }
                                    default: {
                                        used += Integer.parseInt(s[0]);
                                        total += Integer.parseInt(s[1]);
                                    }
                                }
                            }
                            if (used > 0 || total > 0) {
                                vmUsage = used + "/" + total;
                            }
                            enclDo.setUsageCnt(vmUsage);
                        }
                        enclDo.setVmList(vHostVm.toArray(new VmDO[0]));
                    }
                    resultList.add(enclDo);
                    if (++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block22;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        long fStop = System.currentTimeMillis();
        this.timer(fStart, fStop, "getHostEnclList()");
        return resultList;
    }

    public void renameHost(long id, String name) throws Exception {
        HostManager hostManager = HostManager.getInstance();
        hostManager.renameHost(id, name);
    }

    private String processHbasToWwns(String hbaStr) {
        if (hbaStr == null || hbaStr.length() == 0) {
            return hbaStr;
        }
        StringBuffer wwns = new StringBuffer();
        String[] allHbas = hbaStr.split(",");
        for (int i = 0; i < allHbas.length; ++i) {
            String vendorHba = allHbas[i];
            String[] s = vendorHba.split("_");
            if (s.length == 1) {
                if (wwns.length() > 0) {
                    wwns.append(", ");
                }
                wwns.append(s[0]);
                continue;
            }
            if (s.length != 2) continue;
            if (wwns.length() > 0) {
                wwns.append(", ");
            }
            wwns.append(s[1]);
        }
        return wwns.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getMacForVm(long vmID, Connection con) {
        HashedArrayList<String> rstList = new HashedArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(" SELECT MAC FROM VNIC WHERE VM_ID = ?");
            stmt.setLong(1, vmID);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                String mac = rs.getString(1);
                if (rstList.contains(mac)) continue;
                rstList.add(mac);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getMacForVhost(long vhostID, Connection con) {
        HashedArrayList<String> rstList = new HashedArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(" SELECT MAC FROM PHYNIC WHERE VHOST_ID = ?");
            stmt.setLong(1, vhostID);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                String mac = rs.getString(1);
                if (rstList.contains(mac)) continue;
                rstList.add(mac);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getWwnForEnclosure(long enclosureID, Connection con) {
        HashedArrayList<String> rstList = new HashedArrayList<String>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(" SELECT WWN FROM END_PORT WHERE ENCLOSURE_ID = ?");
            stmt.setLong(1, enclosureID);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                byte[] wwn = rs.getBytes(1);
                String wwnAsString = SnmpString.toHexString(wwn);
                if (rstList.contains(wwnAsString)) continue;
                rstList.add(wwnAsString);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return rstList;
    }

    private int getHbaCount(String s, String regex) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        String[] stringArray = s.split(regex);
        return stringArray.length;
    }

    private String getFilterSql(String filterStr) {
        String[] st;
        if (filterStr == null || filterStr.length() < 1) {
            return "";
        }
        String newFilterStr = "";
        int i = 0;
        for (String elem : st = filterStr.split("/t")) {
            if (elem.equalsIgnoreCase("FILTER_SAN_ONLY")) {
                newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                newFilterStr = newFilterStr + "  S_ENC.STORAGE_SYSTEM_ID < 1 ";
            } else if (elem.equalsIgnoreCase("FILTER_SMIS_ONLY")) {
                newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                newFilterStr = newFilterStr + "  S_ENC.STORAGE_SYSTEM_ID > 0 ";
            } else {
                String[] pos = elem.split("=");
                if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("HOSTID")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + "  ENC.ID = " + pos[1].trim() + " ";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("HOSTNAME")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + "  S_ENC.NAME LIKE '%" + pos[1].trim() + "%'";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("IPADDRESS")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + "  ENC.IP_ADDRESS LIKE '%" + pos[1].trim() + "%'";
                }
            }
            ++i;
        }
        newFilterStr = newFilterStr + " ";
        return newFilterStr;
    }

    private String getFilterSqlForHost(String filterStr) {
        String[] st;
        if (filterStr == null || filterStr.length() < 1) {
            return "";
        }
        String newFilterStr = "";
        int i = 0;
        for (String elem : st = filterStr.split("/t")) {
            if (elem.equalsIgnoreCase("FILTER_SAN_ONLY")) {
                newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                newFilterStr = newFilterStr + " ENCLOSURE_ID > 0 ";
            } else if (elem.equalsIgnoreCase("FILTER_LAN_ONLY")) {
                newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                newFilterStr = newFilterStr + " MAC IS NOT NULL AND VHOST_ID = 0 ";
            } else if (elem.equalsIgnoreCase("FILTER_VIRTUAL_ONLY")) {
                newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                newFilterStr = newFilterStr + " VHOST_ID > 0 ";
            } else {
                String[] pos = elem.split("=");
                if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("HOSTID")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ID = " + pos[1].trim() + " ";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("ENCLID")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ENCLOSURE_ID = " + pos[1].trim() + " ";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("VHOSTID")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " VHOST_ID = " + pos[1].trim() + " ";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("HOSTNAME")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " NAME LIKE '%" + pos[1].trim() + "%'";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("IPADDRESS")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( IP LIKE '%" + pos[1].trim() + "%')";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("MACSTR")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( MAC LIKE '%" + pos[1].trim() + "%')";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("WWNSTR")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( PWWN LIKE '%" + pos[1].trim() + "%')";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("VHOSTNAME")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( FULL_NAME LIKE '%" + pos[1].trim() + "%')";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("VCLUSTER")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( VCLUSTER LIKE '%" + pos[1].trim() + "%')";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("MULTIPATH")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( MULTIPATH LIKE '%" + pos[1].trim() + "%')";
                } else if (pos.length == 2 && pos[0].trim().equalsIgnoreCase("OSINFO")) {
                    newFilterStr = i == 0 ? newFilterStr + " WHERE " : newFilterStr + " AND ";
                    newFilterStr = newFilterStr + " ( OS_INFO LIKE '%" + pos[1].trim() + "%')";
                }
            }
            ++i;
        }
        newFilterStr = newFilterStr + " ";
        return newFilterStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUsageCount(Connection con, Map<Long, String> _vmUsageMap) {
        PreparedStatement usedStmt = null;
        PreparedStatement totalStmt = null;
        ResultSet usedRs = null;
        ResultSet totalRs = null;
        String usedSql = null;
        String totalSql = null;
        _vmUsageMap.clear();
        try {
            long vhostId;
            usedSql = "select vhost_id, count(id) from vm where power_state = 1 group by vhost_id";
            totalSql = "select vhost_id, count(id) from vm group by vhost_id";
            usedStmt = con.prepareStatement(usedSql);
            usedRs = SQLLoader.execute(usedStmt);
            while (usedRs.next()) {
                vhostId = usedRs.getLong(1);
                int usedCnt = usedRs.getInt(2);
                _vmUsageMap.put(vhostId, String.valueOf(usedCnt));
            }
            totalStmt = con.prepareStatement(totalSql);
            totalRs = SQLLoader.execute(totalStmt);
            while (totalRs.next()) {
                vhostId = totalRs.getLong(1);
                int totalCnt = totalRs.getInt(2);
                String usedCnt = _vmUsageMap.get(vhostId);
                _vmUsageMap.put(vhostId, (usedCnt == null ? "0" : usedCnt) + "/" + String.valueOf(totalCnt));
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(usedRs);
                DbUtil.close(usedStmt);
                DbUtil.close(totalRs);
                DbUtil.close(totalStmt);
                throw throwable;
            }
            DbUtil.close(usedRs);
            DbUtil.close(usedStmt);
            DbUtil.close(totalRs);
            DbUtil.close(totalStmt);
        }
        DbUtil.close(usedRs);
        DbUtil.close(usedStmt);
        DbUtil.close(totalRs);
        DbUtil.close(totalStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<VmDO> getVmHostData(DbFilterDO dbFilter, int startIdx, int recordSize, boolean isHost, Map<Long, String> _vmUsageMap, Map<Long, List<VmDO>> _Host2vmHash) {
        ArrayList<VmDO> rstList;
        block15: {
            String sortSql;
            if (_vmUsageMap == null) {
                _vmUsageMap = new HashMap<Long, String>();
            }
            if (_Host2vmHash == null) {
                _Host2vmHash = new HashMap<Long, List<VmDO>>();
            }
            rstList = new ArrayList<VmDO>();
            String sortSqlSuffix = "";
            if (!dbFilter.getSortField().equals("Name") && (sortSql = this._Name2SqlHash.get(dbFilter.getSortField())) != null) {
                sortSqlSuffix = this._Name2SqlHash.get(dbFilter.getSortField()) + dbFilter.getSortType();
            }
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                this.processVm(con, _Host2vmHash);
                this.processUsageCount(con, _vmUsageMap);
                sql = SQLLoader.getSqlStmt("HostEnclHandler.VM_HOST_DATA_LIST_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sortSqlSuffix, 1004, 1007);
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                while (rs.next()) {
                    String name = rs.getString(1);
                    String ipStr = rs.getString(2);
                    int cpuCnt = rs.getInt(3);
                    long memSize = rs.getLong(4);
                    String hbas = rs.getString(5);
                    String multiPath = rs.getString(6);
                    long vhostId = rs.getLong(7);
                    String osType = rs.getString(8);
                    String clusterName = rs.getString(9);
                    String alias = rs.getString(10);
                    String macAddr = rs.getString(11);
                    String vhostIp = rs.getString(12);
                    String vmUsage = _vmUsageMap.get(vhostId);
                    VmDO entity = new VmDO();
                    entity.setName(name);
                    entity.setMacAddr(macAddr);
                    entity.setIpAddress(ipStr);
                    entity.setCpuCnt(cpuCnt);
                    entity.setVhostIp(vhostIp);
                    entity.setMemSize(!Double.isNaN(memSize) ? DefaultSnmpNumberRenderer.formatLong(memSize) + "B" : "n/a");
                    if (hbas == null || hbas.length() == 0 || alias == null || alias.length() == 0) {
                        entity.setHbas(hbas);
                    } else {
                        String[] hbasArr = hbas.split(",");
                        String[] aliasArr = alias.split(",");
                        String hbaStr = "";
                        for (int i = 0; i < hbasArr.length; ++i) {
                            hbaStr = hbaStr + hbasArr[i] + (aliasArr[i].equals(NOT_APPLICABLE) ? "" : "(" + aliasArr[i] + ")") + ",";
                        }
                        entity.setHbas(hbaStr.substring(0, hbaStr.length() - 1));
                    }
                    if (vmUsage == null || vmUsage.trim().length() == 0) {
                        vmUsage = "0";
                    }
                    entity.setUsageCnt(vmUsage);
                    entity.setMultipath(multiPath);
                    entity.setOsType(osType);
                    entity.setVmware(true);
                    entity.setIndex(curIdx + startIdx + 1);
                    entity.setCluster(clusterName);
                    entity.setVhostId(vhostId);
                    List<VmDO> vmList = _Host2vmHash.get(vhostId);
                    if (vmList == null) {
                        vmList = new ArrayList<VmDO>();
                    }
                    entity.setVmList(vmList.toArray(new VmDO[0]));
                    rstList.add(entity);
                    if (++curIdx < recordSize) continue;
                    break;
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block15;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processVm(Connection con, Map<Long, List<VmDO>> _Host2vmHash) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        _Host2vmHash.clear();
        try {
            sql = "select vhost_id, vm.name, memory_size, cpucount, os_type,ip_address,power_state, ep.alias,ds.name, vm.disk_read_avg, vm.disk_write_avg, vm.id, vm.full_name  from vm left join vm_datastore_info vdi on vm.id =vdi.vm_id left join data_store ds on ds.id = vdi.datastore_id left join end_port ep on ds.port_wwn = ep.wwn";
            stmt = con.prepareStatement(sql);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                List<String> macStrings;
                long vhostId = rs.getLong(1);
                String vmName = rs.getString(2);
                long memSize = rs.getLong(3);
                int cpuCnt = rs.getInt(4);
                String osType = rs.getString(5);
                byte[] ipByte = rs.getBytes(6);
                int pwrState = rs.getInt(7);
                String dataStore = rs.getString(8);
                String dsSuffix = rs.getString(9);
                double diskRead = rs.getDouble(10);
                double diskWrite = rs.getDouble(11);
                long vmId = rs.getLong(12);
                String vmFullName = rs.getString(13);
                VmDO vm = new VmDO();
                vm.setVhostId(vhostId);
                vm.setCpuCnt(cpuCnt);
                vm.setName(vmName);
                vm.setFullName(vmFullName);
                vm.setMemSize(!Double.isNaN(memSize) ? DefaultSnmpNumberRenderer.formatLongNoPrec(memSize * 1000000L) + "B" : "n/a");
                vm.setDiskRead(!Double.isNaN(diskRead) ? DefaultSnmpNumberRenderer.formatLong((long)diskRead * 1000L) + "B" : "n/a");
                vm.setDiskWrite(!Double.isNaN(diskWrite) ? DefaultSnmpNumberRenderer.formatLong((long)diskWrite * 1000L) + "B" : "n/a");
                vm.setOsType(osType);
                vm.setStatus(pwrState == 1 ? "Active" : "Inactive");
                vm.setIpAddress(ipByte == null ? "" : InetAddress.getByAddress(ipByte).getHostAddress());
                vm.setDataStore((dsSuffix == null ? "" : dsSuffix + "/") + dataStore);
                List<VmDO> vmList = _Host2vmHash.get(vhostId);
                if (vmList == null) {
                    vmList = new ArrayList<VmDO>();
                }
                vmList.add(vm);
                _Host2vmHash.put(vhostId, vmList);
                if (vmId <= 0L || (macStrings = this.getMacForVm(vmId, con)) == null) continue;
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < macStrings.size(); ++i) {
                    buf.append(macStrings.get(i));
                    if (i >= macStrings.size() - 1) continue;
                    buf.append(", ");
                }
                vm.setMacStr(buf.toString());
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostEnclDataLength(DbFilterDO dbFilter, boolean isHost) {
        int dataLength;
        block6: {
            dataLength = 0;
            String filterSql = null;
            filterSql = isHost ? this.getFilterSqlForHost(dbFilter.getFilterStr()) : this.getFilterSql(dbFilter.getFilterStr());
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                sql = isHost ? SQLLoader.getSqlStmt("HostEnclHandler.COMBO_DATA_LENGTH_STMT") : SQLLoader.getSqlStmt("StorageEnclHandler.DATA_LENGTH_STMT");
                stmt = con.prepareStatement(sql + filterSql);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    dataLength = rs.getInt(1);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVmHostDataLength(boolean isHost) {
        int dataLength = 0;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSqlStmt("HostEnclHandler.VM_HOST_DATA_LENGTH_STMT");
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                dataLength = rs.getInt(1);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return dataLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopoTrafficDO getHostTrafficUtilization(int enclosureType, long enclosureId, String enclosureName) {
        topoTrafficDO = new TopoTrafficDO();
        sumAvgRx = 0.0;
        sumAvgTx = 0.0;
        avgRxList = new ArrayList<Double>();
        avgTxList = new ArrayList<Double>();
        totalRxTxList = new ArrayList<Double>();
        nameList = new ArrayList<String>();
        idList = new ArrayList<Long>();
        ifNameList = new ArrayList<String>();
        swNameList = new ArrayList<String>();
        con = null;
        stmt = null;
        rs = null;
        sql = null;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSqlStmt("HostEnclHandler.ENDPORTS_FOR_ENCLOSURE");
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.setLong(1, enclosureId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                endPortId = rs.getLong(1);
                endPortName = rs.getString(2);
                ifName = rs.getString(3);
                swName = rs.getString(4);
                con2 = null;
                stmt2 = null;
                rs2 = null;
                sql2 = null;
                try {
                    con2 = ConnectionManager.getConnection();
                    sql2 = SQLLoader.getSqlStmt("HostEnclHandler.STATS_FOR_ENDPORT");
                    stmt2 = PersistentHelper.getHelper().getPreparedStmt(con2, sql2, 1004, 1007);
                    stmt2.setLong(1, endPortId);
                    stmt2.setLong(2, enclosureType);
                    rs2 = SQLLoader.execute(stmt2);
                    while (rs2.next()) {
                        avg_rx = PersistentHelper.getHelper().getPmDouble(rs2, 1);
                        avg_tx = PersistentHelper.getHelper().getPmDouble(rs2, 2);
                        total_rxtx = PersistentHelper.getHelper().getPmDouble(rs2, 3);
                        if (avg_rx.isNaN()) {
                            avg_rx = new Double(0.0);
                        }
                        if (avg_tx.isNaN()) {
                            avg_tx = new Double(0.0);
                        }
                        if (total_rxtx.isNaN()) {
                            total_rxtx = new Double(0.0);
                        }
                        avgRx = avg_rx;
                        avgTx = avg_tx;
                        totalRxTx = total_rxtx;
                        if (avgRx > 1.0) {
                            avgRx = Math.round(avgRx);
                        }
                        if (avgTx > 1.0) {
                            avgTx = Math.round(avgTx);
                        }
                        if (totalRxTx > 1.0) {
                            totalRxTx = Math.round(totalRxTx);
                        }
                        if (totalRxTx == 0.0) continue;
                        sumAvgRx += avgRx;
                        sumAvgTx += avgTx;
                        avgRxList.add(avgRx);
                        avgTxList.add(avgTx);
                        totalRxTxList.add(totalRxTx);
                        nameList.add(endPortName);
                        idList.add(endPortId);
                        ifNameList.add(ifName);
                        swNameList.add(swName);
                    }
                    ** GOTO lbl84
                }
                catch (Exception ex) {
                    try {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (Throwable var39_38) {
                        DbUtil.close(rs2);
                        DbUtil.close(stmt2);
                        DbUtil.close(con2);
                        throw var39_38;
                    }
lbl84:
                    // 1 sources

                    DbUtil.close(rs2);
                    DbUtil.close(stmt2);
                    DbUtil.close(con2);
                    continue;
                    DbUtil.close(rs2);
                    DbUtil.close(stmt2);
                    DbUtil.close(con2);
                }
            }
            ** GOTO lbl103
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                var22_40 = topoTrafficDO;
            }
            catch (Throwable var40_42) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw var40_42;
            }
lbl103:
            // 1 sources

            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
            avg_rx_list = new HashedArrayList<TopoTrafficItemDO>();
            avg_tx_list = new HashedArrayList<TopoTrafficItemDO>();
            total_rx_tx_list = new HashedArrayList<E>();
            n = nameList.size();
            avg_rx = new TopoTrafficItemDO[n];
            avg_tx = new TopoTrafficItemDO[n];
            name = null;
            ifName = null;
            swName = null;
            id = 0L;
            circumference = 100.0;
            multiplierRx = circumference / sumAvgRx;
            multiplierTx = circumference / sumAvgTx;
            rxValue = 0;
            txValue = 0;
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
            return var22_40;
        }
        for (i = 0; i < n; ++i) {
            name = (String)nameList.get(i);
            ifName = (String)ifNameList.get(i);
            swName = (String)swNameList.get(i);
            id = (Long)idList.get(i);
            rxValue = new Double((Double)avgRxList.get(i) * multiplierRx).intValue();
            txValue = new Double((Double)avgTxList.get(i) * multiplierTx).intValue();
            if (rxValue == 0 && txValue == 0) continue;
            item_rx = new TopoTrafficItemDO();
            item_rx.setName(name);
            item_rx.setId(id);
            item_rx.setValue(rxValue);
            item_rx.setIfName(ifName);
            item_rx.setSwName(swName);
            avg_rx[i] = item_rx;
            avg_rx_list.add(item_rx);
            item_tx = new TopoTrafficItemDO();
            item_tx.setName(name);
            item_tx.setId(id);
            item_tx.setValue(txValue);
            item_tx.setIfName(ifName);
            item_tx.setSwName(swName);
            avg_tx[i] = item_tx;
            avg_tx_list.add(item_tx);
            total_rx_tx_list.add(totalRxTxList.get(i));
        }
        data_list = new ArrayList<CompareRxTx>();
        for (i = 0; i < total_rx_tx_list.size(); ++i) {
            data = new CompareRxTx((Double)total_rx_tx_list.get(i), (TopoTrafficItemDO)avg_rx_list.get(i), (TopoTrafficItemDO)avg_tx_list.get(i));
            data_list.add(data);
        }
        Collections.sort(data_list);
        avg_rx_list.clear();
        avg_tx_list.clear();
        for (i = 0; i < data_list.size() && i < 10; ++i) {
            avg_rx_list.add(((CompareRxTx)data_list.get(i)).getRx());
            avg_tx_list.add(((CompareRxTx)data_list.get(i)).getTx());
        }
        if (data_list.size() > 10) {
            other_rx = new TopoTrafficItemDO();
            other_rx.setName("Other (" + String.valueOf(data_list.size() - 10) + ")");
            other_rx.setId(0L);
            other_rx.setIfName("");
            other_rx.setSwName("");
            other_tx = new TopoTrafficItemDO();
            other_tx.setName("Other (" + String.valueOf(data_list.size() - 10) + ")");
            other_tx.setId(0L);
            other_tx.setIfName("");
            other_tx.setSwName("");
            for (i = 10; i < data_list.size(); ++i) {
                other_rx.setValue(other_rx.getValue() + ((CompareRxTx)data_list.get(i)).getRx().getValue());
                other_tx.setValue(other_tx.getValue() + ((CompareRxTx)data_list.get(i)).getTx().getValue());
            }
            avg_rx_list.add(other_rx);
            avg_tx_list.add(other_tx);
        }
        avg_rx = avg_rx_list.toArray(new TopoTrafficItemDO[avg_rx_list.size()]);
        avg_tx = avg_tx_list.toArray(new TopoTrafficItemDO[avg_tx_list.size()]);
        topoTrafficDO.setAvgRx(avg_rx);
        topoTrafficDO.setAvgTx(avg_tx);
        return topoTrafficDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TopoTrafficDO getHostTrafficUtilizationAtOtherEnd(int enclosureType, long endPortId, String endPortName, int traffic_direction) {
        int i;
        double maxAvgRx = 0.0;
        double maxAvgTx = 0.0;
        Connection con0 = null;
        PreparedStatement stmt0 = null;
        ResultSet rs0 = null;
        String sql0 = null;
        try {
            con0 = ConnectionManager.getConnection();
            sql0 = SQLLoader.getSqlStmt("HostEnclHandler.STATS_FOR_ENDPORT");
            stmt0 = PersistentHelper.getHelper().getPreparedStmt(con0, sql0, 1004, 1007);
            stmt0.setLong(1, endPortId);
            if (enclosureType == 3) {
                stmt0.setLong(2, 3L);
            } else if (enclosureType == 4) {
                stmt0.setLong(2, 4L);
            }
            rs0 = SQLLoader.execute(stmt0);
            while (rs0.next()) {
                Double avg_rx = PersistentHelper.getHelper().getPmDouble(rs0, 1);
                Double avg_tx = PersistentHelper.getHelper().getPmDouble(rs0, 2);
                Double total_rxtx = PersistentHelper.getHelper().getPmDouble(rs0, 3);
                if (avg_rx.isNaN()) {
                    avg_rx = new Double(0.0);
                }
                if (avg_tx.isNaN()) {
                    avg_tx = new Double(0.0);
                }
                if (total_rxtx.isNaN()) {
                    total_rxtx = new Double(0.0);
                }
                double avgRx = avg_rx;
                double avgTx = avg_tx;
                double totalRxTx = total_rxtx;
                this._Log.debug((Object)("_endPortId=" + endPortId + " endPortName=" + endPortName + " avgRx=" + avgRx + " avgTx=" + avgTx));
                if (avgRx > 1.0) {
                    avgRx = Math.round(avgRx);
                }
                if (avgTx > 1.0) {
                    avgTx = Math.round(avgTx);
                }
                if (totalRxTx > 1.0) {
                    totalRxTx = Math.round(totalRxTx);
                }
                maxAvgRx = avgRx;
                maxAvgTx = avgTx;
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs0);
                DbUtil.close(stmt0);
                DbUtil.close(con0);
                throw throwable;
            }
            DbUtil.close(rs0);
            DbUtil.close(stmt0);
            DbUtil.close(con0);
        }
        DbUtil.close(rs0);
        DbUtil.close(stmt0);
        DbUtil.close(con0);
        TopoTrafficDO topoTrafficDO = new TopoTrafficDO();
        double sumAvgRx = 0.0;
        double sumAvgTx = 0.0;
        double diffAvgRx = 0.0;
        double diffAvgTx = 0.0;
        ArrayList<Double> avgRxList = new ArrayList<Double>();
        ArrayList<Double> avgTxList = new ArrayList<Double>();
        ArrayList<Double> totalRxTxList = new ArrayList<Double>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Long> idList = new ArrayList<Long>();
        ArrayList<String> ifNameList = new ArrayList<String>();
        ArrayList<String> swNameList = new ArrayList<String>();
        Connection con1 = null;
        PreparedStatement stmt1 = null;
        ResultSet rs1 = null;
        String sql1 = null;
        try {
            con1 = ConnectionManager.getConnection();
            sql1 = SQLLoader.getSqlStmt("HostEnclHandler.ZONES_FOR_ENDPORT");
            stmt1 = PersistentHelper.getHelper().getPreparedStmt(con1, sql1, 1004, 1007);
            stmt1.setLong(1, endPortId);
            rs1 = SQLLoader.execute(stmt1);
            while (rs1.next()) {
                long zoneId = rs1.getLong(1);
                Connection con2 = null;
                PreparedStatement stmt2 = null;
                ResultSet rs2 = null;
                String sql2 = null;
                try {
                    con2 = ConnectionManager.getConnection();
                    sql2 = SQLLoader.getSqlStmt("HostEnclHandler.MEMBERS_FOR_ZONE");
                    stmt2 = PersistentHelper.getHelper().getPreparedStmt(con2, sql2, 1004, 1007);
                    stmt2.setLong(1, zoneId);
                    rs2 = SQLLoader.execute(stmt2);
                    while (rs2.next()) {
                        long id = rs2.getLong(1);
                        String name = rs2.getString(2);
                        int endport_type = rs2.getInt(3);
                        String ifName = rs2.getString(4);
                        String swName = rs2.getString(5);
                        if (enclosureType == endport_type) continue;
                        Connection con3 = null;
                        PreparedStatement stmt3 = null;
                        ResultSet rs3 = null;
                        String sql3 = null;
                        try {
                            con3 = ConnectionManager.getConnection();
                            sql3 = SQLLoader.getSqlStmt("HostEnclHandler.STATS_FOR_ENDPORT");
                            stmt3 = PersistentHelper.getHelper().getPreparedStmt(con3, sql3, 1004, 1007);
                            stmt3.setLong(1, id);
                            if (enclosureType == 3) {
                                stmt3.setLong(2, 4L);
                            } else if (enclosureType == 4) {
                                stmt3.setLong(2, 3L);
                            }
                            rs3 = SQLLoader.execute(stmt3);
                            while (rs3.next()) {
                                Double avg_rx = PersistentHelper.getHelper().getPmDouble(rs3, 1);
                                Double avg_tx = PersistentHelper.getHelper().getPmDouble(rs3, 2);
                                Double total_rxtx = PersistentHelper.getHelper().getPmDouble(rs3, 3);
                                if (avg_rx.isNaN()) {
                                    avg_rx = new Double(0.0);
                                }
                                if (avg_tx.isNaN()) {
                                    avg_tx = new Double(0.0);
                                }
                                if (total_rxtx.isNaN()) {
                                    total_rxtx = new Double(0.0);
                                }
                                double avgRx = avg_rx;
                                double avgTx = avg_tx;
                                double totalRxTx = total_rxtx;
                                this._Log.debug((Object)(" endPortId=" + id + " endPortName=" + name + " avgRx=" + avgRx + " avgTx=" + avgTx));
                                if (avgRx > 1.0) {
                                    avgRx = Math.round(avgRx);
                                }
                                if (avgTx > 1.0) {
                                    avgTx = Math.round(avgTx);
                                }
                                if (totalRxTx > 1.0) {
                                    totalRxTx = Math.round(totalRxTx);
                                }
                                if (traffic_direction == 0 && avgTx == 0.0 || traffic_direction == 1 && avgRx == 0.0) continue;
                                sumAvgRx += avgRx;
                                sumAvgTx += avgTx;
                                avgRxList.add(avgRx);
                                avgTxList.add(avgTx);
                                totalRxTxList.add(totalRxTx);
                                nameList.add(name);
                                idList.add(id);
                                ifNameList.add(ifName);
                                swNameList.add(swName);
                            }
                        }
                        catch (Exception ex) {
                            try {
                                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                            }
                            catch (Throwable throwable) {
                                DbUtil.close(rs3);
                                DbUtil.close(stmt3);
                                DbUtil.close(con3);
                                throw throwable;
                            }
                            DbUtil.close(rs3);
                            DbUtil.close(stmt3);
                            DbUtil.close(con3);
                            continue;
                        }
                        DbUtil.close(rs3);
                        DbUtil.close(stmt3);
                        DbUtil.close(con3);
                    }
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                finally {
                    diffAvgRx = maxAvgRx - sumAvgRx;
                    diffAvgTx = maxAvgTx - sumAvgTx;
                    if (diffAvgRx < 0.0) {
                        diffAvgRx = 0.0;
                    }
                    if (diffAvgTx < 0.0) {
                        diffAvgTx = 0.0;
                    }
                    sumAvgRx += diffAvgRx;
                    sumAvgTx += diffAvgTx;
                    if (nameList.size() < 10 && (diffAvgRx > 0.0 || diffAvgTx > 0.0)) {
                        avgRxList.add(diffAvgRx);
                        avgTxList.add(diffAvgRx);
                        totalRxTxList.add(diffAvgRx + diffAvgRx);
                        nameList.add("Other");
                        idList.add(0L);
                        ifNameList.add("");
                        swNameList.add("");
                    }
                    DbUtil.close(rs2);
                    DbUtil.close(stmt2);
                    DbUtil.close(con2);
                }
            }
        }
        catch (Exception ex) {
            TopoTrafficDO topoTrafficDO2;
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                topoTrafficDO2 = topoTrafficDO;
            }
            catch (Throwable throwable) {
                DbUtil.close(rs1);
                DbUtil.close(stmt1);
                DbUtil.close(con1);
                throw throwable;
            }
            DbUtil.close(rs1);
            DbUtil.close(stmt1);
            DbUtil.close(con1);
            return topoTrafficDO2;
        }
        DbUtil.close(rs1);
        DbUtil.close(stmt1);
        DbUtil.close(con1);
        HashedArrayList<TopoTrafficItemDO> avg_rx_list = new HashedArrayList<TopoTrafficItemDO>();
        HashedArrayList<TopoTrafficItemDO> avg_tx_list = new HashedArrayList<TopoTrafficItemDO>();
        HashedArrayList<Double> compare_list = new HashedArrayList<Double>();
        int n = nameList.size();
        TopoTrafficItemDO[] avg_rx = new TopoTrafficItemDO[n];
        TopoTrafficItemDO[] avg_tx = new TopoTrafficItemDO[n];
        String name = null;
        String ifName = null;
        String swName = null;
        long id = 0L;
        double circumference = 100.0;
        double multiplierRx = circumference / sumAvgRx;
        double multiplierTx = circumference / sumAvgTx;
        int rxValue = 0;
        int txValue = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            name = (String)nameList.get(i2);
            ifName = (String)ifNameList.get(i2);
            swName = (String)swNameList.get(i2);
            id = (Long)idList.get(i2);
            rxValue = new Double((Double)avgRxList.get(i2) * multiplierRx).intValue();
            txValue = new Double((Double)avgTxList.get(i2) * multiplierTx).intValue();
            if (rxValue == 0 && txValue == 0) continue;
            TopoTrafficItemDO item_rx = new TopoTrafficItemDO();
            item_rx.setName(name);
            item_rx.setId(id);
            item_rx.setValue(rxValue);
            item_rx.setIfName(ifName);
            item_rx.setSwName(swName);
            avg_rx[i2] = item_rx;
            TopoTrafficItemDO item_tx = new TopoTrafficItemDO();
            item_tx.setName(name);
            item_tx.setId(id);
            item_tx.setValue(txValue);
            item_tx.setIfName(ifName);
            item_tx.setSwName(swName);
            avg_tx[i2] = item_tx;
            if (((ArrayList)avg_rx_list).contains(item_rx)) continue;
            ((ArrayList)avg_rx_list).add(item_rx);
            ((ArrayList)avg_tx_list).add(item_tx);
            if (traffic_direction == 0) {
                ((ArrayList)compare_list).add(Double.valueOf(txValue));
                continue;
            }
            if (traffic_direction != 1) continue;
            ((ArrayList)compare_list).add(Double.valueOf(rxValue));
        }
        ArrayList<CompareRxTx> data_list = new ArrayList<CompareRxTx>();
        for (i = 0; i < compare_list.size(); ++i) {
            CompareRxTx data = new CompareRxTx((Double)compare_list.get(i), (TopoTrafficItemDO)avg_rx_list.get(i), (TopoTrafficItemDO)avg_tx_list.get(i));
            data_list.add(data);
        }
        Collections.sort(data_list);
        ((ArrayList)avg_rx_list).clear();
        ((ArrayList)avg_tx_list).clear();
        for (i = 0; i < data_list.size() && i < 10; ++i) {
            ((ArrayList)avg_rx_list).add(((CompareRxTx)data_list.get(i)).getRx());
            ((ArrayList)avg_tx_list).add(((CompareRxTx)data_list.get(i)).getTx());
        }
        if (data_list.size() > 10) {
            TopoTrafficItemDO other_rx = new TopoTrafficItemDO();
            other_rx.setName("Other (" + String.valueOf(data_list.size() - 10) + ")");
            other_rx.setId(0L);
            other_rx.setIfName("");
            other_rx.setSwName("");
            TopoTrafficItemDO other_tx = new TopoTrafficItemDO();
            other_tx.setName("Other (" + String.valueOf(data_list.size() - 10) + ")");
            other_tx.setId(0L);
            other_tx.setIfName("");
            other_tx.setSwName("");
            for (int i3 = 10; i3 < data_list.size(); ++i3) {
                other_rx.setValue(other_rx.getValue() + ((CompareRxTx)data_list.get(i3)).getRx().getValue());
                other_tx.setValue(other_tx.getValue() + ((CompareRxTx)data_list.get(i3)).getTx().getValue());
            }
            other_rx.setValue(other_rx.getValue() + new Double(diffAvgRx * multiplierRx).intValue());
            other_tx.setValue(other_tx.getValue() + new Double(diffAvgTx * multiplierTx).intValue());
            ((ArrayList)avg_rx_list).add(other_rx);
            ((ArrayList)avg_tx_list).add(other_tx);
        } else if (data_list.size() == 0) {
            TopoTrafficItemDO other_rx = new TopoTrafficItemDO();
            other_rx.setName("Other");
            other_rx.setId(0L);
            other_rx.setIfName("");
            other_rx.setSwName("");
            TopoTrafficItemDO other_tx = new TopoTrafficItemDO();
            other_tx.setName("Other");
            other_tx.setId(0L);
            other_tx.setIfName("");
            other_tx.setSwName("");
            other_rx.setValue(1 + other_rx.getValue() + new Double(diffAvgRx * multiplierRx).intValue());
            other_tx.setValue(1 + other_tx.getValue() + new Double(diffAvgTx * multiplierTx).intValue());
            ((ArrayList)avg_rx_list).add(other_rx);
            ((ArrayList)avg_tx_list).add(other_tx);
        }
        avg_rx = avg_rx_list.toArray(new TopoTrafficItemDO[avg_rx_list.size()]);
        avg_tx = avg_tx_list.toArray(new TopoTrafficItemDO[avg_tx_list.size()]);
        topoTrafficDO.setAvgRx(avg_rx);
        topoTrafficDO.setAvgTx(avg_tx);
        return topoTrafficDO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLanRrd(long src_id, long lan_id, int pmType) {
        ArrayList<String> rstList = new ArrayList<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_LAN_RRD_STMT");
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.setLong(1, src_id);
            stmt.setLong(2, lan_id);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                rstList.add(rs.getString(1) + ";" + rs.getLong(2));
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRrd(long dbId, int pmType) {
        ArrayList<String> rstList;
        block6: {
            rstList = new ArrayList<String>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                sql = pmType == 12 || pmType == 13 ? SQLLoader.getSqlStmt("HostEnclHandler.GET_ENCL_RRD_STMT") : SQLLoader.getSqlStmt("HostEnclHandler.GET_RRD_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, dbId);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    rstList.add(rs.getString(1) + ";" + rs.getLong(2));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return rstList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFlowRrd(long srcId, long desId) {
        ArrayList<String> rstList = new ArrayList<String>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_FLOW_RRD_STMT");
            stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
            stmt.setLong(1, srcId);
            stmt.setLong(2, desId);
            stmt.setLong(3, desId);
            stmt.setLong(4, srcId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                rstList.add(rs.getString(1) + ";" + rs.getLong(2));
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return rstList;
    }

    public CallResultDO getEnclChartData(long encId, int pmType, int chartType) throws Exception {
        if (pmType == 15) {
            return this.getDataInLanEnclosure(encId, pmType, chartType);
        }
        if (pmType == 11) {
            return this.getDataInEthSwitchPort(encId, pmType, chartType);
        }
        if (pmType == 12 || pmType == 13) {
            return this.getDataInEnclosure(encId, pmType, chartType);
        }
        return this.getDataInEntity(encId, pmType, chartType, 0L);
    }

    public CallResultDO getEnclFlowChartData(long srcId, long destId, int charType) throws Exception {
        return this.getDataInEntity(srcId, 2, charType, destId);
    }

    /*
     * WARNING - void declaration
     */
    private CallResultDO getDataInEntity(long entityId, int pmType, int chartType, long desId) throws Exception {
        double[][] stats = null;
        long[] interval = null;
        CallResultDO rstDo = new CallResultDO();
        try {
            void var14_15;
            interval = PmChart.getInterval(chartType, -1L, -1L);
            List<Object> rrdList = new ArrayList();
            rrdList = pmType != 2 ? HostEnclHandler.getInstance().getRrd(entityId, pmType) : HostEnclHandler.getInstance().getFlowRrd(entityId, desId);
            for (String string : rrdList) {
                String[] rstArr = string.split(";");
                String rrdFile = rstArr[0];
                int fid = Integer.parseInt(rstArr[1]);
                PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new FabricPK(fid));
                stats = pmRif.getPmChartData(rrdFile, pmType, chartType);
            }
            if (stats == null || stats.length == 0) {
                throw new Exception("No chart data found");
            }
            StatDO[] statArr = new StatDO[stats.length];
            boolean bl = false;
            while (var14_15 < stats.length) {
                statArr[var14_15] = new StatDO(stats[var14_15][0], stats[var14_15][1], stats[var14_15][2], stats[var14_15][3], stats[var14_15][4]);
                ++var14_15;
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            rstDo.setResultMessage(ex.getMessage());
            rstDo.setResultStatus(-1);
        }
        return rstDo;
    }

    public CallResultDO getDataInEnclosure(long encId, int pmType, int chartType) throws Exception {
        double[][] totalStats = null;
        double[][] stats = null;
        long[] interval = null;
        CallResultDO rstDo = new CallResultDO();
        try {
            interval = PmChart.getInterval(chartType, -1L, -1L);
            List<String> rrdList = HostEnclHandler.getInstance().getRrd(encId, pmType);
            for (String rrdFidStr : rrdList) {
                String[] rstArr = rrdFidStr.split(";");
                String rrdFile = rstArr[0];
                int fid = Integer.parseInt(rstArr[1]);
                PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new FabricPK(fid));
                stats = pmRif.getPmChartData(rrdFile, pmType == 12 ? 3 : 4, chartType);
                if (totalStats == null) {
                    totalStats = new double[stats.length][5];
                }
                for (int i = 0; i < stats.length; ++i) {
                    double[] dArray = totalStats[i];
                    dArray[0] = dArray[0] + stats[i][0];
                    double[] dArray2 = totalStats[i];
                    dArray2[1] = dArray2[1] + stats[i][1];
                    totalStats[i][2] = stats[i][2];
                    totalStats[i][3] = stats[i][3];
                    totalStats[i][4] = stats[i][4];
                }
            }
            if (totalStats == null || totalStats.length == 0) {
                this._Log.debug((Object)"No chart data found - getDataInEnclosure()");
                rstDo.setResultMessage("No chart data found");
                rstDo.setResultStatus(-1);
                return rstDo;
            }
            StatDO[] statArr = new StatDO[totalStats.length];
            for (int i = 0; i < totalStats.length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2], totalStats[i][3], totalStats[i][4]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage());
            rstDo.setResultMessage(ex.getMessage());
            rstDo.setResultStatus(-1);
        }
        return rstDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallResultDO getDataInEthSwitchPort(long lanhost_id, int pmType, int chartType) throws Exception {
        long eth_switch_id = 0L;
        String eth_ifname = "";
        long ethswitch_port_id = 0L;
        long lan_id = 0L;
        double[][] totalStats = null;
        double[][] stats = null;
        long[] interval = null;
        CallResultDO rstDo = new CallResultDO();
        try {
            interval = PmChart.getInterval(chartType, -1L, -1L);
            Connection connection = null;
            Statement preparedStatement = null;
            ResultSet resultSet = null;
            Object sqlString = null;
            try {
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rs = null;
                String sql = null;
                try {
                    con = ConnectionManager.getConnection();
                    sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_ETH_SWITCH_ID_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, lanhost_id);
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        eth_switch_id = rs.getLong(1);
                        eth_ifname = rs.getString(2);
                    }
                }
                catch (Exception ex) {
                    try {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(rs);
                        DbUtil.close(stmt);
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                con = null;
                stmt = null;
                rs = null;
                sql = null;
                try {
                    con = ConnectionManager.getConnection();
                    sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_ETHSWITCH_PORT_ID_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, eth_switch_id);
                    stmt.setString(2, eth_ifname);
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        ethswitch_port_id = rs.getLong(1);
                    }
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                }
                con = null;
                stmt = null;
                rs = null;
                sql = null;
                try {
                    con = ConnectionManager.getConnection();
                    sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_LAN_ID_STMT");
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    stmt.setLong(1, eth_switch_id);
                    rs = SQLLoader.execute(stmt);
                    while (rs.next()) {
                        lan_id = rs.getLong(1);
                    }
                }
                catch (Exception ex) {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                }
                List<String> rrdList = HostEnclHandler.getInstance().getLanRrd(ethswitch_port_id, lan_id, pmType);
                for (String rrdFidStr : rrdList) {
                    String[] rstArr = rrdFidStr.split(";");
                    String rrdFile = rstArr[0];
                    int lanID = Integer.parseInt(rstArr[1]);
                    PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(lanID));
                    stats = pmRif.getPmChartData(rrdFile, 11, chartType);
                    if (totalStats == null) {
                        totalStats = new double[stats.length][5];
                    }
                    for (int i = 0; i < stats.length; ++i) {
                        double[] dArray = totalStats[i];
                        dArray[0] = dArray[0] + stats[i][0];
                        double[] dArray2 = totalStats[i];
                        dArray2[1] = dArray2[1] + stats[i][1];
                        totalStats[i][2] = stats[i][2];
                        totalStats[i][3] = stats[i][3];
                        totalStats[i][4] = stats[i][4];
                    }
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                DbUtil.close(resultSet);
                DbUtil.close(preparedStatement);
                DbUtil.close(connection);
            }
            if (totalStats == null || totalStats.length == 0) {
                throw new Exception("No chart data found");
            }
            StatDO[] statArr = new StatDO[totalStats.length];
            for (int i = 0; i < totalStats.length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2], totalStats[i][3], totalStats[i][4]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage());
            rstDo.setResultMessage(ex.getMessage());
            rstDo.setResultStatus(-1);
        }
        return rstDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallResultDO getDataInLanEnclosure(long hostId, int pmType, int chartType) throws Exception {
        long lanhost_id = 0L;
        long eth_switch_id = 0L;
        String eth_ifname = "";
        long ethswitch_port_id = 0L;
        long lan_id = 0L;
        double[][] totalStats = null;
        double[][] stats = null;
        long[] interval = null;
        CallResultDO rstDo = new CallResultDO();
        try {
            interval = PmChart.getInterval(chartType, -1L, -1L);
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            String sqlString = null;
            try {
                connection = ConnectionManager.getConnection();
                sqlString = SQLLoader.getSqlStmt("HostEnclHandler.GET_LANHOST_ID_STMT");
                preparedStatement = PersistentHelper.getHelper().getPreparedStmt(connection, sqlString, 1004, 1007);
                preparedStatement.setLong(1, hostId);
                resultSet = SQLLoader.execute(preparedStatement);
                while (resultSet.next()) {
                    lanhost_id = resultSet.getLong(1);
                    Connection con = null;
                    PreparedStatement stmt = null;
                    ResultSet rs = null;
                    String sql = null;
                    try {
                        con = ConnectionManager.getConnection();
                        sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_ETH_SWITCH_ID_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        stmt.setLong(1, lanhost_id);
                        rs = SQLLoader.execute(stmt);
                        while (rs.next()) {
                            eth_switch_id = rs.getLong(1);
                            eth_ifname = rs.getString(2);
                        }
                    }
                    catch (Exception ex) {
                        try {
                            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                        catch (Throwable throwable) {
                            DbUtil.close(rs);
                            DbUtil.close(stmt);
                            DbUtil.close(con);
                            throw throwable;
                        }
                        DbUtil.close(rs);
                        DbUtil.close(stmt);
                        DbUtil.close(con);
                    }
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    con = null;
                    stmt = null;
                    rs = null;
                    sql = null;
                    try {
                        con = ConnectionManager.getConnection();
                        sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_ETHSWITCH_PORT_ID_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        stmt.setLong(1, eth_switch_id);
                        stmt.setString(2, eth_ifname);
                        rs = SQLLoader.execute(stmt);
                        while (rs.next()) {
                            ethswitch_port_id = rs.getLong(1);
                        }
                    }
                    catch (Exception ex) {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        DbUtil.close(rs);
                        DbUtil.close(stmt);
                        DbUtil.close(con);
                    }
                    con = null;
                    stmt = null;
                    rs = null;
                    sql = null;
                    try {
                        con = ConnectionManager.getConnection();
                        sql = SQLLoader.getSqlStmt("HostEnclHandler.GET_LAN_ID_STMT");
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        stmt.setLong(1, eth_switch_id);
                        rs = SQLLoader.execute(stmt);
                        while (rs.next()) {
                            lan_id = rs.getLong(1);
                        }
                    }
                    catch (Exception ex) {
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                    finally {
                        DbUtil.close(rs);
                        DbUtil.close(stmt);
                        DbUtil.close(con);
                    }
                    List<String> rrdList = HostEnclHandler.getInstance().getLanRrd(ethswitch_port_id, lan_id, pmType);
                    for (String rrdFidStr : rrdList) {
                        String[] rstArr = rrdFidStr.split(";");
                        String rrdFile = rstArr[0];
                        int lanID = Integer.parseInt(rstArr[1]);
                        PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(lanID));
                        stats = pmRif.getPmChartData(rrdFile, 11, chartType);
                        if (totalStats == null) {
                            totalStats = new double[stats.length][5];
                        }
                        for (int i = 0; i < stats.length; ++i) {
                            double[] dArray = totalStats[i];
                            dArray[0] = dArray[0] + stats[i][0];
                            double[] dArray2 = totalStats[i];
                            dArray2[1] = dArray2[1] + stats[i][1];
                            totalStats[i][2] = stats[i][2];
                            totalStats[i][3] = stats[i][3];
                            totalStats[i][4] = stats[i][4];
                        }
                    }
                }
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(resultSet);
                    DbUtil.close(preparedStatement);
                    DbUtil.close(connection);
                    throw throwable;
                }
                DbUtil.close(resultSet);
                DbUtil.close(preparedStatement);
                DbUtil.close(connection);
            }
            DbUtil.close(resultSet);
            DbUtil.close(preparedStatement);
            DbUtil.close(connection);
            if (totalStats == null || totalStats.length == 0) {
                this._Log.debug((Object)"No chart data found - getDataInLanEnclosure()");
                rstDo.setResultMessage("No chart data found");
                rstDo.setResultStatus(-1);
                return rstDo;
            }
            StatDO[] statArr = new StatDO[totalStats.length];
            for (int i = 0; i < totalStats.length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2], totalStats[i][3], totalStats[i][4]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage());
            rstDo.setResultMessage(ex.getMessage());
            rstDo.setResultStatus(-1);
        }
        return rstDo;
    }

    public CallResultDO getVmChartData(String entityName, String vmType, int chartType, long vhostId) throws Exception {
        CallResultDO rstDo = new CallResultDO();
        double[][] cpuStats = null;
        double[][] memStats = null;
        Object totalStats = new double[][]{};
        try {
            VirtualCenterBase vBase = this.getVCenterBase(vhostId);
            cpuStats = ViManager.getInstance().getHistoryPMData(vmType, entityName, vBase, Calendar.getInstance(), chartType, "cpu", "usage");
            memStats = ViManager.getInstance().getHistoryPMData(vmType, entityName, vBase, Calendar.getInstance(), chartType, "mem", "usage");
            if (cpuStats != null && memStats != null) {
                totalStats = new double[cpuStats.length][3];
                for (int i = 0; i < ((double[][])totalStats).length; ++i) {
                    totalStats[i][0] = memStats[i][1];
                    totalStats[i][1] = cpuStats[i][1];
                    totalStats[i][2] = cpuStats[i][0];
                }
            }
            StatDO[] statArr = new StatDO[((double[][])totalStats).length];
            for (int i = 0; i < ((double[][])totalStats).length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("vCenter does not exist")) {
                this._Log.debug((Object)ex.getMessage());
            } else {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage(ex.getMessage());
        }
        return rstDo;
    }

    public CallResultDO getVmDiskIOData(String entityName, String vmType, int chartType, long vhostId) throws Exception {
        CallResultDO rstDo = new CallResultDO();
        double[][] readStats = null;
        double[][] writeStats = null;
        Object totalStats = new double[][]{};
        try {
            VirtualCenterBase vBase = this.getVCenterBase(vhostId);
            readStats = ViManager.getInstance().getHistoryPMData(vmType, entityName, vBase, Calendar.getInstance(), chartType, "disk", "read");
            writeStats = ViManager.getInstance().getHistoryPMData(vmType, entityName, vBase, Calendar.getInstance(), chartType, "disk", "write");
            totalStats = new double[readStats.length][3];
            for (int i = 0; i < ((double[][])totalStats).length; ++i) {
                totalStats[i][0] = readStats[i][1];
                totalStats[i][1] = writeStats[i][1];
                totalStats[i][2] = writeStats[i][0];
            }
            StatDO[] statArr = new StatDO[((double[][])totalStats).length];
            for (int i = 0; i < ((double[][])totalStats).length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("vCenter does not exist")) {
                this._Log.debug((Object)ex.getMessage());
            } else {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage(ex.getMessage());
        }
        return rstDo;
    }

    public CallResultDO getVHostNetworkIOData(String entityName, String vmType, int chartType, long vhostId) throws Exception {
        CallResultDO rstDo = new CallResultDO();
        double[][] usageStats = null;
        Object totalStats = new double[][]{};
        try {
            VirtualCenterBase vBase = this.getVCenterBase(vhostId);
            usageStats = ViManager.getInstance().getHistoryPMData(vmType, entityName, vBase, Calendar.getInstance(), chartType, "net", "usage");
            totalStats = new double[usageStats.length][3];
            for (int i = 0; i < ((double[][])totalStats).length; ++i) {
                totalStats[i][0] = usageStats[i][1];
                totalStats[i][1] = usageStats[i][1];
                totalStats[i][2] = usageStats[i][0];
            }
            StatDO[] statArr = new StatDO[((double[][])totalStats).length];
            for (int i = 0; i < ((double[][])totalStats).length; ++i) {
                statArr[i] = new StatDO(totalStats[i][0], totalStats[i][1], totalStats[i][2]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("vCenter does not exist")) {
                this._Log.debug((Object)ex.getMessage());
            } else {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage(ex.getMessage());
        }
        return rstDo;
    }

    public CallResultDO getVHostLatencyData(String entityName, String vmType, int chartType, long vhostId) throws Exception {
        CallResultDO rstDo = new CallResultDO();
        Object latStats = new double[][]{};
        try {
            VirtualCenterBase vBase = this.getVCenterBase(vhostId);
            latStats = ViManager.getInstance().getHistoryPMData(vmType, entityName, vBase, Calendar.getInstance(), chartType, "disk", "maxTotalLatency");
            StatDO[] statArr = new StatDO[((double[][])latStats).length];
            for (int i = 0; i < ((double[][])latStats).length; ++i) {
                statArr[i] = new StatDO(latStats[i][1], latStats[i][1], latStats[i][0]);
            }
            rstDo.setResultStats(statArr);
        }
        catch (Exception ex) {
            if (ex.getMessage().contains("vCenter does not exist")) {
                this._Log.debug((Object)ex.getMessage());
            } else {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            rstDo.setResultStatus(-1);
            rstDo.setResultMessage(ex.getMessage());
        }
        return rstDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualCenterBase getVCenterBase(long vhostId) {
        VirtualCenterBase vBase;
        block6: {
            vBase = null;
            String sql = "select vc.ip_address, vc.user_name, vc.password, vc.vc_id from vhost, vcenter vc where vhost.vcenter_id = vc.id and vhost.id=?";
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, vhostId);
                rs = SQLLoader.execute(stmt);
                if (rs.next()) {
                    byte[] ipByte = rs.getBytes(1);
                    String userName = rs.getString(2);
                    String pword = rs.getString(3);
                    int vcId = rs.getInt(4);
                    vBase = new VirtualCenterBase(new VcenterPK(vcId), InetAddress.getByAddress(ipByte), userName, StringEncrypter.DESedeDecrypt(pword));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return vBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VmDO getVHostDetail(long enclId_in, long vhostId_in, boolean isHost) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        VmDO entity;
        block17: {
            entity = new VmDO();
            con = null;
            stmt = null;
            rs = null;
            String sql = null;
            try {
                VHostImpl vhostImpl;
                con = ConnectionManager.getConnection();
                if (vhostId_in > 0L) {
                    sql = SQLLoader.getSqlStmt("HostEnclHandler.VM_HOST_DETAIL_BY_VHOST_STMT");
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, vhostId_in);
                    rs = SQLLoader.execute(stmt);
                } else {
                    sql = SQLLoader.getSqlStmt("HostEnclHandler.VM_HOST_DETAIL_STMT");
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, enclId_in);
                    rs = SQLLoader.execute(stmt);
                }
                if (!rs.next()) break block17;
                String name = rs.getString(1);
                String ipStr = rs.getString(2);
                int cpuCnt = rs.getInt(3);
                long memSize = rs.getLong(4);
                String hbas = rs.getString(5);
                String multiPath = rs.getString(6);
                long vhostId = rs.getLong(7);
                String osType = rs.getString(8);
                String clusterName = rs.getString(9);
                String alias = rs.getString(10);
                String macAddr = rs.getString(11);
                String fullName = rs.getString(12);
                entity.setName(name);
                entity.setFullName(fullName);
                entity.setMacAddr(macAddr);
                entity.setIpAddress(ipStr);
                entity.setCpuCnt(cpuCnt);
                entity.setMemSize(!Double.isNaN(memSize) ? DefaultSnmpNumberRenderer.formatLong(memSize) + "B" : "n/a");
                if (hbas == null || hbas.length() == 0 || alias == null || alias.length() == 0) {
                    entity.setHbas(hbas);
                } else {
                    String[] hbasArr = hbas.split(",");
                    String[] aliasArr = alias.split(",");
                    String hbaStr = "";
                    for (int i = 0; i < hbasArr.length; ++i) {
                        hbaStr = hbaStr + hbasArr[i] + (aliasArr[i].equals(NOT_APPLICABLE) ? "" : "(" + aliasArr[i] + ")") + "<br>";
                    }
                    entity.setHbas(hbaStr.substring(0, hbaStr.length() - 1));
                }
                entity.setMultipath(multiPath);
                entity.setOsType(osType);
                entity.setVmware(true);
                entity.setCluster(clusterName);
                entity.setVhostId(vhostId);
                entity.setMacAddr(macAddr);
                entity.setMacStr(macAddr);
                if (vhostId <= 0L) break block17;
                StringBuffer vHostMac = new StringBuffer();
                StringBuffer vHostIpAddresses = new StringBuffer();
                HostImpl hostImpl = HostManager.getInstance().getHostById(enclId_in);
                if (hostImpl == null) break block17;
                if (hostImpl.getVhostId() != 0L && (vhostImpl = VHostImpl.getVhostById(vhostId = hostImpl.getVhostId())) != null) {
                    PhyNicImpl[] phyNics;
                    if (vhostImpl.getMacAddressesAsString() != null && vhostImpl.getMacAddressesAsString().length() > 0) {
                        if (vHostMac.length() > 0) {
                            vHostMac.append("<br>");
                        }
                        vHostMac.append(vhostImpl.getMacAddressesAsString());
                    }
                    if (vhostImpl.getIpAddressesAsString() != null && vhostImpl.getIpAddressesAsString().length() > 0) {
                        if (vHostIpAddresses.length() > 0) {
                            vHostIpAddresses.append("<br>");
                        }
                        vHostIpAddresses.append(vhostImpl.getIpAddressesAsString());
                    }
                    if ((phyNics = vhostImpl.getPhyNics()) != null) {
                        for (int j = 0; j < phyNics.length; ++j) {
                            PhyNicImpl phyNic = phyNics[j];
                            if (phyNic == null || phyNic.getMac() == null || phyNic.getMac().length() <= 0) continue;
                            if (vHostMac.length() > 0) {
                                vHostMac.append("<br>");
                            }
                            vHostMac.append(phyNic.getMac());
                        }
                    }
                }
                entity.setIpAddress(vHostIpAddresses.toString());
                entity.setMacAddr(vHostMac.toString());
                entity.setMacStr(vHostMac.toString());
            }
            catch (Exception ex) {
                try {
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getHostEnclEvts(long encId, int startIdx, int recordSize, boolean isHost) {
        DBEntryDO dto;
        block12: {
            dto = new DBEntryDO();
            if (isHost) {
                dto.setColumn(new String[]{"Index", "Time", "Timestamp", "Host Port", "Severity", "Description", "Type", "Count", "Last-First Seen"});
            } else {
                dto.setColumn(new String[]{"Index", "Time", "Timestamp", "Storage Port", "Severity", "Description", "Type", "Count", "Last-First Seen"});
            }
            Connection con = null;
            PreparedStatement stmt = null;
            Statement evtStmt = null;
            ResultSet rs = null;
            ResultSet evtRs = null;
            String sql = null;
            try {
                String prefix = isHost ? "Host: " : "Storage: ";
                String postfix = ", Port:";
                con = ConnectionManager.getConnection();
                sql = SQLLoader.getSqlStmt("HostEnclHandler.EVT_LIST_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, encId);
                rs = SQLLoader.execute(stmt);
                ArrayList<DBRowDO> rstList = new ArrayList<DBRowDO>();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                int idx = startIdx;
                while (rs.next()) {
                    Timestamp lastSeenTime;
                    String epAlias = rs.getString(1);
                    Timestamp hostTime = lastSeenTime = rs.getTimestamp(2);
                    int severity = rs.getInt(3);
                    String descr = rs.getString(4);
                    int evtType = rs.getInt(5);
                    Timestamp firstSeenTime = rs.getTimestamp(6);
                    long count = rs.getLong(7);
                    if (epAlias == null || epAlias.length() == 0) {
                        try {
                            epAlias = descr.substring(descr.indexOf(prefix) + prefix.length(), descr.indexOf(postfix));
                        }
                        catch (Exception e) {
                            epAlias = "";
                        }
                    }
                    String evtTypeStr = LogEventType.toString(evtType);
                    String hostTimeStr = SnmpTimeticks.getDateFormat().format(hostTime);
                    String lastSeenTimeStr = SnmpTimeticks.getDateFormat().format(lastSeenTime);
                    String firstSeenTimeStr = SnmpTimeticks.getDateFormat().format(firstSeenTime);
                    lastSeenTimeStr = lastSeenTimeStr + "<->" + firstSeenTimeStr;
                    String severityStr = Severity.valueOf(severity).toString();
                    DBRowDO dbRow = new DBRowDO();
                    dbRow.setEntry(new String[]{String.valueOf(++idx), hostTimeStr, String.valueOf(((Date)hostTime).getTime()), epAlias, severityStr, descr, evtTypeStr, String.valueOf(count), lastSeenTimeStr});
                    rstList.add(dbRow);
                    if (++curIdx < recordSize) continue;
                    break;
                }
                dto.setRow(rstList.toArray(new DBRowDO[0]));
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block12;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(evtRs);
                DbUtil.close(stmt);
                DbUtil.close(evtStmt);
                DbUtil.close(con);
            }
            DbUtil.close(evtRs);
            DbUtil.close(stmt);
            DbUtil.close(evtStmt);
            DbUtil.close(con);
        }
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHostEnclEvtsLength(long encId, boolean isHost) {
        Connection con = null;
        PreparedStatement stmt = null;
        Statement evtStmt = null;
        ResultSet rs = null;
        ResultSet evtRs = null;
        String sql = null;
        long evtLength = 0L;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSqlStmt("HostEnclHandler.EVT_LENGTH_STMT");
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, encId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                evtLength = rs.getLong(1);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(evtRs);
                DbUtil.close(stmt);
                DbUtil.close(evtStmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(evtRs);
            DbUtil.close(stmt);
            DbUtil.close(evtStmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(evtRs);
        DbUtil.close(stmt);
        DbUtil.close(evtStmt);
        DbUtil.close(con);
        return evtLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getLanEvts(long lanHostId, int startIdx, int recordSize) {
        DBEntryDO dto;
        block10: {
            dto = new DBEntryDO();
            dto.setColumn(new String[]{"Index", "Time", "Timestamp", "Host Port", "Severity", "Description", "Type", "Count", "Last-First Seen"});
            Connection con = null;
            PreparedStatement stmt = null;
            Statement evtStmt = null;
            ResultSet rs = null;
            ResultSet evtRs = null;
            String sql = null;
            try {
                String prefix = "Host: ";
                String postfix = ", Port:";
                con = ConnectionManager.getConnection();
                sql = SQLLoader.getSqlStmt("HostEnclHandler.LAN_EVT_LIST_STMT");
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                stmt.setLong(1, lanHostId);
                rs = SQLLoader.execute(stmt);
                ArrayList<DBRowDO> rstList = new ArrayList<DBRowDO>();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                int curIdx = 0;
                int idx = startIdx;
                while (rs.next()) {
                    Timestamp lastSeenTime;
                    String epAlias = rs.getString(1);
                    Timestamp hostTime = lastSeenTime = rs.getTimestamp(2);
                    int severity = rs.getInt(3);
                    String descr = rs.getString(4);
                    int evtType = rs.getInt(5);
                    Timestamp firstSeenTime = rs.getTimestamp(6);
                    long count = rs.getLong(7);
                    if (epAlias == null || epAlias.length() == 0) {
                        try {
                            epAlias = descr.substring(descr.indexOf(prefix) + prefix.length(), descr.indexOf(postfix));
                        }
                        catch (Exception e) {
                            epAlias = "";
                        }
                    }
                    String evtTypeStr = LogEventType.toString(evtType);
                    String hostTimeStr = SnmpTimeticks.getDateFormat().format(hostTime);
                    String lastSeenTimeStr = SnmpTimeticks.getDateFormat().format(lastSeenTime);
                    String firstSeenTimeStr = SnmpTimeticks.getDateFormat().format(firstSeenTime);
                    lastSeenTimeStr = lastSeenTimeStr + "<->" + firstSeenTimeStr;
                    String severityStr = Severity.valueOf(severity).toString();
                    DBRowDO dbRow = new DBRowDO();
                    dbRow.setEntry(new String[]{String.valueOf(++idx), hostTimeStr, String.valueOf(((Date)hostTime).getTime()), epAlias, severityStr, descr, evtTypeStr, String.valueOf(count), lastSeenTimeStr});
                    rstList.add(dbRow);
                    if (++curIdx < recordSize) continue;
                    break;
                }
                dto.setRow(rstList.toArray(new DBRowDO[0]));
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex);
                break block10;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(evtRs);
                DbUtil.close(stmt);
                DbUtil.close(evtStmt);
                DbUtil.close(con);
            }
            DbUtil.close(evtRs);
            DbUtil.close(stmt);
            DbUtil.close(evtStmt);
            DbUtil.close(con);
        }
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLanEvtsLength(long lanHostId) {
        Connection con = null;
        PreparedStatement stmt = null;
        Statement evtStmt = null;
        ResultSet rs = null;
        ResultSet evtRs = null;
        String sql = null;
        long evtLength = 0L;
        try {
            con = ConnectionManager.getConnection();
            sql = SQLLoader.getSqlStmt("HostEnclHandler.LAN_EVT_LENGTH_STMT");
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, lanHostId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                evtLength = rs.getLong(1);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(evtRs);
                DbUtil.close(stmt);
                DbUtil.close(evtStmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(evtRs);
            DbUtil.close(stmt);
            DbUtil.close(evtStmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(evtRs);
        DbUtil.close(stmt);
        DbUtil.close(evtStmt);
        DbUtil.close(con);
        return evtLength;
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("name", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("Name", " ORDER BY ENC.NAME ");
        this._Name2SqlHash.put("vhostName", " ORDER BY VH.NAME ");
        this._Name2SqlHash.put("hostTime", " ORDER BY EVT.HOST_TIME ");
        this._Name2SqlHash.put("vmname", " ORDER BY VHOST.NAME ");
        this._Name2SqlHash.put("vmcluster", " ORDER BY HC.NAME ");
        this._Name2SqlHash.put("rxtxStr", " ORDER BY STATS.TOTAL_RXTX ");
        this._Name2SqlHash.put("vcluster", " ORDER BY HC.NAME ");
        this._Name2SqlHash.put("ucsSp", " ORDER BY ENC.SERVICE_PROFILE ");
        this._Name2SqlHash.put("multipath", " ORDER BY VH.MULTIPATH ");
    }

    private void timer(long start, long end, String name) {
        long duration = end - start;
        if (duration < 10L) {
            this._Log.debug((Object)("   " + duration + " ms " + name));
        } else if (duration < 100L) {
            this._Log.debug((Object)("  " + duration + " ms " + name));
        } else if (duration < 1000L) {
            this._Log.debug((Object)(" " + duration + " ms " + name));
        } else {
            this._Log.debug((Object)(duration + " ms " + name));
        }
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        try {
            HostEnclHandler.getInstance().getEnclChartData(2158158990L, 2, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long end = System.currentTimeMillis();
        System.out.println("Total:" + (end - start));
        start = System.currentTimeMillis();
        end = System.currentTimeMillis();
        System.out.println("Length Total:" + (end - start));
    }

    class CompareRxTx
    implements Comparable {
        TopoTrafficItemDO item_rx;
        TopoTrafficItemDO item_tx;
        Double compareValue;

        CompareRxTx(Double compareValue, TopoTrafficItemDO item_rx, TopoTrafficItemDO item_tx) {
            this.compareValue = compareValue;
            this.item_rx = item_rx;
            this.item_tx = item_tx;
        }

        Double getCompareValue() {
            return this.compareValue;
        }

        TopoTrafficItemDO getRx() {
            return this.item_rx;
        }

        TopoTrafficItemDO getTx() {
            return this.item_tx;
        }

        public int compareTo(Object o) {
            return this.compareValue.compareTo(((CompareRxTx)o).getCompareValue());
        }
    }
}

