/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.lan.connector;

import java.io.Serializable;

public class CliMode
implements Serializable {
    public static final CliMode USER_MODE = new CliMode("", "");
    public static final CliMode EXEC_MODE = new CliMode("enable", "disable");
    public static final CliMode CONFIG_MODE = new CliMode("conf t", "exit", EXEC_MODE);
    public static final CliMode NXOS_MODE = new CliMode("connect nxos", "exit", EXEC_MODE);
    String entryCliCommand;
    String exitCliCommand;
    CliMode parentNode;
    CliMode childNode;
    private static final long serialVersionUID = 1L;

    public CliMode(String entryCliCommand) {
        this(entryCliCommand, "exit", null);
    }

    public CliMode(String entryCliCommand, String exitCliCommand) {
        this(entryCliCommand, exitCliCommand, null);
    }

    public CliMode(String entryCliCommand, String exitCliCommand, CliMode parentNode) {
        if (entryCliCommand == null) {
            throw new IllegalArgumentException("Entry CLI command cannot be null.");
        }
        if (exitCliCommand == null) {
            throw new IllegalArgumentException("Exit CLI command cannot be null.");
        }
        this.entryCliCommand = entryCliCommand;
        this.exitCliCommand = exitCliCommand;
        if (parentNode != null) {
            this.setParentCliMode(parentNode);
        }
    }

    public String getEntryCliCommand() {
        return this.entryCliCommand;
    }

    public String getExitCliCommand() {
        return this.exitCliCommand;
    }

    public void setParentCliMode(CliMode parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException("Parent CLI mode cannot be null.");
        }
        this.parentNode = parentNode;
        parentNode.childNode = this;
    }

    public CliMode createSubMode(String entryCommand, String exitCommand) {
        CliMode cliMode = new CliMode(entryCommand, exitCommand, this);
        return cliMode;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CliMode)) {
            return false;
        }
        CliMode modeObj = (CliMode)obj;
        return this.entryCliCommand.equals(modeObj.entryCliCommand) && this.exitCliCommand.equals(modeObj.exitCliCommand);
    }

    public int hashCode() {
        return this.entryCliCommand.hashCode() + this.exitCliCommand.hashCode();
    }
}

