/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.portmapper;

import com.cisco.dcbu.dcm.model.enumkind.NetworkInterfaceAdminStatus;
import com.cisco.dcbu.dcm.model.enumkind.NetworkInterfaceDuplexMode;
import com.cisco.dcbu.dcm.model.enumkind.NetworkInterfaceOperationStatus;
import com.cisco.dcbu.dcm.model.enumkind.NetworkInterfaceSpeedMode;
import com.cisco.dcbu.dcm.model.enumkind.StpLinkType;
import com.cisco.dcbu.dcm.model.enumkind.StpPortPriorityEnum;
import com.cisco.dcbu.dcm.model.enumkind.StpPortRole;
import com.cisco.dcbu.dcm.model.enumkind.StpPortState;
import com.cisco.dcbu.dcm.model.enumkind.StpProtocol;
import com.cisco.dcbu.dcm.model.enumkind.SwitchedNetworkInterfaceMode;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.jaxws.wo.InterfaceInfo;
import com.cisco.dcbu.jaxws.wo.StpInfoDo;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.PersistentWrapperIf;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.portmapper.Constants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PortMapperHandler {
    private static PortMapperHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();
    private Map<String, String> _FilterHash = new HashMap<String, String>();
    private Map<String, Integer> _enumType2Hash;
    private Map<String, String> _stpFilterSqlHash = new HashMap<String, String>();
    private Map<String, String> _stpOrderingHash = new HashMap<String, String>();
    private Map<String, String> _networkInterfaceSpeedModeType;

    public static PortMapperHandler getInstance() {
        if (_Instance == null) {
            _Instance = new PortMapperHandler();
        }
        return _Instance;
    }

    private PortMapperHandler() {
        this.initSqlSortSuffix();
        this._enumType2Hash = new HashMap<String, Integer>();
        this._networkInterfaceSpeedModeType = new HashMap<String, String>();
        this.initEnumTypeHash();
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("interfaceName", "order by ni.name");
        this._Name2SqlHash.put("description", "order by ni.description");
        this._Name2SqlHash.put("hostName", "order by ane.hostname");
        this._Name2SqlHash.put("speed", "order by operstauts.speed");
        this._Name2SqlHash.put("portType", "order by ni.snimode");
        this._Name2SqlHash.put("duplex", "order by portstauts.duplex");
        this._Name2SqlHash.put("adminStatus", "order by ni.adminstatus");
        this._Name2SqlHash.put("operationalStatus", "order by operstauts.operationalstatus");
        this._Name2SqlHash.put("allowedVlans", "order by ni.allowedvlans");
        this._Name2SqlHash.put("macAddress", "order by ni.macaddress");
        this._Name2SqlHash.put("ipAddress", "order by ni.ipaddressprefix");
        this._Name2SqlHash.put("sfpSerialNumber", "order by sfp.serialnumber");
        this._Name2SqlHash.put("stpProtocol", "order by ane.protocol");
        this._stpOrderingHash.put("mstId", "order by  mst.mstsetting_id");
        this._stpOrderingHash.put("vlansmapped", "order by stpSetting.vlansmapped");
        this._stpOrderingHash.put("priority", "order by status.priority");
        this._stpOrderingHash.put("state", "order by status.state");
        this._stpOrderingHash.put("linkType", "order by status.linktype");
        this._stpOrderingHash.put("role", "order by status.role");
        this._stpOrderingHash.put("cost", "order by status.cost");
        this._stpOrderingHash.put("boundaryPort", "order by status.boundaryport");
        this._stpOrderingHash.put("preStandardPort", "order by status.prestandardport");
        this._stpOrderingHash.put("vlanId", "order by vlanref.vlanid");
        this._FilterHash.put("interfaceName", "ni.name like");
        this._FilterHash.put("description", "ni.description like");
        this._FilterHash.put("hostName", "ane.hostname like");
        this._FilterHash.put("speed", "operstauts.speed=");
        this._FilterHash.put("portType", "ni.snimode=");
        this._FilterHash.put("duplex", "portstauts.duplex=");
        this._FilterHash.put("adminStatus", "ni.adminstatus=");
        this._FilterHash.put("operationalStatus", "operstauts.operationalstatus=");
        this._FilterHash.put("allowedVlans", "ni.allowedvlans like");
        this._FilterHash.put("macAddress", "ni.macaddressburntin like");
        this._FilterHash.put("ipAddress", "ni.ipaddressprefix like");
        this._FilterHash.put("sfpSerialNumber", "sfp.serialnumber like");
        this._FilterHash.put("stpProtocol", "ane.protocol=");
        this._stpFilterSqlHash.put("mstId", "mst.mstsetting_id=");
        this._stpFilterSqlHash.put("vlansmapped", "stpSetting.vlansmapped like");
        this._stpFilterSqlHash.put("priority", "status.priority=");
        this._stpFilterSqlHash.put("state", "status.state=");
        this._stpFilterSqlHash.put("linkType", "status.linktype=");
        this._stpFilterSqlHash.put("role", "status.role=");
        this._stpFilterSqlHash.put("cost", "status.cost");
        this._stpFilterSqlHash.put("boundaryPort", "status.boundaryport =");
        this._stpFilterSqlHash.put("preStandardPort", "status.prestandardport =");
        this._stpFilterSqlHash.put("vlanId", "vlanref.vlanid");
    }

    private void initEnumTypeHash() {
        int idx;
        for (idx = 0; idx <= NetworkInterfaceAdminStatus.maxOrdinal(); ++idx) {
            NetworkInterfaceAdminStatus niAdminStatus = NetworkInterfaceAdminStatus.getInstance((int)idx);
            this._enumType2Hash.put("adminStatus" + niAdminStatus.getName(), new Integer(niAdminStatus.getOrdinal()));
        }
        for (idx = 0; idx <= NetworkInterfaceOperationStatus.maxOrdinal(); ++idx) {
            NetworkInterfaceOperationStatus niOperationalStatus = NetworkInterfaceOperationStatus.getInstance((int)idx);
            this._enumType2Hash.put("operationalStatus" + niOperationalStatus.getName(), new Integer(niOperationalStatus.getOrdinal()));
        }
        for (idx = 0; idx <= NetworkInterfaceSpeedMode.maxOrdinal(); ++idx) {
            NetworkInterfaceSpeedMode niSpeedMode = NetworkInterfaceSpeedMode.getInstance((int)idx);
            this._enumType2Hash.put("speed" + niSpeedMode.getName(), new Integer(niSpeedMode.getOrdinal()));
        }
        for (idx = 0; idx <= NetworkInterfaceDuplexMode.maxOrdinal(); ++idx) {
            NetworkInterfaceDuplexMode niDuplexMode = NetworkInterfaceDuplexMode.getInstance((int)idx);
            this._enumType2Hash.put("duplex" + niDuplexMode.getName(), new Integer(niDuplexMode.getOrdinal()));
        }
        for (idx = 0; idx <= StpProtocol.maxOrdinal(); ++idx) {
            StpProtocol stpProtocol = StpProtocol.getInstance((int)idx);
            this._enumType2Hash.put("stpProtocol" + stpProtocol.getName(), new Integer(stpProtocol.getOrdinal()));
        }
        for (idx = 0; idx <= StpLinkType.maxOrdinal(); ++idx) {
            StpLinkType stpLinkType = StpLinkType.getInstance((int)idx);
            this._enumType2Hash.put("linkType" + stpLinkType.getName(), new Integer(stpLinkType.getOrdinal()));
        }
        for (idx = 0; idx <= StpPortPriorityEnum.maxOrdinal(); ++idx) {
            StpPortPriorityEnum stpPortPriority = StpPortPriorityEnum.getInstance((int)idx);
            this._enumType2Hash.put("priority" + stpPortPriority.getName(), new Integer(stpPortPriority.getOrdinal()));
        }
        for (idx = 0; idx <= StpPortRole.maxOrdinal(); ++idx) {
            StpPortRole stpProtRole = StpPortRole.getInstance((int)idx);
            this._enumType2Hash.put("role" + stpProtRole.getName(), new Integer(stpProtRole.getOrdinal()));
        }
        for (idx = 0; idx <= StpPortState.maxOrdinal(); ++idx) {
            StpPortState stpPortState = StpPortState.getInstance((int)idx);
            this._enumType2Hash.put("state" + stpPortState.getName(), new Integer(stpPortState.getOrdinal()));
        }
        for (idx = 0; idx <= SwitchedNetworkInterfaceMode.maxOrdinal(); ++idx) {
            SwitchedNetworkInterfaceMode switchedNetworkInterfaceMode = SwitchedNetworkInterfaceMode.getInstance((int)idx);
            this._enumType2Hash.put("portType" + switchedNetworkInterfaceMode.getName(), new Integer(switchedNetworkInterfaceMode.getOrdinal()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPortMappingDataLength(DbFilterDO dbFilter) {
        int portCount;
        block6: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            portCount = 0;
            String sql = Constants.portMappingCount + Constants.excludePortProfile;
            try {
                sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), null);
                this._Log.info((Object)("getPortMappingDataLength Sql" + sql));
                con = ConnectionManager.getConnection();
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    portCount = rs.getInt(1);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return portCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceInfo[] getPortMappingInfo(DbFilterDO dbFilter, int startIdx, int recordSize) throws SanServiceException {
        HashSet<Long> niInstanceClassIdSet;
        ArrayList<InterfaceInfo> portMappingInterfaceList;
        block30: {
            PreparedStatement stament;
            ArrayList<String> nIInstanceClassIdList;
            String sql;
            ResultSet rs;
            PreparedStatement stmt;
            Connection con;
            block29: {
                block28: {
                    portMappingInterfaceList = new ArrayList<InterfaceInfo>(recordSize);
                    con = null;
                    stmt = null;
                    rs = null;
                    sql = null;
                    nIInstanceClassIdList = new ArrayList<String>();
                    niInstanceClassIdSet = new HashSet<Long>();
                    try {
                        con = ConnectionManager.getConnection();
                        sql = Constants.portMappingInfo + Constants.excludePortProfile;
                        sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), null);
                        sql = sql + " " + this._Name2SqlHash.get(dbFilter.getSortField());
                        sql = sql + " " + dbFilter.getSortType();
                        this._Log.info((Object)("getPortMappingInfo Sql query" + sql));
                        stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                        rs = stmt.executeQuery();
                        if (startIdx != 0) {
                            rs.absolute(startIdx);
                        }
                        int curIdx = 0;
                        while (rs.next()) {
                            InterfaceInfo ifInfo = new InterfaceInfo();
                            ifInfo.setInterfaceName(rs.getString("name"));
                            ifInfo.setHostName(rs.getString("hostname"));
                            ifInfo.setDefaultVdc(rs.getBoolean("defaultvdc"));
                            ifInfo.setAllowedVlans(rs.getString("allowedvlans"));
                            ifInfo.setAllowedvlansforpvlantrunk(rs.getString("allowedvlansforpvlantrunk"));
                            ifInfo.setDescription(rs.getString("description"));
                            String speed = NetworkInterfaceSpeedMode.getInstance((int)rs.getInt("speed")).getName();
                            ifInfo.setSpeed(speed);
                            String classType = rs.getString("class_type");
                            if (rs.getObject("snimode") != null) {
                                String sniMode = SwitchedNetworkInterfaceMode.getInstance((int)rs.getInt("snimode")).getName();
                                ifInfo.setPortType(sniMode);
                                if (rs.getObject("protocol") != null && !SwitchedNetworkInterfaceMode.FABRICPATH.getName().equals(sniMode)) {
                                    ifInfo.setStpProtocol(StpProtocol.getInstance((int)rs.getInt("protocol")).getName());
                                } else {
                                    ifInfo.setStpProtocol("");
                                }
                            } else if ("vlanNetworkInterface".equalsIgnoreCase(classType)) {
                                ifInfo.setPortType("");
                                ifInfo.setStpProtocol("");
                            } else {
                                ifInfo.setPortType("Routed");
                                ifInfo.setStpProtocol("");
                            }
                            if (rs.getObject("duplex") != null) {
                                ifInfo.setDuplex(NetworkInterfaceDuplexMode.getInstance((int)rs.getInt("duplex")).getName());
                            } else {
                                ifInfo.setDuplex("");
                            }
                            ifInfo.setMacAddress(rs.getString("macaddressburntin"));
                            ifInfo.setIpAddress(rs.getString("ipaddressprefix"));
                            ifInfo.setAdminStatus(NetworkInterfaceAdminStatus.getInstance((int)rs.getInt("adminstatus")).getName());
                            ifInfo.setSfpSerialNumber(rs.getString("serialnumber"));
                            ifInfo.setOperationalStatus(NetworkInterfaceOperationStatus.getInstance((int)rs.getInt("operationalstatus")).getName());
                            ifInfo.setInstanceClassId(rs.getLong("instanceclassid"));
                            nIInstanceClassIdList.add(ifInfo.getInstanceClassId().toString());
                            portMappingInterfaceList.add(ifInfo);
                            if (++curIdx < recordSize) continue;
                            break;
                        }
                        DbUtil.close(rs);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                        break block28;
                    }
                    finally {
                        DbUtil.close(rs);
                        DbUtil.close(stmt);
                        DbUtil.close(con);
                    }
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                }
                if (nIInstanceClassIdList.size() <= 0 || nIInstanceClassIdList.size() > 50) break block30;
                try {
                    con = ConnectionManager.getConnection();
                    sql = MessageFormat.format(Constants.mstSettingOnInterface, this.convertCommaSeperatedString(nIInstanceClassIdList));
                    stament = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    rs = stament.executeQuery();
                    while (rs.next()) {
                        niInstanceClassIdSet.add(rs.getLong("networkinterface_id"));
                    }
                    DbUtil.close(rs);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block29;
                }
                finally {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                }
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            try {
                con = ConnectionManager.getConnection();
                sql = MessageFormat.format(Constants.pvstSettingOnInterface, this.convertCommaSeperatedString(nIInstanceClassIdList));
                stament = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = stament.executeQuery();
                while (rs.next()) {
                    niInstanceClassIdSet.add(rs.getLong("networkinterface_id"));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block30;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        for (InterfaceInfo ifInfo : portMappingInterfaceList) {
            ifInfo.setStpStatusExist(niInstanceClassIdSet.contains(ifInfo.getInstanceClassId()));
        }
        return portMappingInterfaceList.toArray(new InterfaceInfo[portMappingInterfaceList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StpInfoDo[] getStpInfo(DbFilterDO dbFilter, Long neInstanceClassId, String stpProtocolType) throws SanServiceException {
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = null;
        ArrayList<StpInfoDo> portStpInfoList = new ArrayList<StpInfoDo>();
        try {
            if (StpProtocol.MST.getName().equals(stpProtocolType)) {
                con = ConnectionManager.getConnection();
                sql = Constants.portMappingMst;
                sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), "stp");
                if (this._stpOrderingHash.containsKey(dbFilter.getSortField())) {
                    sql = sql + " " + this._stpOrderingHash.get(dbFilter.getSortField());
                    sql = sql + " " + dbFilter.getSortType();
                }
                this._Log.info((Object)("getStpInfo Sql query" + sql));
                sql = MessageFormat.format(sql, neInstanceClassId.toString());
                System.out.println(sql);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    StpInfoDo stpInfo = new StpInfoDo();
                    stpInfo.setBoundaryPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "boundaryport"));
                    stpInfo.setCost(rs.getInt("cost"));
                    stpInfo.setLinkType(StpLinkType.getInstance((int)rs.getInt("linktype")).getName());
                    stpInfo.setPreStandardPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "prestandardport"));
                    stpInfo.setPriority(StpPortPriorityEnum.getInstance((int)rs.getInt("priority")).getName());
                    stpInfo.setRole(StpPortRole.getInstance((int)rs.getInt("role")).getName());
                    stpInfo.setState(StpPortState.getInstance((int)rs.getInt("state")).getName());
                    stpInfo.setMstId(rs.getString("instanceId"));
                    stpInfo.setVlansmapped(rs.getString("vlansmapped"));
                    stpInfo.setVlanId("N/A");
                    portStpInfoList.add(stpInfo);
                }
            } else if (StpProtocol.RPVST_PLUS.getName().equals(stpProtocolType) || StpProtocol.PVST.getName().equals(stpProtocolType)) {
                con = ConnectionManager.getConnection();
                sql = Constants.portMappingPvst;
                sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), "stp");
                if (this._stpOrderingHash.containsKey(dbFilter.getSortField())) {
                    sql = sql + " " + this._stpOrderingHash.get(dbFilter.getSortField());
                    sql = sql + " " + dbFilter.getSortType();
                }
                sql = MessageFormat.format(sql, neInstanceClassId.toString());
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    StpInfoDo stpInfo = new StpInfoDo();
                    stpInfo.setBoundaryPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "boundaryport"));
                    stpInfo.setCost(rs.getInt("cost"));
                    stpInfo.setLinkType(StpLinkType.getInstance((int)rs.getInt("linktype")).getName());
                    stpInfo.setPreStandardPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "prestandardport"));
                    stpInfo.setPriority(StpPortPriorityEnum.getInstance((int)rs.getInt("priority")).getName());
                    stpInfo.setRole(StpPortRole.getInstance((int)rs.getInt("role")).getName());
                    stpInfo.setState(StpPortState.getInstance((int)rs.getInt("state")).getName());
                    stpInfo.setMstId("N/A");
                    stpInfo.setVlansmapped("N/A");
                    stpInfo.setVlanId(rs.getString("vlanid"));
                    portStpInfoList.add(stpInfo);
                }
            }
        }
        catch (Exception ex) {
            this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return portStpInfoList.toArray(new StpInfoDo[portStpInfoList.size()]);
    }

    private String getColFilterSql(String colFilterStr, String stpInfo) {
        String filterSql;
        block9: {
            filterSql = "";
            HashSet<String> booleanAttributes = new HashSet<String>();
            booleanAttributes.add("boundaryPort");
            booleanAttributes.add("preStandardPort");
            HashSet<String> castAttibutes = new HashSet<String>();
            castAttibutes.add("cost");
            castAttibutes.add("vlanId");
            castAttibutes.add("mstId");
            if (colFilterStr == null || colFilterStr.length() <= 0) break block9;
            String[] pairs = colFilterStr.split(";");
            if ("stp".equals(stpInfo)) {
                for (int i = 0; i < pairs.length; ++i) {
                    String item = pairs[i];
                    String key = item.split(":")[0];
                    String vlu = item.split(":")[1];
                    if ("All".equals(vlu) || !this._stpFilterSqlHash.containsKey(key)) continue;
                    String enumKey = key + vlu;
                    filterSql = this._enumType2Hash.containsKey(enumKey) ? filterSql + " AND " + this._stpFilterSqlHash.get(key) + this._enumType2Hash.get(enumKey) : (booleanAttributes.contains(key) ? filterSql + " AND " + this._stpFilterSqlHash.get(key) + vlu : (castAttibutes.contains(key) ? filterSql + " AND CAST(" + this._stpFilterSqlHash.get(key) + " AS varchar) like " + "'%" + vlu + "%' " : filterSql + " AND " + this._stpFilterSqlHash.get(key) + "'%" + vlu + "%' "));
                }
            } else {
                String modeValue = "";
                for (int i = 0; i < pairs.length; ++i) {
                    String item = pairs[i];
                    if (item.split(":")[0] == null || item.split(":").length < 2) continue;
                    String key = item.split(":")[0];
                    String vlu = item.split(":")[1];
                    if ("All".equals(vlu)) continue;
                    if ("portType".equals(key)) {
                        modeValue = vlu;
                    }
                    String enumKey = key + vlu;
                    if ("Routed".equals(modeValue) && "stpProtocol".equals(key)) {
                        filterSql = filterSql + " AND " + this._FilterHash.get(key) + this._enumType2Hash.get(enumKey) + "  AND snimode is not null ";
                        continue;
                    }
                    if (this._enumType2Hash.containsKey(enumKey) && "stpProtocol".equals(key)) {
                        filterSql = filterSql + " AND " + this._FilterHash.get(key) + this._enumType2Hash.get(enumKey) + "  AND snimode is not null " + " AND ni.snimode!=8 ";
                        continue;
                    }
                    if ("Routed".equals(vlu)) {
                        filterSql = filterSql + " AND snimode is null ";
                        continue;
                    }
                    if (this._enumType2Hash.containsKey(enumKey)) {
                        filterSql = filterSql + " AND " + this._FilterHash.get(key) + this._enumType2Hash.get(enumKey);
                        continue;
                    }
                    if (!this._FilterHash.containsKey(key)) continue;
                    filterSql = filterSql + " AND " + this._FilterHash.get(key) + "'%" + vlu + "%' ";
                }
            }
        }
        return filterSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStpInfoDataLength(DbFilterDO dbFilter, Long neInstanceClassId, String stpProtocolType) {
        int stpCount;
        block9: {
            Connection con = null;
            Statement stmt = null;
            ResultSet rs = null;
            stpCount = 0;
            String sql = null;
            if (StpProtocol.MST.getName().equals(stpProtocolType)) {
                sql = Constants.portMappingMstCount;
            } else if (StpProtocol.RPVST_PLUS.getName().equals(stpProtocolType) || StpProtocol.PVST.getName().equals(stpProtocolType)) {
                sql = Constants.portMappingPvstCount;
            }
            try {
                sql = MessageFormat.format(sql, neInstanceClassId.toString());
                sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), "stp");
                sql = this.getQueryString(sql);
                this._Log.info((Object)("getStpInfoDataLength Sql" + sql));
                con = ConnectionManager.getConnection();
                PreparedStatement stament = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = stament.executeQuery();
                while (rs.next()) {
                    stpCount = rs.getInt(1);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
                break block9;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return stpCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StpInfoDo[] getStpInfo(DbFilterDO dbFilter, Long neInstanceClassId, String stpProtocolType, int startIdx, int recordSize) throws SanServiceException {
        ArrayList<StpInfoDo> portStpInfoList;
        block10: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            portStpInfoList = new ArrayList<StpInfoDo>();
            int curIdx = 0;
            try {
                if (StpProtocol.MST.getName().equals(stpProtocolType)) {
                    con = ConnectionManager.getConnection();
                    sql = Constants.portMappingMst;
                    sql = MessageFormat.format(sql, neInstanceClassId.toString());
                    sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), "stp");
                    sql = sql + " " + this._Name2SqlHash.get(dbFilter.getSortField());
                    sql = sql + " " + dbFilter.getSortType();
                    sql = this.getQueryString(sql);
                    this._Log.info((Object)("getStpInfo Sql query" + sql));
                    System.out.println(sql);
                    stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                    rs = stmt.executeQuery();
                    if (startIdx != 0) {
                        rs.absolute(startIdx);
                    }
                    while (rs.next()) {
                        StpInfoDo stpInfo = new StpInfoDo();
                        stpInfo.setBoundaryPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "boundaryport"));
                        stpInfo.setCost(rs.getInt("cost"));
                        stpInfo.setLinkType(StpLinkType.getInstance((int)rs.getInt("linktype")).getName());
                        stpInfo.setPreStandardPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "prestandardport"));
                        stpInfo.setPriority(StpPortPriorityEnum.getInstance((int)rs.getInt("priority")).getName());
                        stpInfo.setRole(StpPortRole.getInstance((int)rs.getInt("role")).getName());
                        stpInfo.setState(StpPortState.getInstance((int)rs.getInt("state")).getName());
                        stpInfo.setMstId(rs.getString("instanceId"));
                        stpInfo.setVlansmapped(rs.getString("vlansmapped"));
                        stpInfo.setVlanId("N/A");
                        portStpInfoList.add(stpInfo);
                        if (++curIdx < recordSize) continue;
                        break block10;
                    }
                    break block10;
                }
                if (!StpProtocol.RPVST_PLUS.getName().equals(stpProtocolType) && !StpProtocol.PVST.getName().equals(stpProtocolType)) break block10;
                con = ConnectionManager.getConnection();
                sql = Constants.portMappingPvst;
                sql = MessageFormat.format(sql, neInstanceClassId.toString());
                sql = sql + " " + this.getColFilterSql(dbFilter.getColFilterStr(), "stp");
                sql = this.getQueryString(sql);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = stmt.executeQuery();
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                while (rs.next()) {
                    StpInfoDo stpInfo = new StpInfoDo();
                    stpInfo.setBoundaryPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "boundaryport"));
                    stpInfo.setCost(rs.getInt("cost"));
                    stpInfo.setLinkType(StpLinkType.getInstance((int)rs.getInt("linktype")).getName());
                    stpInfo.setPreStandardPort(PersistentHelper.getHelper().getBooleanFromStringField(rs, "prestandardport"));
                    stpInfo.setPriority(StpPortPriorityEnum.getInstance((int)rs.getInt("priority")).getName());
                    stpInfo.setRole(StpPortRole.getInstance((int)rs.getInt("role")).getName());
                    stpInfo.setState(StpPortState.getInstance((int)rs.getInt("state")).getName());
                    stpInfo.setMstId("N/A");
                    stpInfo.setVlansmapped("N/A");
                    stpInfo.setVlanId(rs.getString("vlanid"));
                    portStpInfoList.add(stpInfo);
                    if (++curIdx < recordSize) continue;
                    break;
                }
            }
            catch (Exception ex) {
                this._Log.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
        }
        return portStpInfoList.toArray(new StpInfoDo[portStpInfoList.size()]);
    }

    public String printPortMapperTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        InterfaceInfo[] interfaceInfoArray = PortMapperHandler.getInstance().getPortMappingInfo(dbFilter, startIdx, recordSize);
        List<InterfaceInfo> interfaceList = Arrays.asList(interfaceInfoArray);
        String title = "PortMapper Report";
        return JasperPrintGenerator.getInstance().generatePrintReport(title, columnHeader, interfaceList);
    }

    public String exportPortMapperTable(DbFilterDO dbFilter, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        InterfaceInfo[] interfaceInfoArray = PortMapperHandler.getInstance().getPortMappingInfo(dbFilter, startIdx, recordSize);
        List<InterfaceInfo> interfaceList = Arrays.asList(interfaceInfoArray);
        String title = "PortMapper Report";
        return JasperPrintGenerator.getInstance().generateExcelReport(title, columnHeader, interfaceList);
    }

    private String convertCommaSeperatedString(List<String> neInstanceClassIdList) {
        StringBuilder sb = new StringBuilder();
        for (String item : neInstanceClassIdList) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public String getQueryString(String in) {
        PersistentWrapperIf persistentWrapper = PersistentHelper.getHelper();
        if (!persistentWrapper.isPostgresDB().booleanValue()) {
            in = in.replaceAll("true", "1");
            in = in.replaceAll("false", "0");
            in = in.replaceAll("varchar", "varchar2(10)");
        }
        return in;
    }
}

