/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.report;

import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.sm.common.model.FilterTreeWrapper;
import com.cisco.dcbu.sm.common.util.Filter;
import com.cisco.dcbu.sm.server.web.report.ReportGroup;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;

public class CustomReport {
    private String title;
    private String scope;
    private String toFile;
    private LinkedList<ReportGroup> groups = new LinkedList();
    private int originalSessionTimeoutInterval = -1;
    private boolean ajaxEnabled = false;
    private boolean personal = true;
    private static String uri;
    private HashMap<String, Filter> filters = new HashMap();

    public CustomReport(String title) {
        this.title = title;
    }

    public CustomReport() {
    }

    public static String getUri() {
        return uri;
    }

    public static void setUri(String uri) {
        CustomReport.uri = uri;
    }

    public void addFilter(String filterName, Object filterValue) {
        Filter filter = new Filter(filterName, filterValue);
        this.addFilter(filter);
    }

    public void addFilter(Filter filter) {
        this.filters.put(filter.getFilterKey(), filter);
        for (ReportGroup group : this.groups) {
            group.addFilter(filter);
        }
    }

    public Object getFilterValue(String filterKey) {
        return this.filters.get(filterKey).getFilterValue();
    }

    public boolean isAjaxEnabled() {
        return this.ajaxEnabled;
    }

    public void setAjaxEnabled(boolean ajaxEnabled) {
        this.ajaxEnabled = ajaxEnabled;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LinkedList<ReportGroup> getGroups() {
        return this.groups;
    }

    public void addGroup(ReportGroup group) {
        this.groups.add(group);
        group.addAll(this.filters);
    }

    public String getTitle() {
        if (this.title == null) {
            return "DCNM";
        }
        return this.title;
    }

    public String getNoWrap() {
        String noWrap = System.getProperty("web.report.nowrap", "true");
        return noWrap;
    }

    public String getScope() {
        if (this.scope != null) {
            return this.scope;
        }
        Filter filter = this.filters.get(Filter.SELECTED);
        if (filter != null) {
            this.scope = ((FilterTreeWrapper)filter.getFilterValue()).getPathName(false);
        }
        return this.scope;
    }

    public void setScope(String s) {
        this.scope = s;
    }

    public String getCreationTime() {
        Date now = new Date();
        SimpleDateFormat timeZone = new SimpleDateFormat("zzz");
        return " as of " + SnmpTimeticks.getDateFormat().format(now) + " " + timeZone.format(now);
    }

    public boolean isShowToc() {
        return this.groups.size() != 1 || this.groups.get(0).getReports().size() != 1;
    }

    public boolean isNotEmpty() {
        for (ReportGroup group : this.groups) {
            if (group.getReports().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public String getToFile() {
        return this.toFile;
    }

    public void setToFile(String toFile) {
        this.toFile = toFile;
        this.addFilter(new Filter(Filter.TOFILE, (Object)toFile, false));
    }

    public int getOriginalSessionTimeoutInterval() {
        return this.originalSessionTimeoutInterval;
    }

    public void setOriginalSessionTimeoutInterval(int originalSessionTimeoutInterval) {
        this.originalSessionTimeoutInterval = originalSessionTimeoutInterval;
    }

    public String getNote() {
        return null;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }
}

