/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.util;

import com.cisco.dcbu.jaxws.san.wo.SwitchDO;
import com.cisco.dcbu.jaxws.wo.DBEntryDO;
import com.cisco.dcbu.jaxws.wo.DBRowDO;
import com.cisco.dcbu.jaxws.wo.DbRowDOComparator;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.dto.SwitchAssignedLicenseInfo;
import com.cisco.dcbu.sm.common.model.NavBase;
import com.cisco.dcbu.sm.common.model.ServerReference;
import com.cisco.dcbu.sm.server.db.ClusterMapping;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.licmgr.FileLicensingHelper;
import com.cisco.dcbu.sm.server.web.WebReferenceManager;
import com.cisco.dcbu.sm.server.web.util.AppGroupUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import java.io.StringReader;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.crimson.tree.ElementNode;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DeferredElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NavigationUtil {
    static final String _GetGroupSQL = "select id, name, type from nav_groups";
    static final String _GetGroupForIDSQL = "select  name from nav_groups where id=?";
    static final String _GetSwitchSQL = "select sw.sys_name, sw.sys_location, sw.non_mds_model,ip_address, sw.id from switch sw, fabric where sw.fabric_id = fabric.id and fabric.id = ?";
    static final String _GetGroupMemSQL = "select mem_dbid, mem_name, type from nav_group_member where group_id =? order by mem_name";
    static final String _GetLanGroupMemSQL = "(select mem_dbid, mem_name, type from nav_group_member where (type=1 or type=2)  and group_id = ? and  mem_dbid not in (select ngm.group_id from nav_group_member ngm where ngm.type=0))  union  (select mem_dbid, mem_name, type from nav_group_member where (type=1 or type=2)  and group_id = ? and   mem_dbid in (select ngm.group_id from nav_group_member ngm where ngm.type=1 or ngm.type=2))  order by mem_name ";
    static final String _InsertGroupMemberSQL = "insert into nav_group_member values(?,?,?,?,?)";
    static final String _UpdateGroupMemberSQL = "update nav_group_member set group_id = ? where mem_dbid=?";
    static final String _UpdateGroupMemberNameSQL = "update nav_group_member set mem_name = ? where mem_dbid=?";
    static final String _InsertGroupSQL = "insert into nav_groups values(?,?,?)";
    static final String _RemoveGroupSQL = "delete from nav_groups where id = ?";
    static final String _RemoveGroupMemberSQL = "delete from nav_group_member where group_id = ?";
    static final String _GetAllLanGroupSQL = "select id, name from nav_groups where type =1";
    static final String _GetFabricGroupLanSQL = "select * from NAV_GROUP_MEMBER nav where nav.type=0  or nav.type=1";
    static final String _GetGroupTypeSQL = "select type from NAV_GROUP_MEMBER nav where nav.mem_dbid = ?";
    static final String _GetFabricIDFabriDBID = "select fabric.id, fabric.fid from fabric";
    static final String _GetNavGroupMembers = "select * from NAV_GROUP_MEMBER";
    private static final String PG_NAV_GROUP_MEM_SQL = "select nvm.id, coalesce(nvm.mem_dbid, ng.id), coalesce(nvm.mem_name,ng.name), coalesce(nvm.type,ng.type), coalesce(nvm.group_id,-1) as grpid  FROM nav_group_member nvm  FULL JOIN nav_groups ng ON nvm.mem_dbid=ng.id ORDER BY grpid ASC";
    private static final String ORCL_NAV_GROUP_MEM_SQL = "select nvm.id, NVL(nvm.mem_dbid, ng.id), NVL(nvm.mem_name,ng.name), NVL(nvm.type,ng.type), NVL(nvm.group_id,-1) as grpid  FROM nav_group_member nvm  FULL JOIN nav_groups ng ON nvm.mem_dbid=ng.id ORDER BY grpid ASC";
    private static Logger _Logger = Logger.getLogger((String)"fms");
    private static NavigationUtil _Instance = null;

    public static NavigationUtil getInstance() {
        if (_Instance == null) {
            _Instance = new NavigationUtil();
        }
        return _Instance;
    }

    private NavigationUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupName(long grpId) {
        String groupName = null;
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            List<SwitchAssignedLicenseInfo> swLcns = FileLicensingHelper.getInstance().getLicenseInfoSwitchAssignment();
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_GetGroupForIDSQL);
            stat.setLong(1, grpId);
            rs = stat.executeQuery();
            while (rs.next()) {
                groupName = rs.getString(1);
            }
        }
        catch (SQLException ex) {
            try {
                _Logger.error((Object)"getGroupName", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        return groupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBEntryDO getAllLanGroups() throws Exception {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"groupDbId", "groupName"});
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_GetAllLanGroupSQL);
            rs = stat.executeQuery();
            while (rs.next()) {
                DBRowDO row = new DBRowDO();
                long groupDbId = rs.getLong(1);
                String groupName = rs.getString(2);
                row.setEntry(new String[]{Long.toString(groupDbId), groupName});
                rList.add(row);
            }
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)"getAllLanGroups", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        Collections.sort(rList, new DbRowDOComparator(0));
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBEntryDO getFabricLanGroupList() {
        DBEntryDO dto = new DBEntryDO();
        ArrayList<DBRowDO> rList = new ArrayList<DBRowDO>();
        dto.setColumn(new String[]{"id", "memName"});
        Connection con = null;
        PreparedStatement stat = null;
        ResultSet rs = null;
        try {
            int groupId;
            int memType;
            con = ConnectionManager.getConnection();
            stat = con.prepareStatement(_GetGroupSQL);
            rs = stat.executeQuery();
            while (rs.next()) {
                DBRowDO row = new DBRowDO();
                long id = rs.getLong(1);
                String memName = rs.getString(2);
                memType = rs.getInt(3);
                if (memType != 1 && memType != 0) continue;
                long memDbId = id;
                groupId = 0;
                row.setEntry(new String[]{Long.toString(id), Long.toString(memDbId), memName, Integer.toString(memType), Integer.toString(groupId)});
                rList.add(row);
            }
            stat.clearBatch();
            stat.clearParameters();
            stat.close();
            stat = con.prepareStatement(_GetFabricIDFabriDBID);
            rs = stat.executeQuery();
            HashMap<Long, Integer> hMap = new HashMap<Long, Integer>();
            while (rs.next()) {
                hMap.put(rs.getLong(1), rs.getInt(2));
            }
            stat.clearBatch();
            stat.clearParameters();
            stat.close();
            stat = con.prepareStatement(_GetFabricGroupLanSQL);
            rs = stat.executeQuery();
            while (rs.next()) {
                DBRowDO row = new DBRowDO();
                long memDbId = rs.getLong(2);
                memType = rs.getInt(4);
                if (memType != 0) continue;
                int id = memType == 0 ? (Integer)hMap.get(memDbId) : -1;
                String memName = rs.getString(3);
                groupId = rs.getInt(5);
                row.setEntry(new String[]{Integer.toString(id), Long.toString(memDbId), memName, Integer.toString(memType), Integer.toString(groupId)});
                rList.add(row);
            }
        }
        catch (Exception ex) {
            try {
                _Logger.error((Object)"getFabricLanGroupList", (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stat);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stat);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stat);
        DbUtil.close(con);
        dto.setRow(rList.toArray(new DBRowDO[0]));
        return dto;
    }

    public String getGroupsInfo() throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        groupNavInXml.append("<groupList name='Data Center'>");
        groupNavInXml.append(this.constructGroupNavigation(-1L));
        groupNavInXml.append("</groupList>");
        return groupNavInXml.toString();
    }

    public String getLanGroupsInfo() throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        groupNavInXml.append("<groupList name='Data Center'>");
        groupNavInXml.append(this.constructGroupNavigation(-1L, false, true));
        groupNavInXml.append("</groupList>");
        return groupNavInXml.toString();
    }

    public String getSanGroupsInfo() throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        groupNavInXml.append("<groupList name='Data Center'>");
        groupNavInXml.append(this.constructSanGroupNavigation(-1L, false));
        groupNavInXml.append("</groupList>");
        return groupNavInXml.toString();
    }

    public String getLicensedLanSwitchesGroupsInfo() throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        groupNavInXml.append("<groupList name='Data Center'>");
        groupNavInXml.append(this.constructLicensedLanSwitchesGroupNavigation(-1L));
        groupNavInXml.append("</groupList>");
        return groupNavInXml.toString();
    }

    public String getGroupsNav() throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        groupNavInXml.append("<root><groupList name='Data Center'>");
        this.constructScopeNav(-1L, groupNavInXml);
        AppGroupUtil.getInstance().appendPortGroupNav(groupNavInXml);
        groupNavInXml.append("</groupList></root>");
        return groupNavInXml.toString();
    }

    public String getGroupsNavRootless() throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        groupNavInXml.append("<groupList name='Data Center'>");
        this.constructScopeNav(-1L, groupNavInXml);
        groupNavInXml.append("\n</groupList>");
        return groupNavInXml.toString();
    }

    private String constructGroupNavigation(long groupId) throws Exception {
        return this.constructGroupNavigation(groupId, true, false);
    }

    private String constructSanGroupNavigation(long groupId, boolean includeFabric) throws Exception {
        ArrayList<NavBase> memList = this.getMemberList(groupId, false, true);
        StringBuffer groupNavInXml = new StringBuffer();
        String navRst = null;
        for (NavBase base : memList) {
            switch (base.getNavType()) {
                case 2: {
                    navRst = this.constructSanGroupNavigation(base.getMemDbId(), includeFabric);
                    if (navRst == null) break;
                    groupNavInXml.append("\n<group isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 2L && base.getMemDbId() != 1L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" >\n");
                    groupNavInXml.append(navRst);
                    groupNavInXml.append("</group>");
                    break;
                }
                case 0: {
                    if (!includeFabric) break;
                    groupNavInXml.append("<groupMember isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 0L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" />");
                    break;
                }
            }
        }
        return groupNavInXml.toString();
    }

    private String constructGroupNavigation(long groupId, boolean includeSwitch, boolean lanOnly) throws Exception {
        StringBuffer groupNavInXml = new StringBuffer();
        String navRst = null;
        ArrayList<NavBase> memList = this.getMemberList(groupId, lanOnly);
        for (NavBase base : memList) {
            switch (base.getNavType()) {
                case 2: {
                    navRst = this.constructGroupNavigation(base.getMemDbId(), includeSwitch, lanOnly);
                    groupNavInXml.append("\n<group isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 2L && base.getMemDbId() != 1L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" >\n");
                    groupNavInXml.append(navRst);
                    groupNavInXml.append("</group>");
                    break;
                }
                case 0: {
                    if (lanOnly) break;
                    groupNavInXml.append("<groupMember isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 0L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" />");
                    break;
                }
                case 1: {
                    groupNavInXml.append("\n<group isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 2L && base.getMemDbId() != 1L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" >");
                    if (includeSwitch) {
                        List<SwitchDO> lanSwitchList = this.getLanSwitchesByLanGroup(base.getMemDbId());
                        for (SwitchDO lanSwitch : lanSwitchList) {
                            groupNavInXml.append("\n<groupMember isBranch=\"false\"  name=\"" + GenUtil.replaceStringForXML(lanSwitch.getName()) + "\" location=\"" + GenUtil.replaceStringForXML(lanSwitch.getLocation()) + "\"  " + "model=\"" + GenUtil.replaceStringForXML(lanSwitch.getModel()) + "\"  " + "icon=\"lanIcon\"  " + "ipAddress=\"" + lanSwitch.getIpAddress() + "\"  " + " state =\"unchecked" + "\" selectable= \"false" + "\" memDbId=\"" + lanSwitch.getSwitchDbID() + "\" type=\"" + 4 + "\" " + "/>");
                        }
                    }
                    groupNavInXml.append("</group>");
                    break;
                }
            }
        }
        return groupNavInXml.toString();
    }

    private String constructLicensedLanSwitchesGroupNavigation(long groupId) throws Exception {
        ArrayList<NavBase> memList = this.getMemberList(groupId, true);
        StringBuffer groupNavInXml = new StringBuffer();
        String navRst = null;
        for (NavBase base : memList) {
            switch (base.getNavType()) {
                case 2: {
                    navRst = this.constructLicensedLanSwitchesGroupNavigation(base.getMemDbId());
                    if (navRst == null) break;
                    groupNavInXml.append("\n<group isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 2L && base.getMemDbId() != 1L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" >\n");
                    groupNavInXml.append(navRst);
                    groupNavInXml.append("</group>");
                    break;
                }
                case 1: {
                    groupNavInXml.append("\n<group isBranch=\"true\"  name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 2L && base.getMemDbId() != 1L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" >");
                    List<SwitchDO> lanSwitchList = this.getLanSwitchesByLanGroup(base.getMemDbId());
                    for (SwitchDO lanSwitch : lanSwitchList) {
                        boolean isLicense = this.isLanSwitchLicensed(lanSwitch.getSwitchDbID());
                        if (!isLicense) continue;
                        boolean isPmCollect = lanSwitch.isPmCollect();
                        String state = "unchecked";
                        if (isPmCollect) {
                            state = "checked";
                        }
                        groupNavInXml.append("\n<groupMember isBranch=\"false\"  name=\"" + GenUtil.replaceStringForXML(lanSwitch.getName()) + "\" location=\"" + GenUtil.replaceStringForXML(lanSwitch.getLocation()) + "\"  " + "model=\"" + GenUtil.replaceStringForXML(lanSwitch.getModel()) + "\"  " + "icon=\"lanIcon\"  " + "ipAddress=\"" + lanSwitch.getIpAddress() + "\"  " + " state =\"" + state + "\" selectable= \"false" + "\" memDbId=\"" + lanSwitch.getSwitchDbID() + "\" type=\"" + 4 + "\" " + "/>");
                    }
                    groupNavInXml.append("</group>");
                    break;
                }
            }
        }
        return groupNavInXml.toString();
    }

    private boolean isLanSwitchLicensed(long lanSwitchId) {
        SwitchAssignedLicenseInfo sLicense = FileLicensingHelper.getInstance().getLanLicenseInfoSwitchAssignment(lanSwitchId);
        if (sLicense != null) {
            return sLicense.isLicensed();
        }
        return false;
    }

    private String getLanSwitchIdsByLanGroup(long lanGroupId) {
        List<SwitchDO> rstList = this.getLanSwitchesByLanGroup(lanGroupId);
        String rst = "";
        for (SwitchDO sw : rstList) {
            rst = rst + sw.getSwitchDbID() + ",";
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SwitchDO> getLanSwitchesByLanGroup(long lanGroupId) {
        ArrayList<SwitchDO> lanSwList;
        block14: {
            PreparedStatement stmt;
            Connection con;
            block13: {
                con = null;
                stmt = null;
                ResultSet rs = null;
                lanSwList = new ArrayList<SwitchDO>();
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement("select sys_name, sys_location, model_name, ip_address, ew.id, is_pm_collect from ethswitch ew,  nav_group_member ngm where ew.id = ngm.mem_dbid and ngm.group_id = ? order by sys_name");
                    stmt.setLong(1, lanGroupId);
                    rs = stmt.executeQuery();
                    SwitchDO swDo = null;
                    while (rs.next()) {
                        String swName = rs.getString(1);
                        String location = rs.getString(2);
                        String model = rs.getString(3);
                        byte[] ipByte = rs.getBytes(4);
                        long dbId = rs.getLong(5);
                        boolean isPmCollect = rs.getBoolean(6);
                        swDo = new SwitchDO();
                        swDo.setName(swName);
                        swDo.setLocation(location);
                        swDo.setModel(model);
                        swDo.setSwitchDbID(dbId);
                        swDo.setPmCollect(isPmCollect);
                        try {
                            swDo.setIpAddress(InetAddress.getByAddress(ipByte).getHostAddress());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        lanSwList.add(swDo);
                    }
                    if (rs == null) break block13;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block14;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con != null) {
                        DbUtil.close(con);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return lanSwList;
    }

    private void constructScopeNav(long groupId, StringBuffer groupNavInXml) throws Exception {
        ArrayList<NavBase> memList = this.getMemberList(groupId);
        for (NavBase base : memList) {
            switch (base.getNavType()) {
                case 2: {
                    groupNavInXml.append("<group isBranch=\"" + (this.hasMember(base.getMemDbId()) ? "true" : "false") + "\" " + " name=\"" + base.getName() + "\" state =\"unchecked" + "\" selectable= \"" + (groupId < 2L && base.getMemDbId() != 1L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" >\n");
                    this.constructScopeNav(base.getMemDbId(), groupNavInXml);
                    groupNavInXml.append("</group>");
                    break;
                }
                case 0: {
                    long fid = this.getMemIdByDbId(base.getMemDbId(), base.getNavType());
                    String svrIp = ClusterMapping.getInstance().qIPStrfromFID((int)fid);
                    groupNavInXml.append("<groupMember isBranch=\"false\"  name=\"" + base.getName() + "\" state =\"unchecked \"" + " icon=\"switchIcon\"  " + " serverIp=\"" + svrIp + "\" " + " memId= \"" + fid + "\" " + " selectable= \"" + (groupId < 0L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" />\n");
                    break;
                }
                case 1: {
                    long lanId = this.getMemIdByDbId(base.getMemDbId(), base.getNavType());
                    groupNavInXml.append("<group isBranch=\"false\"  name=\"" + base.getName() + "\" " + " state =\"unchecked \"" + " icon=\"lanIcon\"  " + " selectable= \"" + (groupId < 0L ? "true" : "false") + "\" memDbId=\"" + base.getMemDbId() + "\" type=\"" + base.getNavType() + "\" " + ">\n");
                    groupNavInXml.append("</group>");
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwitchDO getLanSwitchDetail(long memDbId) {
        SwitchDO swDo;
        PreparedStatement stmt;
        Connection con;
        block13: {
            con = null;
            stmt = null;
            ResultSet rs = null;
            swDo = new SwitchDO();
            try {
                con = ConnectionManager.getConnection();
                String sql = PersistentHelper.getHelper().getQueryString(" select eth.sys_name, eth.sys_location, eth.model_name, eth.ip_address, ngm.group_id  from ethswitch eth, nav_group_member ngm  where eth.id = ngm.mem_dbid and eth.is_fex=false and eth.id = ?");
                stmt = con.prepareStatement(sql);
                stmt.setLong(1, memDbId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    String swName = rs.getString(1);
                    String location = rs.getString(2);
                    String model = rs.getString(3);
                    byte[] ipByte = rs.getBytes(4);
                    long grpId = rs.getLong(5);
                    swDo.setLocation(location);
                    swDo.setModel(model);
                    swDo.setIpAddress(InetAddress.getByAddress(ipByte).getHostAddress());
                    if (swName == null || swName.trim().length() == 0) {
                        swName = swDo.getIpAddress();
                    }
                    swDo.setName(swName);
                    swDo.setLan(true);
                    swDo.setColDBId(grpId);
                }
                if (rs == null) break block13;
            }
            catch (Exception ex) {
                block14: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        return swDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupNameByLanSw(long swDbId) {
        String gName;
        block12: {
            PreparedStatement stmt;
            Connection con;
            block11: {
                con = null;
                stmt = null;
                ResultSet rs = null;
                gName = null;
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement("select ng.name from nav_group_member ngm, nav_groups ng  where ngm.group_id = ng.id and ngm.type = ? and ngm.mem_dbid = ?");
                    stmt.setInt(1, 4);
                    stmt.setLong(2, swDbId);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        gName = rs.getString(1);
                    }
                    if (rs == null) break block11;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block12;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con != null) {
                        DbUtil.close(con);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return gName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMemIdByDbId(long memDbId, int memType) {
        long memId;
        block12: {
            PreparedStatement stmt;
            Connection con;
            block11: {
                con = null;
                stmt = null;
                ResultSet rs = null;
                memId = -1L;
                String sql = memType == 0 ? "select fid from fabric where id=?" : "select lan_id from lan where id=?";
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, memDbId);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        memId = rs.getLong(1);
                    }
                    if (rs == null) break block11;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block12;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con != null) {
                        DbUtil.close(con);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return memId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateGroupInfo(String groupInXml) {
        PreparedStatement memStmt;
        PreparedStatement groupStmt;
        Connection con;
        int status;
        block17: {
            block18: {
                int n;
                block15: {
                    block16: {
                        status = 0;
                        if (groupInXml.length() < 1) {
                            return -1;
                        }
                        con = null;
                        groupStmt = null;
                        memStmt = null;
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder builder = factory.newDocumentBuilder();
                            InputSource is = new InputSource();
                            is.setCharacterStream(new StringReader(groupInXml));
                            Document dom = builder.parse(is);
                            Element root = dom.getDocumentElement();
                            NodeList groups = root.getChildNodes();
                            if (groups.getLength() < 1) {
                                n = -1;
                                if (groupStmt == null) break block15;
                                break block16;
                            }
                            con = ConnectionManager.getConnection();
                            for (int i = 0; i < groups.getLength(); ++i) {
                                Node group = groups.item(i);
                                if (!(group instanceof DeferredElementImpl)) continue;
                                String gDbIdStr = ((DeferredElementImpl)group).getAttribute("memDbId");
                                long gDbid = Long.parseLong(gDbIdStr == null || gDbIdStr.length() == 0 ? "-1" : gDbIdStr);
                                this.dbRemoveGroup(gDbid, con, true);
                                String gName = ((DeferredElementImpl)group).getAttribute("name");
                                String gType = ((DeferredElementImpl)group).getAttribute("type");
                                gDbid = this.getCurGroupIndex(con);
                                groupStmt = con.prepareStatement(_InsertGroupSQL);
                                groupStmt.setLong(1, gName.equals("Default_SAN") ? 1L : (gName.equals("Default_LAN") ? 2L : gDbid + 1L));
                                groupStmt.setString(2, gName);
                                groupStmt.setInt(3, Integer.parseInt(gType));
                                groupStmt.execute();
                                NodeList groupMembers = ((DeferredElementImpl)group).getChildNodes();
                                long groupMemId = this.getCurGroupMemberIndex(con);
                                for (int j = 0; j < groupMembers.getLength(); ++j) {
                                    Node member = groupMembers.item(j);
                                    if (!(member instanceof DeferredElementImpl)) continue;
                                    memStmt = con.prepareStatement(_InsertGroupMemberSQL);
                                    String memDbId = ((DeferredElementImpl)member).getAttribute("memDbId");
                                    String type = ((DeferredElementImpl)member).getAttribute("type");
                                    memStmt.setLong(1, ++groupMemId);
                                    memStmt.setLong(2, Long.parseLong(memDbId));
                                    memStmt.setString(3, ((DeferredElementImpl)member).getAttribute("name"));
                                    memStmt.setInt(4, Integer.parseInt(type));
                                    memStmt.setLong(5, gName.equals("Default_SAN") ? 1L : (gName.equals("Default_LAN") ? 2L : gDbid + 1L));
                                    memStmt.execute();
                                }
                            }
                            if (groupStmt == null) break block17;
                            break block18;
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                            status = -2;
                            return status;
                        }
                    }
                    DbUtil.close(groupStmt);
                }
                if (memStmt != null) {
                    DbUtil.close(memStmt);
                }
                if (con == null) return n;
                DbUtil.close(con);
                return n;
            }
            DbUtil.close(groupStmt);
        }
        if (memStmt != null) {
            DbUtil.close(memStmt);
        }
        if (con == null) return status;
        DbUtil.close(con);
        return status;
        finally {
            if (groupStmt != null) {
                DbUtil.close(groupStmt);
            }
            if (memStmt != null) {
                DbUtil.close(memStmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
    }

    public String getFabricIdsInGroup(String groupInXml) {
        String rst = this.getEntitiesInGroup(groupInXml, 0);
        return rst.length() < 1 ? "" : " AND fabric.id in (" + rst + ") ";
    }

    public String getLanIdsInGroup(String groupInXml) {
        String rst = this.getEntitiesInGroup(groupInXml, 1);
        return rst.length() < 1 ? "" : " AND ethswitch.id in (" + rst + ") ";
    }

    public NavBase getNavSelection(String groupInXml) {
        NavBase sel = null;
        if (groupInXml == null || groupInXml.length() < 1) {
            return sel;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(groupInXml));
            Document dom = builder.parse(is);
            Element root = dom.getDocumentElement();
            String name = ((DeferredElementImpl)root).getAttribute("name");
            if (name == null || name.length() < 1) {
                root = (Element)root.getFirstChild();
            }
            name = ((DeferredElementImpl)root).getAttribute("name");
            String mDbid = ((DeferredElementImpl)root).getAttribute("memDbId");
            String type = ((DeferredElementImpl)root).getAttribute("type");
            sel = type.trim().length() < 1 ? null : new NavBase(Long.parseLong(mDbid), name, Integer.parseInt(type));
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return sel;
    }

    public String getEntitiesInGroup(String groupInXml, int entityType) {
        String rst = "";
        if (groupInXml == null || groupInXml.length() < 1) {
            return rst;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(groupInXml));
            Document dom = builder.parse(is);
            Element root = dom.getDocumentElement();
            rst = this.getChildren(entityType, rst, root);
            if (rst.length() < 1) {
                rst = "-1,";
            }
            rst = rst.substring(0, rst.length() - 1);
            return rst;
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return rst;
        }
    }

    private String getChildren(int entityType, String rst, Object root) {
        NodeList members;
        if (root instanceof DeferredElementImpl) {
            String type = ((DeferredElementImpl)root).getAttribute("type");
            String name = ((DeferredElementImpl)root).getAttribute("name");
            if (type != null && type.length() > 0) {
                if (0 == Integer.parseInt(type)) {
                    String memDbId = ((DeferredElementImpl)root).getAttribute("memDbId");
                    rst = rst + memDbId + ",";
                    return rst;
                }
                if (name.equalsIgnoreCase("Default_LAN") || 1 == Integer.parseInt(type)) {
                    String grpId = ((DeferredElementImpl)root).getAttribute("memDbId");
                    if (entityType != 0) {
                        rst = rst + this.getLanSwitchIdsByLanGroup(Long.parseLong(grpId));
                    }
                    return rst;
                }
            }
        }
        if ((members = ((Element)root).getChildNodes()).getLength() < 1) {
            return rst;
        }
        for (int i = 0; i < members.getLength(); ++i) {
            Node member = members.item(i);
            if (!(member instanceof DeferredElementImpl)) continue;
            String type = ((DeferredElementImpl)member).getAttribute("type");
            String name = ((DeferredElementImpl)member).getAttribute("name");
            if (Integer.parseInt(type) == 1) {
                String grpId = ((DeferredElementImpl)member).getAttribute("memDbId");
                if (entityType == 0) continue;
                rst = rst + this.getLanSwitchIdsByLanGroup(Long.parseLong(grpId));
                continue;
            }
            if (Integer.parseInt(type) == 2) {
                rst = rst + this.getChildren(entityType, "", member);
                continue;
            }
            if (entityType != Integer.parseInt(type)) continue;
            String memDbId = ((DeferredElementImpl)member).getAttribute("memDbId");
            rst = rst + memDbId + ",";
        }
        return rst;
    }

    public int getCountEntitiesInGroup(String groupInXml, int entityType) {
        String rst = "";
        if (groupInXml == null || groupInXml.length() < 1) {
            return 0;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(groupInXml));
            Document dom = builder.parse(is);
            Element root = dom.getDocumentElement();
            return this.countChildren(entityType, rst, root);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            return 0;
        }
    }

    private int countChildren(int entityType, String rst, Object root) {
        NodeList members = ((Element)root).getChildNodes();
        int count = 0;
        if (members.getLength() < 1) {
            return 0;
        }
        for (int i = 0; i < members.getLength(); ++i) {
            Node member = members.item(i);
            if (!(member instanceof DeferredElementImpl)) continue;
            String type = ((DeferredElementImpl)member).getAttribute("type");
            if (entityType == Integer.parseInt(type)) {
                ++count;
                continue;
            }
            if (Integer.parseInt(type) != 2) continue;
            count += this.countChildren(entityType, rst, member);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createNewGroup(String groupInXml) {
        PreparedStatement memStmt;
        PreparedStatement groupStmt;
        Connection con;
        int status;
        block17: {
            block18: {
                int n;
                block15: {
                    block16: {
                        status = 0;
                        if (groupInXml.length() < 1) {
                            return -1;
                        }
                        con = null;
                        groupStmt = null;
                        memStmt = null;
                        try {
                            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                            DocumentBuilder builder = factory.newDocumentBuilder();
                            InputSource is = new InputSource();
                            is.setCharacterStream(new StringReader(groupInXml));
                            Document dom = builder.parse(is);
                            Element rootElement = dom.getDocumentElement();
                            NodeList groups = rootElement.getChildNodes();
                            if (groups.getLength() < 3) {
                                n = -1;
                                if (groupStmt == null) break block15;
                                break block16;
                            }
                            con = ConnectionManager.getConnection();
                            for (int i = 0; i < groups.getLength(); ++i) {
                                Node group = groups.item(i);
                                if (!(group instanceof ElementNode)) continue;
                                groupStmt = con.prepareStatement(_InsertGroupSQL);
                                groupStmt.setLong(1, i + 1);
                                groupStmt.setString(2, ((ElementNode)group).getAttribute("label"));
                                groupStmt.setInt(3, 2);
                                NodeList groupMembers = ((ElementNode)group).getChildNodes();
                                for (int j = 0; j < groupMembers.getLength(); ++j) {
                                    Node member = groupMembers.item(j);
                                    if (!(member instanceof ElementNode)) continue;
                                    memStmt = con.prepareStatement(_InsertGroupMemberSQL);
                                    String dbId = ((ElementNode)member).getAttribute("dbid");
                                    String type = ((ElementNode)member).getAttribute("type");
                                    long gdbId = i + 1;
                                    memStmt.setLong(1, j + 1);
                                    memStmt.setLong(2, Long.parseLong(dbId));
                                    memStmt.setString(3, ((ElementNode)member).getAttribute("label"));
                                    memStmt.setInt(4, Integer.parseInt(type));
                                    memStmt.setLong(5, gdbId);
                                }
                            }
                            if (groupStmt == null) break block17;
                            break block18;
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                            status = -2;
                            return status;
                        }
                    }
                    DbUtil.close(groupStmt);
                }
                if (memStmt != null) {
                    DbUtil.close(memStmt);
                }
                if (con == null) return n;
                DbUtil.close(con);
                return n;
            }
            DbUtil.close(groupStmt);
        }
        if (memStmt != null) {
            DbUtil.close(memStmt);
        }
        if (con == null) return status;
        DbUtil.close(con);
        return status;
        finally {
            if (groupStmt != null) {
                DbUtil.close(groupStmt);
            }
            if (memStmt != null) {
                DbUtil.close(memStmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
    }

    private ArrayList<NavBase> getMemberList(long groupId) {
        return this.getMemberList(groupId, false);
    }

    public boolean isEmptyLanGroup(long lanGrpId) {
        ArrayList<NavBase> theList = this.getMemberList(lanGrpId, false);
        for (int i = 0; i < theList.size(); ++i) {
            NavBase nv = theList.get(i);
            if (nv.getNavType() != 4) continue;
            return false;
        }
        return true;
    }

    private ArrayList<NavBase> getMemberList(long groupId, boolean lanOnly) {
        return this.getMemberList(groupId, lanOnly, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<NavBase> getMemberList(long groupId, boolean lanOnly, boolean sanOnly) {
        PreparedStatement stmt;
        Connection con;
        ArrayList<NavBase> all;
        block20: {
            all = new ArrayList<NavBase>();
            con = null;
            stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                String sql = _GetGroupMemSQL;
                if (groupId < 0L) {
                    sql = "select id, name, type  from nav_groups where id != 1 and id != 2 and id not in ( select mem_dbid from nav_group_member where type = 2   or type=1)";
                    if (lanOnly) {
                        sql = sql + " and (id not in (select ngm.group_id from nav_group_member ngm where ngm.type=0))";
                    }
                    stmt = con.prepareStatement(sql + " order by name");
                } else if (lanOnly) {
                    sql = _GetLanGroupMemSQL;
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, groupId);
                    stmt.setLong(2, groupId);
                } else {
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, groupId);
                }
                rs = stmt.executeQuery();
                while (rs.next()) {
                    long dbId = rs.getLong(1);
                    String name = rs.getString(2);
                    int type = rs.getInt(3);
                    all.add(new NavBase(dbId, name, type));
                }
                if (groupId < 0L) {
                    if (!sanOnly) {
                        all.add(new NavBase(2L, "Default_LAN", 1));
                    }
                    if (!lanOnly) {
                        all.add(new NavBase(1L, "Default_SAN", 2));
                    }
                }
                if (rs == null) break block20;
            }
            catch (Exception ex) {
                block21: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        if (rs == null) break block21;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SwitchDO> getSwitchList(long fdbId) {
        ArrayList<SwitchDO> all;
        block15: {
            PreparedStatement stmt;
            Connection con;
            block14: {
                all = new ArrayList<SwitchDO>();
                con = null;
                stmt = null;
                ResultSet rs = null;
                try {
                    con = ConnectionManager.getConnection();
                    String sql = _GetSwitchSQL;
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, fdbId);
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        try {
                            String swName = rs.getString(1);
                            String location = rs.getString(2);
                            String model = rs.getString(3);
                            byte[] ipByte = rs.getBytes(4);
                            long swId = rs.getLong(5);
                            SwitchDO swDo = new SwitchDO();
                            swDo.setLocation(location);
                            swDo.setModel(model);
                            swDo.setIpAddress(InetAddress.getByAddress(ipByte).getHostAddress());
                            if (swName == null || swName.trim().length() == 0) {
                                swName = swDo.getIpAddress();
                            }
                            swDo.setName(swName);
                            swDo.setSwitchDbID(swId);
                            swDo.setColDBId(fdbId);
                            swDo.setLan(false);
                            all.add(swDo);
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    if (rs == null) break block14;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block15;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con != null) {
                        DbUtil.close(con);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int moveGroupMember(long[] memDbidArr, long newParentDbId) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int status;
        block15: {
            block16: {
                int n;
                block13: {
                    block14: {
                        status = 0;
                        con = null;
                        stmt = null;
                        rs = null;
                        try {
                            con = ConnectionManager.getConnection();
                            for (long memDbid : memDbidArr) {
                                int rst;
                                stmt = con.prepareStatement("select count(*) from nav_group_member ngm where ngm.mem_dbid = ?");
                                stmt.setLong(1, memDbid);
                                rs = stmt.executeQuery();
                                if (rs.next() && (rst = rs.getInt(1)) < 1) {
                                    n = -1;
                                    if (rs == null) break block13;
                                    break block14;
                                }
                                DbUtil.close(stmt);
                                DbUtil.close(rs);
                                stmt = con.prepareStatement(_UpdateGroupMemberSQL);
                                stmt.setLong(1, newParentDbId);
                                stmt.setLong(2, memDbid);
                                stmt.execute();
                                this.setDirtyFlagForGroupCache();
                                DbUtil.close(stmt);
                            }
                            if (rs == null) break block15;
                            break block16;
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                            status = -1;
                            return status;
                        }
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return n;
                DbUtil.close(con);
                return n;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return status;
        DbUtil.close(con);
        return status;
        finally {
            if (rs != null) {
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
    }

    private void setDirtyFlagForGroupCache() {
        for (ServerReference sev : WebReferenceManager.getInstance().getReferences()) {
            try {
                sev.getServerMgr().setDirtyFlagForGCache();
            }
            catch (RemoteException e) {
                _Logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addGroupMember(long memDbid, String memName, int type) {
        this.addGroupMember(memDbid, memName, type, -1L, 1L);
    }

    public void addGroupMember(long memDbid, String memName, int type, long groupId) {
        this.addGroupMember(memDbid, memName, type, -1L, groupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void addGroupMember(long memDbid, String memName, int type, long dbId, long groupId) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block21: {
            block22: {
                block19: {
                    block20: {
                        block17: {
                            block18: {
                                con = null;
                                stmt = null;
                                rs = null;
                                if (memDbid == 0L) {
                                    return;
                                }
                                try {
                                    con = ConnectionManager.getConnection();
                                    stmt = con.prepareStatement("select mem_name from nav_group_member ngm where ngm.mem_dbid = ?");
                                    stmt.setLong(1, memDbid);
                                    rs = stmt.executeQuery();
                                    if (rs.next()) {
                                        String curName = rs.getString(1);
                                        if (curName.equalsIgnoreCase(memName)) {
                                            if (rs == null) break block17;
                                            break block18;
                                        }
                                        DbUtil.close(stmt);
                                        stmt = con.prepareStatement(_UpdateGroupMemberNameSQL);
                                        stmt.setString(1, memName);
                                        stmt.setLong(2, memDbid);
                                        stmt.execute();
                                        this.setDirtyFlagForGroupCache();
                                        if (rs == null) break block19;
                                        break block20;
                                    }
                                    if (dbId < 0L) {
                                        dbId = this.getCurGroupMemberIndex(con);
                                    }
                                    DbUtil.close(stmt);
                                    stmt = con.prepareStatement(_InsertGroupMemberSQL);
                                    stmt.setLong(1, dbId + 1L);
                                    stmt.setLong(2, memDbid);
                                    stmt.setString(3, memName);
                                    stmt.setInt(4, type);
                                    stmt.setLong(5, groupId);
                                    stmt.execute();
                                    if (rs == null) break block21;
                                    break block22;
                                }
                                catch (Exception ex) {
                                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                                    return;
                                }
                            }
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con == null) return;
                        DbUtil.close(con);
                        return;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return;
                DbUtil.close(con);
                return;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return;
        DbUtil.close(con);
        return;
        finally {
            if (rs != null) {
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long addGroup(long parentGroupId, String groupName) {
        long groupMemId;
        PreparedStatement stmt;
        Connection con;
        block16: {
            ResultSet rs;
            block14: {
                long l;
                block15: {
                    block12: {
                        long l2;
                        block13: {
                            int rst;
                            con = null;
                            stmt = null;
                            rs = null;
                            groupMemId = -1L;
                            con = ConnectionManager.getConnection();
                            if (parentGroupId <= 0L) break block12;
                            stmt = con.prepareStatement("select count(*) from nav_groups ng where ng.id = ?");
                            stmt.setLong(1, parentGroupId);
                            rs = stmt.executeQuery();
                            if (!rs.next() || (rst = rs.getInt(1)) >= 1) break block12;
                            l2 = groupMemId;
                            if (rs == null) break block13;
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con == null) return l2;
                        DbUtil.close(con);
                        return l2;
                    }
                    long curGroupId = this.getCurGroupIndex(con);
                    groupMemId = curGroupId + 1L;
                    DbUtil.close(stmt);
                    stmt = con.prepareStatement(_InsertGroupSQL);
                    stmt.setLong(1, groupMemId);
                    stmt.setString(2, groupName);
                    stmt.setInt(3, 2);
                    stmt.execute();
                    if (parentGroupId >= 0L) break block14;
                    l = groupMemId;
                    if (rs == null) break block15;
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return l;
                DbUtil.close(con);
                return l;
            }
            try {
                long curGroupMemberId = this.getCurGroupMemberIndex(con);
                DbUtil.close(stmt);
                stmt = con.prepareStatement(_InsertGroupMemberSQL);
                stmt.setLong(1, curGroupMemberId + 1L);
                stmt.setLong(2, groupMemId);
                stmt.setString(3, groupName);
                stmt.setInt(4, 2);
                stmt.setLong(5, parentGroupId);
                stmt.execute();
                if (rs == null) break block16;
            }
            catch (Exception ex) {
                block17: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        groupMemId = -1L;
                        if (rs == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con == null) throw throwable;
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return groupMemId;
                DbUtil.close(con);
                return groupMemId;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return groupMemId;
        DbUtil.close(con);
        return groupMemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurGroupMemberIndex(Connection con) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        long curIndex;
        block4: {
            curIndex = 0L;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("select id from nav_group_member where id=(select max(id) from nav_group_member)");
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                curIndex = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return curIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurGroupIndex(Connection con) throws Exception {
        ResultSet rs;
        PreparedStatement stmt;
        long curIndex;
        block4: {
            curIndex = 0L;
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareStatement("select id from nav_groups where id=(select max(id) from nav_groups)");
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                curIndex = rs.getInt(1);
            }
            catch (Exception ex) {
                try {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    DbUtil.close(rs);
                    DbUtil.close(stmt);
                    throw throwable;
                }
                DbUtil.close(rs);
                DbUtil.close(stmt);
            }
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        return curIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeEmptyGroup(long gDbId) {
        PreparedStatement stmt;
        Connection con;
        int status;
        block14: {
            int rst = 0;
            status = 0;
            con = null;
            stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("select count(*) from nav_group_member navGm where navGm.group_id = ?");
                stmt.setLong(1, gDbId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    rst = rs.getInt(1);
                    if (rst > 0) {
                        status = -1;
                    } else {
                        status = 0;
                        DbUtil.close(stmt);
                        stmt = con.prepareStatement(_RemoveGroupSQL);
                        stmt.setLong(1, gDbId);
                        stmt.execute();
                    }
                }
                if (rs == null) break block14;
            }
            catch (Exception ex) {
                block15: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        status = -2;
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeGroupAndMem(String[] dbidStrArr, String defGroupXml, String defLanGroupXml) {
        int rst = 0;
        Connection con = null;
        try {
            con = ConnectionManager.getConnection();
            for (String memDbIdStr : dbidStrArr) {
                long memDbId = Long.parseLong(memDbIdStr.split(":")[0]);
                int type = Integer.parseInt(memDbIdStr.split(":")[1]);
                if ((type == 2 || type == 1) && (rst = this.dbRemoveGroup(memDbId, con)) < 0) {
                    int n = rst;
                    return n;
                }
                this.removeGroupMember(memDbId);
            }
            rst = this.updateGroupInfo(defGroupXml);
            rst = this.updateGroupInfo(defLanGroupXml);
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            int n = -1;
            return n;
        }
        finally {
            if (con != null) {
                DbUtil.close(con);
            }
        }
        return rst;
    }

    private int dbRemoveGroup(long gDbid, Connection con) {
        return this.dbRemoveGroup(gDbid, con, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int dbRemoveGroup(long gDbid, Connection con, boolean removeDefaultGroup) {
        if (!removeDefaultGroup && gDbid < 2L) {
            return -1;
        }
        PreparedStatement stmt = null;
        int rst = 0;
        try {
            stmt = con.prepareStatement(_RemoveGroupMemberSQL);
            stmt.setLong(1, gDbid);
            stmt.execute();
            this.setDirtyFlagForGroupCache();
            DbUtil.close(stmt);
            stmt = con.prepareStatement(_RemoveGroupSQL);
            stmt.setLong(1, gDbid);
            stmt.execute();
            this.setDirtyFlagForGroupCache();
        }
        catch (Exception ex) {
            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
            rst = -1;
        }
        finally {
            if (stmt != null) {
                DbUtil.close(stmt);
            }
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupMember(long memDbid) {
        block13: {
            PreparedStatement stmt;
            Connection con;
            block12: {
                con = null;
                stmt = null;
                ResultSet rs = null;
                long group_id = -1L;
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement("select group_id from nav_group_member where mem_dbid=?");
                    stmt.setLong(1, memDbid);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        group_id = rs.getLong(1);
                    }
                    DbUtil.close(stmt);
                    stmt = con.prepareStatement("delete from nav_group_member where mem_dbid = ?");
                    stmt.setLong(1, memDbid);
                    stmt.execute();
                    if (group_id > 2L) {
                        this.resetGroupType(group_id);
                    }
                    if (rs == null) break block12;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    break block13;
                }
                finally {
                    if (rs != null) {
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con != null) {
                        DbUtil.close(con);
                    }
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resetGroupType(long groupId) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block14: {
            block15: {
                block12: {
                    block13: {
                        con = null;
                        stmt = null;
                        rs = null;
                        try {
                            int cnt;
                            con = ConnectionManager.getConnection();
                            stmt = con.prepareStatement("select count(*) from nav_group_member where group_id = ?");
                            stmt.setLong(1, groupId);
                            rs = stmt.executeQuery();
                            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                                if (rs == null) break block12;
                                break block13;
                            }
                            DbUtil.close(stmt);
                            stmt = con.prepareStatement("update nav_groups set type= 2where id =?");
                            stmt.setLong(1, groupId);
                            stmt.execute();
                            DbUtil.close(stmt);
                            stmt = con.prepareStatement("update nav_group_member set type= 2where mem_dbid =?");
                            stmt.setLong(1, groupId);
                            stmt.execute();
                            if (rs == null) break block14;
                            break block15;
                        }
                        catch (Exception ex) {
                            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                            return;
                        }
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return;
                DbUtil.close(con);
                return;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return;
        DbUtil.close(con);
        return;
        finally {
            if (rs != null) {
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con != null) {
                DbUtil.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int modifyGroupType(long groupId, int type) {
        PreparedStatement stmt;
        Connection con;
        int status;
        block13: {
            ResultSet rs;
            block11: {
                int n;
                block12: {
                    status = 0;
                    con = null;
                    stmt = null;
                    rs = null;
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement("select type from nav_groups where id = ? ");
                    stmt.setLong(1, groupId);
                    rs = stmt.executeQuery();
                    int curType = -1;
                    if (rs.next()) {
                        curType = rs.getInt(1);
                    }
                    if (curType != type) break block11;
                    n = status;
                    if (rs == null) break block12;
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return n;
                DbUtil.close(con);
                return n;
            }
            try {
                DbUtil.close(stmt);
                stmt = con.prepareStatement("update nav_groups set type= " + type + "where id =?");
                stmt.setLong(1, groupId);
                stmt.execute();
                DbUtil.close(stmt);
                stmt = con.prepareStatement("update nav_group_member set type= " + type + " where mem_dbid =?");
                stmt.setLong(1, groupId);
                stmt.execute();
                if (rs == null) break block13;
            }
            catch (Exception ex) {
                block14: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        status = -2;
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con == null) throw throwable;
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return status;
                DbUtil.close(con);
                return status;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return status;
        DbUtil.close(con);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int modifyGroupName(long groupId, String newGroupName) {
        PreparedStatement stmt;
        Connection con;
        int status;
        block12: {
            ResultSet rs;
            block10: {
                int n;
                block11: {
                    int rst;
                    status = 0;
                    con = null;
                    stmt = null;
                    rs = null;
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement("select count(*) from nav_groups navG where navG.id = ?");
                    stmt.setLong(1, groupId);
                    rs = stmt.executeQuery();
                    if (!rs.next() || (rst = rs.getInt(1)) != 0) break block10;
                    n = status = -1;
                    if (rs == null) break block11;
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return n;
                DbUtil.close(con);
                return n;
            }
            try {
                DbUtil.close(stmt);
                stmt = con.prepareStatement("update nav_groups set name='" + newGroupName + "' where id =?");
                stmt.setLong(1, groupId);
                stmt.execute();
                DbUtil.close(stmt);
                stmt = con.prepareStatement("update nav_group_member set mem_name='" + newGroupName + "' " + "where mem_dbid =? and (type = " + 2 + " or type = " + 1 + ")");
                stmt.setLong(1, groupId);
                stmt.execute();
                if (rs == null) break block12;
            }
            catch (Exception ex) {
                block13: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        status = -2;
                        if (rs == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con == null) throw throwable;
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con == null) return status;
                DbUtil.close(con);
                return status;
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return status;
        DbUtil.close(con);
        return status;
    }

    public static void main(String[] args) {
        try {
            GenUtil.loadServerProperties(_Logger);
            String ss1 = NavigationUtil.getInstance().getGroupsNav();
            System.out.println("GroupsNav is: \n" + ss1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Long> getAllMemIds(long groupId, int type) {
        ArrayList<Long> tmp;
        block6: {
            tmp = new ArrayList<Long>();
            String QUERY_GROUP_ID = "SELECT MEM_DBID FROM NAV_GROUP_MEMBER WHERE GROUP_ID=? and type=?";
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                conn = ConnectionManager.getConnection();
                stmt = conn.prepareStatement("SELECT MEM_DBID FROM NAV_GROUP_MEMBER WHERE GROUP_ID=? and type=?");
                stmt.setLong(1, groupId);
                stmt.setInt(2, type);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    tmp.add(rs.getLong(1));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage());
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllMemIdName(long groupId, int type) {
        ArrayList<String> rst;
        block6: {
            rst = new ArrayList<String>();
            String QUERY_GROUP_ID = "SELECT MEM_DBID,MEM_NAME FROM NAV_GROUP_MEMBER WHERE GROUP_ID=? and type=?";
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                conn = ConnectionManager.getConnection();
                stmt = conn.prepareStatement("SELECT MEM_DBID,MEM_NAME FROM NAV_GROUP_MEMBER WHERE GROUP_ID=? and type=?");
                stmt.setLong(1, groupId);
                stmt.setInt(2, type);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    rst.add(rs.getLong(1) + ":" + rs.getString(2));
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage());
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMember(long groupId) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block7: {
            boolean bl;
            block6: {
                String QUERY_GROUP_ID = "SELECT MEM_DBID FROM NAV_GROUP_MEMBER WHERE GROUP_ID=? ";
                conn = null;
                stmt = null;
                rs = null;
                try {
                    conn = ConnectionManager.getConnection();
                    stmt = conn.prepareStatement("SELECT MEM_DBID FROM NAV_GROUP_MEMBER WHERE GROUP_ID=? ");
                    stmt.setLong(1, groupId);
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        bl = true;
                        DbUtil.close(rs);
                        break block6;
                    }
                    DbUtil.close(rs);
                    break block7;
                }
                catch (Exception ex) {
                    _Logger.warn((Object)ex.getMessage());
                    return false;
                }
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
            return bl;
        }
        DbUtil.close(stmt);
        DbUtil.close(conn);
        return false;
        finally {
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
    }

    public ArrayList<Long> getAllNavGroupIds(long gid) {
        ArrayList<Long> gids = new ArrayList<Long>();
        LinkedList<Long> ggids = new LinkedList<Long>();
        ggids.add(gid);
        ArrayList<Long> tmp = null;
        while (!ggids.isEmpty()) {
            long id = (Long)ggids.poll();
            gids.add(id);
            tmp = this.getAllMemIds(id, 2);
            ggids.addAll(tmp);
            tmp = this.getAllMemIds(id, 1);
            ggids.addAll(tmp);
        }
        return gids;
    }

    public ArrayList<String> getFabricIdsInGroup(long gid) {
        ArrayList<Long> gids = new ArrayList<Long>();
        ArrayList<String> rst = new ArrayList<String>();
        LinkedList<Long> ggids = new LinkedList<Long>();
        ggids.add(gid);
        ArrayList<String> inteRst = null;
        ArrayList<Long> rstIds = null;
        while (!ggids.isEmpty()) {
            long id = (Long)ggids.poll();
            gids.add(id);
            rstIds = this.getAllMemIds(id, 2);
            ggids.addAll(rstIds);
            inteRst = this.getAllMemIdName(id, 0);
            rst.addAll(inteRst);
        }
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isLANDomain(long groupMemberId) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        int status;
        block20: {
            int n;
            block27: {
                block23: {
                    int n2;
                    block26: {
                        block24: {
                            int n3;
                            block25: {
                                int rst;
                                block21: {
                                    int n4;
                                    block22: {
                                        block18: {
                                            int n5;
                                            block19: {
                                                status = 0;
                                                con = null;
                                                stmt = null;
                                                rs = null;
                                                con = ConnectionManager.getConnection();
                                                stmt = con.prepareStatement("select count(*) from nav_group_member navGm where navGm.group_id = ?");
                                                stmt.setLong(1, groupMemberId);
                                                rs = stmt.executeQuery();
                                                if (!rs.next() || (rst = rs.getInt(1)) != 0) break block18;
                                                n5 = status = 0;
                                                if (rs == null) break block19;
                                                DbUtil.close(rs);
                                            }
                                            if (stmt != null) {
                                                DbUtil.close(stmt);
                                            }
                                            if (con == null) return n5;
                                            DbUtil.close(con);
                                            return n5;
                                        }
                                        DbUtil.close(stmt);
                                        stmt = con.prepareStatement(_GetGroupTypeSQL);
                                        stmt.setLong(1, groupMemberId);
                                        rs = stmt.executeQuery();
                                        if (!rs.next()) break block20;
                                        rst = rs.getInt(1);
                                        if (rst != 1) break block21;
                                        n4 = status = 0;
                                        if (rs == null) break block22;
                                        DbUtil.close(rs);
                                    }
                                    if (stmt != null) {
                                        DbUtil.close(stmt);
                                    }
                                    if (con == null) return n4;
                                    DbUtil.close(con);
                                    return n4;
                                }
                                if (rst != 2) break block23;
                                if (!this.hasMember(groupMemberId)) break block24;
                                n3 = status = -3;
                                if (rs == null) break block25;
                                DbUtil.close(rs);
                            }
                            if (stmt != null) {
                                DbUtil.close(stmt);
                            }
                            if (con == null) return n3;
                            DbUtil.close(con);
                            return n3;
                        }
                        n2 = status = 0;
                        if (rs == null) break block26;
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con == null) return n2;
                    DbUtil.close(con);
                    return n2;
                }
                try {
                    n = status = -3;
                    if (rs == null) break block27;
                }
                catch (Exception ex) {
                    block28: {
                        try {
                            _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                            status = -2;
                            if (rs == null) break block28;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                DbUtil.close(rs);
                            }
                            if (stmt != null) {
                                DbUtil.close(stmt);
                            }
                            if (con == null) throw throwable;
                            DbUtil.close(con);
                            throw throwable;
                        }
                        DbUtil.close(rs);
                    }
                    if (stmt != null) {
                        DbUtil.close(stmt);
                    }
                    if (con == null) return status;
                    DbUtil.close(con);
                    return status;
                }
                DbUtil.close(rs);
            }
            if (stmt != null) {
                DbUtil.close(stmt);
            }
            if (con == null) return n;
            DbUtil.close(con);
            return n;
        }
        if (rs != null) {
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con == null) return status;
        DbUtil.close(con);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long isLANDomainCandidate(String groupName) {
        PreparedStatement stmt;
        Connection con;
        long status;
        block13: {
            status = 0L;
            con = null;
            stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("select id, type from nav_groups where name = ?");
                stmt.setString(1, groupName);
                rs = stmt.executeQuery();
                int type = -1;
                if (rs.next()) {
                    type = rs.getInt(2);
                    long groupId = rs.getLong(1);
                    long l = status = type == 1 ? groupId : -2L;
                }
                if (type == -1) {
                    status = 0L;
                }
                if (rs == null) break block13;
            }
            catch (Exception ex) {
                block14: {
                    try {
                        _Logger.warn((Object)ex.getMessage(), (Throwable)ex);
                        status = -2L;
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int modifyFabricName(long fabricDBId, String newFabricName) {
        PreparedStatement stmt;
        Connection con;
        int status;
        block11: {
            status = 0;
            con = null;
            stmt = null;
            ResultSet rs = null;
            try {
                con = ConnectionManager.getConnection();
                stmt = con.prepareStatement("update nav_group_member set mem_name='" + newFabricName + "' " + "where mem_dbid =? and (type = " + 0 + " )");
                stmt.setLong(1, fabricDBId);
                stmt.execute();
                if (rs == null) break block11;
            }
            catch (Exception ex) {
                block12: {
                    try {
                        _Logger.warn((Object)("NavigationUtil.modifyFabricName fabricDBId=" + fabricDBId + " to " + newFabricName + ", error: " + ex.getMessage()), (Throwable)ex);
                        status = -2;
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            DbUtil.close(rs);
                        }
                        if (stmt != null) {
                            DbUtil.close(stmt);
                        }
                        if (con != null) {
                            DbUtil.close(con);
                        }
                        throw throwable;
                    }
                    DbUtil.close(rs);
                }
                if (stmt != null) {
                    DbUtil.close(stmt);
                }
                if (con != null) {
                    DbUtil.close(con);
                }
            }
            DbUtil.close(rs);
        }
        if (stmt != null) {
            DbUtil.close(stmt);
        }
        if (con != null) {
            DbUtil.close(con);
        }
        return status;
    }

    public static ArrayList getAllFabricsInGroup(long grpId) throws SQLException, Exception {
        ArrayList gnGm = NavigationUtil.getInstance().buildGrpIdLists();
        if (gnGm != null && gnGm.size() > 0) {
            return NavigationUtil.getAllFabricsInGroup(grpId, (NavGroupMember)gnGm.get(0));
        }
        return null;
    }

    public static ArrayList getAllLanSwitchesInNavGroup(long grpId) throws SQLException, Exception {
        ArrayList gnGm = NavigationUtil.getInstance().buildGrpIdLists();
        if (gnGm != null && gnGm.size() > 0) {
            return NavigationUtil.getAllFabricsInGroup(grpId, (NavGroupMember)gnGm.get(0));
        }
        return null;
    }

    public static ArrayList getAllFabricsInGroup(long grpId, NavGroupMember topGrp) {
        ArrayList fabLst = new ArrayList();
        NavGroupMember nm = NavigationUtil.findNaveGroup(topGrp, grpId);
        if (nm != null) {
            NavigationUtil.getFabricsInGroup(nm, fabLst, 0);
        }
        return fabLst;
    }

    public static ArrayList getAllLanSwitchesInNavGroup(long grpId, NavGroupMember topGrp) {
        ArrayList fabLst = new ArrayList();
        NavGroupMember nm = NavigationUtil.findNaveGroup(topGrp, grpId);
        if (nm != null) {
            NavigationUtil.getFabricsInGroup(nm, fabLst, 4);
        }
        return fabLst;
    }

    public static void getFabricsInGroup(NavGroupMember topGrp, ArrayList fabLst, int type) {
        if (topGrp != null && topGrp.children != null && topGrp.children.size() > 0) {
            for (int i = 0; i < topGrp.children.size(); ++i) {
                NavGroupMember chm = topGrp.children.get(i);
                if (chm.type == type) {
                    fabLst.add(chm);
                    continue;
                }
                NavigationUtil.getFabricsInGroup(chm, fabLst, type);
            }
        }
    }

    public static NavGroupMember findNaveGroup(NavGroupMember topGrp, long grpId) {
        NavGroupMember curGrp = topGrp;
        Object foundGrp = null;
        if (curGrp.mem_dbid != grpId) {
            int i = 0;
            while (curGrp.children != null && curGrp.children.size() > 0 && i < curGrp.children.size()) {
                while (i < curGrp.children.size()) {
                    NavGroupMember chm = curGrp.children.get(i);
                    NavGroupMember nvmem = NavigationUtil.findNaveGroup(chm, grpId);
                    if (nvmem != null) {
                        return nvmem;
                    }
                    ++i;
                }
            }
            return null;
        }
        return curGrp;
    }

    public ArrayList buildGrpIdLists() throws SQLException, Exception {
        ArrayList<NavGroupMember> topNodes = new ArrayList<NavGroupMember>();
        ArrayList<NavGroupMember> navmems = new ArrayList<NavGroupMember>();
        NavGroupMember dcmg = new NavGroupMember();
        dcmg.id = -1L;
        dcmg.mem_dbid = -1L;
        dcmg.mem_name = "Data Center";
        topNodes.add(dcmg);
        Connection con = null;
        Object sql = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = ConnectionManager.getConnection();
            String dbDriver = ConnectionManager.getDbDriver();
            boolean isOracle = false;
            if (dbDriver.startsWith("oracle.")) {
                isOracle = true;
            }
            stmt = con.prepareStatement(isOracle ? ORCL_NAV_GROUP_MEM_SQL : PG_NAV_GROUP_MEM_SQL);
            rs = SQLLoader.execute((PreparedStatement)stmt);
            while (rs.next()) {
                NavGroupMember nvm = new NavGroupMember();
                nvm.id = rs.getLong(1);
                nvm.mem_dbid = rs.getLong(2);
                nvm.mem_name = rs.getString(3);
                nvm.type = rs.getInt(4);
                nvm.group_id = rs.getLong(5);
                navmems.add(nvm);
            }
            Collections.sort(navmems);
            this.buildTreeStructure(navmems, topNodes);
        }
        catch (SQLException ex) {
            _Logger.error((Object)ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            ConnectionManager.returnConnection(con);
        }
        return topNodes;
    }

    private void buildTreeStructure(ArrayList navmems, ArrayList nodeList) {
        for (int m = 0; m < nodeList.size(); ++m) {
            NavGroupMember nm = (NavGroupMember)nodeList.get(m);
            Iterator itr = navmems.iterator();
            while (itr.hasNext()) {
                NavGroupMember pr = (NavGroupMember)itr.next();
                if (pr.group_id != nm.mem_dbid) continue;
                nm.children.add(pr);
                itr.remove();
            }
            this.buildTreeStructure(navmems, nm.children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getGroupIdBySw(long swDbId) {
        long grpId;
        block6: {
            String QUERY_GROUP_ID = "SELECT GROUP_ID FROM NAV_GROUP_MEMBER WHERE MEM_DBID=? ";
            grpId = 0L;
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                conn = ConnectionManager.getConnection();
                stmt = conn.prepareStatement("SELECT GROUP_ID FROM NAV_GROUP_MEMBER WHERE MEM_DBID=? ");
                stmt.setLong(1, swDbId);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    grpId = rs.getInt(1);
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                _Logger.warn((Object)ex.getMessage());
                break block6;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(conn);
            }
            DbUtil.close(stmt);
            DbUtil.close(conn);
        }
        return grpId;
    }

    public class NavGroupMember
    implements Comparator,
    Comparable {
        public NavGroupMember parent;
        public long id;
        public long mem_dbid;
        public String mem_name;
        public int type = -1;
        public long group_id;
        public ArrayList<NavGroupMember> children = new ArrayList();

        public int compareTo(Object arg0) {
            return this.compare(this, arg0);
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            NavGroupMember z1 = (NavGroupMember)o1;
            NavGroupMember z2 = (NavGroupMember)o2;
            return (int)(z1.group_id - z2.group_id);
        }
    }
}

