/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.server.web.vpc;

import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import com.cisco.dcbu.jaxws.ep.InvalidArgumentException;
import com.cisco.dcbu.jaxws.ep.SanServiceException;
import com.cisco.dcbu.jaxws.lan.wo.vpc.VpcPoMemIntfDO;
import com.cisco.dcbu.jaxws.lan.wo.vpc.VpcUtilizationDO;
import com.cisco.dcbu.jaxws.wo.DbFilterDO;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.sm.common.rif.PMRif;
import com.cisco.dcbu.sm.common.type.LanPK;
import com.cisco.dcbu.sm.server.db.ConnectionManager;
import com.cisco.dcbu.sm.server.db.DbUtil;
import com.cisco.dcbu.sm.server.db.PersistentHelper;
import com.cisco.dcbu.sm.server.db.PersistentWrapperIf;
import com.cisco.dcbu.sm.server.model.DCManager;
import com.cisco.dcbu.sm.server.model.EthPortImpl;
import com.cisco.dcbu.sm.server.model.EthSwitchImpl;
import com.cisco.dcbu.sm.server.model.LanImpl;
import com.cisco.dcbu.sm.server.web.ClusterProcessor;
import com.cisco.dcbu.sm.server.web.jasper.report.JasperPrintGenerator;
import com.cisco.dcbu.sm.server.web.util.DisplayUtil;
import com.cisco.dcbu.sm.server.web.util.SQLLoader;
import com.cisco.dcbu.sm.server.web.vpc.Constants;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class VpcUtilizationHandler {
    private static VpcUtilizationHandler _Instance = null;
    private Logger _Log = Logger.getLogger((String)"fms");
    private Map<String, String> _Name2SqlHash = new HashMap<String, String>();

    public static VpcUtilizationHandler getInstance() {
        if (_Instance == null) {
            _Instance = new VpcUtilizationHandler();
        }
        return _Instance;
    }

    private VpcUtilizationHandler() {
        this.initSqlSortSuffix();
    }

    private void initSqlSortSuffix() {
        this._Name2SqlHash.put("vpcId", " order by cvpc.vpcId ");
        this._Name2SqlHash.put("domainId", " order by vpcDomainId ");
        this._Name2SqlHash.put("accessPoCh", " order by access_poch.name ");
        this._Name2SqlHash.put("accessAne", " order by access_ane ");
    }

    public int getVpcConsistentDataLength(DbFilterDO dbFilter, String interval) throws SanServiceException {
        int size = this.getAllVpcs(dbFilter, interval, "", "", 0).size();
        if (this._Log.isTraceEnabled()) {
            this._Log.info((Object)("vPC consistentDataLength: " + size));
        }
        return size;
    }

    public VpcUtilizationDO[] getVpcConsistentList(DbFilterDO dbFilter, String interval, int startIdx, int recordSize) throws SanServiceException {
        ArrayList<VpcUtilizationDO> vpcs = this.getAllVpcs(dbFilter, interval, "", "", 0);
        VpcComparator comparator = new VpcComparator(dbFilter.getSortField(), dbFilter.getSortType());
        Collections.sort(vpcs, comparator);
        int endIndex = startIdx + recordSize > vpcs.size() ? vpcs.size() : startIdx + recordSize;
        List _vpcs = vpcs.subList(startIdx, endIndex);
        VpcUtilizationDO[] vpcdos = new VpcUtilizationDO[_vpcs.size() < recordSize ? _vpcs.size() : recordSize];
        int index = 0;
        for (VpcUtilizationDO vpcDO : _vpcs) {
            vpcdos[index++] = vpcDO;
        }
        return vpcdos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<VpcUtilizationDO> getAllVpcs(DbFilterDO dbFilter, String interval, String sortSqlSuffix, String sqlSuffix, int startIdx) {
        ArrayList<VpcUtilizationDO> resultList;
        block11: {
            resultList = new ArrayList<VpcUtilizationDO>();
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            PersistentWrapperIf helper = PersistentHelper.getHelper();
            try {
                con = ConnectionManager.getConnection();
                sql = Constants.VPC_INFO_SQL + sortSqlSuffix;
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql + sqlSuffix, 1004, 1007);
                rs = SQLLoader.execute(stmt);
                if (startIdx != 0) {
                    rs.absolute(startIdx);
                }
                while (rs.next()) {
                    try {
                        if (this._Log.isTraceEnabled()) {
                            this._Log.info((Object)("vPC ID: " + rs.getString("vpc_id")));
                        }
                        if (!helper.getBooleanFromStringField(rs, "is_vpc_consistent") || !helper.getBooleanFromStringField(rs, "is_peerlink_consistent")) {
                            if (!this._Log.isTraceEnabled()) continue;
                            this._Log.info((Object)("Skipping vPC " + rs.getString("vpc_id") + " is_vpc_consistent: " + helper.getBooleanFromStringField(rs, "is_vpc_consistent") + " is_peerlink_consistent: " + helper.getBooleanFromStringField(rs, "is_peerlink_consistent")));
                            continue;
                        }
                        VpcUtilizationDO vpcUtilizationDO = new VpcUtilizationDO();
                        vpcUtilizationDO.vpcId = rs.getInt("vpc_id");
                        vpcUtilizationDO.domainId = rs.getInt("domain_id");
                        this.getPrimaryVpcInformation(vpcUtilizationDO, interval, rs);
                        this.getSecondaryVpcInformation(vpcUtilizationDO, interval, rs);
                        this.getMultiChassisVpcInformation(vpcUtilizationDO, rs);
                        resultList.add(vpcUtilizationDO);
                    }
                    catch (Exception exp) {
                        this._Log.warn((Object)exp.getMessage(), (Throwable)exp);
                    }
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.error((Object)("Failed to get vPCConsistent List" + ex.getMessage()), (Throwable)ex);
                break block11;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMultiChassisVpcInformation(VpcUtilizationDO vpcUtilizationDO, ResultSet rs) throws Exception {
        block5: {
            block6: {
                if (rs.getLong("multichassis_vpc_sw_id") == 0L) break block6;
                Connection con = null;
                PreparedStatement stmt = null;
                ResultSet rsNew = null;
                String sql = "select sys_name from ethswitch where id = ?";
                try {
                    con = ConnectionManager.getConnection();
                    stmt = con.prepareStatement(sql);
                    stmt.setLong(1, rs.getLong("multichassis_vpc_sw_id"));
                    rsNew = SQLLoader.execute(stmt);
                    while (rsNew.next()) {
                        vpcUtilizationDO.accessDevice = rsNew.getString("sys_name");
                    }
                }
                catch (Exception ex) {
                    try {
                        this._Log.warn((Object)("Unable to get ethSwitchImpl in getMultiChassisVpcInformation() for the switch id: " + rs.getLong("multichassis_vpc_sw_id")));
                    }
                    catch (Throwable throwable) {
                        DbUtil.close(rsNew);
                        DbUtil.close(stmt);
                        DbUtil.close(con);
                        throw throwable;
                    }
                    DbUtil.close(rsNew);
                    DbUtil.close(stmt);
                    DbUtil.close(con);
                    break block5;
                }
                DbUtil.close(rsNew);
                DbUtil.close(stmt);
                DbUtil.close(con);
                break block5;
            }
            vpcUtilizationDO.accessDevice = "n/a";
        }
    }

    private void getPrimaryVpcInformation(VpcUtilizationDO vpcUtilizationDO, String interval, ResultSet rs) throws Exception {
        if (this._Log.isTraceEnabled()) {
            this._Log.info((Object)("primary vpc switch id: " + rs.getLong("primary_vpc_switch_id")));
        }
        vpcUtilizationDO.primaryVpcDBID = rs.getLong("primary_vpc_switch_id");
        vpcUtilizationDO.primaryVpcPo = rs.getInt("primary_vpc_po_id");
        ArrayList<VpcPoMemIntfDO> memIntfList = this.getPoMemberIntfList(vpcUtilizationDO.primaryVpcDBID, vpcUtilizationDO.primaryVpcPo, interval);
        vpcUtilizationDO.primaryPoIntfList = memIntfList;
        if (memIntfList != null && memIntfList.size() > 0) {
            vpcUtilizationDO.primaryVpcDevice = memIntfList.get((int)0).deviceName;
        }
        for (VpcPoMemIntfDO intf : vpcUtilizationDO.primaryPoIntfList) {
            vpcUtilizationDO.primaryPoRx += intf.avgRx;
            vpcUtilizationDO.primaryPoTx += intf.avgTx;
            vpcUtilizationDO.primaryPoCapacity = intf.speed == 0L || vpcUtilizationDO.primaryPoCapacity == -1L ? -1L : (vpcUtilizationDO.primaryPoCapacity += intf.speed);
            vpcUtilizationDO.primaryPoMaxRx += intf.maxRx;
            vpcUtilizationDO.primaryPoMaxTx += intf.maxTx;
        }
        vpcUtilizationDO.primaryPoRxStr = this.formatData(vpcUtilizationDO.primaryPoRx);
        vpcUtilizationDO.primaryPoTxStr = this.formatData(vpcUtilizationDO.primaryPoTx);
        if (vpcUtilizationDO.primaryPoCapacity != -1L) {
            vpcUtilizationDO.primaryPoPeakUtil = Math.max(vpcUtilizationDO.primaryPoMaxRx, vpcUtilizationDO.primaryPoMaxTx) * 100.0 / (double)vpcUtilizationDO.primaryPoCapacity;
            vpcUtilizationDO.primaryPoPeakUtil = Math.round(vpcUtilizationDO.primaryPoPeakUtil);
        }
        vpcUtilizationDO.primaryPoCapacityStr = vpcUtilizationDO.primaryPoCapacity <= 0L ? "n/a" : DisplayUtil.formatSpeed(vpcUtilizationDO.primaryPoCapacity);
    }

    private void getSecondaryVpcInformation(VpcUtilizationDO vpcUtilizationDO, String interval, ResultSet rs) throws Exception {
        if (this._Log.isTraceEnabled()) {
            this._Log.info((Object)("secondary vpc switch id: " + rs.getLong("secondary_vpc_switch_id")));
        }
        vpcUtilizationDO.secondaryVpcDBID = rs.getLong("secondary_vpc_switch_id");
        vpcUtilizationDO.secondaryVpcPo = rs.getInt("secondary_vpc_po_id");
        ArrayList<VpcPoMemIntfDO> secondaryMemIntfList = this.getPoMemberIntfList(vpcUtilizationDO.secondaryVpcDBID, vpcUtilizationDO.secondaryVpcPo, interval);
        vpcUtilizationDO.secondaryPoIntfList = secondaryMemIntfList;
        if (secondaryMemIntfList != null && secondaryMemIntfList.size() > 0) {
            vpcUtilizationDO.secondaryVpcDevice = secondaryMemIntfList.get((int)0).deviceName;
        }
        for (VpcPoMemIntfDO intf : vpcUtilizationDO.secondaryPoIntfList) {
            vpcUtilizationDO.secondaryPoRx += intf.avgRx;
            vpcUtilizationDO.secondaryPoTx += intf.avgTx;
            vpcUtilizationDO.secondaryPoCapacity = intf.speed == 0L || vpcUtilizationDO.secondaryPoCapacity == -1L ? -1L : (vpcUtilizationDO.secondaryPoCapacity += intf.speed);
            vpcUtilizationDO.secondaryPoMaxRx += intf.maxRx;
            vpcUtilizationDO.secondaryPoMaxTx += intf.maxTx;
        }
        vpcUtilizationDO.secondaryPoRxStr = this.formatData(vpcUtilizationDO.secondaryPoRx);
        vpcUtilizationDO.secondaryPoTxStr = this.formatData(vpcUtilizationDO.secondaryPoTx);
        if (vpcUtilizationDO.secondaryPoCapacity != -1L) {
            vpcUtilizationDO.secondaryPoPeakUtil = Math.max(vpcUtilizationDO.secondaryPoMaxRx, vpcUtilizationDO.secondaryPoMaxTx) * 100.0 / (double)vpcUtilizationDO.secondaryPoCapacity;
            vpcUtilizationDO.secondaryPoPeakUtil = Math.round(vpcUtilizationDO.secondaryPoPeakUtil);
        }
        vpcUtilizationDO.secondaryPoCapacityStr = vpcUtilizationDO.secondaryPoCapacity <= 0L ? "n/a" : DisplayUtil.formatSpeed(vpcUtilizationDO.secondaryPoCapacity);
    }

    private ArrayList<VpcPoMemIntfDO> getPoMemberIntfList(LanImpl lan, int channelNum, EthSwitchImpl ethSwitchImpl, String interval) {
        ArrayList<VpcPoMemIntfDO> resultList = new ArrayList<VpcPoMemIntfDO>();
        ArrayList<EthPortImpl> ethPortImpls = DCManager.getInstance().findChildrenByChannelNum(lan, ethSwitchImpl, channelNum);
        if (ethPortImpls != null) {
            for (EthPortImpl ethPortImpl : ethPortImpls) {
                VpcPoMemIntfDO intf = new VpcPoMemIntfDO();
                intf.name = ethPortImpl.getIfname();
                intf.deviceName = ethSwitchImpl.getName();
                this.upateIntfAvgRxTx(ethSwitchImpl.getName(), intf, interval);
                resultList.add(intf);
            }
        } else {
            this._Log.warn((Object)("Unabled to get Portchannel members for the device: " + ethSwitchImpl.getIpAddress() + " Portchannel ID: " + channelNum));
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<VpcPoMemIntfDO> getPoMemberIntfList(long switchDBId, int channelNum, String interval) {
        ArrayList<VpcPoMemIntfDO> resultList = new ArrayList<VpcPoMemIntfDO>();
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "select ethswitch_port.if_name, ethswitch.sys_name from ethswitch_port, ethswitch where (ethswitch_port.switch_id = ? and ethswitch.id = ?) and channel_id in ( select if_index from ethswitch_port where if_name like ? and switch_id = ? )";
        try {
            con = ConnectionManager.getConnection();
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, switchDBId);
            stmt.setLong(2, switchDBId);
            stmt.setString(3, "%-channel" + channelNum);
            stmt.setLong(4, switchDBId);
            rs = SQLLoader.execute(stmt);
            while (rs.next()) {
                VpcPoMemIntfDO intf = new VpcPoMemIntfDO();
                intf.name = rs.getString("if_name");
                intf.deviceName = rs.getString("sys_name");
                this.upateIntfAvgRxTx(intf.deviceName, intf, interval);
                resultList.add(intf);
            }
        }
        catch (Exception ex) {
            try {
                this._Log.warn((Object)("Unabled to get Portchannel members for the device DBId: " + switchDBId + " Portchannel ID: " + channelNum));
                this._Log.error((Object)("Failed to get vPCConsistent List" + ex.getMessage()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
                throw throwable;
            }
            DbUtil.close(rs);
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
        DbUtil.close(rs);
        DbUtil.close(stmt);
        DbUtil.close(con);
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upateIntfAvgRxTx(String deviceName, VpcPoMemIntfDO intf, String interval) {
        block17: {
            if (this._Log.isTraceEnabled()) {
                this._Log.info((Object)("Inside upateIntfAvgRxTx() -> deviceName: " + deviceName));
                this._Log.info((Object)("Inside upateIntfAvgRxTx() -> interfaceName: " + intf.name));
            }
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String sql = null;
            try {
                con = ConnectionManager.getConnection();
                if (interval == null) {
                    sql = Constants.INTERFACE_24HOURS_UTIL_SQL;
                } else if (interval.trim().equalsIgnoreCase("24 Hours") || interval.trim().equalsIgnoreCase("")) {
                    sql = Constants.INTERFACE_24HOURS_UTIL_SQL;
                } else if (interval.trim().equalsIgnoreCase("Week")) {
                    sql = Constants.INTERFACE_WEEK_UTIL_SQL;
                } else if (interval.trim().equalsIgnoreCase("Month")) {
                    sql = Constants.INTERFACE_MONTH_UTIL_SQL;
                } else if (interval.trim().equalsIgnoreCase("Year")) {
                    sql = Constants.INTERFACE_YEAR_UTIL_SQL;
                }
                sql = sql.replace("SWITCH_NAME", deviceName);
                sql = sql.replace("INTERFACE_NAME", intf.name);
                stmt = PersistentHelper.getHelper().getPreparedStmt(con, sql, 1004, 1007);
                rs = SQLLoader.execute(stmt);
                while (rs.next()) {
                    double maxTx;
                    double maxRx;
                    double avgTx;
                    double avgRx;
                    long speed = Long.parseLong(rs.getString("intfSpeed"));
                    if (speed < 0L) {
                        speed = 0L;
                    }
                    intf.speed = speed;
                    intf.speedStr = speed <= 0L ? "n/a" : DisplayUtil.formatSpeed(speed);
                    intf.avgRx = avgRx = Double.parseDouble(rs.getString("avgRx")) * 10.0 / 8.0;
                    intf.avgRxStr = this.formatData(avgRx);
                    intf.avgTx = avgTx = Double.parseDouble(rs.getString("avgTx")) * 10.0 / 8.0;
                    intf.avgTxStr = this.formatData(avgTx);
                    intf.maxRx = maxRx = Double.parseDouble(rs.getString("maxRx")) * 10.0;
                    intf.maxTx = maxTx = Double.parseDouble(rs.getString("maxTx")) * 10.0;
                    intf.rrdFile = rs.getString("rrdFile");
                    intf.lanId = rs.getInt("lanId");
                }
                DbUtil.close(rs);
            }
            catch (Exception ex) {
                this._Log.error((Object)("Failed to get Interface Utilization: " + ex.getMessage()), (Throwable)ex);
                break block17;
            }
            finally {
                DbUtil.close(rs);
                DbUtil.close(stmt);
                DbUtil.close(con);
            }
            DbUtil.close(stmt);
            DbUtil.close(con);
        }
    }

    private String formatData(double data) {
        return !Double.isNaN(data) && data > 0.0 ? DefaultSnmpNumberRenderer.formatLong((long)data) + "B" : "n/a";
    }

    public String printVpcUtillTable(DbFilterDO dbFilter, String inverval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        if (this._Log.isTraceEnabled()) {
            this._Log.info((Object)"Inside vPC Utilization printVpcUtillTable");
            this._Log.info((Object)("startIdx: " + startIdx));
            this._Log.info((Object)("recordSize: " + recordSize));
            this._Log.info((Object)("columnHeader.length: " + columnHeader.length));
        }
        try {
            VpcUtilizationDO[] vpcUtil = VpcUtilizationHandler.getInstance().getVpcConsistentList(dbFilter, inverval, startIdx, recordSize);
            List<VpcUtilizationDO> rstList = Arrays.asList(vpcUtil);
            return JasperPrintGenerator.getInstance().generatePrintReport("vPC Utilization", columnHeader, this.getColumnAlignment(), rstList);
        }
        catch (SanServiceException e) {
            this._Log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private HashMap<String, HorizontalAlign> getColumnAlignment() {
        HashMap<String, HorizontalAlign> columnAlignment = new HashMap<String, HorizontalAlign>();
        columnAlignment.put("Capacity", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg. Rx/sec", HorizontalAlign.RIGHT);
        columnAlignment.put("Avg. Tx/sec", HorizontalAlign.RIGHT);
        return columnAlignment;
    }

    public String exportVpcUtilTable(DbFilterDO dbFilter, String inverval, int startIdx, int recordSize, String[] columnHeader) throws SanServiceException {
        if (this._Log.isTraceEnabled()) {
            this._Log.info((Object)"Inside vPC Utilization exportVpcUtillTable");
            this._Log.info((Object)("startIdx: " + startIdx));
            this._Log.info((Object)("recordSize: " + recordSize));
            this._Log.info((Object)("columnHeader.length: " + columnHeader.length));
        }
        try {
            VpcUtilizationDO[] vpcUtil = VpcUtilizationHandler.getInstance().getVpcConsistentList(dbFilter, inverval, startIdx, recordSize);
            List<VpcUtilizationDO> rstList = Arrays.asList(vpcUtil);
            columnHeader[10] = "null:null:null";
            columnHeader[18] = "null:null:null";
            return JasperPrintGenerator.getInstance().generateExcelReport("vPC Utilization", columnHeader, this.getColumnAlignment(), rstList);
        }
        catch (SanServiceException e) {
            this._Log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public double[][] getPmChartData(String rrdFile, int pmType, int lanId, int interval) throws SanServiceException {
        try {
            if (rrdFile == null) {
                throw new InvalidArgumentException();
            }
            PMRif pmRif = ClusterProcessor.getInstance().getPMByPK(new LanPK(lanId));
            return pmRif.getPmChartData(rrdFile, pmType, interval);
        }
        catch (InvalidArgumentException e) {
            this._Log.error((Object)"SanWS caught exception in getPmChartData():", (Throwable)e);
        }
        catch (Throwable e) {
            this._Log.error((Object)"SanWS caught exception in getPmChartData():", e);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        GenUtil.loadServerProperties(null);
        DbFilterDO dbFilter = new DbFilterDO(-1L, -1L, "Name", "DESC");
        dbFilter.setSortField("");
        System.out.println("*********get storage ************ :");
        ArrayList<VpcUtilizationDO> list = VpcUtilizationHandler.getInstance().getAllVpcs(dbFilter, "24 Hours", "", "", 0);
        System.out.println(list.size());
    }

    class VpcComparator
    implements Comparator<VpcUtilizationDO> {
        String sortField = null;
        String sortType = null;

        public VpcComparator(String sortField, String sortType) {
            if (sortField == null || sortField.length() == 0) {
                sortField = "vpc_id";
            }
            if (sortField.endsWith("Str")) {
                sortField = sortField.substring(0, sortField.lastIndexOf("Str"));
            }
            this.sortField = sortField;
            this.sortType = sortType;
        }

        @Override
        public int compare(VpcUtilizationDO o1, VpcUtilizationDO o2) {
            try {
                Field f = VpcUtilizationDO.class.getField(this.sortField);
                Object obj1 = f.get(o1);
                Object obj2 = f.get(o2);
                if (this.sortType.equals("DESC")) {
                    if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                        if ((Integer)obj1 < (Integer)obj2) {
                            return 1;
                        }
                        if ((Integer)obj1 > (Integer)obj2) {
                            return -1;
                        }
                        return 0;
                    }
                    if (obj1 != null && obj2 != null && obj1 instanceof Double && obj2 instanceof Double) {
                        if ((Double)obj1 < (Double)obj2) {
                            return 1;
                        }
                        if ((Double)obj1 > (Double)obj2) {
                            return -1;
                        }
                        return 0;
                    }
                    if (obj1 != null && obj2 != null && obj1 instanceof Long && obj2 instanceof Long) {
                        if ((Long)obj1 < (Long)obj2) {
                            return 1;
                        }
                        if ((Long)obj1 > (Long)obj2) {
                            return -1;
                        }
                        return 0;
                    }
                    obj1 = obj1 == null ? "" : obj1;
                    obj2 = obj2 == null ? "" : obj2;
                    return obj2.toString().compareTo(obj1.toString());
                }
                if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                    if ((Integer)obj1 > (Integer)obj2) {
                        return 1;
                    }
                    if ((Integer)obj1 < (Integer)obj2) {
                        return -1;
                    }
                    return 0;
                }
                if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                    if ((Double)obj1 > (Double)obj2) {
                        return 1;
                    }
                    if ((Double)obj1 < (Double)obj2) {
                        return -1;
                    }
                    return 0;
                }
                if (obj1 != null && obj2 != null && obj1 instanceof Integer && obj2 instanceof Integer) {
                    if ((Long)obj1 > (Long)obj2) {
                        return 1;
                    }
                    if ((Long)obj1 < (Long)obj2) {
                        return -1;
                    }
                    return 0;
                }
                obj1 = obj1 == null ? "" : obj1;
                obj2 = obj2 == null ? "" : obj2;
                return obj1.toString().compareTo(obj2.toString());
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }
}

