/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.accounting;

import com.cisco.dcbu.sme.accounting.Accounting;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import java.io.Serializable;
import java.util.Date;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class SMEKMCAccountingJob
implements StatefulJob,
Serializable {
    private static final long serialVersionUID = 1L;
    private Accounting accountingBean;
    static Logger _Logger = Logger.getLogger((String)"KMC");

    public void setAccountingBean(Accounting accountingBean) {
        this.accountingBean = accountingBean;
    }

    public SMEKMCAccountingJob() {
        try {
            InitialContext ctx = new InitialContext();
            Accounting bean = (Accounting)ctx.lookup("java:global/dcm/dcm/AccountingBean!" + Accounting.class.getName());
            this.setAccountingBean(bean);
        }
        catch (NamingException e) {
            _Logger.error((Object)("Error looking up Accounting Manager implementation " + e.getMessage()));
        }
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDetail jobDetail = context.getJobDetail();
        String groupJobName = jobDetail.getFullName();
        String jobName = groupJobName.substring(groupJobName.indexOf(46) + 1, groupJobName.length());
        _Logger.info((Object)("Archive KMC accounting log job: " + groupJobName + " started at " + new Date()));
        OperationStatus ret = this.accountingBean.archiveLogs();
        if (ret.getStatus() == OperationStatusEnum.Success) {
            _Logger.info((Object)("Archive KMC accounting log  job: " + groupJobName + " finished at " + new Date()));
        } else {
            _Logger.info((Object)("Archive KMC accounting log  job: " + groupJobName + " finished at " + new Date() + " failed!"));
        }
    }
}

