/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.ejb.impl;

import com.cisco.dcbu.sme.ckmc.ejb.api.CKMCMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ClusterMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.DiskGroupMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.KeyMgrFacade;
import com.cisco.dcbu.sme.ckmc.ejb.api.TapeGroupMgrCKMC;
import com.cisco.dcbu.sme.ckmc.entity.Settings;
import com.cisco.dcbu.sme.ckmc.entity.pk.SettingsPK;
import com.cisco.dcbu.sme.comm.service.CKMCMgrMMBean;
import com.cisco.dcbu.sme.common.CKMCClusterStateEnum;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.ConfigProperties;
import com.cisco.dcbu.sme.common.DiskGroupStatusEnum;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.DiskStatusEnum;
import com.cisco.dcbu.sme.common.KMCStatusEnum;
import com.cisco.dcbu.sme.common.KeyManagerConfig;
import com.cisco.dcbu.sme.common.KeyManagerEnum;
import com.cisco.dcbu.sme.common.KeyTypeEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.TapeGroupStatusEnum;
import com.cisco.dcbu.sme.common.TapeVolumeGroupStatusEnum;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyEntity;
import com.cisco.dcbu.sme.xml.SMEKeyTypeEnum;
import com.cisco.dcbu.sme.xml.SMETapeVolumeGroupIndex;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;

@Stateless(name="CKMCMgrBean")
public class CKMCMgrBean
implements Serializable,
CKMCMgr,
ConfigProperties {
    @PersistenceContext(unitName="sme")
    private EntityManager manager;
    private ClusterMgrCKMC clusterBean;
    private TapeGroupMgrCKMC tapeGroupBean;
    private DiskGroupMgrCKMC diskGroupBean;
    private KeyMgrFacade keyBean;
    static Logger _Logger = Logger.getLogger((String)"KMC");

    @EJB
    public void setClusterCKMCBean(ClusterMgrCKMC clusterBean) {
        this.clusterBean = clusterBean;
    }

    @EJB
    public void setTapeGroupCKMCBean(TapeGroupMgrCKMC tapeGroupBean) {
        this.tapeGroupBean = tapeGroupBean;
    }

    @EJB
    public void setDiskGroupCKMCBean(DiskGroupMgrCKMC diskGroupBean) {
        this.diskGroupBean = diskGroupBean;
    }

    @EJB
    public void setKeyMgrFacadeBean(KeyMgrFacade keyBean) {
        this.keyBean = keyBean;
    }

    @Override
    public OperationStatus updateKMCStatus(String msg) {
        OperationStatus stat = new OperationStatus();
        SettingsPK pk = new SettingsPK("sme.kmc.status.msg");
        Settings s = (Settings)this.manager.find(Settings.class, (Object)pk);
        if (msg == null) {
            msg = "";
        }
        if (msg.length() > 63) {
            msg = msg.substring(1, 64);
        }
        if (s != null) {
            s.setValue(msg);
        } else {
            s = new Settings();
            s.setName("sme.kmc.status.msg");
            s.setValue(msg);
        }
        try {
            this.manager.persist((Object)s);
            stat.set(OperationStatusEnum.Success, "Set KMC state to " + msg);
        }
        catch (Exception e) {
            String logMsg = "Failed to update KMC state to " + msg + " Exception: " + e.getMessage();
            stat.set(OperationStatusEnum.Failure, logMsg);
            _Logger.error((Object)logMsg);
        }
        return stat;
    }

    public String getKMCStatus() {
        SettingsPK pk = new SettingsPK("sme.kmc.status.msg");
        Settings s = (Settings)this.manager.find(Settings.class, (Object)pk);
        if (s != null) {
            return s.getValue();
        }
        return "Unknown status";
    }

    @Override
    public OperationStatus logMessage(SMEContext ctx, String clusterName, String clusterId, String message) {
        return this.keyBean.logMessage(ctx, clusterName, clusterId, message);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public OperationStatus updateKey(SMEContext ctx, SMEKey keyObject) {
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        ret.setDescription("success");
        SMEKeyEntity entity = keyObject.getData().getKey_Entity();
        if (entity.isSetDisk_Key()) {
            ret = this.clusterBean.addCluster(entity.getDisk_Key().getCluster_Name(), entity.getDisk_Key().getCluster_ID(), ClusterStatusEnum.Online, CKMCClusterStateEnum.None);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
            ret = this.diskGroupBean.addDiskGroup(entity.getDisk_Key().getCluster_Name(), entity.getDisk_Key().getDisk_Group_Name(), DiskGroupStatusEnum.Ready);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
            ret = this.diskGroupBean.updateDiskNoStatus(null, entity.getDisk_Key().getCluster_Name(), entity.getDisk_Key().getDisk_Group_Name(), entity.getDisk_Key().getDisk_Name(), entity.getDisk_Key().getDisk_VPD().getVendor_ID(), entity.getDisk_Key().getDisk_VPD().getProduct_ID(), entity.getDisk_Key().getDisk_VPD().getDevice_ID());
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
            int version = this.diskGroupBean.getDiskKeyVersion(entity.getDisk_Key().getCluster_Name(), entity.getDisk_Key().getDisk_Group_Name(), entity.getDisk_Key().getDisk_Name(), entity.getDisk_Key().getDisk_VPD().getVendor_ID(), entity.getDisk_Key().getDisk_VPD().getProduct_ID(), entity.getDisk_Key().getDisk_VPD().getDevice_ID());
            if (version < 0) {
                ret.set(OperationStatusEnum.Failure, "Failed to update key");
            }
            if ((ret = this.keyBean.addKey(ctx, keyObject, KeyTypeEnum.DiskKey, version + 1)).getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
        } else if (entity.isSetMasterKey_Key()) {
            ret = this.clusterBean.addCluster(entity.getMasterKey_Key().getCluster_Name(), entity.getMasterKey_Key().getCluster_ID(), ClusterStatusEnum.Online, CKMCClusterStateEnum.None);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
            int version = Integer.valueOf(keyObject.getData().getKey_Entity().getMasterKey_Key().getMaster_Key_Version());
            ret = this.keyBean.addKey(ctx, keyObject, KeyTypeEnum.MasterKey, version);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
        } else if (!entity.isSetMasterKey_Share_Key()) {
            if (entity.isSetTape_Volume_Group_Shared_Key()) {
                ret = this.clusterBean.addCluster(entity.getTape_Volume_Group_Shared_Key().getCluster_Name(), entity.getTape_Volume_Group_Shared_Key().getCluster_ID(), ClusterStatusEnum.Online, CKMCClusterStateEnum.None);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                ret = this.tapeGroupBean.addTapeGroup(entity.getTape_Volume_Group_Shared_Key().getCluster_Name(), entity.getTape_Volume_Group_Shared_Key().getTape_BackupGroup_Name(), TapeGroupStatusEnum.Active);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                ret = this.tapeGroupBean.addTapeVolumeGroup(entity.getTape_Volume_Group_Shared_Key().getCluster_Name(), entity.getTape_Volume_Group_Shared_Key().getTape_BackupGroup_Name(), entity.getTape_Volume_Group_Shared_Key().getTape_VolumeGroup_Name(), TapeVolumeGroupStatusEnum.Active);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                int version = this.tapeGroupBean.getTapeVolumeGroupSharedVersion(entity.getTape_Volume_Group_Shared_Key().getCluster_Name(), entity.getTape_Volume_Group_Shared_Key().getTape_BackupGroup_Name(), entity.getTape_Volume_Group_Shared_Key().getTape_VolumeGroup_Name());
                if (version < 0) {
                    ret.set(OperationStatusEnum.Failure, "Failed to update key");
                }
                if ((ret = this.keyBean.addKey(ctx, keyObject, KeyTypeEnum.TapeVolumeGroupSharedKey, version + 1)).getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                OperationStatus retRep = this.keyBean.addPendingReplication(ctx, keyObject);
            } else if (entity.isSetTape_Volume_Group_Wrap_Key()) {
                ret = this.clusterBean.addCluster(entity.getTape_Volume_Group_Wrap_Key().getCluster_Name(), entity.getTape_Volume_Group_Wrap_Key().getCluster_ID(), ClusterStatusEnum.Online, CKMCClusterStateEnum.None);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                ret = this.tapeGroupBean.addTapeGroup(entity.getTape_Volume_Group_Wrap_Key().getCluster_Name(), entity.getTape_Volume_Group_Wrap_Key().getTape_BackupGroup_Name(), TapeGroupStatusEnum.Active);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                ret = this.tapeGroupBean.addTapeVolumeGroup(entity.getTape_Volume_Group_Wrap_Key().getCluster_Name(), entity.getTape_Volume_Group_Wrap_Key().getTape_BackupGroup_Name(), entity.getTape_Volume_Group_Wrap_Key().getTape_VolumeGroup_Name(), TapeVolumeGroupStatusEnum.Active);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                int version = this.tapeGroupBean.getTapeVolumeGroupWrapVersion(entity.getTape_Volume_Group_Wrap_Key().getCluster_Name(), entity.getTape_Volume_Group_Wrap_Key().getTape_BackupGroup_Name(), entity.getTape_Volume_Group_Wrap_Key().getTape_VolumeGroup_Name());
                if (version < 0) {
                    ret.set(OperationStatusEnum.Failure, "Failed to update key");
                }
                if ((ret = this.keyBean.addKey(ctx, keyObject, KeyTypeEnum.TapeVolumeGroupWrapKey, version + 1)).getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                OperationStatus retRep = this.keyBean.addPendingReplication(ctx, keyObject);
            } else if (entity.isSetTape_Volume_Key()) {
                ret = this.clusterBean.addCluster(entity.getTape_Volume_Key().getCluster_Name(), entity.getTape_Volume_Key().getCluster_ID(), ClusterStatusEnum.Online, CKMCClusterStateEnum.None);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                ret = this.tapeGroupBean.addTapeGroup(entity.getTape_Volume_Key().getCluster_Name(), entity.getTape_Volume_Key().getTape_BackupGroup_Name(), TapeGroupStatusEnum.Active);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                ret = this.tapeGroupBean.addTapeVolumeGroup(entity.getTape_Volume_Key().getCluster_Name(), entity.getTape_Volume_Key().getTape_BackupGroup_Name(), entity.getTape_Volume_Key().getTape_VolumeGroup_Name(), TapeVolumeGroupStatusEnum.Active);
                if (ret.getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                if (entity.getTape_Volume_Key().getBarcode() == null) {
                    String logMsg = "Null barcode specified for the key.";
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                    return ret;
                }
                if (entity.getTape_Volume_Key().getBarcode().length() > 32) {
                    String logMsg = "Invalid barcode specified for the key.";
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                    return ret;
                }
                int version = this.tapeGroupBean.getTapeVolumeVersion(entity.getTape_Volume_Key().getCluster_Name(), entity.getTape_Volume_Key().getTape_BackupGroup_Name(), entity.getTape_Volume_Key().getTape_VolumeGroup_Name(), entity.getTape_Volume_Key().getBarcode());
                if (version < 0) {
                    ret.set(OperationStatusEnum.Failure, "Failed to update key");
                }
                if ((ret = this.keyBean.addKey(ctx, keyObject, KeyTypeEnum.TapeVolumeKey, version + 1)).getStatus() != OperationStatusEnum.Success) {
                    return ret;
                }
                OperationStatus retRep = this.keyBean.addPendingReplication(ctx, keyObject);
            }
        }
        return ret;
    }

    @Override
    public SMEKey getKey(SMEContext ctx, String clusterName, String clusterId, String guid) {
        return this.keyBean.getKey(ctx, clusterName, clusterId, guid);
    }

    @Override
    public SMEKey getKeysbyClonedFromGUID(SMEContext ctx, String clusterName, String clusterId, String guid) {
        return this.keyBean.getKeysbyClonedFromGUID(ctx, clusterName, clusterId, guid);
    }

    @Override
    public SMEKey getBestKeybyEntity(SMEContext ctx, String entityIndexWC, KeyTypeEnum keyType) {
        return this.keyBean.getBestKeybyEntityWC(ctx, entityIndexWC, keyType);
    }

    @Override
    public OperationStatus archiveAllKeysforEntity(SMEContext ctx, String clusterId, SMEKeyEntity entity, String archivalTime) {
        OperationStatus ret = this.keyBean.archiveAllKeysbyEntity(ctx, entity, archivalTime);
        if (ret.getStatus() == OperationStatusEnum.Success) {
            SMETapeVolumeGroupIndex index = entity.getTape_Volume_Group_Wrap_Key();
            this.tapeGroupBean.archiveTapeVolumeGroup(index.getCluster_Name(), index.getTape_BackupGroup_Name(), index.getTape_VolumeGroup_Name());
        }
        return ret;
    }

    @Override
    public OperationStatus archiveKey(SMEContext ctx, String clusterName, String clusterId, String guid, String archivalTime) {
        OperationStatus ret = new OperationStatus();
        SMEKey key = this.keyBean.getKey(ctx, clusterName, clusterId, guid);
        if (key != null) {
            ret = this.keyBean.archiveKey(ctx, clusterName, guid, archivalTime);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
        } else {
            String logMsg = "Failed to find key guid, archive request failed : " + guid;
            ret.set(OperationStatusEnum.NoMoreObjects, logMsg);
            _Logger.error((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus purgeKey(SMEContext ctx, String clusterName, String clusterId, String guid) {
        OperationStatus ret = new OperationStatus();
        SMEKey key = this.keyBean.getKey(ctx, clusterName, clusterId, guid);
        if (key != null) {
            OperationStatus stat;
            String entityIndexWC;
            SMEKey testKey;
            ret = this.keyBean.deleteKey(ctx, clusterName, guid);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
            if (SMEKeyTypeEnum.KEY___TYPE___DISK___KEY.equals((Object)key.getData().getKey_Type()) && (testKey = this.keyBean.getBestKeybyEntityWC(ctx, entityIndexWC = clusterName + ":" + key.getData().getKey_Entity().getDisk_Key().getDisk_Group_Name() + ":" + key.getData().getKey_Entity().getDisk_Key().getDisk_Name() + ":%", KeyTypeEnum.DiskKey)) == null && !OperationStatusEnum.Success.equals((stat = this.diskGroupBean.purgeDisk(ctx, clusterName, key.getData().getKey_Entity().getDisk_Key().getDisk_Group_Name(), key.getData().getKey_Entity().getDisk_Key().getDisk_Name())).getStatus())) {
                _Logger.warn((Object)"Failed to purge Disk after last Disk Key purge.");
            }
        } else {
            String logMsg = "Key guid " + guid + " not found for cluster " + clusterName;
            ret.set(OperationStatusEnum.Success, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus purgeKeyByClonedGuid(SMEContext ctx, String clusterName, String clusterId, String clonedGuid) {
        OperationStatus ret = new OperationStatus();
        SMEKey key = this.keyBean.getKeysbyClonedFromGUID(ctx, clusterName, clusterId, clonedGuid);
        if (key != null) {
            OperationStatus stat;
            String entityIndexWC;
            SMEKey testKey;
            ret = this.keyBean.deleteKey(ctx, clusterName, key.getIndex().getGUID());
            if (ret.getStatus() != OperationStatusEnum.Success) {
                return ret;
            }
            if (SMEKeyTypeEnum.KEY___TYPE___DISK___KEY.equals((Object)key.getData().getKey_Type()) && (testKey = this.keyBean.getBestKeybyEntityWC(ctx, entityIndexWC = clusterName + ":" + key.getData().getKey_Entity().getDisk_Key().getDisk_Group_Name() + ":" + key.getData().getKey_Entity().getDisk_Key().getDisk_Name() + ":%", KeyTypeEnum.DiskKey)) == null && !OperationStatusEnum.Success.equals((stat = this.diskGroupBean.purgeDisk(ctx, clusterName, key.getData().getKey_Entity().getDisk_Key().getDisk_Group_Name(), key.getData().getKey_Entity().getDisk_Key().getDisk_Name())).getStatus())) {
                _Logger.warn((Object)"Failed to purge Disk after last Disk Key purge.");
            }
        } else {
            String logMsg = "Cloned from Key guid " + clonedGuid + " not found for cluster " + clusterName;
            ret.set(OperationStatusEnum.Success, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus updateDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName, String vendor, String product, String device, DiskStatusEnum status) {
        return this.diskGroupBean.updateDisk(ctx, clusterName, diskGroupName, diskName, vendor, product, device, status);
    }

    @Override
    public DiskInfo getDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupBean.getDisk(ctx, clusterName, diskGroupName, diskName);
    }

    @Override
    public DiskInfo getDisk(SMEContext ctx, String clusterName, String vendor, String product, String device) {
        return this.diskGroupBean.getDisk(ctx, clusterName, vendor, product, device);
    }

    @Override
    public KeyManagerConfig getKeyManagerConfig() {
        _Logger.debug((Object)"CKMCMgr - get Key Manager Config");
        KeyManagerConfig config = new KeyManagerConfig();
        try {
            SettingsPK pk = new SettingsPK("sme.key.manager");
            Settings s = (Settings)this.manager.find(Settings.class, (Object)pk);
            if (s != null) {
                if (s.getValue().equals(KeyManagerEnum.CISCO.toString())) {
                    config.setKeyManager(KeyManagerEnum.CISCO);
                    _Logger.warn((Object)"CISCO Key Manager Configured");
                } else if (s.getValue().equals(KeyManagerEnum.RSA.toString())) {
                    config.setKeyManager(KeyManagerEnum.RSA);
                    _Logger.warn((Object)"RSA Key Manager Configured");
                } else if (s.getValue().equals(KeyManagerEnum.NONE.toString())) {
                    config.setKeyManager(KeyManagerEnum.NONE);
                    _Logger.warn((Object)"No Key Manager Configured");
                } else {
                    config.setKeyManager(KeyManagerEnum.NOT_CFG);
                    _Logger.warn((Object)"No Key Manager Configured");
                }
            } else {
                config.setKeyManager(KeyManagerEnum.NOT_CFG);
                _Logger.warn((Object)"No Key Manager Configured");
            }
            pk = new SettingsPK("sme.primary.kmc.address");
            s = (Settings)this.manager.find(Settings.class, (Object)pk);
            if (s != null) {
                config.setPrimaryKMCAddr(s.getValue());
                _Logger.debug((Object)("Primary KMC server Address: " + config.getPrimaryKMCAddr()));
            } else {
                _Logger.warn((Object)"No Primary KMC Server address configured");
            }
            pk = new SettingsPK("sme.secondary.kmc.address");
            s = (Settings)this.manager.find(Settings.class, (Object)pk);
            if (s != null) {
                config.setSecondaryKMCAddr(s.getValue());
                _Logger.debug((Object)("Secondary KMC server Address: " + config.getSecondaryKMCAddr()));
            } else {
                _Logger.warn((Object)"No Secondary KMC Server address configured");
            }
        }
        catch (Exception e) {
            _Logger.warn((Object)("Exception in getKeyManagerConfig. Exception: " + e.getMessage()));
        }
        return config;
    }

    @Override
    public OperationStatus saveKeyManagerConfig(KeyManagerConfig config) {
        OperationStatus ret = new OperationStatus();
        _Logger.debug((Object)"CKMCMgr - save Key Manager Config");
        SettingsPK pk = new SettingsPK("sme.key.manager");
        Settings s = (Settings)this.manager.find(Settings.class, (Object)pk);
        if (s == null) {
            s = new Settings();
        }
        s.setName("sme.key.manager");
        s.setValue(config.getKeyManager().toString());
        try {
            this.manager.persist((Object)s);
        }
        catch (Exception e) {
            String logMsg = "Failed to Save Key Manager Configuration. Exception: " + e.getMessage();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            return ret;
        }
        pk = new SettingsPK("sme.primary.kmc.address");
        s = (Settings)this.manager.find(Settings.class, (Object)pk);
        if (s == null) {
            s = new Settings();
        }
        s.setName("sme.primary.kmc.address");
        s.setValue(config.getPrimaryKMCAddr());
        try {
            this.manager.persist((Object)s);
        }
        catch (Exception e) {
            String logMsg = "Failed to Save Key Manager Server. Exception: " + e.getMessage();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            return ret;
        }
        pk = new SettingsPK("sme.secondary.kmc.address");
        s = (Settings)this.manager.find(Settings.class, (Object)pk);
        if (s == null) {
            s = new Settings();
        }
        s.setName("sme.secondary.kmc.address");
        s.setValue(config.getSecondaryKMCAddr());
        try {
            this.manager.persist((Object)s);
        }
        catch (Exception e) {
            String logMsg = "Failed to Save Key Manager Server. Exception: " + e.getMessage();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
            return ret;
        }
        if (config.getKeyManager() == KeyManagerEnum.CISCO) {
            String logMsg = "Saved Key Manager Configuration. CISCO Key Manager configured.";
            ret.set(OperationStatusEnum.Success, logMsg);
            _Logger.info((Object)logMsg);
            return ret;
        }
        if (config.getKeyManager() == KeyManagerEnum.RSA) {
            String logMsg = "Saved Key Manager Configuration. RSA Key Manager configured.";
            ret.set(OperationStatusEnum.Success, logMsg);
            _Logger.info((Object)logMsg);
            return ret;
        }
        if (config.getKeyManager() == KeyManagerEnum.NONE) {
            String logMsg = "Saved Key Manager Configuration. No Key Manager configured. This is FM installtion for provisioning and cannot be used as KMC.";
            ret.set(OperationStatusEnum.Success, logMsg);
            _Logger.info((Object)logMsg);
            return ret;
        }
        String logMsg = "Saved Key Manager Configuration. No Key Manager Configured.";
        ret.set(OperationStatusEnum.Success, logMsg);
        _Logger.warn((Object)logMsg);
        return ret;
    }

    @Override
    public OperationStatus restartKMC() {
        OperationStatus ret = new OperationStatus();
        CKMCMgrMMBean ckmc = null;
        ObjectName obj = null;
        try {
            obj = new ObjectName("dcm:service=CKMCManager");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ckmc = MBeanServerInvocationHandler.newProxyInstance(server, obj, CKMCMgrMMBean.class, false);
            if (ckmc != null) {
                ckmc.stopCKMCListenerService();
                Thread.sleep(2000L);
                ckmc.startCKMCListenerService();
                Thread.sleep(2000L);
                Config conf = Config.getInstance();
                if (conf.getKmcServerCertFileName() == null || conf.getKmcServerCertFileName().length() == 0) {
                    if (ckmc.isNonSecureKMCRunning()) {
                        String logMsg = "Sucessfully restarted CKMC";
                        this.updateKMCStatus(logMsg);
                        ret.set(OperationStatusEnum.Success, logMsg);
                        _Logger.info((Object)logMsg);
                    } else {
                        String logMsg = "Failed to restart CKMC";
                        this.updateKMCStatus(logMsg);
                        ret.set(OperationStatusEnum.Failure, logMsg);
                        _Logger.warn((Object)logMsg);
                    }
                } else if (ckmc.isSecureKMCRunning()) {
                    String logMsg = "Sucessfully restarted secure CKMC";
                    this.updateKMCStatus(logMsg);
                    ret.set(OperationStatusEnum.Success, logMsg);
                    _Logger.info((Object)logMsg);
                } else {
                    String logMsg = "Failed to restart the secure CKMC: " + this.getKMCStatus();
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    _Logger.warn((Object)logMsg);
                }
            } else {
                String logMsg = "Failed to restart the KMC service in Fabric Manager. Please restart the Fabric Manager Server to correct this.";
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        }
        catch (Exception e) {
            String logMsg = "Failed to restart the KMC service in Fabric Manager. Please restart the Fabric Manager Server to correct this.";
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public KMCStatusEnum getNonSecureKMCStatus() {
        KMCStatusEnum status = KMCStatusEnum.None;
        CKMCMgrMMBean ckmc = null;
        ObjectName obj = null;
        try {
            obj = new ObjectName("dcm:service=CKMCManager");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ckmc = MBeanServerInvocationHandler.newProxyInstance(server, obj, CKMCMgrMMBean.class, false);
            if (ckmc != null) {
                status = ckmc.isNonSecureKMCRunning() ? KMCStatusEnum.Running : KMCStatusEnum.Stopped;
            }
        }
        catch (Exception e) {
            String logMsg = "Failed to communicate with KMC service in Fabric Manager. Please restart the Fabric Manager Server to correct this.";
            _Logger.warn((Object)(logMsg + e.getMessage()));
        }
        return status;
    }

    @Override
    public KMCStatusEnum getSecureKMCStatus() {
        KMCStatusEnum status = KMCStatusEnum.None;
        CKMCMgrMMBean ckmc = null;
        ObjectName obj = null;
        try {
            obj = new ObjectName("dcm:service=CKMCManager");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ckmc = MBeanServerInvocationHandler.newProxyInstance(server, obj, CKMCMgrMMBean.class, false);
            if (ckmc != null) {
                status = ckmc.isSecureKMCRunning() ? KMCStatusEnum.Running : KMCStatusEnum.Stopped;
            }
        }
        catch (Exception e) {
            String logMsg = "Failed to communicate with KMC service in Fabric Manager. Please restart the Fabric Manager Server to correct this.";
            _Logger.warn((Object)(logMsg + e.getMessage()));
        }
        return status;
    }

    @Override
    public String getPrimaryKMCServer() {
        Config conf = Config.getInstance();
        return conf.getPrimaryKMCAddr();
    }

    @Override
    public String getSecondaryKMCServer() {
        Config conf = Config.getInstance();
        return conf.getSecondaryKMCAddr();
    }

    @Override
    public OperationStatus setPrimaryKMCServer(String primaryKMCIPAddr) {
        Config conf = Config.getInstance();
        conf.setPrimaryKMCAddr(primaryKMCIPAddr);
        OperationStatus ret = conf.saveConfig();
        if (ret.getStatus() != OperationStatusEnum.Success) {
            _Logger.warn((Object)"Failed to save Primary KMC IP address");
        }
        return ret;
    }

    @Override
    public OperationStatus setSecondaryKMCServer(String secondaryKMCIPAddr) {
        Config conf = Config.getInstance();
        conf.setSecondaryKMCAddr(secondaryKMCIPAddr);
        OperationStatus ret = conf.saveConfig();
        if (ret.getStatus() != OperationStatusEnum.Success) {
            _Logger.warn((Object)"Failed to save Secondary KMC IP address");
        }
        return ret;
    }

    @Override
    public String getPeerKMC() {
        Config conf = Config.getInstance();
        String kmcServerType = conf.getKmcServerType();
        if (kmcServerType != null) {
            if (kmcServerType.equalsIgnoreCase("Primary")) {
                return conf.getSecondaryKMCAddr();
            }
            return conf.getPrimaryKMCAddr();
        }
        return null;
    }

    @Override
    public boolean isKMCPrimary() {
        Config conf = Config.getInstance();
        String kmcServerType = conf.getKmcServerType();
        if (kmcServerType != null) {
            return kmcServerType.equalsIgnoreCase("Primary");
        }
        return false;
    }

    @Override
    public boolean isKMCSecure() {
        Config conf = Config.getInstance();
        return conf.getKmcServerCertFileName() != null && conf.getKmcServerCertFileName().length() > 0;
    }
}

