/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.ejb.impl;

import com.cisco.dcbu.sme.ckmc.ejb.api.ClusterMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.KeyMgrFacade;
import com.cisco.dcbu.sme.ckmc.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.ckmc.entity.Cluster;
import com.cisco.dcbu.sme.ckmc.entity.ClusterAttributes;
import com.cisco.dcbu.sme.ckmc.entity.ClusterSmartcard;
import com.cisco.dcbu.sme.ckmc.entity.pk.ClusterPK;
import com.cisco.dcbu.sme.ckmc.entity.pk.ClusterSmartcardPK;
import com.cisco.dcbu.sme.common.CKMCClusterStateEnum;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterLockEnum;
import com.cisco.dcbu.sme.common.ClusterModeEnum;
import com.cisco.dcbu.sme.common.ClusterRecoveryShareInfo;
import com.cisco.dcbu.sme.common.ClusterSmartcardInfo;
import com.cisco.dcbu.sme.common.ClusterSourceEnum;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.ClusterTypeEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.tree.ClusterTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Stateless
public class ClusterMgrCKMCBean
extends MgrHelper
implements Serializable,
ClusterMgrCKMC {
    @PersistenceContext(unitName="sme")
    private EntityManager manager;
    private KeyMgrFacade keyBean;
    static Logger _Logger = Logger.getLogger((String)"KMC");

    @EJB
    public void setModelBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setKeyMgrFacadeBean(KeyMgrFacade keyBean) {
        this.keyBean = keyBean;
    }

    public void setClusterBean() {
        this.clusterBean = this;
    }

    @Override
    public OperationStatus updateClusterCKMCState(String clusterName, String clusterId, CKMCClusterStateEnum state) {
        OperationStatus ret = new OperationStatus();
        ClusterPK pk = new ClusterPK(clusterName);
        Cluster cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk);
        if (cluster != null) {
            cluster.setCkmcState(state);
            try {
                this.manager.persist((Object)cluster);
                ret.set(OperationStatusEnum.Success, "Success");
            }
            catch (Exception e) {
                ret.set(OperationStatusEnum.Failure, e.getMessage());
            }
        } else {
            ret = this.addCluster(clusterName, clusterId, ClusterStatusEnum.Online, state);
        }
        return ret;
    }

    @Override
    public OperationStatus updateClusterCKMCMasterIPAddress(String clusterName, String clusterId, String masterIPAddr) {
        OperationStatus ret = new OperationStatus();
        ClusterPK pk = new ClusterPK(clusterName);
        Cluster cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk);
        if (cluster == null) {
            ret = this.addCluster(clusterName, clusterId, ClusterStatusEnum.Online, CKMCClusterStateEnum.Init_Received);
        }
        if ((cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk)) != null) {
            cluster.setMasterIPAddr(masterIPAddr);
            try {
                this.manager.persist((Object)cluster);
                ret.set(OperationStatusEnum.Success, "Success");
            }
            catch (Exception e) {
                ret.set(OperationStatusEnum.Failure, e.getMessage());
            }
        }
        return ret;
    }

    @Override
    public OperationStatus addCluster(String clusterName, String clusterId, ClusterStatusEnum status, CKMCClusterStateEnum state) {
        OperationStatus ret = new OperationStatus();
        ClusterPK pk = new ClusterPK(clusterName);
        Cluster cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk);
        if (cluster == null) {
            cluster = new Cluster();
            pk = new ClusterPK();
            cluster.setPk(pk);
            cluster.setClusterName(clusterName);
            cluster.setClusterId(clusterId);
            cluster.setStatus(status);
            cluster.setCkmcState(state);
            try {
                this.manager.persist((Object)cluster);
                ret.setStatus(OperationStatusEnum.Success);
            }
            catch (Exception e) {
                ret.set(OperationStatusEnum.Failure, e.getMessage());
            }
        } else if (clusterId.equals(cluster.getClusterId())) {
            ret.setStatus(OperationStatusEnum.Success);
        } else {
            String logMsg = "Failed to add Cluster " + clusterName + " to the KMC database as same cluster with Cluster Id " + cluster.getClusterId() + " already exists in KMC database";
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.error((Object)logMsg);
        }
        return ret;
    }

    @Override
    public OperationStatus addClusterAttributes(ClusterInfo clusterInfo) {
        OperationStatus ret = new OperationStatus();
        _Logger.debug((Object)("Adding cluster attributes for: " + clusterInfo.getClusterName() + " mode: " + (Object)((Object)clusterInfo.getMode()) + " recovery: " + clusterInfo.getRecoverySchemeThreshold() + "/" + clusterInfo.getRecoverySchemeTotal() + " type: " + (Object)((Object)clusterInfo.getType())));
        if (clusterInfo.getRecoverySchemeThreshold() == 0) {
            ret.setStatus(OperationStatusEnum.Success);
            return ret;
        }
        ClusterPK pk = new ClusterPK(clusterInfo.getClusterName());
        ClusterAttributes attributes = (ClusterAttributes)this.manager.find(ClusterAttributes.class, (Object)pk);
        if (attributes == null) {
            attributes = new ClusterAttributes();
            attributes.setPk(pk);
            attributes.setRecoveryThreshold(clusterInfo.getRecoverySchemeThreshold());
            attributes.setRecoveryTotal(clusterInfo.getRecoverySchemeTotal());
            attributes.setSecurityMode(clusterInfo.getMode());
            attributes.setCapability(clusterInfo.getType().ordinal());
            try {
                this.manager.persist((Object)attributes);
                ret.setStatus(OperationStatusEnum.Success);
            }
            catch (Exception e) {
                ret.set(OperationStatusEnum.Failure, e.getMessage());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Success);
        }
        return ret;
    }

    @Override
    public OperationStatus setClusterLock(String clusterName, ClusterLockEnum lockState) {
        OperationStatus ret = new OperationStatus();
        ClusterPK pk = new ClusterPK(clusterName);
        ClusterAttributes attributes = (ClusterAttributes)this.manager.find(ClusterAttributes.class, (Object)pk);
        if (attributes != null) {
            attributes.setLock(lockState.ordinal());
            this.manager.persist((Object)attributes);
        }
        return ret;
    }

    @Override
    public OperationStatus addClusterAttributes(String clusterName, ClusterModeEnum mode, int threshold, int total) {
        OperationStatus ret = new OperationStatus();
        _Logger.debug((Object)("Adding cluster attributes for: " + clusterName + " mode: " + (Object)((Object)mode) + " recovery: " + threshold + "/" + total));
        ClusterPK pk = new ClusterPK(clusterName);
        ClusterAttributes attributes = (ClusterAttributes)this.manager.find(ClusterAttributes.class, (Object)pk);
        if (attributes == null) {
            attributes = new ClusterAttributes();
            attributes.setPk(pk);
            attributes.setRecoveryThreshold(threshold);
            attributes.setRecoveryTotal(total);
            attributes.setSecurityMode(mode);
            try {
                this.manager.persist((Object)attributes);
                ret.setStatus(OperationStatusEnum.Success);
            }
            catch (Exception e) {
                ret.set(OperationStatusEnum.Failure, e.getMessage());
            }
        } else {
            ret.setStatus(OperationStatusEnum.Success);
        }
        return ret;
    }

    @Override
    public ClusterInfo getClusterInfo(String clusterName) {
        ClusterAttributes attributes;
        ClusterPK pk = new ClusterPK(clusterName);
        Cluster cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk);
        ClusterInfo clusterInfo = new ClusterInfo();
        if (cluster != null) {
            clusterInfo.setClusterId(cluster.getClusterId());
            clusterInfo.setClusterName(cluster.getClusterName());
            clusterInfo.setStatus(cluster.getStatus());
            clusterInfo.setCkmcState(cluster.getCkmcState());
            clusterInfo.setMasterIPAddr(cluster.getMasterIPAddr());
            clusterInfo.setSource(ClusterSourceEnum.KMC);
        }
        if ((attributes = (ClusterAttributes)this.manager.find(ClusterAttributes.class, (Object)pk)) != null) {
            clusterInfo.setMode(attributes.getSecurityMode());
            clusterInfo.setRecoverySchemeThreshold(attributes.getRecoveryThreshold());
            clusterInfo.setRecoverySchemeTotal(attributes.getRecoveryTotal());
            clusterInfo.setType(ClusterTypeEnum.map(attributes.getCapability()));
            clusterInfo.setLockState(ClusterLockEnum.map(attributes.getLock()));
        }
        return clusterInfo;
    }

    @Override
    public OperationStatus deleteCluster(SMEContext ctx, String clusterName) {
        OperationStatus ret = new OperationStatus();
        ClusterPK pk = new ClusterPK(clusterName);
        Cluster cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk);
        ClusterAttributes attributes = (ClusterAttributes)this.manager.find(ClusterAttributes.class, (Object)pk);
        try {
            this.manager.remove((Object)cluster);
            if (attributes != null) {
                this.manager.remove((Object)attributes);
            }
            if ((ret = this.deleteAllSmartcards(clusterName)).getStatus() != OperationStatusEnum.Success) {
                String logMsg = "Successfully deleted an offline cluster: " + clusterName + ". However, failed to delete smarcard infomation.";
                ret.set(OperationStatusEnum.Success, logMsg);
                _Logger.info((Object)logMsg);
            }
            ret.setStatus(OperationStatusEnum.Success);
            _Logger.info((Object)("Successfully deleted an offline cluster: " + clusterName));
        }
        catch (Exception e) {
            String logMsg = "Failed to delete an offline cluster: " + clusterName + " Error: " + e.getMessage();
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    @Override
    public ArrayList<ClusterTreeNode> getClusterTreeNodes(SMEContext ctx, ArrayList<ClusterTreeNode> onlineClusters) {
        List clusters = this.manager.createQuery("from Cluster c").getResultList();
        boolean isClusterOnline = false;
        Iterator it = clusters.iterator();
        ArrayList<ClusterTreeNode> clusternodes = new ArrayList<ClusterTreeNode>();
        while (it.hasNext()) {
            isClusterOnline = false;
            Cluster cluster = (Cluster)it.next();
            ClusterTreeNode c = new ClusterTreeNode();
            for (ClusterTreeNode cn : onlineClusters) {
                if (!cn.getClusterName().equalsIgnoreCase(cluster.getClusterName())) continue;
                isClusterOnline = true;
                break;
            }
            if (isClusterOnline) continue;
            c.setClusterId(cluster.getClusterId());
            c.setClusterName(cluster.getClusterName());
            c.setStatus(cluster.getStatus());
            c.setMasterIPAddr(cluster.getMasterIPAddr());
            c.setSource(ClusterSourceEnum.KMC);
            clusternodes.add(c);
        }
        return clusternodes;
    }

    @Override
    public OperationStatus updateSmartcard(String userName, ClusterRecoveryShareInfo shareInfo) {
        OperationStatus ret = new OperationStatus();
        ClusterSmartcardPK pk = new ClusterSmartcardPK(shareInfo.getClusterName(), shareInfo.getMasterKeyGUID(), shareInfo.getMasterKeyVersion(), shareInfo.getRecoveryShareVersion(), shareInfo.getShareIndex());
        ClusterSmartcard clusterSmartcard = (ClusterSmartcard)this.manager.find(ClusterSmartcard.class, (Object)pk);
        if (clusterSmartcard != null) {
            clusterSmartcard.setSmartcardLabel(shareInfo.getSmartcardLabel());
            clusterSmartcard.setSmartcardSerialNumber(shareInfo.getSmartcardSerialNumber());
            clusterSmartcard.setUserName(userName);
        } else {
            clusterSmartcard = new ClusterSmartcard();
            clusterSmartcard.setPk(pk);
            clusterSmartcard.setSmartcardLabel(shareInfo.getSmartcardLabel());
            clusterSmartcard.setSmartcardSerialNumber(shareInfo.getSmartcardSerialNumber());
            clusterSmartcard.setUserName(userName);
        }
        try {
            this.manager.persist((Object)clusterSmartcard);
            ret.set(OperationStatusEnum.Success, "Success");
        }
        catch (Exception e) {
            ret.set(OperationStatusEnum.Failure, e.getMessage());
        }
        return ret;
    }

    @Override
    public ArrayList<ClusterSmartcardInfo> getClusterSmarcardInfo(String clusterName, String masterKeyGuid) {
        _Logger.debug((Object)("ClusterMgrCKMC - get smartcard infomation for " + clusterName));
        Query q = this.manager.createNamedQuery("getClusterSmartcards");
        q.setParameter("clusterName", (Object)clusterName);
        List smartcards = q.getResultList();
        Iterator itKeys = smartcards.iterator();
        ArrayList<ClusterSmartcardInfo> clusterSmartcards = new ArrayList<ClusterSmartcardInfo>();
        while (itKeys.hasNext()) {
            ClusterSmartcard sc = (ClusterSmartcard)itKeys.next();
            if (sc != null) {
                ClusterSmartcardInfo csi = new ClusterSmartcardInfo();
                csi.setClusterName(sc.getClusterName());
                csi.setMasterKeyGUID(sc.getMasterKeyGUID());
                if (masterKeyGuid != null && masterKeyGuid.equals(sc.getMasterKeyGUID())) {
                    csi.setActive(true);
                } else {
                    csi.setActive(false);
                }
                csi.setMasterKeyVersion(sc.getMasterKeyVersion());
                csi.setRecoveryShareVersion(sc.getRecoveryShareVersion());
                csi.setShareIndex(sc.getShareIndex());
                csi.setSmartcardLabel(sc.getSmartcardLabel());
                csi.setSmartcardSerialNumber(sc.getSmartcardSerialNumber());
                csi.setUserName(sc.getUserName());
                clusterSmartcards.add(csi);
                continue;
            }
            _Logger.info((Object)("Failed to get smartcards for cluster " + clusterName));
        }
        return clusterSmartcards;
    }

    private OperationStatus deleteAllSmartcards(String clusterName) {
        OperationStatus ret = new OperationStatus();
        _Logger.debug((Object)("ClusterMgrCKMC - delete smartcard infomation for " + clusterName));
        Query q = this.manager.createNamedQuery("getClusterSmartcards");
        q.setParameter("clusterName", (Object)clusterName);
        List smartcards = q.getResultList();
        for (ClusterSmartcard sc : smartcards) {
            try {
                this.manager.remove((Object)sc);
            }
            catch (Exception e) {
                String logMsg = "Failed to delete smartcard for cluster " + clusterName + " Exception: " + e.getMessage();
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.info((Object)logMsg);
                return ret;
            }
        }
        ret.setStatus(OperationStatusEnum.Success);
        return ret;
    }

    @Override
    public OperationStatus deleteAllClusters() {
        _Logger.debug((Object)"Delete all clusters");
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        Query q = this.manager.createNamedQuery("deleteAllClusters");
        try {
            q.executeUpdate();
            ret.setStatus(OperationStatusEnum.Success);
        }
        catch (Exception e) {
            ret.set(OperationStatusEnum.Failure, e.getMessage());
        }
        return ret;
    }

    @Override
    public OperationStatus archiveCluster(SMEContext ctx, String clusterName) {
        OperationStatus ret = new OperationStatus();
        ClusterPK pk = new ClusterPK(clusterName);
        Cluster cluster = (Cluster)this.manager.find(Cluster.class, (Object)pk);
        if (cluster != null) {
            cluster.setStatus(ClusterStatusEnum.Archived);
            cluster.setMasterIPAddr(null);
            try {
                this.manager.persist((Object)cluster);
                ret.set(OperationStatusEnum.Success, "Success");
            }
            catch (Exception e) {
                ret.set(OperationStatusEnum.Failure, e.getMessage());
            }
        } else {
            ret.set(OperationStatusEnum.Success, "Success");
        }
        return ret;
    }
}

