/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.ejb.impl;

import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sme.ckmc.ejb.api.ClusterMgrCKMC;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import org.apache.log4j.Logger;

class MgrHelper {
    static Logger _Logger = Logger.getLogger((String)"SME");
    protected ModelMgr modelBean;
    protected ClusterMgrCKMC clusterBean;

    MgrHelper() {
    }

    protected String getSMEClusterMaster(SMEContext ctx, String clusterName) {
        _Logger.debug((Object)"getClusterMaster - entry");
        String switchIP = null;
        ClusterInfo clusterInfo = this.modelBean.getClusterInfo(ctx, clusterName);
        if (clusterInfo != null) {
            switchIP = clusterInfo.getMasterIPAddr();
        } else {
            _Logger.debug((Object)("Cluster " + clusterName + " does not exists in FM model."));
            clusterInfo = this.clusterBean.getClusterInfo(clusterName);
            if (clusterInfo != null) {
                switchIP = clusterInfo.getMasterIPAddr();
            }
        }
        if (switchIP == null) {
            _Logger.info((Object)("No switch IP address for the cluster " + clusterName + " could be obtained."));
        }
        return switchIP;
    }

    protected CKMCFacade getCKMCBean(String ipAddr) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        if (ipAddr == null) {
            return this.getCKMCBean();
        }
        String rmiPort = System.getProperty("server.port", "4447");
        CKMCFacade ckmcBean = this.getCKMCBean(ipAddr, rmiPort, _useSsl);
        return ckmcBean;
    }

    private CKMCFacade getCKMCBean(String ipAddr, String port, boolean _useSsl) {
        try {
            return (CKMCFacade)EjbRegistry.getInstance().getRemoteService(ipAddr, port, _useSsl, "CKMCFacadeBean", CKMCFacade.class.getName());
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation connecting to " + ipAddr + ":" + port), (Throwable)e);
            return null;
        }
    }

    protected CKMCFacade getCKMCBean() {
        try {
            return EjbRegistry.getInstance().getCKMCFacade();
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation " + e.getMessage()));
            return null;
        }
    }
}

