/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.ejb.impl;

import com.cisco.dcbu.sme.accounting.Accounting;
import com.cisco.dcbu.sme.accounting.AccountingOperationEnum;
import com.cisco.dcbu.sme.accounting.AccountingStatusEnum;
import com.cisco.dcbu.sme.ckmc.ejb.api.KeyMgrFacade;
import com.cisco.dcbu.sme.ckmc.ejb.api.ReplicationConfigMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ReplicationKeyMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ReplicationMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.TapeGroupMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.impl.MgrHelper;
import com.cisco.dcbu.sme.ckmc.entity.ReplicationPendingKey;
import com.cisco.dcbu.sme.ckmc.entity.ReplicationRel;
import com.cisco.dcbu.sme.ckmc.entity.pk.ReplicationPendingKeyPK;
import com.cisco.dcbu.sme.ckmc.entity.pk.ReplicationRelPK;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.ckmc.replication.ReplicationContextFactory;
import com.cisco.dcbu.sme.comm.service.CKMCMgrMMBean;
import com.cisco.dcbu.sme.comm.service.CKMCWorker;
import com.cisco.dcbu.sme.comm.service.CKMCWorkerInterface;
import com.cisco.dcbu.sme.common.ClusterBase;
import com.cisco.dcbu.sme.common.Config;
import com.cisco.dcbu.sme.common.KeyTypeEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.SessionToken;
import com.cisco.dcbu.sme.ejb.api.ModelMgr;
import com.cisco.dcbu.sme.exception.SMEAccountingException;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.message.ReplicationMessage;
import com.cisco.dcbu.sme.replication.ReplicationCtxOperEnum;
import com.cisco.dcbu.sme.replication.ReplicationStatusEnum;
import com.cisco.dcbu.sme.replication.SMEReplicationContext;
import com.cisco.dcbu.sme.replication.SMEReplicationRelationship;
import com.cisco.dcbu.sme.xml.SMECKMCExportReplicatedKeyResp;
import com.cisco.dcbu.sme.xml.SMECKMCImportReplicatedKeyResp;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextData;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextGetResp;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextIndex;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextObject;
import com.cisco.dcbu.sme.xml.SMECKMCReplicationContextSetResp;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyData;
import com.cisco.dcbu.sme.xml.SMEKeyEntity;
import com.cisco.dcbu.sme.xml.SMEKeyStatusEnum;
import com.cisco.dcbu.sme.xml.SMEMessage;
import java.io.ByteArrayInputStream;
import java.lang.management.ManagementFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.TransactionTimeout;

@Stateless
@Remote(value={ReplicationMgr.class})
public class ReplicationMgrBean
extends MgrHelper
implements ReplicationMgr {
    @PersistenceContext(unitName="sme")
    private EntityManager manager;
    private KeyMgrFacade keyBean;
    private ReplicationConfigMgr replicationConfigBean;
    private ReplicationKeyMgr replicationKeyBean;
    private TapeGroupMgrCKMC tapeGroupBean;
    private Accounting accountingBean;
    private static boolean replicationInProgress = false;
    static Logger _Logger = Logger.getLogger((String)"KMC");
    public static final int SME_REPLICATION_ATTEMPTS = 3;

    @EJB
    public void setAccountingBean(Accounting aBean) {
        this.accountingBean = aBean;
    }

    @EJB
    public void setKeyMgrFacadeBean(KeyMgrFacade keyBean) {
        this.keyBean = keyBean;
    }

    @EJB
    public void setReplicationConfigBean(ReplicationConfigMgr replicationConfigBean) {
        this.replicationConfigBean = replicationConfigBean;
    }

    @EJB
    public void setReplicationKeyBean(ReplicationKeyMgr replicationKeyBean) {
        this.replicationKeyBean = replicationKeyBean;
    }

    @EJB
    public void setModelBean(ModelMgr modelBean) {
        this.modelBean = modelBean;
    }

    @EJB
    public void setTapeGroupBean(TapeGroupMgrCKMC tapeGroupBean) {
        this.tapeGroupBean = tapeGroupBean;
    }

    @Override
    public void removeReplicationContext(SMEReplicationContext context) {
        ReplicationContextFactory ctxFactory = ReplicationContextFactory.getInstance();
        if (ctxFactory.replicationCtx(ReplicationCtxOperEnum.GET, context.getClusterName(), null).equals(context)) {
            OperationStatus ret = this.deleteReplicationContext(context);
            if (ret.getStatus() != OperationStatusEnum.Success) {
                _Logger.warn((Object)("Failed to delete the replication context for cluster: " + context.getClusterName() + " guid: " + context.getContextindex()));
            }
            ctxFactory.replicationCtx(ReplicationCtxOperEnum.DELETE, context.getClusterName(), context);
        }
    }

    @Override
    public SMEReplicationContext getReplicationContext(SMEContext ctx, String clusterName, int attempt) {
        ReplicationContextFactory ctxFactory = ReplicationContextFactory.getInstance();
        SMEReplicationContext context = ctxFactory.replicationCtx(ReplicationCtxOperEnum.GET, clusterName, null);
        if (context != null) {
            Config conf = Config.getInstance();
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            if (currentTime.getTime() - context.getTime().getTime() > (long)(conf.getReplicationExpiry() * 60 * 60 * 1000)) {
                _Logger.info((Object)("Replication context for cluster " + clusterName + " expired"));
                this.removeReplicationContext(context);
            }
        } else {
            _Logger.debug((Object)("Replication context for cluster " + clusterName + " not in cache"));
            context = this.createAndGetReplicationContext(ctx, clusterName, attempt);
            if (context != null) {
                ctxFactory.replicationCtx(ReplicationCtxOperEnum.SET, clusterName, context);
            }
            return context;
        }
        _Logger.debug((Object)("Replication context for cluster " + clusterName + " obtained from cache"));
        return context;
    }

    private SMEReplicationContext getNewReplicationContext(String clusterName) {
        SMEReplicationContext context = null;
        ReplicationMessage replicationMessage = new ReplicationMessage();
        String token = SessionToken.get();
        String msgOut = replicationMessage.prepareReplicationContextGetReq(clusterName, token, null);
        String msgIn = null;
        msgIn = this.sendReceiveMessage(clusterName, msgOut, token);
        if (msgIn != null) {
            SMEMessage smeMessage = replicationMessage.parseReplicationContextGetResp(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (replicationMessage.analyzeResponse(smeMessage)) {
                    context = new SMEReplicationContext();
                    SMECKMCReplicationContextGetResp resp = smeMessage.getTable_Data().getCKMC_Replication_Context_Get_Resp();
                    SMECKMCReplicationContextObject repCtxObj = resp.getContext();
                    SMECKMCReplicationContextIndex index = repCtxObj.getIndex();
                    SMECKMCReplicationContextData data = repCtxObj.getData();
                    context.setClusterName(index.getCluster_Name());
                    context.setContextindex(index.getID().toString());
                    context.setPubkey(data.getCert().getCert());
                    _Logger.info((Object)("Got replication context for cluster " + clusterName + " context index " + context.getContextindex()));
                }
            }
            catch (SMEException se) {
                _Logger.warn((Object)("Failed to get replication context for cluster " + clusterName + ". Error: " + se.getMessage()));
            }
        } else {
            _Logger.warn((Object)("Failed to get replication context for cluster " + clusterName + ". Unable to communicate with switch."));
        }
        return context;
    }

    private OperationStatus deleteReplicationContext(SMEReplicationContext replicationCtx) {
        OperationStatus ret = new OperationStatus();
        ReplicationMessage replicationMessage = new ReplicationMessage();
        String clusterName = replicationCtx.getClusterName();
        String id = replicationCtx.getContextindex();
        String token = SessionToken.get();
        String msgOut = replicationMessage.prepareDeleteReplicationContextSetReq(clusterName, replicationCtx, token);
        String msgIn = null;
        msgIn = this.sendReceiveMessage(clusterName, msgOut, token);
        if (msgIn != null) {
            SMEMessage smeMessage = replicationMessage.parseDeleteReplicationContextSetResp(new ByteArrayInputStream(msgIn.getBytes()));
            try {
                if (replicationMessage.analyzeResponse(smeMessage)) {
                    String logMsg = "Successfully deleted replication context for cluster " + clusterName + " context index " + id;
                    ret.set(OperationStatusEnum.Success, logMsg);
                    _Logger.info((Object)logMsg);
                }
            }
            catch (SMEException se) {
                String logMsg = "Failed to delete replication context for cluster " + clusterName + " context index " + id + ". Error: " + se.getMessage();
                ret.set(OperationStatusEnum.Failure, logMsg);
                _Logger.warn((Object)logMsg);
            }
        } else {
            String logMsg = "Failed to get replication context for cluster " + clusterName + " context index " + id + ". Unable to communicate with switch.";
            ret.set(OperationStatusEnum.Failure, logMsg);
            _Logger.warn((Object)logMsg);
        }
        return ret;
    }

    private SMEReplicationContext createAndGetReplicationContext(SMEContext ctx, String clusterName, int attempt) {
        SMEReplicationContext context;
        block10: {
            context = null;
            ReplicationMessage replicationMessage = new ReplicationMessage();
            String token = SessionToken.get();
            String msgOut = replicationMessage.prepareCreateReplicationContextSetReq(clusterName, token);
            String msgIn = null;
            msgIn = this.sendReceiveMessage(clusterName, msgOut, token);
            if (msgIn != null) {
                SMEMessage smeMessage = replicationMessage.parseCreateReplicationContextSetResp(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!replicationMessage.analyzeResponse(smeMessage)) break block10;
                    context = new SMEReplicationContext();
                    SMECKMCReplicationContextSetResp resp = smeMessage.getTable_Data().getCKMC_Replication_Context_Set_Resp();
                    SMECKMCReplicationContextObject repCtxObj = resp.getContext();
                    SMECKMCReplicationContextIndex index = repCtxObj.getIndex();
                    SMECKMCReplicationContextData data = repCtxObj.getData();
                    context.setClusterName(index.getCluster_Name());
                    context.setContextindex(index.getID().toString());
                    context.setPubkey(data.getCert().getCert());
                    context.setTime(new Timestamp(System.currentTimeMillis()));
                    String logMsg = "Got replication context for cluster " + clusterName + " context index " + context.getContextindex();
                    _Logger.info((Object)logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", clusterName, null, AccountingOperationEnum.GET_REPLICATION_CTX, AccountingStatusEnum.SUCCESS, "cluster %s index: %s", clusterName, context.getContextindex());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
                catch (SMEException se) {
                    String logMsg = "Failed to create replication context for cluster " + clusterName + " attempt: " + attempt + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", clusterName, null, AccountingOperationEnum.GET_REPLICATION_CTX, AccountingStatusEnum.FAILURE, "cluster %s attempt: %s. Error: %s", clusterName, attempt, se.getMessage());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
            } else {
                String logMsg = "Failed to create replication context for cluster " + clusterName + " attempt: " + attempt + ". Error: Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                try {
                    this.accountingBean.log(ctx, "KMC", clusterName, null, AccountingOperationEnum.GET_REPLICATION_CTX, AccountingStatusEnum.FAILURE, "cluster %s attempt: %s. Error: %s", clusterName, attempt, "Unable to communicate with switch");
                }
                catch (SMEAccountingException e) {
                    _Logger.error((Object)("Failed to log event: " + logMsg));
                }
            }
        }
        return context;
    }

    @Override
    public SMEKey exportReplicatedKey(SMEContext ctx, String guid, SMEReplicationContext replicationCtx, SMEReplicationRelationship relation, int attempt) {
        SMEKey xKey;
        block19: {
            ReplicationPendingKey keyToReplicate = this.replicationKeyBean.getPendingKey(null, relation, guid);
            if (keyToReplicate == null) {
                _Logger.warn((Object)("Key Guid: " + guid + " not found in pending list for cluster " + relation.getSourceClusterName()));
                return null;
            }
            xKey = new SMEKey();
            SMEKey key = this.keyBean.getKey(null, keyToReplicate.getSourceClusterName(), keyToReplicate.getGuid());
            if (key == null) {
                OperationStatus deletePendingStatus;
                String logMsg = "Key Guid: " + keyToReplicate.getGuid() + " not found in KMC for cluster " + relation.getSourceClusterName();
                _Logger.warn((Object)logMsg);
                try {
                    this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.EXPORT_REPLICATED_KEY, AccountingStatusEnum.FAILURE, "Guid: %s from cluster %s for cluster %s attempt: %s. Error: %s", keyToReplicate.getGuid(), relation.getSourceClusterName(), relation.getDestClusterName(), attempt, "Key not found");
                }
                catch (SMEAccountingException e) {
                    _Logger.error((Object)("Failed to log event: " + logMsg));
                }
                OperationStatus errorKeyStatus = this.replicationKeyBean.moveToErrorKey(null, guid, relation, logMsg);
                if (errorKeyStatus.getStatus() == OperationStatusEnum.Success && (deletePendingStatus = this.replicationKeyBean.deletePendingKey(null, relation, keyToReplicate.getGuid())) != null && deletePendingStatus.getStatus() != OperationStatusEnum.Success) {
                    _Logger.warn((Object)("Failed to remove pending replication key Guid: " + keyToReplicate.getGuid() + " for cluster " + relation.getDestClusterName()));
                }
                return null;
            }
            SMEKey wrapKey = this.keyBean.getKey(null, keyToReplicate.getSourceClusterName(), key.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data().getWrapped_By_GUID());
            if (wrapKey == null) {
                OperationStatus deletePendingStatus;
                String logMsg = "Wrap Key Guid: " + key.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data().getWrapped_By_GUID() + " not found in KMC for cluster " + relation.getSourceClusterName();
                _Logger.warn((Object)logMsg);
                try {
                    this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.EXPORT_REPLICATED_KEY, AccountingStatusEnum.FAILURE, "Guid: %s from cluster %s for cluster %s attempt: %s. Error: %s", key.getData().getKey_Data().getEncrypted_Data().getSymmetric_Key_Data().getWrapped_By_GUID(), relation.getSourceClusterName(), relation.getDestClusterName(), attempt, "Wrap Key not found");
                }
                catch (SMEAccountingException e) {
                    _Logger.error((Object)("Failed to log event: " + logMsg));
                }
                OperationStatus errorWrapKeyStatus = this.replicationKeyBean.moveToErrorKey(null, guid, relation, logMsg);
                if (errorWrapKeyStatus.getStatus() == OperationStatusEnum.Success && (deletePendingStatus = this.replicationKeyBean.deletePendingKey(null, relation, keyToReplicate.getGuid())) != null && deletePendingStatus.getStatus() != OperationStatusEnum.Success) {
                    _Logger.warn((Object)("Failed to remove pending replication key Guid: " + keyToReplicate.getGuid() + " for cluster " + relation.getDestClusterName()));
                }
                return null;
            }
            ReplicationMessage replicationMessage = new ReplicationMessage();
            String token = SessionToken.get();
            String msgOut = replicationMessage.prepareExportReplicatedKeyReq(relation.getSourceClusterName(), token, relation, replicationCtx, key, wrapKey);
            String msgIn = null;
            msgIn = this.sendReceiveMessage(relation.getSourceClusterName(), msgOut, token);
            if (msgIn != null) {
                SMEMessage smeMessage = replicationMessage.parseExportReplicatedKeyResp(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!replicationMessage.analyzeResponse(smeMessage)) break block19;
                    SMECKMCExportReplicatedKeyResp resp = smeMessage.getTable_Data().getCKMC_Export_Replicated_Key_Resp();
                    xKey = resp.getKey_Object();
                    String logMsg = "Successfully exported of transalated key " + key.getIndex().getGUID() + " from cluster " + relation.getSourceClusterName();
                    _Logger.info((Object)logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.EXPORT_REPLICATED_KEY, AccountingStatusEnum.SUCCESS, "Guid: %s from cluster %s for cluster %s", keyToReplicate.getGuid(), relation.getSourceClusterName(), relation.getDestClusterName());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
                catch (SMEException se) {
                    String logMsg = "Failed to export of transalated key " + key.getIndex().getGUID() + " from cluster " + relation.getSourceClusterName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.EXPORT_REPLICATED_KEY, AccountingStatusEnum.FAILURE, "Guid: %s from cluster %s for cluster %s attempt: %s. Error: %s", keyToReplicate.getGuid(), relation.getSourceClusterName(), relation.getDestClusterName(), attempt, se.getMessage());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
            } else {
                String logMsg = "Failed to get of transalated key " + key.getIndex().getGUID() + " from cluster " + relation.getSourceClusterName() + ". Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                try {
                    this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.EXPORT_REPLICATED_KEY, AccountingStatusEnum.FAILURE, "Guid: %s from cluster %s for cluster %s attempt: %s. Error: %s", keyToReplicate.getGuid(), relation.getSourceClusterName(), relation.getDestClusterName(), attempt, ". Unable to communicate with switch.");
                }
                catch (SMEAccountingException e) {
                    _Logger.error((Object)("Failed to log event: " + logMsg));
                }
            }
        }
        return xKey;
    }

    @Override
    public OperationStatus importReplicatedKey(SMEContext ctx, SMEKey key, SMEReplicationContext replicationCtx, SMEReplicationRelationship relation) {
        OperationStatus ret;
        block23: {
            ret = new OperationStatus();
            SMEKey xKey = null;
            ArrayList<SMEKey> wrapKeyObjectList = null;
            switch (key.getData().getKey_Type()) {
                case KEY___TYPE___TAPE___VOLUME___KEY: 
                case KEY___TYPE___TAPE___VOLUMEGROUP___SHARED___KEY: {
                    String entity = relation.getDestClusterName() + ":" + relation.getDestTapeGroupName() + ":" + relation.getDestTapeVolumeGroupName();
                    wrapKeyObjectList = this.keyBean.getKeysbyExactEntity(entity, KeyTypeEnum.TapeVolumeGroupWrapKey);
                    break;
                }
                case KEY___TYPE___TAPE___VOLUMEGROUP___WRAP___KEY: {
                    wrapKeyObjectList = this.keyBean.getKeysbyExactEntity(relation.getDestClusterName(), KeyTypeEnum.MasterKey);
                    break;
                }
                default: {
                    String logMsg = "Invalid Key Type for replicating key";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    return ret;
                }
            }
            if (wrapKeyObjectList.size() == 0) {
                String logMsg = "No Wrap keys available in KMC for the cluster";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
                return ret;
            }
            SMEKey wrapKey = null;
            for (SMEKey wrap : wrapKeyObjectList) {
                if (wrap.getData().getStatus() != SMEKeyStatusEnum.SME___KEY___ACTIVE) continue;
                wrapKey = wrap;
                break;
            }
            if (wrapKey == null) {
                wrapKey = wrapKeyObjectList.get(wrapKeyObjectList.size() - 1);
            }
            ReplicationMessage replicationMessage = new ReplicationMessage();
            String token = SessionToken.get();
            String msgOut = replicationMessage.prepareImportReplicatedKeyReq(relation.getDestClusterName(), token, relation, replicationCtx, key, wrapKey);
            String msgIn = null;
            msgIn = this.sendReceiveMessage(relation.getDestClusterName(), msgOut, token);
            if (msgIn != null) {
                SMEMessage smeMessage = replicationMessage.parseImportReplicatedKeyResp(new ByteArrayInputStream(msgIn.getBytes()));
                try {
                    if (!replicationMessage.analyzeResponse(smeMessage)) break block23;
                    SMECKMCImportReplicatedKeyResp resp = smeMessage.getTable_Data().getCKMC_Import_Replicated_Key_Resp();
                    xKey = resp.getKey_Object();
                    SMEKey ckey = this.keyBean.getKeysbyClonedFromGUID(relation.getDestClusterName(), key.getIndex().getGUID());
                    if (ckey != null) {
                        String logMsg = "Key " + key.getIndex().getGUID() + "was already replicated in cluster " + relation.getDestClusterName() + ". Key Not replicated.";
                        _Logger.warn((Object)logMsg);
                        ret.set(OperationStatusEnum.Success, logMsg);
                        try {
                            this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.REPLICATED_KEY, AccountingStatusEnum.FAILURE, " guid: %s from source cluster: %s to destination cluster %s Error: %s", key.getIndex().getGUID(), relation.getSourceClusterName(), relation.getDestClusterName(), ". Error: Key was already replicated in cluster");
                        }
                        catch (SMEAccountingException e) {
                            _Logger.error((Object)("Failed to log event: " + logMsg));
                        }
                        return ret;
                    }
                    ret = this.storeImportedKey(xKey);
                    if (ret.getStatus() == OperationStatusEnum.Success) {
                        String logMsg = "Successfully imported a transalated key " + xKey.getIndex().getGUID() + " to cluster " + relation.getDestClusterName();
                        _Logger.info((Object)logMsg);
                        ret.set(OperationStatusEnum.Success, logMsg);
                        try {
                            this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.REPLICATED_KEY, AccountingStatusEnum.SUCCESS, " guid: %s from source cluster: %s to guid %s, destination cluster %s", key.getIndex().getGUID(), relation.getSourceClusterName(), xKey.getIndex().getGUID(), relation.getDestClusterName());
                        }
                        catch (SMEAccountingException e) {
                            _Logger.error((Object)("Failed to log event: " + logMsg));
                        }
                        break block23;
                    }
                    String logMsg = "Failed to import a transalated key " + key.getIndex().getGUID() + " to cluster " + relation.getDestClusterName() + ". Error: Failed to store key in KMC database";
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.REPLICATED_KEY, AccountingStatusEnum.FAILURE, " guid: %s from source cluster: %s to destination cluster %s Error: %s", key.getIndex().getGUID(), relation.getSourceClusterName(), relation.getDestClusterName(), ". Error: Failed to store key in KMC database");
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
                catch (SMEException se) {
                    String logMsg = "Failed to import a transalated key " + key.getIndex().getGUID() + " to cluster " + relation.getDestClusterName() + ". Error: " + se.getMessage();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.REPLICATED_KEY, AccountingStatusEnum.FAILURE, " guid: %s from source cluster: %s to destination cluster %s Error: %s", key.getIndex().getGUID(), relation.getSourceClusterName(), relation.getDestClusterName(), ". Error: " + se.getMessage());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
            } else {
                String logMsg = "Failed to import a transalated key " + key.getIndex().getGUID() + " to cluster " + relation.getDestClusterName() + ". Error: Unable to communicate with switch.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
                try {
                    this.accountingBean.log(ctx, "KMC", relation.getSourceClusterName(), null, AccountingOperationEnum.REPLICATED_KEY, AccountingStatusEnum.FAILURE, " guid: %s from source cluster: %s to destination cluster %s Error: %s", key.getIndex().getGUID(), relation.getSourceClusterName(), relation.getDestClusterName(), ". Error: Unable to communicate with switch.");
                }
                catch (SMEAccountingException e) {
                    _Logger.error((Object)("Failed to log event: " + logMsg));
                }
            }
        }
        return ret;
    }

    private CKMCFacade getActiveCKMC(String clusterName) {
        Config conf = Config.getInstance();
        String primaryKMCipAddr = conf.getPrimaryKMCAddr();
        String secondaryKMCipAddr = conf.getSecondaryKMCAddr();
        CKMCFacade pri = this.getCKMCBean(primaryKMCipAddr);
        CKMCFacade sec = this.getCKMCBean(secondaryKMCipAddr);
        if (pri != null && pri.isClusterConnected(clusterName)) {
            return pri;
        }
        if (sec != null && sec.isClusterConnected(clusterName)) {
            return sec;
        }
        return null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=7200L)
    public OperationStatus replicate(SMEReplicationRelationship relationship) {
        OperationStatus ret = new OperationStatus();
        SMEContext ctx = new SMEContext();
        ClusterBase cluster = new ClusterBase();
        cluster.setClusterName(relationship.getSourceClusterName());
        ctx.setCluster(cluster);
        ReplicationStatusEnum status = this.getReplicationRelationshipStatus(relationship);
        switch (status) {
            case None: {
                String logMsg = "No replication relation found for this replication job.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
                return ret;
            }
            case Created: {
                String logMsg;
                ret = this.queueKeys(relationship);
                if (ret.getStatus() == OperationStatusEnum.Success) {
                    logMsg = "Successfully queued existing keys for replication relationship source cluster: " + relationship.getSourceClusterName() + " source tape group: " + relationship.getSourceTapeGroupName() + " source volume group: " + relationship.getSourceTapeVolumeGroupName() + " destination cluster: " + relationship.getDestClusterName() + " destination tape group: " + relationship.getDestTapeGroupName() + " destination volume group: " + relationship.getDestTapeVolumeGroupName();
                    _Logger.info((Object)logMsg);
                    ret.set(OperationStatusEnum.Success, logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", relationship.getSourceClusterName(), null, AccountingOperationEnum.Q_KEYS_REPLICATION, AccountingStatusEnum.SUCCESS, "source cluster: %s source tape group: %s source volume group: %s  destination cluster: %s destination tape group: %s destination volume group: %s ", relationship.getSourceClusterName(), relationship.getSourceTapeGroupName(), relationship.getSourceTapeVolumeGroupName(), relationship.getDestClusterName(), relationship.getDestTapeGroupName(), relationship.getDestTapeVolumeGroupName());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                } else {
                    logMsg = "Failed to queue existing keys for replication relationship source cluster: " + relationship.getSourceClusterName() + " source tape group: " + relationship.getSourceTapeGroupName() + " source volume group: " + relationship.getSourceTapeVolumeGroupName() + " destination cluster: " + relationship.getDestClusterName() + " destination tape group: " + relationship.getDestTapeGroupName() + " destination volume group: " + relationship.getDestTapeVolumeGroupName() + ret.getDescription();
                    _Logger.warn((Object)logMsg);
                    ret.set(OperationStatusEnum.Failure, logMsg);
                    try {
                        this.accountingBean.log(ctx, "KMC", relationship.getSourceClusterName(), null, AccountingOperationEnum.Q_KEYS_REPLICATION, AccountingStatusEnum.FAILURE, "source cluster: %s source tape group: %s source volume group: %s  destination cluster: %s destination tape group: %s destination volume group: %s error: %s ", relationship.getSourceClusterName(), relationship.getSourceTapeGroupName(), relationship.getSourceTapeVolumeGroupName(), relationship.getDestClusterName(), relationship.getDestTapeGroupName(), relationship.getDestTapeVolumeGroupName(), ret.getDescription());
                    }
                    catch (SMEAccountingException e) {
                        _Logger.error((Object)("Failed to log event: " + logMsg));
                    }
                }
                ret = this.replicationConfigBean.updateReplicationRelationship(relationship, ReplicationStatusEnum.Pending, "Pending");
                if (ret.getStatus() == OperationStatusEnum.Success) {
                    _Logger.info((Object)"Successfully updated status to pending for replication.");
                    break;
                }
                logMsg = "Failed to update the status of replication to pending this replication job.";
                _Logger.warn((Object)logMsg);
                ret.set(OperationStatusEnum.Failure, logMsg);
                break;
            }
            case Pending: 
            case Done: {
                ArrayList<String> guidstoReplicate = this.getKeysToReplicate(relationship);
                if (guidstoReplicate.size() > 0) {
                    CKMCFacade srcCKMC = this.getActiveCKMC(relationship.getSourceClusterName());
                    if (srcCKMC == null) {
                        String logMsg = "Failed to connect to KMC where Source Cluster " + relationship.getSourceClusterName() + " is connected to";
                        _Logger.warn((Object)logMsg);
                        ret.set(OperationStatusEnum.Failure, logMsg);
                        return ret;
                    }
                    CKMCFacade destCKMC = this.getActiveCKMC(relationship.getDestClusterName());
                    if (destCKMC == null) {
                        String logMsg = "Failed to connect to KMC where destination Cluster " + relationship.getSourceClusterName() + " is connected to";
                        _Logger.warn((Object)logMsg);
                        ret.set(OperationStatusEnum.Failure, logMsg);
                        return ret;
                    }
                    for (String guid : guidstoReplicate) {
                        this.replicateKey(ctx, guid, relationship, srcCKMC, destCKMC);
                    }
                }
                ret.set(OperationStatusEnum.Success, "Success");
                break;
            }
        }
        return ret;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    private void replicateKey(SMEContext ctx, String guid, SMEReplicationRelationship relationship, CKMCFacade srcCKMC, CKMCFacade destCKMC) {
        boolean done = false;
        int attempt = 0;
        String reason = null;
        String logMsg = null;
        while (!done && attempt < 3) {
            SMEReplicationContext replicationCtx = destCKMC.getReplicationContext(ctx, relationship.getDestClusterName(), ++attempt);
            if (replicationCtx == null) {
                logMsg = "Replication context could not be obtained for cluster " + relationship.getDestClusterName() + " attempt: " + attempt;
                _Logger.warn((Object)logMsg);
                continue;
            }
            SMEKey exportedKey = srcCKMC.exportReplicatedKey(ctx, guid, replicationCtx, relationship, attempt);
            if (exportedKey == null) {
                logMsg = "Failed to export Key Guid: " + guid + " from cluster " + relationship.getSourceClusterName() + " for cluster " + relationship.getDestClusterName() + " attempt: " + attempt;
                _Logger.warn((Object)logMsg);
                continue;
            }
            OperationStatus importStatus = destCKMC.importReplicatedKey(ctx, exportedKey, replicationCtx, relationship);
            if (importStatus != null && importStatus.getStatus() != OperationStatusEnum.Success) {
                destCKMC.removeReplicationContext(replicationCtx);
                continue;
            }
            OperationStatus deletePendingStatus = this.replicationKeyBean.deletePendingKey(null, relationship, guid);
            if (deletePendingStatus != null && deletePendingStatus.getStatus() != OperationStatusEnum.Success) {
                _Logger.warn((Object)("Failed to remove pending replication key Guid: " + guid + " for cluster " + relationship.getDestClusterName()));
                continue;
            }
            done = true;
        }
        if (!done && attempt == 3) {
            OperationStatus deletePendingStatus;
            logMsg = "Failed to replicate Key Guid: " + guid + "source cluster: " + relationship.getSourceClusterName() + " to destination cluster: " + relationship.getDestClusterName() + " Error: Maiximum attempts failed";
            try {
                this.accountingBean.log(ctx, "KMC", relationship.getSourceClusterName(), null, AccountingOperationEnum.REPLICATED_KEY, AccountingStatusEnum.FAILURE, " guid: %s from source cluster: %s to destination cluster %s Error: %s", guid, relationship.getSourceClusterName(), relationship.getDestClusterName(), "Maiximum attempts failed");
            }
            catch (SMEAccountingException e) {
                _Logger.error((Object)("Failed to log event: " + logMsg));
            }
            reason = "Maiximum attempts failed";
            OperationStatus errorKeyStatus = this.replicationKeyBean.moveToErrorKey(null, guid, relationship, reason);
            if (errorKeyStatus.getStatus() == OperationStatusEnum.Success && (deletePendingStatus = this.replicationKeyBean.deletePendingKey(null, relationship, guid)) != null && deletePendingStatus.getStatus() != OperationStatusEnum.Success) {
                _Logger.warn((Object)("Failed to remove pending replication key Guid: " + guid + " for cluster " + relationship.getDestClusterName()));
            }
        }
    }

    private ReplicationStatusEnum getReplicationRelationshipStatus(SMEReplicationRelationship rl) {
        ReplicationStatusEnum status = ReplicationStatusEnum.None;
        ReplicationRelPK pk = new ReplicationRelPK(rl.getSourceClusterName(), rl.getSourceTapeGroupName(), rl.getSourceTapeVolumeGroupName(), rl.getReplicationId());
        ReplicationRel replicationRelation = (ReplicationRel)this.manager.find(ReplicationRel.class, (Object)pk);
        if (replicationRelation != null) {
            status = replicationRelation.getStatus();
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendReceiveMessage(String clusterName, String message, String token) {
        block10: {
            String msgIn = null;
            if (clusterName == null) {
                _Logger.warn((Object)"Clustername not provided to send message routine.");
                return null;
            }
            CKMCWorkerInterface ckmcwi = this.getCKMCTransport(clusterName);
            try {
                if (ckmcwi != null) {
                    CKMCWorkerInterface cKMCWorkerInterface = ckmcwi;
                    synchronized (cKMCWorkerInterface) {
                        OperationStatus sendOS = ckmcwi.send(message, token);
                        if (sendOS.getStatus().equals(OperationStatusEnum.Success)) {
                            ckmcwi.wait(100L);
                            msgIn = ckmcwi.receive(token);
                            Long endTime = System.currentTimeMillis() + 60000L;
                            while (msgIn == null && System.currentTimeMillis() < endTime) {
                                ckmcwi.wait(10000L);
                                msgIn = ckmcwi.receive(token);
                            }
                            if (msgIn == null) {
                                _Logger.warn((Object)"Failed to receive response from switch: Timed out after 5 minutes.");
                                ckmcwi.cancel(token);
                            }
                            return msgIn;
                        }
                        _Logger.warn((Object)("Failed to send message through transport for token " + token));
                        break block10;
                    }
                }
                _Logger.warn((Object)"Failed to send message to switch: Could not get transport.");
            }
            catch (Exception ex) {
                _Logger.warn((Object)("Failed to send message to switch: " + ex.getMessage()));
            }
        }
        return null;
    }

    private CKMCWorkerInterface getCKMCTransport(String clusterName) {
        CKMCMgrMMBean ckmc = null;
        CKMCWorker ckmcwi = null;
        ObjectName obj = null;
        try {
            obj = new ObjectName("sme:service=CKMCManager");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ckmc = MBeanServerInvocationHandler.newProxyInstance(server, obj, CKMCMgrMMBean.class, false);
            if (ckmc != null) {
                ckmcwi = ckmc.getCKMCWorker(clusterName);
            }
            if (ckmcwi != null) {
                return ckmcwi;
            }
            return null;
        }
        catch (Exception e) {
            _Logger.warn((Object)"Failed to send communication.");
            return null;
        }
    }

    private OperationStatus storeImportedKey(SMEKey xkey) {
        Config conf = Config.getInstance();
        if (!conf.isRetainImportedKeyState()) {
            SMEKeyData data = xkey.getData();
            data.setDeletion_Time(data.getCreation_Time());
            data.setStatus(SMEKeyStatusEnum.SME___KEY___ARCHIVED);
            xkey.setData(data);
        }
        SMEContext ctx = new SMEContext();
        ClusterBase cluster = new ClusterBase();
        cluster.setClusterName(xkey.getIndex().getCluster_Name());
        ctx.setCluster(cluster);
        SMEKeyEntity xEntity = xkey.getData().getKey_Entity();
        OperationStatus retKey = new OperationStatus();
        if (xEntity.isSetTape_Volume_Group_Shared_Key()) {
            int version = this.tapeGroupBean.getTapeVolumeGroupSharedVersion(xEntity.getTape_Volume_Group_Shared_Key().getCluster_Name(), xEntity.getTape_Volume_Group_Shared_Key().getTape_BackupGroup_Name(), xEntity.getTape_Volume_Group_Shared_Key().getTape_VolumeGroup_Name());
            if (version >= -1) {
                retKey = this.keyBean.addKey(ctx, xkey, KeyTypeEnum.TapeVolumeGroupSharedKey, version + 1);
            } else {
                retKey.set(OperationStatusEnum.Failure, "Failed to update key " + xkey.getIndex().getGUID() + " for cluster " + ctx.getCluster().getClusterName());
            }
        } else if (xEntity.isSetTape_Volume_Key()) {
            int version = this.tapeGroupBean.getTapeVolumeVersion(xEntity.getTape_Volume_Key().getCluster_Name(), xEntity.getTape_Volume_Key().getTape_BackupGroup_Name(), xEntity.getTape_Volume_Key().getTape_VolumeGroup_Name(), xEntity.getTape_Volume_Key().getBarcode());
            if (version >= -1) {
                retKey = this.keyBean.addKey(ctx, xkey, KeyTypeEnum.TapeVolumeKey, version + 1);
            } else {
                retKey.set(OperationStatusEnum.Failure, "Failed to update key " + xkey.getIndex().getGUID() + " for cluster " + ctx.getCluster().getClusterName());
            }
        } else if (xEntity.isSetTape_Volume_Group_Wrap_Key()) {
            int version = this.tapeGroupBean.getTapeVolumeGroupWrapVersion(xEntity.getTape_Volume_Group_Wrap_Key().getCluster_Name(), xEntity.getTape_Volume_Group_Wrap_Key().getTape_BackupGroup_Name(), xEntity.getTape_Volume_Group_Wrap_Key().getTape_VolumeGroup_Name());
            if (version >= -1) {
                retKey = this.keyBean.addKey(ctx, xkey, KeyTypeEnum.TapeVolumeGroupWrapKey, version + 1);
            } else {
                retKey.set(OperationStatusEnum.Failure, "Failed to update key " + xkey.getIndex().getGUID() + " for cluster " + ctx.getCluster().getClusterName());
            }
        }
        if (retKey.getStatus() != OperationStatusEnum.Success) {
            _Logger.warn((Object)("Failed to update ckmc database for key guid: " + xkey.getIndex().getGUID()));
            return retKey;
        }
        _Logger.info((Object)("Original wrap key guid: " + xkey.getData().getCloned_By_GUID() + ". Imported wrap key guid: " + xkey.getIndex().getGUID()));
        return retKey;
    }

    private OperationStatus queueKeys(SMEReplicationRelationship relationship) {
        OperationStatus ret = new OperationStatus();
        String entityIndex = relationship.getSourceClusterName() + ":" + relationship.getSourceTapeGroupName() + ":" + relationship.getSourceTapeVolumeGroupName();
        try {
            ArrayList<SMEKey> keyList = this.keyBean.getKeysbyEntityWC(entityIndex, KeyTypeEnum.TapeVolumeKey);
            ArrayList<SMEKey> keyListShared = this.keyBean.getKeysbyEntityWC(entityIndex, KeyTypeEnum.TapeVolumeGroupSharedKey);
            keyList.addAll(keyListShared);
            ArrayList<SMEKey> keyListWrapped = this.keyBean.getKeysbyEntityWC(entityIndex, KeyTypeEnum.TapeVolumeGroupWrapKey);
            keyList.addAll(keyListWrapped);
            for (SMEKey key : keyList) {
                ReplicationPendingKeyPK pk = new ReplicationPendingKeyPK(key.getIndex().getGUID(), relationship.getSourceClusterName(), relationship.getDestClusterName(), relationship.getDestTapeGroupName(), relationship.getDestTapeVolumeGroupName());
                ReplicationPendingKey rp = (ReplicationPendingKey)this.manager.find(ReplicationPendingKey.class, (Object)pk);
                if (rp != null) continue;
                rp = new ReplicationPendingKey();
                rp.setPk(pk);
                rp.setSourceTapeGroupName(relationship.getSourceTapeGroupName());
                rp.setSourceTapeVolumeGroupName(relationship.getSourceTapeVolumeGroupName());
                rp.setScheduledReplicationTime(new Timestamp(System.currentTimeMillis()));
                this.manager.persist((Object)rp);
            }
            ret.set(OperationStatusEnum.Success, " Success");
        }
        catch (Exception e) {
            String logMsg = "Failed to queue existing keys for replication. Error: " + e.getMessage();
            _Logger.warn((Object)logMsg);
            ret.set(OperationStatusEnum.Failure, logMsg);
        }
        return ret;
    }

    private ArrayList<String> getKeysToReplicate(SMEReplicationRelationship relationship) {
        ArrayList<String> guids = new ArrayList<String>();
        Query q = this.manager.createNamedQuery("getAllReplicationPending");
        q.setParameter("sourceClusterName", (Object)relationship.getSourceClusterName());
        q.setParameter("sourceTapeGroupName", (Object)relationship.getSourceTapeGroupName());
        q.setParameter("sourceTapeVolumeGroupName", (Object)relationship.getSourceTapeVolumeGroupName());
        q.setParameter("destClusterName", (Object)relationship.getDestClusterName());
        q.setParameter("destTapeGroupName", (Object)relationship.getDestTapeGroupName());
        q.setParameter("destTapeVolumeGroupName", (Object)relationship.getDestTapeVolumeGroupName());
        List pendingList = q.getResultList();
        for (ReplicationPendingKey pending : pendingList) {
            guids.add(pending.getGuid());
        }
        return guids;
    }
}

