/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.ejb.impl;

import com.cisco.dcbu.sme.ckmc.ejb.api.ClusterMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.KeyMgrFacade;
import com.cisco.dcbu.sme.ckmc.ejb.api.SyncDBMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.TapeGroupMgrCKMC;
import com.cisco.dcbu.sme.common.CKMCClusterStateEnum;
import com.cisco.dcbu.sme.common.ClusterModeEnum;
import com.cisco.dcbu.sme.common.ClusterStatusEnum;
import com.cisco.dcbu.sme.common.KeyTypeEnum;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.TapeGroupStatusEnum;
import com.cisco.dcbu.sme.common.TapeVolumeGroupStatusEnum;
import com.cisco.dcbu.sme.xml.SMEKey;
import com.cisco.dcbu.sme.xml.SMEKeyStatusEnum;
import java.io.Serializable;
import java.util.ArrayList;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Stateless
public class SyncDBMgrCKMCBean
implements Serializable,
SyncDBMgrCKMC {
    private KeyMgrFacade keyBean;
    private ClusterMgrCKMC clusterBean;
    private TapeGroupMgrCKMC tapeGroupBean;
    static Logger _Logger = Logger.getLogger((String)"KMC");

    @EJB
    public void setKeyMgrFacadeBean(KeyMgrFacade keyBean) {
        this.keyBean = keyBean;
    }

    @EJB
    public void setClusterCKMCBean(ClusterMgrCKMC clusterBean) {
        this.clusterBean = clusterBean;
    }

    @EJB
    public void setTapeGroupCKMCBean(TapeGroupMgrCKMC tapeGroupBean) {
        this.tapeGroupBean = tapeGroupBean;
    }

    @Override
    public void perform() {
        OperationStatus ret = new OperationStatus();
        _Logger.info((Object)"SYNC - Start synchronizing KMC model database from Key Database");
        ret = this.tapeGroupBean.deleteAllTapeVolumeGroups();
        if (ret.getStatus() != OperationStatusEnum.Success) {
            _Logger.warn((Object)("SYNC - Delete Tape Volume Groups Failed. Error: " + ret.getDescription()));
        }
        if ((ret = this.tapeGroupBean.deleteAllTapeGroups()).getStatus() != OperationStatusEnum.Success) {
            _Logger.warn((Object)("SYNC - Delete Tape Group Failed. Error: " + ret.getDescription()));
        }
        if ((ret = this.clusterBean.deleteAllClusters()).getStatus() != OperationStatusEnum.Success) {
            _Logger.warn((Object)("SYNC - Delete Clusters Failed. Error: " + ret.getDescription()));
        }
        this.syncClusters();
        _Logger.warn((Object)"SYNC - Complete");
    }

    private void syncClusters() {
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        ret.setDescription("success");
        String entityIndex = "";
        ArrayList<SMEKey> masterKeys = this.keyBean.getKeysbyEntityWC(entityIndex, KeyTypeEnum.MasterKey);
        for (SMEKey masterKey : masterKeys) {
            SMEKeyStatusEnum status;
            ClusterStatusEnum clusterStatus;
            String clusterId;
            String clusterName = masterKey.getData().getKey_Entity().getMasterKey_Key().getCluster_Name();
            ret = this.clusterBean.addCluster(clusterName, clusterId = masterKey.getData().getKey_Entity().getMasterKey_Key().getCluster_ID(), clusterStatus = (status = masterKey.getData().getStatus()) == SMEKeyStatusEnum.SME___KEY___ACTIVE ? ClusterStatusEnum.Online : ClusterStatusEnum.Archived, CKMCClusterStateEnum.None);
            if (ret.getStatus() == OperationStatusEnum.Success) {
                this.syncTapeGroups(clusterName);
            } else {
                _Logger.warn((Object)("SYNC - Update Cluster Failed for cluster " + clusterName + " Error: " + ret.getDescription()));
            }
            if ((ret = this.clusterBean.addClusterAttributes(clusterName, ClusterModeEnum.Basic, 1, 1)).getStatus() == OperationStatusEnum.Success) continue;
            _Logger.warn((Object)("SYNC - Update Cluster Attributes Failed for cluster " + clusterName + " Error: " + ret.getDescription()));
        }
    }

    private void syncTapeGroups(String clusterName) {
        TapeGroupStatusEnum tapeGroupStatus = TapeGroupStatusEnum.Archived;
        OperationStatus ret = new OperationStatus();
        ret.setStatus(OperationStatusEnum.Success);
        ret.setDescription("success");
        String entityIndex = clusterName;
        ArrayList<SMEKey> wrapKeys = this.keyBean.getKeysbyEntityWC(entityIndex, KeyTypeEnum.TapeVolumeGroupWrapKey);
        for (SMEKey wrapKey : wrapKeys) {
            TapeVolumeGroupStatusEnum volumeGroupStatus;
            String tapeGroupName = wrapKey.getData().getKey_Entity().getTape_Volume_Group_Wrap_Key().getTape_BackupGroup_Name();
            String tapeVolumeGroupName = wrapKey.getData().getKey_Entity().getTape_Volume_Group_Wrap_Key().getTape_VolumeGroup_Name();
            SMEKeyStatusEnum status = wrapKey.getData().getStatus();
            if (status == SMEKeyStatusEnum.SME___KEY___ACTIVE) {
                volumeGroupStatus = TapeVolumeGroupStatusEnum.Active;
                tapeGroupStatus = TapeGroupStatusEnum.Active;
            } else {
                volumeGroupStatus = TapeVolumeGroupStatusEnum.Archived;
            }
            ret = this.tapeGroupBean.addTapeGroup(clusterName, tapeGroupName, tapeGroupStatus);
            if (ret.getStatus() == OperationStatusEnum.Success) {
                ret = this.tapeGroupBean.addTapeVolumeGroup(clusterName, tapeGroupName, tapeVolumeGroupName, volumeGroupStatus);
                if (ret.getStatus() == OperationStatusEnum.Success) continue;
                _Logger.warn((Object)("SYNC - Update Tape Volume Group Failed for cluster " + clusterName + " Tape Group " + tapeGroupName + " Tape Volume Group " + tapeVolumeGroupName + " Error: " + ret.getDescription()));
                continue;
            }
            _Logger.warn((Object)("SYNC - Update Tape Group Failed for cluster " + clusterName + " Tape Group " + tapeGroupName + " Error: " + ret.getDescription()));
        }
        _Logger.info((Object)("SYNC - Update Tape Group Successful for cluster " + clusterName));
    }
}

