/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.facade.impl;

import com.cisco.dcbu.sm.common.registry.EjbRegistry;
import com.cisco.dcbu.sme.ckmc.ejb.api.CKMCMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ClusterMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.DiskGroupMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.KeyMgrFacade;
import com.cisco.dcbu.sme.ckmc.ejb.api.OfflineKeyMgrCKMC;
import com.cisco.dcbu.sme.ckmc.ejb.api.RKCRelationshipMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.ReplicationMgr;
import com.cisco.dcbu.sme.ckmc.ejb.api.TapeGroupMgrCKMC;
import com.cisco.dcbu.sme.ckmc.facade.api.CKMCFacade;
import com.cisco.dcbu.sme.comm.service.CKMCMgrMMBean;
import com.cisco.dcbu.sme.common.ClusterInfo;
import com.cisco.dcbu.sme.common.ClusterLockEnum;
import com.cisco.dcbu.sme.common.ClusterRecoveryShareInfo;
import com.cisco.dcbu.sme.common.ClusterSmartcardInfo;
import com.cisco.dcbu.sme.common.ClusterTypeEnum;
import com.cisco.dcbu.sme.common.DiskGroupImport;
import com.cisco.dcbu.sme.common.DiskGroupInfo;
import com.cisco.dcbu.sme.common.DiskInfo;
import com.cisco.dcbu.sme.common.FilterInfo;
import com.cisco.dcbu.sme.common.ImportObject;
import com.cisco.dcbu.sme.common.KMCStatusEnum;
import com.cisco.dcbu.sme.common.KeyInfo;
import com.cisco.dcbu.sme.common.KeyTypeEnum;
import com.cisco.dcbu.sme.common.MasterkeyRekeyInfo;
import com.cisco.dcbu.sme.common.OperationStatus;
import com.cisco.dcbu.sme.common.OperationStatusEnum;
import com.cisco.dcbu.sme.common.RKCFilterInfo;
import com.cisco.dcbu.sme.common.RKCRelationshipInfo;
import com.cisco.dcbu.sme.common.RKCRelationshipMapInfo;
import com.cisco.dcbu.sme.common.SMEContext;
import com.cisco.dcbu.sme.common.TapeGroupInfo;
import com.cisco.dcbu.sme.common.TapeVolumeGroupInfo;
import com.cisco.dcbu.sme.common.TapeVolumes;
import com.cisco.dcbu.sme.exception.SMEException;
import com.cisco.dcbu.sme.replication.SMEReplicationContext;
import com.cisco.dcbu.sme.replication.SMEReplicationRelationship;
import com.cisco.dcbu.sme.tree.ClusterTreeNode;
import com.cisco.dcbu.sme.tree.DiskGroupTreeNode;
import com.cisco.dcbu.sme.tree.DiskTreeNode;
import com.cisco.dcbu.sme.tree.TapeGroupTreeNode;
import com.cisco.dcbu.sme.tree.TapeVolumeGroupTreeNode;
import com.cisco.dcbu.sme.xml.SMEKey;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.TransactionTimeout;

@Stateless
@Remote(value={CKMCFacade.class})
public class CKMCFacadeBean
implements CKMCFacade {
    private ClusterMgrCKMC clusterMgrCKMCBean;
    private TapeGroupMgrCKMC tapeGroupMgrCKMCBean;
    private DiskGroupMgrCKMC diskGroupMgrCKMCBean;
    private OfflineKeyMgrCKMC offlineKeyMgrCKMCBean;
    private CKMCMgr mgrCKMCBean;
    private KeyMgrFacade keyMgrBean;
    private ReplicationMgr replicationMgrBean;
    private RKCRelationshipMgr rkcMgrBean;
    static Logger _Logger = Logger.getLogger((String)"KMC");

    @EJB
    public void setClusterMgrCKMCBean(ClusterMgrCKMC clusterMgrCKMCBean) {
        this.clusterMgrCKMCBean = clusterMgrCKMCBean;
    }

    @EJB
    public void setTapeGroupMgrCKMCBean(TapeGroupMgrCKMC tapeGroupMgrCKMCBean) {
        this.tapeGroupMgrCKMCBean = tapeGroupMgrCKMCBean;
    }

    @EJB
    public void setDiskGroupMgrCKMCBean(DiskGroupMgrCKMC diskGroupMgrCKMCBean) {
        this.diskGroupMgrCKMCBean = diskGroupMgrCKMCBean;
    }

    @EJB
    public void setOfflineKeyMgrCKMCBean(OfflineKeyMgrCKMC offlineKeyMgrCKMCBean) {
        this.offlineKeyMgrCKMCBean = offlineKeyMgrCKMCBean;
    }

    @EJB
    public void setMgrCkmcBean(CKMCMgr mgrCKMCBean) {
        this.mgrCKMCBean = mgrCKMCBean;
    }

    @EJB
    public void setKeyMgrBean(KeyMgrFacade keyMgrBean) {
        this.keyMgrBean = keyMgrBean;
    }

    @EJB
    public void setReplicationMgrBean(ReplicationMgr replicationMgrBean) {
        this.replicationMgrBean = replicationMgrBean;
    }

    @EJB
    public void setRKCRelationshipMgrBean(RKCRelationshipMgr rkcMgrBean) {
        this.rkcMgrBean = rkcMgrBean;
    }

    @Override
    public OperationStatus restartKMC() {
        return this.mgrCKMCBean.restartKMC();
    }

    @Override
    public KMCStatusEnum getNonSecureKMCStatus() {
        return this.mgrCKMCBean.getNonSecureKMCStatus();
    }

    @Override
    public KMCStatusEnum getSecureKMCStatus() {
        return this.mgrCKMCBean.getSecureKMCStatus();
    }

    @Override
    public KMCStatusEnum getKMCStatus(String kmcIPAddr) {
        CKMCFacade peerKMC = this.getPeerCKMCBean(kmcIPAddr);
        if (peerKMC != null) {
            KMCStatusEnum secureStatus = peerKMC.getSecureKMCStatus();
            KMCStatusEnum nonSecureStatus = peerKMC.getNonSecureKMCStatus();
            if (secureStatus == KMCStatusEnum.Running || nonSecureStatus == KMCStatusEnum.Running) {
                return KMCStatusEnum.Running;
            }
            return KMCStatusEnum.Stopped;
        }
        return KMCStatusEnum.None;
    }

    @Override
    public boolean isKMCPrimary(String kmcIPAddr) {
        boolean status = false;
        CKMCFacade peerKMC = this.getPeerCKMCBean(kmcIPAddr);
        if (peerKMC != null) {
            status = peerKMC.isKMCPrimary();
        }
        return status;
    }

    @Override
    public boolean isKMCSecure(String kmcIPAddr) {
        boolean status = false;
        CKMCFacade peerKMC = this.getPeerCKMCBean(kmcIPAddr);
        if (peerKMC != null) {
            status = peerKMC.isKMCSecure();
        }
        return status;
    }

    @Override
    public String getPeerKMC(String kmcIPAddr) {
        String peerKMCAddr = null;
        CKMCFacade peerKMC = this.getPeerCKMCBean(kmcIPAddr);
        if (peerKMC != null) {
            peerKMCAddr = peerKMC.getPeerKMC();
        }
        return peerKMCAddr;
    }

    @Override
    public boolean isKMCPrimary() {
        return this.mgrCKMCBean.isKMCPrimary();
    }

    @Override
    public boolean isKMCSecure() {
        return this.mgrCKMCBean.isKMCSecure();
    }

    @Override
    public String getPeerKMC() {
        return this.mgrCKMCBean.getPeerKMC();
    }

    @Override
    public String getPrimaryKMCServer() {
        return this.mgrCKMCBean.getPrimaryKMCServer();
    }

    @Override
    public String getSecondaryKMCServer() {
        return this.mgrCKMCBean.getSecondaryKMCServer();
    }

    @Override
    public OperationStatus setPrimaryKMCServer(String primaryKMCIPAddr) {
        return this.mgrCKMCBean.setPrimaryKMCServer(primaryKMCIPAddr);
    }

    @Override
    public OperationStatus setSecondaryKMCServer(String secondaryKMCIPAddr) {
        return this.mgrCKMCBean.setSecondaryKMCServer(secondaryKMCIPAddr);
    }

    @Override
    public SMEKey assembleMasterkey(ArrayList<ClusterRecoveryShareInfo> recoveryShares, int recoveryThreshold) throws SMEException {
        return this.offlineKeyMgrCKMCBean.assembleMasterkey(recoveryShares, recoveryThreshold);
    }

    @Override
    public SMEKey unwrapPasswordKey(SMEKey sourceKey, String password) throws SMEException {
        return this.offlineKeyMgrCKMCBean.unwrapPasswordKey(sourceKey, password);
    }

    public boolean checkKeyClusterId(SMEKey key, String clusterId) {
        return this.keyMgrBean.checkKeyClusterId(key, clusterId);
    }

    public HashMap<String, SMEKey> getWrapKeysbyEntity(TapeVolumeGroupInfo tapeVolumeGroup) {
        return this.keyMgrBean.getWrapKeysbyEntity(tapeVolumeGroup);
    }

    public ArrayList<SMEKey> getMediaKeyListbyEntity(TapeVolumeGroupInfo tapeVolumeGroup) {
        return this.keyMgrBean.getMediaKeyListbyEntity(tapeVolumeGroup);
    }

    @Override
    public OperationStatus deleteTapeGroup(SMEContext ctx, String clusterName, String tapeGroupName) {
        return this.tapeGroupMgrCKMCBean.deleteTapeGroup(ctx, clusterName, tapeGroupName);
    }

    @Override
    public OperationStatus deleteTapeVolumeGroup(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        return this.tapeGroupMgrCKMCBean.deleteTapeVolumeGroup(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
    }

    @Override
    public byte[] doExport(SMEContext ctx, String clusterId, TapeVolumeGroupInfo tapeVolumeGroup, String password) throws SMEException {
        return this.tapeGroupMgrCKMCBean.doExport(ctx, clusterId, tapeVolumeGroup, password);
    }

    @Override
    public byte[] doExportFilter(SMEContext ctx, String clusterId, TapeVolumeGroupInfo tapeVolumeGroup, String password, FilterInfo filter) throws SMEException {
        return this.tapeGroupMgrCKMCBean.doExportFilter(ctx, clusterId, tapeVolumeGroup, password, filter);
    }

    @Override
    public byte[] doExportFilter(SMEContext ctx, String clusterId, TapeVolumeGroupInfo tapeVolumeGroup, String password, SMEKey masterKey, FilterInfo filter) throws SMEException {
        return this.tapeGroupMgrCKMCBean.doExportFilter(ctx, clusterId, tapeVolumeGroup, password, masterKey, filter);
    }

    @Override
    public byte[] doExport(SMEContext ctx, String clusterId, TapeVolumeGroupInfo tapeVolumeGroup, String password, SMEKey masterKey) throws SMEException {
        return this.tapeGroupMgrCKMCBean.doExport(ctx, clusterId, tapeVolumeGroup, password, masterKey);
    }

    @Override
    public String getCurrentMasterKeyGuid(TapeVolumeGroupInfo tapeVolumeGroup) {
        return this.tapeGroupMgrCKMCBean.getCurrentMasterKeyGuid(tapeVolumeGroup);
    }

    @Override
    public ArrayList<String> getMasterKeyGuids(TapeVolumeGroupInfo tapeVolumeGroup) {
        return this.tapeGroupMgrCKMCBean.getMasterKeyGuids(tapeVolumeGroup);
    }

    @Override
    public ArrayList<TapeGroupInfo> getTapeGroupInfoList(String clusterName, ArrayList<TapeGroupInfo> ignoreTapeGroups) {
        return this.tapeGroupMgrCKMCBean.getTapeGroupInfoList(clusterName, ignoreTapeGroups);
    }

    @Override
    public ArrayList<TapeGroupTreeNode> getTapeGroupTreeNodes(SMEContext ctx, ArrayList<TapeGroupTreeNode> ignoreTapeGroups) {
        return this.tapeGroupMgrCKMCBean.getTapeGroupTreeNodes(ctx, ignoreTapeGroups);
    }

    @Override
    public ArrayList<TapeVolumeGroupInfo> getTapeVolumeGroupInfoList(String clusterName, String tapeGroupName, ArrayList<TapeVolumeGroupInfo> ignoreVolumeGroups) {
        return this.tapeGroupMgrCKMCBean.getTapeVolumeGroupInfoList(clusterName, tapeGroupName, ignoreVolumeGroups);
    }

    @Override
    public ArrayList<KeyInfo> getTapeVolumeGroupKeyList(SMEContext ctx, String clusterName, String tapeGroupName, String volumeGroupName) {
        return this.tapeGroupMgrCKMCBean.getTapeVolumeGroupKeyList(ctx, clusterName, tapeGroupName, volumeGroupName);
    }

    @Override
    public TapeVolumes getTapeVolumeInfoList(SMEContext ctx, String clusterName, String tapeGroupName, String volumeGroupName) {
        return this.tapeGroupMgrCKMCBean.getTapeVolumeInfoList(ctx, clusterName, tapeGroupName, volumeGroupName);
    }

    @Override
    public ArrayList<TapeVolumeGroupTreeNode> getVolumeGroupTreeNodes(TapeGroupTreeNode tg, ArrayList<TapeVolumeGroupTreeNode> ignoreTapeVolumeGroups) {
        return this.tapeGroupMgrCKMCBean.getVolumeGroupTreeNodes(tg, ignoreTapeVolumeGroups);
    }

    @Override
    public OperationStatus deleteActiveTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode, String guid) {
        return this.tapeGroupMgrCKMCBean.deleteActiveTapeVolume(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, barCode, guid);
    }

    @Override
    public OperationStatus purgeActiveTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode, String guid) {
        return this.tapeGroupMgrCKMCBean.purgeActiveTapeVolume(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, barCode, guid);
    }

    @Override
    public OperationStatus purgeArchivedTapeVolume(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String barCode, String guid) {
        return this.tapeGroupMgrCKMCBean.purgeArchivedTapeVolume(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, barCode, guid);
    }

    @Override
    public OperationStatus purgeTapeVolumeGroupKey(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName, String guid) {
        return this.tapeGroupMgrCKMCBean.purgeTapeVolumeGroupKey(ctx, clusterName, tapeGroupName, tapeVolumeGroupName, guid);
    }

    @Override
    public OperationStatus doImport(SMEContext ctx, TapeVolumeGroupInfo tapeVolumeGroup, ImportObject importObject, String password) {
        return this.tapeGroupMgrCKMCBean.doImport(ctx, tapeVolumeGroup, importObject, password);
    }

    @Override
    public OperationStatus createReplicationRelationship(SMEContext ctx, TapeVolumeGroupInfo source, TapeVolumeGroupInfo destination) {
        return this.tapeGroupMgrCKMCBean.createReplicationRelationship(ctx, source, destination);
    }

    @Override
    public OperationStatus deleteReplicationRelationship(SMEContext ctx, TapeVolumeGroupInfo source, TapeVolumeGroupInfo destination) {
        return this.tapeGroupMgrCKMCBean.deleteReplicationRelationship(ctx, source, destination);
    }

    @Override
    public ArrayList<SMEReplicationRelationship> getReplicationRelationships(TapeVolumeGroupInfo source) {
        return this.tapeGroupMgrCKMCBean.getReplicationRelationships(source);
    }

    @Override
    public int getCountTapeKeysWrappedByGUID(SMEContext ctx, String entityIndexWC, String wrapGuid) {
        return this.tapeGroupMgrCKMCBean.getCountTapeKeysWrappedByGUID(ctx, entityIndexWC, wrapGuid);
    }

    @Override
    public ArrayList<KeyInfo> getTapeKeysWrappedByGUID(SMEContext ctx, String entityIndexWC, String wrapGuid) {
        return this.tapeGroupMgrCKMCBean.getTapeKeysWrappedByGUID(ctx, entityIndexWC, wrapGuid);
    }

    @Override
    public OperationStatus addClusterAttributes(ClusterInfo clusterInfo) {
        return this.clusterMgrCKMCBean.addClusterAttributes(clusterInfo);
    }

    @Override
    public OperationStatus setClusterLock(String clusterName, ClusterLockEnum lockState) {
        return this.clusterMgrCKMCBean.setClusterLock(clusterName, lockState);
    }

    @Override
    public OperationStatus deleteCluster(SMEContext ctx, String clusterName) {
        OperationStatus ret = new OperationStatus();
        ret.set(OperationStatusEnum.Success, "Cluster deleted");
        ClusterInfo ci = this.clusterMgrCKMCBean.getClusterInfo(clusterName);
        if (ci != null) {
            ret = ClusterTypeEnum.Tape.equals((Object)ci.getType()) ? this.tapeGroupMgrCKMCBean.deleteTapeGroupsByCluster(ctx, clusterName) : this.diskGroupMgrCKMCBean.deleteDiskGroupsByCluster(ctx, clusterName);
        }
        ret = this.clusterMgrCKMCBean.deleteCluster(ctx, clusterName);
        return ret;
    }

    @Override
    public OperationStatus archiveCluster(SMEContext ctx, String clusterName) {
        OperationStatus ret = this.clusterMgrCKMCBean.archiveCluster(ctx, clusterName);
        if (ret.getStatus() == OperationStatusEnum.Success) {
            _Logger.info((Object)("Cluster " + clusterName + " marked deactivated in KMC."));
            ArrayList<SMEKey> masterKeys = this.keyMgrBean.getKeysbyExactEntity(clusterName, KeyTypeEnum.MasterKey);
            for (SMEKey key : masterKeys) {
                SimpleDateFormat formatter = new SimpleDateFormat("E MMM d HH:mm:ss z yyyy", Locale.ENGLISH);
                String archivalDate = formatter.format(new Date());
                OperationStatus ret1 = this.keyMgrBean.archiveKey(ctx, clusterName, key.getIndex().getGUID(), archivalDate);
                if (ret.getStatus() == OperationStatusEnum.Success) continue;
                _Logger.info((Object)("Failed to deactivate master key " + key.getIndex().getGUID() + " for cluster " + clusterName));
                ret.set(OperationStatusEnum.Failure, ret.getDescription() + ret1.getDescription());
            }
        }
        return ret;
    }

    @Override
    public ClusterInfo getClusterInfo(String clusterName) {
        return this.clusterMgrCKMCBean.getClusterInfo(clusterName);
    }

    @Override
    public ArrayList<ClusterSmartcardInfo> getClusterSmarcardInfo(String clusterName, String masterKeyGuid) {
        return this.clusterMgrCKMCBean.getClusterSmarcardInfo(clusterName, masterKeyGuid);
    }

    @Override
    public ArrayList<ClusterTreeNode> getClusterTreeNodes(SMEContext ctx, ArrayList<ClusterTreeNode> onlineClusters) {
        return this.clusterMgrCKMCBean.getClusterTreeNodes(ctx, onlineClusters);
    }

    @Override
    public OperationStatus updateSmartcard(String userName, ClusterRecoveryShareInfo shareInfo) {
        return this.clusterMgrCKMCBean.updateSmartcard(userName, shareInfo);
    }

    @Override
    public OperationStatus cloneVolumeGroupKeys(SMEContext ctx, String masterKeyGuid, String currentMasterKeyGuid) {
        return this.tapeGroupMgrCKMCBean.cloneVolumeGroupKeys(ctx, masterKeyGuid, currentMasterKeyGuid);
    }

    private CKMCFacade getPeerCKMCBean(String ipAddr) {
        boolean _useSsl = Boolean.getBoolean("server.useSsl");
        String port = System.getProperty("server.port", "4447");
        CKMCFacade ckmcBean = null;
        try {
            ckmcBean = this.getPeerCKMCBean(ipAddr, port, _useSsl);
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation connecting to " + ipAddr + ":" + port), (Throwable)e);
        }
        return ckmcBean;
    }

    private CKMCFacade getPeerCKMCBean(String ipAddr, String port, boolean _useSsl) throws Exception {
        try {
            return (CKMCFacade)EjbRegistry.getInstance().getRemoteService(ipAddr, port, _useSsl, "CKMCFacadeBean", CKMCFacade.class.getName());
        }
        catch (Exception e) {
            _Logger.error((Object)("Error looking up Key Manager implementation connecting to " + ipAddr + ":" + port), (Throwable)e);
            return null;
        }
    }

    @Override
    public OperationStatus deleteDestReplicationRelationship(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        return this.tapeGroupMgrCKMCBean.deleteDestReplicationRelationship(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
    }

    @Override
    public OperationStatus deleteSrcReplicationRelationship(SMEContext ctx, String clusterName, String tapeGroupName, String tapeVolumeGroupName) {
        return this.tapeGroupMgrCKMCBean.deleteSrcReplicationRelationship(ctx, clusterName, tapeGroupName, tapeVolumeGroupName);
    }

    @Override
    public SMEKey exportReplicatedKey(SMEContext ctx, String guid, SMEReplicationContext replicationCtx, SMEReplicationRelationship relation, int attempt) {
        return this.replicationMgrBean.exportReplicatedKey(ctx, guid, replicationCtx, relation, attempt);
    }

    @Override
    public SMEReplicationContext getReplicationContext(SMEContext ctx, String clusterName, int attempt) {
        return this.replicationMgrBean.getReplicationContext(ctx, clusterName, attempt);
    }

    @Override
    public OperationStatus importReplicatedKey(SMEContext ctx, SMEKey key, SMEReplicationContext replicationCtx, SMEReplicationRelationship relation) {
        return this.replicationMgrBean.importReplicatedKey(ctx, key, replicationCtx, relation);
    }

    @Override
    public void removeReplicationContext(SMEReplicationContext context) {
        this.replicationMgrBean.removeReplicationContext(context);
    }

    @Override
    public boolean isClusterConnected(String clusterName) {
        CKMCMgrMMBean ckmc = null;
        Object ckmcwi = null;
        ObjectName obj = null;
        try {
            obj = new ObjectName("sme:service=CKMCManager");
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ckmc = MBeanServerInvocationHandler.newProxyInstance(server, obj, CKMCMgrMMBean.class, false);
            if (ckmc != null) {
                return ckmc.isClusterConnected(clusterName);
            }
            return false;
        }
        catch (Exception e) {
            _Logger.warn((Object)("Failed to communicate with master switch for cluster" + clusterName));
            return false;
        }
    }

    @Override
    public ArrayList<KeyInfo> getActiveDiskKeysWrappedByGUID(SMEContext ctx, String entityIndexWC, String wrapGuid) {
        return this.diskGroupMgrCKMCBean.getActiveDiskKeysWrappedByGUID(ctx, entityIndexWC, wrapGuid);
    }

    @Override
    public ArrayList<KeyInfo> getDiskKeysWrappedByGUID(SMEContext ctx, String entityIndexWC, String wrapGuid) {
        return this.diskGroupMgrCKMCBean.getDiskKeysWrappedByGUID(ctx, entityIndexWC, wrapGuid);
    }

    @Override
    public KeyInfo cloneDiskKey(SMEContext ctx, KeyInfo importKey, String wrapGUID) {
        return this.diskGroupMgrCKMCBean.cloneDiskKey(ctx, importKey, wrapGUID);
    }

    @Override
    public MasterkeyRekeyInfo cloneArchivedDiskKeys(SMEContext ctx, MasterkeyRekeyInfo stateMgr) {
        return this.diskGroupMgrCKMCBean.cloneArchivedDiskKeys(ctx, stateMgr);
    }

    @Override
    public OperationStatus deleteDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupMgrCKMCBean.purgeDisk(ctx, clusterName, diskGroupName, diskName);
    }

    @Override
    public OperationStatus deleteDiskGroup(SMEContext ctx, String clusterName, String diskGroupName) {
        return this.diskGroupMgrCKMCBean.deleteDiskGroup(ctx, clusterName, diskGroupName);
    }

    @Override
    @TransactionTimeout(value=7200L)
    public byte[] doExport(SMEContext ctx, String clusterId, ArrayList<DiskInfo> diskList, String password) throws SMEException {
        return this.diskGroupMgrCKMCBean.doExport(ctx, clusterId, diskList, password);
    }

    @Override
    @TransactionTimeout(value=7200L)
    public byte[] doExport(SMEContext ctx, String clusterId, ArrayList<DiskInfo> diskList, String password, SMEKey masterKey) throws SMEException {
        return this.diskGroupMgrCKMCBean.doExport(ctx, clusterId, diskList, password, masterKey);
    }

    @Override
    @TransactionTimeout(value=7200L)
    public byte[] doExportFilter(SMEContext ctx, String clusterId, ArrayList<DiskInfo> diskList, String password, FilterInfo filter) throws SMEException {
        return this.diskGroupMgrCKMCBean.doExportFilter(ctx, clusterId, diskList, password, filter);
    }

    @Override
    @TransactionTimeout(value=7200L)
    public byte[] doExportFilter(SMEContext ctx, String clusterId, ArrayList<DiskInfo> diskList, String password, SMEKey masterKey, FilterInfo filter) throws SMEException {
        return this.diskGroupMgrCKMCBean.doExportFilter(ctx, clusterId, diskList, password, masterKey, filter);
    }

    @Override
    public OperationStatus doImport(SMEContext ctx, DiskGroupImport importObject, String password, ArrayList<DiskInfo> diskList) {
        return this.diskGroupMgrCKMCBean.doImport(ctx, importObject, password, diskList);
    }

    @Override
    public String getCurrentMasterKeyGuid(DiskInfo disk) {
        return this.diskGroupMgrCKMCBean.getCurrentMasterKeyGuid(disk);
    }

    @Override
    public ArrayList<DiskGroupInfo> getDiskGroupInfoList(String clusterName, ArrayList<DiskGroupInfo> ignoreDiskGroups) {
        return this.diskGroupMgrCKMCBean.getDiskGroupInfoList(clusterName, ignoreDiskGroups);
    }

    @Override
    public ArrayList<DiskGroupTreeNode> getDiskGroupTreeNodes(SMEContext ctx, ArrayList<DiskGroupTreeNode> ignoreDiskGroups) {
        return this.diskGroupMgrCKMCBean.getDiskGroupTreeNodes(ctx, ignoreDiskGroups);
    }

    @Override
    public DiskGroupInfo getDiskGroup(SMEContext ctx, String clusterName, String diskGroupName) {
        return this.diskGroupMgrCKMCBean.getDiskGroup(ctx, clusterName, diskGroupName);
    }

    @Override
    public DiskInfo getDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupMgrCKMCBean.getDisk(ctx, clusterName, diskGroupName, diskName);
    }

    @Override
    public DiskInfo getDisk(SMEContext ctx, String clusterName, String vendor, String product, String device) {
        return this.diskGroupMgrCKMCBean.getDisk(ctx, clusterName, vendor, product, device);
    }

    @Override
    public ArrayList<DiskInfo> getDiskInfoList(String clusterName, String DiskGroupName, ArrayList<DiskInfo> ignoreDisks) {
        return this.diskGroupMgrCKMCBean.getDiskInfoList(clusterName, DiskGroupName, ignoreDisks);
    }

    @Override
    public KeyInfo getActiveDiskKey(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupMgrCKMCBean.getActiveDiskKey(ctx, clusterName, diskGroupName, diskName);
    }

    @Override
    public KeyInfo replicateDiskKey(SMEContext ctx, KeyInfo sourceKey, DiskInfo diskInfo) {
        return this.diskGroupMgrCKMCBean.replicateDiskKey(ctx, sourceKey, diskInfo);
    }

    @Override
    public ArrayList<KeyInfo> getDiskKeyList(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupMgrCKMCBean.getDiskKeyList(ctx, clusterName, diskGroupName, diskName);
    }

    @Override
    public ArrayList<KeyInfo> getDiskGroupDiskKeyList(SMEContext ctx, String clusterName, String diskGroupName) {
        return this.diskGroupMgrCKMCBean.getDiskGroupDiskKeyList(ctx, clusterName, diskGroupName);
    }

    @Override
    public ArrayList<DiskTreeNode> getDiskTreeNodes(DiskGroupTreeNode diskGroup, ArrayList<DiskTreeNode> ignoreDisks) {
        return this.diskGroupMgrCKMCBean.getDiskTreeNodes(diskGroup, ignoreDisks);
    }

    @Override
    public ArrayList<String> getMasterKeyGuids(DiskInfo disk) {
        return this.diskGroupMgrCKMCBean.getMasterKeyGuids(disk);
    }

    @Override
    public OperationStatus archiveDiskKey(SMEContext ctx, String clusterName, String diskGroupName, String diskName, String guid) {
        return this.diskGroupMgrCKMCBean.archiveDiskKey(ctx, clusterName, diskGroupName, diskName, guid);
    }

    @Override
    public OperationStatus purgeDiskKey(SMEContext ctx, String clusterName, String diskGroupName, String diskName, String guid) {
        return this.diskGroupMgrCKMCBean.purgeDiskKey(ctx, clusterName, diskGroupName, diskName, guid);
    }

    @Override
    public OperationStatus createReplicationRelationship(SMEContext ctx, DiskInfo source, DiskInfo destination) {
        return this.diskGroupMgrCKMCBean.createReplicationRelationship(ctx, source, destination);
    }

    @Override
    public OperationStatus deleteReplicationRelationship(SMEContext ctx, DiskInfo source, DiskInfo destination) {
        return this.diskGroupMgrCKMCBean.deleteReplicationRelationship(ctx, source, destination);
    }

    public OperationStatus deleteSrcReplicationRelationshipDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupMgrCKMCBean.deleteSrcReplicationRelationship(ctx, clusterName, diskGroupName, diskName);
    }

    public OperationStatus deleteDestReplicationRelationshipDisk(SMEContext ctx, String clusterName, String diskGroupName, String diskName) {
        return this.diskGroupMgrCKMCBean.deleteDestReplicationRelationship(ctx, clusterName, diskGroupName, diskName);
    }

    @Override
    public ArrayList<SMEReplicationRelationship> getReplicationRelationships(DiskInfo source) {
        return this.diskGroupMgrCKMCBean.getReplicationRelationships(source);
    }

    @Override
    public boolean isValidDiskKey(SMEContext ctx, String clusterName, String guid) {
        return this.diskGroupMgrCKMCBean.isValidDiskKey(ctx, clusterName, guid);
    }

    @Override
    public OperationStatus create(RKCRelationshipInfo relationship) {
        return this.rkcMgrBean.create(relationship);
    }

    @Override
    public OperationStatus delete(RKCRelationshipInfo relationship) {
        return this.rkcMgrBean.delete(relationship);
    }

    @Override
    public OperationStatus modify(RKCRelationshipInfo relationship) {
        return this.rkcMgrBean.modify(relationship);
    }

    @Override
    public OperationStatus switchover(RKCRelationshipInfo relationship) {
        return this.rkcMgrBean.switchover(relationship);
    }

    @Override
    public RKCRelationshipInfo getRKCRelationship(RKCRelationshipInfo relationship) {
        return this.rkcMgrBean.getRKCRelationship(relationship);
    }

    @Override
    public ArrayList<RKCRelationshipInfo> getRKCRelationshipList(ArrayList<RKCFilterInfo> filterList) {
        return this.rkcMgrBean.getRKCRelationshipList(filterList);
    }

    @Override
    public RKCRelationshipMapInfo getRKCRelationshipMap(String cluster, String vendor, String product, String wwn) {
        return this.rkcMgrBean.getRKCRelationshipMap(cluster, vendor, product, wwn);
    }
}

