/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sme.ckmc.security;

import com.cisco.dcbu.sme.exception.SMEUnsupportedValueException;

public class ByteArrayPacker {
    public static int packBytes(byte[] input, int offset, int value, int size) throws SMEUnsupportedValueException {
        switch (size) {
            case 1: {
                if (offset > input.length) {
                    throw new SMEUnsupportedValueException("Offset out of range");
                }
                input[offset] = (byte)(value & 0xFF);
                break;
            }
            case 2: {
                if (offset + 1 > input.length) {
                    throw new SMEUnsupportedValueException("Offset+size out of range");
                }
                input[offset] = (byte)(value >> 8 & 0xFF);
                input[offset + 1] = (byte)(value & 0xFF);
                break;
            }
            case 4: {
                byte tempval;
                if (offset + 3 > input.length) {
                    throw new SMEUnsupportedValueException("Offset+size out of range");
                }
                input[offset + 3] = tempval = (byte)(value & 0xFF);
                input[offset + 2] = tempval = (byte)((value >>= 8) & 0xFF);
                input[offset + 1] = tempval = (byte)((value >>= 8) & 0xFF);
                input[offset] = tempval = (byte)((value >>= 8) & 0xFF);
                break;
            }
            default: {
                throw new SMEUnsupportedValueException("Size " + size + " is not supported");
            }
        }
        return offset + size;
    }

    public static int packBytes(byte[] input, int offset, byte[] data, int dataOffset, int length) {
        for (int i = 0; i < length; ++i) {
            input[offset + i] = data[dataOffset + i];
        }
        return offset + length;
    }
}

